package Acme::CPANAuthors::CPAN::Streaks::WeeklyReleases::Current;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-04-12'; # DATE
our $DIST = 'Acme-CPANAuthorsBundle-CPAN-Streaks'; # DIST
our $VERSION = '20240412.0'; # VERSION

use Acme::CPANAuthors::Register (
    'PERLANCAR' => '',
    'KIMOTO' => '',
    'SKIM' => '',
    'INGY' => '',
    'UTASHIRO' => '',
    'ETHER' => '',
    'WYANT' => '',
    'DJERIUS' => '',
    'BLIAKO' => '',
    'SIDNEY' => '',
    'JDEGUEST' => '',
    'SHLOMIF' => '',
    'BDFOY' => '',
    'HANJE' => '',
    'DAVECROSS' => '',
    'DILLANBH' => '',
    'MIKKOI' => '',
    'WATERKIP' => '',
    'CORION' => '',
    'LEONT' => '',
    'LNATION' => '',
    'NHORNE' => '',
    'TYRRMINAL' => '',
    'BKB' => '',
    'DERF' => '',
    'ETJ' => '',
    'HERNAN' => '',
    'JRM' => '',
    'MEWP' => '',
    'SYP' => '',
    'TIMKA' => '',
    'DROLSKY' => '',
    'GENE' => '',
    'GSG' => '',
    'MATHIAS' => '',
    'ABEVERLEY' => '',
    'ASPOSE' => '',
    'ATRODO' => '',
    'DCHURCH' => '',
    'DDICK' => '',
    'DFE' => '',
    'DWHEELER' => '',
    'FKENTO' => '',
    'HOLLIE' => '',
    'JDASILVA' => '',
    'JMERELO' => '',
    'LEEJO' => '',
    'MAUKE' => '',
    'MBRADSHAW' => '',
    'MELMOTHX' => '',
    'MERKYS' => '',
    'MRUEDA' => '',
    'MYSOCIETY' => '',
    'PHILIPPE' => '',
    'PMQS' => '',
    'REEDFISH' => '',
    'RKAPL' => '',
    'SONGMU' => '',
    'TANIGUCHI' => '',
    'TONYC' => '',
    'TRIZEN' => '',
    'AAHAZRED' => '',
    'AJNN' => '',
    'ARFREITAS' => '',
    'ARISTOTLE' => '',
    'ASPIERS' => '',
    'BRIANDFOY' => '',
    'DANBERR' => '',
    'DRCLAW' => '',
    'EXODIST' => '',
    'FREDERICD' => '',
    'GBROWN' => '',
    'HMBRAND' => '',
    'ISHIGAKI' => '',
    'JAVONET' => '',
    'JIMAVERA' => '',
    'JMATES' => '',
    'JONASBN' => '',
    'LEV' => '',
    'LITCHIE' => '',
    'MJEMMESON' => '',
    'MSTPLBG' => '',
    'OALDERS' => '',
    'OLIVER' => '',
    'PAYJP' => '',
    'PEVANS' => '',
    'PRBRENAN' => '',
    'RRWO' => '',
    'SJQUINNEY' => '',
    'VVELOX' => '',
    'WESM' => '',
);


1;
# ABSTRACT: Authors with ongoing weekly releases streak (do a release every week)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::Streaks::WeeklyReleases::Current - Authors with ongoing weekly releases streak (do a release every week)

=head1 VERSION

This document describes version 20240412.0 of Acme::CPANAuthors::CPAN::Streaks::WeeklyReleases::Current (from Perl distribution Acme-CPANAuthorsBundle-CPAN-Streaks), released on 2024-04-12.

=head1 SYNOPSIS

=head1 DESCRIPTION

Current standings (as of 2024-04-12, produced by L<cpan-streaks>):

  +-----------+-----+------------+-------------+
  | author    | len | start_date | status      |
  +-----------+-----+------------+-------------+
  | PERLANCAR | 503 | 2014-08-24 | ongoing     |
  | KIMOTO    |  12 | 2024-01-21 | ongoing     |
  | SKIM      |  12 | 2024-01-21 | ongoing     |
  | INGY      |   9 | 2024-02-11 | ongoing     |
  | UTASHIRO  |   8 | 2024-02-11 | might-break |
  | ETHER     |   7 | 2024-02-18 | might-break |
  | WYANT     |   7 | 2024-02-18 | might-break |
  | DJERIUS   |   6 | 2024-02-25 | might-break |
  | BLIAKO    |   6 | 2024-03-03 | ongoing     |
  | SIDNEY    |   6 | 2024-03-03 | ongoing     |
  | JDEGUEST  |   5 | 2024-03-10 | ongoing     |
  | SHLOMIF   |   5 | 2024-03-10 | ongoing     |
  | BDFOY     |   4 | 2024-03-17 | ongoing     |
  | HANJE     |   4 | 2024-03-17 | ongoing     |
  | DAVECROSS |   3 | 2024-03-17 | might-break |
  | DILLANBH  |   3 | 2024-03-17 | might-break |
  | MIKKOI    |   3 | 2024-03-17 | might-break |
  | WATERKIP  |   3 | 2024-03-17 | might-break |
  | CORION    |   3 | 2024-03-24 | ongoing     |
  | LEONT     |   3 | 2024-03-24 | ongoing     |
  | LNATION   |   3 | 2024-03-24 | ongoing     |
  | NHORNE    |   3 | 2024-03-24 | ongoing     |
  | TYRRMINAL |   3 | 2024-03-24 | ongoing     |
  | BKB       |   2 | 2024-03-24 | might-break |
  | DERF      |   2 | 2024-03-24 | might-break |
  | ETJ       |   2 | 2024-03-24 | might-break |
  | HERNAN    |   2 | 2024-03-24 | might-break |
  | JRM       |   2 | 2024-03-24 | might-break |
  | MEWP      |   2 | 2024-03-24 | might-break |
  | SYP       |   2 | 2024-03-24 | might-break |
  | TIMKA     |   2 | 2024-03-24 | might-break |
  | DROLSKY   |   2 | 2024-03-31 | ongoing     |
  | GENE      |   2 | 2024-03-31 | ongoing     |
  | GSG       |   2 | 2024-03-31 | ongoing     |
  | MATHIAS   |   2 | 2024-03-31 | ongoing     |
  | ABEVERLEY |   1 | 2024-03-31 | might-break |
  | ASPOSE    |   1 | 2024-03-31 | might-break |
  | ATRODO    |   1 | 2024-03-31 | might-break |
  | DCHURCH   |   1 | 2024-03-31 | might-break |
  | DDICK     |   1 | 2024-03-31 | might-break |
  | DFE       |   1 | 2024-03-31 | might-break |
  | DWHEELER  |   1 | 2024-03-31 | might-break |
  | FKENTO    |   1 | 2024-03-31 | might-break |
  | HOLLIE    |   1 | 2024-03-31 | might-break |
  | JDASILVA  |   1 | 2024-03-31 | might-break |
  | JMERELO   |   1 | 2024-03-31 | might-break |
  | LEEJO     |   1 | 2024-03-31 | might-break |
  | MAUKE     |   1 | 2024-03-31 | might-break |
  | MBRADSHAW |   1 | 2024-03-31 | might-break |
  | MELMOTHX  |   1 | 2024-03-31 | might-break |
  | MERKYS    |   1 | 2024-03-31 | might-break |
  | MRUEDA    |   1 | 2024-03-31 | might-break |
  | MYSOCIETY |   1 | 2024-03-31 | might-break |
  | PHILIPPE  |   1 | 2024-03-31 | might-break |
  | PMQS      |   1 | 2024-03-31 | might-break |
  | REEDFISH  |   1 | 2024-03-31 | might-break |
  | RKAPL     |   1 | 2024-03-31 | might-break |
  | SONGMU    |   1 | 2024-03-31 | might-break |
  | TANIGUCHI |   1 | 2024-03-31 | might-break |
  | TONYC     |   1 | 2024-03-31 | might-break |
  | TRIZEN    |   1 | 2024-03-31 | might-break |
  | AAHAZRED  |   1 | 2024-04-07 | ongoing     |
  | AJNN      |   1 | 2024-04-07 | ongoing     |
  | ARFREITAS |   1 | 2024-04-07 | ongoing     |
  | ARISTOTLE |   1 | 2024-04-07 | ongoing     |
  | ASPIERS   |   1 | 2024-04-07 | ongoing     |
  | BRIANDFOY |   1 | 2024-04-07 | ongoing     |
  | DANBERR   |   1 | 2024-04-07 | ongoing     |
  | DRCLAW    |   1 | 2024-04-07 | ongoing     |
  | EXODIST   |   1 | 2024-04-07 | ongoing     |
  | FREDERICD |   1 | 2024-04-07 | ongoing     |
  | GBROWN    |   1 | 2024-04-07 | ongoing     |
  | HMBRAND   |   1 | 2024-04-07 | ongoing     |
  | ISHIGAKI  |   1 | 2024-04-07 | ongoing     |
  | JAVONET   |   1 | 2024-04-07 | ongoing     |
  | JIMAVERA  |   1 | 2024-04-07 | ongoing     |
  | JMATES    |   1 | 2024-04-07 | ongoing     |
  | JONASBN   |   1 | 2024-04-07 | ongoing     |
  | LEV       |   1 | 2024-04-07 | ongoing     |
  | LITCHIE   |   1 | 2024-04-07 | ongoing     |
  | MJEMMESON |   1 | 2024-04-07 | ongoing     |
  | MSTPLBG   |   1 | 2024-04-07 | ongoing     |
  | OALDERS   |   1 | 2024-04-07 | ongoing     |
  | OLIVER    |   1 | 2024-04-07 | ongoing     |
  | PAYJP     |   1 | 2024-04-07 | ongoing     |
  | PEVANS    |   1 | 2024-04-07 | ongoing     |
  | PRBRENAN  |   1 | 2024-04-07 | ongoing     |
  | RRWO      |   1 | 2024-04-07 | ongoing     |
  | SJQUINNEY |   1 | 2024-04-07 | ongoing     |
  | VVELOX    |   1 | 2024-04-07 | ongoing     |
  | WESM      |   1 | 2024-04-07 | ongoing     |
  +-----------+-----+------------+-------------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SEE ALSO

L<Acme::CPANAuthors>

CPAN Regulars Boards, L<http://cpan.io/board/once-a/>, which as of this writing,
has some input data missing and thus produces some incorrect results.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthorsBundle-CPAN-Streaks>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
