package TableDataRole::Util::CSV;

use 5.010001;
use strict;
use warnings;

use Role::Tiny;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2021-09-28'; # DATE
our $DIST = 'TableDataRoles-Standard'; # DIST
our $VERSION = '0.012'; # VERSION

requires 'get_column_names';
requires 'has_next_item';
requires 'get_next_item';
requires 'reset_iterator';

sub as_csv {
    require Text::CSV_XS;
    my $self = shift;

    $self->{csv_parser} //= Text::CSV_XS->new({binary=>1});
    my $csv = $self->{csv_parser};

    $self->reset_iterator;

    my $res = "";
    $csv->combine($self->get_column_names);
    $res .= $csv->string . "\n";
    while ($self->has_next_item) {
        my $row = $self->get_next_item;
        $csv->combine(@$row);
        $res .= $csv->string . "\n";
    }
    $res;
}

1;
# ABSTRACT: Provide as_csv() and other CSV-related methods

__END__

=pod

=encoding UTF-8

=head1 NAME

TableDataRole::Util::CSV - Provide as_csv() and other CSV-related methods

=head1 VERSION

This document describes version 0.012 of TableDataRole::Util::CSV (from Perl distribution TableDataRoles-Standard), released on 2021-09-28.

=head1 PROVIDED METHODS

=head2 as_csv

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/TableDataRoles-Standard>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-TableDataRoles-Standard>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla plugin and/or Pod::Weaver::Plugin. Any additional steps required
beyond that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=TableDataRoles-Standard>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
