use utf8;

package SemanticWeb::Schema::Review;

# ABSTRACT: A review of an item - for example

use Moo;

extends qw/ SemanticWeb::Schema::CreativeWork /;


use MooX::JSON_LD 'Review';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v14.0.0';


has associated_claim_review => (
    is        => 'rw',
    predicate => '_has_associated_claim_review',
    json_ld   => 'associatedClaimReview',
);



has associated_media_review => (
    is        => 'rw',
    predicate => '_has_associated_media_review',
    json_ld   => 'associatedMediaReview',
);



has associated_review => (
    is        => 'rw',
    predicate => '_has_associated_review',
    json_ld   => 'associatedReview',
);



has item_reviewed => (
    is        => 'rw',
    predicate => '_has_item_reviewed',
    json_ld   => 'itemReviewed',
);



has negative_notes => (
    is        => 'rw',
    predicate => '_has_negative_notes',
    json_ld   => 'negativeNotes',
);



has positive_notes => (
    is        => 'rw',
    predicate => '_has_positive_notes',
    json_ld   => 'positiveNotes',
);



has review_aspect => (
    is        => 'rw',
    predicate => '_has_review_aspect',
    json_ld   => 'reviewAspect',
);



has review_body => (
    is        => 'rw',
    predicate => '_has_review_body',
    json_ld   => 'reviewBody',
);



has review_rating => (
    is        => 'rw',
    predicate => '_has_review_rating',
    json_ld   => 'reviewRating',
);





1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::Review - A review of an item - for example

=head1 VERSION

version v14.0.0

=head1 DESCRIPTION

A review of an item - for example, of a restaurant, movie, or store.

=head1 ATTRIBUTES

=head2 C<associated_claim_review>

C<associatedClaimReview>

An associated L<SemanticWeb::Schema::ClaimReview>, related by specific common content, topic or claim. The expectation is that this property would be most typically used in cases where a single activity is conducting both claim reviews and media reviews, in which case [[relatedMediaReview]] would commonly be used on a L<SemanticWeb::Schema::ClaimReview>, while [[relatedClaimReview]] would be used on L<SemanticWeb::Schema::MediaReview>.

A associated_claim_review should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::Review']>

=back

=head2 C<_has_associated_claim_review>

A predicate for the L</associated_claim_review> attribute.

=head2 C<associated_media_review>

C<associatedMediaReview>

An associated L<SemanticWeb::Schema::MediaReview>, related by specific common content, topic or claim. The expectation is that this property would be most typically used in cases where a single activity is conducting both claim reviews and media reviews, in which case [[relatedMediaReview]] would commonly be used on a L<SemanticWeb::Schema::ClaimReview>, while [[relatedClaimReview]] would be used on L<SemanticWeb::Schema::MediaReview>.

A associated_media_review should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::Review']>

=back

=head2 C<_has_associated_media_review>

A predicate for the L</associated_media_review> attribute.

=head2 C<associated_review>

C<associatedReview>

An associated L<SemanticWeb::Schema::Review>.

A associated_review should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::Review']>

=back

=head2 C<_has_associated_review>

A predicate for the L</associated_review> attribute.

=head2 C<item_reviewed>

C<itemReviewed>

The item that is being reviewed/rated.

A item_reviewed should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::Thing']>

=back

=head2 C<_has_item_reviewed>

A predicate for the L</item_reviewed> attribute.

=head2 C<negative_notes>

C<negativeNotes>

Indicates, in the context of a L<SemanticWeb::Schema::Review> (e.g. framed as 'pro' vs 'con' considerations), negative considerations - either as unstructured text, or a list.

A negative_notes should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::ItemList']>

=item C<InstanceOf['SemanticWeb::Schema::ListItem']>

=item C<InstanceOf['SemanticWeb::Schema::WebContent']>

=item C<Str>

=back

=head2 C<_has_negative_notes>

A predicate for the L</negative_notes> attribute.

=head2 C<positive_notes>

C<positiveNotes>

Indicates, in the context of a L<SemanticWeb::Schema::Review> (e.g. framed as 'pro' vs 'con' considerations), positive considerations - either as unstructured text, or a list.

A positive_notes should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::ItemList']>

=item C<InstanceOf['SemanticWeb::Schema::ListItem']>

=item C<InstanceOf['SemanticWeb::Schema::WebContent']>

=item C<Str>

=back

=head2 C<_has_positive_notes>

A predicate for the L</positive_notes> attribute.

=head2 C<review_aspect>

C<reviewAspect>

This Review or Rating is relevant to this part or facet of the
itemReviewed.

A review_aspect should be one of the following types:

=over

=item C<Str>

=back

=head2 C<_has_review_aspect>

A predicate for the L</review_aspect> attribute.

=head2 C<review_body>

C<reviewBody>

The actual body of the review.

A review_body should be one of the following types:

=over

=item C<Str>

=back

=head2 C<_has_review_body>

A predicate for the L</review_body> attribute.

=head2 C<review_rating>

C<reviewRating>

The rating given in this review. Note that reviews can themselves be rated. The C<reviewRating> applies to rating given by the review. The [[aggregateRating]] property applies to the review itself, as a creative work.

A review_rating should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::Rating']>

=back

=head2 C<_has_review_rating>

A predicate for the L</review_rating> attribute.

=head1 SEE ALSO

L<SemanticWeb::Schema::CreativeWork>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2022 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
