package Acme::CPANAuthors::CPAN::Streaks::MonthlyReleases::Current;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-12-11'; # DATE
our $DIST = 'Acme-CPANAuthorsBundle-CPAN-Streaks'; # DIST
our $VERSION = '20231211.0'; # VERSION

use Acme::CPANAuthors::Register (
    'BINGOS' => '',
    'ETHER' => '',
    'LEEJO' => '',
    'PERLANCAR' => '',
    'PEVANS' => '',
    'UTASHIRO' => '',
    'OALDERS' => '',
    'KIMOTO' => '',
    'OLIVER' => '',
    'SKIM' => '',
    'DERF' => '',
    'JDEGUEST' => '',
    'LEONT' => '',
    'NHORNE' => '',
    'BDFOY' => '',
    'HMBRAND' => '',
    'JIMAVERA' => '',
    'ASPOSE' => '',
    'DJERIUS' => '',
    'JAVONET' => '',
    'DDUMONT' => '',
    'DRCLAW' => '',
    'JV' => '',
    'VVELOX' => '',
    'HANJE' => '',
    'AJNN' => '',
    'DCANTRELL' => '',
    'CORION' => '',
    'PROCH' => '',
    'SISYPHUS' => '',
    'TIMLEGGE' => '',
    'TURNERJW' => '',
    'ABALAMA' => '',
    'NERDVANA' => '',
    'SHLOMIF' => '',
    'CADE' => '',
    'DDICK' => '',
    'LICHTKIND' => '',
    'RAWLEYFOW' => '',
    'BURAK' => '',
    'DROLSKY' => '',
    'GRYPHON' => '',
    'TEAM' => '',
    'WYANT' => '',
    'BLIAKO' => '',
    'CUKEBOT' => '',
    'EXODIST' => '',
    'LNATION' => '',
    'NLNETLABS' => '',
    'YANICK' => '',
    'BPS' => '',
    'PJACKLAM' => '',
    'RKAPL' => '',
    'ZHMYLOVE' => '',
    'DART' => '',
    'FASTLY' => '',
    'FKENTO' => '',
    'JKEENAN' => '',
    'MBRADSHAW' => '',
    'MRUEDA' => '',
    'PRBRENAN' => '',
    'SANKO' => '',
    'SRI' => '',
    'GSG' => '',
    'JGNI' => '',
    'JJATRIA' => '',
    'JMATES' => '',
    'JRM' => '',
    'OETIKER' => '',
    'RRWO' => '',
    'SREZIC' => '',
    'TANIGUCHI' => '',
    'YANGAK' => '',
    'ABELTJE' => '',
    'BIGFOOT' => '',
    'BRAINBUZ' => '',
    'BRTASTIC' => '',
    'CCELSO' => '',
    'DUMB' => '',
    'EINHVERFR' => '',
    'GENE' => '',
    'GIBUS' => '',
    'HOCHSTEN' => '',
    'KAZEBURO' => '',
    'LION' => '',
    'MPOURASG' => '',
    'NALOBIN' => '',
    'NKH' => '',
    'PATJOL' => '',
    'REFECO' => '',
    'RKELSCH' => '',
    'SUKRIA' => '',
    'TODDR' => '',
    'TRIZEN' => '',
    'ZMUGHAL' => '',
    'CGPAN' => '',
    'DCHURCH' => '',
    'DORNER' => '',
    'FELIPE' => '',
    'GDT' => '',
    'ISHIGAKI' => '',
    'JGOMEZ' => '',
    'MIKKOI' => '',
    'OODLER' => '',
    'SHOGO' => '',
    'SIDNEY' => '',
    'TONYC' => '',
    'ARTHAS' => '',
    'ATKACH' => '',
    'AWNCORP' => '',
    'BENNING' => '',
    'BORISD' => '',
    'BORISV' => '',
    'CARELINE' => '',
    'CRORAA' => '',
    'DAMI' => '',
    'DANBERR' => '',
    'DANKOGAI' => '',
    'DAVIDRAAB' => '',
    'DCONWAY' => '',
    'DERIV' => '',
    'DOMM' => '',
    'DTUCKWELL' => '',
    'EHUELS' => '',
    'ETJ' => '',
    'EXIFTOOL' => '',
    'FSEITZ' => '',
    'FSM' => '',
    'GAHAYES' => '',
    'GNUSTAVO' => '',
    'GRAY' => '',
    'GRICHTER' => '',
    'GSB' => '',
    'GWILLIAMS' => '',
    'IKEGAMI' => '',
    'IPINFO' => '',
    'JMASLAK' => '',
    'JOYREX' => '',
    'JSOBRIER' => '',
    'LANCEW' => '',
    'LSKATZ' => '',
    'MAMAWE' => '',
    'MBARBON' => '',
    'MDOOTSON' => '',
    'PIRZYK' => '',
    'PLAIN' => '',
    'PMB' => '',
    'RBAIRWELL' => '',
    'RJBS' => '',
    'ROBM' => '',
    'RSCHUPP' => '',
    'RWF' => '',
    'RWI' => '',
    'SGRAY' => '',
    'SIMCOP' => '',
    'SNEZ' => '',
    'STRAKA' => '',
    'SULLR' => '',
    'SVW' => '',
    'TINITA' => '',
    'TOSHIOITO' => '',
    'TROTH' => '',
    'VIKAS' => '',
    'VOEGELAS' => '',
    'WHOM' => '',
    'WOUTER' => '',
    'XAVIERH' => '',
    'AAHAZRED' => '',
    'ABH' => '',
    'ABRAXXA' => '',
    'AKIYM' => '',
    'CHOROBA' => '',
    'DAKKAR' => '',
    'DVEEDEN' => '',
    'EMUNDALL' => '',
    'FREED' => '',
    'GBROWN' => '',
    'HAKONH' => '',
    'HKOBA' => '',
    'KRAIH' => '',
    'MAUKE' => '',
    'MERKYS' => '',
    'MICHIELB' => '',
    'OVID' => '',
    'PACMAN' => '',
    'PLICEASE' => '',
    'PMPERRY' => '',
    'SBECK' => '',
    'TEODESIAN' => '',
    'TURNSTEP' => '',
    'YTURTLE' => '',
);


1;
# ABSTRACT: Authors with ongoing month releases streak (do a release every month)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::Streaks::MonthlyReleases::Current - Authors with ongoing month releases streak (do a release every month)

=head1 VERSION

This document describes version 20231211.0 of Acme::CPANAuthors::CPAN::Streaks::MonthlyReleases::Current (from Perl distribution Acme-CPANAuthorsBundle-CPAN-Streaks), released on 2023-12-11.

=head1 SYNOPSIS

=head1 DESCRIPTION

Current standings (as of 2023-12-11, produced by L<cpan-streaks>):

  +-----------+-----+------------+-------------+
  | author    | len | start_date | status      |
  +-----------+-----+------------+-------------+
  | BINGOS    | 214 | 2006-03    | ongoing     |
  | ETHER     | 142 | 2012-03    | ongoing     |
  | LEEJO     | 117 | 2014-04    | ongoing     |
  | PERLANCAR | 113 | 2014-08    | ongoing     |
  | PEVANS    |  67 | 2018-06    | ongoing     |
  | UTASHIRO  |  67 | 2018-06    | ongoing     |
  | OALDERS   |  53 | 2019-08    | ongoing     |
  | KIMOTO    |  25 | 2021-12    | ongoing     |
  | OLIVER    |  23 | 2022-02    | ongoing     |
  | SKIM      |  21 | 2022-04    | ongoing     |
  | DERF      |  19 | 2022-06    | ongoing     |
  | JDEGUEST  |  19 | 2022-06    | ongoing     |
  | LEONT     |  14 | 2022-10    | might-break |
  | NHORNE    |  12 | 2022-12    | might-break |
  | BDFOY     |  12 | 2023-01    | ongoing     |
  | HMBRAND   |  11 | 2023-01    | might-break |
  | JIMAVERA  |  11 | 2023-01    | might-break |
  | ASPOSE    |  11 | 2023-02    | ongoing     |
  | DJERIUS   |  10 | 2023-03    | ongoing     |
  | JAVONET   |   9 | 2023-04    | ongoing     |
  | DDUMONT   |   8 | 2023-05    | ongoing     |
  | DRCLAW    |   8 | 2023-05    | ongoing     |
  | JV        |   8 | 2023-05    | ongoing     |
  | VVELOX    |   8 | 2023-05    | ongoing     |
  | HANJE     |   7 | 2023-05    | might-break |
  | AJNN      |   7 | 2023-06    | ongoing     |
  | DCANTRELL |   7 | 2023-06    | ongoing     |
  | CORION    |   6 | 2023-06    | might-break |
  | PROCH     |   6 | 2023-06    | might-break |
  | SISYPHUS  |   6 | 2023-06    | might-break |
  | TIMLEGGE  |   6 | 2023-06    | might-break |
  | TURNERJW  |   6 | 2023-06    | might-break |
  | ABALAMA   |   6 | 2023-07    | ongoing     |
  | NERDVANA  |   6 | 2023-07    | ongoing     |
  | SHLOMIF   |   6 | 2023-07    | ongoing     |
  | CADE      |   5 | 2023-07    | might-break |
  | DDICK     |   5 | 2023-07    | might-break |
  | LICHTKIND |   5 | 2023-07    | might-break |
  | RAWLEYFOW |   5 | 2023-07    | might-break |
  | BURAK     |   5 | 2023-08    | ongoing     |
  | DROLSKY   |   5 | 2023-08    | ongoing     |
  | GRYPHON   |   5 | 2023-08    | ongoing     |
  | TEAM      |   5 | 2023-08    | ongoing     |
  | WYANT     |   5 | 2023-08    | ongoing     |
  | BLIAKO    |   4 | 2023-08    | might-break |
  | CUKEBOT   |   4 | 2023-08    | might-break |
  | EXODIST   |   4 | 2023-08    | might-break |
  | LNATION   |   4 | 2023-08    | might-break |
  | NLNETLABS |   4 | 2023-08    | might-break |
  | YANICK    |   4 | 2023-08    | might-break |
  | BPS       |   4 | 2023-09    | ongoing     |
  | PJACKLAM  |   4 | 2023-09    | ongoing     |
  | RKAPL     |   4 | 2023-09    | ongoing     |
  | ZHMYLOVE  |   4 | 2023-09    | ongoing     |
  | DART      |   3 | 2023-09    | might-break |
  | FASTLY    |   3 | 2023-09    | might-break |
  | FKENTO    |   3 | 2023-09    | might-break |
  | JKEENAN   |   3 | 2023-09    | might-break |
  | MBRADSHAW |   3 | 2023-09    | might-break |
  | MRUEDA    |   3 | 2023-09    | might-break |
  | PRBRENAN  |   3 | 2023-09    | might-break |
  | SANKO     |   3 | 2023-09    | might-break |
  | SRI       |   3 | 2023-09    | might-break |
  | GSG       |   3 | 2023-10    | ongoing     |
  | JGNI      |   3 | 2023-10    | ongoing     |
  | JJATRIA   |   3 | 2023-10    | ongoing     |
  | JMATES    |   3 | 2023-10    | ongoing     |
  | JRM       |   3 | 2023-10    | ongoing     |
  | OETIKER   |   3 | 2023-10    | ongoing     |
  | RRWO      |   3 | 2023-10    | ongoing     |
  | SREZIC    |   3 | 2023-10    | ongoing     |
  | TANIGUCHI |   3 | 2023-10    | ongoing     |
  | YANGAK    |   3 | 2023-10    | ongoing     |
  | ABELTJE   |   2 | 2023-10    | might-break |
  | BIGFOOT   |   2 | 2023-10    | might-break |
  | BRAINBUZ  |   2 | 2023-10    | might-break |
  | BRTASTIC  |   2 | 2023-10    | might-break |
  | CCELSO    |   2 | 2023-10    | might-break |
  | DUMB      |   2 | 2023-10    | might-break |
  | EINHVERFR |   2 | 2023-10    | might-break |
  | GENE      |   2 | 2023-10    | might-break |
  | GIBUS     |   2 | 2023-10    | might-break |
  | HOCHSTEN  |   2 | 2023-10    | might-break |
  | KAZEBURO  |   2 | 2023-10    | might-break |
  | LION      |   2 | 2023-10    | might-break |
  | MPOURASG  |   2 | 2023-10    | might-break |
  | NALOBIN   |   2 | 2023-10    | might-break |
  | NKH       |   2 | 2023-10    | might-break |
  | PATJOL    |   2 | 2023-10    | might-break |
  | REFECO    |   2 | 2023-10    | might-break |
  | RKELSCH   |   2 | 2023-10    | might-break |
  | SUKRIA    |   2 | 2023-10    | might-break |
  | TODDR     |   2 | 2023-10    | might-break |
  | TRIZEN    |   2 | 2023-10    | might-break |
  | ZMUGHAL   |   2 | 2023-10    | might-break |
  | CGPAN     |   2 | 2023-11    | ongoing     |
  | DCHURCH   |   2 | 2023-11    | ongoing     |
  | DORNER    |   2 | 2023-11    | ongoing     |
  | FELIPE    |   2 | 2023-11    | ongoing     |
  | GDT       |   2 | 2023-11    | ongoing     |
  | ISHIGAKI  |   2 | 2023-11    | ongoing     |
  | JGOMEZ    |   2 | 2023-11    | ongoing     |
  | MIKKOI    |   2 | 2023-11    | ongoing     |
  | OODLER    |   2 | 2023-11    | ongoing     |
  | SHOGO     |   2 | 2023-11    | ongoing     |
  | SIDNEY    |   2 | 2023-11    | ongoing     |
  | TONYC     |   2 | 2023-11    | ongoing     |
  | ARTHAS    |   1 | 2023-11    | might-break |
  | ATKACH    |   1 | 2023-11    | might-break |
  | AWNCORP   |   1 | 2023-11    | might-break |
  | BENNING   |   1 | 2023-11    | might-break |
  | BORISD    |   1 | 2023-11    | might-break |
  | BORISV    |   1 | 2023-11    | might-break |
  | CARELINE  |   1 | 2023-11    | might-break |
  | CRORAA    |   1 | 2023-11    | might-break |
  | DAMI      |   1 | 2023-11    | might-break |
  | DANBERR   |   1 | 2023-11    | might-break |
  | DANKOGAI  |   1 | 2023-11    | might-break |
  | DAVIDRAAB |   1 | 2023-11    | might-break |
  | DCONWAY   |   1 | 2023-11    | might-break |
  | DERIV     |   1 | 2023-11    | might-break |
  | DOMM      |   1 | 2023-11    | might-break |
  | DTUCKWELL |   1 | 2023-11    | might-break |
  | EHUELS    |   1 | 2023-11    | might-break |
  | ETJ       |   1 | 2023-11    | might-break |
  | EXIFTOOL  |   1 | 2023-11    | might-break |
  | FSEITZ    |   1 | 2023-11    | might-break |
  | FSM       |   1 | 2023-11    | might-break |
  | GAHAYES   |   1 | 2023-11    | might-break |
  | GNUSTAVO  |   1 | 2023-11    | might-break |
  | GRAY      |   1 | 2023-11    | might-break |
  | GRICHTER  |   1 | 2023-11    | might-break |
  | GSB       |   1 | 2023-11    | might-break |
  | GWILLIAMS |   1 | 2023-11    | might-break |
  | IKEGAMI   |   1 | 2023-11    | might-break |
  | IPINFO    |   1 | 2023-11    | might-break |
  | JMASLAK   |   1 | 2023-11    | might-break |
  | JOYREX    |   1 | 2023-11    | might-break |
  | JSOBRIER  |   1 | 2023-11    | might-break |
  | LANCEW    |   1 | 2023-11    | might-break |
  | LSKATZ    |   1 | 2023-11    | might-break |
  | MAMAWE    |   1 | 2023-11    | might-break |
  | MBARBON   |   1 | 2023-11    | might-break |
  | MDOOTSON  |   1 | 2023-11    | might-break |
  | PIRZYK    |   1 | 2023-11    | might-break |
  | PLAIN     |   1 | 2023-11    | might-break |
  | PMB       |   1 | 2023-11    | might-break |
  | RBAIRWELL |   1 | 2023-11    | might-break |
  | RJBS      |   1 | 2023-11    | might-break |
  | ROBM      |   1 | 2023-11    | might-break |
  | RSCHUPP   |   1 | 2023-11    | might-break |
  | RWF       |   1 | 2023-11    | might-break |
  | RWI       |   1 | 2023-11    | might-break |
  | SGRAY     |   1 | 2023-11    | might-break |
  | SIMCOP    |   1 | 2023-11    | might-break |
  | SNEZ      |   1 | 2023-11    | might-break |
  | STRAKA    |   1 | 2023-11    | might-break |
  | SULLR     |   1 | 2023-11    | might-break |
  | SVW       |   1 | 2023-11    | might-break |
  | TINITA    |   1 | 2023-11    | might-break |
  | TOSHIOITO |   1 | 2023-11    | might-break |
  | TROTH     |   1 | 2023-11    | might-break |
  | VIKAS     |   1 | 2023-11    | might-break |
  | VOEGELAS  |   1 | 2023-11    | might-break |
  | WHOM      |   1 | 2023-11    | might-break |
  | WOUTER    |   1 | 2023-11    | might-break |
  | XAVIERH   |   1 | 2023-11    | might-break |
  | AAHAZRED  |   1 | 2023-12    | ongoing     |
  | ABH       |   1 | 2023-12    | ongoing     |
  | ABRAXXA   |   1 | 2023-12    | ongoing     |
  | AKIYM     |   1 | 2023-12    | ongoing     |
  | CHOROBA   |   1 | 2023-12    | ongoing     |
  | DAKKAR    |   1 | 2023-12    | ongoing     |
  | DVEEDEN   |   1 | 2023-12    | ongoing     |
  | EMUNDALL  |   1 | 2023-12    | ongoing     |
  | FREED     |   1 | 2023-12    | ongoing     |
  | GBROWN    |   1 | 2023-12    | ongoing     |
  | HAKONH    |   1 | 2023-12    | ongoing     |
  | HKOBA     |   1 | 2023-12    | ongoing     |
  | KRAIH     |   1 | 2023-12    | ongoing     |
  | MAUKE     |   1 | 2023-12    | ongoing     |
  | MERKYS    |   1 | 2023-12    | ongoing     |
  | MICHIELB  |   1 | 2023-12    | ongoing     |
  | OVID      |   1 | 2023-12    | ongoing     |
  | PACMAN    |   1 | 2023-12    | ongoing     |
  | PLICEASE  |   1 | 2023-12    | ongoing     |
  | PMPERRY   |   1 | 2023-12    | ongoing     |
  | SBECK     |   1 | 2023-12    | ongoing     |
  | TEODESIAN |   1 | 2023-12    | ongoing     |
  | TURNSTEP  |   1 | 2023-12    | ongoing     |
  | YTURTLE   |   1 | 2023-12    | ongoing     |
  +-----------+-----+------------+-------------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SEE ALSO

L<Acme::CPANAuthors>

CPAN Regulars Boards, L<http://cpan.io/board/once-a/>, which as of this writing,
has some input data missing and thus produces some incorrect results.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthorsBundle-CPAN-Streaks>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
