use strict;
use Config;
use Panda::Install;

my $ivbits = $Config{ivsize}*8;

write_makefile(
    NAME      => 'Panda::Date',
    PREREQ_PM => {'Panda::Export' => 0, 'Panda::XS' => '1.1.0'},
    SRC       => 'src',
    INC       => '-Isrc',
    DEFINE    => $ENV{TEST_FULL} ? '-DTEST_FULL -DTEST_INLINE' : '',
    TYPEMAPS  => ['typemap', "typemap$ivbits"],
    PAYLOAD   => {'zoneinfo' => ''},
    BIN_DEPS  => 'Panda::Lib',
    BIN_SHARE => {
        INCLUDE  => {'src' => '/'},
        TYPEMAPS => {
            'typemap'        => '',
            "typemap$ivbits" => '',
        },
    },
    #OPTIMIZE => '-g',
    #CC => 'clang++',
    #CCFLAGS => '-std=c++11',
);
