package Acme::CPANAuthors::CPAN::Streaks::MonthlyReleases::Current;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-05-06'; # DATE
our $DIST = 'Acme-CPANAuthorsBundle-CPAN-Streaks'; # DIST
our $VERSION = '20240506.0'; # VERSION

use Acme::CPANAuthors::Register (
    'BINGOS' => '',
    'ETHER' => '',
    'LEEJO' => '',
    'PERLANCAR' => '',
    'UTASHIRO' => '',
    'OALDERS' => '',
    'KIMOTO' => '',
    'OLIVER' => '',
    'SKIM' => '',
    'JDEGUEST' => '',
    'DERF' => '',
    'BDFOY' => '',
    'JIMAVERA' => '',
    'ASPOSE' => '',
    'DJERIUS' => '',
    'JV' => '',
    'VVELOX' => '',
    'AJNN' => '',
    'TEAM' => '',
    'WYANT' => '',
    'BPS' => '',
    'RKAPL' => '',
    'SREZIC' => '',
    'JRM' => '',
    'RRWO' => '',
    'DAMI' => '',
    'RJBS' => '',
    'DAVECROSS' => '',
    'KUERBIS' => '',
    'MATHIAS' => '',
    'INGY' => '',
    'DDICK' => '',
    'LEONT' => '',
    'LNATION' => '',
    'SISYPHUS' => '',
    'ARISTOTLE' => '',
    'BKB' => '',
    'ETJ' => '',
    'FREDERICD' => '',
    'MBRADSHAW' => '',
    'NHORNE' => '',
    'GBROWN' => '',
    'MRUEDA' => '',
    'TIMKA' => '',
    'TYRRMINAL' => '',
    'ABRAXXA' => '',
    'BRIANDFOY' => '',
    'DWHEELER' => '',
    'EXODIST' => '',
    'HANJE' => '',
    'HOUSTON' => '',
    'JAVONET' => '',
    'JDDPAUSE' => '',
    'JONASBN' => '',
    'KHEDIN' => '',
    'PLICEASE' => '',
    'PMQS' => '',
    'TANIGUCHI' => '',
    'WATERKIP' => '',
    'DCANTRELL' => '',
    'GRYPHON' => '',
    'JOESUF' => '',
    'NERDVANA' => '',
    'TRIZEN' => '',
    'ATRODO' => '',
    'BLIAKO' => '',
    'BRTASTIC' => '',
    'CORION' => '',
    'DANBERR' => '',
    'DILLANBH' => '',
    'FKENTO' => '',
    'FSM' => '',
    'GENE' => '',
    'HERNAN' => '',
    'JKEENAN' => '',
    'JMATES' => '',
    'MAUKE' => '',
    'MEWP' => '',
    'PEVANS' => '',
    'SHLOMIF' => '',
    'SIDNEY' => '',
    'SYP' => '',
    'YANICK' => '',
    'ARFREITAS' => '',
    'BPSCHUCK' => '',
    'CAPOEIRAB' => '',
    'DRCLAW' => '',
    'GDT' => '',
    'JJATRIA' => '',
    'NLNETLABS' => '',
    'RURBAN' => '',
    'UXYZAB' => '',
    'AAHAZRED' => '',
    'ABALAMA' => '',
    'ABBYPAN' => '',
    'ABELTJE' => '',
    'ABEVERLEY' => '',
    'AMBS' => '',
    'ASPIERS' => '',
    'BIGPRESH' => '',
    'CHEVALIER' => '',
    'CHOROBA' => '',
    'CHROMATIC' => '',
    'CJM' => '',
    'COUDOT' => '',
    'CROMEDOME' => '',
    'DFE' => '',
    'DKECHAG' => '',
    'DROLSKY' => '',
    'DSKOLL' => '',
    'EGOR' => '',
    'EWHEELER' => '',
    'FASTLY' => '',
    'FELIPE' => '',
    'GFRANKS' => '',
    'GIRAFFED' => '',
    'GSG' => '',
    'GWILLIAMS' => '',
    'HIGHTOWE' => '',
    'HMBRAND' => '',
    'HOLLIE' => '',
    'ISHIGAKI' => '',
    'JDASILVA' => '',
    'JFORGET' => '',
    'JKUTEJ' => '',
    'JMERELO' => '',
    'KARASIK' => '',
    'KRYDE' => '',
    'LEV' => '',
    'LITCHIE' => '',
    'LSKATZ' => '',
    'MELMOTHX' => '',
    'MERKYS' => '',
    'MGUBIN' => '',
    'MICHIELB' => '',
    'MJEMMESON' => '',
    'MSTPLBG' => '',
    'MYSOCIETY' => '',
    'NALOBIN' => '',
    'NWCLARK' => '',
    'PAYJP' => '',
    'PHILIPPE' => '',
    'PJCJ' => '',
    'POPEFELIX' => '',
    'PRBRENAN' => '',
    'PREACTION' => '',
    'RAFORG' => '',
    'REEDFISH' => '',
    'RSPIER' => '',
    'SCHUBIGER' => '',
    'SFOBERSKI' => '',
    'SJQUINNEY' => '',
    'SKAJI' => '',
    'SONGMU' => '',
    'SPWHITTON' => '',
    'TEODESIAN' => '',
    'TIMLEGGE' => '',
    'TONYC' => '',
    'TURNERJW' => '',
    'VNEALV' => '',
    'VOJ' => '',
    'WESM' => '',
    'YTURTLE' => '',
    'ZHUMARIN' => '',
    'BWEST' => '',
    'CAVAC' => '',
    'DAGOLDEN' => '',
    'DVEEDEN' => '',
    'EGILES' => '',
    'HAARG' => '',
    'MAMAWE' => '',
    'MJONDET' => '',
    'OLOF' => '',
    'RATCLIFFE' => '',
    'STEFFENW' => '',
);


1;
# ABSTRACT: Authors with ongoing month releases streak (do a release every month)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::Streaks::MonthlyReleases::Current - Authors with ongoing month releases streak (do a release every month)

=head1 VERSION

This document describes version 20240506.0 of Acme::CPANAuthors::CPAN::Streaks::MonthlyReleases::Current (from Perl distribution Acme-CPANAuthorsBundle-CPAN-Streaks), released on 2024-05-06.

=head1 SYNOPSIS

=head1 DESCRIPTION

Current standings (as of 2024-05-06, produced by L<cpan-streaks>):

  +-----------+-----+------------+-------------+
  | author    | len | start_date | status      |
  +-----------+-----+------------+-------------+
  | BINGOS    | 218 | 2006-03    | might-break |
  | ETHER     | 147 | 2012-03    | ongoing     |
  | LEEJO     | 121 | 2014-04    | might-break |
  | PERLANCAR | 118 | 2014-08    | ongoing     |
  | UTASHIRO  |  71 | 2018-06    | might-break |
  | OALDERS   |  57 | 2019-08    | might-break |
  | KIMOTO    |  30 | 2021-12    | ongoing     |
  | OLIVER    |  28 | 2022-02    | ongoing     |
  | SKIM      |  26 | 2022-04    | ongoing     |
  | JDEGUEST  |  24 | 2022-06    | ongoing     |
  | DERF      |  23 | 2022-06    | might-break |
  | BDFOY     |  17 | 2023-01    | ongoing     |
  | JIMAVERA  |  16 | 2023-01    | might-break |
  | ASPOSE    |  15 | 2023-02    | might-break |
  | DJERIUS   |  15 | 2023-03    | ongoing     |
  | JV        |  13 | 2023-05    | ongoing     |
  | VVELOX    |  12 | 2023-05    | might-break |
  | AJNN      |  11 | 2023-06    | might-break |
  | TEAM      |  10 | 2023-08    | ongoing     |
  | WYANT     |  10 | 2023-08    | ongoing     |
  | BPS       |   8 | 2023-09    | might-break |
  | RKAPL     |   8 | 2023-09    | might-break |
  | SREZIC    |   8 | 2023-10    | ongoing     |
  | JRM       |   7 | 2023-10    | might-break |
  | RRWO      |   7 | 2023-10    | might-break |
  | DAMI      |   7 | 2023-11    | ongoing     |
  | RJBS      |   7 | 2023-11    | ongoing     |
  | DAVECROSS |   6 | 2023-12    | ongoing     |
  | KUERBIS   |   6 | 2023-12    | ongoing     |
  | MATHIAS   |   6 | 2023-12    | ongoing     |
  | INGY      |   5 | 2023-12    | might-break |
  | DDICK     |   5 | 2024-01    | ongoing     |
  | LEONT     |   5 | 2024-01    | ongoing     |
  | LNATION   |   5 | 2024-01    | ongoing     |
  | SISYPHUS  |   5 | 2024-01    | ongoing     |
  | ARISTOTLE |   4 | 2024-01    | might-break |
  | BKB       |   4 | 2024-01    | might-break |
  | ETJ       |   4 | 2024-01    | might-break |
  | FREDERICD |   4 | 2024-01    | might-break |
  | MBRADSHAW |   4 | 2024-01    | might-break |
  | NHORNE    |   4 | 2024-01    | might-break |
  | GBROWN    |   4 | 2024-02    | ongoing     |
  | MRUEDA    |   4 | 2024-02    | ongoing     |
  | TIMKA     |   4 | 2024-02    | ongoing     |
  | TYRRMINAL |   4 | 2024-02    | ongoing     |
  | ABRAXXA   |   3 | 2024-02    | might-break |
  | BRIANDFOY |   3 | 2024-02    | might-break |
  | DWHEELER  |   3 | 2024-02    | might-break |
  | EXODIST   |   3 | 2024-02    | might-break |
  | HANJE     |   3 | 2024-02    | might-break |
  | HOUSTON   |   3 | 2024-02    | might-break |
  | JAVONET   |   3 | 2024-02    | might-break |
  | JDDPAUSE  |   3 | 2024-02    | might-break |
  | JONASBN   |   3 | 2024-02    | might-break |
  | KHEDIN    |   3 | 2024-02    | might-break |
  | PLICEASE  |   3 | 2024-02    | might-break |
  | PMQS      |   3 | 2024-02    | might-break |
  | TANIGUCHI |   3 | 2024-02    | might-break |
  | WATERKIP  |   3 | 2024-02    | might-break |
  | DCANTRELL |   3 | 2024-03    | ongoing     |
  | GRYPHON   |   3 | 2024-03    | ongoing     |
  | JOESUF    |   3 | 2024-03    | ongoing     |
  | NERDVANA  |   3 | 2024-03    | ongoing     |
  | TRIZEN    |   3 | 2024-03    | ongoing     |
  | ATRODO    |   2 | 2024-03    | might-break |
  | BLIAKO    |   2 | 2024-03    | might-break |
  | BRTASTIC  |   2 | 2024-03    | might-break |
  | CORION    |   2 | 2024-03    | might-break |
  | DANBERR   |   2 | 2024-03    | might-break |
  | DILLANBH  |   2 | 2024-03    | might-break |
  | FKENTO    |   2 | 2024-03    | might-break |
  | FSM       |   2 | 2024-03    | might-break |
  | GENE      |   2 | 2024-03    | might-break |
  | HERNAN    |   2 | 2024-03    | might-break |
  | JKEENAN   |   2 | 2024-03    | might-break |
  | JMATES    |   2 | 2024-03    | might-break |
  | MAUKE     |   2 | 2024-03    | might-break |
  | MEWP      |   2 | 2024-03    | might-break |
  | PEVANS    |   2 | 2024-03    | might-break |
  | SHLOMIF   |   2 | 2024-03    | might-break |
  | SIDNEY    |   2 | 2024-03    | might-break |
  | SYP       |   2 | 2024-03    | might-break |
  | YANICK    |   2 | 2024-03    | might-break |
  | ARFREITAS |   2 | 2024-04    | ongoing     |
  | BPSCHUCK  |   2 | 2024-04    | ongoing     |
  | CAPOEIRAB |   2 | 2024-04    | ongoing     |
  | DRCLAW    |   2 | 2024-04    | ongoing     |
  | GDT       |   2 | 2024-04    | ongoing     |
  | JJATRIA   |   2 | 2024-04    | ongoing     |
  | NLNETLABS |   2 | 2024-04    | ongoing     |
  | RURBAN    |   2 | 2024-04    | ongoing     |
  | UXYZAB    |   2 | 2024-04    | ongoing     |
  | AAHAZRED  |   1 | 2024-04    | might-break |
  | ABALAMA   |   1 | 2024-04    | might-break |
  | ABBYPAN   |   1 | 2024-04    | might-break |
  | ABELTJE   |   1 | 2024-04    | might-break |
  | ABEVERLEY |   1 | 2024-04    | might-break |
  | AMBS      |   1 | 2024-04    | might-break |
  | ASPIERS   |   1 | 2024-04    | might-break |
  | BIGPRESH  |   1 | 2024-04    | might-break |
  | CHEVALIER |   1 | 2024-04    | might-break |
  | CHOROBA   |   1 | 2024-04    | might-break |
  | CHROMATIC |   1 | 2024-04    | might-break |
  | CJM       |   1 | 2024-04    | might-break |
  | COUDOT    |   1 | 2024-04    | might-break |
  | CROMEDOME |   1 | 2024-04    | might-break |
  | DFE       |   1 | 2024-04    | might-break |
  | DKECHAG   |   1 | 2024-04    | might-break |
  | DROLSKY   |   1 | 2024-04    | might-break |
  | DSKOLL    |   1 | 2024-04    | might-break |
  | EGOR      |   1 | 2024-04    | might-break |
  | EWHEELER  |   1 | 2024-04    | might-break |
  | FASTLY    |   1 | 2024-04    | might-break |
  | FELIPE    |   1 | 2024-04    | might-break |
  | GFRANKS   |   1 | 2024-04    | might-break |
  | GIRAFFED  |   1 | 2024-04    | might-break |
  | GSG       |   1 | 2024-04    | might-break |
  | GWILLIAMS |   1 | 2024-04    | might-break |
  | HIGHTOWE  |   1 | 2024-04    | might-break |
  | HMBRAND   |   1 | 2024-04    | might-break |
  | HOLLIE    |   1 | 2024-04    | might-break |
  | ISHIGAKI  |   1 | 2024-04    | might-break |
  | JDASILVA  |   1 | 2024-04    | might-break |
  | JFORGET   |   1 | 2024-04    | might-break |
  | JKUTEJ    |   1 | 2024-04    | might-break |
  | JMERELO   |   1 | 2024-04    | might-break |
  | KARASIK   |   1 | 2024-04    | might-break |
  | KRYDE     |   1 | 2024-04    | might-break |
  | LEV       |   1 | 2024-04    | might-break |
  | LITCHIE   |   1 | 2024-04    | might-break |
  | LSKATZ    |   1 | 2024-04    | might-break |
  | MELMOTHX  |   1 | 2024-04    | might-break |
  | MERKYS    |   1 | 2024-04    | might-break |
  | MGUBIN    |   1 | 2024-04    | might-break |
  | MICHIELB  |   1 | 2024-04    | might-break |
  | MJEMMESON |   1 | 2024-04    | might-break |
  | MSTPLBG   |   1 | 2024-04    | might-break |
  | MYSOCIETY |   1 | 2024-04    | might-break |
  | NALOBIN   |   1 | 2024-04    | might-break |
  | NWCLARK   |   1 | 2024-04    | might-break |
  | PAYJP     |   1 | 2024-04    | might-break |
  | PHILIPPE  |   1 | 2024-04    | might-break |
  | PJCJ      |   1 | 2024-04    | might-break |
  | POPEFELIX |   1 | 2024-04    | might-break |
  | PRBRENAN  |   1 | 2024-04    | might-break |
  | PREACTION |   1 | 2024-04    | might-break |
  | RAFORG    |   1 | 2024-04    | might-break |
  | REEDFISH  |   1 | 2024-04    | might-break |
  | RSPIER    |   1 | 2024-04    | might-break |
  | SCHUBIGER |   1 | 2024-04    | might-break |
  | SFOBERSKI |   1 | 2024-04    | might-break |
  | SJQUINNEY |   1 | 2024-04    | might-break |
  | SKAJI     |   1 | 2024-04    | might-break |
  | SONGMU    |   1 | 2024-04    | might-break |
  | SPWHITTON |   1 | 2024-04    | might-break |
  | TEODESIAN |   1 | 2024-04    | might-break |
  | TIMLEGGE  |   1 | 2024-04    | might-break |
  | TONYC     |   1 | 2024-04    | might-break |
  | TURNERJW  |   1 | 2024-04    | might-break |
  | VNEALV    |   1 | 2024-04    | might-break |
  | VOJ       |   1 | 2024-04    | might-break |
  | WESM      |   1 | 2024-04    | might-break |
  | YTURTLE   |   1 | 2024-04    | might-break |
  | ZHUMARIN  |   1 | 2024-04    | might-break |
  | BWEST     |   1 | 2024-05    | ongoing     |
  | CAVAC     |   1 | 2024-05    | ongoing     |
  | DAGOLDEN  |   1 | 2024-05    | ongoing     |
  | DVEEDEN   |   1 | 2024-05    | ongoing     |
  | EGILES    |   1 | 2024-05    | ongoing     |
  | HAARG     |   1 | 2024-05    | ongoing     |
  | MAMAWE    |   1 | 2024-05    | ongoing     |
  | MJONDET   |   1 | 2024-05    | ongoing     |
  | OLOF      |   1 | 2024-05    | ongoing     |
  | RATCLIFFE |   1 | 2024-05    | ongoing     |
  | STEFFENW  |   1 | 2024-05    | ongoing     |
  +-----------+-----+------------+-------------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SEE ALSO

L<Acme::CPANAuthors>

CPAN Regulars Boards, L<http://cpan.io/board/once-a/>, which as of this writing,
has some input data missing and thus produces some incorrect results.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthorsBundle-CPAN-Streaks>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
