package Acme::CPANAuthors::CPAN::Streaks::MonthlyNewDistributions::Current;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-04-12'; # DATE
our $DIST = 'Acme-CPANAuthorsBundle-CPAN-Streaks'; # DIST
our $VERSION = '20240412.0'; # VERSION

use Acme::CPANAuthors::Register (
    'PERLANCAR' => '',
    'SKIM' => '',
    'DJERIUS' => '',
    'BRIANDFOY' => '',
    'DAVECROSS' => '',
    'HANJE' => '',
    'ARISTOTLE' => '',
    'CORION' => '',
    'ANTONOV' => '',
    'ARTHAS' => '',
    'ATOY' => '',
    'BLIAKO' => '',
    'BOD' => '',
    'CHRISARG' => '',
    'DERIV' => '',
    'DILLANBH' => '',
    'GENE' => '',
    'GTERMARS' => '',
    'HAUKEX' => '',
    'HAX' => '',
    'HERNAN' => '',
    'JKEENAN' => '',
    'JONASBN' => '',
    'JV' => '',
    'KTAT' => '',
    'MATHIAS' => '',
    'PETDANCE' => '',
    'SIDNEY' => '',
    'TRIZEN' => '',
    'TULAMILI' => '',
    'UTASHIRO' => '',
    'GBROWN' => '',
    'ISHIGAKI' => '',
    'JMATES' => '',
    'LEONT' => '',
    'LNATION' => '',
    'MYSOCIETY' => '',
    'PHILIPPE' => '',
    'TYRRMINAL' => '',
);


1;
# ABSTRACT: Authors with ongoing monthly new distributions streak (release a new distribution every month)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::Streaks::MonthlyNewDistributions::Current - Authors with ongoing monthly new distributions streak (release a new distribution every month)

=head1 VERSION

This document describes version 20240412.0 of Acme::CPANAuthors::CPAN::Streaks::MonthlyNewDistributions::Current (from Perl distribution Acme-CPANAuthorsBundle-CPAN-Streaks), released on 2024-04-12.

=head1 SYNOPSIS

=head1 DESCRIPTION

Current standings (as of 2024-04-12, produced by L<cpan-streaks>):

  +-----------+-----+------------+-------------+
  | author    | len | start_date | status      |
  +-----------+-----+------------+-------------+
  | PERLANCAR | 117 | 2014-08    | ongoing     |
  | SKIM      |  14 | 2023-03    | ongoing     |
  | DJERIUS   |   5 | 2023-12    | ongoing     |
  | BRIANDFOY |   3 | 2024-02    | ongoing     |
  | DAVECROSS |   3 | 2024-02    | ongoing     |
  | HANJE     |   2 | 2024-02    | might-break |
  | ARISTOTLE |   2 | 2024-03    | ongoing     |
  | CORION    |   2 | 2024-03    | ongoing     |
  | ANTONOV   |   1 | 2024-03    | might-break |
  | ARTHAS    |   1 | 2024-03    | might-break |
  | ATOY      |   1 | 2024-03    | might-break |
  | BLIAKO    |   1 | 2024-03    | might-break |
  | BOD       |   1 | 2024-03    | might-break |
  | CHRISARG  |   1 | 2024-03    | might-break |
  | DERIV     |   1 | 2024-03    | might-break |
  | DILLANBH  |   1 | 2024-03    | might-break |
  | GENE      |   1 | 2024-03    | might-break |
  | GTERMARS  |   1 | 2024-03    | might-break |
  | HAUKEX    |   1 | 2024-03    | might-break |
  | HAX       |   1 | 2024-03    | might-break |
  | HERNAN    |   1 | 2024-03    | might-break |
  | JKEENAN   |   1 | 2024-03    | might-break |
  | JONASBN   |   1 | 2024-03    | might-break |
  | JV        |   1 | 2024-03    | might-break |
  | KTAT      |   1 | 2024-03    | might-break |
  | MATHIAS   |   1 | 2024-03    | might-break |
  | PETDANCE  |   1 | 2024-03    | might-break |
  | SIDNEY    |   1 | 2024-03    | might-break |
  | TRIZEN    |   1 | 2024-03    | might-break |
  | TULAMILI  |   1 | 2024-03    | might-break |
  | UTASHIRO  |   1 | 2024-03    | might-break |
  | GBROWN    |   1 | 2024-04    | ongoing     |
  | ISHIGAKI  |   1 | 2024-04    | ongoing     |
  | JMATES    |   1 | 2024-04    | ongoing     |
  | LEONT     |   1 | 2024-04    | ongoing     |
  | LNATION   |   1 | 2024-04    | ongoing     |
  | MYSOCIETY |   1 | 2024-04    | ongoing     |
  | PHILIPPE  |   1 | 2024-04    | ongoing     |
  | TYRRMINAL |   1 | 2024-04    | ongoing     |
  +-----------+-----+------------+-------------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SEE ALSO

L<Acme::CPANAuthors>

CPAN Regulars Boards, L<http://cpan.io/board/once-a/>, which as of this writing,
has some input data missing and thus produces some incorrect results.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthorsBundle-CPAN-Streaks>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
