#ifndef MARPAESLIF_JSONTESTERSTRICTEXTERNAL_H
#define MARPAESLIF_JSONTESTERSTRICTEXTERNAL_H

static const char *grammars =
  "# --------------------------------------------------\n"
  "# Meta settings\n"
  "# --------------------------------------------------\n"
  ":desc              ::= 'Strict JSON Grammar'\n"
  ":default           ::= action => ::shift fallback-encoding => UTF-8 discard-is-fallback => 1\n"
  "\n"
  "# ---------------------------------\n"
  "# Discard unsignificant whitespaces\n"
  "# ---------------------------------\n"
  ":discard           ::= /[\\x{9}\\x{A}\\x{D}\\x{20}]+/\n"
  "\n"
  "# -------------------------------------------------------------------------------------------\n"
  "# Symbols aliases and settings\n"
  "# -------------------------------------------------------------------------------------------\n"
  ":symbol ::= ','                                                     name => COMMA\n"
  ":symbol ::= '{'                                                     name => LBRACKET\n"
  ":symbol ::= '}'                                                     name => RBRACKET\n"
  ":symbol ::= '['                                                     name => LSQUARE\n"
  ":symbol ::= ']'                                                     name => RSQUARE\n"
  ":symbol ::= 'true'                                                  name => TRUE\n"
  ":symbol ::= 'false'                                                 name => FALSE\n"
  ":symbol ::= 'null'                                                  name => NULL\n"
  ":symbol ::= '\"'                                                    name => DQUOTE               pause => after event => :discard[switch]\n"
  ":symbol ::= /\"([^\"\\\\\\x00-\\x1F]*)\"/ -> '$1'                   name => BASIC_STRING         priority => 1\n"
  ":symbol ::= /-?(?:0|[1-9][0-9]*)(?:\\.[0-9]+)?(?:[eE][+-]?[0-9]+)?/ name => NUMBER\n"
  ":symbol ::= /[^\"\\\\\\x00-\\x1F]+/u                                name => UNESCAPED_CHARACTERS\n"
  ":symbol ::= /(?:\\\\[\"\\\\\\/bfnrt])+/                             name => ESCAPED_CHARACTERS\n"
  ":symbol ::= /(?:\\\\u[[:xdigit:]]{4})+/                             name => ESCAPED_UNICODE\n"
  "\n"
  "# ----------\n"
  "# JSON value\n"
  "# ----------\n"
  "value               ::= object\n"
  "                      | array\n"
  "                      | string\n"
  "                      | constant\n"
  "                      | number\n"
  "\n"
  "# -----------\n"
  "# JSON object\n"
  "# -----------\n"
  "object              ::= (-$LBRACKET-) members (-$RBRACKET-)\n"
  "members             ::= member*                                      action         => ::lua->object\n"
  "                                                                     separator      => $COMMA\n"
  "                                                                     proper         => 1\n"
  "                                                                     hide-separator => 1\n"
  "member              ::= string (-':'-) value                         action         => ::row\n"
  "\n"
  "# ----------\n"
  "# JSON Array\n"
  "# ----------\n"
  "array               ::= (-$LSQUARE-) elements (-$RSQUARE-)\n"
  "elements            ::= value*                                       action         => ::row\n"
  "                                                                     separator      => $COMMA\n"
  "                                                                     proper         => 1\n"
  "                                                                     hide-separator => 1\n"
  "\n"
  "# -----------\n"
  "# JSON String\n"
  "# -----------\n"
  "\n"
  "string              ::= $BASIC_STRING\n"
  "                      | $DQUOTE string_parts $DQUOTE                 action         => ::copy[1]\n"
  "                      | $DQUOTE              $DQUOTE                 action         => ::u8\"\" # Empty string\n"
  "string_parts        ::= string_part+                                 action         => ::concat\n"
  "string_part         ::= $UNESCAPED_CHARACTERS\n"
  "                      | $ESCAPED_CHARACTERS action         => ::lua->string_escape_part\n"
  "                      | $ESCAPED_UNICODE    action         => ::lua->string_unicode_part\n"
  "\n"
  "\n"
  "# -------------\n"
  "# JSON constant\n"
  "# -------------\n"
  "constant ::= $TRUE                                                   action         => ::true\n"
  "           | $FALSE                                                  action         => ::false\n"
  "           | $NULL                                                   action         => ::undef\n"
  "\n"
  "# -----------\n"
  "# JSON number\n"
  "# -----------\n"
  "number         ::= $NUMBER                                           action => ::luac->function(number) return tonumber(number) end\n"
  "\n"
  "<luascript>\n"
  "---------------------------------------------------------------\n"
  "-- members ::= member*\n"
  "---------------------------------------------------------------\n"
  "function object(...)\n"
  "  local output = niledtablekv()\n"
  "  local n\n"
  "\n"
  "  for n=1,select('#',...) do\n"
  "    local member = select(n, ...)\n"
  "    output[member[1]] = member[2]\n"
  "  end\n"
  "\n"
  "  return output\n"
  "end\n"
  "\n"
  "---------------------------------------------------------------\n"
  "-- string_part ::= $ESCAPED_CHARACTERS\n"
  "---------------------------------------------------------------\n"
  "function string_escape_part(input)\n"
  "  local c = input:sub(2, 2) -- get second character\n"
  "\n"
  "  if     c == 'b'  then c = '\\b'\n"
  "  elseif c == 'f'  then c = '\\f'\n"
  "  elseif c == 'n'  then c = '\\n'\n"
  "  elseif c == 'r'  then c = '\\r'\n"
  "  elseif c == 't'  then c = '\\t'\n"
  "  end\n"
  "\n"
  "  return c\n"
  "\n"
  "end\n"
  "\n"
  "---------------------------------------------------------------\n"
  "-- string_part ::= $ESCAPED_UNICODE\n"
  "---------------------------------------------------------------\n"
  "function string_unicode_part(input)\n"
  "  local stringtable = {}\n"
  "  local uint32 = {}\n"
  "  local p = 1\n"
  "  local pmax = input:len()\n"
  "\n"
  "  while p <= pmax do\n"
  "    local u = input:sub(p+2, p + 5)\n"
  "    uint32[#uint32+1] = tonumber('0x'..u)\n"
  "    p = p + 6\n"
  "  end\n"
  "\n"
  "  local j = 2\n"
  "  for i = 1, #uint32 do\n"
  "    local u = uint32[i]\n"
  "    if ((j <= #uint32) and (u >= 0xD800) and (u <= 0xDBFF) and (uint32[j] >= 0xDC00) and (uint32[j] <= 0xDFFF)) then\n"
  "      -- Surrogate UTF-16 pair\n"
  "      u = 0x10000 + ((u & 0x3FF) << 10) + (uint32[j] & 0x3FF)\n"
  "      i = i + 1\n"
  "      j = j + 1\n"
  "    end\n"
  "    if ((u >= 0xD800) and (u <= 0xDFFF)) then\n"
  "      u = 0xFFFD -- Replacement character\n"
  "    end\n"
  "    stringtable[#stringtable + 1] = utf8.char(u)\n"
  "  end\n"
  "\n"
  "  return table.concat(stringtable)\n"
  "end\n"
  "</luascript>\n"
  ;

#endif /* MARPAESLIF_JSONTESTERSTRICTEXTERNAL_H */
