package GCC::Builtins;

use 5.006;
use strict;
use warnings;

our $VERSION = '0.02';

our @ISA = (qw/Exporter DynaLoader/);
our %EXPORT_TAGS = ( 'all' => [qw( clz )] );
our @EXPORT_OK   = ( @{ $EXPORT_TAGS{'all'} } );

require DynaLoader;
__PACKAGE__->bootstrap($VERSION);

=pod

=head1 NAME

GCC::Builtins - access GCC compiler builtin functions via XS

=head1 VERSION

Version 0.02

=head1 SYNOPSIS

This module provides Perl access to GCC C compiler
builtin functions.

    use GCC::Builtins qw/:all/;
    # or use GCC::Builtins qw/ ... clz ... /;
    my $leading_zeros = GCC::Builtins::clz(10);


=head1 EXPORT

=over 2

=item * C<unisgned int clz(int n)>

=back

Export tag C<:all> imports all exportable functions.

=head1 SUBROUTINES/METHODS

=head2 C<int clz(unsigned int n)>

It returns the number of leading zeros in the input integer.
It can be used to find the most significant bit turned on
whose (zero-based) index will be the return of this function.

=head1 AUTHOR

Andreas Hadjiprocopis, C<< <bliako ta cpan.org / andreashad2 ta gmail.com> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-gcc-builtins at rt.cpan.org>, or through
the web interface at L<https://rt.cpan.org/NoAuth/ReportBug.html?Queue=GCC-Builtins>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.


=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc GCC::Builtins


You can also look for information at:

=over 4

=item * RT: CPAN's request tracker (report bugs here)

L<https://rt.cpan.org/NoAuth/Bugs.html?Dist=GCC-Builtins>


=item * Review this module at PerlMonks

L<https://www.perlmonks.org/?node_id=21144>

=item * Search CPAN

L<https://metacpan.org/release/GCC-Builtins>

=back


=head1 ACKNOWLEDGEMENTS

=over 2

=item * This module started by this discussion at PerlMonks:

[Most Significant Set Bit | https://perlmonks.org/?node_id=11158279]

=item * Hackers of Free Software.

=item * GNU and the Free Software Foundation, providers of GNU Compiler Collection.

=back

=head1 HUGS

!Almaz!


=head1 LICENSE AND COPYRIGHT

This software is Copyright (c) 2024 by Andreas Hadjiprocopis.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)


=cut

1; # End of GCC::Builtins
