#!/usr/bin/env perl

use strict;
use warnings;

use lib 'blib/lib';

use Test::More;

use File::Temp;
use Cwd;
use FindBin;
use File::Basename;

use Automate::Animate::FFmpeg;

my $curdir = Cwd::abs_path($FindBin::Bin);

my $anim_outfile = 'abc';

my @inpimages = (
	File::Spec->catfile($curdir, 't-data', 'images', 'red.png'),
	File::Spec->catfile($curdir, 't-data', 'images', 'green.png'),
	File::Spec->catfile($curdir, 't-data', 'images', 'blue.png'),
	File::Spec->catfile($curdir, 't-data', 'images', 'yellow.png'),
);
my $aaFF = Automate::Animate::FFmpeg->new();
ok(defined $aaFF, 'Automate::Animate::FFmpeg->new()'." : called and got defined result.") or BAIL_OUT;

is($aaFF->input_pattern('*.png'), 1, 'input_pattern()'." : called and got good result.");
is_deeply(
	{ map { $_ => 1 } @inpimages },
	{ map { $_ => 1 } @{ $aaFF->input_images() } },
	'input_pattern()'." : called and got the images expected."
);
$aaFF->clear_input_images();

is($aaFF->input_pattern('*.png', File::Spec->catdir($curdir, 't-data')), 1, 'input_pattern()'." : called and got good result.");
is_deeply(
	{ map { $_ => 1 } @inpimages },
	{ map { $_ => 1 } @{ $aaFF->input_images() } },
	'input_pattern()'." : called and got the images expected."
);
$aaFF->clear_input_images();

is($aaFF->input_pattern('regex(/\.PNG$/i)', File::Spec->catdir($curdir, 't-data')), 1, 'input_pattern()'." : called and got good result.");
is_deeply(
	{ map { $_ => 1 } @inpimages  },
	{ map { $_ => 1 } @{ $aaFF->input_images() } },
	'input_pattern()'." : called and got the images expected."
);

is($aaFF->input_patterns([
  ['regex(/\.PNG$/i)', File::Spec->catdir($curdir, 't-data')],
  ['regex(/\.JPG$/i)', File::Spec->catdir($curdir, 't-data')],
]), 1, 'input_pattern()'." : called and got good result.");
is_deeply(
	{ map { $_ => 1 } (@inpimages,File::Spec->catfile($curdir, 't-data', 'images', 'green.jpg')) },
	{ map { $_ => 1 } @{ $aaFF->input_images() } },
	'input_pattern()'." : called and got the images expected."
);

# END
done_testing;
