package App::BPOMUtils::Table::FoodAdditive;

use 5.010001;
use strict 'subs', 'vars';
use utf8;
use warnings;
use Log::ger;

use Exporter 'import';
use Perinci::Sub::Gen::AccessTable qw(gen_read_table_func);

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-01-20'; # DATE
our $DIST = 'App-BPOMUtils-Table'; # DIST
our $VERSION = '0.015'; # VERSION

our @EXPORT_OK = qw(
                       bpom_list_food_additives
               );

our %SPEC;

# BEGIN FRAGMENT id=meta-idn_bpom_bahan_tambahan_pangan varname=meta_idn_bpom_bahan_tambahan_pangan
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idn_bpom_bahan_tambahan_pangan/meta.yaml
# src-revision: fd25ff3eacbf391c7b55867c83451edd646fd0ad (Tue Dec 6 23:04:00 2022 +0700)
# generate-date: Fri Jan 20 09:03:12 2023 UTC
# generated-by: update-fragments-in-perl-module
our $meta_idn_bpom_bahan_tambahan_pangan = {
  "fields" => {
    id => {
      "filterable_regex" => "Yes",
      "pos" => 0,
      "schema" => "uint*",
      "sortable" => "Yes",
      "summary" => "ID",
      "summary.alt.lang.id" => "ID",
      "unique" => "Yes",
    },
    name => {
      "filterable_regex" => "Yes",
      "pos" => 1,
      "schema" => "str*",
      "sortable" => "Yes",
      "summary" => "Name",
      "summary.alt.lang.id" => "Nama",
      "unique" => "Yes",
    },
  },
  "pk" => "id",
  "summary" => "Additives in BPOM processed food division",
  "summary.alt.lang.id_ID" => "Bahan tambahan pangan di BPOM pangan olahan",
};
# END FRAGMENT id=meta-idn_bpom_bahan_tambahan_pangan

# BEGIN FRAGMENT id=data-idn_bpom_bahan_tambahan_pangan varname=data_idn_bpom_bahan_tambahan_pangan
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idn_bpom_bahan_tambahan_pangan/data.csv
# src-revision: fd25ff3eacbf391c7b55867c83451edd646fd0ad (Tue Dec 6 23:04:00 2022 +0700)
# generate-date: Fri Jan 20 09:03:12 2023 UTC
# generated-by: update-fragments-in-perl-module
our $data_idn_bpom_bahan_tambahan_pangan = [
  [
    1,
    "a -Amilase dari Aspergillus oryzae, Var (alpha-Amylase from Aspergillus oryzae, var.)",
    "",
  ],
  [2, "Agar-agar (Agar)", ""],
  [3, "Agar-agar (Agar)", ""],
  [4, "Agar-agar (Agar)", ""],
  [5, "Agar-agar (Agar)", ""],
  [6, "Agar-agar (Agar)", ""],
  [7, "Alfa-Siklodekstrin (alpha-Cyclodextrin)", ""],
  [8, "Alfa-Siklodekstrin (alpha-Cyclodextrin)", ""],
  [9, "Amonium Fosfatidat (Ammonium Phosphatide)", ""],
  [
    10,
    "Amonium hidrogen karbonat (Ammonium hydrogen carbonate)",
    "",
  ],
  [
    11,
    "Amonium hidrogen karbonat (Ammonium hydrogen carbonate) ",
    "",
  ],
  [
    12,
    "Amonium hidrogen karbonat (Ammonium hydrogen carbonate)",
    "",
  ],
  [13, "Amonium karbonat (Ammonium carbonate)", ""],
  [14, "Amonium karbonat (Ammonium carbonate)", ""],
  [15, "Amonium karbonat (Ammonium carbonate)", ""],
  [16, "Amonium klorida (Ammonium chloride)", ""],
  [17, "Antosianin (Anthocyanins)", ""],
  [18, "Asam 5- inosinat (5-Inosinic acid)", ""],
  [19, "Asam 5-guanilat (5-Guanylic acid)", ""],
  [20, "Asam adipat (Adipic acid) ", ""],
  [21, "Asam adipat (Adipic acid)", ""],
  [22, "Asam alginat (Alginic acid)", ""],
  [23, "Asam alginat (Alginic acid)", ""],
  [24, "Asam alginat (Alginic acid)", ""],
  [25, "Asam alginat (Alginic acid)", ""],
  [26, "Asam alginat (Alginic acid)", ""],
  [27, "Asam asetat (Acetic acid)", ""],
  [28, "Asam askorbat (Ascorbic acid)", ""],
  [29, "Asam benzoate (Benzoic acid)", ""],
  [30, "Asam eritorbat (Erythorbic acid)", ""],
  [31, "Asam fosfat (Orthophosphoric acid)", ""],
  [32, "Asam fumarat (Fumaric acid)", ""],
  [33, "Asam fumarat (Fumaric acid)", ""],
  [34, "Asam hidroklorida (Hydrochloric acid)", ""],
  [35, "Asam laktat (Lactic acid)", ""],
  [36, "Asam L-glutamat (L-Glutamic acid)", ""],
  [37, "Asam malat (Malic acid)", ""],
  [38, "Asam propionat (Propionic acid)", ""],
  [39, "Asam siklamat (Cyclamic acid)", ""],
  [40, "Asam sitrat (Citric acid)", ""],
  [41, "Asam sorbat (Sorbic acid) ", ""],
  [42, "Asam tartrat (Tartaric acid)", ""],
  [43, "Asesulfam-K (Acesulfame potassium)", ""],
  [44, "Asetil pati oksidasi (Acetylated oxidized starch)", ""],
  [45, "Asetil pati oksidasi (Acetylated oxidized starch)", ""],
  [46, "Asetil pati oksidasi (Acetylated oxidized starch)", ""],
  [47, "Askorbil palmitat (Ascorbyl palmitate)", ""],
  [48, "Askorbil stearat (Ascorbyl stearate)", ""],
  [49, "Aspartam (Aspartame)", ""],
  [50, "Belerang dioksida (Sulphur dioxide)", ""],
  [51, "Besi (II) Glukonat", ""],
  [
    52,
    "Beta-apo-8-karotenal CI. No. 40820 (beta-Apo-8-Carotenal)",
    "",
  ],
  [
    53,
    "Beta-karoten (sayuran) CI. No. 75130 (Carotenes, beta(vegetable))",
    "",
  ],
  [
    54,
    "Beta-karoten (sintetik) CI. No. 40800 (beta-Carotenes, synthetic)",
    "",
  ],
  [
    55,
    "Beta-karoten dari Blakeslea trispora (beta-Carotenes (Blakeslea trispora))",
    "",
  ],
  [56, "Biru berlian FCF CI No. 42090 (Brilliant blue FCF)", ""],
  [57, "Bromelain (Bromelain)", ""],
  [58, "Bromelain (Bromelain)", ""],
  [59, "Bromelain (Bromelain)", ""],
  [
    60,
    "Butil hidrokinon tersier/TBHQ (Tertiary butylhydroquinone)",
    "",
  ],
  [61, "Butil hidroksi anisol/BHA (Butylated hydroxyanisole)", ""],
  [62, "Butil hidroksi toluen/BHT (Butylated hydroxytoluene)", ""],
  [63, "Coklat HT CI. No. 20285 (Brown HT)", ""],
  [64, "d-alfa tokoferol (d-alpha-Tocopherol )", ""],
  [65, "Dekstrin (Dextrins) ", ""],
  [66, "Dekstrin (Dextrins)", ""],
  [67, "Dekstrin (Dextrins) ", ""],
  [68, "Dikalium 5-guanilat (Dipotassium 5- guanylate) ", ""],
  [69, "Dikalium 5-inosinat (Dipotassium 5- inosinate)", ""],
  [70, "Dikalium fosfat (Dipotassium orthophosphate)", ""],
  [71, "Dikalium fosfat (Dipotassium orthophosphate)", ""],
  [72, "Dikalium fosfat (Dipotassium orthophosphate)", ""],
  [73, "Dikalsium difosfat (Dicalcium diphosphate)", ""],
  [74, "Dikalsium difosfat (Dicalcium diphosphate)", ""],
  [75, "Dikalsium difosfat (Dicalcium diphosphate)", ""],
  [76, "Dikalsium fosfat (Dicalcium orthophosphate) ", ""],
  [77, "Dinatrium 5- inosinat (Disodium 5- inosinate)", ""],
  [
    78,
    "Dinatrium 5- ribonukleotida (Disodium 5- ribonucleotides)",
    "",
  ],
  [79, "Dinatrium 5-guanilat (Disodium 5- guanylate)", ""],
  [80, "Dinatrium difosfat (Disodium diphosphate)", ""],
  [81, "Dinatrium difosfat (Disodium diphosphate)", ""],
  [82, "Dinatrium difosfat (Disodium diphosphate)", ""],
  [83, "Dinatrium fosfat (Disodium orthophosphate)", ""],
  [84, "Dinatrium fosfat (Disodium orthophosphate)", ""],
  [85, "Dinatrium fosfat (Disodium orthophosphate)", ""],
  [
    86,
    "Dinatrium monohidrogen sitrat (Disodium monohydrogen citrate)",
    "",
  ],
  [
    87,
    "Dinatrium monohidrogen sitrat (Disodium monohydrogen citrate)",
    "",
  ],
  [
    88,
    "Dinatrium monohidrogen sitrat (Disodium monohydrogen citrate)",
    "",
  ],
  [
    89,
    "Dipati adipat terasetilasi (Acetylated distarch adipate) ",
    "",
  ],
  [
    90,
    "Dipati adipat terasetilasi (Acetylated distarch adipate) ",
    "",
  ],
  [
    91,
    "Dipati adipat terasetilasi (Acetylated distarch adipate) ",
    "",
  ],
  [
    92,
    "Dipati adipat terasetilasi (Acetylated distarch adipate) ",
    "",
  ],
  [93, "Dipati fosfat (Distarch phosphate)", ""],
  [94, "Dipati fosfat (Distarch phosphate)", ""],
  [95, "Dipati fosfat (Distarch phosphate)", ""],
  [96, "Dipati fosfat (Distarch phosphate)", ""],
  [
    97,
    "Dipati fosfat terasetilasi (Acetylated distrarch phosphate)",
    "",
  ],
  [
    98,
    "Dipati fosfat terasetilasi (Acetylated distrarch phosphate)",
    "",
  ],
  [
    99,
    "Dipati fosfat terasetilasi (Acetylated distrarch phosphate)",
    "",
  ],
  [
    100,
    "Dipati fosfat terasetilasi (Acetylated distrarch phosphate)",
    "",
  ],
  [101, "dl-alfa tokoferol (dl-alpha Tocopherol)", ""],
  [
    102,
    "Ekstrak anato CI. No. 75120 (berbasis bixin) (Annatto extracts, bixin based)",
    "",
  ],
  [103, "Ekstrak cochineal No. 75470 (Cochineal extract)", ""],
  [
    104,
    "Ekstrak Luo Han Guo (berasal dari buah Siraitia grosvenorii) atau Monk Fruit Extract",
    "Pemanis",
  ],
  [105, "Ekstrak Quillaila", ""],
  [106, "Ekstrak Ragi (Yeast Extract)", ""],
  [107, "Ekstrak Rosemari (Rosemary Extract)", "Antioksidan"],
  [108, "Eritritol (Erythritol)", ""],
  [109, "Eritrosin CI. No. 45430 (Erythrosine)", ""],
  [
    110,
    "Ester asam lemak dan asetat dari gliserol (Acetic and fatty acid esters of glycerol)",
    "",
  ],
  [
    111,
    "Ester asam lemak dan asetat dari gliserol (Acetic and fatty acid esters of glycerol)",
    "",
  ],
  [
    112,
    "Ester asam lemak dan asetat dari gliserol (Acetic and fatty acid esters of glycerol)",
    "",
  ],
  [
    113,
    "Ester asam lemak dan diasetiltartrat dari gliserol (Diacetyltaric and fatty acid esters of glycerol)",
    "",
  ],
  [
    114,
    "Ester asam lemak dan diasetiltartrat dari gliserol (Diacetyltaric and fattya acid esters of glycerol)",
    "",
  ],
  [
    115,
    "Ester asam lemak dan diasetiltartrat dari gliserol (Diacetyltartaric and fatty acid esters of glycerol)",
    "",
  ],
  [
    116,
    "Ester asam lemak dan laktat dari gliserol (Lactic and fatty acid esters of glycerol)",
    "",
  ],
  [
    117,
    "Ester asam lemak dan laktat dari gliserol (Lactic and fatty acid esters of glycerol)",
    "",
  ],
  [
    118,
    "Ester asam lemak dan laktat dari gliserol (Lactic and fatty acid esters of glycerol)",
    "",
  ],
  [
    119,
    "Ester asam lemak dan sitrat dari gliserol (Citric and fatty acid esters of glycerol)",
    "",
  ],
  [
    120,
    "Ester asam lemak dan sitrat dari gliserol (Citric and fatty acid esters of glycerol)",
    "",
  ],
  [
    121,
    "Ester asam lemak dan sitrat dari gliserol (Citric and fatty acid esters of glycerol)",
    "",
  ],
  [
    122,
    "Ester gliserol resin kayu (Glycerol ester of wood Rosin)",
    "",
  ],
  [
    123,
    "Ester gliserol resin kayu (Glycerol ester of wood rosin)",
    "",
  ],
  [
    124,
    "Ester gliserol resin kayu (Glycerol ester of wood rosin)",
    "",
  ],
  [
    125,
    "Ester gliserol resin kayu (Glycerol ester of wood Rosin)",
    "",
  ],
  [
    126,
    "Ester poligliserol asam lemak (Polyglycerol esters of fatty acids)",
    "",
  ],
  [
    127,
    "Ester poligliserol asam risinoleat terinteresterifikasi (Polyglycerol esters of interesterified ricinoleic acid)",
    "",
  ],
  [
    128,
    "Ester poligliserol asam risinoleat terinteresterifikasi (Polyglycerol esters of interesterified ricinoleic acid)",
    "",
  ],
  [
    129,
    "Ester propilen glikol asam lemak (Propylene glycol esters of fatty acids)",
    "",
  ],
  [
    130,
    "Ester sukrosa asam lemak (Sucrose esters of fatty acids)",
    "",
  ],
  [
    131,
    "Etil ester dari beta-apo-8asam karotenoat CI. No. 40825 (beta-apo-8-Carotenoic acid ethyl ester)",
    "",
  ],
  [132, "Etil metil selulosa (Methyl ethyl cellulose)", ""],
  [133, "Etil metil selulosa (Methyl ethyl cellulose)", ""],
  [134, "Etil metil selulosa (Methyl ethyl cellulose)", ""],
  [135, "Etil metil selulosa (Methyl ethyl cellulose)", ""],
  [
    136,
    "Etil para-hidroksibenzoat (Ethyl para- hydroxybenzoate)",
    "",
  ],
  [137, "Etil selulosa (Ethyl cellulose)", ""],
  [138, "Etil selulosa (Ethyl cellulose)", ""],
  [
    139,
    "Fosfat dipati fosfat (Phosphate distarch phosphates)",
    "",
  ],
  [
    140,
    "Fosfat dipati fosfat (Phosphated distarch phosphate)",
    "",
  ],
  [
    141,
    "Fosfat dipati fosfat (Phosphated distarch phosphates)",
    "",
  ],
  [
    142,
    "Fosfat dipati fosfat (Phosphated distarch phosphates)",
    "",
  ],
  [143, "Gama tokoferol (Gamma Tocopherol)", ""],
  [144, "Gama-Siklodekstrin (gamma-Cyclodextrin)", ""],
  [145, "Gama-Siklodekstrin (gamma-Cyclodextrin)", ""],
  [146, "Gelatin (Edible gelatin)", ""],
  [147, "Gelatin (Edible gelatin)", ""],
  [148, "Gelatin (Edible gelatin)", ""],
  [149, "Gelatin (Edible gelatin)", ""],
  [150, "Gelatin (Edible gelatin)", ""],
  [151, "Glikosida steviol (Steviol glycosides)", ""],
  [152, "Gliserol (Glycerol)", ""],
  [153, "Gliserol (Glycerol)", ""],
  [154, "Gliserol (Glycerol)", ""],
  [155, "Gliserol (Glycerol)", ""],
  [156, "Glukono delta lakton (Glucono delta lactone)", ""],
  [157, "Glukono delta lakton (Glucono delta lactone)", ""],
  [158, "Glukosa oksidase dari Aspergillus niger", ""],
  [159, "Gom arab (Arabic gum)", ""],
  [160, "Gom arab (Arabic gum)", ""],
  [161, "Gom arab (Arabic gum)", ""],
  [162, "Gom arab (Arabic gum)", ""],
  [163, "Gom gatti (Gum ghatti)", ""],
  [164, "Gom gatti (Gum ghatti)", ""],
  [165, "Gom gelan (Gellan gum)", ""],
  [166, "Gom gelan (Gellan gum)", ""],
  [167, "Gom gelan (Gellan gum)", ""],
  [168, "Gom guar (Guar gum)", ""],
  [169, "Gom guar (Guar gum)", ""],
  [170, "Gom guar (Guar gum)", ""],
  [171, "Gom guar (Guar gum)", ""],
  [172, "Gom kacang lokus (Locust bean gum)", ""],
  [173, "Gom kacang lokus (Locust bean gum)", ""],
  [174, "Gom kacang lokus (Locust bean gum)", ""],
  [175, "Gom karaya (Karaya gum)", ""],
  [176, "Gom karaya (Karaya gum)", ""],
  [177, "Gom karaya (Karaya gum)", ""],
  [178, "Gom karaya (Karaya gum)", ""],
  [179, "Gom tara (Tara gum)", ""],
  [180, "Gom tara (Tara gum)", ""],
  [181, "Gom tragakan (Tragacanth gum)", ""],
  [182, "Gom tragakan (Tragacanth gum)", ""],
  [183, "Gom tragakan (Tragacanth gum)", ""],
  [184, "Gom tragakan (Tragacanth gum)", ""],
  [185, "Gom xanthan (Xanthan gum)", ""],
  [186, "Gom xanthan (Xanthan gum)", ""],
  [187, "Gom xanthan (Xanthan gum)", ""],
  [188, "Hemiselulase dari Aspergillus niger", ""],
  [
    189,
    "Hidroksipropil dipati fosfat (Hydroxypropyl distarch phosphate)",
    "",
  ],
  [
    190,
    "Hidroksipropil dipati fosfat (Hydroxypropyl distarch phosphate)",
    "",
  ],
  [
    191,
    "Hidroksipropil dipati fosfat (Hydroxypropyl distarch phosphate)",
    "",
  ],
  [
    192,
    "Hidroksipropil dipati fosfat (Hydroxypropyl distarch phosphate)",
    "",
  ],
  [
    193,
    "Hidroksipropil metil selulosa (Hydroxypropyl methyl cellulose)",
    "",
  ],
  [
    194,
    "Hidroksipropil metil selulosa (Hydroxypropyl methyl cellulose)",
    "",
  ],
  [
    195,
    "Hidroksipropil metil selulosa (Hydroxypropyl methyl cellulose)",
    "",
  ],
  [
    196,
    "Hidroksipropil metil selulosa (Hydroxypropyl methyl cellulose)",
    "",
  ],
  [197, "Hidroksipropil pati (Hydroxypropyl starch)", ""],
  [198, "Hidroksipropil pati (Hydroxypropyl starch)", ""],
  [199, "Hidroksipropil pati (Hydroxypropyl starch)", ""],
  [200, "Hidroksipropil pati (Hydroxypropyl starch)", ""],
  [201, "Hidroksipropil selulosa (Hydroxypropyl cellulose)", ""],
  [202, "Hidroksipropil selulosa (Hydroxypropyl cellulose)", ""],
  [203, "Hidroksipropil selulosa (Hydroxypropyl cellulose)", ""],
  [204, "Hijau FCF CI. No. 42053 (Fast green FCF)", ""],
  [205, "Indigotin CI. No. 73015 (Indigotine)", ""],
  [206, "Isopropil sitrat (Isopropyl citrates)", ""],
  [207, "Kalium adipat (Potassium adipate)", ""],
  [208, "Kalium alginat (Potassium alginate)", ""],
  [209, "Kalium alginat (Potassium alginate) ", ""],
  [210, "Kalium alginat (Potassium alginate) ", ""],
  [211, "Kalium alginat (Potassium alginate) ", ""],
  [212, "Kalium askorbat (Potassium ascorbate)", ""],
  [213, "Kalium benzoat (Potassium benzoate)", ""],
  [214, "Kalium besi (II) sianida (Potassium ferrocyanide)", ""],
  [215, "Kalium bisulfit (Potassium bisulphite)", ""],
  [
    216,
    "Kalium dihidrogen sitrat (Potassium dihydrogen citrate)",
    "",
  ],
  [
    217,
    "Kalium dihidrogen sitrat (Potassium dihydrogen citrate)",
    "",
  ],
  [
    218,
    "Kalium dihidrogen sitrat (Potassium dihydrogen citrate)",
    "",
  ],
  [
    219,
    "Kalium dihidrogen sitrat (Potassium dihydrogen citrate)",
    "",
  ],
  [220, "Kalium glukonat (Potassium gluconate)", ""],
  [
    221,
    "Kalium hidrogen karbonat (Potassium hydrogen carbonate)",
    "",
  ],
  [
    222,
    "Kalium hidrogen karbonat (Potassium hydrogen carbonate) ",
    "",
  ],
  [
    223,
    "Kalium hidrogen karbonat (Potassium hydrogen carbonate) ",
    "",
  ],
  [
    224,
    "Kalium hidrogen tartrat (Potassium hydrogen tartrate)",
    "",
  ],
  [225, "Kalium hidroksida (Potassium hydroxide)", ""],
  [226, "Kalium hidroksida (Potassium hydroxide)", ""],
  [227, "Kalium hidroksida (Potassium hydroxide)", ""],
  [228, "Kalium karbonat (Potassium carbonate)", ""],
  [229, "Kalium karbonat (Potassium carbonates)", ""],
  [230, "Kalium klorida (Potassium chloride)", ""],
  [231, "Kalium klorida (Potassium chloride)", ""],
  [232, "Kalium klorida (Potassium chloride)", ""],
  [233, "Kalium laktat (Potassium lactate)", ""],
  [234, "Kalium laktat (Potassium lactate)", ""],
  [235, "Kalium metabisulfit (Potassium metabisulphite)", ""],
  [236, "Kalium nitrat (Potassium nitrate)", ""],
  [237, "Kalium nitrit (Potassium nitrite) ", ""],
  [238, "Kalium polifosfat (Potassium polyphosphate)", ""],
  [239, "Kalium polifosfat (Potassium polyphosphate)", ""],
  [240, "Kalium polifosfat (Potassium polyphosphate)", ""],
  [241, "Kalium propionat (Potassium propionate) ", ""],
  [242, "Kalium sakarin (Potassium saccharin)", ""],
  [243, "Kalium sorbat (Potassium sorbate)", ""],
  [244, "Kalium sulfat (Potassium sulphate)", ""],
  [245, "Kalium sulfit (Potassium sulphite)", ""],
  [246, "Kalium tripolifosfat (Potassium tripolyphosphate)", ""],
  [247, "Kalium tripolifosfat (Potassium tripolyphosphate)", ""],
  [248, "Kalsium 5- inosinat (Calcium 5- inosinate)", ""],
  [
    249,
    "Kalsium 5- ribonukleotida (Calcium 5- ribonucleotides)",
    "",
  ],
  [250, "Kalsium 5-guanilat (Calcium 5- guanylate) ", ""],
  [251, "Kalsium alginat (Calcium alginate)", ""],
  [252, "Kalsium alginat (Calcium alginate)", ""],
  [253, "Kalsium alginat (Calcium alginate)", ""],
  [254, "Kalsium alginat (Calcium alginate)", ""],
  [255, "Kalsium alginat (Calcium alginate)", ""],
  [256, "Kalsium asetat (Calcium acetate)", ""],
  [257, "Kalsium asetat (Calcium acetate)", ""],
  [258, "Kalsium asetat (Calcium acetate)", ""],
  [259, "Kalsium askorbat (Calcium ascorbate)", ""],
  [260, "Kalsium benzoat (Calcium benzoate )", ""],
  [261, "Kalsium besi (II) sianida (Calcium ferrocyanide)", ""],
  [262, "Kalsium bisulfit (Calcium bisulphite)", ""],
  [263, "Kalsium difosfat (Calcium Dihydrogen Diphosphate)", ""],
  [264, "Kalsium di-L-glutamat (Calsium di-L-glutamate)", ""],
  [
    265,
    "Kalsium dinatrium etilen diamin tetra asetat (Calcium disodium ethylene diamine tetra acetate)",
    "",
  ],
  [266, "Kalsium DL-malat (Calcium DL-malate)", ""],
  [267, "Kalsium fosfat (Calcium phosphates)", ""],
  [268, "Kalsium glukonat (Calcium gluconate)", ""],
  [269, "Kalsium glukonat (Calcium gluconate)", ""],
  [270, "Kalsium hidroksida (Calcium hydroxide)", ""],
  [271, "Kalsium hidroksida (Calcium hydroxide)", ""],
  [272, "Kalsium karbonat (Calcium carbonate)", ""],
  [273, "Kalsium karbonat (Calcium carbonate)", ""],
  [274, "Kalsium karbonat (Calcium carbonate)", ""],
  [275, "Kalsium karbonat (Calcium carbonate)", ""],
  [276, "Kalsium klorida (Calcium chloride)", ""],
  [277, "Kalsium klorida (Calcium chloride)", ""],
  [278, "Kalsium klorida (Calcium chloride)", ""],
  [279, "Kalsium laktat (Calcium lactate)", ""],
  [280, "Kalsium laktat (Calcium lactate)", ""],
  [281, "Kalsium laktat (Calcium lactate)", ""],
  [282, "Kalsium laktat (Calcium lactate)", ""],
  [283, "Kalsium laktat (Calcium lactate)", ""],
  [284, "Kalsium oksida (Calcium oxide)", ""],
  [285, "Kalsium oksida (Calcium oxide)", ""],
  [286, "Kalsium polifosfat (Calcium polyphosphate)", ""],
  [287, "Kalsium polifosfat (Calcium polyphosphates)", ""],
  [288, "Kalsium polifosfat (Calcium polyphosphates)", ""],
  [289, "Kalsium propionat (Calcium propionate) ", ""],
  [290, "Kalsium sakarin (Calcium saccharin)", ""],
  [291, "Kalsium siklamat (Calcium cyclamate)", ""],
  [292, "Kalsium silikat (Calcium silicate)", ""],
  [293, "Kalsium sorbat (Calcium sorbate)", ""],
  [294, "Kalsium sulfat (Calcium sulphate)", ""],
  [295, "Kalsium sulfat (Calcium sulphate)", ""],
  [296, "Kalsium sulfat (Calcium sulphate)", ""],
  [297, "Kalsium sulfat (Calcium sulphate)", ""],
  [298, "Kalsium sulfat (Calcium sulphate)", ""],
  [299, "Kalsium sulfat (Calcium sulphate)", ""],
  [300, "Karagen (Carrageenan)", ""],
  [301, "Karagen (Carrageenan)", ""],
  [302, "Karagen (Carrageenan)", ""],
  [303, "Karagen (Carrageenan)", ""],
  [304, "Karagen (Carrageenan)", ""],
  [305, "Karamel I (Caramel I - plain)", ""],
  [306, "Karamel II", ""],
  [
    307,
    "Karamel III amonia proses (Caramel III - ammonia process)",
    "",
  ],
  [
    308,
    "Karamel IV amonia sulfit proses (Caramel IV - sulphite ammonia process)",
    "",
  ],
  [309, "Karbon dioksida (Carbon dioxide)", ""],
  [310, "Karbon dioksida (Carbon dioxide)", ""],
  [311, "Karbon tanaman CI. 77266 (Vegetable carbon)", ""],
  [312, "Karmin CI. No. 75470 (Carmines) ", ""],
  [313, "Karmoisin CI. No. 14720 (Azorubine (carmoisine))", ""],
  [314, "Karmoisin CI. No. 14720 (carmoisine)", ""],
  [315, "Klorofil CI. No. 75810 (Chlorophyll)", ""],
  [
    316,
    "Klorofil dan klorofilin tembaga kompleks CI. No. 75810 (Chlorophylls and chlorophyllins, copper complexes)",
    "",
  ],
  [
    317,
    "Klorofil tembaga kompleks CI. No. 75810 (Chlorophylls, Copper Complexes)",
    "",
  ],
  [318, "Kuning FCF CI. No. 15985 Sunset yellow FCF", ""],
  [319, "Kuning kuinolin CI. No. 47005 Quinoline yellow", ""],
  [320, "Kurkumin CI. No. 75300 (Curcumin)", ""],
  [321, "Laktitol (Lactitol)", ""],
  [322, "L-amonium laktat (L-ammonium lactate)", ""],
  [323, "L-Amonium laktat (L-Ammonium lactate)", ""],
  [324, "Lesitin (Lecithins)", ""],
  [325, "Lesitin (Lecithins)", ""],
  [326, "Lilin kandelila (Candelilla wax)", ""],
  [327, "Lilin kandelila (Candelilla wax)", ""],
  [328, "Lilin karnauba (Carnauba wax)", ""],
  [329, "Lilin mikrokristalin (Microcrystalline wax)", ""],
  [330, "Lisozim hidroklorida (Lysozyme hydrochloride)", ""],
  [331, "Lutein", ""],
  [332, "Magnesium hidroksida (Magnesium hydroxide)", ""],
  [333, "Magnesium hidroksida (Magnesium hydroxide)", ""],
  [334, "Magnesium hidroksida (Magnesium hydroxide)", ""],
  [335, "Magnesium karbonat (Magnesium carbonate)", ""],
  [336, "Magnesium karbonat (Magnesium carbonate)", ""],
  [337, "Magnesium karbonat (Magnesium carbonate)", ""],
  [338, "Magnesium oksida (Magnesium oxide)", ""],
  [339, "Magnesium silikat (Magnesium silicate)", ""],
  [340, "Malam (Beeswax)", ""],
  [341, "Malam (Beeswax)", ""],
  [342, "Malam (Beeswax)", ""],
  [343, "Manitol (Mannitol)", ""],
  [344, "Merah allura CI. No. 16035 (Allura red)", ""],
  [345, "Merah bit (Beet red)", ""],
  [
    346,
    "Metil para-hidroksibenzoat (Methyl para hydroxybenzoate)",
    "",
  ],
  [347, "Metil selulosa (Methyl cellulosa)", ""],
  [348, "Metil selulosa (Methyl cellulosa)", ""],
  [349, "Metil selulosa (Methyl cellulose)", ""],
  [350, "Metil selulosa (Methyl cellulose)", ""],
  [351, "Minyak Atsiri Paprika (Paprika Oleoresin)", ""],
  [
    352,
    "Mono dan digliserida asam lemak (Mono- and di-glycerides of fatty acids)",
    "",
  ],
  [
    353,
    "Mono dan digliserida asam lemak (Mono- and di-glycerides of fatty acids)",
    "",
  ],
  [
    354,
    "Mono dan digliserida asam lemak (Mono- and di-glycerides of fatty acids)",
    "",
  ],
  [
    355,
    "Mono dan digliserida asam lemak (Mono- and di-glycerides of fatty acids)",
    "",
  ],
  [
    356,
    "Mono dan digliserida asam lemak (Mono- and di-glycerides of fatty acids)",
    "",
  ],
  [357, "Monokalium fosfat (Monopotassium orthophosphate)", ""],
  [358, "Monokalium fosfat (Monopotassium orthophosphate)", ""],
  [359, "Monokalium fosfat (Monopotassium orthophosphate)", ""],
  [360, "Monokalium L-glutamate (Monopotassium L-glutamate)", ""],
  [361, "Monokalsium fosfat (Monocalcium orthophosphate) ", ""],
  [362, "Mononatrium fosfat (Monosodium orthophosphate)", ""],
  [363, "Mononatrium fosfat (Monosodium orthophosphate)", ""],
  [364, "Mononatrium fosfat (Monosodium orthophosphate)", ""],
  [365, "Mononatrium L-glutamate (Monosodium L-glutamate)", ""],
  [366, "Monopati fosfat (Monostarch phosphate)", ""],
  [367, "Monopati fosfat (Monostarch phosphate)", ""],
  [368, "Monopati fosfat (Monostarch phosphate)", ""],
  [369, "Monopati fosfat Mono (starch phosphate)", ""],
  [370, "Natrium malat (Sodium malate)", ""],
  [371, "Natrium adipat (Sodium adipates)", ""],
  [372, "Natrium alginat (Sodium alginate)", ""],
  [373, "Natrium alginat (Sodium alginate)", ""],
  [374, "Natrium alginat (Sodium alginate)", ""],
  [375, "Natrium alginat (Sodium alginate)", ""],
  [376, "Natrium alginat (Sodium alginate)", ""],
  [
    377,
    "Natrium aluminium fosfat (Sodium aluminium phosphates)",
    "",
  ],
  [378, "Natrium aluminosilikat (Sodium aluminosilicate)", ""],
  [379, "Natrium asetat (Sodium acetate)", ""],
  [380, "Natrium askorbat (Sodium ascorbate)", ""],
  [381, "Natrium benzoat (Sodium benzoate)", ""],
  [382, "Natrium besi (II) sianida (Sodium ferrocyanide)", ""],
  [383, "Natrium bisulfit (Sodium bisulphate)", ""],
  [
    384,
    "Natrium dihidrogen sitrat (Sodium dihydrogen citrate)",
    "",
  ],
  [
    385,
    "Natrium dihidrogen sitrat (Sodium dihydrogen citrate)",
    "",
  ],
  [
    386,
    "Natrium dihidrogen sitrat (Sodium dihydrogen citrate)",
    "",
  ],
  [
    387,
    "Natrium dihidrogen sitrat (Sodium dihydrogen citrate)",
    "",
  ],
  [388, "Natrium eritorbat (Sodium erythorbate)", ""],
  [389, "Natrium glukonat (Sodium gluconate)", ""],
  [390, "Natrium glukonat (Sodium gluconate)", ""],
  [
    391,
    "Natrium hidrogen karbonat (Sodium hydrogen carbonate)",
    "",
  ],
  [
    392,
    "Natrium hidrogen karbonat (Sodium hydrogen carbonate) ",
    "",
  ],
  [
    393,
    "Natrium hidrogen karbonat (Sodium hydrogen carbonate) ",
    "",
  ],
  [394, "Natrium hidrogen malat (Sodium hydrogen malate)", ""],
  [395, "Natrium hidrogen malat (Sodium hydrogen malate)", ""],
  [396, "Natrium Hidrogen Sulfat (Sodium Hydrogen Sulphate)", ""],
  [397, "Natrium hidroksida (Sodium hydroxide)", ""],
  [
    398,
    "Natrium kalsium polifosfat (Sodium calcium polyphosphate)",
    "",
  ],
  [
    399,
    "Natrium kalsium polifosfat (Sodium calcium polyphosphate)",
    "",
  ],
  [
    400,
    "Natrium karboksimetil selulosa (Sodium carboxymethyl cellulose)",
    "",
  ],
  [
    401,
    "Natrium karboksimetil selulosa (Sodium carboxymethyl cellulose)",
    "",
  ],
  [
    402,
    "Natrium karboksimetil selulosa (Sodium carboxymethyl cellulose)",
    "",
  ],
  [
    403,
    "Natrium karboksimetil selulosa (Sodium carboxymethyl cellulose)",
    "",
  ],
  [
    404,
    "Natrium karboksimetil selulosa hidrolisa enzim (Sodium carboxymethyl cellulose, enzymatically hydrolysed)",
    "",
  ],
  [
    405,
    "Natrium karboksimetil selulosa hidrolisa enzim (Sodium carboxymethyl cellulose, enzymatically hydrolysed)",
    "",
  ],
  [406, "Natrium karbonat (Sodium carbonate)", ""],
  [407, "Natrium karbonat (Sodium carbonate)", ""],
  [408, "Natrium karbonat (Sodium carbonate)", ""],
  [409, "Natrium karbonat (Sodium carbonate)", ""],
  [410, "Natrium kaseinat (Sodium caseinate)", ""],
  [411, "Natrium kaseinat (Sodium caseinate)", ""],
  [412, "Natrium kaseinat (Sodium caseinate)", ""],
  [413, "Natrium kroskarmelos (Croscarmellose sodium)", ""],
  [414, "Natrium laktat (Sodium lactate)", ""],
  [415, "Natrium laktat (Sodium lactate)", ""],
  [416, "Natrium laktat (Sodium lactate)", ""],
  [417, "Natrium laktat (Sodium lactate)", ""],
  [418, "Natrium laktat (Sodium lactate)", ""],
  [419, "Natrium laktat (Sodium lactate)", ""],
  [420, "Natrium malat (Sodium malate)", ""],
  [421, "Natrium metabisulfit (Sodium metabisulphite)", ""],
  [422, "Natrium nitrat (Sodium nitrate)", ""],
  [423, "Natrium nitrit (Sodium nitrite)", ""],
  [424, "Natrium polifosfat (Sodium polyphosphate)", ""],
  [425, "Natrium polifosfat (Sodium polyphosphate)", ""],
  [426, "Natrium polifosfat (Sodium polyphosphate)", ""],
  [427, "Natrium propionat (Sodium propionate)", ""],
  [428, "Natrium sakarin (Sodium saccharin)", ""],
  [429, "Natrium siklamat (Sodium cyclamate)", ""],
  [430, "Natrium sorbat (Sodium sorbate)", ""],
  [
    431,
    "Natrium stearoil-2-laktilat (Sodium stearoyl-2-lactylate)",
    "",
  ],
  [
    432,
    "Natrium stearoil-2-laktilat (Sodium stearoyl-2-lactylate)",
    "",
  ],
  [433, "Natrium sulfat (Sodium sulphate)", ""],
  [434, "Natrium sulfit (Sodium sulphite )", ""],
  [435, "Natrium tripolifosfat (Sodium Tripolyphosphate)", ""],
  [436, "Natrium tripolifosfat (Sodium Tripolyphosphate)", ""],
  [437, "Neotam (Neotame)", ""],
  [438, "Nisin (Nisin)", ""],
  [439, "Nitrogen (Nitrogen)", ""],
  [440, "Papain (Papain)", ""],
  [441, "Papain (Papain)", ""],
  [442, "Pati asetat (Starch acetate)", ""],
  [443, "Pati asetat (Starch acetate)", ""],
  [444, "Pati asetat (Starch acetate)", ""],
  [445, "Pati asetat (Starch acetate)", ""],
  [446, "Pati modifikasi asam (Acid treated starch)", ""],
  [447, "Pati modifikasi asam (Acid treated starch)", ""],
  [448, "Pati modifikasi asam (Acid treated starch)", ""],
  [449, "Pati modifikasi asam (Acid treated starch)", ""],
  [450, "Pati modifikasi basa (Alkaline treated starch)", ""],
  [451, "Pati modifikasi basa (Alkaline treated starch)", ""],
  [452, "Pati modifikasi basa (Alkaline treated starch)", ""],
  [453, "Pati modifikasi enzim (Enzymed treated starch)", ""],
  [454, "Pati modifikasi enzim (Enzymed treated starch)", ""],
  [455, "Pati modifikasi enzim (Enzymed treated starch)", ""],
  [456, "Pati modifikasi enzim (Enzymed treated starch)", ""],
  [
    457,
    "Pati natrium oktenilsuksinat (Starch sodium octenyl succinate)",
    "",
  ],
  [
    458,
    "Pati natrium oktenilsuksinat (Starch sodium octenyl succinate)",
    "",
  ],
  [
    459,
    "Pati natrium oktenilsuksinat (Starch sodium octenyl succinate)",
    "",
  ],
  [460, "Pati oksidasi (Oxidized starch)", ""],
  [461, "Pati oksidasi (Oxidized starch)", ""],
  [462, "Pati oksidasi (Oxidized starch)", ""],
  [463, "Pati oksidasi (Oxidized starch)", ""],
  [464, "Pati pucat (Bleached starch)", ""],
  [465, "Pati pucat (Bleached starch)", ""],
  [466, "Pati pucat (Bleached starch)", ""],
  [467, "Pati pucat (Bleached starch)", ""],
  [468, "Pektin (Pectins)", ""],
  [469, "Pektin (Pectins)", ""],
  [470, "Pektin (Pectins)", ""],
  [471, "Pektin (Pectins)", ""],
  [472, "Perisa Alami (Natural Flavour)", ""],
  [473, "Perisa Artifisial (Artificial flavour)", ""],
  [474, "Perisa hasil proses panas (Process flavouring)", ""],
  [475, "Perisa Identik Alami (Natural Identical Flavour)", ""],
  [476, "Polidekstrosa (Polydextroses)", ""],
  [477, "Polidekstrosa (Polydextroses)", ""],
  [478, "Polidekstrosa (Polydextroses)", ""],
  [479, "Polidekstrosa (Polydextroses)", ""],
  [480, "Polidekstrosa (Polydextroses)", ""],
  [481, "Polietilen glikol (Polyethylene glycol)", ""],
  [
    482,
    "Polisorbat 20 (Polyoxyethylene (20) sorbitan monolaurate)",
    "",
  ],
  [
    483,
    "Polisorbat 40 (Polyoxyethylene (20) Sorbitan Monopalmitate)",
    "",
  ],
  [
    484,
    "Polisorbat 60 (Polyoxyethylene (20) sorbitan monostearate)",
    "",
  ],
  [
    485,
    "Polisorbat 65 (Polyoxyethylene (20) ssorbitan tristearate)",
    "",
  ],
  [
    486,
    "Polisorbat 80 (Polyoxyethylene (20) sorbitan monooleate)",
    "",
  ],
  [487, "Ponceau 4R CI. No. 16255 (Ponceau 4R)", ""],
  [488, "Propil galat (Propyl gallate)", ""],
  [489, "Propilen glikol (Propylene glycol)", ""],
  [490, "Propilen glikol (Propylene glycole)", ""],
  [491, "Propilen glikol alginat (Propylene glycol alginate)", ""],
  [492, "Propilen glikol alginat (Propylene glycol alginate)", ""],
  [493, "Propilen glikol alginat (Propylene glycol alginate)", ""],
  [494, "Propilen glikol alginat (Propylene glycol alginate)", ""],
  [
    495,
    "Protease dari Aspergillus oryzae, Var. (Protease from Aspergillus oryzae, var)",
    "",
  ],
  [496, "Riboflavin (sintetik) (Riboflavin, synthetic)", ""],
  [
    497,
    "Riboflavin 5- natrium fosfat (Riboflavin 5-phosphate sodium)",
    "",
  ],
  [
    498,
    "Rumput laut eucheuma olahan (Processed eucheuma seaweed)",
    "",
  ],
  [
    499,
    "Rumput laut eucheuma olahan (Processed eucheuma seaweed)",
    "",
  ],
  [
    500,
    "Rumput laut eucheuma olahan (Processed eucheuma seaweed)",
    "",
  ],
  [501, "Sakarin (Saccharin)", ""],
  [502, "Selulosa bubuk (Powdered cellulose)", ""],
  [503, "Selulosa bubuk (Powdered cellulose)", ""],
  [504, "Selulosa bubuk (Powdered cellulose)", ""],
  [505, "Selulosa bubuk (Powdered cellulose)", ""],
  [506, "Selulosa bubuk (Powdered cellulose)", ""],
  [
    507,
    "Selulosa mikrokristalin (Microcrystalline cellulose)",
    "",
  ],
  [
    508,
    "Selulosa mikrokristalin (Microcrystalline cellulose)",
    "",
  ],
  [
    509,
    "Selulosa mikrokristalin (Microcrystalline cellulose)",
    "",
  ],
  [
    510,
    "Selulosa mikrokristalin (Microcrystalline cellulose)",
    "",
  ],
  [
    511,
    "Selulosa mikrokristalin (Microcrystalline cellulose)",
    "",
  ],
  [
    512,
    "Selulosa mikrokristalin (Microcrystalline cellulose)",
    "",
  ],
  [513, "Silikon dioksida halus (Silicon dioxide, amorphous)", ""],
  [514, "Silitol (Xylitol)", ""],
  [515, "Sorbitan monostearat (Sorbitan monostearat) ", ""],
  [516, "Sorbitan tristearat (Sorbitan tristearat)", ""],
  [517, "Sorbitol (Sorbitol)", ""],
  [518, "Sorbitol Sirup (Sorbitol syrup)", ""],
  [519, "Sukralosa (Sucralose/Trichlorogalactosucrose)", ""],
  [
    520,
    "Sukrosa asetat isobutirat (Sucrose acetate isobutyrate)",
    "",
  ],
  [521, "Syelak (Shellac)", ""],
  [522, "Tartrazin CI. No. 19140 (Tartrazine)", ""],
  [523, "Tetrakalium difosfat (Tetrapotassium diphosphate)", ""],
  [524, "Tetrakalium difosfat (Tetrapotassium diphosphate)", ""],
  [525, "Tetrakalium difosfat (Tetrapotassium diphosphate)", ""],
  [526, "Tetranatrium difosfat (Tetrasodium diphosphate)", ""],
  [527, "Tetranatrium difosfat (Tetrasodium diphosphate)", ""],
  [528, "Tetranatrium difosfat (Tetrasodium diphosphate)", ""],
  [529, "Titanium dioksida CI. No. 77891 (Titanium dioxide)", ""],
  [
    530,
    "Tokoferol campuran pekat (Mixed tocopherol concentrate)",
    "",
  ],
  [531, "Triasetin (Triacetin)", ""],
  [532, "Trietil sitrat (Triethyl citrate)", ""],
  [533, "Trietil sitrat (Triethyl citrate)", "Pembawa"],
  [534, "Trikalium fosfat (Tripotassium orthophosphate)", ""],
  [535, "Trikalium fosfat (Tripotassium orthophosphate)", ""],
  [536, "Trikalium fosfat (Tripotassium orthophosphate)", ""],
  [537, "Trikalium sitrat (Tripotassium citrate)", ""],
  [538, "Trikalium sitrat (Tripotassium citrate)", ""],
  [539, "Trikalium sitrat (Tripotassium citrate)", ""],
  [540, "Trikalium sitrat (Tripotassium citrate)", ""],
  [541, "Trikalsium fosfat (Tricalcium orthophosphate) ", ""],
  [542, "Trikalsium fosfat (Tricalcium orthophosphate)", ""],
  [543, "Trikalsium sitrat (Tricalcium citrate)", ""],
  [544, "Trikalsium sitrat (Tricalcium citrate)", ""],
  [545, "Trikalsium sitrat (Tricalcium citrate)", ""],
  [546, "Trinatrium difosfat (Trisodium diphosphate)", ""],
  [547, "Trinatrium difosfat (Trisodium diphosphate)", ""],
  [548, "Trinatrium fosfat (Trisodium orthophosphate)", ""],
  [549, "Trinatrium fosfat (Trisodium orthophosphate)", ""],
  [550, "Trinatrium fosfat (Trisodium orthophosphate)", ""],
  [551, "Trinatrium sitrat (Trisodium citrate)", ""],
  [552, "Trinatrium sitrat (Trisodium citrate)", ""],
  [553, "Trinatrium sitrat (Trisodium citrate)", ""],
  [554, "Trinatrium sitrat (Trisodium citrate)", ""],
  [555, "Xylanase dari Aspergillus niger", "Perlakuan Tepung"],
  [556, "Xylanase dari Aspergillus niger", ""],
];
# END FRAGMENT id=data-idn_bpom_bahan_tambahan_pangan

my $res = gen_read_table_func(
    name => 'bpom_list_food_additives',
    summary => 'List additives in BPOM processed food division',
    table_data => $data_idn_bpom_bahan_tambahan_pangan,
    table_spec => $meta_idn_bpom_bahan_tambahan_pangan,
    description => <<'_',
_
    extra_props => {
        examples => [
            {
                summary => 'Check for additives that contain "dextrin" but do not contain "gamma"',
                src_plang => 'bash',
                src => '[[prog]] -l --format text-pretty -- dextrin -gamma',
                test => 0,
            },
            {
                summary => 'Check for additives that contain "magnesium" or "titanium"',
                src_plang => 'bash',
                src => '[[prog]] -l --format text-pretty --or -- magnesium titanium',
                test => 0,
            },
            {
                summary => 'Check for additives that match some regular expressions',
                src_plang => 'bash',
                src => q{[[prog]] -l --format text-pretty -- /potassium/ '/citrate|phosphate/'},
                test => 0,
            },
        ],
    },
);
die "Can't generate function: $res->[0] - $res->[1]" unless $res->[0] == 200;

1;
# ABSTRACT: List additives in BPOM processed food division

__END__

=pod

=encoding UTF-8

=head1 NAME

App::BPOMUtils::Table::FoodAdditive - List additives in BPOM processed food division

=head1 VERSION

This document describes version 0.015 of App::BPOMUtils::Table::FoodAdditive (from Perl distribution App-BPOMUtils-Table), released on 2023-01-20.

=head1 FUNCTIONS


=head2 bpom_list_food_additives

Usage:

 bpom_list_food_additives(%args) -> [$status_code, $reason, $payload, \%result_meta]

List additives in BPOM processed food division.

This function is not exported by default, but exportable.

Arguments ('*' denotes required arguments):

=over 4

=item * B<detail> => I<bool> (default: 0)

Return array of full records instead of just ID fields.

By default, only the key (ID) field is returned per result entry.

=item * B<exclude_fields> => I<array[str]>

Select fields to return.

=item * B<fields> => I<array[str]>

Select fields to return.

=item * B<id> => I<int>

Only return records where the 'id' field equals specified value.

=item * B<id.in> => I<array[int]>

Only return records where the 'id' field is in the specified values.

=item * B<id.is> => I<int>

Only return records where the 'id' field equals specified value.

=item * B<id.isnt> => I<int>

Only return records where the 'id' field does not equal specified value.

=item * B<id.max> => I<int>

Only return records where the 'id' field is less than or equal to specified value.

=item * B<id.min> => I<int>

Only return records where the 'id' field is greater than or equal to specified value.

=item * B<id.not_in> => I<array[int]>

Only return records where the 'id' field is not in the specified values.

=item * B<id.xmax> => I<int>

Only return records where the 'id' field is less than specified value.

=item * B<id.xmin> => I<int>

Only return records where the 'id' field is greater than specified value.

=item * B<name> => I<str>

Only return records where the 'name' field equals specified value.

=item * B<name.contains> => I<str>

Only return records where the 'name' field contains specified text.

=item * B<name.in> => I<array[str]>

Only return records where the 'name' field is in the specified values.

=item * B<name.is> => I<str>

Only return records where the 'name' field equals specified value.

=item * B<name.isnt> => I<str>

Only return records where the 'name' field does not equal specified value.

=item * B<name.matches> => I<str>

Only return records where the 'name' field matches specified regular expression pattern.

=item * B<name.max> => I<str>

Only return records where the 'name' field is less than or equal to specified value.

=item * B<name.min> => I<str>

Only return records where the 'name' field is greater than or equal to specified value.

=item * B<name.not_contains> => I<str>

Only return records where the 'name' field does not contain specified text.

=item * B<name.not_in> => I<array[str]>

Only return records where the 'name' field is not in the specified values.

=item * B<name.not_matches> => I<str>

Only return records where the 'name' field does not match specified regular expression.

=item * B<name.xmax> => I<str>

Only return records where the 'name' field is less than specified value.

=item * B<name.xmin> => I<str>

Only return records where the 'name' field is greater than specified value.

=item * B<queries> => I<array[str]>

Search.

This will search all searchable fields with one or more specified queries. Each
query can be in the form of C<-FOO> (dash prefix notation) to require that the
fields do not contain specified string, or C</FOO/> to use regular expression.
All queries must match if the C<query_boolean> option is set to C<and>; only one
query should match if the C<query_boolean> option is set to C<or>.

=item * B<query_boolean> => I<str> (default: "and")

Whether records must match all search queries ('and') or just one ('or').

If set to C<and>, all queries must match; if set to C<or>, only one query should
match. See the C<queries> option for more details on searching.

=item * B<random> => I<bool> (default: 0)

Return records in random order.

=item * B<result_limit> => I<int>

Only return a certain number of records.

=item * B<result_start> => I<int> (default: 1)

Only return starting from the n'th record.

=item * B<sort> => I<array[str]>

Order records according to certain field(s).

A list of field names separated by comma. Each field can be prefixed with '-' to
specify descending order instead of the default ascending.

=item * B<with_field_names> => I<bool>

Return field names in each record (as hashE<sol>associative array).

When enabled, function will return each record as hash/associative array
(field name => value pairs). Otherwise, function will return each record
as list/array (field value, field value, ...).


=back

Returns an enveloped result (an array).

First element ($status_code) is an integer containing HTTP-like status code
(200 means OK, 4xx caller error, 5xx function error). Second element
($reason) is a string containing error message, or something like "OK" if status is
200. Third element ($payload) is the actual result, but usually not present when enveloped result is an error response ($status_code is not 2xx). Fourth
element (%result_meta) is called result metadata and is optional, a hash
that contains extra information, much like how HTTP response headers provide additional metadata.

Return value:  (any)

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/App-BPOMUtils-Table>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-App-BPOMUtils-Table>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023, 2022, 2021 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=App-BPOMUtils-Table>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
