#!perl

use strict;
use warnings;

use Test::More;

# Ensure a recent version of Test::Pod::Coverage

my $min_tpc = 1.08;
eval "use Test::Pod::Coverage $min_tpc";
plan skip_all =>
  "Test::Pod::Coverage $min_tpc required for testing POD coverage"
  if $@;

# Test::Pod::Coverage doesn't require a minimum Pod::Coverage version,
# but older versions don't recognize some common documentation styles

my $min_pc = 0.18;
eval "use Pod::Coverage $min_pc";
plan skip_all => "Pod::Coverage $min_pc required for testing POD coverage"
  if $@;

plan tests => 2;

my $trustme;

$trustme = {
            trustme => [ qw/copy modify/ ],
           };
pod_coverage_ok('Math::BigInt::Constant', $trustme,
                "All our Math::BigInt::Constants are covered");

$trustme = {
            trustme => [ qw/copy modify as_int/ ],
           };
pod_coverage_ok('Math::BigFloat::Constant', $trustme,
                "All our Math::BigFloat::Constantss are covered" );
