# Generated by default/object.tt
package Paws::WAFV2::CustomResponseBody;
  use Moose;
  has Content => (is => 'ro', isa => 'Str', required => 1);
  has ContentType => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::WAFV2::CustomResponseBody

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WAFV2::CustomResponseBody object:

  $service_obj->Method(Att1 => { Content => $value, ..., ContentType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WAFV2::CustomResponseBody object:

  $result = $service_obj->Method(...);
  $result->Att1->Content

=head1 DESCRIPTION

The response body to use in a custom response to a web request. This is
referenced by key from CustomResponse C<CustomResponseBodyKey>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Content => Str

The payload of the custom response.

You can use JSON escape strings in JSON content. To do this, you must
specify JSON content in the C<ContentType> setting.

For information about the limits on count and size for custom request
and response settings, see WAF quotas
(https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in
the WAF Developer Guide
(https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).


=head2 B<REQUIRED> ContentType => Str

The type of content in the payload that you are defining in the
C<Content> string.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WAFV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

