# Generated by default/object.tt
package Paws::TimestreamWrite::Table;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str');
  has CreationTime => (is => 'ro', isa => 'Str');
  has DatabaseName => (is => 'ro', isa => 'Str');
  has LastUpdatedTime => (is => 'ro', isa => 'Str');
  has RetentionProperties => (is => 'ro', isa => 'Paws::TimestreamWrite::RetentionProperties');
  has TableName => (is => 'ro', isa => 'Str');
  has TableStatus => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::TimestreamWrite::Table

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::TimestreamWrite::Table object:

  $service_obj->Method(Att1 => { Arn => $value, ..., TableStatus => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::TimestreamWrite::Table object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

Table represents a database table in Timestream. Tables contain one or
more related time series. You can modify the retention duration of the
memory store and the magnetic store for a table.

=head1 ATTRIBUTES


=head2 Arn => Str

The Amazon Resource Name that uniquely identifies this table.


=head2 CreationTime => Str

The time when the Timestream table was created.


=head2 DatabaseName => Str

The name of the Timestream database that contains this table.


=head2 LastUpdatedTime => Str

The time when the Timestream table was last updated.


=head2 RetentionProperties => L<Paws::TimestreamWrite::RetentionProperties>

The retention duration for the memory store and magnetic store.


=head2 TableName => Str

The name of the Timestream table.


=head2 TableStatus => Str

The current state of the table:

=over

=item *

C<DELETING> - The table is being deleted.

=item *

C<ACTIVE> - The table is ready for use.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::TimestreamWrite>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

