
package Paws::SSOIdentityStore::ListUsers;
  use Moose;
  has Filters => (is => 'ro', isa => 'ArrayRef[Paws::SSOIdentityStore::Filter]');
  has IdentityStoreId => (is => 'ro', isa => 'Str', required => 1);
  has MaxResults => (is => 'ro', isa => 'Int');
  has NextToken => (is => 'ro', isa => 'Str');

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'ListUsers');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::SSOIdentityStore::ListUsersResponse');
  class_has _result_key => (isa => 'Str', is => 'ro');
1;

### main pod documentation begin ###

=head1 NAME

Paws::SSOIdentityStore::ListUsers - Arguments for method ListUsers on L<Paws::SSOIdentityStore>

=head1 DESCRIPTION

This class represents the parameters used for calling the method ListUsers on the
L<AWS SSO Identity Store|Paws::SSOIdentityStore> service. Use the attributes of this class
as arguments to method ListUsers.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to ListUsers.

=head1 SYNOPSIS

    my $identitystore = Paws->service('SSOIdentityStore');
    my $ListUsersResponse = $identitystore->ListUsers(
      IdentityStoreId => 'MyIdentityStoreId',
      Filters         => [
        {
          AttributePath  => 'MyAttributePath',          # min: 1, max: 255
          AttributeValue => 'MySensitiveStringType',    # min: 1, max: 1024

        },
        ...
      ],    # OPTIONAL
      MaxResults => 1,                # OPTIONAL
      NextToken  => 'MyNextToken',    # OPTIONAL
    );

    # Results:
    my $NextToken = $ListUsersResponse->NextToken;
    my $Users     = $ListUsersResponse->Users;

    # Returns a L<Paws::SSOIdentityStore::ListUsersResponse> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/identitystore/ListUsers>

=head1 ATTRIBUTES


=head2 Filters => ArrayRef[L<Paws::SSOIdentityStore::Filter>]

A list of C<Filter> objects, which is used in the C<ListUsers> and
C<ListGroups> request.



=head2 B<REQUIRED> IdentityStoreId => Str

The globally unique identifier for the identity store, such as
d-1234567890. In this example, d- is a fixed prefix, and 1234567890 is
a randomly generated string which contains number and lower case
letters. This value is generated at the time that a new identity store
is created.



=head2 MaxResults => Int

The maximum number of results to be returned per request, which is used
in the C<ListUsers> and C<ListGroups> request to specify how many
results to return in one page. The length limit is 50 characters.



=head2 NextToken => Str

The pagination token used for the C<ListUsers> and C<ListGroups> APIs.
This value is generated by the identity store service and is returned
in the API response if the total results are more than the size of one
page, and when this token is used in the API request to search for the
next page.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method ListUsers in L<Paws::SSOIdentityStore>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

