# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::NZ;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20210921211833;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8[1-579]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            50(?:
              [0367]|
              88
            )|
            [89]0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2,3})'
                },
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '
            24|
            [346]|
            7[2-57-9]|
            9[2-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            2(?:
              10|
              74
            )|
            [59]|
            80
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1|
            2[028]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            2(?:
              [169]|
              7[0-35-9]
            )|
            7|
            86
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,5})'
                }
              ];

my $validators = {
                'fixed_line' => '
          24099\\d{3}|
          (?:
            3[2-79]|
            [49][2-9]|
            6[235-9]|
            7[2-57-9]
          )\\d{6}
        ',
                'geographic' => '
          24099\\d{3}|
          (?:
            3[2-79]|
            [49][2-9]|
            6[235-9]|
            7[2-57-9]
          )\\d{6}
        ',
                'mobile' => '
          2[0-27-9]\\d{7,8}|
          21\\d{6}
        ',
                'pager' => '[28]6\\d{6,7}',
                'personal_number' => '70\\d{7}',
                'specialrate' => '(
          (?:
            11\\d{5}|
            50(?:
              0[08]|
              30|
              66|
              77|
              88
            )
          )\\d{3}|
          90\\d{6,8}
        )|(
          8(?:
            1[6-9]|
            22|
            3\\d|
            4[045]|
            5[459]|
            7[0-3579]|
            90
          )\\d{2,7}
        )',
                'toll_free' => '
          508\\d{6,7}|
          80\\d{6,8}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"6439705", "Motueka",
"643467", "Dunedin",
"644203", "Wellington",
"649232", "Pukekohe",
"6466508", "Napier\/Wairoa",
"643415", "Balclutha",
"6496990", "Kaitaia",
"6439332", "Hokitika",
"649887", "Auckland",
"644570", "Wellington",
"644904", "Paraparaumu",
"644212", "Wellington",
"6435685", "Tokanui",
"6439525", "Milton",
"647848", "Hamilton",
"6432443", "Christchurch",
"6478450", "Hamilton",
"6442129", "Paraparaumu",
"644280", "Wellington",
"6465604", "Ohakune",
"6473945", "Tauranga",
"6472143", "Morrinsville",
"6437465", "Waimate",
"64483", "Wellington",
"6495531", "Helensville",
"6439451", "Invercargill",
"6435994", "Ashburton",
"6472459", "Rotorua",
"6478073", "Tokoroa\/Putaruru",
"6434299", "Haast",
"6467551", "New\ Plymouth",
"6472802", "Paeroa",
"6499006", "Whangarei",
"643215", "Invercargill",
"6499426", "Auckland",
"646366", "Levin",
"6468256", "Palmerston\ North",
"6477884", "Tauranga",
"6433958", "Oamaru",
"6435559", "Haast",
"6479291", "Hamilton",
"64438", "Wellington",
"6432757", "Lumsden",
"644526", "Wellington",
"6433957", "Palmerston",
"647245", "Hamilton",
"649982", "Whangarei",
"6472122", "Te\ Awamutu",
"6432758", "Otautau",
"6432626", "Kurow",
"6468997", "Napier",
"6492830", "Auckland",
"6472609", "Whangamata",
"6439045", "Twizel",
"6445952", "Wellington",
"6475628", "Tauranga",
"6479845", "Paeroa",
"6499553", "Kaikohe",
"643964", "Christchurch",
"649297", "Auckland",
"64935", "Auckland",
"6468998", "Napier",
"6475627", "Taupo",
"647988", "Rotorua",
"6432723", "Takaka",
"6472194", "Whakatane",
"6479850", "Tokoroa",
"6492420", "Auckland",
"6499479", "Pukekohe",
"6499876", "Kaikohe",
"6432639", "Edendale",
"6439050", "Geraldine",
"6436595", "Mt\ Cook",
"6432805", "Winton",
"646328", "Palmerston\ North",
"644890", "Wellington",
"6462165", "Stratford",
"643463", "Palmerston",
"6492808", "Great\ Barrier\ Island",
"6432742", "Twizel",
"6493936", "Maungaturoto",
"6465618", "Masterton",
"6499746", "Kawakawa",
"643305", "Ashburton\/Akaroa\/Chatham\ Islands",
"6498826", "Warkworth",
"6439858", "Kaikoura",
"6478142", "Whakatane",
"6439732", "Otautau",
"6492807", "Helensville",
"643955", "Dunedin",
"6469280", "Waipukurau",
"6465617", "Mokau",
"649883", "Auckland",
"649392", "Auckland",
"6439857", "Akaroa",
"6433942", "Akaroa",
"6449741", "Paraparaumu",
"6499047", "Pukekohe",
"647460", "Rotorua",
"649582", "Auckland",
"6436992", "Greymouth",
"6499048", "Pukekohe",
"6462415", "Levin",
"6462811", "New\ Plymouth",
"6435687", "Lumsden",
"6439527", "Kurow",
"643982", "Christchurch",
"6432449", "Queenstown",
"6439708", "Murchison",
"649429", "Great\ Barrier\ Island",
"6434401", "Cromwell",
"6439528", "Lawrence",
"6435688", "Queenstown",
"6445950", "Wellington",
"6492832", "Dargaville",
"6439707", "Takaka",
"643432", "Oamaru",
"6437468", "Wanaka",
"649555", "Auckland",
"6437474", "Oamaru",
"6473948", "Opotiki",
"643943", "Christchurch",
"6439314", "Winton",
"643337", "Christchurch",
"6472149", "Whangamata",
"6479029", "Waihi",
"6439006", "Nelson",
"649215", "Auckland",
"6437467", "Queenstown",
"6439052", "Mt\ Cook",
"6479852", "Whangamata",
"6473947", "Whakatane",
"6436584", "Winton",
"6469271", "Pahiatua",
"6472821", "Hamilton",
"6433940", "Westport",
"6499451", "Warkworth",
"6468264", "Palmerston\ North",
"6435531", "Nelson",
"6469282", "Mokau",
"6439730", "Invercargill",
"646986", "Gisborne",
"6469615", "Masterton",
"6434293", "Haast",
"6478140", "Rotorua",
"6478079", "Hamilton",
"646753", "New\ Plymouth",
"649818", "Auckland",
"6432814", "Mt\ Cook",
"6432740", "Lawrence",
"6469574", "Taihape",
"643444", "Ranfurly",
"6439274", "Queenstown",
"6439268", "Dunedin",
"6433955", "Mt\ Cook",
"6436990", "Cheviot",
"6469019", "Pahiatua",
"6432755", "Edendale",
"6469311", "Palmerston\ North",
"6435553", "Wanaka",
"6439346", "Christchurch",
"6439267", "Dunedin",
"6469869", "Ruatoria",
"6424", "Scott\ Base",
"647880", "Matamata",
"6478129", "Matamata",
"6435527", "Alexandra",
"647304", "Whakatane",
"6479848", "Te\ Kuiti",
"6439048", "Lawrence",
"6475625", "Rotorua",
"6432651", "Queenstown",
"6432729", "Westport",
"6439330", "Westport",
"6496992", "Kawakawa",
"6435528", "Ranfurly",
"6435694", "Franz\ Josef",
"6479847", "Te\ Awamutu",
"6472603", "Hamilton",
"6499559", "Whangarei",
"646757", "New\ Plymouth",
"6439047", "Alexandra",
"6468995", "Napier",
"6493942", "Great\ Barrier\ Island",
"6472427", "Rotorua",
"643250", "Christchurch",
"643689", "Waimate",
"6432736", "Dunedin",
"6478136", "Te\ Awamutu",
"6436597", "Cromwell",
"6432807", "Tokanui",
"6499473", "Helensville",
"6469711", "New\ Plymouth",
"6472428", "Taupo",
"647812", "Hamilton",
"6439746", "Dunedin",
"6439083", "Cheviot",
"6432808", "Westport",
"6432633", "Otautau",
"6436624", "Darfield",
"6436598", "Wanaka",
"6439855", "Rangiora",
"6439531", "Timaru",
"6498851", "Pukekohe",
"6465615", "Wanganui",
"6496511", "Whangarei",
"6462168", "Featherston",
"643769", "Greymouth",
"6472800", "Thames",
"6439876", "Roxburgh",
"6432420", "Christchurch",
"6462167", "Mokau",
"6472120", "Putaruru\/Tokoroa",
"6479040", "Otorohanga",
"6462417", "Wanganui",
"649908", "Auckland",
"6434244", "Amberley",
"643731", "Greymouth",
"6479501", "Opotiki",
"64456", "Wellington",
"64335", "Christchurch",
"6439714", "Waimate",
"643947", "Invercargill",
"649964", "Auckland",
"6462418", "Palmerston\ North",
"6499045", "Hibiscus\ Coast",
"643450", "Queenstown",
"646833", "Napier\/Hastings",
"6469000", "New\ Plymouth",
"643740", "Christchurch",
"6479719", "Te\ Kuiti",
"6468801", "Wanganui",
"6439769", "Roxburgh",
"649425", "Warkworth",
"649652", "Warkworth",
"649828", "Auckland",
"6463914", "Stratford",
"6439092", "Rangiora",
"6436523", "Hokitika",
"6475824", "Hamilton",
"643920", "Rangiora",
"6436652", "Winton",
"6466996", "Stratford",
"644461", "Wellington",
"6496882", "Auckland",
"644439", "Wellington",
"646342", "Wanganui",
"6472612", "Te\ Awamutu",
"6432662", "Christchurch",
"647923", "Whakatane",
"6432711", "Akaroa",
"6473924", "Paeroa",
"6433911", "Nelson",
"6468885", "New\ Plymouth",
"6433995", "Tokanui",
"6434231", "Christchurch",
"6437441", "Motueka",
"646387", "Waiouru",
"6477770", "Tauranga",
"6468820", "Palmerston\ North",
"6492225", "Pukekohe",
"6473992", "Opotiki",
"6435516", "Balclutha",
"6432615", "Amberley",
"6472220", "Tauranga",
"6497775", "Helensville",
"6499462", "Whangarei",
"6472819", "Rotorua",
"643576", "Nelson",
"6474444", "Hamilton",
"6434228", "Tokanui",
"647927", "Tauranga",
"647856", "Hamilton",
"649959", "Hibiscus\ Coast",
"643685", "Fairlie",
"6434271", "Balclutha",
"6434227", "Riverton",
"643520", "Blenheim",
"646837", "Wairoa",
"6436683", "Rangiora",
"649630", "Auckland",
"6434282", "Queenstown",
"6442198", "Paraparaumu",
"644589", "Wellington",
"6439024", "Lumsden",
"6463908", "Wairoa",
"643486", "Dunedin",
"6469293", "New\ Plymouth",
"6435544", "Winton",
"6462109", "Waiouru",
"6439061", "Greymouth",
"6442197", "Paraparaumu",
"6498815", "Helensville",
"6463907", "Waipukurau",
"646374", "Dannevirke",
"6432227", "Queenstown",
"644399", "Wellington",
"6437778", "Greymouth",
"6436647", "Te\ Anau",
"6462426", "Levin",
"6432228", "Wanaka",
"6436648", "Lumsden",
"6437777", "Christchurch",
"6439763", "Palmerston",
"6472222", "Hamilton",
"6479713", "Morrinsville",
"643419", "Balclutha",
"6473990", "Te\ Awamutu",
"6468822", "Masterton",
"6477772", "Rotorua",
"6462601", "Palmerston\ North",
"646656", "Levin",
"6435954", "Christchurch",
"643225", "Otautau",
"6432991", "Milton",
"644806", "Wellington",
"6499460", "Whangarei",
"6439884", "Franz\ Josef",
"643219", "Invercargill",
"6434280", "Queenstown",
"6436529", "Westport",
"6434991", "Cromwell",
"646858", "Waipukurau",
"643425", "Dunedin",
"6433997", "Gore",
"6468887", "Gisborne",
"644777", "Wellington",
"6468888", "Masterton",
"6433998", "Lumsden",
"646967", "New\ Plymouth",
"6497777", "Auckland",
"6432617", "Cheviot",
"644916", "Wellington",
"6492228", "Warkworth",
"6497778", "Pukekohe",
"643788", "Westport",
"6475616", "Whangamata",
"647839", "Hamilton",
"6469002", "Hawera",
"6492227", "Whangarei",
"6432618", "Culverden",
"6435666", "Oamaru",
"6434225", "Edendale",
"6499811", "Hibiscus\ Coast",
"6499061", "Hibiscus\ Coast",
"6478091", "Matamata",
"6437486", "Tokanui",
"6439090", "Rangiora",
"6472813", "Waihi",
"6462620", "New\ Plymouth",
"649401", "Kaikohe",
"6436576", "Cromwell",
"6463905", "Napier",
"6462103", "Levin",
"6498817", "Hibiscus\ Coast",
"6469299", "Napier\/Hastings",
"6478996", "Huntly",
"6436689", "Christchurch",
"6466004", "Waipukurau",
"6435884", "Dunedin",
"6465626", "Ruatoria",
"6436650", "Otautau",
"6439286", "Cromwell",
"646862", "Gisborne",
"6437775", "Wanaka",
"6432660", "Christchurch",
"6472610", "Morrinsville",
"6436645", "Ranfurly",
"6496880", "Auckland",
"6432225", "Greymouth",
"6433984", "Roxburgh",
"6432608", "Dunedin",
"6468884", "Palmerston\ North",
"6469012", "Waiouru",
"6475606", "Matamata",
"6433994", "Winton",
"6432607", "Dunedin",
"6439296", "Invercargill",
"6443709", "Paraparaumu",
"6473925", "Putaruru\/Tokoroa",
"6472123", "Morrinsville",
"643669", "Christchurch",
"6478072", "Paeroa",
"649400", "Kaikohe",
"6432423", "Dunedin",
"6472803", "Waihi",
"643308", "Ashburton\/Akaroa\/Chatham\ Islands",
"644902", "Paraparaumu",
"644370", "Wellington",
"649347", "Auckland",
"644290", "Paraparaumu",
"6475950", "Hamilton",
"64930", "Auckland",
"6475825", "Hamilton",
"64447", "Wellington",
"6469289", "Taihape",
"644913", "Wellington",
"6432630", "Christchurch",
"6472142", "Te\ Awamutu",
"6479022", "Morrinsville",
"6439080", "Ashburton",
"6492429", "Pukekohe",
"649984", "Auckland",
"6499470", "Hibiscus\ Coast",
"6492009", "Pukekohe",
"6479859", "Tauranga",
"646657", "Masterton",
"646325", "Palmerston\ North",
"6478081", "Rotorua",
"6463991", "Masterton",
"6463915", "Opunake",
"6466579", "Featherston",
"647838", "Hamilton",
"6474637", "Opotiki",
"6492839", "Whangarei",
"6472600", "Hamilton",
"6442821", "Wellington",
"643789", "Westport",
"6439333", "Franz\ Josef",
"6474638", "Opotiki",
"649200", "Auckland",
"6432442", "Christchurch",
"6433988", "Wanaka",
"6439751", "Culverden",
"6435550", "Fox\ Glacier",
"6466526", "Waiouru",
"644803", "Wellington",
"6436993", "Kaikoura",
"6433987", "Cromwell",
"646653", "Wanganui",
"6499100", "Pukekohe",
"647878", "Te\ Kuiti",
"64423", "Wellington",
"6432743", "Kurow",
"6435545", "Gore",
"6498814", "Pukekohe",
"6435888", "Timaru",
"643218", "Invercargill",
"6466008", "Ohakune",
"6434290", "Greymouth",
"6478143", "Opotiki",
"6439733", "Te\ Anau",
"643962", "Christchurch",
"6435887", "Invercargill",
"6432646", "Timaru",
"6462611", "Napier",
"6466007", "Stratford",
"6439025", "Otautau",
"6433943", "Amberley",
"6436566", "Kurow",
"6494701", "Whangarei",
"6474445", "Hamilton",
"649394", "Auckland",
"6432614", "Akaroa",
"6445953", "Wellington",
"6497774", "Warkworth",
"6435676", "Kurow",
"64941", "Auckland",
"6499552", "Dargaville",
"643418", "Balclutha",
"6492224", "Auckland",
"6499726", "Kawakawa",
"6469891", "Gisborne",
"6432722", "Murchison",
"6496999", "Auckland",
"644917", "Wellington",
"6472621", "Tauranga",
"6473927", "Te\ Kuiti",
"647853", "Hamilton",
"6469247", "Wanganui",
"649905", "Auckland",
"6472129", "Whangamata",
"6479049", "Te\ Kuiti",
"6435506", "Amberley",
"6473928", "Te\ Awamutu",
"6435552", "Queenstown",
"643434", "Oamaru",
"6439885", "Fox\ Glacier",
"647552", "Tauranga",
"647968", "Hamilton",
"6498881", "Hibiscus\ Coast",
"6475827", "Hamilton",
"6469283", "Opunake",
"6473847", "Taupo",
"6434292", "Hokitika",
"643984", "Blenheim",
"6432429", "Timaru",
"6475828", "Hamilton",
"6472809", "Otorohanga",
"643234", "Riverton",
"6463917", "Wanganui",
"6473337", "Rotorua",
"6462119", "Wairoa",
"649958", "Helensville",
"6479421", "Tauranga",
"6439326", "Rangiora",
"6479001", "Hamilton",
"6463918", "Wanganui",
"643977", "Christchurch",
"6435955", "Christchurch",
"6473338", "Rotorua",
"6479853", "Putaruru",
"643442", "Queenstown",
"649631", "Auckland",
"644245", "Wellington",
"643521", "Nelson",
"6468241", "Gisborne",
"6432720", "Nelson",
"6499296", "Kaitaia",
"6496011", "Kaikohe",
"646211", "Napier",
"6492833", "Warkworth",
"6466551", "New\ Plymouth",
"6436999", "Nelson",
"6436644", "Alexandra",
"6468811", "Marton",
"6479108", "Whakatane",
"6439726", "Timaru",
"6433985", "Alexandra",
"6432224", "Invercargill",
"6479709", "Matamata",
"643741", "Christchurch",
"6437774", "Queenstown",
"6469010", "Taihape",
"6479107", "Whakatane",
"644260", "Wellington",
"6466005", "Mokau",
"6439027", "Winton",
"6439071", "Motueka",
"6435885", "Invercargill",
"6439739", "Invercargill",
"6433949", "Rangiora",
"6442609", "Paraparaumu",
"6435548", "Westport",
"6474656", "Te\ Awamutu",
"6463904", "Napier",
"6439028", "Edendale",
"6432749", "Wanaka",
"646836", "Napier\/Hastings",
"6478070", "Morrinsville",
"6435547", "Blenheim",
"647970", "Hamilton",
"649815", "Auckland",
"643487", "Dunedin",
"647857", "Hamilton",
"6493943", "Helensville",
"644460", "Wellington",
"6474447", "Te\ Kuiti",
"6473931", "Whangamata",
"6434261", "Balclutha",
"6467771", "New\ Plymouth",
"649962", "Auckland",
"649558", "Auckland",
"6499733", "Warkworth",
"6462221", "Gisborne",
"6499472", "Great\ Barrier\ Island",
"649218", "Auckland",
"6434224", "Te\ Anau",
"6439082", "Culverden",
"6474448", "Taumarunui",
"643921", "Blenheim",
"6472140", "Putaruru\/Tokoroa",
"649829", "Auckland",
"6479020", "Te\ Awamutu",
"6432632", "Lumsden",
"647926", "Tauranga",
"6436616", "Geraldine",
"6432440", "Christchurch",
"646951", "Palmerston\ North",
"6496993", "Whangarei",
"6472602", "Hamilton",
"6495589", "Pukekohe",
"6496883", "Auckland",
"6439277", "Invercargill",
"6472613", "Putaruru\/Tokoroa",
"6432663", "Christchurch",
"649909", "Auckland",
"6436631", "Motueka",
"6439278", "Invercargill",
"647881", "Matamata",
"647541", "Tauranga",
"6469578", "Marton",
"6436522", "Greymouth",
"6432818", "Christchurch",
"6436653", "Edendale",
"643768", "Greymouth",
"6477885", "Tauranga",
"6432817", "Christchurch",
"6469577", "Ohakune",
"6443990", "Paraparaumu",
"6462100", "Levin",
"6468268", "New\ Plymouth",
"6439317", "Gore",
"6436588", "Lumsden",
"6437477", "Roxburgh",
"6472810", "Tauranga",
"6462623", "Stratford",
"6479246", "Thames",
"6435995", "Darfield",
"646273", "Hawera",
"6463926", "Taihape",
"6439318", "Lumsden",
"6437478", "Twizel",
"6473944", "Tauranga",
"6436587", "Gore",
"6465605", "Marton",
"6437464", "Timaru",
"643688", "Timaru",
"643336", "Christchurch",
"646344", "Wanganui",
"646974", "Napier",
"643451", "Queenstown",
"6435684", "Winton",
"6439524", "Oamaru",
"6477779", "Putaruru\/Tokoroa",
"6462137", "Palmerston\ North",
"6439704", "Murchison",
"6449084", "Wellington",
"646843", "Napier\/Hastings",
"6462138", "Palmerston\ North",
"6439717", "Fairlie",
"6434247", "Kaikoura",
"6462414", "Napier",
"6439718", "Mt\ Cook",
"6434248", "Cheviot",
"6468308", "Napier",
"643946", "Invercargill",
"6462801", "Palmerston\ North",
"6436682", "Dunedin",
"6462121", "Palmerston\ North",
"6434283", "Cromwell",
"643752", "Franz\ Josef",
"6439016", "Alexandra",
"6479230", "Opotiki",
"6469292", "Ruatoria",
"6462164", "New\ Plymouth",
"649640", "Auckland",
"646847", "Napier\/Hastings",
"6436594", "Waimate",
"6436628", "Ashburton",
"649825", "Auckland",
"6499463", "Whangarei",
"6432804", "Riverton",
"6472424", "Tauranga",
"6436627", "Waitangi\ \(Chatham\ Is\.\)",
"647323", "Whakatane",
"646372", "Masterton",
"646756", "New\ Plymouth",
"6472195", "Rotorua",
"6473993", "Te\ Awamutu",
"6469009", "Palmerston\ North",
"6469301", "Ruatoria",
"6435698", "Hokitika",
"6435561", "Dunedin",
"649428", "Hibiscus\ Coast",
"647824", "Hamilton",
"6439044", "Milton",
"6479844", "Otorohanga",
"6479710", "Putaruru\/Tokoroa",
"6439760", "Twizel",
"6435697", "Westport",
"6432754", "Tokanui",
"644527", "Wellington",
"6478591", "Hamilton",
"6439275", "Nelson",
"6432669", "Rangiora",
"649451", "Auckland",
"6433954", "Lawrence",
"6477888", "Taupo",
"644891", "Wellington",
"6436501", "Akaroa",
"6432815", "Fairlie",
"6469575", "Waiouru",
"6469290", "Napier\/Hastings",
"6436659", "Haast",
"6477887", "Te\ Awamutu",
"6436680", "Akaroa",
"646367", "Levin",
"6469614", "Levin",
"6435998", "Rangiora",
"6465607", "Taihape",
"6436585", "Tokanui",
"6437456", "Culverden",
"646329", "Palmerston\ North",
"6435997", "Amberley",
"6439099", "Kaikoura",
"6437475", "Palmerston",
"6465608", "Dannevirke",
"643654", "Timaru",
"6498019", "Pukekohe",
"6439315", "Tokanui",
"6462629", "Levin",
"647989", "Taupo",
"6439762", "Oamaru",
"6498691", "Maungaturoto",
"6479712", "Te\ Awamutu",
"6472223", "Hamilton",
"649886", "Auckland",
"6436549", "Mt\ Cook",
"649801", "Auckland",
"643466", "Dunedin",
"6477773", "Taupo",
"6468823", "Napier\/Hastings",
"649320", "Auckland",
"646855", "Waipukurau",
"644571", "Wellington",
"6499044", "Hibiscus\ Coast",
"6495561", "Whangarei",
"6434245", "Culverden",
"6439715", "Timaru",
"6462102", "Levin",
"6462156", "Hawera",
"6447770", "Paraparaumu",
"6439854", "Waitangi\ \(Chatham\ Is\.\)",
"6493209", "Great\ Barrier\ Island",
"6465614", "Wanganui",
"6436520", "Greymouth",
"6434289", "Wanaka",
"644281", "Wellington",
"644931", "Wellington",
"6436625", "Rangiora",
"6499016", "Kaikohe",
"6499469", "Maungaturoto",
"6472812", "Tauranga",
"646864", "Ruatoria",
"6472198", "Opotiki",
"6435695", "Fox\ Glacier",
"647849", "Hamilton",
"647589", "Hamilton",
"6469851", "Napier",
"6468994", "Waipukurau",
"6499718", "Whangarei",
"6472197", "Tauranga",
"6475624", "Rotorua",
"6469003", "Napier\/Hastings",
"6473999", "Taupo",
"646761", "Opunake",
"6499717", "Whangarei",
"649296", "Auckland",
"646363", "Levin",
"6499466", "Kaikohe",
"646362", "Levin",
"6436508", "Rangiora",
"6499019", "Maungaturoto",
"6477881", "Hamilton",
"6436507", "Kaikoura",
"643680", "Fairlie",
"6467554", "New\ Plymouth",
"6478598", "Hamilton",
"643612", "Timaru",
"6435512", "Rangiora",
"6473996", "Otorohanga",
"6479294", "Hamilton",
"6436635", "Fairlie",
"643738", "Greymouth",
"6478597", "Hamilton",
"649986", "Whangarei",
"647549", "Tauranga",
"647889", "Morrinsville",
"649236", "Pukekohe",
"6462422", "Napier\/Hastings",
"649635", "Auckland",
"643525", "Takaka",
"6439863", "Motueka",
"6493206", "Pukekohe",
"6439454", "Lumsden",
"6434286", "Christchurch",
"6435991", "Franz\ Josef",
"6465601", "Palmerston\ North",
"6462159", "Mokau",
"649811", "Auckland",
"646964", "Wanganui",
"6462626", "Mokau",
"6463923", "Ohakune",
"6469045", "Waipukurau",
"6498016", "Hibiscus\ Coast",
"6462125", "Taihape",
"6437480", "Gore",
"6437459", "Rangiora",
"6495568", "Kawakawa",
"6435660", "Haast",
"6475610", "Putaruru\/Tokoroa",
"649420", "Helensville",
"6495567", "Kaitaia",
"6436546", "Fairlie",
"644922", "Wellington",
"6462805", "Napier\/Hastings",
"647949", "Hamilton",
"649846", "Auckland",
"6469305", "New\ Plymouth",
"6472616", "Taumarunui",
"6472191", "Whakatane",
"6472115", "Taumarunui",
"649476", "Auckland",
"6463942", "Masterton",
"6439280", "Nelson",
"643925", "Christchurch",
"6465620", "New\ Plymouth",
"6436656", "Hokitika",
"649220", "Auckland",
"6478990", "Thames",
"6466992", "Hawera",
"6469571", "Palmerston\ North",
"6432811", "Fox\ Glacier",
"6437482", "Lumsden",
"6436505", "Culverden",
"6435534", "Takaka",
"6499013", "Kawakawa",
"6468261", "Masterton",
"6499454", "Whangarei",
"646373", "Masterton",
"6469314", "Waiouru",
"647322", "Whakatane",
"6478595", "Hamilton",
"6436637", "Twizel",
"6439271", "Westport",
"643236", "Winton",
"6469006", "Gisborne",
"6475612", "Te\ Kuiti",
"6436638", "Kurow",
"6435662", "Geraldine",
"649459", "Whangarei",
"647981", "Hamilton",
"6439282", "Christchurch",
"6434404", "Alexandra",
"647906", "Taupo",
"6463940", "Levin",
"643753", "Hokitika",
"6462814", "Hawera",
"6466990", "Mokau",
"6462153", "New\ Plymouth",
"643436", "Kurow",
"6478992", "Paeroa",
"646321", "Marton",
"6436581", "Invercargill",
"6469274", "New\ Plymouth",
"6496507", "Helensville",
"6439869", "Blenheim",
"6465622", "Stratford",
"6439311", "Invercargill",
"6439019", "Roxburgh",
"6496508", "Hibiscus\ Coast",
"6437471", "Kurow",
"6462128", "Ohakune",
"646842", "Napier\/Hastings",
"6437453", "Amberley",
"6462127", "Dannevirke",
"6498854", "Hibiscus\ Coast",
"6439534", "Mt\ Cook",
"644650", "Wellington",
"6496514", "Whangarei",
"6479249", "Huntly",
"6462807", "Napier\/Hastings",
"6472226", "Te\ Kuiti",
"6446509", "Paraparaumu",
"6495565", "Dargaville",
"6468301", "Napier",
"6435510", "Darfield",
"646272", "Hawera",
"6462808", "Napier\/Hastings",
"6439711", "Geraldine",
"6434241", "Rangiora",
"6468826", "Levin",
"6477776", "Whangamata",
"646834", "Napier\/Hastings",
"6472118", "Taumarunui",
"6469308", "Opunake",
"6435691", "Murchison",
"643420", "Christchurch",
"6462420", "Palmerston\ North",
"6469307", "Stratford",
"6432654", "Blenheim",
"646769", "New\ Plymouth",
"64332", "Christchurch",
"6469714", "Hawera",
"64635", "Palmerston\ North",
"646377", "Masterton",
"6436621", "Culverden",
"647391", "Hamilton",
"644939", "Wellington",
"649919", "Auckland",
"647217", "Taupo",
"6499872", "Whangarei",
"6436619", "Cheviot",
"6439000", "Christchurch",
"6436563", "Lawrence",
"6475821", "Hamilton",
"6473841", "Taupo",
"647557", "Tauranga",
"64757", "Tauranga",
"644895", "Paraparaumu",
"64320", "Gore",
"6432622", "Balclutha",
"6445956", "Wellington",
"6433914", "Takaka",
"646346", "Wanganui",
"643334", "Christchurch",
"644498", "Wellington",
"646976", "Napier",
"6437444", "Takaka",
"6434234", "Darfield",
"6435673", "Lawrence",
"649963", "Auckland",
"644975", "Paraparaumu",
"6432714", "Cheviot",
"6473921", "Matamata",
"6469241", "Napier",
"6468804", "Napier",
"6496018", "Auckland",
"6468248", "New\ Plymouth",
"6466523", "Palmerston\ North",
"647590", "Hamilton",
"6439340", "Mt\ Cook",
"6436996", "Takaka",
"647312", "Whakatane",
"6496017", "Great\ Barrier\ Island",
"6439729", "Fox\ Glacier",
"6468247", "Mokau",
"6479752", "Rotorua",
"6432746", "Alexandra",
"649408", "Kaitaia",
"643447", "Alexandra",
"6493932", "Dargaville",
"6479008", "Rotorua",
"6498822", "Kaikohe",
"643300", "Ashburton\/Akaroa\/Chatham\ Islands",
"6478085", "Tauranga",
"6439736", "Riverton",
"6473331", "Rotorua",
"643950", "Dunedin",
"6479007", "Whakatane",
"644298", "Paraparaumu",
"6474659", "Whangamata",
"6432643", "Haast",
"6463911", "New\ Plymouth",
"647868", "Thames",
"6433946", "Culverden",
"6463995", "Marton",
"6435541", "Te\ Anau",
"647826", "Huntly",
"643482", "Dunedin",
"6475482", "Tauranga",
"647307", "Whakatane",
"6479014", "Matamata",
"6439740", "Christchurch",
"6478130", "Morrinsville",
"6432730", "Blenheim",
"6462615", "Gisborne",
"646754", "New\ Plymouth",
"647957", "Hamilton",
"6479101", "Rotorua",
"6468818", "Opunake",
"6439755", "Rangiora",
"643443", "Wanaka",
"64331", "Rangiora\/Amberley\/Culverden\/Darfield\/Cheviot\/Kaikoura",
"6466558", "Opunake",
"6439336", "Cromwell",
"6468817", "Stratford",
"6499299", "Whangarei",
"6466557", "Stratford",
"646765", "Stratford",
"647213", "Hamilton",
"6435509", "Culverden",
"6475603", "Hamilton",
"6462144", "Ruatoria",
"6472625", "Opotiki",
"6439293", "Blenheim",
"6472126", "Otorohanga",
"6449123", "Wellington",
"6479748", "Taumarunui",
"6434268", "Roxburgh",
"6467778", "Wairoa",
"649915", "Auckland",
"6432426", "Blenheim",
"647870", "Te\ Awamutu",
"643944", "Christchurch",
"6462227", "Napier",
"6439870", "Queenstown",
"6472806", "Matamata",
"644888", "Wellington",
"6499422", "Helensville",
"6499002", "Auckland",
"6434274", "Kurow",
"6467777", "Napier",
"6434267", "Ranfurly",
"6479747", "Te\ Kuiti",
"6494705", "Whangarei",
"649967", "Auckland",
"6468252", "Dannevirke",
"6462228", "Wanganui",
"6474441", "Waihi",
"647852", "Hamilton",
"643464", "Dunedin",
"6439881", "Greymouth",
"6432732", "Fairlie",
"6478132", "Paeroa",
"649950", "Auckland",
"644907", "Wellington",
"649884", "Auckland",
"6439742", "Christchurch",
"6436569", "Alexandra",
"6475480", "Tauranga",
"6436613", "Wanaka",
"647885", "Putaruru\/Tokoroa",
"6496996", "Warkworth",
"6434994", "Palmerston",
"6435679", "Alexandra",
"649892", "Auckland",
"6468245", "Wairoa",
"6496015", "Maungaturoto",
"643963", "Christchurch",
"6439723", "Blenheim",
"643455", "Dunedin",
"644390", "Wellington",
"6466529", "Pahiatua",
"6463997", "Palmerston\ North",
"647960", "Hamilton",
"6479005", "Tauranga",
"644619", "Wellington",
"6468250", "Stratford",
"6432994", "Otautau",
"6474653", "Putaruru\/Tokoroa",
"6432649", "Waimate",
"6469203", "New\ Plymouth",
"6499420", "Pukekohe",
"644802", "Wellington",
"6435951", "Christchurch",
"6499000", "Auckland",
"6463998", "Palmerston\ North",
"6462604", "Ohakune",
"6439872", "Alexandra",
"649639", "Auckland",
"643529", "Nelson",
"6435881", "Dunedin",
"6439075", "Takaka",
"6462617", "Masterton",
"6466001", "Napier",
"649294", "Auckland",
"643967", "Christchurch",
"6439323", "Cheviot",
"649550", "Auckland",
"6439002", "Rangiora",
"649210", "Auckland",
"6462618", "Masterton",
"6499870", "Whangarei",
"6492426", "Whangarei",
"6492006", "Helensville",
"6479856", "Tauranga",
"649282", "Auckland",
"644817", "Wellington",
"6466555", "Hawera",
"6433981", "Twizel",
"6439758", "Ashburton",
"6468815", "Pahiatua",
"643749", "Christchurch",
"6439757", "Waitangi\ \(Chatham\ Is\.\)",
"6492836", "Kaitaia",
"6432620", "Palmerston",
"644204", "Wellington",
"6479750", "Tauranga",
"6472627", "Rotorua",
"6439299", "Murchison",
"644903", "Wellington",
"6435503", "Christchurch",
"6475609", "Paeroa",
"6439342", "Geraldine",
"6472628", "Taupo",
"6494314", "Warkworth",
"6473935", "Rotorua",
"6472133", "Taupo",
"6469286", "Dannevirke",
"6467775", "Palmerston\ North",
"6434265", "Milton",
"6498820", "Whangarei",
"6462225", "Levin",
"6493930", "Whangarei",
"6478094", "Tauranga",
"6499064", "Helensville",
"647348", "Rotorua",
"6478084", "Hamilton",
"6432997", "Edendale",
"6436686", "Invercargill",
"647349", "Rotorua",
"644524", "Wellington",
"6439862", "Nelson",
"649211", "Auckland",
"6462608", "Dannevirke",
"6463994", "Dannevirke",
"6439012", "Queenstown",
"643690", "Waimate",
"649551", "Auckland",
"6432998", "Tokanui",
"643614", "Timaru",
"6469296", "Levin",
"6462607", "Taihape",
"6478999", "Hamilton",
"6466011", "Marton",
"64992", "Auckland",
"646863", "Gisborne",
"646308", "Featherston",
"6462423", "Gisborne",
"6468805", "Wanganui",
"6439289", "Akaroa",
"646364", "Levin",
"6432715", "Culverden",
"6435669", "Wanaka",
"6434998", "Dunedin",
"6475619", "Hamilton",
"6435513", "Waitangi\ \(Chatham\ Is\.\)",
"6433991", "Invercargill",
"6468881", "Napier\/Hastings",
"6433915", "Greymouth",
"643657", "Queenstown",
"6437445", "Fox\ Glacier",
"6434235", "Akaroa",
"6434997", "Lawrence",
"644906", "Paraparaumu",
"649820", "Auckland",
"6436579", "Wanaka",
"6437450", "Westport",
"649638", "Auckland",
"6436526", "Fox\ Glacier",
"6499068", "Pukekohe",
"644924", "Wellington",
"643528", "Motueka",
"6494704", "Whangarei",
"6499818", "Great\ Barrier\ Island",
"6499067", "Pukekohe",
"6478097", "Whakatane",
"649951", "Auckland",
"64952", "Auckland",
"6466993", "Waiouru",
"6462150", "New\ Plymouth",
"6434275", "Milton",
"643653", "Blenheim",
"6492221", "Auckland",
"6472624", "Whakatane",
"6469025", "Mokau",
"6463943", "Masterton",
"6432611", "Kaikoura",
"6497771", "Kaikohe",
"644391", "Wellington",
"644816", "Wellington",
"6439754", "Darfield",
"646867", "Gisborne",
"643409", "Queenstown",
"6479242", "Rotorua",
"6462614", "Wairoa",
"6499010", "Kaitaia",
"6463922", "Palmerston\ North",
"6479091", "Taupo",
"643966", "Christchurch",
"647961", "Hamilton",
"6462106", "Pahiatua",
"6462605", "Marton",
"6462152", "New\ Plymouth",
"6478993", "Waihi",
"644889", "Wellington",
"643446", "Roxburgh",
"6465623", "Opunake",
"6479004", "Te\ Awamutu",
"6432995", "Winton",
"6439283", "Rangiora",
"6468807", "Gisborne",
"6493991", "Pukekohe",
"647823", "Hamilton",
"6468244", "Waipukurau",
"6496014", "Dargaville",
"6468808", "Palmerston\ North",
"6437447", "Greymouth",
"6434237", "Culverden",
"6434995", "Te\ Anau",
"6432718", "Rangiora",
"6433917", "Franz\ Josef",
"643246", "Tokanui",
"6434238", "Waitangi\ \(Chatham\ Is\.\)",
"6437448", "Haast",
"6432717", "Kaikoura",
"6435519", "Twizel",
"6475613", "Te\ Awamutu",
"646347", "Wanganui",
"6433918", "Fox\ Glacier",
"6435663", "Twizel",
"6437483", "Otautau",
"647216", "Rotorua",
"6499012", "Kawakawa",
"6463920", "Palmerston\ North",
"6479240", "Taupo",
"6472816", "Morrinsville",
"643211", "Invercargill",
"647871", "Te\ Awamutu",
"6434277", "Ranfurly",
"647869", "Thames",
"649966", "Auckland",
"6462224", "Masterton",
"6434221", "Invercargill",
"6478095", "Taupo",
"646274", "Hawera",
"6466999", "New\ Plymouth",
"6499065", "Helensville",
"644299", "Paraparaumu",
"6473934", "Rotorua",
"6434278", "Roxburgh",
"6439010", "Queenstown",
"647922", "Whakatane",
"646343", "Wanganui",
"6439860", "Nelson",
"649409", "Kaitaia",
"6467774", "Dannevirke",
"6434264", "Kurow",
"643660", "Christchurch",
"6479229", "Opotiki",
"6494315", "Warkworth",
"646382", "Taihape",
"646844", "Napier\/Hastings",
"6437771", "Blenheim",
"6439766", "Balclutha",
"6479716", "Waihi",
"6496007", "Helensville",
"6466554", "Hawera",
"6436641", "Lawrence",
"644499", "Wellington",
"6496008", "Hibiscus\ Coast",
"6432221", "Nelson",
"6468814", "Dannevirke",
"6463901", "Gisborne",
"643951", "Dunedin",
"6437452", "Akaroa",
"6439067", "Franz\ Josef",
"647827", "Hamilton",
"647306", "Whakatane",
"6479018", "Putaruru\/Tokoroa",
"6439068", "Fox\ Glacier",
"6469277", "Gisborne",
"6493933", "Kaikohe",
"649918", "Auckland",
"6498823", "Kaitaia",
"6437461", "Fairlie",
"643221", "Invercargill",
"6444889", "Paraparaumu",
"6469278", "Gisborne",
"643332", "Christchurch",
"6468691", "Gisborne",
"644938", "Wellington",
"6432642", "Fox\ Glacier",
"6439455", "Otautau",
"643437", "Oamaru",
"6472130", "Tauranga",
"647357", "Rotorua",
"646768", "New\ Plymouth",
"6449081", "Paraparaumu",
"6439701", "Nelson",
"6462818", "New\ Plymouth",
"6466522", "Palmerston\ North",
"6435500", "Christchurch",
"6448880", "Paraparaumu",
"6462817", "Napier",
"644488", "Wellington",
"6439521", "Dunedin",
"6435681", "Invercargill",
"6479753", "Taupo",
"6479295", "Whakatane",
"6436634", "Mt\ Cook",
"6432623", "Lawrence",
"6469317", "Pahiatua",
"6435672", "Balclutha",
"6499556", "Maungaturoto",
"643421", "Christchurch",
"6469318", "Levin",
"6432726", "Franz\ Josef",
"643393", "Christchurch",
"6439749", "Christchurch",
"6499458", "Kawakawa",
"6499873", "Kaitaia",
"6472828", "Tauranga",
"6467555", "New\ Plymouth",
"6436562", "Balclutha",
"6435538", "Lumsden",
"6432739", "Balclutha",
"6439320", "Akaroa",
"647390", "Hamilton",
"6472827", "Tauranga",
"6499457", "Kaitaia",
"6435537", "Winton",
"6478139", "Whangamata",
"6449122", "Wellington",
"649405", "Kaikohe",
"6478076", "Te\ Awamutu",
"6499423", "Great\ Barrier\ Island",
"6499003", "Warkworth",
"6467529", "Mokau",
"6469200", "Gisborne",
"6474650", "Morrinsville",
"646376", "Pahiatua",
"6468253", "Marton",
"6432801", "Lumsden",
"6436591", "Nelson",
"646946", "Masterton",
"647865", "Whangamata",
"6475602", "Hamilton",
"6469016", "Ohakune",
"646752", "New\ Plymouth",
"6432658", "Murchison",
"6479841", "Huntly",
"6439720", "Blenheim",
"6432657", "Motueka",
"643484", "Dunedin",
"6439292", "Timaru",
"6469304", "Wairoa",
"647854", "Hamilton",
"649458", "Dargaville",
"6462804", "Palmerston\ North",
"644495", "Wellington",
"643942", "Christchurch",
"643433", "Oamaru",
"6462411", "New\ Plymouth",
"6432446", "Blenheim",
"647980", "Hamilton",
"6496518", "Kawakawa",
"6436610", "Kaikoura",
"643756", "Hokitika",
"6472146", "Otorohanga",
"6475483", "Tauranga",
"6479026", "Paeroa",
"6439009", "Greymouth",
"6462161", "Masterton",
"6499630", "Pukekohe",
"6498858", "Kaikohe",
"6496517", "Kaitaia",
"643983", "Christchurch",
"647903", "Hamilton",
"6462124", "Marton",
"6498857", "Dargaville",
"6439457", "Winton",
"6449030", "Paraparaumu",
"6469202", "Levin",
"6474652", "Paeroa",
"649583", "Auckland",
"6495538", "Auckland",
"644666", "Wellington",
"6493939", "Auckland",
"6439873", "Wanaka",
"6439458", "Edendale",
"647345", "Rotorua",
"6469275", "Wanganui",
"6449120", "Wellington",
"649810", "Auckland",
"6439290", "Christchurch",
"6462815", "Wairoa",
"649421", "Hibiscus\ Coast",
"6439722", "Blenheim",
"647895", "Taumarunui",
"6434405", "Alexandra",
"6475600", "Hamilton",
"649237", "Pukekohe",
"647378", "Taupo",
"644804", "Wellington",
"6433951", "Timaru",
"6449008", "Paraparaumu",
"6479298", "Taupo",
"646654", "Gisborne",
"6432629", "Roxburgh",
"6469315", "Taihape",
"6432751", "Riverton",
"6472606", "Huntly",
"6443331", "Wellington",
"6479297", "Tauranga",
"6478594", "Hamilton",
"644590", "Wellington",
"6435535", "Invercargill",
"6467558", "New\ Plymouth",
"6499455", "Dargaville",
"644465", "Wellington",
"649473", "Auckland",
"6432733", "Geraldine",
"6466549", "Ruatoria",
"6469611", "Wanganui",
"6478133", "Putaruru\/Tokoroa",
"6467557", "New\ Plymouth",
"6498901", "Pukekohe",
"6499476", "Auckland",
"6439743", "Christchurch",
"6436612", "Akaroa",
"6499879", "Warkworth",
"6436504", "Cheviot",
"6432636", "Te\ Anau",
"643681", "Timaru",
"6468259", "Levin",
"6472132", "Taupo",
"6432640", "Hokitika",
"649983", "Whangarei",
"6436517", "Motueka",
"6434296", "Greymouth",
"6469715", "Mokau",
"6499009", "Auckland",
"6436518", "Murchison",
"649477", "Auckland",
"6432655", "Nelson",
"6475621", "Tauranga",
"6474648", "Huntly",
"649292", "Auckland",
"6435502", "Christchurch",
"6439343", "Waimate",
"6435556", "Fairlie",
"64497", "Wellington",
"6466520", "Palmerston\ North",
"6468991", "Gisborne",
"6469854", "Waipukurau",
"647888", "Matamata",
"6434351", "Mt\ Cook",
"649847", "Auckland",
"6435670", "Palmerston",
"6499041", "Helensville",
"6495564", "Whangarei",
"6498855", "Kawakawa",
"6439535", "Fairlie",
"6439851", "Culverden",
"644213", "Wellington",
"6432887", "Nelson",
"6496515", "Dargaville",
"6465611", "Napier",
"6439322", "Culverden",
"6439003", "Ashburton",
"6436560", "Palmerston",
"64925", "Auckland",
"644240", "Wellington",
"6432888", "Nelson",
"644202", "Wellington",
"649233", "Pukekohe",
"644914", "Wellington",
"649889", "Auckland",
"643981", "Christchurch",
"647986", "Hamilton",
"6495562", "Whangarei",
"6436630", "Takaka",
"647351", "Rotorua",
"643469", "Dunedin",
"6496009", "Pukekohe",
"6439324", "Darfield",
"646326", "Palmerston\ North",
"643431", "Oamaru",
"649600", "Auckland",
"643750", "Haast",
"6479019", "Whangamata",
"6462101", "Levin",
"6439069", "Haast",
"6472811", "Tauranga",
"646370", "Masterton",
"646214", "Gisborne",
"6466998", "New\ Plymouth",
"6478093", "Rotorua",
"6434279", "Twizel",
"6499063", "Hibiscus\ Coast",
"6466997", "New\ Plymouth",
"644928", "Wellington",
"649634", "Auckland",
"643524", "Takaka",
"643231", "Invercargill",
"6494313", "Warkworth",
"6469852", "Napier",
"6435504", "Christchurch",
"6469029", "Opunake",
"6462149", "Ruatoria",
"6475615", "Waihi",
"647846", "Hamilton",
"649949", "Auckland",
"6432719", "Waitangi\ \(Chatham\ Is\.\)",
"6435665", "Waimate",
"6435517", "Lawrence",
"646965", "Wanganui\ W100",
"6437449", "Hokitika",
"6434239", "Christchurch",
"6478592", "Hamilton",
"6434993", "Alexandra",
"6433919", "Haast",
"649299", "Auckland",
"6435518", "Milton",
"6462800", "Palmerston\ North",
"6469040", "Wairoa",
"6462120", "Palmerston\ North",
"6437485", "Te\ Anau",
"6436614", "Timaru",
"6436502", "Amberley",
"6434226", "Lumsden",
"6465625", "Gisborne",
"6474654", "Taumarunui",
"6432993", "Balclutha",
"646304", "Featherston",
"646368", "Levin",
"644209", "Wellington",
"646954", "Palmerston\ North\ W100",
"647220", "Tauranga",
"6478995", "Matamata",
"6463906", "Napier",
"6462603", "Palmerston\ North",
"643732", "Greymouth",
"6439724", "Blenheim",
"6432226", "Timaru",
"643924", "Christchurch",
"6469300", "Gisborne",
"644528", "Wellington",
"6436646", "Roxburgh",
"6435560", "Mt\ Cook",
"6479711", "Whangamata",
"6439285", "Invercargill",
"6468809", "Masterton",
"6439761", "Kurow",
"6437776", "Cromwell",
"6462802", "Palmerston\ North",
"647366", "Rotorua",
"644551", "Paraparaumu",
"6478590", "Hamilton",
"649427", "Hibiscus\ Coast",
"644211", "Wellington",
"6439063", "Westport",
"6436500", "Christchurch",
"6469291", "Gisborne",
"6462122", "Palmerston\ North",
"6436681", "Dunedin",
"643339", "Christchurch",
"6499069", "Pukekohe",
"6466995", "Opunake",
"6434273", "Lawrence",
"6499819", "Helensville",
"6449124", "Wellington",
"649431", "Maungaturoto",
"6498690", "Kawakawa",
"646278", "Hawera",
"6435562", "Invercargill",
"6475604", "Hamilton",
"6468886", "Wanganui",
"6433996", "Edendale",
"6439294", "Dunedin",
"6469302", "Napier",
"643683", "Timaru",
"6497776", "Hibiscus\ Coast",
"6435674", "Milton",
"6434233", "Rangiora",
"6437443", "Nelson",
"6495560", "Whangarei",
"6435668", "Kurow",
"6436632", "Murchison",
"6432616", "Ashburton",
"6475618", "Opotiki",
"646385", "Ohakune",
"646759", "New\ Plymouth",
"6434999", "Dunedin",
"6433913", "Murchison",
"6432713", "Ashburton",
"6435515", "Oamaru",
"6492226", "Helensville",
"6435667", "Waitangi\ \(Chatham\ Is\.\)",
"6475617", "Whakatane",
"647925", "Tauranga",
"6436564", "Milton",
"6436578", "Wanaka",
"6447771", "Paraparaumu",
"6437487", "Winton",
"643687", "Timaru",
"6436577", "Cromwell",
"6436521", "Greymouth",
"6498816", "Great\ Barrier\ Island",
"649816", "Auckland",
"643767", "Greymouth",
"6462609", "Pahiatua",
"646835", "Napier\/Hastings",
"6478997", "Morrinsville",
"649391", "Auckland",
"6432999", "Invercargill",
"6432644", "Westport",
"6478998", "Hamilton",
"649423", "Warkworth",
"6465627", "Levin",
"6466524", "Ohakune",
"6439287", "Oamaru",
"6468803", "Gisborne",
"6469850", "Napier",
"6439288", "Ashburton",
"6462425", "Masterton",
"643949", "Dunedin",
"649581", "Auckland",
"649666", "Auckland",
"644810", "Wellington",
"643288", "Christchurch",
"644894", "Wellington",
"6468812", "Waiouru",
"6466552", "New\ Plymouth",
"643960", "Christchurch",
"643335", "Christchurch",
"64957", "Auckland",
"6437454", "Ashburton",
"649557", "Auckland",
"6439005", "Invercargill",
"647858", "Hamilton",
"644393", "Paraparaumu",
"6496513", "Whangarei",
"6432889", "Blenheim",
"6498853", "Whangarei",
"6439533", "Geraldine",
"6468258", "Waiouru",
"6432631", "Gore",
"647464", "Hamilton",
"6499007", "Kaikohe",
"6439081", "Ashburton",
"6499471", "Hibiscus\ Coast",
"6469713", "Stratford",
"64948", "Auckland",
"6462222", "Ohakune",
"6468257", "Taihape",
"643488", "Dunedin",
"6478080", "Hamilton",
"6467772", "Hawera",
"6469616", "Featherston",
"6434262", "Alexandra",
"6499428", "Warkworth",
"6473932", "Rotorua",
"6499008", "Pukekohe",
"6463990", "Featherston",
"6436519", "Takaka",
"6467525", "Mokau",
"649953", "Auckland",
"6442820", "Wellington",
"6432756", "Gore",
"6472601", "Hamilton",
"643651", "Nelson",
"6439345", "Christchurch",
"644437", "Wellington",
"6474649", "Matamata",
"6432653", "Wanaka",
"649590", "Auckland",
"6433956", "Dunedin",
"6439750", "Kaikoura",
"6432627", "Alexandra",
"6468996", "Napier",
"6435551", "Franz\ Josef",
"6479299", "Rotorua",
"6469313", "Marton",
"6475626", "Taupo",
"6432628", "Ranfurly",
"6499101", "Pukekohe",
"649957", "Pukekohe",
"6467559", "New\ Plymouth",
"64997", "Auckland",
"6466548", "Ruatoria",
"644292", "Paraparaumu",
"647862", "Paeroa",
"6439745", "Greymouth",
"6499877", "Maungaturoto",
"6434291", "Westport",
"649402", "Kawakawa",
"6478135", "Te\ Kuiti",
"6499014", "Dargaville",
"6498882", "Whangarei",
"6435533", "Murchison",
"644900", "Wellington",
"649826", "Auckland",
"6499453", "Warkworth",
"6499878", "Warkworth",
"6432735", "Mt\ Cook",
"643978", "Christchurch",
"6472823", "Whakatane",
"6462610", "Napier",
"6493937", "Warkworth",
"6469273", "New\ Plymouth",
"646764", "Stratford",
"6499747", "Dargaville",
"6439875", "Ranfurly",
"6462154", "New\ Plymouth",
"6494700", "Whangarei",
"6479002", "Matamata",
"646839", "Napier\/Hastings",
"6465616", "Hawera",
"6493938", "Auckland",
"6495539", "Auckland",
"6479422", "Tauranga",
"6439459", "Tokanui",
"643696", "Geraldine",
"644587", "Wellington",
"6439856", "Darfield",
"6499748", "Whangarei",
"6499046", "Pukekohe",
"64953", "Auckland",
"646861", "Gisborne",
"649914", "Auckland",
"6496012", "Kawakawa",
"6469890", "Gisborne",
"643538", "Nelson",
"649213", "Auckland",
"644934", "Wellington",
"6468242", "Ruatoria",
"6472620", "Tauranga",
"6462813", "Wanganui",
"6435686", "Gore",
"6439526", "Twizel",
"647892", "Taumarunui",
"643303", "Ashburton\/Akaroa\/Chatham\ Islands",
"643590", "Christchurch",
"643465", "Palmerston",
"644918", "Wellington",
"6439706", "Nelson",
"643417", "Milton",
"6439752", "Cheviot",
"6496519", "Maungaturoto",
"6479244", "Tauranga",
"6498880", "Helensville",
"6463924", "Marton",
"6439008", "Timaru",
"647884", "Morrinsville",
"6498859", "Kaitaia",
"647544", "Tauranga",
"6437466", "Cromwell",
"6439007", "Dunedin",
"6473946", "Taupo",
"643217", "Invercargill",
"6479000", "Hamilton",
"6494702", "Whangarei",
"647833", "Hamilton",
"647877", "Te\ Kuiti",
"6479420", "Tauranga",
"6468255", "Pahiatua",
"643454", "Dunedin",
"644462", "Wellington",
"6499425", "Auckland",
"6499005", "Auckland",
"64357", "Blenheim",
"6469468", "Featherston",
"6472622", "Tauranga",
"6432659", "Takaka",
"6432721", "Motueka",
"647334", "Rotorua",
"6469892", "Gisborne",
"6496010", "Kaitaia",
"646341", "Wanganui",
"6439347", "Christchurch",
"6499551", "Whangarei",
"643666", "Christchurch",
"6439266", "Dunedin",
"649295", "Auckland",
"643213", "Invercargill",
"6435526", "Kurow",
"6466550", "New\ Plymouth",
"6468810", "Ohakune",
"647873", "Otorohanga",
"647837", "Hamilton",
"6479846", "Taumarunui",
"646969", "New\ Plymouth",
"6432625", "Twizel",
"6469319", "Masterton",
"6479293", "Hamilton",
"64962", "Auckland",
"6439046", "Kurow",
"6432737", "Palmerston",
"6439748", "Dunedin",
"6439070", "Motueka",
"6472829", "Tauranga",
"6499459", "Maungaturoto",
"6436596", "Queenstown",
"647374", "Taupo",
"6432806", "Edendale",
"647210", "Hamilton",
"6478137", "Thames",
"6435539", "Otautau",
"6439747", "Wanaka",
"6499875", "Dargaville",
"6432738", "Oamaru",
"6467553", "New\ Plymouth",
"6478071", "Otorohanga",
"6478138", "Waihi",
"6439453", "Te\ Anau",
"649348", "Auckland",
"643307", "Ashburton\/Akaroa\/Chatham\ Islands",
"6495533", "Whangarei",
"6473930", "Waihi",
"6463992", "Levin",
"6478082", "Tauranga",
"644205", "Wellington",
"6467770", "Gisborne",
"6434260", "Oamaru",
"6444888", "Paraparaumu",
"6439864", "Takaka",
"6498825", "Maungaturoto",
"6469279", "Levin",
"6462220", "New\ Plymouth",
"6479021", "Te\ Awamutu",
"6472141", "Te\ Kuiti",
"6462166", "Opunake",
"6493935", "Kawakawa",
"643957", "Timaru",
"643413", "Balclutha",
"64334", "Christchurch",
"6444887", "Paraparaumu",
"6432441", "Christchurch",
"6462416", "Waipukurau",
"6462819", "Levin",
"646856", "Waipukurau",
"6472119", "Thames",
"6469001", "New\ Plymouth",
"6469309", "Mokau",
"643667", "Christchurch",
"6439276", "Nelson",
"644525", "Wellington",
"6494312", "Warkworth",
"6469853", "Wairoa",
"6468800", "Napier\/Hastings",
"643615", "Timaru",
"6439344", "Timaru",
"647551", "Tauranga",
"6478092", "Huntly",
"646365", "Palmerston\ North",
"643216", "Invercargill",
"6432816", "Waimate",
"647211", "Hamilton",
"6469576", "Dannevirke",
"6499062", "Hibiscus\ Coast",
"649349", "Auckland",
"647876", "Te\ Kuiti",
"6462129", "Waiouru",
"6437476", "Ranfurly",
"6439316", "Edendale",
"6463927", "Dannevirke",
"6479247", "Hamilton",
"649632", "Auckland",
"6436586", "Edendale",
"643441", "Queenstown",
"6437455", "Cheviot",
"643522", "Nelson",
"6439004", "Gore",
"6463928", "Pahiatua",
"646968", "New\ Plymouth\ W100",
"6432710", "Christchurch",
"6433910", "Nelson",
"6462809", "Napier\/Hastings",
"6495563", "Whangarei",
"6437440", "Nelson",
"6434230", "Christchurch",
"6434246", "Waitangi\ \(Chatham\ Is\.\)",
"6477771", "Whakatane",
"6468821", "Featherston",
"6439716", "Geraldine",
"64687", "Napier\/Hastings",
"649650", "Auckland",
"646857", "Waipukurau",
"6469020", "Stratford",
"6472221", "Tauranga",
"643742", "Dunedin",
"6432992", "Gore",
"6439017", "Cromwell",
"643956", "Timaru",
"6439868", "Blenheim",
"643306", "Ashburton\/Akaroa\/Chatham\ Islands",
"647386", "Taupo",
"6439018", "Ranfurly",
"6434270", "Oamaru",
"6462602", "Palmerston\ North",
"6496509", "Pukekohe",
"6462155", "Hawera",
"6439874", "Cromwell",
"6478134", "Taumarunui",
"6499015", "Dargaville",
"6432734", "Waimate",
"6479010", "Thames",
"643922", "Nelson",
"6439060", "Greymouth",
"6436626", "Akaroa",
"6436503", "Ashburton",
"6439744", "Queenstown",
"646952", "Palmerston\ North\ W100",
"6478593", "Hamilton",
"6435696", "Haast",
"6434992", "Ranfurly",
"647836", "Hamilton",
"6436639", "Oamaru",
"643539", "Nelson",
"644436", "Wellington",
"6435563", "Queenstown",
"6469022", "Hawera",
"6469303", "Waipukurau",
"6473991", "Whakatane",
"647325", "Opotiki",
"6462600", "Palmerston\ North",
"6499004", "Hibiscus\ Coast",
"6434272", "Alexandra",
"644901", "Wellington",
"6499424", "Auckland",
"646838", "Wairoa",
"6477886", "Rotorua",
"6432990", "Lumsden",
"6468254", "Ohakune",
"6499461", "Whangarei",
"647928", "Tauranga",
"643979", "Christchurch",
"6437457", "Darfield",
"649216", "Auckland",
"6465606", "Waiouru",
"6479245", "Matamata",
"6462123", "Palmerston\ North",
"6434281", "Queenstown",
"6463925", "Waiouru",
"6435996", "Akaroa",
"6437458", "Kaikoura",
"6495569", "Maungaturoto",
"6462803", "Palmerston\ North",
"6434990", "Queenstown",
"643693", "Geraldine",
"646388", "Taihape",
"6465950", "Palmerston\ North",
"6468802", "New\ Plymouth",
"6479754", "Tauranga",
"6499810", "Hibiscus\ Coast",
"6462157", "Stratford",
"6498824", "Kawakawa",
"643697", "Geraldine",
"644586", "Wellington",
"643489", "Dunedin",
"6478090", "Thames",
"6493934", "Kaitaia",
"6439091", "Rangiora",
"6462158", "Opunake",
"6439015", "Wanaka",
"6462621", "New\ Plymouth",
"646845", "Napier\/Hastings",
"649869", "Auckland",
"643961", "Christchurch",
"6439865", "Murchison",
"6436509", "Waitangi\ \(Chatham\ Is\.\)",
"6499874", "Kawakawa",
"6499018", "Maungaturoto",
"649827", "Auckland",
"649956", "Auckland",
"6499017", "Kaikohe",
"6436651", "Riverton",
"6478599", "Hamilton",
"6437442", "Murchison",
"6434232", "Ashburton",
"6436633", "Geraldine",
"6432624", "Milton",
"6433912", "Motueka",
"6432712", "Amberley",
"6432661", "Christchurch",
"6472196", "Taupo",
"6472611", "Matamata",
"6499716", "Helensville",
"6496881", "Auckland",
"6475607", "Morrinsville",
"643948", "Invercargill",
"6435505", "Akaroa",
"6439298", "Motueka",
"6496991", "Kaikohe",
"6475608", "Otorohanga",
"6432652", "Cromwell",
"6472629", "Taupo",
"649452", "Auckland",
"6432606", "Dunedin",
"6439297", "Takaka",
"64937", "Auckland",
"6478451", "Hamilton",
"6462223", "Palmerston\ North",
"6469712", "New\ Plymouth",
"644892", "Paraparaumu",
"6434263", "Lawrence",
"6467773", "Wanganui",
"6495530", "Great\ Barrier\ Island",
"6439886", "Haast",
"6473933", "Rotorua",
"6439450", "Invercargill",
"6467550", "New\ Plymouth",
"649390", "Auckland",
"6435956", "Christchurch",
"6496512", "Whangarei",
"6462619", "Featherston",
"6439325", "Kaikoura",
"6498852", "Warkworth",
"6439073", "Motueka",
"6439532", "Timaru",
"647315", "Opotiki",
"649840", "Auckland",
"6479290", "Hamilton",
"649580", "Auckland",
"6439759", "Cromwell",
"649426", "Hibiscus\ Coast",
"649813", "Auckland",
"6468813", "Taihape",
"646758", "New\ Plymouth",
"6466553", "New\ Plymouth",
"6499295", "Kaikohe",
"647462", "Taupo",
"644210", "Wellington",
"6492831", "Maungaturoto",
"644572", "Wellington",
"649404", "Kawakawa",
"6439284", "Blenheim",
"6466527", "Taihape",
"6434402", "Alexandra",
"647864", "Thames",
"6496013", "Whangarei",
"649230", "Pukekohe",
"6439725", "Christchurch",
"6433986", "Queenstown",
"644550", "Wellington",
"646279", "Hawera",
"6468243", "Napier",
"6466528", "Dannevirke",
"6462812", "Napier\/Hastings",
"6469272", "Featherston",
"6478994", "Tauranga",
"6479851", "Waihi",
"6432648", "Geraldine",
"6479003", "Thames",
"6463999", "Palmerston\ North",
"6465624", "Featherston",
"643485", "Lawrence",
"6474655", "Te\ Kuiti",
"649817", "Auckland",
"6466006", "Opunake",
"6435886", "Invercargill",
"6432647", "Fairlie",
"644494", "Wellington",
"643338", "Christchurch",
"643686", "Timaru",
"6436615", "Ashburton",
"649903", "Auckland",
"6437484", "Riverton",
"6436567", "Ranfurly",
"647855", "Hamilton",
"649912", "Auckland",
"6469281", "Wairoa",
"6498883", "Whangarei",
"6435532", "Motueka",
"6436568", "Roxburgh",
"6499452", "Warkworth",
"64933", "Auckland",
"6472822", "Rotorua",
"649980", "Auckland",
"6449740", "Paraparaumu",
"6499728", "Dargaville",
"6435677", "Ranfurly",
"6469312", "Ohakune",
"646762", "Stratford",
"6475614", "Thames",
"6499727", "Whangarei",
"6435664", "Timaru",
"6435678", "Roxburgh",
"6469246", "Palmerston\ North",
"6439295", "Nelson",
"6472623", "Tauranga",
"6462810", "Gisborne",
"6473926", "Taumarunui",
"6435508", "Cheviot",
"6469893", "Ruatoria",
"6434400", "Alexandra",
"647974", "Hamilton",
"647542", "Tauranga",
"6435507", "Ashburton",
"647882", "Putaruru\/Tokoroa",
"644529", "Wellington",
"6445951", "Wellington",
"6475605", "Huntly",
"6463944", "Featherston",
"6467779", "Masterton",
"6434269", "Twizel",
"646369", "Levin",
"6494703", "Whangarei",
"6475826", "Hamilton",
"643270", "Christchurch",
"6466994", "Ohakune",
"647843", "Hamilton",
"643390", "Christchurch",
"6469270", "Marton",
"647894", "Taumarunui",
"6499450", "Warkworth",
"6433941", "Blenheim",
"6472820", "Hamilton",
"644805", "Wellington",
"6462613", "Waipukurau",
"6435530", "Nelson",
"6463916", "Mokau",
"643226", "Otautau",
"6439327", "Ashburton",
"6439079", "Murchison",
"6439731", "Gore",
"6478141", "Taupo",
"647332", "Rotorua",
"646327", "Marton",
"6432741", "Milton",
"6468819", "Mokau",
"6499297", "Hibiscus\ Coast",
"64337", "Christchurch",
"649298", "Auckland",
"643452", "Wanaka",
"6466559", "Mokau",
"644464", "Wellington",
"6436991", "Culverden",
"6469310", "Wanganui",
"6499298", "Pukekohe",
"647987", "Tauranga",
"649948", "Auckland",
"6439753", "Amberley",
"6462424", "Wanganui",
"6496019", "Auckland",
"6439727", "Dunedin",
"647350", "Rotorua",
"6468249", "Opunake",
"6439331", "Greymouth",
"6432650", "Christchurch",
"647372", "Taupo",
"6466525", "Marton",
"646323", "Palmerston\ North",
"6439728", "Franz\ Josef",
"643980", "Christchurch",
"6432645", "Greymouth",
"6439452", "Gore",
"6495532", "Warkworth",
"6439026", "Riverton",
"6479009", "Hamilton",
"6463993", "Pahiatua",
"643751", "Fox\ Glacier",
"6478083", "Hamilton",
"6474657", "Thames",
"64926", "Auckland",
"643430", "Mt\ Cook",
"6469710", "New\ Plymouth",
"647983", "Hamilton",
"643903", "Christchurch",
"6474658", "Waihi",
"6435546", "Greymouth",
"6439530", "Timaru",
"6474446", "Otorohanga",
"6498850", "Great\ Barrier\ Island",
"6496510", "Whangarei",
"6436618", "Blenheim",
"6472801", "Huntly",
"6467552", "New\ Plymouth",
"6436565", "Twizel",
"6436617", "Cromwell",
"6472121", "Te\ Kuiti",
"6435514", "Palmerston",
"64354", "Nelson",
"6499725", "Hibiscus\ Coast",
"6479500", "Whakatane",
"643230", "Invercargill",
"643468", "Dunedin",
"644915", "Wellington",
"647847", "Hamilton",
"6435675", "Twizel",
"649888", "Auckland",
"6479292", "Hamilton",
"6437460", "Waitangi\ \(Chatham\ Is\.\)",
"6474449", "Opotiki",
"6468690", "Gisborne",
"644905", "Paraparaumu",
"6472131", "Rotorua",
"6472814", "Putaruru\/Tokoroa",
"649588", "Auckland",
"6449080", "Paraparaumu",
"6439700", "Nelson",
"6468992", "Wairoa",
"647547", "Tauranga",
"647887", "Morrinsville",
"6435501", "Christchurch",
"646750", "Mokau",
"6475622", "Tauranga",
"6496995", "Maungaturoto",
"6495588", "Hibiscus\ Coast",
"6435680", "Dunedin",
"6439520", "Dunedin",
"6499042", "Hibiscus\ Coast",
"6436998", "Blenheim",
"643940", "Christchurch",
"643214", "Invercargill",
"647982", "Hamilton",
"649478", "Auckland",
"6479109", "Opotiki",
"6479708", "Thames",
"6496016", "Warkworth",
"6433983", "Ranfurly",
"643457", "Dunedin",
"64347", "Dunedin",
"6436997", "Motueka",
"6468246", "Hawera",
"6432747", "Queenstown",
"6439738", "Winton",
"646322", "Marton",
"6435549", "Hokitika",
"6462104", "Marton",
"6433948", "Kaikoura",
"6442608", "Paraparaumu",
"6439029", "Tokanui",
"6465612", "Waipukurau",
"6479006", "Taupo",
"6439321", "Amberley",
"6439737", "Tokanui",
"6432748", "Cromwell",
"6439852", "Cheviot",
"6433947", "Darfield",
"6466003", "Ruatoria",
"6435883", "Dunedin",
"6479855", "Taupo",
"643965", "Christchurch",
"6462118", "Waipukurau",
"647834", "Hamilton",
"6435953", "Christchurch",
"6439055", "Fairlie",
"6474651", "Otorohanga",
"6469201", "Ruatoria",
"6436590", "Nelson",
"6432800", "Te\ Anau",
"643453", "Dunedin",
"6472420", "Hamilton",
"6473339", "Taupo",
"6439040", "Balclutha",
"6492835", "Kaikohe",
"6439338", "Queenstown",
"649988", "Whangarei",
"6439764", "Lawrence",
"643736", "Greymouth",
"647377", "Taupo",
"6479714", "Huntly",
"644815", "Wellington",
"6439721", "Blenheim",
"6468816", "Hawera",
"6439337", "Wanaka",
"6466556", "Stratford",
"643304", "Ashburton\/Akaroa\/Chatham\ Islands",
"6443332", "Wellington",
"64936", "Auckland",
"6432752", "Te\ Anau",
"6472128", "Waihi",
"6473929", "Thames",
"6433952", "Fairlie",
"649238", "Pukekohe",
"6469249", "Masterton",
"6462410", "New\ Plymouth",
"6472127", "Paeroa",
"6436611", "Rangiora",
"6432427", "Greymouth",
"6462160", "Masterton",
"647883", "Putaruru\/Tokoroa",
"647543", "Tauranga",
"6499631", "Pukekohe",
"6462226", "Napier",
"6472807", "Te\ Awamutu",
"6469285", "Hawera",
"6432428", "Queenstown",
"6467776", "Levin",
"6434266", "Palmerston",
"6479746", "Opotiki",
"6439883", "Hokitika",
"6475829", "Hamilton",
"6472808", "Putaruru\/Tokoroa",
"6474443", "Matamata",
"6436592", "Nelson",
"6432802", "Gore",
"647215", "Rotorua",
"6449031", "Paraparaumu",
"646763", "Opunake",
"644897", "Wellington",
"6449121", "Wellington",
"649554", "Hibiscus\ Coast",
"6439291", "Dunedin",
"6496997", "Hibiscus\ Coast",
"649913", "Auckland",
"6479842", "Matamata",
"649214", "Auckland",
"649902", "Warkworth",
"6496998", "Helensville",
"6475601", "Hamilton",
"649940", "Auckland",
"6439042", "Oamaru",
"6445955", "Wellington",
"6433989", "Waimate",
"6462412", "Gisborne",
"6433950", "Waitangi\ \(Chatham\ Is\.\)",
"6436995", "Westport",
"647362", "Rotorua",
"6432750", "Invercargill",
"6442429", "Paraparaumu",
"6443330", "Wellington",
"6463996", "Palmerston\ North",
"6439023", "Te\ Anau",
"6433945", "Cheviot",
"6439735", "Lumsden",
"6435889", "Timaru",
"6469610", "Wanganui",
"643445", "Cromwell",
"6478086", "Hamilton",
"6436684", "Dunedin",
"6466009", "Waiouru",
"6498900", "Pukekohe",
"64927", "Auckland",
"6462162", "Masterton",
"6432745", "Roxburgh",
"6469294", "Palmerston\ North",
"6435543", "Tokanui",
"6462616", "Ruatoria",
"647463", "Whakatane",
"6463913", "Hawera",
"6462115", "Wairoa",
"6432641", "Franz\ Josef",
"647305", "Whakatane",
"6468692", "Gisborne",
"649812", "Auckland",
"6492008", "Hibiscus\ Coast",
"6479858", "Whakatane",
"6492428", "Hibiscus\ Coast",
"6439057", "Waimate",
"6437462", "Geraldine",
"6492427", "Warkworth",
"6492007", "Warkworth",
"6479857", "Opotiki",
"6435682", "Riverton",
"6439522", "Dunedin",
"649954", "Auckland",
"6439335", "Haast",
"6492838", "Pukekohe",
"6475620", "Tauranga",
"6466521", "Palmerston\ North",
"6474639", "Opotiki",
"6492837", "Hibiscus\ Coast",
"6439702", "Nelson",
"64336", "Christchurch",
"6468990", "Ruatoria",
"6439756", "Akaroa",
"6449082", "Wellington",
"649880", "Auckland",
"644577", "Wellington",
"6472626", "Rotorua",
"6469243", "New\ Plymouth",
"6432609", "Mt\ Cook",
"6472125", "Huntly",
"6473923", "Otorohanga",
"6479045", "Taumarunui",
"6434350", "Twizel",
"6435671", "Oamaru",
"644893", "Wellington",
"6443708", "Paraparaumu",
"6499040", "Helensville",
"6439850", "Ashburton",
"649917", "Auckland",
"6436524", "Hokitika",
"64943", "Whangarei",
"6473843", "Taupo",
"6475823", "Hamilton",
"6494706", "Whangarei",
"6469287", "Ohakune",
"6465610", "Napier",
"6436561", "Oamaru",
"6472805", "Morrinsville",
"646949", "Levin\ W100",
"646379", "Masterton",
"643260", "Christchurch",
"643438", "Kurow",
"649965", "Auckland",
"6432425", "Invercargill",
"6469288", "Waiouru",
"6499467", "Kaitaia",
"6436506", "Darfield",
"6436623", "Amberley",
"6432634", "Invercargill",
"6499468", "Kawakawa",
"6466010", "Taihape",
"6434222", "Gore",
"6499474", "Helensville",
"6439084", "Amberley",
"649424", "Hibiscus\ Coast",
"647828", "Huntly",
"6472199", "Opotiki",
"6469005", "Wanganui",
"6473997", "Te\ Kuiti",
"643249", "Te\ Anau",
"6499719", "Whangarei",
"6473998", "Taumarunui",
"6435693", "Nelson",
"6472604", "Hamilton",
"6434243", "Akaroa",
"6432222", "Christchurch",
"6439713", "Mt\ Cook",
"6436642", "Milton",
"6468303", "Napier",
"6468880", "Napier\/Hastings",
"6437772", "Timaru",
"646651", "Napier",
"6493207", "Hibiscus\ Coast",
"6434287", "Queenstown",
"6493208", "Helensville",
"643449", "Alexandra",
"644886", "Wellington",
"6437451", "Blenheim",
"6463902", "Gisborne",
"644801", "Wellington",
"6434288", "Cromwell",
"6437473", "Milton",
"6435999", "Christchurch",
"6439313", "Te\ Anau",
"6439097", "Darfield",
"6498017", "Hibiscus\ Coast",
"647959", "Hamilton",
"6462627", "Wanganui",
"6436583", "Te\ Anau",
"647309", "Whakatane",
"6498018", "Whangarei",
"6462151", "New\ Plymouth",
"643692", "Geraldine",
"6465609", "Pahiatua",
"6439098", "Akaroa",
"6462628", "Wanganui",
"643755", "Hokitika",
"6477775", "Huntly",
"6468825", "Gisborne",
"6492220", "Auckland",
"649281", "Auckland",
"6436548", "Waimate",
"643684", "Timaru",
"6432610", "Darfield",
"644496", "Wellington",
"6495566", "Kaikohe",
"646348", "Wanganui",
"6436547", "Geraldine",
"6472225", "Rotorua",
"6497770", "Whangarei",
"6439273", "Blenheim",
"6432668", "Blenheim",
"6435554", "Cromwell",
"6436657", "Franz\ Josef",
"6477889", "Whakatane",
"649969", "Auckland",
"647866", "Thames",
"6468263", "Napier",
"644296", "Paraparaumu",
"646375", "Pahiatua",
"6499011", "Kaitaia",
"649822", "Auckland",
"6436658", "Fox\ Glacier",
"6479090", "Taupo",
"6469573", "Palmerston\ North",
"6432813", "Geraldine",
"6434294", "Franz\ Josef",
"649406", "Kaitaia",
"646590", "Palmerston\ North",
"6436629", "Christchurch",
"644909", "Wellington",
"647920", "Rotorua",
"646953", "Palmerston\ North\ W100",
"6499465", "Dargaville",
"644466", "Wellington",
"6496100", "Pukekohe",
"6497772", "Kaitaia",
"6499554", "Kaitaia",
"6432612", "Rangiora",
"6436636", "Waimate",
"643923", "Nelson",
"6435699", "Amberley",
"6493990", "Great\ Barrier\ Island",
"6469008", "Palmerston\ North",
"646868", "Gisborne",
"6432724", "Greymouth",
"6473995", "Putaruru\/Tokoroa",
"6472193", "Whakatane",
"6492222", "Auckland",
"6469007", "Masterton",
"643224", "Invercargill",
"643782", "Westport",
"647896", "Taumarunui",
"6439719", "Waimate",
"649249", "Auckland",
"6434249", "Kaikoura",
"6468309", "Napier",
"643743", "Christchurch",
"647346", "Rotorua",
"643527", "Motueka",
"6434285", "Cheviot",
"6463921", "Palmerston\ North",
"6479241", "Whakatane",
"6466012", "Pahiatua",
"6434220", "Invercargill",
"6436589", "Otautau",
"646213", "Wanganui",
"643481", "Dunedin",
"6472144", "Matamata",
"6465603", "Palmerston\ North",
"6462625", "Hawera",
"6439319", "Otautau",
"6439011", "Queenstown",
"6435993", "Mt\ Cook",
"6462126", "Pahiatua",
"6437479", "Edendale",
"6439861", "Nelson",
"6462806", "Napier\/Hastings",
"6477778", "Te\ Awamutu",
"643523", "Murchison",
"649633", "Auckland",
"6432444", "Nelson",
"644819", "Wellington",
"6477777", "Hamilton",
"6468827", "New\ Plymouth",
"6462139", "Palmerston\ North",
"6437770", "Nelson",
"6468882", "Napier\/Hastings",
"6469014", "Dannevirke",
"6433992", "Riverton",
"646307", "Featherston",
"6472615", "Te\ Kuiti",
"6436640", "Palmerston",
"6469306", "Hawera",
"6472116", "Thames",
"6432220", "Dunedin",
"6439279", "Christchurch",
"643206", "Edendale",
"6432819", "Christchurch",
"6469579", "Pahiatua",
"643571", "Nelson",
"6463900", "Gisborne",
"6478074", "Taumarunui",
"6477883", "Hamilton",
"647851", "Hamilton",
"6468269", "New\ Plymouth",
"6436655", "Westport",
"64338", "Christchurch",
"6469276", "Wanganui",
"6439001", "Christchurch",
"6462169", "Featherston",
"647347", "Rotorua",
"6475820", "Hamilton",
"6465613", "Wairoa",
"6466002", "Napier",
"6439853", "Amberley",
"643526", "Motueka",
"6435882", "Dunedin",
"649636", "Auckland",
"643412", "Balclutha",
"6499043", "Hibiscus\ Coast",
"6462419", "Masterton",
"6433982", "Kurow",
"649235", "Pukekohe",
"6434353", "Twizel",
"6473920", "Huntly",
"643930", "Christchurch",
"6462816", "Gisborne",
"6469240", "Gisborne",
"644555", "Wellington",
"6478128", "Huntly",
"6479849", "Thames",
"649985", "Auckland",
"6468993", "Taihape",
"6439341", "Fairlie",
"6439049", "Palmerston",
"6499557", "Warkworth",
"6472605", "Thames",
"6432728", "Haast",
"6469316", "Dannevirke",
"644818", "Wellington",
"6469004", "Napier\/Hastings",
"6435529", "Roxburgh",
"6475623", "Tauranga",
"6499558", "Great\ Barrier\ Island",
"646324", "Palmerston\ North",
"6432727", "Fox\ Glacier",
"643552", "Dunedin",
"6432635", "Riverton",
"643968", "Christchurch",
"6499475", "Hibiscus\ Coast",
"644467", "Wellington",
"647850", "Hamilton",
"6439085", "Waitangi\ \(Chatham\ Is\.\)",
"647872", "Te\ Awamutu",
"6472429", "Whakatane",
"6435536", "Invercargill",
"643212", "Invercargill",
"6472826", "Matamata",
"6499456", "Kaikohe",
"6436599", "Blenheim",
"6432809", "Hokitika",
"6478077", "Waihi",
"6435540", "Edendale",
"6434295", "Fox\ Glacier",
"6439741", "Christchurch",
"6469716", "Opunake",
"6478078", "Whangamata",
"647533", "Tauranga",
"6469613", "Levin",
"6478131", "Otorohanga",
"647921", "Rotorua",
"6439882", "Westport",
"6432731", "Timaru",
"6439020", "Gore",
"643926", "Christchurch",
"6469017", "Marton",
"6479100", "Rotorua",
"6443333", "Paraparaumu",
"6432753", "Winton",
"6439269", "Dunedin",
"644463", "Wellington",
"649475", "Auckland",
"649248", "Auckland",
"6435555", "Timaru",
"6432656", "Nelson",
"647832", "Hamilton",
"6433953", "Geraldine",
"646306", "Featherston",
"649585", "Auckland",
"649845", "Auckland",
"6432448", "Dunedin",
"6472224", "Taupo",
"6439709", "Motueka",
"647343", "Rotorua",
"6435689", "Otautau",
"6439529", "Palmerston",
"6477774", "Thames",
"6468824", "Wanganui",
"6432447", "Timaru",
"6435650", "Greymouth",
"6472147", "Paeroa",
"6479027", "Paeroa",
"6437469", "Alexandra",
"6473949", "Taupo",
"6439871", "Queenstown",
"6435952", "Christchurch",
"6442125", "Paraparaumu",
"646831", "Napier\/Hastings",
"6472148", "Waihi",
"6496516", "Kaikohe",
"643302", "Ashburton\/Akaroa\/Chatham\ Islands",
"647893", "Taumarunui",
"6498856", "Maungaturoto",
"6474440", "Paeroa",
"6439536", "Waimate",
"644887", "Wellington",
"6439456", "Riverton",
"6492809", "Maungaturoto",
"649212", "Auckland",
"6434284", "Wanaka",
"644493", "Wellington",
"6465619", "Masterton",
"6439880", "Greymouth",
"6475958", "Taupo",
"6462163", "New\ Plymouth",
"649552", "Pukekohe",
"6475481", "Tauranga",
"649968", "Auckland",
"6435542", "Riverton",
"6434359", "Twizel",
"6462413", "Gisborne",
"6499049", "Great\ Barrier\ Island",
"647905", "Taupo",
"649280", "Auckland",
"6479102", "Rotorua",
"64983", "Auckland",
"6472608", "Waihi",
"6432725", "Hokitika",
"649930", "Auckland",
"6473994", "Rotorua",
"643235", "Invercargill",
"649403", "Kawakawa",
"646349", "Wanganui",
"6468999", "Napier",
"6479843", "Morrinsville",
"6472607", "Paeroa",
"647863", "Waihi",
"6499555", "Kawakawa",
"644910", "Wellington",
"6479296", "Tauranga",
"644293", "Paraparaumu",
"6474442", "Morrinsville",
"6499478", "Pukekohe",
"647308", "Whakatane",
"6499464", "Whangarei",
"6432803", "Otautau",
"6468251", "Wanganui",
"6436593", "Nelson",
"6432638", "Tokanui",
"6435950", "Christchurch",
"6499001", "Auckland",
"647958", "Hamilton",
"6499421", "Hibiscus\ Coast",
"6499477", "Pukekohe",
"6432637", "Winton",
"6472458", "Rotorua",
"6435880", "Dunedin",
"6466000", "Napier",
"6434298", "Hokitika",
"643448", "Alexandra",
"6473842", "Taupo",
"6436654", "Tokanui",
"649407", "Kaikohe",
"6472457", "Rotorua",
"6499871", "Whangarei",
"64944", "Auckland",
"647867", "Thames",
"6434297", "Westport",
"644297", "Paraparaumu",
"6478075", "Te\ Kuiti",
"649952", "Auckland",
"6435558", "Waimate",
"6472614", "Otorohanga",
"6433959", "Balclutha",
"644834", "Paraparaumu",
"6469242", "Levin",
"6473922", "Morrinsville",
"6432664", "Christchurch",
"6433980", "Milton",
"649890", "Auckland",
"6496884", "Auckland",
"649814", "Auckland",
"6435557", "Geraldine",
"6442420", "Wellington",
"6432621", "Oamaru",
"6479751", "Tauranga",
"6439523", "Balclutha",
"6435683", "Te\ Anau",
"6432445", "Greymouth",
"644497", "Wellington",
"644250", "Wellington",
"6466509", "Napier\/Waipukurau",
"644392", "Wellington",
"643248", "Lumsden",
"6439703", "Takaka",
"6449083", "Wellington",
"6442128", "Paraparaumu",
"6462624", "Opunake",
"647829", "Hamilton",
"6463912", "New\ Plymouth",
"6468693", "Gisborne",
"6473332", "Rotorua",
"647218", "Tauranga",
"6442127", "Paraparaumu",
"6437463", "Mt\ Cook",
"6498821", "Dargaville",
"6493931", "Whangarei",
"646650", "Napier",
"6472145", "Huntly",
"6479025", "Huntly",
"6436687", "Nelson",
"6469298", "Masterton",
"6432996", "Riverton",
"646378", "Masterton",
"6477880", "Hamilton",
"643439", "Oamaru",
"6436688", "Waitangi\ \(Chatham\ Is\.\)",
"6469297", "Masterton",
"6462105", "Taihape",
"6463903", "Ruatoria",
"6462606", "Waiouru",
"643989", "Nelson",
"649881", "Auckland",
"6434242", "Darfield",
"6439712", "Fairlie",
"6432223", "Akaroa",
"649422", "Warkworth",
"6436643", "Balclutha",
"644920", "Wellington",
"6468302", "Napier",
"647466", "Tauranga",
"6437773", "Dunedin",
"6496994", "Dargaville",
"6492229", "Hibiscus\ Coast",
"643239", "Invercargill",
"646975", "Napier",
"6497779", "Great\ Barrier\ Island",
"646345", "Wanganui",
"6435692", "Takaka",
"6434996", "Roxburgh",
"6432619", "Christchurch",
"644896", "Wellington",
"6435990", "Hokitika",
"6493944", "Hibiscus\ Coast",
"6472815", "Whakatane",
"6465600", "Palmerston\ North",
"6436622", "Cheviot",
"6434223", "Otautau",
"6469284", "Stratford",
"6436527", "Haast",
"6468262", "Napier",
"6437481", "Invercargill",
"6432812", "Haast",
"6499066", "Helensville",
"6436528", "Westport",
"6469572", "Palmerston\ North",
"649916", "Auckland",
"6435661", "Fairlie",
"6475611", "Taumarunui",
"649941", "Auckland",
"6439272", "Timaru",
"649291", "Auckland",
"6468889", "Levin",
"6433999", "Otautau",
"646766", "New\ Plymouth",
"646601", "Napier",
"6472190", "Whakatane",
"644576", "Wellington",
"6492834", "Kawakawa",
"6439765", "Milton",
"6479715", "Paeroa",
"6439281", "Christchurch",
"6437472", "Lawrence",
"6465621", "New\ Plymouth",
"6439312", "Riverton",
"6436582", "Riverton",
"6479854", "Rotorua",
"6478991", "Whangamata",
"643762", "Greymouth",
"647825", "Hamilton",
"6478144", "Tauranga",
"6462107", "Dannevirke",
"6432810", "Franz\ Josef",
"6432744", "Ranfurly",
"6469570", "Palmerston\ North",
"6442199", "Paraparaumu",
"6469295", "Wanganui",
"6433944", "Ashburton",
"6462108", "Ohakune",
"6468260", "Featherston",
"643331", "Christchurch",
"6439734", "Edendale",
"6436685", "Nelson",
"643456", "Dunedin",
"6468806", "New\ Plymouth",
"6437779", "Invercargill",
"649239", "Pukekohe",
"6432229", "Dunedin",
"6439270", "Greymouth",
"6436994", "Murchison",
"6436649", "Gore",
"644219", "Wellington",
"6497773", "Dargaville",
"6437446", "Franz\ Josef",
"6434236", "Amberley",
"6432613", "Waitangi\ \(Chatham\ Is\.\)",
"6463941", "Masterton",
"6445954", "Wellington",
"6433916", "Hokitika",
"6432716", "Darfield",
"643655", "Dunedin",
"6472192", "Whakatane",
"647886", "Putaruru\/Tokoroa",
"6492223", "Auckland",
"647546", "Tauranga",
"6472818", "Rotorua",
"6466991", "Wanganui",
"6436580", "Invercargill",
"6434229", "Winton",
"649439", "Dargaville",
"6472817", "Taupo",
"6439310", "Invercargill",
"6437470", "Balclutha",
"6472804", "Whangamata",
"6434276", "Palmerston",
"6432424", "Nelson",
"6477882", "Hamilton",
"6436525", "Franz\ Josef",
"646751", "New\ Plymouth",
"6468883", "Palmerston\ North",
"6433993", "Te\ Anau",
"6435511", "Kaikoura",
"646903", "Palmerston\ North",
"649479", "Auckland",
"6468300", "Napier",
"6472124", "Matamata",
"6439710", "Timaru",
"6434240", "Ashburton",
"6479717", "Otorohanga",
"6439767", "Alexandra",
"6435690", "Motueka",
"6462421", "New\ Plymouth",
"646865", "Gisborne",
"6479718", "Taumarunui",
"6439768", "Ranfurly",
"643941", "Christchurch",
"649589", "Auckland",
"6439334", "Fox\ Glacier",
"649849", "Auckland",
"647376", "Taupo",
"6466013", "Featherston",
"6436620", "Kaikoura",
"6439066", "Hokitika",
"6465602", "Palmerston\ North",
"649399", "Auckland",
"6435992", "Fox\ Glacier",
"6462114", "Waipukurau",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+64|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;