# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::BR;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20210204173824;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '
            1(?:
              1[25-8]|
              2[357-9]|
              3[02-68]|
              4[12568]|
              5|
              6[0-8]|
              8[015]|
              9[0-47-9]
            )|
            321|
            610
          ',
                  'pattern' => '(\\d{3,6})'
                },
                {
                  'format' => '$1-$2',
                  'leading_digits' => '
            4(?:
              02|
              37
            )0|
            [34]00
          ',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '
            [2357]|
            4(?:
              [0-24-9]|
              3(?:
                [0-689]|
                7[1-9]
              )
            )
          ',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            (?:
              [358]|
              90
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2,3})(\\d{4})'
                },
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '9',
                  'pattern' => '(\\d{5})(\\d{4})'
                },
                {
                  'format' => '$1 $2-$3',
                  'leading_digits' => '
            (?:
              [14689][1-9]|
              2[12478]|
              3[1-578]|
              5[13-5]|
              7[13-579]
            )[2-57]
          ',
                  'national_rule' => '($1)',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2-$3',
                  'leading_digits' => '
            [16][1-9]|
            [2-57-9]
          ',
                  'national_rule' => '($1)',
                  'pattern' => '(\\d{2})(\\d{5})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            [14689][1-9]|
            2[12478]|
            3[1-578]|
            5[13-5]|
            7[13-579]
          )[2-5]\\d{7}
        ',
                'geographic' => '
          (?:
            [14689][1-9]|
            2[12478]|
            3[1-578]|
            5[13-5]|
            7[13-579]
          )[2-5]\\d{7}
        ',
                'mobile' => '
          (?:
            [14689][1-9]|
            2[12478]|
            3[1-578]|
            5[13-5]|
            7[13-579]
          )(?:
            7|
            9\\d
          )\\d{7}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          300\\d{7}|
          [34]00\\d{5}|
          4(?:
            02|
            37
          )0\\d{4}
        )|(
          300\\d{6}|
          [59]00\\d{6,7}
        )',
                'toll_free' => '800\\d{6,7}',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"55483355", "Imbituba\ \-\ SC",
"55133343", "Guarujá\ \-\ SP",
"55753664", "Taperoá\ \-\ BA",
"55383621", "Januária\ \-\ MG",
"55833321", "Campina\ Grande\ \-\ PB",
"55823533", "Jaramataia\ \-\ AL",
"55413111", "Curitiba\ \-\ PR",
"5587386", "Petrolina\ \-\ PE",
"55283569", "Ibitirama\ \-\ ES",
"55333333", "Realeza\ \-\ MG",
"5521342", "Rio\ de\ Janeiro\ \-\ RJ",
"55483356", "Imbituba\ \-\ SC",
"55313749", "Ouro\ Branco\ \-\ MG",
"55883633", "Ararendá\ \-\ CE",
"55913753", "Barcarena\ \-\ PA",
"55273044", "Colatina\ \-\ ES",
"55143487", "Júlio\ Mesquita\ \-\ SP",
"55114653", "Arujá\ \-\ SP",
"55333262", "Goiabeira\ \-\ MG",
"55943432", "Floresta\ do\ Araguaia\ \-\ PA",
"55813136", "Caruaru\ \-\ PE",
"5581332", "Recife\ \-\ PE",
"55653384", "Porto\ Estrela\ \-\ MT",
"55812126", "Recife\ \-\ PE",
"55213642", "Teresópolis\ \-\ RJ",
"55793341", "Aquidabã\ \-\ SE",
"55663507", "Simione\ \-\ MT",
"55983357", "Matinha\ \-\ MA",
"55163524", "Sertãozinho\ \-\ SP",
"55693342", "Cerejeiras\ \-\ RO",
"55313334", "Minas\ Gerais",
"55843396", "Lucrécia\ \-\ RN",
"55843065", "Mossoró\ \-\ RN",
"55843395", "Almino\ Afonso\ \-\ RN",
"55913528", "Novo\ Progresso\ \-\ PA",
"55333525", "Poté\ \-\ MG",
"55133494", "Praia\ Grande\ \-\ SP",
"55114028", "Salto\ \-\ SP",
"55313831", "Itabira\ \-\ MG",
"55283517", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55323274", "Rio\ Novo\ \-\ MG",
"55333526", "Ataléia\ \-\ MG",
"55883664", "Marco\ \-\ CE",
"55192114", "Limeira\ \-\ SP",
"55183917", "Presidente\ Prudente\ \-\ SP",
"55123153", "Lorena\ \-\ SP",
"55192511", "Campinas\ \-\ SP",
"55663527", "Nova\ União\ \-\ MT",
"55922129", "Manaus\ \-\ AM",
"5511285", "São\ Paulo\ \-\ SP",
"55873773", "Lajedo\ \-\ PE",
"55773646", "Ipupiara\ \-\ BA",
"55143112", "Botucatu\ \-\ SP",
"55113555", "São\ Paulo\ \-\ SP",
"55623464", "Água\ Fria\ de\ Goiás\ \-\ GO",
"55193473", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55633497", "Tupirama\ \-\ TO",
"5521340", "Rio\ de\ Janeiro\ \-\ RJ",
"55113556", "São\ Paulo\ \-\ SP",
"55773480", "Coribe\ \-\ BA",
"55343327", "Conceição\ das\ Alagoas\ \-\ MG",
"55273213", "Cariacica\ \-\ ES",
"55773645", "Boquira\ \-\ BA",
"55353229", "Varginha\ \-\ MG",
"55193656", "Mococa\ \-\ SP",
"55623312", "Itapuranga\ \-\ GO",
"55643688", "Jaupaci\ \-\ GO",
"55513111", "Cachoeirinha\ \-\ RS",
"55323372", "São\ João\ Del\ Rei\ \-\ MG",
"55613010", "Brasília\ \-\ DF",
"55473340", "Blumenau\ \-\ SC",
"55223512", "Nova\ Friburgo\ \-\ RJ",
"55214117", "Nova\ Iguaçu\ \-\ RJ",
"55823305", "Maceió\ \-\ AL",
"55343671", "São\ Gotardo\ \-\ MG",
"55643611", "Rio\ Verde\ \-\ GO",
"55953263", "Alto\ Alegre\ \-\ RR",
"55115486", "São\ Paulo\ \-\ SP",
"55633472", "Araguacema\ \-\ TO",
"55423644", "Santa\ Maria\ do\ Oeste\ \-\ PR",
"55313232", "Minas\ Gerais",
"55333412", "São\ João\ Evangelista\ \-\ MG",
"55773459", "Tanhaçu\ \-\ BA",
"55883530", "Araripe\ \-\ CE",
"55753281", "Paulo\ Afonso\ \-\ BA",
"55853650", "Carnaubal\ \-\ CE",
"55873831", "Serra\ Talhada\ \-\ PE",
"55753218", "Salgadália\ \-\ BA",
"55483544", "Morro\ Grande\ \-\ SC",
"5596322", "Macapá\ \-\ AP",
"55163101", "Ribeirão\ Preto\ \-\ SP",
"55484009", "Florianópolis\ \-\ SC",
"55112688", "Guarulhos\ \-\ SP",
"55473399", "Timbó\ \-\ SC",
"55493539", "Iomerê\ \-\ SC",
"55213643", "Teresópolis\ \-\ RJ",
"55513056", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55623432", "Goiânia\ \-\ GO",
"55713216", "Simões\ Filho\ \-\ BA",
"55152102", "Sorocaba\ \-\ SP",
"55813705", "Santa\ Cruz\ do\ Capibaribe\ \-\ PE",
"55943433", "Tucumã\ \-\ PA",
"55513055", "Guaíba\ \-\ RS",
"55963321", "Serra\ do\ Navio\ \-\ AP",
"55333263", "Resplendor\ \-\ MG",
"55114652", "Arujá\ \-\ SP",
"55913752", "Tailândia\ \-\ PA",
"55883632", "Viçosa\ do\ Ceará\ \-\ CE",
"55333332", "Manhuaçu\ \-\ MG",
"55113109", "Jundiaí\ \-\ SP",
"55273314", "Vitória\ \-\ ES",
"5565366", "Cuiabá\ \-\ MT",
"55112838", "São\ Paulo\ \-\ SP",
"55133342", "Guarujá\ \-\ SP",
"55513951", "Novo\ Hamburgo\ \-\ RS",
"55663500", "Primavera\ do\ Leste\ \-\ MT",
"55313264", "Minas\ Gerais",
"55183638", "Birigui\ \-\ SP",
"55143646", "Mineiros\ do\ Tietê\ \-\ SP",
"55833348", "Alcantil\ \-\ PB",
"55153558", "Apiaí\ \-\ SP",
"55373221", "Divinópolis\ \-\ MG",
"55873875", "Cabrobó\ \-\ PE",
"55813201", "Recife\ \-\ PE",
"55963081", "Macapá\ \-\ AP",
"55993641", "Coroatá\ \-\ MA",
"55753451", "Araças\ \-\ BA",
"55413639", "Lapa\ \-\ PR",
"55873876", "Belém\ de\ São\ Francisco\ \-\ PE",
"55693343", "Corumbiara\ \-\ RO",
"55433512", "Arapoti\ \-\ PR",
"55313414", "Minas\ Gerais",
"55113129", "São\ Paulo\ \-\ SP",
"55333234", "Engenheiro\ Caldas\ \-\ MG",
"55423421", "Irati\ \-\ PR",
"55814003", "Recife\ \-\ PE",
"55883537", "Salitre\ \-\ CE",
"55493338", "Cunhataí\ \-\ SC",
"55873772", "Correntes\ \-\ PE",
"55753632", "Santo\ Antônio\ de\ Jesus\ \-\ BA",
"55984141", "São\ Luís\ \-\ MA",
"55653283", "Comodoro\ \-\ MT",
"55813726", "Belo\ Jardim\ \-\ PE",
"55313681", "Lagoa\ Santa\ \-\ MG",
"55123152", "Lorena\ \-\ SP",
"55473347", "Piçarras\ \-\ SC",
"55663603", "Aripuanã\ \-\ MT",
"55193979", "Monte\ Mor\ \-\ SP",
"55513639", "São\ Vendelino\ \-\ RS",
"55163236", "Ribeirão\ Preto\ \-\ SP",
"55413056", "Pinhais\ \-\ PR",
"55193497", "Limeira\ \-\ SP",
"55114431", "Jundiaí\ \-\ SP",
"55653631", "Cuiabá\ \-\ MT",
"5579324", "Aracaju\ \-\ SE",
"55213116", "Rio\ de\ Janeiro\ \-\ RJ",
"55483278", "São\ José\ \-\ SC",
"5516337", "São\ Carlos\ \-\ SP",
"55313233", "Minas\ Gerais",
"55333413", "Paulistas\ \-\ MG",
"55633473", "Xambioá\ \-\ TO",
"55493251", "Lages\ \-\ SC",
"55953262", "Normandia\ \-\ RR",
"5583322", "João\ Pessoa\ \-\ PB",
"55943312", "Marabá\ \-\ PA",
"5549", "Santa\ Catarina",
"55313876", "Urucânia\ \-\ MG",
"55973346", "Uarini\ \-\ AM",
"55733046", "Jequié\ \-\ BA",
"55313875", "Santa\ Margarida\ \-\ MG",
"55973345", "Alvarães\ \-\ AM",
"55883451", "Dom\ Maurício\ \-\ CE",
"55373201", "Itaúna\ \-\ MG",
"55633449", "Tupiratins\ \-\ TO",
"55323373", "São\ João\ Del\ Rei\ \-\ MG",
"55112352", "São\ Paulo\ \-\ SP",
"55213540", "Nova\ Iguaçu\ \-\ RJ",
"55673434", "Sanga\ Puitã\ \-\ MS",
"55312101", "Belo\ Horizonte\ \-\ MG",
"55953532", "Caracaraí\ \-\ RR",
"55163304", "Araraquara\ \-\ SP",
"55753626", "Feira\ de\ Santana\ \-\ BA",
"55983652", "Bom\ Jesus\ das\ Selvas\ \-\ MA",
"55243353", "Porto\ Real\ \-\ RJ",
"55813732", "Fazenda\ Nova\ \-\ PE",
"55483344", "Palhoça\ \-\ SC",
"55623406", "Buritinópolis\ \-\ GO",
"55423247", "Ivaí\ \-\ PR",
"55114029", "Salto\ \-\ SP",
"55623512", "Senador\ Canedo\ \-\ GO",
"55323572", "Silveirânia\ \-\ MG",
"55843384", "Pilões\ \-\ RN",
"55313563", "Itabirito\ \-\ MG",
"55683612", "Sena\ Madureira\ \-\ AC",
"55383672", "Paracatu\ \-\ MG",
"55413150", "Fazenda\ Rio\ Grande\ \-\ PR",
"55833372", "Cuité\ \-\ PB",
"55753469", "Cícero\ Dantas\ \-\ BA",
"55813447", "Recife\ \-\ PE",
"55673213", "Campo\ Grande\ \-\ MS",
"55653396", "Alto\ Paraguai\ \-\ MT",
"55433432", "Jandaia\ do\ Sul\ \-\ PR",
"55133378", "Cubatão\ \-\ SP",
"55373273", "Onça\ de\ Pitangui\ \-\ MG",
"55353843", "Ijaci\ \-\ MG",
"55513462", "Canoas\ \-\ RS",
"55923245", "Manaus\ \-\ AM",
"55153275", "Itapetininga\ \-\ SP",
"55163172", "Igarapava\ \-\ SP",
"55833397", "Natuba\ \-\ PB",
"55173845", "Meridiano\ \-\ SP",
"55173846", "Mira\ Estrela\ \-\ SP",
"55373249", "Itaúna\ \-\ MG",
"55143812", "São\ Manuel\ \-\ SP",
"55153276", "Sarapuí\ \-\ SP",
"55333325", "Imbé\ de\ Minas\ \-\ MG",
"55713052", "Salvador\ \-\ BA",
"55843282", "Santo\ Antônio\ \-\ RN",
"55163821", "Orlândia\ \-\ SP",
"55823526", "Coité\ do\ Nóia\ \-\ AL",
"55883625", "Chaval\ \-\ CE",
"55643495", "Goiatuba\ \-\ GO",
"55753330", "Boninal\ \-\ BA",
"55643496", "Aloândia\ \-\ GO",
"55872101", "Petrolina\ \-\ PE",
"55673463", "Juti\ \-\ MS",
"55883626", "São\ Benedito\ \-\ CE",
"55833274", "Araçagi\ \-\ PB",
"55893442", "Alagoinha\ do\ Piauí\ \-\ PI",
"55413462", "Morretes\ \-\ PR",
"55333326", "Santa\ Bárbara\ do\ Leste\ \-\ MG",
"55773458", "Brumado\ \-\ BA",
"55163324", "Araraquara\ \-\ SP",
"55623425", "São\ Domingos\ \-\ GO",
"55163202", "Jaboticabal\ \-\ SP",
"55713641", "Catu\ \-\ BA",
"55313534", "Igarapé\ \-\ MG",
"55114009", "São\ Paulo\ \-\ SP",
"55643689", "Diorama\ \-\ GO",
"55753182", "Alagoinhas\ \-\ BA",
"55312524", "Contagem\ \-\ MG",
"55173551", "Ibirá\ \-\ SP",
"55483242", "Palhoça\ \-\ SC",
"55133579", "São\ Vicente\ \-\ SP",
"55313660", "Pedro\ Leopoldo\ \-\ MG",
"55913088", "Belém\ \-\ PA",
"55813273", "Recife\ \-\ PE",
"55973482", "Ipixuna\ \-\ AM",
"55633421", "Araguaína\ \-\ TO",
"55913011", "Paragominas\ \-\ PA",
"55823262", "Messias\ \-\ AL",
"55343061", "Patos\ de\ Minas\ \-\ MG",
"55473643", "Mafra\ \-\ SC",
"55613642", "Formosa\ \-\ GO",
"55793541", "Tobias\ Barreto\ \-\ SE",
"55663904", "Barra\ do\ Garças\ \-\ MT",
"55114511", "Mauá\ \-\ SP",
"55853353", "Uruburetama\ \-\ CE",
"55423656", "Goioxim\ \-\ PR",
"55833521", "Sousa\ \-\ PB",
"55143288", "Bauru\ \-\ SP",
"55423655", "Altamira\ do\ Paraná\ \-\ PR",
"5561342", "Brasília\ \-\ DF",
"55333533", "Novo\ Cruzeiro\ \-\ MG",
"55673044", "Campo\ Grande\ \-\ MS",
"55193448", "Ibitiruna\ \-\ SP",
"55753267", "Biritinga\ \-\ BA",
"55213816", "Rio\ de\ Janeiro\ \-\ RJ",
"55833373", "Araruna\ \-\ PB",
"55513044", "Alvorada\ \-\ RS",
"55383673", "Guarda\-Mor\ \-\ MG",
"55983311", "São\ Luís\ \-\ MA",
"55313562", "Itabirito\ \-\ MG",
"55193401", "Piracicaba\ \-\ SP",
"55833390", "Prata\ \-\ PB",
"55983388", "Peri\ Mirim\ \-\ MA",
"55613540", "Brazlândia\ \-\ DF",
"55323573", "Piraúba\ \-\ MG",
"55383690", "Montes\ Claros\ \-\ MG",
"55623513", "Nerópolis\ \-\ GO",
"55283551", "Divino\ de\ São\ Lourenço\ \-\ ES",
"55813685", "Quipapá\ \-\ PE",
"55483014", "São\ João\ Batista\ \-\ SC",
"55953086", "Boa\ Vista\ \-\ RR",
"55813733", "Taquaritinga\ do\ Norte\ \-\ PE",
"55243352", "Itatiaia\ \-\ RJ",
"55983653", "Santa\ Inês\ \-\ MA",
"55313721", "Conselheiro\ Lafaiete\ \-\ MG",
"55863241", "Boa\ Hora\ \-\ PI",
"55813686", "Belém\ de\ Maria\ \-\ PE",
"55183639", "Santo\ Antônio\ do\ Aracanguá\ \-\ SP",
"55983476", "Santa\ Quitéria\ do\ Maranhão\ \-\ MA",
"55112245", "Guarulhos\ \-\ SP",
"55143654", "Brotas\ \-\ SP",
"55143813", "Botucatu\ \-\ SP",
"55413157", "Quatro\ Barras\ \-\ PR",
"55112839", "São\ Paulo\ \-\ SP",
"55473547", "Braço\ do\ Trombudo\ \-\ SC",
"55743551", "Filadélfia\ \-\ BA",
"55893585", "Coronel\ José\ Dias\ \-\ PI",
"55533312", "Bagé\ \-\ RS",
"55163173", "Igarapava\ \-\ SP",
"55983475", "Mata\ Roma\ \-\ MA",
"55513463", "Rio\ Grande\ do\ Sul",
"55353842", "Nazareno\ \-\ MG",
"55553307", "Santa\ Maria\ \-\ RS",
"55373272", "Maravilhas\ \-\ MG",
"55693485", "Espigão\ D\'Oeste\ \-\ RO",
"55433433", "Ariranha\ do\ Ivaí\ \-\ PR",
"55143458", "Queiroz\ \-\ SP",
"55493538", "Ibicaré\ \-\ SC",
"55654104", "Várzea\ Grande\ \-\ MT",
"55823234", "Maceió\ \-\ AL",
"55212645", "Itaboraí\ \-\ RJ",
"55483243", "Biguaçu\ \-\ SC",
"55633448", "Babaçulândia\ \-\ TO",
"55513157", "Três\ Coroas\ \-\ RS",
"55643657", "Bom\ Jardim\ de\ Goiás\ \-\ GO",
"55163203", "Jaboticabal\ \-\ SP",
"55212646", "São\ Gonçalo\ \-\ RJ",
"55433312", "Arapongas\ \-\ PR",
"55943426", "Xinguara\ \-\ PA",
"55483279", "Palhoça\ \-\ SC",
"55893443", "Santana\ do\ Piauí\ \-\ PI",
"55323348", "Cipotânea\ \-\ MG",
"55112657", "Guarulhos\ \-\ SP",
"55843283", "Brejinho\ \-\ RN",
"55313667", "Coronel\ Fabriciano\ \-\ MG",
"55443427", "Porto\ Rico\ \-\ PR",
"55613679", "São\ Gabriel\ de\ Goiás\ \-\ GO",
"55883410", "Itaiçaba\ \-\ CE",
"55513638", "Salvador\ do\ Sul\ \-\ RS",
"55333532", "Itaipé\ \-\ MG",
"55553327", "Salto\ do\ Jacuí\ \-\ RS",
"55843631", "Macaíba\ \-\ RN",
"55823332", "Maceió\ \-\ AL",
"55443209", "Nova\ Esperança\ \-\ PR",
"55813030", "Paulista\ \-\ PE",
"55853352", "Pentecoste\ \-\ CE",
"55273111", "Aracruz\ \-\ ES",
"5515341", "Sorocaba\ \-\ SP",
"55183857", "São\ João\ do\ Pau\ D\'Alho\ \-\ SP",
"55773461", "Bom\ Jesus\ da\ Serra\ \-\ BA",
"55473642", "Mafra\ \-\ SC",
"55493339", "Águas\ de\ Chapecó\ \-\ SC",
"55823263", "Marechal\ Deodoro\ \-\ AL",
"55353241", "São\ Gonçalo\ do\ Sapucaí\ \-\ MG",
"55973483", "Envira\ \-\ AM",
"55283310", "Castelo\ \-\ ES",
"55813272", "Recife\ \-\ PE",
"55433464", "Mauá\ da\ Serra\ \-\ PR",
"55753337", "Utinga\ \-\ BA",
"55713628", "Arembepe\ \-\ BA",
"55963521", "Oiapoque\ \-\ AP",
"55513434", "Viamão\ \-\ RS",
"55242109", "Resende\ \-\ RJ",
"55323693", "Barbacena\ \-\ MG",
"55633487", "São\ Bento\ do\ Tocantins\ \-\ TO",
"55153372", "Itapetininga\ \-\ SP",
"55543338", "Victor\ Graeff\ \-\ RS",
"55652137", "Várzea\ Grande\ \-\ MT",
"55473350", "Brusque\ \-\ SC",
"55773473", "Macaúbas\ \-\ BA",
"55313323", "Belo\ Horizonte\ \-\ MG",
"55193646", "São\ Sebastião\ da\ Grama\ \-\ SP",
"55183422", "Assis\ \-\ SP",
"55823271", "São\ Miguel\ dos\ Campos\ \-\ AL",
"5583333", "Campina\ Grande\ \-\ PB",
"55773449", "Malhada\ de\ Pedras\ \-\ BA",
"55114599", "Jundiaí\ \-\ SP",
"55213431", "Rio\ de\ Janeiro\ \-\ RJ",
"55333084", "Governador\ Valadares\ \-\ MG",
"55423654", "Catuporanga\ \-\ PR",
"55543251", "Cambará\ do\ Sul\ \-\ RS",
"55143714", "Cerqueira\ César\ \-\ SP",
"55833276", "Pilões\ \-\ PB",
"55883624", "Granja\ \-\ CE",
"55123143", "Cruzeiro\ \-\ SP",
"55383727", "Monjolos\ \-\ MG",
"55333202", "Governador\ Valadares\ \-\ MG",
"55163981", "Pradópolis\ \-\ SP",
"5531382", "Ipatinga\ \-\ MG",
"55333324", "Vargem\ Alegre\ \-\ MG",
"55613357", "Samambaia\ Sul\ \-\ DF",
"55823524", "Feira\ Grande\ \-\ AL",
"55933538", "Terra\ Santa\ \-\ PA",
"55833275", "Serraria\ \-\ PB",
"55493228", "Bocaina\ do\ Sul\ \-\ SC",
"55623628", "Novo\ Gama\ \-\ GO",
"55313535", "Mateus\ Leme\ \-\ MG",
"55753604", "Feira\ de\ Santana\ \-\ BA",
"55163326", "Boa\ Esperança\ do\ Sul\ \-\ SP",
"55883428", "Iracema\ \-\ CE",
"55643698", "Nova\ Aurora\ \-\ GO",
"5554", "Rio\ Grande\ do\ Sul",
"55773656", "Brejolândia\ \-\ BA",
"55653277", "Caramujo\ \-\ MT",
"55313536", "Florestal\ \-\ MG",
"55173341", "Colina\ \-\ SP",
"55113354", "São\ Paulo\ \-\ SP",
"55833682", "São\ José\ dos\ Ramos\ \-\ PB",
"55443251", "Sabáudia\ \-\ PR",
"55474141", "Itajaí\ \-\ SC",
"55373331", "Oliveira\ \-\ MG",
"55843674", "Natal\ \-\ RN",
"55173844", "Pontes\ Gestal\ \-\ SP",
"55743529", "Andorinha\ \-\ BA",
"55413908", "Curitiba\ \-\ PR",
"55112717", "São\ Paulo\ \-\ SP",
"55513471", "Cachoeirinha\ \-\ RS",
"55153274", "Alambari\ \-\ SP",
"55843478", "São\ José\ do\ Seridó\ \-\ RN",
"55813863", "Petrolina\ \-\ PE",
"55183402", "Assis\ \-\ SP",
"55313303", "Belo\ Horizonte\ \-\ MG",
"5544", "Paraná",
"55753624", "Feira\ de\ Santana\ \-\ BA",
"55163305", "Araraquara\ \-\ SP",
"55143472", "Ubirajara\ \-\ SP",
"55313759", "Minas\ Gerais",
"55483346", "São\ José\ \-\ SC",
"55673435", "Antônio\ João\ \-\ MS",
"55814062", "Recife\ \-\ PE",
"55623404", "Assunção\ de\ Goiás\ \-\ GO",
"55123878", "São\ José\ dos\ Campos\ \-\ SP",
"55833361", "Esperança\ \-\ PB",
"55863269", "Beneditinos\ \-\ PI",
"55283529", "Itapemirim\ \-\ ES",
"55153521", "Itapeva\ \-\ SP",
"55483345", "Tijucas\ \-\ SC",
"5511361", "São\ Paulo\ \-\ SP",
"5521346", "Rio\ de\ Janeiro\ \-\ RJ",
"55373258", "Pitangui\ \-\ MG",
"55163306", "São\ Carlos\ \-\ SP",
"55843385", "Marcelino\ Vieira\ \-\ RN",
"5531380", "Minas\ Gerais",
"55793351", "Porto\ da\ Folha\ \-\ SE",
"55993668", "Timbiras\ \-\ MA",
"55323722", "Muriaé\ \-\ MG",
"55493491", "Seara\ \-\ SC",
"55623608", "Goiânia\ \-\ GO",
"55753428", "Pedrão\ \-\ BA",
"55843386", "Tenente\ Ananias\ \-\ RN",
"55543268", "Farroupilha\ \-\ RS",
"55553318", "Jóia\ \-\ RS",
"55493241", "Curitibanos\ \-\ SC",
"55923012", "Manaus\ \-\ AM",
"55353339", "São\ Lourenço\ \-\ MG",
"55153349", "Ibiúna\ \-\ SP",
"55553381", "São\ Miguel\ das\ Missões\ \-\ RS",
"55833559", "Bom\ Jesus\ \-\ PB",
"55633459", "Buriti\ do\ Tocantins\ \-\ TO",
"55112342", "São\ Paulo\ \-\ SP",
"55313322", "Minas\ Gerais",
"55773472", "Maetinga\ \-\ BA",
"55513436", "Viamão\ \-\ RS",
"55883441", "Quixeramobim\ \-\ CE",
"55513435", "Rio\ Grande\ do\ Sul",
"55973356", "Anamã\ \-\ AM",
"55153373", "Itapetininga\ \-\ SP",
"55553884", "Dona\ Otília\ \-\ RS",
"55113117", "São\ Paulo\ \-\ SP",
"55433465", "Rosário\ do\ Ivaí\ \-\ PR",
"55713669", "Palmares\ \-\ BA",
"55943424", "Redenção\ \-\ PA",
"55173529", "Elisiário\ \-\ SP",
"55413941", "Curitiba\ \-\ PR",
"55753031", "Alagoinhas\ \-\ BA",
"55673471", "Iguatemi\ \-\ MS",
"55473357", "Ibirama\ \-\ SC",
"55663438", "Nova\ Xavantina\ \-\ MT",
"55613389", "Planaltina\ \-\ DF",
"55193487", "Santa\ Maria\ da\ Serra\ \-\ SP",
"55333203", "Governador\ Valadares\ \-\ MG",
"55163859", "Orlândia\ \-\ SP",
"55873787", "Paranatama\ \-\ PE",
"55213589", "Mesquita\ \-\ RJ",
"55474108", "Balneário\ Camboriú\ \-\ SC",
"55544052", "Passo\ Fundo\ \-\ RS",
"55733639", "Ilhéus\ \-\ BA",
"55433711", "Cambé\ \-\ PR",
"55273422", "Cariacica\ \-\ ES",
"55833358", "Barra\ de\ São\ Miguel\ \-\ PB",
"55813376", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55153548", "Itapirapuã\ Paulista\ \-\ SP",
"55983474", "Duque\ Bacelar\ \-\ MA",
"55143656", "Torrinha\ \-\ SP",
"55373261", "Lagoa\ da\ Prata\ \-\ MG",
"55513941", "Canoas\ \-\ RS",
"55834064", "Campina\ Grande\ \-\ PB",
"55983678", "Pindare\ Mirim\ \-\ MA",
"55753441", "Aporá\ \-\ BA",
"55614141", "Brasília\ \-\ DF",
"55173011", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55115839", "São\ Paulo\ \-\ SP",
"55823235", "Maceió\ \-\ AL",
"55452031", "Marechal\ Cândido\ Rondon\ \-\ PR",
"5582337", "Maceió\ \-\ AL",
"55813411", "Belo\ Jardim\ \-\ PE",
"55513045", "Viamão\ \-\ RS",
"55213814", "Rio\ de\ Janeiro\ \-\ RJ",
"55322102", "Juiz\ de\ Fora\ \-\ MG",
"55983399", "Mirinzal\ \-\ MA",
"55323723", "Rosário\ da\ Limeira\ \-\ MG",
"55613114", "Brasília\ \-\ DF",
"55553567", "Campina\ das\ Missões\ \-\ RS",
"55813684", "São\ Benedito\ do\ Sul\ \-\ PE",
"55543614", "Rio\ dos\ Índios\ \-\ RS",
"55213311", "Macaé\ \-\ RJ",
"55313571", "Brumadinho\ \-\ MG",
"55953084", "Boa\ Vista\ \-\ RR",
"55143473", "Alvinlândia\ \-\ SP",
"55283155", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55193112", "Campinas\ \-\ SP",
"55643699", "Buriti\ de\ Goiás\ \-\ GO",
"55883429", "Alto\ Santo\ \-\ CE",
"55553237", "São\ Gabriel\ \-\ RS",
"55473653", "Papanduva\ \-\ SC",
"55163412", "São\ Carlos\ \-\ SP",
"55193813", "Itapira\ \-\ SP",
"55193654", "Santo\ Antônio\ do\ Jardim\ \-\ SP",
"55633461", "Brasilândia\ do\ Tocantins\ \-\ TO",
"55115611", "São\ Paulo\ \-\ SP",
"55513515", "Porto\ Alegre\ \-\ RS",
"55443538", "Engenheiro\ Beltrão\ \-\ PR",
"55483546", "Ermo\ \-\ SC",
"55193458", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55423645", "Laranjal\ \-\ PR",
"55833561", "Bernardino\ Batista\ \-\ PB",
"55613041", "Brasília\ \-\ DF",
"55343662", "Araxá\ \-\ MG",
"55513140", "Novo\ Hamburgo\ \-\ RS",
"55853012", "Caucaia\ \-\ CE",
"55323361", "Carandaí\ \-\ MG",
"55843292", "Tangará\ \-\ RN",
"55423646", "Pitanga\ \-\ PR",
"55643640", "Lagoa\ Santa\ \-\ GO",
"55153321", "Sorocaba\ \-\ SP",
"55513402", "Guaíba\ \-\ RS",
"55473388", "Doutor\ Pedrinho\ \-\ SC",
"55853343", "Canindé\ \-\ CE",
"55163506", "Matão\ \-\ SP",
"55183928", "Presidente\ Prudente\ \-\ SP",
"55663581", "Castanheira\ \-\ MT",
"552125", "Rio\ de\ Janeiro\ \-\ RJ",
"55773448", "Dom\ Basílio\ \-\ BA",
"55112378", "Mogi\ das\ Cruzes\ \-\ SP",
"55883665", "Morrinhos\ \-\ CE",
"55893452", "Wall\ Ferraz\ \-\ PI",
"55114598", "Vargem\ \-\ SP",
"55464007", "Francisco\ Beltrão\ \-\ PR",
"55242483", "Miguel\ Pereira\ \-\ RJ",
"55143298", "Macatuba\ \-\ SP",
"55843277", "Nísia\ Floresta\ \-\ RN",
"55113554", "São\ Paulo\ \-\ SP",
"55483252", "São\ Bonifácio\ \-\ SC",
"55113151", "São\ Paulo\ \-\ SP",
"55713651", "São\ Francisco\ do\ Conde\ \-\ BA",
"55773644", "Brotas\ de\ Macaúbas\ \-\ BA",
"55543210", "Passo\ Fundo\ \-\ RS",
"55343318", "Uberaba\ \-\ MG",
"55312564", "Contagem\ \-\ MG",
"55653901", "Cuiabá\ \-\ MT",
"55543339", "Erebango\ \-\ RS",
"55443460", "Tamboara\ \-\ PR",
"55623466", "Vila\ Boa\ \-\ GO",
"55423459", "Fernandes\ Pinheiro\ \-\ PR",
"55313335", "Belo\ Horizonte\ \-\ MG",
"55753429", "Conde\ \-\ BA",
"55353853", "Campos\ Gerais\ \-\ MG",
"55623609", "Goiânia\ \-\ GO",
"55653025", "Cuiabá\ \-\ MT",
"55813457", "Paulista\ \-\ PE",
"55953235", "São\ João\ da\ Baliza\ \-\ RR",
"55953236", "Caroebe\ \-\ RR",
"55454101", "Cascavel\ \-\ PR",
"55653026", "Várzea\ Grande\ \-\ MT",
"55513422", "Barro\ Vermelho\ \-\ RS",
"55123843", "Ubatuba\ \-\ SP",
"55313336", "Minas\ Gerais",
"55114474", "Santo\ André\ \-\ SP",
"55843394", "Frutuoso\ Gomes\ \-\ RN",
"55323275", "Santana\ do\ Deserto\ \-\ MG",
"55833133", "João\ Pessoa\ \-\ PB",
"551129", "São\ Paulo\ \-\ SP",
"55733212", "Itabuna\ \-\ BA",
"55283528", "Vargem\ Alta\ \-\ ES",
"55114017", "Jarinu\ \-\ SP",
"55883409", "Russas\ \-\ CE",
"55133495", "Praia\ Grande\ \-\ SP",
"55373259", "Pitangui\ \-\ MG",
"55333524", "Ladainha\ \-\ MG",
"55823202", "Maceió\ \-\ AL",
"55313758", "Minas\ Gerais",
"5551364", "Rio\ Grande\ do\ Sul",
"55513898", "Porto\ Alegre\ \-\ RS",
"55323276", "Mar\ de\ Espanha\ \-\ MG",
"55643543", "Cezarina\ \-\ GO",
"5593", "Pará",
"55483354", "Garopaba\ \-\ SC",
"55453237", "Lindoeste\ \-\ PR",
"55163262", "Itápolis\ \-\ SP",
"55993425", "Jenipapo\ dos\ Vieiras\ \-\ MA",
"55743528", "Umburanas\ \-\ BA",
"55923542", "Maués\ \-\ AM",
"55833387", "São\ Sebastião\ de\ Lagoa\ de\ Roça\ \-\ PB",
"55843479", "Carnaúba\ dos\ Dantas\ \-\ RN",
"55114069", "Diadema\ \-\ SP",
"55653386", "São\ José\ do\ Rio\ Claro\ \-\ MT",
"55413140", "Campo\ Largo\ \-\ PR",
"55153572", "Itaberá\ \-\ SP",
"55643579", "Itumbiara\ \-\ GO",
"55114815", "Jundiaí\ \-\ SP",
"55243379", "Angra\ dos\ Reis\ \-\ RJ",
"55993078", "Caxias\ \-\ MA",
"55114816", "Jundiaí\ \-\ SP",
"5531327", "Belo\ Horizonte\ \-\ MG",
"55313523", "Sítio\ Novo\ \-\ MG",
"55242252", "Três\ Rios\ \-\ RJ",
"55223053", "Cabo\ Frio\ \-\ RJ",
"55853342", "Caucaia\ \-\ CE",
"55213114", "Rio\ de\ Janeiro\ \-\ RJ",
"5535", "Minas\ Gerais",
"55613388", "Planaltina\ \-\ DF",
"55663439", "Rondonópolis\ \-\ MT",
"55513403", "Guaíba\ \-\ RS",
"55843293", "Serra\ Caiada\ \-\ RN",
"55553367", "Santo\ Antônio\ das\ Missões\ \-\ RS",
"55413054", "Campo\ Largo\ \-\ PR",
"55343663", "Perdizes\ \-\ MG",
"55473041", "Blumenau\ \-\ SC",
"55313371", "Minas\ Gerais",
"55913854", "Maracanã\ \-\ PA",
"55183941", "Espigão\ \-\ SP",
"55654007", "Cuiabá\ \-\ MT",
"55823223", "Maceió\ \-\ AL",
"55193812", "Cosmópolis\ \-\ SP",
"55353251", "Cambuquira\ \-\ MG",
"55163413", "São\ Carlos\ \-\ SP",
"55333731", "Araçuaí\ \-\ MG",
"55473652", "Itaiópolis\ \-\ SC",
"55313874", "Minas\ Gerais",
"5563331", "Gurupi\ \-\ TO",
"55673929", "Três\ Lagoas\ \-\ MS",
"55212656", "São\ João\ de\ Meriti\ \-\ RJ",
"55613475", "Brasília\ \-\ DF",
"55643647", "Maurilândia\ \-\ GO",
"55333235", "Tumiritinga\ \-\ MG",
"55333236", "Alpercata\ \-\ MG",
"55483253", "Paulo\ Lopes\ \-\ SC",
"55212655", "São\ João\ de\ Meriti\ \-\ RJ",
"55633654", "Taguatinga\ \-\ TO",
"55713043", "Salvador\ \-\ BA",
"55813576", "Sirinhaém\ \-\ PE",
"55833558", "Cachoeira\ dos\ Índios\ \-\ PB",
"55873761", "Garanhuns\ \-\ PE",
"55163234", "Ribeirão\ Preto\ \-\ SP",
"55893453", "Pio\ Ix\ \-\ PI",
"55273198", "Vitória\ \-\ ES",
"55112647", "São\ Paulo\ \-\ SP",
"55313627", "Ribeirão\ das\ Neves\ \-\ MG",
"55843737", "Parnamirim\ \-\ RN",
"5519343", "Piracicaba\ \-\ SP",
"55473557", "Imbuia\ \-\ SC",
"55743541", "Senhor\ do\ Bonfim\ \-\ BA",
"55313265", "Minas\ Gerais",
"55373287", "Perdigão\ \-\ MG",
"55823203", "Ibateguara\ \-\ AL",
"55313266", "Minas\ Gerais",
"55713433", "Salvador\ \-\ BA",
"55143644", "Igaraçu\ do\ Tietê\ \-\ SP",
"55983398", "Cedral\ \-\ MA",
"55833380", "Puxinanã\ \-\ PB",
"55123842", "Ubatuba\ \-\ SP",
"55873874", "Ouricuri\ \-\ PE",
"55513423", "Gravataí\ \-\ RS",
"55173329", "Alberto\ Moreira\ \-\ SP",
"55553792", "Pinheirinho\ do\ Vale\ \-\ RS",
"55453230", "Diamante\ do\ Sul\ \-\ PR",
"55773401", "Vitória\ da\ Conquista\ \-\ BA",
"55423250", "Abapã\ \-\ PR",
"55193716", "Campinas\ \-\ SP",
"55313522", "Minas\ Gerais",
"5586", "Piauí",
"55153573", "Barão\ de\ Antonina\ \-\ SP",
"55513054", "Viamão\ \-\ RS",
"5515322", "Sorocaba\ \-\ SP",
"55112751", "São\ Paulo\ \-\ SP",
"55273315", "Vitória\ \-\ ES",
"55323559", "Visconde\ do\ Rio\ Branco\ \-\ MG",
"55863251", "São\ João\ da\ Serra\ \-\ PI",
"55113988", "Guarulhos\ \-\ SP",
"55353539", "São\ Sebastião\ do\ Paraíso\ \-\ MG",
"55163263", "Itápolis\ \-\ SP",
"55313761", "Conselheiro\ Lafaiete\ \-\ MG",
"55463025", "Pato\ Branco\ \-\ PR",
"55643542", "Itumbiara\ \-\ GO",
"55833359", "Congo\ \-\ PB",
"55873841", "Sertânia\ \-\ PE",
"55513697", "Brochier\ \-\ RS",
"55813613", "Limoeiro\ \-\ PE",
"55483534", "Santa\ Rosa\ do\ Sul\ \-\ SC",
"55733295", "Itanhém\ \-\ BA",
"55123019", "São\ José\ dos\ Campos\ \-\ SP",
"55913287", "Ananindeua\ \-\ PA",
"55483131", "Florianópolis\ \-\ SC",
"55733296", "Medeiros\ Neto\ \-\ BA",
"55313242", "Minas\ Gerais",
"55423634", "Campina\ do\ Simão\ \-\ PR",
"55663461", "Jaciara\ \-\ MT",
"55112304", "Guarulhos\ \-\ SP",
"55543358", "Lagoa\ Vermelha\ \-\ RS",
"55423438", "Guamiranga\ \-\ PR",
"55353826", "Lavras\ \-\ MG",
"55623586", "Goiânia\ \-\ GO",
"55813351", "Recife\ \-\ PE",
"55883115", "Juazeiro\ do\ Norte\ \-\ CE",
"55133505", "Mongaguá\ \-\ SP",
"55133506", "Mongaguá\ \-\ SP",
"55653053", "Várzea\ Grande\ \-\ MT",
"55923223", "Manaus\ \-\ AM",
"55493321", "Chapecó\ \-\ SC",
"55473330", "Blumenau\ \-\ SC",
"55353825", "Itutinga\ \-\ MG",
"55114892", "Bragança\ Paulista\ \-\ SP",
"5544326", "Maringá\ \-\ PR",
"55183601", "Bento\ de\ Abreu\ \-\ SP",
"55693413", "Urupá\ \-\ RO",
"55313555", "Minas\ Gerais",
"55123104", "Aparecida\ \-\ SP",
"55114624", "Osasco\ \-\ SP",
"5517332", "Barretos\ \-\ SP",
"55493018", "Lages\ \-\ SC",
"55513672", "Tapes\ \-\ RS",
"55313556", "Mariana\ \-\ MG",
"55743221", "Senhor\ do\ Bonfim\ \-\ BA",
"55493677", "Itapiranga\ \-\ SC",
"55434007", "Londrina\ \-\ PR",
"55623277", "Aparecida\ de\ Goiânia\ \-\ GO",
"55643565", "Itumbiara\ \-\ GO",
"55114428", "Santo\ André\ \-\ SP",
"55143885", "Pirambóia\ \-\ SP",
"55753643", "Valença\ \-\ BA",
"55543231", "Vacaria\ \-\ RS",
"55913724", "Benevides\ \-\ PA",
"55933558", "Belterra\ \-\ PA",
"55163728", "São\ Joaquim\ da\ Barra\ \-\ SP",
"55833481", "Água\ Branca\ \-\ PB",
"55383811", "Monte\ Azul\ \-\ MG",
"55212186", "Nilópolis\ \-\ RJ",
"55193439", "Saltinho\ \-\ SP",
"55143886", "Pardinho\ \-\ SP",
"55423560", "Fluviópolis\ \-\ PR",
"55853366", "Fortaleza\ \-\ CE",
"55513285", "Rio\ Grande\ do\ Sul",
"55183377", "Florínia\ \-\ SP",
"55423663", "Palmeirinha\ \-\ PR",
"55733687", "Caravelas\ \-\ BA",
"55493301", "Concórdia\ \-\ SC",
"55534007", "Pelotas\ \-\ RS",
"55313841", "Coronel\ Fabriciano\ \-\ MG",
"55673673", "Jateí\ \-\ MS",
"55413672", "Quatro\ Barras\ \-\ PR",
"55623997", "Goiânia\ \-\ GO",
"55853365", "Canindé\ \-\ CE",
"55482101", "Criciúma\ \-\ SC",
"55443231", "Itambé\ \-\ PR",
"55623394", "Santa\ Rita\ do\ Novo\ Destino\ \-\ GO",
"55473626", "São\ Bento\ do\ Sul\ \-\ SC",
"55833268", "João\ Pessoa\ \-\ PB",
"55863133", "Teresina\ \-\ PI",
"55493804", "Lages\ \-\ SC",
"55513592", "São\ Leopoldo\ \-\ RS",
"55633367", "Tocantínia\ \-\ TO",
"55473625", "Irineópolis\ \-\ SC",
"55373351", "Arcos\ \-\ MG",
"55813145", "Vitória\ de\ Santo\ Antão\ \-\ PE",
"55213632", "Magé\ \-\ RJ",
"5596", "Amapá",
"55353722", "Poços\ de\ Caldas\ \-\ MG",
"55114408", "Cajamar\ \-\ SP",
"55352103", "Pouso\ Alegre\ \-\ MG",
"55973415", "Benjamin\ Constant\ \-\ AM",
"55313470", "Minas\ Gerais",
"55443683", "Doutor\ Oliveira\ Castro\ \-\ PR",
"55163708", "Franca\ \-\ SP",
"55613963", "Brasília\ \-\ DF",
"55663211", "Sinop\ \-\ MT",
"55333343", "Alto\ Jequitibá\ \-\ MG",
"55173248", "Mendonça\ \-\ SP",
"55183621", "Araçatuba\ \-\ SP",
"55513718", "Vera\ Cruz\ \-\ RS",
"55493572", "Matos\ Costa\ \-\ SC",
"55883643", "Massapê\ \-\ CE",
"55212391", "Rio\ de\ Janeiro\ \-\ RJ",
"55313739", "Minas\ Gerais",
"55673455", "Rio\ Brilhante\ \-\ MS",
"55353561", "Carmo\ do\ Rio\ Claro\ \-\ MG",
"55673456", "Nova\ Alvorada\ do\ Sul\ \-\ MS",
"55813510", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55143307", "Ibirarema\ \-\ SP",
"55123521", "Pindamonhangaba\ \-\ SP",
"55373238", "Pará\ de\ Minas\ \-\ MG",
"55513781", "Rio\ Grande\ do\ Sul",
"55963251", "Macapá\ \-\ AP",
"55823543", "Teotônio\ Vilela\ \-\ AL",
"55114604", "Mairiporã\ \-\ SP",
"55122134", "São\ José\ dos\ Campos\ \-\ SP",
"55793411", "Nossa\ Senhora\ da\ Glória\ \-\ SE",
"55513456", "Canoas\ \-\ RS",
"55433901", "Apucarana\ \-\ PR",
"55653052", "Cuiabá\ \-\ MT",
"55633439", "Itacajá\ \-\ TO",
"55113362", "São\ Paulo\ \-\ SP",
"55173201", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55513455", "Rio\ Grande\ do\ Sul",
"55533026", "Pelotas\ \-\ RS",
"5511439", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55443276", "Maringá\ \-\ PR",
"5511257", "São\ Paulo\ \-\ SP",
"55173694", "Dirce\ Reis\ \-\ SP",
"55613605", "Cidade\ Ocidental\ \-\ GO",
"55313243", "Minas\ Gerais",
"55222791", "Macaé\ \-\ RJ",
"55323339", "Barbacena\ \-\ MG",
"55833539", "Triunfo\ \-\ PB",
"55613606", "Santo\ Antônio\ do\ Descoberto\ \-\ GO",
"55114441", "Caieiras\ \-\ SP",
"55443275", "Barbosa\ Ferraz\ \-\ PR",
"55193581", "Porto\ Ferreira\ \-\ SP",
"55533025", "Pelotas\ \-\ RS",
"55473337", "Blumenau\ \-\ SC",
"55162108", "Araraquara\ \-\ SP",
"55483205", "Florianópolis\ \-\ SC",
"55163246", "Taiúva\ \-\ SP",
"55513649", "Montenegro\ \-\ RS",
"55443125", "Marialva\ \-\ PR",
"55753642", "Jaguaripe\ \-\ BA",
"553136", "Minas\ Gerais",
"55713118", "Salvador\ \-\ BA",
"55163839", "Ituverava\ \-\ SP",
"55873828", "Tuparetama\ \-\ PE",
"55343257", "Uberlândia\ \-\ MG",
"55883547", "Caririaçu\ \-\ CE",
"55543361", "Sarandi\ \-\ RS",
"55423906", "Castro\ \-\ PR",
"55113414", "Itu\ \-\ SP",
"55213664", "Belford\ Roxo\ \-\ RJ",
"55493348", "União\ do\ Oeste\ \-\ SC",
"55513673", "Mostardas\ \-\ RS",
"55193933", "Paulínia\ \-\ SP",
"55533921", "Pelotas\ \-\ RS",
"55673286", "Camapuã\ \-\ MS",
"55333244", "Galiléia\ \-\ MG",
"55673285", "Jaraguari\ \-\ MS",
"55823647", "Pariconha\ \-\ AL",
"55693412", "Alvorada\ do\ Oeste\ \-\ RO",
"55193792", "Limeira\ \-\ SP",
"55423519", "União\ da\ Vitória\ \-\ PR",
"55513690", "Rio\ Grande\ do\ Sul",
"55242225", "Petrópolis\ \-\ RJ",
"55114893", "Campo\ Limpo\ Paulista\ \-\ SP",
"55823256", "Flexeiras\ \-\ AL",
"55993631", "São\ Luís\ Gonzaga\ do\ Maranhão\ \-\ MA",
"55193895", "Socorro\ \-\ SP",
"55613625", "Cidade\ Ocidental\ \-\ GO",
"55413649", "Campo\ Largo\ \-\ PR",
"55624106", "Trindade\ \-\ GO",
"55513593", "Novo\ Hamburgo\ \-\ RS",
"55813517", "São\ Lourenço\ da\ Mata\ \-\ PE",
"55313014", "Belo\ Horizonte\ \-\ MG",
"55613626", "Santo\ Antônio\ do\ Descoberto\ \-\ GO",
"55173802", "Paulo\ de\ Faria\ \-\ SP",
"55734102", "Ilhéus\ \-\ BA",
"55624105", "Senador\ Canedo\ \-\ GO",
"55483721", "Florianópolis\ \-\ SC",
"55823255", "Colônia\ Leopoldina\ \-\ AL",
"55193896", "Santo\ Antônio\ de\ Posse\ \-\ SP",
"55413673", "Piraquara\ \-\ PR",
"55673672", "Rio\ Brilhante\ \-\ MS",
"55113264", "Salvador\ \-\ BA",
"55443361", "Umuarama\ \-\ PR",
"55453211", "Santa\ Maria\ \-\ PR",
"55923324", "Presidente\ Figueiredo\ \-\ AM",
"55353558", "São\ Sebastião\ do\ Paraíso\ \-\ MG",
"55423662", "Paz\ \-\ PR",
"55453288", "Santa\ Lúcia\ \-\ PR",
"55323538", "Presidente\ Bernardes\ \-\ MG",
"55183648", "Juritis\ \-\ SP",
"55412118", "Curitiba\ \-\ PR",
"55823542", "São\ Sebastião\ \-\ AL",
"5511269", "São\ Paulo\ \-\ SP",
"55793261", "São\ Cristóvão\ \-\ SE",
"55114031", "Bragança\ Paulista\ \-\ SP",
"55313828", "Minas\ Gerais",
"55112848", "São\ Paulo\ \-\ SP",
"55893425", "Sussuapara\ \-\ PI",
"55433478", "Lunardelli\ \-\ PR",
"55413456", "Matinhos\ \-\ PR",
"55893426", "Geminiano\ \-\ PI",
"55883642", "Moraújo\ \-\ CE",
"55413455", "Pontal\ do\ Paraná\ \-\ PR",
"55493573", "Calmon\ \-\ SC",
"55773671", "Sítio\ do\ Mato\ \-\ BA",
"5549322", "Lages\ \-\ SC",
"55923084", "Manaus\ \-\ AM",
"55713396", "Simões\ Filho\ \-\ BA",
"55333342", "Durandé\ \-\ MG",
"5583", "Paraiba",
"5516391", "Ribeirão\ Preto\ \-\ SP",
"55613962", "Brasília\ \-\ DF",
"55343459", "Frutal\ \-\ MG",
"55833251", "João\ Pessoa\ \-\ PB",
"55174003", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55634101", "Palmas\ \-\ TO",
"55693526", "Jaru\ \-\ RO",
"55543276", "Protásio\ Alves\ \-\ RS",
"55493549", "Vargem\ \-\ SC",
"55273767", "São\ Mateus\ \-\ ES",
"55693525", "Vale\ do\ Anari\ \-\ RO",
"55543275", "Nova\ Araçá\ \-\ RS",
"55352102", "Pouso\ Alegre\ \-\ MG",
"55733680", "Ilhéus\ \-\ BA",
"55213633", "Guapimirim\ \-\ RJ",
"55413601", "Pinhais\ \-\ PR",
"55163729", "Ituverava\ \-\ SP",
"55183285", "Caiabu\ \-\ SP",
"55933559", "Trairão\ \-\ PA",
"55543380", "Ibirapuitã\ \-\ RS",
"55813846", "Santa\ Cruz\ da\ Baixa\ Verde\ \-\ PE",
"55353361", "Itanhandu\ \-\ MG",
"55314114", "Conselheiro\ Lafaiete\ \-\ MG",
"55123321", "São\ José\ dos\ Campos\ \-\ SP",
"55183286", "Anhumas\ \-\ SP",
"55833419", "Santa\ Teresinha\ \-\ PB",
"55823343", "Maceió\ \-\ AL",
"55493019", "Lages\ \-\ SC",
"55633519", "Lajeado\ \-\ TO",
"55613632", "Formosa\ \-\ GO",
"55553257", "São\ Vicente\ do\ Sul\ \-\ RS",
"55473633", "São\ Bento\ do\ Sul\ \-\ SC",
"55713283", "Salvador\ \-\ BA",
"55353864", "Perdões\ \-\ MG",
"55853304", "Fortaleza\ \-\ CE",
"55623594", "Aparecida\ de\ Goiânia\ \-\ GO",
"55114666", "Itapecerica\ da\ Serra\ \-\ SP",
"55793457", "Macambira\ \-\ SE",
"55863276", "Piripiri\ \-\ PI",
"55442102", "Maringá\ \-\ PR",
"55483232", "Florianópolis\ \-\ SC",
"55314009", "Belo\ Horizonte\ \-\ MG",
"55112524", "São\ Paulo\ \-\ SP",
"55843424", "Ipueira\ \-\ RN",
"55543359", "Vila\ Maria\ \-\ RS",
"55114665", "Embu\-Guaçu\ \-\ SP",
"55713631", "Itaparica\ \-\ BA",
"55693532", "Cacaulândia\ \-\ RO",
"55373551", "Dores\ do\ Indaiá\ \-\ MG",
"55313544", "Betim\ \-\ MG",
"55433032", "Londrina\ \-\ PR",
"55243324", "Barra\ Mansa\ \-\ RJ",
"55893432", "Cajazeiras\ do\ Piauí\ \-\ PI",
"55913765", "Salvaterra\ \-\ PA",
"55513621", "Capão\ Novo\ \-\ RS",
"55833467", "São\ José\ do\ Sabugi\ \-\ PB",
"55733284", "Canavieiras\ \-\ BA",
"55123677", "Natividade\ da\ Serra\ \-\ SP",
"55123018", "São\ José\ dos\ Campos\ \-\ SP",
"55483093", "Palhoça\ \-\ SC",
"55433270", "Santa\ Cecília\ do\ Pavão\ \-\ PR",
"55753340", "Marcionílio\ Souza\ \-\ BA",
"55173836", "Cosmorama\ \-\ SP",
"55993584", "Lajeado\ Novo\ \-\ MA",
"55183697", "Rubiácea\ \-\ SP",
"55542992", "Caxias\ do\ Sul\ \-\ RS",
"55542102", "Bento\ Gonçalves\ \-\ RS",
"55993118", "Timon\ \-\ MA",
"55115094", "São\ Paulo\ \-\ SP",
"55713452", "Salvador\ \-\ BA",
"55513719", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55173249", "Potirendaba\ \-\ SP",
"55853324", "Caridade\ \-\ CE",
"55313738", "São\ Brás\ do\ Suaçuí\ \-\ MG",
"55413392", "Campo\ Largo\ \-\ PR",
"55343812", "Lagamar\ \-\ MG",
"55684003", "Rio\ Branco\ \-\ AC",
"55733661", "Vereda\ \-\ BA",
"55514", "Rio\ Grande\ do\ Sul",
"55433442", "Bom\ Sucesso\ \-\ PR",
"55533293", "Rio\ Grande\ \-\ RS",
"55933735", "Monte\ Dourado\ \-\ PA",
"55833217", "Santa\ Rita\ \-\ PB",
"55193663", "Divinolândia\ \-\ SP",
"55143602", "Jaú\ \-\ SP",
"55353833", "Candeias\ \-\ MG",
"55743686", "Ibipeba\ \-\ BA",
"55633381", "Conceição\ do\ Tocantins\ \-\ TO",
"55212886", "Nova\ Iguaçu\ \-\ RJ",
"55413621", "Colombo\ \-\ PR",
"55424101", "Guarapuava\ \-\ PR",
"55743685", "Mundo\ Novo\ \-\ BA",
"55313356", "Contagem\ \-\ MG",
"55123301", "Lorena\ \-\ SP",
"55114409", "Jacaré\ \-\ SP",
"5511316", "São\ Paulo\ \-\ SP",
"55933736", "Munguba\ \-\ PA",
"55623386", "Faina\ \-\ GO",
"55643504", "Americano\ do\ Brasil\ \-\ GO",
"55813551", "Ipojuca\ \-\ PE",
"55114177", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55513601", "Osório\ \-\ RS",
"55114784", "São\ Roque\ \-\ SP",
"55133305", "Guarujá\ \-\ SP",
"55843608", "Natal\ \-\ RN",
"55163353", "Ibaté\ \-\ SP",
"55493521", "Joaçaba\ \-\ SC",
"55773623", "São\ Desidério\ \-\ BA",
"55913411", "Capanema\ \-\ PA",
"55623385", "Nova\ Crixás\ \-\ GO",
"55813742", "Cachoeirinha\ \-\ PE",
"55853084", "Fortaleza\ \-\ CE",
"55483334", "Florianópolis\ \-\ SC",
"55453257", "Entre\ Rios\ do\ Oeste\ \-\ PR",
"55212671", "Duque\ de\ Caxias\ \-\ RJ",
"55423237", "Piraí\ do\ Sul\ \-\ PR",
"55513767", "Tunas\ \-\ RS",
"55793259", "Aracaju\ \-\ SE",
"55112897", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55953542", "Mucajaí\ \-\ RR",
"55623921", "Goiânia\ \-\ GO",
"55673444", "Taquarussu\ \-\ MS",
"55153491", "Salto\ de\ Pirapora\ \-\ SP",
"55112504", "São\ Paulo\ \-\ SP",
"55153241", "Ibiúna\ \-\ SP",
"55553289", "Vale\ Vêneto\ \-\ RS",
"55312138", "Belo\ Horizonte\ \-\ MG",
"55513444", "Viamão\ \-\ RS",
"55493349", "Irati\ \-\ SC",
"55473632", "Campo\ Alegre\ \-\ SC",
"55323251", "Santos\ Dumont\ \-\ MG",
"55813099", "Olinda\ \-\ PE",
"55613633", "Padre\ Bernardo\ \-\ GO",
"55543702", "Bento\ Gonçalves\ \-\ RS",
"55313128", "Jaboticatubas\ \-\ MG",
"55333751", "Pedra\ Azul\ \-\ MG",
"551", "São\ Paulo",
"55313809", "Santa\ Bárbara\ \-\ MG",
"55823342", "Maceió\ \-\ AL",
"5511467", "Ferraz\ de\ Vasconcelos\ \-\ SP",
"5532", "Minas\ Gerais",
"55873829", "Ingazeira\ \-\ PE",
"55193567", "Santa\ Cruz\ da\ Conceição\ \-\ SP",
"55163838", "Ituverava\ \-\ SP",
"55823013", "Maceió\ \-\ AL",
"55413034", "Piraquara\ \-\ PR",
"55843641", "Natal\ \-\ RN",
"55162109", "Araraquara\ \-\ SP",
"55833538", "São\ José\ da\ Lagoa\ Tapada\ \-\ PB",
"55163254", "Guariroba\ \-\ SP",
"55283037", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55214503", "Rio\ de\ Janeiro\ \-\ RJ",
"55222727", "São\ Francisco\ de\ Itabapoana\ \-\ RJ",
"55923524", "Urucurituba\ \-\ AM",
"5512320", "São\ José\ dos\ Campos\ \-\ SP",
"55553250", "Nova\ Esperança\ do\ Sul\ \-\ RS",
"55193519", "Campinas\ \-\ SP",
"55323338", "Madre\ de\ Deus\ de\ Minas\ \-\ MG",
"55893433", "Monsenhor\ Hipólito\ \-\ PI",
"55713167", "Salvador\ \-\ BA",
"55433033", "Apucarana\ \-\ PR",
"55353735", "Caldas\ \-\ MG",
"5518390", "Presidente\ Prudente\ \-\ SP",
"55693533", "Porto\ Velho\ \-\ RO",
"55323755", "Vieiras\ \-\ MG",
"55543387", "Selbach\ \-\ RS",
"55213626", "Rio\ de\ Janeiro\ \-\ RJ",
"55224105", "Nova\ Friburgo\ \-\ RJ",
"55442103", "Maringá\ \-\ PR",
"55613218", "Brasília\ \-\ DF",
"55633438", "Recursolândia\ \-\ TO",
"55353736", "Cabo\ Verde\ \-\ MG",
"55513370", "Rio\ Grande\ do\ Sul",
"55873809", "Iguaraci\ \-\ PE",
"55493548", "Vargem\ Bonita\ \-\ SC",
"55173272", "Tanabi\ \-\ SP",
"5511568", "São\ Paulo\ \-\ SP",
"55683248", "Rio\ Branco\ \-\ AC",
"55682106", "Rio\ Branco\ \-\ AC",
"55513760", "Colinas\ \-\ RS",
"55353832", "Campo\ Belo\ \-\ MG",
"55193662", "Caconde\ \-\ SP",
"55213267", "Rio\ de\ Janeiro\ \-\ RJ",
"55473537", "Chapadão\ do\ Lageado\ \-\ SC",
"55343654", "Santa\ Rosa\ da\ Serra\ \-\ MG",
"55343813", "Vazante\ \-\ MG",
"55413063", "Curitiba\ \-\ PR",
"55413393", "Campo\ Largo\ \-\ PR",
"55923365", "Novo\ Airão\ \-\ AM",
"55713453", "Salvador\ \-\ BA",
"55963217", "Macapá\ \-\ AP",
"55613468", "Brasília\ \-\ DF",
"55542103", "Passo\ Fundo\ \-\ RS",
"55112849", "São\ Paulo\ \-\ SP",
"55222661", "Araruama\ \-\ RJ",
"55113175", "São\ Paulo\ \-\ SP",
"55443133", "Mandaguari\ \-\ PR",
"55353559", "Guaxupé\ \-\ MG",
"55893464", "Caridade\ do\ Piauí\ \-\ PI",
"55953543", "Iracema\ \-\ RR",
"55183649", "Birigui\ \-\ SP",
"55323539", "Ubá\ \-\ MG",
"55124004", "São\ José\ dos\ Campos\ \-\ SP",
"5515301", "Sorocaba\ \-\ SP",
"55813743", "Camocim\ de\ São\ Félix\ \-\ PE",
"55713676", "Mata\ de\ São\ João\ \-\ BA",
"55213219", "Rio\ de\ Janeiro\ \-\ RJ",
"55773622", "Angical\ \-\ BA",
"55173122", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55943386", "Lindoeste\ \-\ PA",
"55483264", "Canelinha\ \-\ SC",
"55163352", "Ibitinga\ \-\ SP",
"55413648", "Bateias\ \-\ PR",
"55513034", "Sapucaia\ do\ Sul\ \-\ RS",
"55943385", "Vila\ Santa\ Fé\ \-\ PA",
"55433064", "Londrina\ \-\ PR",
"55193884", "Paulínia\ \-\ SP",
"55513582", "Novo\ Hamburgo\ \-\ RS",
"55114785", "Embu\ das\ Artes\ \-\ SP",
"55434104", "Apucarana\ \-\ PR",
"55222673", "Araruama\ \-\ RJ",
"55453038", "Cascavel\ \-\ PR",
"55623384", "Taquaral\ de\ Goiás\ \-\ GO",
"55183022", "Assis\ \-\ SP",
"55333611", "Águas\ Formosas\ \-\ MG",
"55114786", "Taboão\ da\ Serra\ \-\ SP",
"55694001", "Porto\ Velho\ \-\ RO",
"55813155", "Gravatá\ \-\ PE",
"55643412", "Itumbiara\ \-\ GO",
"55823553", "Porto\ Real\ do\ Colégio\ \-\ AL",
"55673446", "Angélica\ \-\ MS",
"55112506", "São\ Paulo\ \-\ SP",
"55913733", "Murucupi\ \-\ PA",
"55673445", "Anaurilândia\ \-\ MS",
"55883653", "Ibiapina\ \-\ CE",
"55843405", "Currais\ Novos\ \-\ RN",
"55353521", "Passos\ \-\ MG",
"55173258", "Bady\ Bassitt\ \-\ SP",
"55333353", "Pingo\-D\'Água\ \-\ MG",
"55733697", "Travessão\ \-\ BA",
"55313851", "João\ Monlevade\ \-\ MG",
"55115095", "São\ Paulo\ \-\ SP",
"55853326", "Capistrano\ \-\ CE",
"5554322", "Caxias\ do\ Sul\ \-\ RS",
"55353274", "Olímpio\ Noronha\ \-\ MG",
"55273720", "Itarana\ \-\ ES",
"55112861", "São\ Paulo\ \-\ SP",
"55993586", "Ribamar\ Fiquene\ \-\ MA",
"55173834", "Guarani\ D\'Oeste\ \-\ SP",
"55113303", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55853325", "Pacoti\ \-\ CE",
"55483523", "Maracajá\ \-\ SC",
"55153467", "Capela\ do\ Alto\ \-\ SP",
"55373341", "Itapecerica\ \-\ MG",
"55983337", "Alcântara\ \-\ MA",
"55733672", "Santa\ Cruz\ Cabrália\ \-\ BA",
"55833228", "Cabedelo\ \-\ PB",
"55794002", "Aracaju\ \-\ SE",
"55493275", "Otacílio\ Costa\ \-\ SC",
"55143581", "Pongaí\ \-\ SP",
"55663401", "Barra\ do\ Garças\ \-\ MT",
"55173331", "Guaíra\ \-\ SP",
"55743684", "Canarana\ \-\ BA",
"55443573", "Iretama\ \-\ PR",
"5544322", "Maringá\ \-\ PR",
"55843426", "Serra\ Negra\ do\ Norte\ \-\ RN",
"55133821", "Registro\ \-\ SP",
"55313546", "Minas\ Gerais",
"55623595", "Goiânia\ \-\ GO",
"55313545", "Rio\ Acima\ \-\ MG",
"55623596", "Aparecida\ de\ Goiânia\ \-\ GO",
"55114664", "Embu\-Guaçu\ \-\ SP",
"55753311", "Santo\ Antônio\ de\ Jesus\ \-\ BA",
"55223066", "Nova\ Friburgo\ \-\ RJ",
"55843425", "São\ João\ do\ Sabugi\ \-\ RN",
"55863274", "Brasileira\ \-\ PI",
"55114468", "Santo\ André\ \-\ SP",
"55733286", "Itapebi\ \-\ BA",
"55122123", "Taubaté\ \-\ SP",
"55133202", "Santos\ \-\ SP",
"55714007", "Salvador\ \-\ BA",
"55913764", "São\ Sebastião\ da\ Boa\ Vista\ \-\ PA",
"55133324", "Santos\ \-\ SP",
"55463313", "Pato\ Branco\ \-\ PR",
"55243325", "Barra\ Mansa\ \-\ RJ",
"55353067", "Varginha\ \-\ MG",
"55753653", "Cairu\ \-\ BA",
"55513687", "Arroio\ do\ Sal\ \-\ RS",
"55123027", "São\ José\ dos\ Campos\ \-\ SP",
"55473902", "Jaraguá\ do\ Sul\ \-\ SC",
"55733285", "Potiraguá\ \-\ BA",
"55623282", "Aparecida\ de\ Goiânia\ \-\ GO",
"55273137", "Vitória\ \-\ ES",
"55123133", "Guaratinguetá\ \-\ SP",
"55423520", "São\ Mateus\ do\ Sul\ \-\ PR",
"55643526", "Itumbiara\ \-\ GO",
"55753475", "Porto\ de\ Sauipe\ \-\ BA",
"55833208", "João\ Pessoa\ \-\ PB",
"55773439", "Encruzilhada\ \-\ BA",
"55183284", "Rosana\ \-\ SP",
"55413582", "Curitiba\ \-\ PR",
"55623004", "Goiânia\ \-\ GO",
"55873851", "Petrolândia\ \-\ PE",
"55314115", "Lagoa\ Santa\ \-\ MG",
"55663421", "Rondonópolis\ \-\ MT",
"55323229", "Juiz\ de\ Fora\ \-\ MG",
"55653312", "Santo\ Afonso\ \-\ MT",
"5554320", "Caxias\ do\ Sul\ \-\ RS",
"55353866", "Santana\ do\ Jacaré\ \-\ MG",
"55853306", "Fortaleza\ \-\ CE",
"55114882", "Carapicuíba\ \-\ SP",
"55853305", "Fortaleza\ \-\ CE",
"55543348", "Água\ Santa\ \-\ RS",
"55353865", "Cana\ Verde\ \-\ MG",
"55493361", "Chapecó\ \-\ SC",
"55813341", "Recife\ \-\ PE",
"55713025", "Salvador\ \-\ BA",
"55333352", "São\ Pedro\ dos\ Ferros\ \-\ MG",
"55313868", "Conceição\ do\ Mato\ Dentro\ \-\ MG",
"55793221", "Aracaju\ \-\ SE",
"55443018", "Cianorte\ \-\ PR",
"55883652", "Guaraciaba\ do\ Norte\ \-\ CE",
"55893465", "Valença\ do\ Piauí\ \-\ PI",
"55913732", "Acará\ \-\ PA",
"55623959", "Niquelândia\ \-\ GO",
"55443677", "Tapejara\ \-\ PR",
"55213604", "Niterói\ \-\ RJ",
"55823552", "Piaçabuçu\ \-\ AL",
"55113571", "São\ Paulo\ \-\ SP",
"55713026", "Lauro\ de\ Freitas\ \-\ BA",
"55643413", "Morrinhos\ \-\ GO",
"55513036", "Novo\ Hamburgo\ \-\ RS",
"55483265", "São\ João\ Batista\ \-\ SC",
"55983182", "São\ Luís\ \-\ MA",
"55433066", "Londrina\ \-\ PR",
"55193886", "Vinhedo\ \-\ SP",
"55193924", "Águas\ de\ Lindóia\ \-\ SP",
"55193885", "Indaiatuba\ \-\ SP",
"55273727", "São\ Gabriel\ da\ Palha\ \-\ ES",
"55513583", "Rio\ Grande\ do\ Sul",
"55483266", "Florianópolis\ \-\ SC",
"55513035", "Novo\ Hamburgo\ \-\ RS",
"55673687", "Miranda\ \-\ MS",
"55913447", "Cachoeira\ do\ Piriá\ \-\ PA",
"55794003", "Aracaju\ \-\ SE",
"55313482", "Minas\ Gerais",
"55733673", "Arataca\ \-\ BA",
"55753431", "Inhambupe\ \-\ BA",
"55413659", "Tunas\ \-\ PR",
"55183658", "Clementina\ \-\ SP",
"55483522", "Araranguá\ \-\ SC",
"55553421", "Alegrete\ \-\ RS",
"55923364", "Caapiranga\ \-\ AM",
"55513931", "Porto\ Alegre\ \-\ RS",
"55193671", "Casa\ Branca\ \-\ SP",
"55933067", "Santarém\ \-\ PA",
"55693222", "Porto\ Velho\ \-\ RO",
"55173261", "Nova\ Granada\ \-\ SP",
"55114537", "Jundiaí\ \-\ SP",
"55123132", "Guaratinguetá\ \-\ SP",
"55623283", "Aparecida\ de\ Goiânia\ \-\ GO",
"55473903", "Joinville\ \-\ SC",
"55493735", "Fazenda\ Zandavalli\ \-\ SC",
"55753652", "Cairu\ \-\ BA",
"55513659", "Rio\ Grande\ do\ Sul",
"55163256", "Santa\ Ernestina\ \-\ SP",
"55133203", "Santos\ \-\ SP",
"55873868", "Afrânio\ \-\ PE",
"5517323", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55222781", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55193904", "Mogi\ Mirim\ \-\ SP",
"55813915", "Aripibu\ \-\ PE",
"55193307", "Campinas\ \-\ SP",
"55543321", "Erechim\ \-\ RS",
"55242266", "Werneck\ \-\ RJ",
"55323754", "São\ Francisco\ do\ Glória\ \-\ MG",
"55333254", "Perpétuo\ Socorro\ \-\ MG",
"55453421", "Toledo\ \-\ PR",
"55353734", "Santa\ Rita\ de\ Caldas\ \-\ MG",
"55883557", "Porteiras\ \-\ CE",
"55493358", "Cordilheira\ Alta\ \-\ SC",
"55443572", "Piquirivaí\ \-\ PR",
"55224104", "Macaé\ \-\ RJ",
"55212634", "Maricá\ \-\ RJ",
"55673295", "São\ Gabriel\ do\ Oeste\ \-\ MS",
"55414122", "Curitiba",
"55513445", "Presidente\ Lucena\ \-\ RS",
"55553401", "Uruguaiana\ \-\ RS",
"55513680", "Quintão\ \-\ RS",
"55743258", "Baixa\ Grande\ \-\ BA",
"55133848", "Iguape\ \-\ SP",
"55353373", "Virgínia\ \-\ MG",
"55983469", "Urbano\ Santos\ \-\ MA",
"55883431", "Itapiúna\ \-\ CE",
"55653313", "Cuiabá\ \-\ MT",
"55513446", "Viamão\ \-\ RS",
"55413036", "Almirante\ Tamandaré\ \-\ PR",
"55713594", "Simões\ Filho\ \-\ BA",
"55153339", "Sorocaba\ \-\ SP",
"55163751", "Buritizal\ \-\ SP",
"55313253", "Belo\ Horizonte\ \-\ MG",
"55623631", "Jataí\ \-\ GO",
"55933521", "Vila\ Residencial\ Belo\ Monte\ \-\ PA",
"55413035", "São\ José\ dos\ Pinhais\ \-\ PR",
"55242522", "Nova\ Friburgo\ \-\ RJ",
"55273382", "Vitória\ \-\ ES",
"55863321", "Parnaíba\ \-\ PI",
"55112533", "São\ Paulo\ \-\ SP",
"55163343", "Ibaté\ \-\ SP",
"55683261", "Humaitá\ \(Pad\ Humaitá\)\ \-\ AC",
"55112085", "Guarulhos\ \-\ SP",
"55843433", "Acari\ \-\ RN",
"55533283", "Pelotas\ \-\ RS",
"55483303", "Florianópolis\ \-\ SC",
"55173280", "Olímpia\ \-\ SP",
"55112086", "Guarulhos\ \-\ SP",
"55343421", "Frutal\ \-\ MG",
"55833229", "Santa\ Rita\ \-\ PB",
"55813541", "Abreu\ e\ Lima\ \-\ PE",
"55493561", "Caçador\ \-\ SC",
"55773663", "Morpará\ \-\ BA",
"55953552", "Bonfim\ \-\ RR",
"55673454", "Maracaju\ \-\ MS",
"55513727", "Rio\ Grande\ do\ Sul",
"55413382", "São\ José\ dos\ Pinhais\ \-\ PR",
"55163379", "Fazenda\ Babilônia\ \-\ SP",
"55643086", "Itumbiara\ \-\ GO",
"55114606", "Várzea\ Paulista\ \-\ SP",
"55122136", "São\ José\ dos\ Campos\ \-\ SP",
"55643533", "Itumbiara\ \-\ GO",
"55114605", "Caieiras\ \-\ SP",
"55133271", "Santos\ \-\ SP",
"55243333", "Arrozal\ \-\ RJ",
"55754141", "Feira\ de\ Santana\ \-\ BA",
"55453247", "Penha\ \-\ PR",
"55112887", "Itaquaquecetuba\ \-\ SP",
"55473428", "Dona\ Francisca\ SC\ 301\ \-\ SC",
"55913694", "Anapu\ \-\ PA",
"55853364", "Umirim\ \-\ CE",
"55913822", "Quatipuru\ \-\ PA",
"55733621", "Dário\ Meira\ \-\ BA",
"55193623", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55123833", "Ubatuba\ \-\ SP",
"55313346", "Belo\ Horizonte\ \-\ MG",
"55623396", "Itaguari\ \-\ GO",
"55473624", "Canoinhas\ \-\ SC",
"55863081", "Teresina\ \-\ PI",
"55353301", "Poços\ de\ Caldas\ \-\ MG",
"55433452", "Borrazópolis\ \-\ PR",
"55453039", "Cascavel\ \-\ PR",
"55633602", "Paraíso\ do\ Tocantins\ \-\ TO",
"55183582", "Parapuã\ \-\ SP",
"55123105", "Aparecida\ \-\ SP",
"55373541", "Abaeté\ \-\ MG",
"55513707", "Lajeado\ \-\ RS",
"55313554", "Lavras\ Novas\ \-\ MG",
"55914003", "Belém\ \-\ PA",
"55713270", "Salvador\ \-\ BA",
"55543349", "São\ Domingos\ do\ Sul\ \-\ RS",
"55313151", "Sete\ Lagoas\ \-\ MG",
"55793447", "Frei\ Paulo\ \-\ SE",
"55153268", "Boituva\ \-\ SP",
"55123682", "Taubaté\ \-\ SP",
"55143318", "Marília\ \-\ SP",
"55173531", "Catanduva\ \-\ SP",
"55323228", "Juiz\ de\ Fora\ \-\ MG",
"55333728", "Bandeira\ \-\ MG",
"55633527", "Santa\ Tereza\ do\ Tocantins\ \-\ TO",
"55123106", "Silveiras\ \-\ SP",
"55913725", "Apeú\ \-\ PA",
"55513661", "Tramandaí\ \-\ RS",
"55833427", "Catingueira\ \-\ PB",
"55143884", "Anhembi\ \-\ SP",
"55543373", "São\ Valentim\ \-\ RS",
"55863301", "Teresina\ \-\ PI",
"55643564", "Anicuns\ \-\ GO",
"55653617", "Cuiabá\ \-\ MT",
"55773438", "Cândido\ Sales\ \-\ BA",
"55833209", "João\ Pessoa\ \-\ PB",
"55133872", "Sete\ Barras\ \-\ SP",
"55663497", "Primavera\ do\ Leste\ \-\ MT",
"55274102", "Serra\ \-\ ES",
"55913726", "Ulianópolis\ \-\ PA",
"55884141", "Juazeiro\ do\ Norte\ \-\ CE",
"55693236", "Porto\ Velho\ \-\ RO",
"55733294", "Itamaraju\ \-\ BA",
"55423636", "Cantagalo\ \-\ PR",
"55483535", "Jacinto\ Machado\ \-\ SC",
"55143662", "Bariri\ \-\ SP",
"55743162", "Juazeiro\ \-\ BA",
"5511310", "São\ Paulo\ \-\ SP",
"55114469", "Santo\ André\ \-\ SP",
"55483536", "Timbé\ do\ Sul\ \-\ SC",
"55115907", "São\ Paulo\ \-\ SP",
"55423635", "Laranjeiras\ do\ Sul\ \-\ PR",
"55693235", "Porto\ Velho\ \-\ RO",
"55933549", "Porto\ Trombetas\ \-\ PA",
"55513382", "Rio\ Grande\ do\ Sul",
"55353692", "Itajubá\ \-\ MG",
"55663472", "Serra\ Dourada\ \-\ MT",
"55983451", "Santa\ Rita\ \-\ MA",
"55673003", "Campo\ Grande\ \-\ MS",
"55213923", "Rio\ de\ Janeiro\ \-\ RJ",
"55212792", "Nilópolis\ \-\ RJ",
"55623584", "Aparecida\ de\ Goiânia\ \-\ GO",
"55883511", "Juazeiro\ do\ Norte\ \-\ CE",
"55353824", "Ingaí\ \-\ MG",
"55222760", "Rio\ das\ Ostras\ \-\ RJ",
"55123864", "São\ Sebastião\ \-\ SP",
"55913802", "Mãe\ do\ Rio\ \-\ PA",
"55893424", "Paquetá\ \-\ PI",
"55222621", "São\ Pedro\ da\ Aldeia\ \-\ RJ",
"55813753", "São\ Joaquim\ do\ Monte\ \-\ PE",
"55243332", "Rio\ Claro\ \-\ RJ",
"55313817", "Ponte\ Nova\ \-\ MG",
"55283531", "Itapemirim\ \-\ ES",
"55713394", "Aratu\ \-\ BA",
"55613877", "Brasília\ \-\ DF",
"55643532", "Itumbiara\ \-\ GO",
"55173576", "Ariranha\ \-\ SP",
"55313911", "Contagem\ \-\ MG",
"55183659", "Bilac\ \-\ SP",
"55923533", "Parintins\ \-\ AM",
"55512107", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55773021", "Barreiras\ \-\ BA",
"55413383", "São\ José\ dos\ Pinhais\ \-\ PR",
"55492102", "Lages\ \-\ SC",
"55953553", "Cantá\ \-\ RR",
"55773662", "Palmas\ de\ Monte\ Alto\ \-\ BA",
"55193966", "Conchal\ \-\ SP",
"55413658", "Bocaiúva\ do\ Sul\ \-\ PR",
"55533282", "Pelotas\ \-\ RS",
"55843432", "Campo\ Redondo\ \-\ RN",
"55793272", "Japaratuba\ \-\ SE",
"55433675", "Centenário\ do\ Sul\ \-\ PR",
"55273296", "Aracruz\ \-\ ES",
"55113607", "Osasco\ \-\ SP",
"55163342", "Ibitinga\ \-\ SP",
"55112532", "São\ Paulo\ \-\ SP",
"55193965", "Hortolândia\ \-\ SP",
"55353573", "Monte\ Belo\ \-\ MG",
"55653513", "Lucas\ do\ Rio\ Verde\ \-\ MT",
"55693524", "Governador\ Jorge\ Teixeira\ \-\ RO",
"55193507", "Araras\ \-\ SP",
"55433453", "Kaloré\ \-\ PR",
"55453240", "Medianeira\ \-\ PR",
"55613624", "Valparaíso\ de\ Goiás\ \-\ GO",
"55373329", "Formiga\ \-\ MG",
"55193894", "Indaiatuba\ \-\ SP",
"55513720", "Estrêla\ \-\ RS",
"55823254", "São\ Luís\ do\ Quitunde\ \-\ AL",
"55123832", "Ubatuba\ \-\ SP",
"55624104", "Goiânia\ \-\ GO",
"55213227", "Rio\ de\ Janeiro\ \-\ RJ",
"55193622", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55493558", "Ipira\ \-\ SC",
"55673022", "Campo\ Grande\ \-\ MS",
"55793297", "Siriri\ \-\ SE",
"55983218", "São\ Luís\ \-\ MA",
"55913823", "Americano\ \-\ PA",
"5519344", "Limeira\ \-\ SP",
"5511458", "Jundiaí\ \-\ SP",
"55313869", "Congonhas\ do\ Norte\ \-\ MG",
"55443019", "Cianorte\ \-\ PR",
"55743531", "Curaçá\ \-\ BA",
"55483322", "Florianópolis\ \-\ SC",
"55113502", "São\ Paulo\ \-\ SP",
"55443521", "Goioerê\ \-\ PR",
"55222767", "Cambuci\ \-\ RJ",
"55933597", "Tabocal\ \-\ PA",
"55873817", "Alagoinha\ \-\ PE",
"55543372", "Marcelino\ Ramos\ \-\ RS",
"55983664", "Buriticupu\ \-\ MA",
"55163244", "Monte\ Alto\ \-\ SP",
"55333246", "Mendes\ Pimentel\ \-\ MG",
"55133849", "Iguape\ \-\ SP",
"55743259", "Macajuba\ \-\ BA",
"55513137", "Alvorada\ \-\ RS",
"55213665", "Queimados\ \-\ RJ",
"55983468", "São\ Benedito\ do\ Rio\ Preto\ \-\ MA",
"55323746", "Espera\ Feliz\ \-\ MG",
"55423904", "Telêmaco\ Borba\ \-\ PR",
"55242224", "São\ José\ do\ Vale\ do\ Rio\ Preto\ \-\ RJ",
"55323745", "Caiana\ \-\ MG",
"55113416", "Taboão\ da\ Serra\ \-\ SP",
"55273071", "Vitória\ \-\ ES",
"55333245", "Divino\ das\ Laranjeiras\ \-\ MG",
"55183583", "Rinópolis\ \-\ SP",
"55643637", "Aparecida\ do\ Rio\ Doce\ \-\ GO",
"55543397", "Maximiliano\ de\ Almeida\ \-\ RS",
"55913803", "Bonito\ \-\ PA",
"55333741", "Jequitinhonha\ \-\ MG",
"55684062", "Rio\ Branco\ \-\ AC",
"55323241", "Juiz\ de\ Fora\ \-\ MG",
"55973334", "Canutama\ \-\ AM",
"55413003", "Curitiba\ \-\ PR",
"55923306", "Manaus\ \-\ AM",
"55613408", "Brasília\ \-\ DF",
"55153251", "Tatuí\ \-\ SP",
"55173489", "Brasitânia\ \-\ SP",
"55513454", "Esteio\ \-\ RS",
"55353693", "Pouso\ Alegre\ \-\ MG",
"55412107", "Curitiba\ \-\ PR",
"55473031", "Joinville\ \-\ SC",
"55513658", "Charqueadas\ \-\ RS",
"55633520", "Nova\ Rosalândia\ \-\ TO",
"5531374", "Minas\ Gerais",
"55173695", "Marinópolis\ \-\ SP",
"5511272", "São\ Paulo\ \-\ SP",
"5586322", "Teresina\ \-\ PI",
"55873869", "Santa\ Maria\ da\ Boa\ Vista\ \-\ PE",
"55193602", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55853332", "Redenção\ \-\ CE",
"55443274", "Sarandi\ \-\ PR",
"55213207", "Rio\ de\ Janeiro\ \-\ RJ",
"55113371", "São\ Paulo\ \-\ SP",
"55193186", "Charqueada\ \-\ SP",
"55513700", "Rio\ Grande\ do\ Sul",
"55883437", "Tauá\ \-\ CE",
"55193572", "Leme\ \-\ SP",
"55313111", "São\ Joaquim\ de\ Bicas\ \-\ MG",
"55472106", "Jaraguá\ do\ Sul\ \-\ SC",
"55513363", "Rio\ Grande\ do\ Sul",
"55613574", "Brasília\ \-\ DF",
"55813678", "Rio\ Formoso\ \-\ PE",
"55423521", "União\ da\ Vitória\ \-\ PR",
"55873889", "Cedro\ \-\ PE",
"55213977", "Rio\ de\ Janeiro\ \-\ RJ",
"55493237", "Capão\ Alto\ \-\ SC",
"55183748", "Ilha\ Solteira\ \-\ SP",
"55933527", "Santarém\ \-\ PA",
"55813474", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55433262", "Assaí\ \-\ PR",
"55623637", "Goiânia\ \-\ GO",
"55483062", "Florianópolis\ \-\ SC",
"55223234", "Campos\ dos\ Goitacazes\ \-\ RJ",
"55753239", "Anguera\ \-\ BA",
"55773275", "Maiquinique\ \-\ BA",
"55614003", "Brasília\ \-\ DF",
"55923584", "Manaus\ \-\ AM",
"55182101", "Presidente\ Prudente\ \-\ SP",
"55333513", "Campanário\ \-\ MG",
"5563322", "Palmas\ \-\ TO",
"55114134", "Barueri\ \-\ SP",
"55115032", "São\ Paulo\ \-\ SP",
"5511279", "São\ Paulo\ \-\ SP",
"55833449", "Riacho\ dos\ Cavalos\ \-\ PB",
"55193597", "Rio\ Claro\ \-\ SP",
"55193804", "Mogi\ Mirim\ \-\ SP",
"55114531", "Jundiaí\ \-\ SP",
"55343241", "Araguari\ \-\ MG",
"5598323", "São\ Luís\ \-\ MA",
"55943305", "Bannach\ \-\ PA",
"55123663", "Campos\ do\ Jordão\ \-\ SP",
"55983488", "Santana\ do\ Maranhão\ \-\ MA",
"55833490", "Bonito\ de\ Santa\ Fé\ \-\ PB",
"55423274", "Ventania\ \-\ PR",
"55353623", "Itajubá\ \-\ MG",
"55893578", "Gilbués\ \-\ PI",
"55433525", "Jacarezinho\ \-\ PR",
"55213733", "Rio\ de\ Janeiro\ \-\ RJ",
"55913031", "Ananindeua\ \-\ PA",
"55693025", "Porto\ Velho\ \-\ RO",
"55833473", "Desterro\ \-\ PB",
"55693026", "Porto\ Velho\ \-\ RO",
"55433526", "Santana\ do\ Itararé\ \-\ PR",
"55494101", "Chapecó\ \-\ SC",
"55543327", "Passo\ Fundo\ \-\ RS",
"55873850", "Brejinho\ \-\ PE",
"55193301", "Piracicaba\ \-\ SP",
"55652128", "Cuiabá\ \-\ MT",
"5511562", "São\ Paulo\ \-\ SP",
"55733536", "Santa\ Inês\ \-\ BA",
"55753437", "Nova\ Soure\ \-\ BA",
"55553615", "Santa\ Margarida\ do\ Sul\ \-\ RS",
"55273225", "Vitória\ \-\ ES",
"55493439", "Linha\ Planalto\ \-\ SC",
"55213030", "Rio\ de\ Janeiro\ \-\ RJ",
"55913441", "Igarapé\-Açu\ \-\ PA",
"55673681", "Terenos\ \-\ MS",
"55623532", "Senador\ Canedo\ \-\ GO",
"55733535", "Jitaúna\ \-\ BA",
"55173267", "Guapiaçu\ \-\ SP",
"55473135", "Rio\ da\ Anta\ \-\ SC",
"55813712", "Caruaru\ \-\ PE",
"55673414", "Vila\ Vargas\ \-\ MS",
"55313889", "Belo\ Horizonte\ \-\ MG",
"55893494", "Paes\ Landim\ \-\ PI",
"55472125", "Balneário\ Camboriú\ \-\ SC",
"5547332", "Blumenau\ \-\ SC",
"55843254", "São\ Pedro\ \-\ RN",
"55212132", "Rio\ de\ Janeiro\ \-\ RJ",
"55413070", "Fazenda\ Rio\ Grande\ \-\ PR",
"55114163", "Barueri\ \-\ SP",
"55173330", "Guaíra\ \-\ SP",
"55193321", "Araras\ \-\ SP",
"55343842", "Monte\ Carmelo\ \-\ MG",
"55463553", "Espigão\ Alto\ do\ Iguaçu\ \-\ PR",
"55212703", "Niterói\ \-\ RJ",
"55114280", "Cotia\ \-\ SP",
"55513749", "Palanque\ \-\ RS",
"55793227", "Aracaju\ \-\ SE",
"55533262", "Arroio\ Grande\ \-\ RS",
"55954400", "Caracaraí\ \-\ RR",
"55313850", "Minas\ Gerais",
"55273721", "Colatina\ \-\ ES",
"55773682", "Iuiú\ \-\ BA",
"55943326", "Rondon\ do\ Pará\ \-\ PA",
"55384009", "Montes\ Claros\ \-\ MG",
"55193824", "Águas\ de\ Lindóia\ \-\ SP",
"55513773", "Poço\ das\ Antas\ \-\ RS",
"55212380", "Rio\ de\ Janeiro\ \-\ RJ",
"55123634", "Taubaté\ \-\ SP",
"55474003", "Blumenau\ \-\ SC",
"55663427", "Rondonópolis\ \-\ MT",
"55873857", "Flores\ \-\ PE",
"55343228", "Uberlândia\ \-\ MG",
"55913796", "Mocajuba\ \-\ PA",
"55143106", "Bauru\ \-\ SP",
"55633301", "Gurupi\ \-\ TO",
"55223861", "Itaocara\ \-\ RJ",
"55193549", "Mogi\ Mirim\ \-\ SP",
"55913795", "Baião\ \-\ PA",
"55114489", "Francisco\ Morato\ \-\ SP",
"55493367", "Sul\ Brasil\ \-\ SC",
"55883568", "Jaguaribara\ \-\ CE",
"55114695", "Guararema\ \-\ SP",
"55323401", "Leopoldina\ \-\ MG",
"55513362", "Rio\ Grande\ do\ Sul",
"55223094", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55114696", "Salesópolis\ \-\ SP",
"55193573", "Leme\ \-\ SP",
"55143361", "Botucatu\ \-\ SP",
"55553754", "Pinhal\ \-\ RS",
"55853004", "Fortaleza\ \-\ CE",
"55212722", "Niterói\ \-\ RJ",
"55443635", "Japurá\ \-\ PR",
"55213103", "Nova\ Iguaçu\ \-\ RJ",
"55833472", "Teixeira\ \-\ PB",
"55473221", "Blumenau\ \-\ SC",
"55483648", "Termas\ do\ Gravatal\ \-\ SC",
"55443636", "Pérola\ \-\ PR",
"55112118", "Itu\ \-\ SP",
"55843353", "São\ Miguel\ \-\ RN",
"55213970", "Rio\ de\ Janeiro\ \-\ RJ",
"55353622", "Itajubá\ \-\ MG",
"55493319", "Chapecó\ \-\ SC",
"55153288", "Cerquilho\ \-\ SP",
"55123662", "Campos\ do\ Jordão\ \-\ SP",
"55222759", "Macaé\ \-\ RJ",
"55123021", "São\ José\ dos\ Campos\ \-\ SP",
"55813010", "Paulista\ \-\ PE",
"55114704", "Embu\ das\ Artes\ \-\ SP",
"55513681", "Cidreira\ \-\ RS",
"55823312", "Maceió\ \-\ AL",
"55633572", "Palmas\ \-\ TO",
"55843611", "Natal\ \-\ RN",
"55513618", "Barão\ \-\ RS",
"55133386", "Guarujá\ \-\ SP",
"55183721", "Andradina\ \-\ SP",
"55333512", "Frei\ Gaspar\ \-\ MG",
"55513077", "Canoas\ \-\ RS",
"55623305", "São\ Francisco\ de\ Goiás\ \-\ GO",
"55153461", "Porto\ Feliz\ \-\ SP",
"5561332", "Brasília\ \-\ DF",
"55513264", "Rio\ Grande\ do\ Sul",
"55323421", "Cataguases\ \-\ MG",
"55713203", "Salvador\ \-\ BA",
"55413414", "Tagaçaba\ \-\ PR",
"55112867", "São\ Paulo\ \-\ SP",
"55123519", "São\ José\ dos\ Campos\ \-\ SP",
"55633692", "Dianópolis\ \-\ TO",
"55483034", "São\ José\ \-\ SC",
"55853384", "Maracanaú\ \-\ CE",
"55313857", "Dom\ Silvério\ \-\ MG",
"55743626", "Mundo\ Novo\ \-\ BA",
"55213835", "Rio\ de\ Janeiro\ \-\ RJ",
"55633321", "Araguaína\ \-\ TO",
"55623085", "Aparecida\ de\ Goiânia\ \-\ GO",
"55623533", "Goiânia\ \-\ GO",
"55833299", "Pitimbu\ \-\ PB",
"55463246", "Saudade\ do\ Iguaçu\ \-\ PR",
"55663407", "Barra\ do\ Garças\ \-\ MT",
"55143587", "Presidente\ Alves\ \-\ SP",
"55463245", "Honório\ Serpa\ \-\ PR",
"55623086", "Goiânia\ \-\ GO",
"55513772", "Arvorezinha\ \-\ RS",
"55694007", "Porto\ Velho\ \-\ RO",
"55513930", "Porto\ Alegre\ \-\ RS",
"55623326", "Jaraguá\ \-\ GO",
"55143276", "Bauru\ \-\ SP",
"55143275", "Paulistânia\ \-\ SP",
"55673232", "Corumbá\ \-\ MS",
"55773683", "Jaborandi\ \-\ BA",
"55733204", "Itaju\ do\ Colônia\ \-\ BA",
"55313055", "Belo\ Horizonte\ \-\ MG",
"55272101", "Colatina\ \-\ ES",
"55623325", "Rubiataba\ \-\ GO",
"55112396", "Itu\ \-\ SP",
"55183701", "Mirandópolis\ \-\ SP",
"55114576", "Mauá\ \-\ SP",
"55533263", "Santa\ Vitória\ do\ Palmar\ \-\ RS",
"55463552", "Capanema\ \-\ PR",
"55353527", "Bom\ Jesus\ dos\ Campos\ \-\ MG",
"55213037", "Nova\ Iguaçu\ \-\ RJ",
"55343843", "Estrela\ do\ Sul\ \-\ MG",
"55114162", "Barueri\ \-\ SP",
"55333426", "Dores\ de\ Guanhães\ \-\ MG",
"55623981", "Aparecida\ de\ Goiânia\ \-\ GO",
"55112819", "Mogi\ das\ Cruzes\ \-\ SP",
"55333425", "Braúnas\ \-\ MG",
"55133594", "Praia\ Grande\ \-\ SP",
"55212133", "Rio\ de\ Janeiro\ \-\ RJ",
"55242444", "Barra\ do\ Piraí\ \-\ RJ",
"55753430", "Itapicuru\ \-\ BA",
"55693443", "Cacoal\ \-\ RO",
"55513660", "Rio\ Grande\ do\ Sul",
"55273233", "Vitória\ \-\ ES",
"55613297", "Brasília\ \-\ DF",
"55142122", "Avaré\ \-\ SP",
"55183334", "Presidente\ Prudente\ \-\ SP",
"55153257", "Porangaba\ \-\ SP",
"55743632", "Mairi\ \-\ BA",
"55833644", "Tenório\ \-\ PB",
"55213694", "Maricá\ \-\ RJ",
"55333747", "Santo\ Antônio\ do\ Jacinto\ \-\ MG",
"55543391", "Gaurama\ \-\ RS",
"55833448", "Bom\ Sucesso\ \-\ PB",
"55193124", "Piracicaba\ \-\ SP",
"55113377", "São\ Paulo\ \-\ SP",
"55433305", "Londrina\ \-\ PR",
"55213201", "Rio\ de\ Janeiro\ \-\ RJ",
"55713271", "Salvador\ \-\ BA",
"55543622", "Passo\ Fundo\ \-\ RS",
"55193521", "Campinas\ \-\ SP",
"55273362", "Guarapari\ \-\ ES",
"55383841", "Salinas\ \-\ MG",
"55433306", "Londrina\ \-\ PR",
"55893543", "Antônio\ Almeida\ \-\ PI",
"55673562", "Chapadão\ do\ Sul\ \-\ MS",
"55533325", "Pelotas\ \-\ RS",
"55713121", "Camaçari\ \-\ BA",
"55753238", "Terra\ Nova\ \-\ BA",
"55813643", "Itaquitinga\ \-\ PE",
"55873811", "Jirau\ \-\ PE",
"55423301", "Ponta\ Grossa\ \-\ PR",
"55443527", "Nova\ Cantu\ \-\ PR",
"55883510", "Iguatu\ \-\ CE",
"55173664", "Aspásia\ \-\ SP",
"55333432", "São\ Sebastião\ do\ Maranhão\ \-\ MG",
"5511436", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55613272", "Brasília\ \-\ DF",
"55433564", "Quatiguá\ \-\ PR",
"55643631", "Jataí\ \-\ GO",
"55943333", "Itupiranga\ \-\ PA",
"55673226", "Ladário\ \-\ MS",
"55512121", "Porto\ Alegre\ \-\ RS",
"55813679", "Gameleira\ \-\ PE",
"55963421", "Amapá\ \-\ AP",
"5575348", "Feira\ de\ Santana\ \-\ BA",
"55113392", "São\ Paulo\ \-\ SP",
"55653352", "Nova\ Marilândia\ \-\ MT",
"55553228", "Boca\ do\ Monte\ \-\ RS",
"55214137", "Nilópolis\ \-\ RJ",
"55673225", "Coxim\ \-\ MS",
"55473249", "Itajaí\ \-\ SC",
"55623332", "Silvânia\ \-\ GO",
"55213221", "Rio\ de\ Janeiro\ \-\ RJ",
"55843552", "Galinhos\ \-\ RN",
"55273264", "Linhares\ \-\ ES",
"55543527", "Áurea\ \-\ RS",
"55193501", "Hortolândia\ \-\ SP",
"55423677", "Pinhão\ \-\ PR",
"55313462", "Belo\ Horizonte\ \-\ MG",
"55883613", "Sobral\ \-\ CE",
"55743537", "Sento\ Sé\ \-\ BA",
"55413534", "São\ José\ dos\ Pinhais\ \-\ PR",
"55513748", "Lajeado\ \-\ RS",
"55333313", "Inhapim\ \-\ MG",
"55323449", "Leopoldina\ \-\ MG",
"55633373", "Almas\ \-\ TO",
"55173281", "Olímpia\ \-\ SP",
"55413131", "Curitiba\ \-\ PR",
"55153459", "Iperó\ \-\ SP",
"55643452", "Rio\ Quente\ \-\ GO",
"55473447", "Araquari\ \-\ SC",
"55173633", "Santa\ Albertina\ \-\ SP",
"55893485", "Isaías\ Coelho\ \-\ PI",
"55193019", "Mogi\-Guaçu\ \-\ SP",
"55512101", "Porto\ Alegre\ \-\ RS",
"55843246", "Pipa\ \-\ RN",
"55313888", "Minas\ Gerais",
"55493634", "Iporã\ do\ Oeste\ \-\ SC",
"55843245", "Vila\ Flor\ \-\ RN",
"55283537", "Iconha\ \-\ ES",
"55222627", "São\ Pedro\ da\ Aldeia\ \-\ RJ",
"55273772", "Nova\ Venécia\ \-\ ES",
"55923675", "Manaus\ \-\ AM",
"55653254", "Indiavaí\ \-\ MT",
"55193866", "Conchal\ \-\ SP",
"55443622", "Umuarama\ \-\ PR",
"55213726", "Teresópolis\ \-\ RJ",
"55493438", "Ipumirim\ \-\ SC",
"55113601", "Osasco\ \-\ SP",
"55213171", "Rio\ de\ Janeiro\ \-\ RJ",
"55483285", "Biguaçu\ \-\ SC",
"55212683", "Paracambi\ \-\ RJ",
"55483286", "Palhoça\ \-\ SC",
"55513563", "Ivoti\ \-\ RS",
"55162111", "Ribeirão\ Preto\ \-\ SP",
"55943364", "Vila\ Mandii\ \-\ PA",
"55153646", "Buri\ \-\ SP",
"55713504", "Lauro\ de\ Freitas\ \-\ BA",
"55193865", "Hortolândia\ \-\ SP",
"55433533", "Panema\ \-\ PR",
"55513619", "Rio\ Grande\ do\ Sul",
"55183264", "Iepê\ \-\ SP",
"55893542", "Landri\ Sales\ \-\ PI",
"55413562", "Colombo\ \-\ PR",
"55823425", "Taquarana\ \-\ AL",
"55353327", "Carrancas\ \-\ MG",
"55423573", "Porto\ Vitória\ \-\ PR",
"5542322", "Ponta\ Grossa\ \-\ PR",
"55222758", "São\ Fidélis\ \-\ RJ",
"55823426", "Estrela\ de\ Alagoas\ \-\ AL",
"55243065", "Petrópolis\ \-\ RJ",
"55753612", "Feira\ de\ Santana\ \-\ BA",
"55643595", "Itumbiara\ \-\ GO",
"55112119", "Atibaia\ \-\ SP",
"55553241", "Santana\ do\ Livramento\ \-\ RS",
"55153289", "Ibiúna\ \-\ SP",
"55623526", "Goiânia\ \-\ GO",
"55743633", "Saúde\ \-\ BA",
"55113444", "São\ Paulo\ \-\ SP",
"55383014", "Montes\ Claros\ \-\ MG",
"55883517", "Jucás\ \-\ CE",
"55433158", "Ibiporã\ \-\ PR",
"55213823", "Rio\ de\ Janeiro\ \-\ RJ",
"55273232", "Vitória\ \-\ ES",
"55693442", "Rolim\ de\ Moura\ \-\ RO",
"55313434", "Belo\ Horizonte\ \-\ MG",
"55413721", "Paranaguá\ \-\ PR",
"55633521", "Brejinho\ de\ Nazaré\ \-\ TO",
"55493021", "Lages\ \-\ SC",
"55123895", "Ilhabela\ \-\ SP",
"55223533", "Vila\ Velha\ \-\ ES",
"55772102", "Vitória\ da\ Conquista\ \-\ BA",
"55653353", "Acorizal\ \-\ MT",
"55553746", "Seberi\ \-\ RS",
"55113393", "São\ Paulo\ \-\ SP",
"55863194", "Teresina\ \-\ PI",
"55553745", "Iraí\ \-\ RS",
"55883569", "Deputado\ Irapuan\ Pinheiro\ \-\ CE",
"55143387", "Sarutaiá\ \-\ SP",
"55114684", "Juquitiba\ \-\ SP",
"55943332", "São\ Domingos\ do\ Araguaia\ \-\ PA",
"55513701", "Rio\ Grande\ do\ Sul",
"55123896", "Ilhabela\ \-\ SP",
"5581342", "Recife\ \-\ PE",
"55613273", "Brasília\ \-\ DF",
"55333433", "São\ José\ do\ Jacuri\ \-\ MG",
"55913784", "Portel\ \-\ PA",
"55163711", "Franca\ \-\ SP",
"55733266", "Itarantim\ \-\ BA",
"55853181", "Fortaleza\ \-\ CE",
"55114488", "Francisco\ Morato\ \-\ SP",
"55653611", "Cuiabá\ \-\ MT",
"55813642", "Condado\ \-\ PE",
"55733265", "Itororó\ \-\ BA",
"55212771", "Duque\ de\ Caxias\ \-\ RJ",
"55513667", "Três\ Cachoeiras\ \-\ RS",
"55833421", "Patos\ \-\ PB",
"55993565", "Formosa\ da\ Serra\ Negra\ \-\ MA",
"55623506", "Trindade\ \-\ GO",
"55112818", "Mauá\ \-\ SP",
"55733627", "Santa\ Cruz\ da\ Vitória\ \-\ BA",
"55643453", "Caldas\ Novas\ \-\ GO",
"55353591", "Monte\ Santo\ de\ Minas\ \-\ MG",
"55633372", "Natividade\ \-\ TO",
"55333312", "Mutum\ \-\ MG",
"55623505", "Trindade\ \-\ GO",
"55213803", "Niterói\ \-\ RJ",
"55143722", "Tupã\ \-\ SP",
"55863087", "Teresina\ \-\ PI",
"55463254", "Coronel\ Domingos\ Soares\ \-\ PR",
"55183876", "Paulicéia\ \-\ SP",
"55183362", "Paraguaçu\ Paulista\ \-\ SP",
"55623412", "Goiânia\ \-\ GO",
"55183875", "Santa\ Mercedes\ \-\ SP",
"55413667", "Pinhais\ \-\ PR",
"55743664", "Xique\-xique\ \-\ BA",
"55843553", "Jandaíra\ \-\ RN",
"55493905", "Chapecó\ \-\ SC",
"55913429", "Viseu\ \-\ PA",
"55433532", "Cambará\ \-\ PR",
"55493567", "Caçador\ \-\ SC",
"55633397", "Pugmil\ \-\ TO",
"55343427", "Planura\ \-\ MG",
"55473374", "Schroeder\ \-\ SC",
"55513562", "Portão\ \-\ RS",
"55212682", "Seropédica\ \-\ RJ",
"55833298", "Conde\ \-\ PB",
"55683267", "Vila\ Campinas\ \(Pad\ Peixoto\)\ \-\ AC",
"55623094", "Aparecida\ de\ Goiânia\ \-\ GO",
"55443623", "Umuarama\ \-\ PR",
"55193373", "Piracicaba\ \-\ SP",
"55623364", "São\ Miguel\ do\ Araguaia\ \-\ GO",
"55543520", "Erechim\ \-\ RS",
"55453241", "Cafelândia\ \-\ PR",
"55273773", "São\ Mateus\ \-\ ES",
"55643676", "Cachoeira\ de\ Goiás\ \-\ GO",
"55123184", "Cruzeiro\ \-\ SP",
"55513721", "Triunfo\ \-\ RS",
"55913665", "Benevides\ \-\ PA",
"55173632", "Jales\ \-\ SP",
"55643675", "Palminópolis\ \-\ GO",
"55463543", "Realeza\ \-\ PR",
"55493636", "São\ João\ do\ Oeste\ \-\ SC",
"55553419", "Barra\ do\ Quaraí\ \-\ RS",
"55513759", "Travesseiro\ \-\ RS",
"55893484", "Campinas\ do\ Piauí\ \-\ PI",
"55773677", "Érico\ Cardoso\ \-\ BA",
"55313899", "Viçosa\ \-\ MG",
"55353438", "Camanducaia\ \-\ MG",
"55453269", "Vila\ Nova\ \-\ PR",
"55193361", "Mogi\-Guaçu\ \-\ SP",
"55713412", "Salvador\ \-\ BA",
"55843244", "Baía\ Formosa\ \-\ RN",
"55114037", "Pedra\ Bela\ \-\ SP",
"55213162", "Nilópolis\ \-\ RJ",
"55533304", "Santa\ Maria\ \-\ RS",
"55633358", "Dueré\ \-\ TO",
"55943366", "Vila\ Novo\ Paraíso\ \-\ PA",
"55273761", "São\ Mateus\ \-\ ES",
"55212734", "Rio\ Bonito\ \-\ RJ",
"55213724", "Rio\ de\ Janeiro\ \-\ RJ",
"55833257", "Mata\ Redonda\ \-\ PB",
"55943365", "Vila\ Taboca\ \-\ PA",
"55313840", "Minas\ Gerais",
"55433202", "Apucarana\ \-\ PR",
"55144004", "Bauru\ \-\ SP",
"5511566", "São\ Paulo\ \-\ SP",
"55813114", "Vitória\ de\ Santo\ Antão\ \-\ PE",
"55273266", "Santa\ Leopoldina\ \-\ ES",
"55163042", "Sertãozinho\ \-\ SP",
"55543581", "Passo\ Fundo\ \-\ RS",
"5563341", "Araguaína\ \-\ TO",
"55474062", "Joinville\ \-\ SC",
"55273265", "Rio\ Bananal\ \-\ ES",
"55614063", "Brasília\ \-\ DF",
"55193682", "São\ José\ do\ Rio\ Pardo\ \-\ SP",
"55513780", "Rio\ Grande\ do\ Sul",
"55423027", "Ponta\ Grossa\ \-\ PR",
"55993637", "Joselândia\ \-\ MA",
"55413083", "Curitiba\ \-\ PR",
"55413535", "Curitiba\ \-\ PR",
"55613411", "Brasília\ \-\ DF",
"55613488", "Brasília\ \-\ DF",
"55114273", "Caieiras\ \-\ SP",
"5511452", "Jundiaí\ \-\ SP",
"55433172", "Arapongas\ \-\ PR",
"55343251", "Santa\ Vitória\ \-\ MG",
"55374141", "Divinópolis\ \-\ MG",
"55833459", "Nova\ Olinda\ \-\ PB",
"55443518", "Campo\ Mourão\ \-\ PR",
"55115631", "São\ Paulo\ \-\ SP",
"55353663", "Pedralva\ \-\ MG",
"55873840", "Inajá\ \-\ PE",
"55222772", "Macaé\ \-\ RJ",
"55613261", "Brasília\ \-\ DF",
"55855672", "São\ Paulo\ \-\ SP",
"55823641", "Delmiro\ Gouveia\ \-\ AL",
"55193833", "Paulínia\ \-\ SP",
"55433565", "São\ José\ da\ Boa\ Vista\ \-\ PR",
"55433566", "Carlópolis\ \-\ PR",
"55212763", "Nova\ Iguaçu\ \-\ RJ",
"5534", "Minas\ Gerais",
"55163432", "Franca\ \-\ SP",
"55114103", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55883541", "Várzea\ Alegre\ \-\ CE",
"55543367", "Três\ Palmeiras\ \-\ RS",
"55513536", "Conceição\ \-\ RS",
"55843013", "Natal\ \-\ RN",
"55543319", "Montauri\ \-\ RS",
"55273371", "Linhares\ \-\ ES",
"55553269", "São\ João\ do\ Polêsine\ \-\ RS",
"55213982", "Rio\ de\ Janeiro\ \-\ RJ",
"55343338", "Uberaba\ \-\ MG",
"55373511", "Divinópolis\ \-\ MG",
"55185821", "Dracena\ \-\ SP",
"55833480", "Igaracy\ \-\ PB",
"55473258", "Vitor\ Meireles\ \-\ SC",
"5511450", "São\ Paulo\ \-\ SP",
"55134104", "São\ Vicente\ \-\ SP",
"55663538", "Bom\ Jesus\ do\ Araguaia\ \-\ MT",
"55433304", "Londrina\ \-\ PR",
"55143597", "Presidente\ Alves\ \-\ SP",
"55643478", "Ouvidor\ \-\ GO",
"55124159", "Vargem\ Grande\ Paulista\ \-\ SP",
"55473375", "Corupá\ \-\ SC",
"55623096", "Goiânia\ \-\ GO",
"55913468", "Capitão\ Poço\ \-\ PA",
"55313045", "Belo\ Horizonte\ \-\ MG",
"55623366", "Mara\ Rosa\ \-\ GO",
"55543439", "Faria\ Lemos\ \-\ RS",
"55623095", "Goiânia\ \-\ GO",
"55793337", "Poço\ Redondo\ \-\ SE",
"55623365", "Crixás\ \-\ GO",
"55833289", "Juripiranga\ \-\ PB",
"55984002", "São\ Luís\ \-\ MA",
"55473376", "Jaraguá\ do\ Sul\ \-\ SC",
"55113583", "São\ Paulo\ \-\ SP",
"55982106", "São\ Luís\ \-\ MA",
"55513787", "Pinheiral\ \-\ RS",
"55444101", "Sarandi\ \-\ PR",
"55163668", "Santo\ Antônio\ da\ Alegria\ \-\ SP",
"55123185", "Lorena\ \-\ SP",
"55183502", "Adamantina\ \-\ SP",
"55123527", "Pindamonhangaba\ \-\ SP",
"55343614", "Perdizes\ \-\ MG",
"55343853", "Tiros\ \-\ MG",
"55212397", "Duque\ de\ Caxias\ \-\ RJ",
"55123602", "Taubaté\ \-\ SP",
"55643674", "Iporá\ \-\ GO",
"55123186", "Cachoeira\ Paulista\ \-\ SP",
"55513571", "São\ José\ do\ Hortêncio\ \-\ RS",
"55463542", "Santa\ Izabel\ do\ Oeste\ \-\ PR",
"5519341", "Piracicaba\ \-\ SP",
"55323461", "Angustura\ \-\ MG",
"55114272", "Santana\ de\ Parnaíba\ \-\ SP",
"55313847", "Minas\ Gerais",
"55473488", "Blumenau\ \-\ SC",
"55112827", "São\ Paulo\ \-\ SP",
"55534001", "Pelotas\ \-\ RS",
"55993564", "Governador\ Eugênio\ Barros\ \-\ MA",
"55473411", "Rio\ do\ Sul\ \-\ SC",
"55143572", "Pirajuí\ \-\ SP",
"55183371", "Maracaí\ \-\ SP",
"55553538", "Boa\ Vista\ do\ Buricá\ \-\ RS",
"55273335", "Vitória\ \-\ ES",
"55773693", "Rio\ do\ Pires\ \-\ BA",
"55793260", "Barra\ dos\ Coqueiros\ \-\ SE",
"55633361", "Paraíso\ do\ Tocantins\ \-\ TO",
"55193683", "Santa\ Cruz\ das\ Palmeiras\ \-\ SP",
"55614062", "Brasília\ \-\ DF",
"55474063", "Joinville\ \-\ SC",
"55423132", "Irati\ \-\ PR",
"55273758", "Mantenópolis\ \-\ ES",
"55483003", "Florianópolis\ \-\ SC",
"55422122", "Castro\ \-\ PR",
"55743665", "Jacobina\ \-\ BA",
"55482107", "Florianópolis\ \-\ SC",
"55443237", "Santa\ Zélia\ \-\ PR",
"55115818", "São\ Paulo\ \-\ SP",
"55434001", "Londrina\ \-\ PR",
"55223084", "Macaé\ \-\ RJ",
"55143321", "Bauru\ \-\ SP",
"55114686", "São\ Lourenço\ da\ Serra\ \-\ SP",
"55183522", "Adamantina\ \-\ SP",
"55123894", "Ilhabela\ \-\ SP",
"55483658", "Braço\ do\ Norte\ \-\ SC",
"55183607", "Araçatuba\ \-\ SP",
"55473261", "Balneário\ Camboriú\ \-\ SC",
"55222773", "Macaé\ \-\ RJ",
"55553744", "Frederico\ Westphalen\ \-\ RS",
"55323288", "Olaria\ \-\ MG",
"55353662", "Maria\ da\ Fé\ \-\ MG",
"55613331", "Recanto\ das\ Emas\ \-\ DF",
"55212124", "Duque\ de\ Caxias\ \-\ RJ",
"55913633", "Curralinho\ \-\ PA",
"55353021", "Passos\ \-\ MG",
"55843379", "Francisco\ Dantas\ \-\ RN",
"55543237", "Bom\ Jesus\ \-\ RS",
"55113659", "Osasco\ \-\ SP",
"55663419", "Campo\ Verde\ \-\ MT",
"55993326", "Timon\ \-\ MA",
"55343268", "Ituiutaba\ \-\ MG",
"55483023", "Palhoça\ \-\ SC",
"55823424", "Major\ Isidoro\ \-\ AL",
"55543360", "Nova\ Boa\ Vista\ \-\ RS",
"55643901", "Itumbiara\ \-\ GO",
"55663467", "Nova\ Nazaré\ \-\ MT",
"55114871", "São\ Paulo\ \-\ SP",
"55183265", "Rancharia\ \-\ SP",
"55433223", "Cambé\ \-\ PR",
"55993533", "Buritirana\ \-\ MA",
"55643594", "Itumbiara\ \-\ GO",
"55163214", "Araraquara\ \-\ SP",
"55183266", "Alfredo\ Marcondes\ \-\ SP",
"55243064", "Petrópolis\ \-\ RJ",
"55873847", "Tabira\ \-\ PE",
"55422102", "Ponta\ Grossa\ \-\ PR",
"55513691", "Rio\ Grande\ do\ Sul",
"55123966", "São\ José\ dos\ Campos\ \-\ SP",
"55113445", "Itaquaquecetuba\ \-\ SP",
"5598308", "São\ Luís\ \-\ MA",
"55112807", "Embu\ das\ Artes\ \-\ SP",
"55493327", "Nova\ Itaberaba\ \-\ SC",
"55112594", "São\ Paulo\ \-\ SP",
"55114374", "Carapicuíba\ \-\ SP",
"55313436", "Minas\ Gerais",
"55153298", "Pilar\ do\ Sul\ \-\ SP",
"55823628", "Monteirópolis\ \-\ AL",
"55333215", "Governador\ Valadares\ \-\ MG",
"55313435", "Belo\ Horizonte\ \-\ MG",
"55623524", "Goiânia\ \-\ GO",
"55123965", "Jacareí\ \-\ SP",
"55173291", "Riolândia\ \-\ SP",
"55613489", "Planaltina\ \-\ DF",
"55653244", "Jauru\ \-\ MT",
"55193387", "Campinas\ \-\ SP",
"55713533", "Salvador\ \-\ BA",
"55793281", "Laranjeiras\ \-\ SE",
"55442031", "Umuarama\ \-\ PR",
"55843255", "Senador\ Elói\ de\ Souza\ \-\ RN",
"5519353", "Rio\ Claro\ \-\ SP",
"55843256", "Boa\ Saúde\ \-\ RN",
"55473457", "Barra\ Velha\ \-\ SC",
"55222667", "Araruama\ \-\ RJ",
"55543519", "Erechim\ \-\ RS",
"55543905", "Gramado\ \-\ RS",
"55213766", "Nova\ Iguaçu\ \-\ RJ",
"55193826", "Vinhedo\ \-\ SP",
"55443662", "Maria\ Helena\ \-\ PR",
"55383546", "São\ Gonçalo\ do\ Rio\ Preto\ \-\ MG",
"55383545", "Presidente\ Kubitschek\ \-\ MG",
"55554052", "Santa\ Maria\ \-\ RS",
"55123635", "Taubaté\ \-\ SP",
"55513523", "Parobé\ \-\ RS",
"55543906", "Farroupilha\ \-\ RS",
"55193984", "Paulínia\ \-\ SP",
"55213765", "Mesquita\ \-\ RJ",
"55193825", "Indaiatuba\ \-\ SP",
"55993263", "Imperatriz\ \-\ MA",
"55943324", "Marabá\ \-\ PA",
"55483296", "Biguaçu\ \-\ SC",
"55553614", "Vitória\ das\ Missões\ \-\ RS",
"5511507", "São\ Paulo\ \-\ SP",
"55983272", "São\ Luís\ \-\ MA",
"55212670", "Japeri\ \-\ RJ",
"55633359", "São\ Valério\ da\ Natividade\ \-\ TO",
"55733534", "Jaguaquara\ \-\ BA",
"55183323", "Assis\ \-\ SP",
"55273302", "Aracruz\ \-\ ES",
"55273224", "Vitória\ \-\ ES",
"55212693", "Nilópolis\ \-\ RJ",
"55623920", "Goiânia\ \-\ GO",
"55863360", "Joaquim\ Pires\ \-\ PI",
"55193702", "Limeira\ \-\ SP",
"55673416", "Dourados\ \-\ MS",
"55893496", "São\ Francisco\ de\ Assis\ do\ Piauí\ \-\ PI",
"55513600", "Rio\ Grande\ do\ Sul",
"55643442", "Catalão\ \-\ GO",
"55383252", "Engenheiro\ Dolabela\ \-\ MG",
"55513758", "Capitão\ \-\ RS",
"55613704", "Brasília\ \-\ DF",
"55893495", "Queimada\ Nova\ \-\ PI",
"55453268", "Santa\ Helena\ \-\ PR",
"5566", "Mato\ Grosso",
"55473531", "Rio\ do\ Sul\ \-\ SC",
"55313898", "Cajuri\ \-\ MG",
"55273082", "Vitória\ \-\ ES",
"55114135", "Taboão\ da\ Serra\ \-\ SP",
"55193806", "Mogi\ Mirim\ \-\ SP",
"55143373", "Santa\ Cruz\ do\ Rio\ Pardo\ \-\ SP",
"55493623", "Descanso\ \-\ SC",
"55793530", "Estância\ \-\ SE",
"55854007", "Maracanaú\ \-\ CE",
"55193805", "Mogi\ Mirim\ \-\ SP",
"55663539", "Novo\ Mundo\ \-\ MT",
"55813653", "Lagoa\ do\ Itaenga\ \-\ PE",
"55943222", "Marabá\ \-\ PA",
"55443567", "Quinta\ do\ Sol\ \-\ PR",
"55354101", "Varginha\ \-\ MG",
"55114136", "Araçariguama\ \-\ SP",
"55173624", "Jales\ \-\ SP",
"5521323", "Rio\ de\ Janeiro\ \-\ RJ",
"55433524", "Cornélio\ Procópio\ \-\ PR",
"55163513", "Sertãozinho\ \-\ SP",
"55423275", "Tibagi\ \-\ PR",
"55543381", "Soledade\ \-\ RS",
"55653342", "Denise\ \-\ MT",
"55813311", "Ipojuca\ \-\ PE",
"55553268", "Dona\ Francisca\ \-\ RS",
"55423276", "Reserva\ \-\ PR",
"55513620", "Rio\ Grande\ do\ Sul",
"55353237", "São\ Thomé\ das\ Letras\ \-\ MG",
"55323257", "Juiz\ de\ Fora\ \-\ MG",
"55192103", "Campinas\ \-\ SP",
"5511260", "São\ Paulo\ \-\ SP",
"55153247", "Votorantim\ \-\ SP",
"5571210", "Salvador\ \-\ BA",
"55472104", "Itajaí\ \-\ SC",
"55753341", "João\ Amaro\ \-\ BA",
"55313515", "Belo\ Horizonte\ \-\ MG",
"55843647", "Parnamirim\ \-\ RN",
"55893553", "Júlio\ Borges\ \-\ PI",
"55983374", "Santa\ Luzia\ do\ Paruá\ \-\ MA",
"55933518", "Itaituba\ \-\ PA",
"55813475", "Recife\ \-\ PE",
"55873929", "Serra\ Talhada\ \-\ PE",
"55773274", "Macarani\ \-\ BA",
"55443906", "Umuarama\ \-\ PR",
"55732101", "Ilhéus\ \-\ BA",
"55313402", "Nova\ Lima\ \-\ MG",
"55193561", "Pirassununga\ \-\ SP",
"55273322", "Vitória\ \-\ ES",
"55833458", "Manaíra\ \-\ PB",
"55813476", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55454052", "Foz\ do\ Iguaçu\ \-\ PR",
"55413523", "Curitiba\ \-\ PR",
"55673522", "Três\ Lagoas\ \-\ MS",
"55733206", "Mucuri\ \-\ BA",
"55493527", "Joaçaba\ \-\ SC",
"55823215", "Maceió\ \-\ AL",
"55115819", "São\ Paulo\ \-\ SP",
"55513522", "Morro\ da\ Pedra\ \-\ RS",
"55333628", "Umburatiba\ \-\ MG",
"55643997", "Itumbiara\ \-\ GO",
"55222534", "Duas\ Barras\ \-\ RJ",
"5545", "Paraná",
"55823216", "Maceió\ \-\ AL",
"55513607", "Rio\ Grande\ do\ Sul",
"55863367", "Luís\ Correia\ \-\ PI",
"55443663", "Douradina\ \-\ PR",
"55273759", "Água\ Doce\ do\ Norte\ \-\ ES",
"55143274", "Gália\ \-\ SP",
"55733205", "Argolo\ \-\ BA",
"55115066", "São\ Paulo\ \-\ SP",
"55133596", "Praia\ Grande\ \-\ SP",
"55553539", "Independência\ \-\ RS",
"55112891", "Suzano\ \-\ SP",
"55513761", "Paverama\ \-\ RS",
"55423231", "Carambeí\ \-\ PR",
"55242445", "Barra\ do\ Piraí\ \-\ RJ",
"5543337", "Londrina\ \-\ PR",
"55453251", "Ouro\ Verde\ do\ Oeste\ \-\ PR",
"55333424", "Senhora\ do\ Porto\ \-\ MG",
"55733667", "Itamaraju\ \-\ BA",
"55433235", "Primeiro\ de\ Maio\ \-\ PR",
"55443048", "Sarandi\ \-\ PR",
"55383253", "Engenheiro\ Navarro\ \-\ MG",
"55643443", "Catalão\ \-\ GO",
"55483035", "São\ José\ \-\ SC",
"55513266", "Rio\ Grande\ do\ Sul",
"55483583", "Balneário\ Gaivota\ \-\ SC",
"55163669", "Cássia\ dos\ Coqueiros\ \-\ SP",
"55143762", "Taquarituba\ \-\ SP",
"55183691", "Buritama\ \-\ SP",
"55192122", "Campinas\ \-\ SP",
"55212692", "Nilópolis\ \-\ RJ",
"55833288", "Mulungu\ \-\ PB",
"5592362", "Manaus\ \-\ AM",
"55183322", "Assis\ \-\ SP",
"55673503", "Paranaíba\ \-\ MS",
"55413627", "Fazenda\ Rio\ Grande\ \-\ PR",
"55124158", "Vargem\ Grande\ Paulista\ \-\ SP",
"55743624", "Jacobina\ \-\ BA",
"55463244", "Sulina\ \-\ PR",
"55643479", "Panamá\ \-\ GO",
"55633387", "Jaú\ do\ Tocantins\ \-\ TO",
"55983273", "São\ Luís\ \-\ MA",
"55913469", "Nova\ Timboteua\ \-\ PA",
"55813431", "Olinda\ \-\ PE",
"55913606", "Bagre\ \-\ PA",
"55214062", "Rio\ de\ Janeiro\ \-\ RJ",
"55713637", "Vera\ Cruz\ \-\ BA",
"55823629", "Ouro\ Branco\ \-\ AL",
"55443634", "São\ Jorge\ do\ Patrocínio\ \-\ PR",
"55753328", "Ibiquera\ \-\ BA",
"55553755", "Liberato\ Salzano\ \-\ RS",
"55513415", "Canoas\ \-\ RS",
"55933793", "Porto\ de\ Moz\ \-\ PA",
"55913182", "Belém\ \-\ PA",
"55513416", "Capão\ da\ Canoa\ \-\ RS",
"55653343", "Arenápolis\ \-\ MT",
"55553756", "Cerro\ Grande\ \-\ RS",
"55883529", "Milhã\ \-\ CE",
"55163512", "Ribeirão\ Preto\ \-\ SP",
"5581346", "Recife\ \-\ PE",
"55814109", "Paulista\ \-\ PE",
"55913605", "Anajás\ \-\ PA",
"55114705", "Santana\ de\ Parnaíba\ \-\ SP",
"55513502", "Capão\ da\ Canoa\ \-\ RS",
"55133384", "Guarujá\ \-\ SP",
"55193000", "Vinhedo\ \-\ SP",
"55813652", "Camutanga\ \-\ PE",
"55123671", "São\ Luís\ do\ Paraitinga\ \-\ SP",
"55163406", "Franca\ \-\ SP",
"55163405", "Franca\ \-\ SP",
"55733225", "Igrapiúna\ \-\ BA",
"55173893", "Palestina\ \-\ SP",
"55643586", "Itumbiara\ \-\ GO",
"55443438", "São\ Carlos\ do\ Ivaí\ \-\ PR",
"55343269", "Ituiutaba\ \-\ MG",
"55143372", "Santa\ Cruz\ do\ Rio\ Pardo\ \-\ SP",
"55323250", "Juiz\ de\ Fora\ \-\ MG",
"55493622", "São\ Miguel\ do\ Oeste\ \-\ SC",
"55553338", "Nova\ Ramada\ \-\ RS",
"55183571", "Flórida\ Paulista\ \-\ SP",
"55833461", "Santa\ Luzia\ \-\ PB",
"55513627", "Imbé\ \-\ RS",
"55114706", "Barueri\ \-\ SP",
"55183302", "Assis\ \-\ SP",
"5555", "Rio\ Grande\ do\ Sul",
"55454053", "Foz\ do\ Iguaçu\ \-\ PR",
"55222748", "Travessão\ \-\ RJ",
"55663418", "São\ Pedro\ da\ Cipa\ \-\ MT",
"55663481", "Alto\ Araguaia\ \-\ MT",
"552124", "Rio\ de\ Janeiro\ \-\ RJ",
"55114201", "Barueri\ \-\ SP",
"55843378", "São\ Francisco\ do\ Oeste\ \-\ RN",
"55893552", "Guadalupe\ \-\ PI",
"55143104", "Bauru\ \-\ SP",
"55413607", "Araucária\ \-\ PR",
"55373431", "Bambuí\ \-\ MG",
"55114694", "Biritiba\-Mirim\ \-\ SP",
"55753011", "Feira\ de\ Santana\ \-\ BA",
"55553251", "Santiago\ \-\ RS",
"55192102", "Campinas\ \-\ SP",
"55623565", "Goiânia\ \-\ GO",
"55112277", "Bragança\ Paulista\ \-\ SP",
"55173441", "General\ Salgado\ \-\ SP",
"55212301", "Rio\ de\ Janeiro\ \-\ RJ",
"55483659", "Pedras\ Grandes\ \-\ SC",
"55113383", "São\ Paulo\ \-\ SP",
"55552103", "Santa\ Maria\ \-\ RS",
"55513470", "Rio\ Grande\ do\ Sul",
"55383534", "Diamantina\ \-\ MG",
"55923215", "Manaus\ \-\ AM",
"55353654", "Gonçalves\ \-\ MG",
"55673243", "Dois\ Irmãos\ do\ Buriti\ \-\ MS",
"55513493", "Viamão\ \-\ RS",
"55613517", "Brasília\ \-\ DF",
"55173815", "Guaraci\ \-\ SP",
"55313718", "Baldim\ \-\ MG",
"55313577", "Minas\ Gerais",
"551137", "São\ Paulo\ \-\ SP",
"55343832", "Patrocínio\ \-\ MG",
"55813625", "Goiana\ \-\ PE",
"55493656", "Saltinho\ \-\ SC",
"55513739", "Rio\ Grande\ do\ Sul",
"55443250", "Presidente\ Castelo\ Branco\ \-\ PR",
"55813626", "Goiana\ \-\ PE",
"55143842", "São\ Manuel\ \-\ SP",
"55493655", "Campo\ Erê\ \-\ SC",
"55483462", "Criciúma\ \-\ SC",
"55653235", "Figueirópolis\ D\'Oeste\ \-\ MT",
"55173816", "Orindiúva\ \-\ SP",
"55834101", "Campina\ Grande\ \-\ PB",
"55413555", "Campo\ Largo\ \-\ PR",
"55124611", "Cotia\ \-\ SP",
"55213099", "Teresópolis\ \-\ RJ",
"55413556", "São\ José\ dos\ Pinhais\ \-\ PR",
"55433717", "Londrina\ \-\ PR",
"55493449", "Ipuaçu\ \-\ SC",
"55813469", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"5561325", "Brasília\ \-\ DF",
"55223013", "Campos\ dos\ Goitacazes\ \-\ RJ",
"55833360", "Borborema\ \-\ PB",
"55623542", "Goiânia\ \-\ GO",
"5563", "Tocantins",
"55733546", "Nova\ Itarana\ \-\ BA",
"55983011", "São\ Luís\ \-\ MA",
"55753447", "Ouriçangas\ \-\ BA",
"55453027", "Foz\ do\ Iguaçu\ \-\ PR",
"55793114", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55193853", "Pedreira\ \-\ SP",
"55823270", "Maribondo\ \-\ AL",
"55513555", "Rio\ Grande\ do\ Sul",
"55383563", "São\ Gonçalo\ do\ Abaeté\ \-\ MG",
"55613612", "Cristalina\ \-\ GO",
"55533717", "Rio\ Grande\ \-\ RS",
"55513556", "Rio\ Grande\ do\ Sul",
"55633539", "Lizarda\ \-\ TO",
"55823293", "Paripueira\ \-\ AL",
"55213743", "Nilópolis\ \-\ RJ",
"55115042", "São\ Paulo\ \-\ SP",
"55773491", "São\ Félix\ do\ Coribe\ \-\ BA",
"55873781", "Canhotinho\ \-\ PE",
"55833439", "Lagoa\ \-\ PB",
"55273278", "Acioli\ \-\ ES",
"5598324", "São\ Luís\ \-\ MA",
"55382101", "Montes\ Claros\ \-\ MG",
"55463524", "Francisco\ Beltrão\ \-\ PR",
"55193481", "São\ Pedro\ \-\ SP",
"55133513", "Santos\ \-\ SP",
"55823032", "Maceió\ \-\ AL",
"55843223", "Natal\ \-\ RN",
"55473351", "Brusque\ \-\ SC",
"55553027", "Santa\ Maria\ \-\ RS",
"55114144", "Itapevi\ \-\ SP",
"55213779", "Nova\ Iguaçu\ \-\ RJ",
"55553387", "Ajuricaba\ \-\ RS",
"55313697", "Bairro\ Eldorado\ \-\ Sete\ Lagoas\ MG",
"55452103", "Toledo\ \-\ PR",
"55213568", "Niterói\ \-\ RJ",
"55423912", "São\ Mateus\ do\ Sul\ \-\ PR",
"55993552", "Colinas\ \-\ MA",
"55663558", "Santa\ Terezinha\ \-\ MT",
"55613368", "Brasília\ \-\ DF",
"55753249", "Tanquinho\ \-\ BA",
"55493247", "Lebon\ Régis\ \-\ SC",
"55973423", "Fonte\ Boa\ \-\ AM",
"55183355", "Presidente\ Prudente\ \-\ SP",
"55433343", "Londrina\ \-\ PR",
"55483212", "Florianópolis\ \-\ SC",
"55113514", "São\ Paulo\ \-\ SP",
"55883447", "Limoeiro\ do\ Norte\ \-\ CE",
"55183356", "Echaporã\ \-\ SP",
"55113188", "São\ Paulo\ \-\ SP",
"55473238", "Blumenau\ \-\ SC",
"55753685", "Ipecaetá\ \-\ BA",
"55483463", "Forquilhinha\ \-\ SC",
"55153527", "Itapetininga\ \-\ SP",
"55663027", "Rondonópolis\ \-\ MT",
"55123978", "Jambeiro\ \-\ SP",
"55833367", "Bananeiras\ \-\ PB",
"55643609", "Itumbiara\ \-\ GO",
"55533342", "Pelotas\ \-\ RS",
"55343833", "Serra\ do\ Salitre\ \-\ MG",
"55513492", "Viamão\ \-\ RS",
"55673242", "Miranda\ \-\ MS",
"55543459", "Bento\ Gonçalves\ \-\ RS",
"55823891", "Viçosa\ \-\ MG",
"55653366", "Nova\ Mutum\ \-\ MT",
"55143879", "Bauru\ \-\ SP",
"55653365", "Cuiabá\ \-\ MT",
"55552102", "Uruguaiana\ \-\ RS",
"55183278", "Caiuá\ \-\ SP",
"55853404", "Fortaleza\ \-\ CE",
"55143491", "Tupã\ \-\ SP",
"55213846", "Duque\ de\ Caxias\ \-\ RJ",
"55843084", "Natal\ \-\ RN",
"55213845", "Duque\ de\ Caxias\ \-\ RJ",
"55223012", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55443257", "Flórida\ \-\ PR",
"55173347", "Jaborandi\ \-\ SP",
"55313570", "Minas\ Gerais",
"55353461", "Bom\ Repouso\ \-\ MG",
"55123421", "Taubaté\ \-\ SP",
"55863288", "Palmeirais\ \-\ PI",
"55513477", "Canoas\ \-\ RS",
"55273355", "Vitória\ \-\ ES",
"55623579", "Goiânia\ \-\ GO",
"55433244", "Prado\ Ferreira\ \-\ PR",
"55213551", "Rio\ de\ Janeiro\ \-\ RJ",
"55883685", "Ipueiras\ \-\ CE",
"55634052", "Palmas\ \-\ TO",
"55663561", "Itaúba\ \-\ MT",
"55323021", "Ubá\ \-\ MG",
"55613351", "Taguatinga\ \-\ DF",
"55843222", "Natal\ \-\ RN",
"55313649", "Santa\ Luzia\ \-\ MG",
"55242463", "Engenheiro\ Paulo\ de\ Frontin\ \-\ RJ",
"55823033", "Maceió\ \-\ AL",
"55483434", "Morro\ da\ Fumaça\ \-\ SC",
"55383721", "Curvelo\ \-\ MG",
"55163818", "São\ Joaquim\ da\ Barra\ \-\ SP",
"55163987", "Serrana\ \-\ SP",
"55883686", "Catunda\ \-\ CE",
"55133406", "São\ Vicente\ \-\ SP",
"55213742", "Nova\ Iguaçu\ \-\ RJ",
"55353211", "Passos\ \-\ MG",
"55443646", "Pérola\ Independente\ \-\ PR",
"55823292", "Porto\ Calvo\ \-\ AL",
"55913311", "Castanhal\ \-\ PA",
"55163384", "Matão\ \-\ SP",
"55383562", "Brasilândia\ de\ Minas\ \-\ MG",
"55613613", "Águas\ Lindas\ de\ Goiás\ \-\ GO",
"55623486", "Colinas\ do\ Sul\ \-\ GO",
"55662103", "Rondonópolis\ \-\ MT",
"551121", "São\ Paulo\ \-\ SP",
"55193852", "Pedreira\ \-\ SP",
"55443645", "Terra\ Roxa\ \-\ PR",
"55643629", "Montividiu\ \-\ GO",
"55512139", "Porto\ Alegre\ \-\ RS",
"55353716", "Poços\ de\ Caldas\ \-\ MG",
"55313456", "Minas\ Gerais",
"55513279", "Rio\ Grande\ do\ Sul",
"55433342", "Londrina\ \-\ PR",
"55753272", "Tucano\ \-\ BA",
"55353715", "Poços\ de\ Caldas\ \-\ MG",
"55163024", "Ribeirão\ Preto\ \-\ SP",
"55623378", "Itauçu\ \-\ GO",
"55553359", "Cerro\ Largo\ \-\ RS",
"55513243", "Rio\ Grande\ do\ Sul",
"55223717", "Macaé\ \-\ RJ",
"55193539", "Ajapi\ \-\ SP",
"55423460", "Teixeira\ Soares\ \-\ PR",
"55383226", "Coração\ de\ Jesus\ \-\ MG",
"55643465", "Urutaí\ \-\ GO",
"55823277", "Anadia\ \-\ AL",
"55753030", "Feira\ de\ Santana\ \-\ BA",
"55473098", "Itapema\ \-\ SC",
"55114528", "Cabreúva\ \-\ SP",
"55183998", "João\ Ramalho\ \-\ SP",
"55993553", "Sucupira\ do\ Riachão\ \-\ MA",
"55452102", "Foz\ do\ Iguaçu\ \-\ PR",
"55333025", "Governador\ Valadares\ \-\ MG",
"55353645", "São\ José\ do\ Alegre\ \-\ MG",
"55443288", "Sarandi\ \-\ PR",
"55693043", "Porto\ Velho\ \-\ RO",
"55433543", "Itambaracá\ \-\ PR",
"55543461", "Carlos\ Barbosa\ \-\ RS",
"55813468", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55493448", "Arabutã\ \-\ SC",
"55183556", "Inúbia\ Paulista\ \-\ SP",
"55123655", "Caçapava\ \-\ SP",
"55414114", "Curitiba\ \-\ PR",
"55493644", "Dionísio\ Cerqueira\ \-\ SC",
"55843235", "Natal\ \-\ RN",
"55283547", "Conceição\ do\ Castelo\ \-\ ES",
"55433579", "Salto\ do\ Itararé\ \-\ PR",
"55613568", "Guará\ \-\ DF",
"55833048", "João\ Pessoa\ \-\ PB",
"55313767", "Minas\ Gerais",
"55173643", "Santa\ Rita\ D\'Oeste\ \-\ SP",
"55454100", "Cascavel\ \-\ PR",
"55843236", "Natal\ \-\ RN",
"55473154", "Rio\ dos\ Cedros\ \-\ SC",
"55342102", "Uberlândia\ \-\ MG",
"55383232", "Cristália\ \-\ MG",
"55673278", "Rio\ Negro\ \-\ MS",
"55373281", "Santo\ Antônio\ do\ Monte\ \-\ MG",
"55313719", "Minas\ Gerais",
"55743547", "Antônio\ Gonçalves\ \-\ BA",
"55414009", "Curitiba\ \-\ PR",
"55513738", "Venâncio\ Aires\ \-\ RS",
"55314", "Minas\ Gerais",
"55553276", "São\ Pedro\ do\ Sul\ \-\ RS",
"55333293", "São\ José\ da\ Safira\ \-\ MG",
"55693464", "Vale\ do\ Paraíso\ \-\ RO",
"55733554", "Aurelino\ Leal\ \-\ BA",
"55773229", "Brumado\ \-\ BA",
"55453275", "São\ Clemente\ \-\ PR",
"55623342", "Ipiranga\ de\ Goiás\ \-\ GO",
"55643641", "Santa\ Helena\ de\ Goiás\ \-\ GO",
"55313392", "Contagem\ \-\ MG",
"5585347", "Fortaleza\ \-\ CE",
"55514009", "Porto\ Alegre\ \-\ RS",
"55453276", "Santa\ Helena\ \-\ PR",
"55343359", "Uberaba\ \-\ MG",
"55943012", "Marabá\ \-\ PA",
"55513544", "Taquara\ \-\ RS",
"55463565", "Flor\ da\ Serra\ do\ Sul\ \-\ PR",
"55313621", "Vespasiano\ \-\ MG",
"55112641", "São\ Paulo\ \-\ SP",
"55653223", "Cáceres\ \-\ MT",
"55943379", "São\ João\ do\ Araguaia\ \-\ PA",
"55753248", "Coração\ de\ Maria\ \-\ BA",
"55324101", "Barbacena\ \-\ MG",
"55273129", "Guarapari\ \-\ ES",
"55613369", "Paranoá\ \-\ DF",
"55663559", "Novo\ Horizonte\ do\ Norte\ \-\ MT",
"55813633", "Nazaré\ da\ Mata\ \-\ PE",
"55383749", "Pirapora\ \-\ MG",
"55313377", "Belo\ Horizonte\ \-\ MG",
"55163958", "Taquaral\ \-\ SP",
"55893533", "Rio\ Grande\ do\ Piauí\ \-\ PI",
"55813281", "Recife\ \-\ PE",
"55383831", "Porteirinha\ \-\ MG",
"55543288", "Gramado\ \-\ RS",
"55473047", "Balneário\ Camboriú\ \-\ SC",
"55833438", "Condado\ \-\ PB",
"55553361", "Giruá\ \-\ RS",
"55183841", "Junqueirópolis\ \-\ SP",
"55424052", "Guarapuava\ \-\ PR",
"55833634", "Casserengue\ \-\ PB",
"55743642", "Irecê\ \-\ BA",
"55333737", "Berilo\ \-\ MG",
"55773616", "Formosa\ do\ Rio\ Preto\ \-\ BA",
"55633538", "Aparecida\ do\ Rio\ Negro\ \-\ TO",
"55183344", "Presidente\ Prudente\ \-\ SP",
"55654001", "Cuiabá\ \-\ MT",
"55623578", "Aparecida\ de\ Goiânia\ \-\ GO",
"55833381", "Montadas\ \-\ PB",
"55823025", "Maceió\ \-\ AL",
"55653927", "Várzea\ Grande\ \-\ MT",
"55553559", "Braga\ \-\ RS",
"55173642", "Vitória\ Brasil\ \-\ SP",
"55453231", "Santa\ Tereza\ do\ Oeste\ \-\ PR",
"55423251", "Papagaios\ Novos\ \-\ PR",
"55883574", "Barbalha\ \-\ CE",
"55693651", "Costa\ Marques\ \-\ RO",
"55863289", "São\ Gonçalo\ do\ Piauí\ \-\ PI",
"55222554", "Macuco\ \-\ RJ",
"55843365", "Messias\ Targino\ \-\ RN",
"55114509", "Santo\ André\ \-\ SP",
"5542", "Paraná",
"55813537", "Chã\ Grande\ \-\ PE",
"55843366", "Janduís\ \-\ RN",
"55313034", "Contagem\ \-\ MG",
"55433542", "Bandeirantes\ \-\ PR",
"55114916", "São\ Paulo\ \-\ SP",
"5554331", "Passo\ Fundo\ \-\ RS",
"55863250", "Prata\ do\ Piauí\ \-\ PI",
"55153307", "Itapetininga\ \-\ SP",
"55753201", "Acupe\ \-\ BA",
"55183279", "Regente\ Feijó\ \-\ SP",
"55543458", "Tuiutí\ \-\ RS",
"55313760", "Minas\ Gerais",
"55643404", "Itumbiara\ \-\ GO",
"55193744", "Campinas\ \-\ SP",
"55333292", "Marilac\ \-\ MG",
"55273344", "Viana\ \-\ ES",
"55883221", "Juazeiro\ do\ Norte\ \-\ CE",
"55643608", "Bom\ Jesus\ de\ Goiás\ \-\ GO",
"55843504", "Caicó\ \-\ RN",
"55613551", "Brasília\ \-\ DF",
"55433255", "Rolândia\ \-\ PR",
"55433256", "Rolândia\ \-\ PR",
"55123979", "Monteiro\ Lobato\ \-\ SP",
"55753694", "Santanópolis\ \-\ BA",
"55114011", "Piracaia\ \-\ SP",
"55383233", "Francisco\ Sá\ \-\ MG",
"55483055", "Içara\ \-\ SC",
"55114529", "Jacaré\ \-\ SP",
"55143407", "Garça\ \-\ SP",
"55183999", "Estrela\ do\ Norte\ \-\ SP",
"55553358", "Salvador\ das\ Missões\ \-\ RS",
"55653222", "Cáceres\ \-\ MT",
"55343826", "Patos\ de\ Minas\ \-\ MG",
"55273555", "Mimoso\ do\ Sul\ \-\ ES",
"55623379", "Minaçu\ \-\ GO",
"55193538", "Ajapi\ \-\ SP",
"55533255", "Pedro\ Osório\ \-\ RS",
"55943013", "Parauapebas\ \-\ PA",
"55943342", "Abel\ Figueiredo\ \-\ PA",
"55443654", "Brasilândia\ do\ Sul\ \-\ PR",
"55313393", "Minas\ Gerais",
"55623343", "Abadiânia\ \-\ GO",
"55173547", "Itajobi\ \-\ SP",
"55114308", "Diadema\ \-\ SP",
"55533256", "Bojuru\ \-\ RS",
"55843271", "Macaíba\ \-\ RN",
"55313370", "Minas\ Gerais",
"55793431", "Itabaiana\ \-\ SE",
"55693432", "Rolim\ de\ Moura\ \-\ RO",
"55163396", "Santa\ Lúcia\ \-\ SP",
"55273242", "Vila\ Velha\ \-\ ES",
"55633467", "Presidente\ Kennedy\ \-\ TO",
"55453559", "Itaipulândia\ \-\ PR",
"55313444", "Belo\ Horizonte\ \-\ MG",
"55643628", "Ouroana\ \-\ GO",
"55653566", "Juína\ \-\ MT",
"55623494", "Cavalcante\ \-\ GO",
"55163395", "Rincão\ \-\ SP",
"55513128", "Gravataí\ \-\ RS",
"55193913", "Itapira\ \-\ SP",
"55743643", "Mulungu\ do\ Morro\ \-\ BA",
"55553231", "Rosário\ do\ Sul\ \-\ RS",
"55463223", "Pato\ Branco\ \-\ PR",
"55113434", "São\ Paulo\ \-\ SP",
"55973471", "São\ Gabriel\ da\ Cachoeira\ \-\ AM",
"55153327", "Sorocaba\ \-\ SP",
"55113638", "São\ Paulo\ \-\ SP",
"55323367", "Alfredo\ Vasconcelos\ \-\ MG",
"55112628", "São\ Paulo\ \-\ SP",
"55833567", "Cabedelo\ \-\ PB",
"55893532", "Pajeú\ do\ Piauí\ \-\ PI",
"55473317", "Indaial\ \-\ SC",
"55514116", "Porto\ Alegre\ \-\ RS",
"55493257", "Frei\ Rogério\ \-\ SC",
"55213528", "Rio\ de\ Janeiro\ \-\ RJ",
"55513252", "Rio\ Grande\ do\ Sul",
"55653637", "Cuiabá\ \-\ MT",
"55383758", "Augusto\ de\ Lima\ \-\ MG",
"55773481", "Bom\ Jesus\ da\ Lapa\ \-\ BA",
"55753259", "Euclides\ da\ Cunha\ \-\ BA",
"55873791", "Palmeirina\ \-\ PE",
"55192146", "Capivari\ \-\ SP",
"55193491", "Capivari\ \-\ SP",
"55993542", "Balsas\ \-\ MA",
"55973463", "Amaturá\ \-\ AM",
"55553372", "Santa\ Bárbara\ do\ Sul\ \-\ RS",
"55833635", "Damião\ \-\ PB",
"55823283", "Viçosa\ \-\ AL",
"55183345", "Presidente\ Prudente\ \-\ SP",
"55833636", "Frei\ Martinho\ \-\ PB",
"55773614", "Barreiras\ \-\ BA",
"55713379", "Lauro\ de\ Freitas\ \-\ BA",
"55843332", "Areia\ Branca\ \-\ RN",
"55112610", "Mogi\ das\ Cruzes\ \-\ SP",
"55453274", "Toledo\ \-\ PR",
"55113198", "São\ Paulo\ \-\ SP",
"55163973", "Guatapará\ \-\ SP",
"55513546", "Três\ Coroas\ \-\ RS",
"55883531", "Brejo\ Santo\ \-\ CE",
"55513545", "Igrejinha\ \-\ RS",
"55115641", "São\ Paulo\ \-\ SP",
"55383523", "Felício\ dos\ Santos\ \-\ MG",
"55873830", "Solidão\ \-\ PE",
"55193843", "Itapira\ \-\ SP",
"55313071", "Belo\ Horizonte\ \-\ MG",
"55163949", "Cruz\ das\ Posses\ \-\ SP",
"5516362", "Ribeirão\ Preto\ \-\ SP",
"55463564", "Salgado\ Filho\ \-\ PR",
"55473341", "Itajaí\ \-\ SC",
"55793712", "Aracaju\ \-\ SE",
"55483199", "Tubarão\ \-\ SC",
"5598325", "São\ Luís\ \-\ MA",
"55843263", "Touros\ \-\ RN",
"55193879", "Monte\ Mor\ \-\ SP",
"55643610", "Mineiros\ \-\ GO",
"55693216", "Porto\ Velho\ \-\ RO",
"55373227", "Nova\ Serrana\ \-\ MG",
"55893566", "Redenção\ do\ Gurguéia\ \-\ PI",
"55643513", "Caldas\ Novas\ \-\ GO",
"55473156", "Braço\ do\ Baú\ \-\ SC",
"55923512", "Borba\ \-\ AM",
"55893565", "Santa\ Luz\ \-\ PI",
"55273015", "Vitória\ \-\ ES",
"55613308", "Planaltina\ \-\ DF",
"55344004", "Uberlândia\ \-\ MG",
"55693465", "Teixeirópolis\ \-\ RO",
"55513354", "Rio\ Grande\ do\ Sul",
"5513347", "Praia\ Grande\ \-\ SP",
"55733556", "Lajedo\ do\ Tabocal\ \-\ BA",
"55213508", "Itaboraí\ \-\ RJ",
"55713717", "Camaçari\ \-\ BA",
"55993647", "Igarapé\ Grande\ \-\ MA",
"55513483", "Alvorada\ \-\ RS",
"55623552", "Guapó\ \-\ GO",
"55693466", "Nova\ União\ \-\ RO",
"55493459", "Coronel\ Martins\ \-\ SC",
"5561324", "Brasília\ \-\ DF",
"55414116", "Curitiba\ \-\ PR",
"55313830", "Minas\ Gerais",
"55353644", "Piranguinho\ \-\ MG",
"55123654", "Caçapava\ \-\ SP",
"55533611", "Portão\ \-\ RS",
"55983368", "Primeira\ Cruz\ \-\ MA",
"55213089", "Rio\ de\ Janeiro\ \-\ RJ",
"55543472", "São\ Valentim\ do\ Sul\ \-\ RS",
"55843234", "Natal\ \-\ RN",
"55114047", "Diadema\ \-\ SP",
"55733242", "Ibicaraí\ \-\ BA",
"55493645", "Guaraciaba\ \-\ SC",
"55212152", "Teresópolis\ \-\ RJ",
"55493646", "Cunha\ Porã\ \-\ SC",
"55463533", "São\ João\ \-\ PR",
"55313295", "Belo\ Horizonte\ \-\ MG",
"55313445", "Belo\ Horizonte\ \-\ MG",
"55843525", "Guamaré\ \-\ RN",
"55113436", "Guarulhos\ \-\ SP",
"55133216", "Santos\ \-\ SP",
"55353298", "Machado\ \-\ MG",
"55113435", "Guarulhos\ \-\ SP",
"55823282", "Paulo\ Jacinto\ \-\ AL",
"55843526", "Porto\ do\ Mangue\ \-\ RN",
"55163394", "Matão\ \-\ SP",
"55553373", "Saldanha\ Marinho\ \-\ RS",
"55313446", "Belo\ Horizonte\ \-\ MG",
"55312191", "Contagem\ \-\ MG",
"55853464", "Fortaleza\ \-\ CE",
"55993543", "Tasso\ Fragoso\ \-\ MA",
"55143268", "Macatuba\ \-\ SP",
"55493289", "Lages\ \-\ SC",
"559132", "Belém\ \-\ PA",
"55883696", "Monsenhor\ Tabosa\ \-\ CE",
"55873837", "Iguaraci\ \-\ PE",
"55513253", "Rio\ Grande\ do\ Sul",
"55753287", "Abaré\ \-\ BA",
"55883695", "Sobral\ \-\ CE",
"55112078", "Barueri\ \-\ SP",
"55343824", "Lagoa\ Formosa\ \-\ MG",
"55843262", "João\ Câmara\ \-\ RN",
"55323061", "Juiz\ de\ Fora\ \-\ MG",
"55663521", "Alta\ Floresta\ \-\ MT",
"55114779", "Itapecerica\ da\ Serra\ \-\ SP",
"55273151", "Linhares\ \-\ ES",
"55183911", "Eneida\ \-\ SP",
"55613341", "Cruzeiro\ \-\ DF",
"55413482", "Guaraqueçaba\ \-\ PR",
"55673483", "Coronel\ Sapucaia\ \-\ MS",
"55443655", "Cafezal\ do\ Sul\ \-\ PR",
"55193842", "Serra\ Negra\ \-\ SP",
"55123211", "Cruzeiro\ \-\ SP",
"55873035", "Petrolina\ \-\ PE",
"55533254", "Cerrito\ \-\ RS",
"55633491", "Luzinópolis\ \-\ TO",
"55163972", "Bonfim\ Paulista\ \-\ SP",
"55443656", "Alto\ Piquiri\ \-\ PR",
"55843333", "Apodi\ \-\ RN",
"55833307", "Caraúbas\ \-\ PB",
"55753162", "Santo\ Antônio\ de\ Jesus\ \-\ BA",
"55213855", "Rio\ de\ Janeiro\ \-\ RJ",
"55623553", "Hidrolândia\ \-\ GO",
"55193746", "Campinas\ \-\ SP",
"55843412", "Currais\ Novos\ \-\ RN",
"55443247", "Santa\ Fé\ \-\ PR",
"55913116", "Belém\ \-\ PA",
"55513482", "Barra\ do\ Ribeiro\ \-\ RS",
"55162137", "Ribeirão\ Preto\ \-\ SP",
"55213856", "São\ Gonçalo\ \-\ RJ",
"55643405", "Piracanjuba\ \-\ GO",
"55983351", "Viana\ \-\ MA",
"55433254", "Cambé\ \-\ PR",
"55114099", "Diadema\ \-\ SP",
"55553548", "Cândido\ Godói\ \-\ RS",
"55753696", "Saubara\ \-\ BA",
"55273345", "Vitória\ \-\ ES",
"55153519", "Sorocaba\ \-\ SP",
"55643512", "Rio\ Quente\ \-\ GO",
"55753695", "São\ Domingos\ \-\ BA",
"55313837", "Barão\ de\ Cocais\ \-\ MG",
"55283511", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"5577", "Bahia",
"55673546", "Brasilândia\ \-\ MS",
"55683311", "Cruzeiro\ do\ Sul\ \-\ AC",
"55343301", "Uberlândia\ \-\ MG",
"55443039", "Cianorte\ \-\ PR",
"55314122", "Contagem\ \-\ MG",
"55883576", "Jaguaretama\ \-\ CE",
"55463532", "Quedas\ do\ Iguaçu\ \-\ PR",
"55212153", "Rio\ de\ Janeiro\ \-\ RJ",
"55683028", "Rio\ Branco\ \-\ AC",
"55733243", "Floresta\ Azul\ \-\ BA",
"55883575", "Jati\ \-\ CE",
"55114317", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55863298", "Angical\ do\ Piauí\ \-\ PI",
"55793347", "Cedro\ de\ São\ João\ \-\ SE",
"55843364", "Olho\-D\'Água\ do\ Borges\ \-\ RN",
"55663501", "Alta\ Floresta\ \-\ MT",
"55114914", "São\ Paulo\ \-\ SP",
"55653326", "Tangará\ da\ Serra\ \-\ MT",
"55222555", "Cantagalo\ \-\ RJ",
"55733279", "Teolândia\ \-\ BA",
"55653325", "Tangará\ da\ Serra\ \-\ MT",
"55222556", "São\ Sebastião\ do\ Alto\ \-\ RJ",
"55543449", "Bento\ Gonçalves\ \-\ RS",
"55143481", "Marília\ \-\ SP",
"55183851", "Tupi\ Paulista\ \-\ SP",
"55773467", "Jacaraci\ \-\ BA",
"55193878", "Louveira\ \-\ SP",
"55843637", "Bento\ Fernandes\ \-\ RN",
"55113402", "Atibaia\ \-\ SP",
"55553321", "Cruz\ Alta\ \-\ RS",
"55443421", "Paranavaí\ \-\ PR",
"55313130", "Matozinhos\ \-\ MG",
"55163820", "Orlândia\ \-\ SP",
"55313382", "Minas\ Gerais",
"55183354", "Platina\ \-\ SP",
"55463262", "Palmas\ \-\ PR",
"55753331", "Seabra\ \-\ BA",
"55273253", "Serra\ \-\ ES",
"55713699", "Saubara\ \-\ BA",
"55113515", "São\ Paulo\ \-\ SP",
"55743652", "Ibititá\ \-\ BA",
"55663573", "Paranatinga\ \-\ MT",
"55513554", "São\ Leopoldo\ \-\ RS",
"55643651", "Quirinópolis\ \-\ GO",
"55713378", "Lauro\ de\ Freitas\ \-\ BA",
"55813604", "Surubim\ \-\ PE",
"55943353", "Vila\ Cruzeiro\ do\ Sul\ \-\ PA",
"55513151", "Porto\ Alegre\ \-\ RS",
"55242471", "Vassouras\ \-\ RJ",
"55653332", "Nova\ Olímpia\ \-\ MT",
"55313661", "Pedro\ Leopoldo\ \-\ MG",
"55753258", "Araci\ \-\ BA",
"55463525", "Marmeleiro\ \-\ PR",
"55383759", "Lassance\ \-\ MG",
"55673016", "Dourados\ \-\ MS",
"55453301", "Cascavel\ \-\ PR",
"55112651", "São\ Paulo\ \-\ SP",
"55114145", "Itapevi\ \-\ SP",
"55923312", "Balbina\ \-\ AM",
"55543401", "Farroupilha\ \-\ RS",
"55463526", "Itapejara\ D\'Oeste\ \-\ PR",
"55314136", "Belo\ Horizonte\ \-\ MG",
"55793643", "Riachão\ do\ Dantas\ \-\ SE",
"55353449", "Pouso\ Alegre\ \-\ MG",
"55413554", "Quatro\ Barras\ \-\ PR",
"55963622", "Vitória\ do\ Jari\ \-\ AP",
"5511364", "São\ Paulo\ \-\ SP",
"55173475", "Meridiano\ \-\ SP",
"55643432", "Itumbiara\ \-\ GO",
"55813877", "Carnaubeira\ da\ Penha\ \-\ PE",
"55733544", "Planaltino\ \-\ BA",
"55843532", "Lajes\ \-\ RN",
"55983369", "Santo\ Amaro\ do\ Maranhão\ \-\ MA",
"55353473", "Santa\ Rita\ do\ Sapucaí\ \-\ MG",
"55693424", "Ji\-Paraná\ \-\ RO",
"55513345", "Rio\ Grande\ do\ Sul",
"55212251", "São\ Gonçalo\ \-\ RJ",
"55443401", "Cianorte\ \-\ PR",
"55714113", "Lauro\ de\ Freitas\ \-\ BA",
"55553301", "Santa\ Maria\ \-\ RS",
"55113422", "São\ Caetano\ do\ Sul\ \-\ SP",
"55833623", "Cuité\ de\ Mamanguape\ \-\ PB",
"55383083", "Montes\ Claros\ \-\ MG",
"55383535", "Datas\ \-\ MG",
"55353656", "Consolação\ \-\ MG",
"55213916", "Rio\ de\ Janeiro\ \-\ RJ",
"55173311", "Catanduva\ \-\ SP",
"55212755", "São\ João\ de\ Meriti\ \-\ RJ",
"55493458", "Itá\ \-\ SC",
"55193407", "Americana\ \-\ SP",
"55433553", "Nova\ América\ da\ Colina\ \-\ PR",
"55212756", "São\ João\ de\ Meriti\ \-\ RJ",
"55543421", "Gramado\ \-\ RS",
"55353655", "Sapucaí\-Mirim\ \-\ MG",
"55123646", "Roseira\ \-\ SP",
"55453321", "Cascavel\ \-\ PR",
"55863247", "Castelo\ do\ Piauí\ \-\ PI",
"55813624", "Surubim\ \-\ PE",
"55313727", "Capela\ Nova\ \-\ MG",
"55173814", "Adolfo\ \-\ SP",
"55833058", "Campina\ Grande\ \-\ PB",
"5565368", "Várzea\ Grande\ \-\ MT",
"55493654", "São\ Bernardino\ \-\ SC",
"55283557", "Apiacá\ \-\ ES",
"55743653", "Morro\ do\ Chapéu\ \-\ BA",
"55663301", "Rondonópolis\ \-\ MT",
"55793547", "Arauá\ \-\ SE",
"55643668", "Serranópolis\ \-\ GO",
"55913017", "Ananindeua\ \-\ PA",
"55163026", "Franca\ \-\ SP",
"55633427", "Pequizeiro\ \-\ TO",
"55353714", "Poços\ de\ Caldas\ \-\ MG",
"55163025", "Franca\ \-\ SP",
"55463263", "Palmas\ \-\ PR",
"55313383", "Belo\ Horizonte\ \-\ MG",
"55753261", "Serrinha\ \-\ BA",
"5517321", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55663597", "Nova\ Monte\ Verde\ \-\ MT",
"55113403", "Bragança\ Paulista\ \-\ SP",
"55112668", "Mogi\ das\ Cruzes\ \-\ SP",
"5545322", "Cascavel\ \-\ PR",
"55123112", "Potim\ \-\ SP",
"55443448", "Marilena\ \-\ PR",
"55483436", "Nova\ Veneza\ \-\ SC",
"55883684", "Ipaporanga\ \-\ CE",
"55623611", "Aparecida\ de\ Goiânia\ \-\ GO",
"55143269", "Lençóis\ Paulista\ \-\ SP",
"55483435", "Siderópolis\ \-\ SC",
"55623484", "Mambaí\ \-\ GO",
"55883411", "Russas\ \-\ CE",
"55173557", "Sales\ \-\ SP",
"55533246", "Aceguá\ \-\ RS",
"55163385", "Tabatinga\ \-\ SP",
"55312586", "Contagem\ \-\ MG",
"55112312", "Mogi\ das\ Cruzes\ \-\ SP",
"55623353", "Goianésia\ \-\ GO",
"55473050", "Camboriú\ \-\ SC",
"55943352", "Parauapebas\ \-\ PA",
"55993578", "São\ Domingos\ do\ Maranhão\ \-\ MA",
"55813031", "Recife\ \-\ PE",
"55543038", "Garibaldi\ \-\ RS",
"55713647", "Catu\ \-\ BA",
"55443644", "São\ Manoel\ do\ Paraná\ \-\ PR",
"55353299", "Alfenas\ \-\ MG",
"55163386", "Dobrada\ \-\ SP",
"55773460", "Igaporã\ \-\ BA",
"55663572", "Nova\ Bandeirantes\ \-\ MT",
"55533245", "Candiota\ \-\ RS",
"55833622", "Capim\ \-\ PB",
"55113423", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55463234", "Bom\ Sucesso\ do\ Sul\ \-\ PR",
"55733278", "Wenceslau\ Guimarães\ \-\ BA",
"55714112", "Salvador\ \-\ BA",
"55313720", "Minas\ Gerais",
"55353472", "Cachoeira\ de\ Minas\ \-\ MG",
"55183117", "Araçatuba\ \-\ SP",
"55863240", "Cabeceiras\ do\ Piauí\ \-\ PI",
"55843533", "Afonso\ Bezerra\ \-\ RN",
"55213844", "Nova\ Iguaçu\ \-\ RJ",
"55643433", "Itumbiara\ \-\ GO",
"55483045", "Criciúma\ \-\ SC",
"55663321", "Rondonópolis\ \-\ MT",
"55863299", "Hugo\ Napoleão\ \-\ PI",
"55793642", "Colônia\ Treze\ \-\ SE",
"55833391", "Boqueirão\ \-\ PB",
"55913712", "Castanhal\ \-\ PA",
"55273354", "Viana\ \-\ ES",
"55443038", "Umuarama\ \-\ PR",
"55693641", "Alta\ Floresta\ do\ Oeste\ \-\ RO",
"55532128", "Pelotas\ \-\ RS",
"55753684", "Ichu\ \-\ BA",
"55114098", "Salto\ \-\ SP",
"55312107", "Sete\ Lagoas\ \-\ MG",
"55473309", "Blumenau\ \-\ SC",
"55843325", "Upanema\ \-\ RN",
"55433552", "Nova\ Fátima\ \-\ PR",
"55843326", "Tibau\ \-\ RN",
"5555322", "Santa\ Maria\ \-\ RS",
"55653364", "Várzea\ Grande\ \-\ MT",
"55115063", "São\ Paulo\ \-\ SP",
"55242443", "Barra\ do\ Piraí\ \-\ RJ",
"55843252", "Sítio\ Novo\ \-\ RN",
"55773411", "Ibitira\ \-\ BA",
"55483277", "São\ Pedro\ de\ Alcântara\ \-\ SC",
"55273161", "Guarapari\ \-\ ES",
"55323051", "Barbacena\ \-\ MG",
"55773488", "Correntina\ \-\ BA",
"55663541", "Colíder\ \-\ MT",
"55383751", "Corinto\ \-\ MG",
"55433618", "Ibaiti\ \-\ PR",
"55873798", "Bom\ Conselho\ \-\ PE",
"55193498", "Nova\ Odessa\ \-\ SP",
"55343844", "Grupiara\ \-\ MG",
"55543902", "Passo\ Fundo\ \-\ RS",
"55443665", "Icaraíma\ \-\ PR",
"55733203", "Ibicaraí\ \-\ BA",
"55773684", "Roda\ Velha\ \-\ BA",
"55893477", "Inhuma\ \-\ PI",
"55533264", "Praia\ do\ Hermenegildo\ \-\ RS",
"55923071", "Manaus\ \-\ AM",
"55793194", "Aracaju\ \-\ SE",
"55123632", "Taubaté\ \-\ SP",
"55643659", "Itarumã\ \-\ GO",
"55193822", "Sumaré\ \-\ SP",
"55213762", "Nilópolis\ \-\ RJ",
"55443666", "Herculândia\ \-\ PR",
"55313426", "Belo\ Horizonte\ \-\ MG",
"55493337", "Jardinópolis\ \-\ SC",
"55883538", "Potengi\ \-\ CE",
"55113191", "São\ Paulo\ \-\ SP",
"55983276", "São\ Luís\ \-\ MA",
"55673919", "Três\ Lagoas\ \-\ MS",
"55242107", "Volta\ Redonda\ \-\ RJ",
"55623534", "Goiânia\ \-\ GO",
"55113594", "São\ Paulo\ \-\ SP",
"5511589", "São\ Paulo\ \-\ SP",
"55753339", "Souto\ Soares\ \-\ BA",
"55553329", "Entre\ Ijuís\ \-\ RS",
"55114000", "Arujá\ \-\ SP",
"55643680", "Nazário\ \-\ GO",
"55313078", "Belo\ Horizonte\ \-\ MG",
"55193705", "Campinas\ \-\ SP",
"55853383", "Maracanaú\ \-\ CE",
"55443429", "Diamante\ do\ Norte\ \-\ PR",
"55383255", "Botumirim\ \-\ MG",
"55613677", "Planaltina\ \-\ GO",
"55473348", "Itajaí\ \-\ SC",
"55483033", "Palhoça\ \-\ SC",
"55893492", "Campo\ Alegre\ do\ Fidalgo\ \-\ PI",
"55513263", "Rio\ Grande\ do\ Sul",
"55193706", "Campinas\ \-\ SP",
"55613081", "Brasília\ \-\ DF",
"55223831", "Bom\ Jesus\ do\ Itabapoana\ \-\ RJ",
"55673412", "Douradina\ \-\ MS",
"55213274", "Rio\ de\ Janeiro\ \-\ RJ",
"55713204", "Salvador\ \-\ BA",
"55383647", "Formoso\ \-\ MG",
"55273533", "Vila\ Velha\ \-\ ES",
"55114132", "Pirapora\ do\ Bom\ Jesus\ \-\ SP",
"55613597", "Taguatinga\ \-\ DF",
"55163403", "Franca\ \-\ SP",
"55153557", "Itaóca\ \-\ SP",
"55833347", "Gado\ Bravo\ \-\ PB",
"55923582", "Manaus\ \-\ AM",
"55193802", "Holambra\ \-\ SP",
"55483443", "Criciúma\ \-\ SC",
"55183637", "Araçatuba\ \-\ SP",
"55114703", "Cotia\ \-\ SP",
"55115034", "São\ Paulo\ \-\ SP",
"55843354", "Encanto\ \-\ RN",
"55613301", "Brasília\ \-\ DF",
"55222565", "Bom\ Jardim\ \-\ RJ",
"55653345", "Poconé\ \-\ MT",
"55423272", "Telêmaco\ Borba\ \-\ PR",
"55553753", "São\ José\ das\ MissõEs\ \-\ RS",
"55543207", "São\ Brás\ \-\ RS",
"55653346", "Nortelândia\ \-\ MT",
"55222566", "Bom\ Jardim\ \-\ RJ",
"55813497", "Recife\ \-\ PE",
"55423122", "Ponta\ Grossa\ \-\ PR",
"55242292", "Petrópolis\ \-\ RJ",
"55643931", "Itumbiara\ \-\ GO",
"5515321", "Sorocaba\ \-\ SP",
"55773261", "Itapetinga\ \-\ BA",
"55313512", "Betim\ \-\ MG",
"55983361", "Axixá\ \-\ MA",
"55194003", "Campinas\ \-\ SP",
"55813472", "Recife\ \-\ PE",
"55112837", "São\ Paulo\ \-\ SP",
"55153431", "Itararé\ \-\ SP",
"55443902", "Paranavaí\ \-\ PR",
"55222222", "Nova\ Friburgo\ \-\ RJ",
"55513234", "Rio\ Grande\ do\ Sul",
"55273326", "Vila\ Velha\ \-\ ES",
"55273325", "Vitória\ \-\ ES",
"55553528", "Campo\ Novo\ \-\ RS",
"55353441", "Ouro\ Fino\ \-\ MG",
"55213763", "Mesquita\ \-\ RJ",
"55153653", "Capão\ Bonito\ \-\ SP",
"55123633", "Taubaté\ \-\ SP",
"55383543", "Gouveia\ \-\ MG",
"55353291", "Alfenas\ \-\ MG",
"55513774", "Ilópolis\ \-\ RS",
"55643071", "Rio\ Verde\ \-\ GO",
"55423447", "São\ João\ do\ Triunfo\ \-\ PR",
"55343088", "Uberlândia\ \-\ MG",
"55883419", "Arneiroz\ \-\ CE",
"55214118", "Rio\ de\ Janeiro\ \-\ RJ",
"55114007", "São\ Paulo\ \-\ SP",
"55673234", "Corumbá\ \-\ MS",
"55733202", "Barra\ do\ Rocha\ \-\ BA",
"55643687", "Córrego\ do\ Ouro\ \-\ GO",
"55853022", "Fortaleza\ \-\ CE",
"55143261", "Agudos\ \-\ SP",
"55112687", "São\ Paulo\ \-\ SP",
"55114164", "Carapicuíba\ \-\ SP",
"55153311", "Sorocaba\ \-\ SP",
"55753217", "Santo\ Amaro\ \-\ BA",
"55212704", "Niterói\ \-\ RJ",
"55713083", "Salvador\ \-\ BA",
"55493330", "Chapecó\ \-\ SC",
"55843253", "Bom\ Jesus\ \-\ RN",
"55242442", "Barra\ do\ Piraí\ \-\ RJ",
"55115062", "São\ Paulo\ \-\ SP",
"55133592", "Praia\ Grande\ \-\ SP",
"55153388", "Sorocaba\ \-\ SP",
"55673413", "Panambi\ \-\ MS",
"55993522", "Tuntum\ \-\ MA",
"55433232", "Sertanópolis\ \-\ PR",
"55143766", "Arandu\ \-\ SP",
"55473081", "Balneário\ Camboriú\ \-\ SC",
"55793635", "Lagarto\ \-\ SE",
"55183981", "Mirante\ do\ Paranapanema\ \-\ SP",
"55663528", "Luciára\ \-\ MT",
"55893493", "Acauã\ \-\ PI",
"55114806", "Jundiaí\ \-\ SP",
"5561320", "Brasília\ \-\ DF",
"55183918", "Presidente\ Prudente\ \-\ SP",
"55114805", "Jundiaí\ \-\ SP",
"55753269", "Riachão\ do\ Jacuípe\ \-\ BA",
"55853382", "Maracanaú\ \-\ CE",
"55143765", "Águas\ de\ Santa\ Bárbara\ \-\ SP",
"55473018", "Gaspar\ \-\ SC",
"55453541", "Santa\ Terezinha\ de\ Itaipu\ \-\ PR",
"55973453", "Boca\ do\ Acre\ \-\ AM",
"55343328", "Campo\ Florido\ \-\ MG",
"55733084", "Ilhéus\ \-\ BA",
"55183325", "Assis\ \-\ SP",
"55113820", "Guarulhos\ \-\ SP",
"55833474", "Maturéia\ \-\ PB",
"55553752", "Ametista\ do\ Sul\ \-\ RS",
"55353624", "Delfim\ Moreira\ \-\ MG",
"55692181", "Porto\ Velho\ \-\ RO",
"55423273", "Telêmaco\ Borba\ \-\ PR",
"55634003", "Palmas\ \-\ TO",
"55123664", "Campos\ do\ Jordão\ \-\ SP",
"55473301", "Indaial\ \-\ SC",
"55163515", "Ribeirão\ Preto\ \-\ SP",
"55983358", "Penalva\ \-\ MA",
"55983683", "Satubinha\ \-\ MA",
"55114702", "Cotia\ \-\ SP",
"55823314", "Maceió\ \-\ AL",
"55553541", "Santo\ Cristo\ \-\ RS",
"55483442", "Criciúma\ \-\ SC",
"55813655", "São\ Vicente\ Ferrer\ \-\ PE",
"55143376", "Sodrélia\ \-\ SP",
"55193803", "Sumaré\ \-\ SP",
"55493626", "Bandeirante\ \-\ SC",
"55813656", "Orobó\ \-\ PE",
"55143375", "Espírito\ Santo\ do\ Turvo\ \-\ SP",
"55493625", "Belmonte\ \-\ SC",
"55733222", "Ilhéus\ \-\ BA",
"55283518", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55114027", "Salto\ \-\ SP",
"5521387", "Rio\ de\ Janeiro\ \-\ RJ",
"55114133", "Barueri\ \-\ SP",
"55333514", "Malacacheta\ \-\ MG",
"55833399", "Massaranduba\ \-\ PB",
"5514323", "Bauru\ \-\ SP",
"55942101", "Marabá\ \-\ PA",
"55484106", "Florianópolis\ \-\ SC",
"55893555", "Arraial\ \-\ PI",
"55373247", "Igaratinga\ \-\ MG",
"55863291", "Jardim\ do\ Mulato\ \-\ PI",
"55813473", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55194002", "Campinas\ \-\ SP",
"55663508", "Santo\ Antônio\ Fontoura\ \-\ MT",
"5561322", "Brasília\ \-\ DF",
"55114826", "Rio\ Grande\ da\ Serra\ \-\ SP",
"55613573", "Brasília\ \-\ DF",
"55143411", "Jaú\ \-\ SP",
"55433334", "Londrina\ \-\ PR",
"55192106", "Piracicaba\ \-\ SP",
"55993627", "Bacabal\ \-\ MA",
"55192105", "Piracicaba\ \-\ SP",
"55143488", "Quintana\ \-\ SP",
"55733236", "Una\ \-\ BA",
"55163847", "Nuporanga\ \-\ SP",
"55343855", "Rio\ Paranaíba\ \-\ MG",
"55193871", "Valinhos\ \-\ SP",
"55854102", "Fortaleza\ \-\ CE",
"55193977", "Artur\ Nogueira\ \-\ SP",
"55343856", "Arapuá\ \-\ MG",
"55553328", "Fortaleza\ dos\ Valos\ \-\ RS",
"55513637", "Feliz\ \-\ RS",
"55222101", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55473349", "Itajaí\ \-\ SC",
"55493632", "Tunápolis\ \-\ SC",
"55163941", "Ribeirão\ Preto\ \-\ SP",
"55443428", "Graciosa\ \-\ PR",
"55173567", "Paraíso\ \-\ SP",
"55113585", "São\ Paulo\ \-\ SP",
"5511592", "São\ Paulo\ \-\ SP",
"55623363", "Porangatu\ \-\ GO",
"55443624", "Umuarama\ \-\ PR",
"55193374", "Piracicaba\ \-\ SP",
"55713627", "Camaçari\ \-\ BA",
"55753338", "Mucugê\ \-\ BA",
"55623093", "Goiânia\ \-\ GO",
"55473390", "Itajaí\ \-\ SC",
"55963116", "Santana\ \-\ AP",
"55953212", "Boa\ Vista\ \-\ RR",
"55773450", "Barra\ da\ Estiva\ \-\ BA",
"55313312", "Belo\ Horizonte\ \-\ MG",
"55883539", "Baixio\ \-\ CE",
"55473373", "Guaramirim\ \-\ SC",
"55613501", "Planaltina\ \-\ DF",
"55373421", "Luz\ \-\ MG",
"55643658", "São\ Simão\ \-\ GO",
"55273262", "Guarapari\ \-\ ES",
"55633447", "São\ Miguel\ do\ Tocantins\ \-\ TO",
"5575", "Bahia",
"55313464", "Belo\ Horizonte\ \-\ MG",
"55773695", "Tanque\ Novo\ \-\ BA",
"55753251", "Itaberaba\ \-\ BA",
"55273333", "Vitória\ \-\ ES",
"55433619", "Ibaiti\ \-\ PR",
"55773489", "Cocos\ \-\ BA",
"55613397", "Taguatinga\ \-\ DF",
"55193499", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55142104", "Jaú\ \-\ SP",
"55833547", "Vieirópolis\ \-\ PB",
"55112658", "Poá\ \-\ SP",
"55323347", "Ibertioga\ \-\ MG",
"55133034", "Praia\ Grande\ \-\ SP",
"55643454", "Caldas\ Novas\ \-\ GO",
"55543291", "São\ Marcos\ \-\ RS",
"55913636", "Limoeiro\ do\ Ajuru\ \-\ PA",
"55484020", "Florianópolis\ \-\ SC",
"55623937", "Anápolis\ \-\ GO",
"55913783", "Breves\ \-\ PA",
"55173662", "Santa\ Salete\ \-\ SP",
"55333434", "São\ Pedro\ do\ Suaçuí\ \-\ MG",
"55613274", "Brasília\ \-\ DF",
"55693621", "São\ Francisco\ do\ Guaporé\ \-\ RO",
"55433176", "Rolândia\ \-\ PR",
"55413158", "Campina\ Grande\ do\ Sul\ \-\ PR",
"55423221", "Telêmaco\ Borba\ \-\ PR",
"55114735", "Mogi\ das\ Cruzes\ \-\ SP",
"55193030", "Vinhedo\ \-\ SP",
"55433562", "Sertaneja\ \-\ PR",
"55493537", "Treze\ Tílias\ \-\ SC",
"55114683", "Juquitiba\ \-\ SP",
"55143457", "Oscar\ Bressane\ \-\ SP",
"55623334", "Petrolina\ de\ Goiás\ \-\ GO",
"55553308", "Ijuí\ \-\ RS",
"55683237", "Plácido\ de\ Castro\ \-\ AC",
"55114736", "Mogi\ das\ Cruzes\ \-\ SP",
"55213824", "Rio\ de\ Janeiro\ \-\ RJ",
"55483478", "Criciúma\ \-\ SC",
"55283560", "Alegre\ \-\ ES",
"55313433", "Belo\ Horizonte\ \-\ MG",
"55333213", "Governador\ Valadares\ \-\ MG",
"5592363", "Manaus\ \-\ AM",
"55493451", "Paial\ \-\ SC",
"55983387", "Palmeirândia\ \-\ MA",
"5588", "Ceará",
"55113443", "São\ Paulo\ \-\ SP",
"55413637", "Bugre\ \-\ PR",
"55743634", "Caldeirão\ Grande\ \-\ BA",
"55833642", "Santa\ Cecília\ \-\ PB",
"55993535", "Pequiá\ \-\ MA",
"55613521", "Brasília\ \-\ DF",
"55183263", "Santo\ Anastácio\ \-\ SP",
"55833051", "Campina\ Grande\ \-\ PB",
"55993536", "Governador\ Edison\ Lobão\ \-\ MA",
"55483025", "Florianópolis\ \-\ SC",
"5511441", "Atibaia\ \-\ SP",
"55273364", "Guarapari\ \-\ ES",
"55473372", "Jaraguá\ do\ Sul\ \-\ SC",
"55513564", "Dois\ Irmãos\ \-\ RS",
"55433534", "Santo\ Antônio\ da\ Platina\ \-\ PR",
"55643661", "Mineiros\ \-\ GO",
"55913087", "Belém\ \-\ PA",
"55623092", "Goiânia\ \-\ GO",
"55623362", "Porangatu\ \-\ GO",
"55112707", "São\ Paulo\ \-\ SP",
"55753268", "Teofilândia\ \-\ BA",
"55633685", "Combinado\ \-\ TO",
"55313651", "Caeté\ \-\ MG",
"55193447", "Piracicaba\ \-\ SP",
"55493633", "Santa\ Helena\ \-\ SC",
"55463546", "Nova\ Esperança\ do\ Sudoeste\ \-\ PR",
"55633440", "Fortaleza\ do\ Tabocão\ \-\ TO",
"55143287", "Avaí\ \-\ SP",
"55112661", "São\ Paulo\ \-\ SP",
"55173634", "Urânia\ \-\ SP",
"5511433", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55922127", "Manaus\ \-\ AM",
"55663529", "Querência\ \-\ MT",
"55463545", "Nova\ Prata\ do\ Iguaçu\ \-\ PR",
"55873939", "Flores\ \-\ PE",
"55773457", "Riacho\ de\ Santana\ \-\ BA",
"55443441", "Terra\ Rica\ \-\ PR",
"55114275", "Mairiporã\ \-\ SP",
"55183861", "Irapuru\ \-\ SP",
"55323017", "Juiz\ de\ Fora\ \-\ MG",
"55484007", "Florianópolis\ \-\ SC",
"55113120", "São\ Paulo\ \-\ SP",
"55883614", "Sobral\ \-\ CE",
"55473397", "Gaspar\ \-\ SC",
"55633374", "Figueirópolis\ \-\ TO",
"5531381", "Minas\ Gerais",
"55273332", "Vitória\ \-\ ES",
"55333314", "Ipanema\ \-\ MG",
"55433660", "Lupionópolis\ \-\ PR",
"55883418", "Jaguaruana\ \-\ CE",
"55463252", "Clevelândia\ \-\ PR",
"55513630", "Rio\ Grande\ do\ Sul",
"55273263", "Santa\ Maria\ de\ Jetibá\ \-\ ES",
"55993571", "Porto\ Franco\ \-\ MA",
"55543031", "Canela\ \-\ RS",
"55743662", "Barra\ \-\ BA",
"55163315", "Ribeirão\ Preto\ \-\ SP",
"55473501", "Jaraguá\ do\ Sul\ \-\ SC",
"55353409", "Lavras\ \-\ MG",
"55733271", "Iguaí\ \-\ BA",
"55212765", "Nova\ Iguaçu\ \-\ RJ",
"55543441", "Veranópolis\ \-\ RS",
"55143489", "Iacri\ \-\ SP",
"55133377", "Cubatão\ \-\ SP",
"55193836", "Vinhedo\ \-\ SP",
"55813448", "Recife\ \-\ PE",
"55114682", "Juquitiba\ \-\ SP",
"55433563", "Tomazina\ \-\ PR",
"55193835", "Indaiatuba\ \-\ SP",
"55473274", "Jaraguá\ do\ Sul\ \-\ SC",
"55173663", "Santa\ Clara\ D\'Oeste\ \-\ SP",
"55432101", "Londrina\ \-\ PR",
"55663328", "Planalto\ da\ Serra\ \-\ MT",
"55833398", "Itatuba\ \-\ PB",
"55813644", "Cumaru\ \-\ PE",
"55493664", "Maravilha\ \-\ SC",
"5519352", "Rio\ Claro\ \-\ SP",
"55153511", "Itapetininga\ \-\ SP",
"5511362", "São\ Paulo\ \-\ SP",
"55893544", "Uruçuí\ \-\ PI",
"55183262", "Presidente\ Bernardes\ \-\ SP",
"55753614", "Feira\ de\ Santana\ \-\ BA",
"55193123", "Campinas\ \-\ SP",
"55114091", "Diadema\ \-\ SP",
"55473521", "Rio\ do\ Sul\ \-\ SC",
"5511263", "São\ Paulo\ \-\ SP",
"55112284", "Osasco\ \-\ SP",
"55313939", "Conselheiro\ Lafaiete\ \-\ MG",
"55133392", "Guarujá\ \-\ SP",
"55753418", "Alagoinhas\ \-\ BA",
"55113442", "São\ Paulo\ \-\ SP",
"55983359", "São\ João\ Batista\ \-\ MA",
"55213693", "Paracambi\ \-\ RJ",
"55223205", "Saquarema\ \-\ RJ",
"55333212", "Governador\ Valadares\ \-\ MG",
"55313432", "Belo\ Horizonte\ \-\ MG",
"55123962", "Jacareí\ \-\ SP",
"55713797", "Salvador\ \-\ BA",
"55793319", "Gracho\ Cardoso\ \-\ SE",
"5532321", "Juiz\ de\ Fora\ \-\ MG",
"55773221", "Itapetinga\ \-\ BA",
"55743636", "Caém\ \-\ BA",
"55193765", "Campinas\ \-\ SP",
"55623523", "Goiânia\ \-\ GO",
"55213826", "Rio\ de\ Janeiro\ \-\ RJ",
"55743635", "Tapiramutá\ \-\ BA",
"55713264", "Salvador\ \-\ BA",
"55114373", "São\ Paulo\ \-\ SP",
"55433302", "Londrina\ \-\ PR",
"55353451", "Silvianópolis\ \-\ MG",
"55643593", "Itumbiara\ \-\ GO",
"55993534", "Davinópolis\ \-\ MA",
"55433224", "Santo\ Antônio\ do\ Paraíso\ \-\ PR",
"55313711", "Prudente\ de\ Morais\ \-\ MG",
"55134102", "Guarujá\ \-\ SP",
"55414001", "Curitiba\ \-\ PR",
"55543625", "Capão\ Bonito\ do\ Sul\ \-\ RS",
"55823423", "Igaci\ \-\ AL",
"55483024", "Florianópolis\ \-\ SC",
"55643570", "Claudinápolis\ \-\ GO",
"55712203", "Salvador\ \-\ BA",
"55114349", "São\ Paulo\ \-\ SP",
"55673565", "Aparecida\ do\ Taboado\ \-\ MS",
"55243370", "Angra\ dos\ Reis\ \-\ RJ",
"55533204", "Rio\ Grande\ \-\ RS",
"55333436", "Rio\ Vermelho\ \-\ MG",
"55313216", "Minas\ Gerais",
"55353537", "Fortaleza\ de\ Minas\ \-\ MG",
"55673907", "Corumbá\ \-\ MS",
"55213133", "Rio\ de\ Janeiro\ \-\ RJ",
"55433174", "Cambé\ \-\ PR",
"55133445", "Mongaguá\ \-\ SP",
"55733263", "Teixeira\ de\ Freitas\ \-\ BA",
"55133446", "Mongaguá\ \-\ SP",
"55753420", "Entre\ Rios\ \-\ BA",
"55153547", "Guapiara\ \-\ SP",
"55833357", "São\ Domingos\ do\ Cariri\ \-\ PB",
"5522382", "Itaperuna\ \-\ RJ",
"55613275", "Brasília\ \-\ DF",
"55433571", "Siqueira\ Campos\ \-\ PR",
"55313215", "Minas\ Gerais",
"55333435", "Coluna\ \-\ MG",
"55623336", "Alexânia\ \-\ GO",
"55443219", "Maringá\ \-\ PR",
"55553743", "Jaboticaba\ \-\ RS",
"55653356", "Rosário\ Oeste\ \-\ MT",
"55553430", "São\ Borja\ \-\ RS",
"55113395", "Jundiaí\ \-\ SP",
"55883400", "Limoeiro\ do\ Norte\ \-\ CE",
"55623335", "Vianópolis\ \-\ GO",
"55123893", "São\ Sebastião\ \-\ SP",
"55163434", "Ribeirão\ Preto\ \-\ SP",
"55992101", "Imperatriz\ \-\ MA",
"55313466", "Belo\ Horizonte\ \-\ MG",
"55654009", "Cuiabá\ \-\ MT",
"55843555", "Pedra\ Grande\ \-\ RN",
"55712223", "Salvador\ \-\ BA",
"55193684", "São\ José\ do\ Rio\ Pardo\ \-\ SP",
"55142105", "Marília\ \-\ SP",
"55773498", "Formoso\ A\ \-\ BA",
"55623503", "Abadia\ de\ Goiás\ \-\ GO",
"55553369", "São\ Pedro\ do\ Butiá\ \-\ RS",
"55773201", "Vitória\ da\ Conquista\ \-\ BA",
"55964141", "Macapá\ \-\ AP",
"55873788", "Angelim\ \-\ PE",
"55193488", "Mombuca\ \-\ SP",
"55543330", "Carazinho\ \-\ RS",
"55133036", "Santos\ \-\ SP",
"55663437", "Campinápolis\ \-\ MT",
"55643455", "Caldas\ Novas\ \-\ GO",
"5551357", "Rio\ Grande\ do\ Sul",
"55473358", "Witmarsum\ \-\ SC",
"55993563", "Aldeias\ Altas\ \-\ MA",
"55142106", "Bauru\ \-\ SP",
"55213806", "Rio\ de\ Janeiro\ \-\ RJ",
"55273776", "Barra\ de\ São\ Francisco\ \-\ ES",
"55893482", "Simplício\ Mendes\ \-\ PI",
"55953198", "Boa\ Vista\ \-\ RR",
"55613361", "Guará\ \-\ DF",
"55383741", "Pirapora\ \-\ MG",
"55663551", "Nova\ Canaã\ do\ Norte\ \-\ MT",
"55733234", "Ilhéus\ \-\ BA",
"55713414", "Salvador\ \-\ BA",
"55843242", "Arês\ \-\ RN",
"55242453", "Valença\ \-\ RJ",
"55673202", "Campo\ Grande\ \-\ MS",
"55883420", "São\ João\ do\ Jaguaribe\ \-\ CE",
"55553317", "Santa\ Maria\ \-\ RS",
"55923672", "Manaus\ \-\ AM",
"55543267", "Vila\ Seca\ \-\ RS",
"55163463", "Araraquara\ \-\ SP",
"55343351", "Sacramento\ \-\ MG",
"55643649", "Castelândia\ \-\ GO",
"553131", "Minas\ Gerais",
"55193375", "Piracicaba\ \-\ SP",
"55443625", "Perobal\ \-\ PR",
"55514001", "Porto\ Alegre\ \-\ RS",
"5564392", "Itumbiara\ \-\ GO",
"55113584", "São\ Paulo\ \-\ SP",
"55483282", "Florianópolis\ \-\ SC",
"55533224", "Morro\ Redondo\ \-\ RS",
"55212103", "Rio\ de\ Janeiro\ \-\ RJ",
"55443626", "Umuarama\ \-\ PR",
"55193862", "Mogi\ Mirim\ \-\ SP",
"55473231", "Blumenau\ \-\ SC",
"55693582", "Cujubim\ \-\ RO",
"55713681", "Vera\ Cruz\ \-\ BA",
"55753616", "Feira\ de\ Santana\ \-\ BA",
"55823422", "Cacimbinhas\ \-\ AL",
"55123971", "São\ Bento\ do\ Sapucaí\ \-\ SP",
"55114019", "Itu\ \-\ SP",
"55674001", "Campo\ Grande\ \-\ MS",
"55153115", "Boituva\ \-\ SP",
"55433303", "Arapongas\ \-\ PR",
"55893546", "Bertolínia\ \-\ PI",
"55613559", "Samambaia\ Sul\ \-\ DF",
"55813459", "Aldeia\ \-\ PE",
"55112592", "São\ Paulo\ \-\ SP",
"55693446", "Primavera\ de\ Rondônia\ \-\ RO",
"55753427", "Esplanada\ \-\ BA",
"55623607", "Goiânia\ \-\ GO",
"55733526", "Jequié\ \-\ BA",
"55833350", "Ouro\ Velho\ \-\ PB",
"55623522", "Goiânia\ \-\ GO",
"55733525", "Jequié\ \-\ BA",
"55993667", "Governador\ Archer\ \-\ MA",
"55183271", "Presidente\ Venceslau\ \-\ SP",
"55273235", "Vitória\ \-\ ES",
"55213020", "Rio\ de\ Janeiro\ \-\ RJ",
"55693445", "São\ Felipe\ do\ Oeste\ \-\ RO",
"55123892", "São\ Sebastião\ \-\ SP",
"55243377", "Angra\ dos\ Reis\ \-\ RJ",
"55143201", "Bauru\ \-\ SP",
"55114104", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55553742", "Palmeira\ das\ Missões\ \-\ RS",
"55353664", "Conceição\ das\ Pedras\ \-\ MG",
"55193834", "Indaiatuba\ \-\ SP",
"55943335", "Itinga\ do\ Maranhão\ \-\ PA",
"55453239", "Juvinópolis\ \-\ PR",
"55473275", "Jaraguá\ do\ Sul\ \-\ SC",
"55863281", "Milton\ Brandão\ \-\ PI",
"55813646", "Tracunhaém\ \-\ PE",
"55112781", "São\ Paulo\ \-\ SP",
"55423259", "Ventania\ \-\ PR",
"55843477", "Ouro\ Branco\ \-\ RN",
"55833389", "Olivedos\ \-\ PB",
"55733262", "Eunápolis\ \-\ BA",
"55114067", "Diadema\ \-\ SP",
"55553551", "Tenente\ Portela\ \-\ RS",
"55493665", "Iraceminha\ \-\ SC",
"55813645", "Feira\ Nova\ \-\ PE",
"55413907", "Curitiba\ \-\ PR",
"55933537", "Mujuí\ dos\ Campos\ \-\ PA",
"55993562", "Gonçalves\ Dias\ \-\ MA",
"55613358", "Samambaia\ Sul\ \-\ DF",
"55633376", "Barrolândia\ \-\ TO",
"55663568", "São\ José\ do\ Xingu\ \-\ MT",
"55333316", "Pocrane\ \-\ MG",
"55333315", "Inhapim\ \-\ MG",
"5577308", "Vitória\ da\ Conquista\ \-\ BA",
"55163811", "São\ Joaquim\ da\ Barra\ \-\ SP",
"55633375", "Pindorama\ do\ Tocantins\ \-\ TO",
"55383728", "Angueretá\ \-\ MG",
"55623502", "Bela\ Vista\ de\ Goiás\ \-\ GO",
"55483631", "Tubarão\ \-\ SC",
"55133296", "Santos\ \-\ SP",
"55543260", "Caravaggio\ \-\ RS",
"55643697", "Davinópolis\ \-\ GO",
"55883427", "Boa\ Viagem\ \-\ CE",
"55853377", "Itaitinga\ \-\ CE",
"55312111", "Belo\ Horizonte\ \-\ MG",
"55183366", "Quatá\ \-\ SP",
"55183872", "Ouro\ Verde\ \-\ SP",
"55133295", "Santos\ \-\ SP",
"55353281", "Cristina\ \-\ MG",
"55693583", "Quinto\ Bec\ \-\ RO",
"55193863", "Itapira\ \-\ SP",
"55433535", "Jaguariaíva\ \-\ PR",
"55843279", "Extremoz\ \-\ RN",
"55513565", "Nova\ Hartz\ \-\ RS",
"55114762", "Mogi\ das\ Cruzes\ \-\ SP",
"55543337", "Estação\ \-\ RS",
"55212685", "Mangaratiba\ \-\ RJ",
"55513566", "São\ Leopoldo\ \-\ RS",
"55423457", "Rebouças\ \-\ PR",
"55483283", "Palhoça\ \-\ SC",
"55433536", "Ribeirão\ Claro\ \-\ PR",
"55633488", "Praia\ Norte\ \-\ TO",
"55492049", "Chapecó\ \-\ SC",
"55623371", "Goiás\ \-\ GO",
"55173636", "Dolcinópolis\ \-\ SP",
"5531347", "Belo\ Horizonte\ \-\ MG",
"55143221", "Marília\ \-\ SP",
"55923673", "Manaus\ \-\ AM",
"55323311", "Juiz\ de\ Fora\ \-\ MG",
"55242452", "Valença\ \-\ RJ",
"55843243", "Goianinha\ \-\ RN",
"55913662", "Terra\ Alta\ \-\ PA",
"55463544", "Enéas\ Marques\ \-\ PR",
"55473361", "Balneário\ Camboriú\ \-\ SC",
"5598322", "São\ Luís\ \-\ MA",
"55183991", "Mirante\ do\ Paranapanema\ \-\ SP",
"55343612", "Araxá\ \-\ MG",
"55833511", "Patos\ \-\ PB",
"55123604", "Pindamonhangaba\ \-\ SP",
"55893483", "São\ João\ do\ Piauí\ \-\ PI",
"55173635", "Aparecida\ D\'Oeste\ \-\ SP",
"55643672", "Mineiros\ \-\ GO",
"55863260", "Demerval\ Lobão\ \-\ PI",
"55283520", "Piúma\ \-\ ES",
"55115931", "São\ Paulo\ \-\ SP",
"55193575", "Itirapina\ \-\ SP",
"55113384", "São\ Paulo\ \-\ SP",
"55222630", "Cabo\ Frio\ \-\ RJ",
"55472102", "Blumenau\ \-\ SC",
"55543468", "Pinto\ Bandeira\ \-\ RS",
"55313750", "Minas\ Gerais",
"55493441", "Concórdia\ \-\ SC",
"55193576", "Ipeúna\ \-\ SP",
"55713225", "Feira\ de\ Santana\ \-\ BA",
"55114693", "Guararema\ \-\ SP",
"55443218", "Maringá\ \-\ PR",
"55143103", "Bauru\ \-\ SP",
"55613561", "Taguatinga\ \-\ DF",
"55983372", "Santo\ Antônio\ dos\ Lopes\ \-\ MA",
"55433265", "São\ Sebastião\ da\ Amoreira\ \-\ PR",
"55433266", "Nova\ Santa\ Bárbara\ \-\ PR",
"55143732", "Avaré\ \-\ SP",
"55183223", "Presidente\ Prudente\ \-\ SP",
"55673524", "Três\ Lagoas\ \-\ MS",
"5511518", "São\ Paulo\ \-\ SP",
"55513236", "Rio\ Grande\ do\ Sul",
"55943787", "Tucuruí\ \-\ PA",
"55483065", "Florianópolis\ \-\ SC",
"55273324", "Vitória\ \-\ ES",
"55623303", "Montes\ Claros\ de\ Goiás\ \-\ GO",
"55273084", "Vitória\ \-\ ES",
"55133383", "Guarujá\ \-\ SP",
"55373288", "Araújos\ \-\ MG",
"55173622", "Jales\ \-\ SP",
"55513731", "Rio\ Pardo\ \-\ RS",
"55222564", "Trajano\ de\ Morais\ \-\ RJ",
"55653344", "Jangada\ \-\ MT",
"55843355", "Venha\-Ver\ \-\ RN",
"55713176", "Salvador\ \-\ BA",
"55843356", "Doutor\ Severiano\ \-\ RN",
"55443633", "São\ João\ \-\ PR",
"55793318", "Monte\ Alegre\ de\ Sergipe\ \-\ SE",
"55983397", "Turiaçu\ \-\ MA",
"55983274", "Paço\ do\ Lumiar\ \-\ MA",
"55463243", "Mangueirinha\ \-\ PR",
"55623536", "Goiânia\ \-\ GO",
"55113596", "São\ Paulo\ \-\ SP",
"55553612", "Dilermando\ de\ Aguiar\ \-\ RS",
"55633457", "Colméia\ \-\ TO",
"55643648", "Itajá\ \-\ GO",
"55313424", "Belo\ Horizonte\ \-\ MG",
"55273222", "Vitória\ \-\ ES",
"55113595", "São\ Paulo\ \-\ SP",
"55623535", "Santo\ Antônio\ de\ Goiás\ \-\ GO",
"55213833", "Rio\ de\ Janeiro\ \-\ RJ",
"55733532", "Itamari\ \-\ BA",
"55643444", "Buriti\ Alegre\ \-\ GO",
"55424063", "Ponta\ Grossa\ \-\ PR",
"55383254", "Itacambira\ \-\ MG",
"55313628", "Ribeirão\ das\ Neves\ \-\ MG",
"55193704", "Limeira\ \-\ SP",
"55323357", "Coronel\ Xavier\ Chaves\ \-\ MG",
"55613027", "Taguatinga\ \-\ DF",
"55713205", "Salvador\ \-\ BA",
"55753241", "Santo\ Amaro\ \-\ BA",
"55613702", "Brasília\ \-\ DF",
"55472122", "Balneário\ Camboriú\ \-\ SC",
"55473359", "Botuverá\ \-\ SC",
"55413873", "Campina\ Grande\ do\ Sul\ \-\ PR",
"55163951", "Cravinhos\ \-\ SP",
"55333423", "Sabinópolis\ \-\ MG",
"55343846", "Douradoquara\ \-\ MG",
"55543281", "Nova\ Petrópolis\ \-\ RS",
"55343845", "Iraí\ de\ Minas\ \-\ MG",
"55873789", "Brejão\ \-\ PE",
"55833431", "Pombal\ \-\ PB",
"55773499", "Sussuarana\ \-\ BA",
"55613387", "Sobradinho\ \-\ DF",
"55433627", "Leópolis\ \-\ PR",
"55212136", "Rio\ de\ Janeiro\ \-\ RJ",
"55773440", "Piripá\ \-\ BA",
"55193695", "Mococa\ \-\ SP",
"55533265", "Chuí\ \-\ RS",
"55143273", "Fernão\ \-\ SP",
"55623323", "Ceres\ \-\ GO",
"55633531", "Divinópolis\ do\ Tocantins\ \-\ TO",
"55443664", "Alto\ Paraíso\ \-\ PR",
"55713667", "Mata\ de\ São\ João\ \-\ BA",
"55773686", "Serra\ Dourada\ \-\ BA",
"55943322", "Marabá\ \-\ PA",
"55663510", "Juara\ \-\ MT",
"5511422", "São\ Caetano\ do\ Sul\ \-\ SP",
"55222533", "Nova\ Friburgo\ \-\ RJ",
"55114573", "Cotia\ \-\ SP",
"55983521", "Caxias\ \-\ MA",
"55112719", "São\ Paulo\ \-\ SP",
"55863219", "Teresina\ \-\ PI",
"55323511", "Muriaé\ \-\ MG",
"55833388", "Seridó\ \-\ PB",
"5521341", "Rio\ de\ Janeiro\ \-\ RJ",
"55183222", "Presidente\ Prudente\ \-\ SP",
"55743527", "Casa\ Nova\ \-\ BA",
"55143733", "Avaré\ \-\ SP",
"5511366", "São\ Paulo\ \-\ SP",
"55453238", "Ibema\ \-\ PR",
"55983373", "Maracaçumé\ \-\ MA",
"55893554", "São\ José\ do\ Peixe\ \-\ PI",
"55143102", "Bauru\ \-\ SP",
"5522272", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55114692", "Biritiba\-Mirim\ \-\ SP",
"55472103", "Itajaí\ \-\ SC",
"55983349", "Barreirinhas\ \-\ MA",
"55543537", "Caxias\ do\ Sul\ \-\ RS",
"55533503", "Bagé\ \-\ RS",
"55653492", "Ouro\ Branco\ \(Antiga\ Raposolândia\)\ \-\ MT",
"55433336", "Londrina\ \-\ PR",
"55192104", "Campinas\ \-\ SP",
"55353626", "Wenceslau\ Braz\ \-\ MG",
"55163111", "Franca\ \-\ SP",
"55123666", "Santo\ Antônio\ do\ Pinhal\ \-\ SP",
"55913184", "Belém\ \-\ PA",
"55753208", "Campinhos\ \-\ BA",
"55913777", "Ponta\ de\ Pedras\ \-\ PA",
"55324141", "Juiz\ de\ Fora\ \-\ MG",
"55753491", "Feira\ de\ Santana\ \-\ BA",
"55443632", "Xambrê\ \-\ PR",
"55213736", "Rio\ de\ Janeiro\ \-\ RJ",
"55543451", "Bento\ Gonçalves\ \-\ RS",
"55163514", "Ribeirão\ Preto\ \-\ SP",
"5562400", "Goiânia\ \-\ GO",
"55433523", "Cornélio\ Procópio\ \-\ PR",
"5554302", "Caxias\ do\ Sul\ \-\ RS",
"55353625", "Marmelópolis\ \-\ MG",
"55643601", "São\ Luís\ de\ Montes\ Belos\ \-\ GO",
"55813654", "Salgadinho\ \-\ PE",
"55114081", "São\ Paulo\ \-\ SP",
"55333516", "Capelinha\ \-\ MG",
"55313757", "Itaverava\ \-\ MG",
"55133382", "Guarujá\ \-\ SP",
"55333515", "Água\ Boa\ \-\ MG",
"55683327", "Assis\ Brasil\ \(Vila\)\ \-\ AC",
"55114018", "Pinhalzinho\ \-\ SP",
"55863267", "Lagoa\ Alegre\ \-\ PI",
"55513101", "Alvorada\ \-\ RS",
"55623302", "Jussara\ \-\ GO",
"55493624", "Romelândia\ \-\ SC",
"55143374", "Caporanga\ \-\ SP",
"55143297", "Bairro\ de\ Santa\ Izabel\ \-\ SP",
"55663517", "Sinop\ \-\ MT",
"55472123", "Blumenau\ \-\ SC",
"55613703", "Brasília\ \-\ DF",
"55473702", "Blumenau\ \-\ SC",
"55543632", "Passo\ Fundo\ \-\ RS",
"55183821", "Dracena\ \-\ SP",
"55633696", "Novo\ Jardim\ \-\ TO",
"55743061", "Juazeiro\ \-\ BA",
"55114597", "Nazaré\ Paulista\ \-\ SP",
"55633695", "Novo\ Alegre\ \-\ TO",
"55553351", "Pirapó\ \-\ RS",
"55143764", "Iaras\ \-\ SP",
"55773447", "Cordeiros\ \-\ BA",
"55424062", "Ponta\ Grossa\ \-\ PR",
"5553327", "Pelotas\ \-\ RS",
"55613380", "Núcleo\ Bandeirante\ \-\ DF",
"55183324", "Assis\ \-\ SP",
"55733533", "Maracas\ \-\ BA",
"55973385", "Manicoré\ \-\ AM",
"55273223", "Vitória\ \-\ ES",
"55353267", "Paraguaçu\ \-\ MG",
"55643377", "Mossâmedes\ \-\ GO",
"55553613", "Mato\ Queimado\ \-\ RS",
"55743622", "Jacobina\ \-\ BA",
"55513271", "Novo\ Hamburgo\ \-\ RS",
"55733086", "Ilhéus\ \-\ BA",
"55463242", "Chopinzinho\ \-\ PR",
"55843278", "São\ Gonçalo\ do\ Amarante\ \-\ RN",
"55513775", "Pouso\ Novo\ \-\ RS",
"55513524", "Novo\ Hamburgo\ \-\ RS",
"55112392", "São\ Paulo\ \-\ SP",
"55673236", "Nioaque\ \-\ MS",
"55943323", "Marabá\ \-\ PA",
"55612030", "Brasília\ \-\ DF",
"55512131", "Porto\ Alegre\ \-\ RS",
"55643621", "Rio\ Verde\ \-\ GO",
"55513776", "Relvado\ \-\ RS",
"55383729", "Curvelo\ \-\ MG",
"55212705", "Niterói\ \-\ RJ",
"55463555", "Planalto\ \-\ PR",
"55473387", "Pomerode\ \-\ SC",
"55114165", "Itapecerica\ da\ Serra\ \-\ SP",
"55114166", "Barueri\ \-\ SP",
"55112621", "São\ Paulo\ \-\ SP",
"55193457", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55313641", "Santa\ Luzia\ \-\ MG",
"55663569", "Porto\ Alegre\ do\ Norte\ \-\ MT",
"55613359", "Samambaia\ Sul\ \-\ DF",
"55413096", "São\ José\ dos\ Pinhais\ \-\ PR",
"55443537", "Engenheiro\ Beltrão\ \-\ PR",
"55463556", "Pérola\ D\'Oeste\ \-\ PR",
"55323451", "Astolfo\ Dutra\ \-\ MG",
"55353431", "Cambuí\ \-\ MG",
"55993554", "Paraibano\ \-\ MA",
"55433477", "São\ João\ do\ Ivaí\ \-\ PR",
"55544141", "Caxias\ do\ Sul\ \-\ RS",
"55313827", "Minas\ Gerais",
"55953592", "Pacaraima\ \-\ RR",
"55313385", "Minas\ Gerais",
"55633351", "Gurupi\ \-\ TO",
"55743656", "Canarana\ \-\ BA",
"55474053", "Blumenau\ \-\ SC",
"55273768", "Boa\ Esperança\ \-\ ES",
"55643941", "Itumbiara\ \-\ GO",
"55113512", "São\ Paulo\ \-\ SP",
"55313386", "Minas\ Gerais",
"55483214", "São\ José\ \-\ SC",
"55743655", "Central\ \-\ BA",
"55513710", "Lajeado\ \-\ RS",
"55533243", "Dom\ Pedrito\ \-\ RS",
"55653336", "Diamantino\ \-\ MT",
"55813581", "Chã\ de\ Alegria\ \-\ PE",
"55623356", "Nova\ Veneza\ \-\ GO",
"55313026", "Sete\ Lagoas\ \-\ MG",
"55623355", "Itapuranga\ \-\ GO",
"55813518", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55543511", "Vacaria\ \-\ RS",
"55613614", "Novo\ Gama\ \-\ GO",
"55653335", "Agrovila\ das\ Palmeiras\ \-\ MT",
"55163383", "Matão\ \-\ SP",
"55483433", "Criciúma\ \-\ SC",
"55183647", "Glicério\ \-\ SP",
"55323537", "Paula\ Cândido\ \-\ MG",
"55453287", "Boa\ Vista\ da\ Aparecida\ \-\ PR",
"55115044", "São\ Paulo\ \-\ SP",
"55114142", "Itapevi\ \-\ SP",
"55443588", "Vidigal\ \-\ PR",
"55223841", "Natividade\ \-\ RJ",
"55933589", "Santarém\ \-\ PA",
"55183255", "Rancharia\ \-\ SP",
"55162107", "São\ Carlos\ \-\ SP",
"55173472", "Nhandeara\ \-\ SP",
"55483043", "Tubarão\ \-\ SC",
"55113426", "Diadema\ \-\ SP",
"55843535", "Jardim\ de\ Angicos\ \-\ RN",
"55512117", "Porto\ Alegre\ \-\ RS",
"55493347", "Coronel\ Freitas\ \-\ SC",
"55843536", "Pedra\ Preta\ \-\ RN",
"55853403", "Fortaleza\ \-\ CE",
"55113425", "Diadema\ \-\ SP",
"55883548", "Altaneira\ \-\ CE",
"55813319", "São\ Lourenço\ da\ Mata\ \-\ PE",
"55383532", "Diamantina\ \-\ MG",
"55483668", "Pinheiral\ \-\ SC",
"55115213", "São\ Paulo\ \-\ SP",
"55212752", "São\ João\ de\ Meriti\ \-\ RJ",
"55843323", "Mossoró\ \-\ RN",
"55473251", "Brusque\ \-\ SC",
"55543389", "Fontoura\ Xavier\ \-\ RS",
"55663531", "Sinop\ \-\ MT",
"5547", "Santa\ Catarina",
"55923198", "Manaus\ \-\ AM",
"55343834", "Guimarânia\ \-\ MG",
"55242433", "Barra\ do\ Piraí\ \-\ RJ",
"55733254", "Gandu\ \-\ BA",
"55143844", "Pratânia\ \-\ SP",
"55483464", "Lauro\ Muller\ \-\ SC",
"55193778", "Campinas\ \-\ SP",
"55643471", "Pontalina\ \-\ GO",
"55163707", "Franca\ \-\ SP",
"55343411", "Iturama\ \-\ MG",
"55113513", "São\ Paulo\ \-\ SP",
"55273256", "Aracruz\ \-\ ES",
"55913461", "Colares\ \-\ PA",
"55453280", "São\ Luiz\ D\'Oeste\ \-\ PR",
"55143529", "Lins\ \-\ SP",
"55273255", "Viana\ \-\ ES",
"55413698", "Almirante\ Tamandaré\ \-\ PR",
"55474052", "Blumenau\ \-\ SC",
"55433344", "Londrina\ \-\ PR",
"55753274", "Cansanção\ \-\ BA",
"55163661", "Batatais\ \-\ SP",
"55123116", "Bananal\ \-\ SP",
"55953593", "Amajari\ \-\ RR",
"5511454", "Mauá\ \-\ SP",
"55183699", "Lourdes\ \-\ SP",
"55143308", "Fartura\ \-\ SP",
"55452104", "Cascavel\ \-\ PR",
"55513717", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55633612", "Gurupi\ \-\ TO",
"55123115", "Arapeí\ \-\ SP",
"55124110", "Pindamonhangaba\ \-\ SP",
"55623998", "Goiânia\ \-\ GO",
"55513769", "Rio\ Grande\ do\ Sul",
"55913812", "Magalhães\ Barata\ \-\ PA",
"55843224", "Natal\ \-\ RN",
"55423239", "Ponta\ Grossa\ \-\ PR",
"55373073", "Itaúna\ \-\ MG",
"55114143", "Itapevi\ \-\ SP",
"55883501", "Juazeiro\ do\ Norte\ \-\ CE",
"55653266", "Pontes\ e\ Lacerda\ \-\ MT",
"55453259", "São\ José\ das\ Palmeiras\ \-\ PR",
"55413012", "Curitiba\ \-\ PR",
"55733688", "Piraí\ do\ Norte\ \-\ BA",
"55653265", "Conquista\ D\'Oeste\ \-\ MT",
"55473418", "Joinville\ \-\ SC",
"55193351", "Araras\ \-\ SP",
"55793257", "São\ Cristóvão\ \-\ SE",
"55314133", "Belo\ Horizonte\ \-\ MG",
"55483432", "Içara\ \-\ SC",
"55463523", "Francisco\ Beltrão\ \-\ PR",
"55313820", "Minas\ Gerais",
"55163382", "Matão\ \-\ SP",
"55383564", "Ruralminas\ I\ \-\ MG",
"55633368", "Pium\ \-\ TO",
"55943356", "Parauapebas\ \-\ PA",
"55112840", "Salto\ \-\ SP",
"55823294", "União\ dos\ Palmares\ \-\ AL",
"55273751", "Mucurici\ \-\ ES",
"55793113", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55153624", "Itapeva\ \-\ SP",
"55943355", "Marabá\ \-\ PA",
"55374101", "Itaúna\ \-\ MG",
"55833267", "Juarez\ Távora\ \-\ PB",
"55663575", "Peixoto\ de\ Azevedo\ \-\ MT",
"55533242", "Bagé\ \-\ RS",
"55833625", "Marcação\ \-\ PB",
"55553259", "Mata\ \-\ RS",
"55493678", "Itapiranga\ \-\ SC",
"55714116", "Dias\ d\'Ávila\ \-\ BA",
"55185841", "Junqueirópolis\ \-\ SP",
"55423551", "Santana\ \-\ PR",
"55323281", "Lima\ Duarte\ \-\ MG",
"55613338", "Brasília\ \-\ DF",
"55663489", "Ribeirão\ Cascalheira\ \-\ MT",
"55114209", "Barueri\ \-\ SP",
"55513379", "Rio\ Grande\ do\ Sul",
"55933557", "Faro\ \-\ PA",
"5531378", "Minas\ Gerais",
"55433242", "Bela\ Vista\ do\ Paraíso\ \-\ PR",
"55793645", "Boquim\ \-\ SE",
"55114427", "Santo\ André\ \-\ SP",
"55612328", "Brasília\ \-\ DF",
"55343261", "Ituiutaba\ \-\ MG",
"55653371", "Nova\ Mutum\ \-\ MT",
"55873948", "Bom\ Nome\ \-\ PE",
"5516363", "Ribeirão\ Preto\ \-\ SP",
"55993015", "Imperatriz\ \-\ MA",
"55753501", "Paulo\ Afonso\ \-\ BA",
"55114878", "Barueri\ \-\ SP",
"55833469", "Várzea\ \-\ PB",
"55223828", "Boaventura\ \-\ RJ",
"55843691", "Lajes\ Pintadas\ \-\ RN",
"5561", "Federal\ District",
"55513698", "Capela\ de\ Santana\ \-\ RS",
"55793459", "Pedra\ Mole\ \-\ SE",
"55213913", "Itaboraí\ \-\ RJ",
"55883521", "Crato\ \-\ CE",
"55353653", "Conceição\ dos\ Ouros\ \-\ MG",
"55513494", "Itapuã\ \-\ RS",
"55153291", "Araçoiaba\ da\ Serra\ \-\ SP",
"55433555", "Japira\ \-\ PR",
"55212753", "São\ João\ de\ Meriti\ \-\ RJ",
"55433556", "Abatiá\ \-\ PR",
"55115212", "São\ Paulo\ \-\ SP",
"55823621", "Santana\ do\ Ipanema\ \-\ AL",
"55383533", "Couto\ de\ Magalhães\ de\ Minas\ \-\ MG",
"55314007", "Belo\ Horizonte\ \-\ MG",
"55543357", "Camargo\ \-\ RS",
"55793288", "Areia\ Branca\ \-\ SE",
"5516396", "Ribeirão\ Preto\ \-\ SP",
"55513255", "Rio\ Grande\ do\ Sul",
"55983229", "Raposa\ \-\ MA",
"55793211", "Aracaju\ \-\ SE",
"55513256", "Rio\ Grande\ do\ Sul",
"55163659", "Brodowski\ \-\ SP",
"55514112", "Novo\ Hamburgo\ \-\ RS",
"55993545", "São\ Domingos\ do\ Azeitão\ \-\ MA",
"55313479", "Minas\ Gerais",
"55553375", "Panambi\ \-\ RS",
"55813519", "São\ Lourenço\ da\ Mata\ \-\ PE",
"55273717", "Colatina\ \-\ ES",
"55113433", "Embu\ das\ Artes\ \-\ SP",
"55114241", "Embu\ das\ Artes\ \-\ SP",
"55133213", "Santos\ \-\ SP",
"55463224", "Pato\ Branco\ \-\ PR",
"55743644", "Itaguaçu\ da\ Bahia\ \-\ BA",
"55843523", "Alto\ do\ Rodrigues\ \-\ RN",
"55373381", "Cláudio\ \-\ MG",
"55143541", "Promissão\ \-\ SP",
"5592364", "Manaus\ \-\ AM",
"55313443", "Minas\ Gerais",
"55553376", "Panambi\ \-\ RS",
"55313730", "Minas\ Gerais",
"55224009", "Campos\ dos\ Goitacazes\ \-\ RJ",
"55623344", "Uruana\ \-\ GO",
"55843335", "Ipanguaçu\ \-\ RN",
"55343457", "Carneirinho\ \-\ MG",
"55513542", "Taquara\ \-\ RS",
"55313394", "Belo\ Horizonte\ \-\ MG",
"55493547", "Celso\ Ramos\ \-\ SC",
"55273769", "Jaguaré\ \-\ ES",
"55313064", "Belo\ Horizonte\ \-\ MG",
"55843336", "São\ Rafael\ \-\ RN",
"55443653", "Tuneiras\ do\ Oeste\ \-\ PR",
"55313107", "Sete\ Lagoas\ \-\ MG",
"55613467", "Brasília\ \-\ DF",
"5575322", "Feira\ de\ Santana\ \-\ BA",
"55963281", "Santana\ \-\ AP",
"55643054", "Rio\ Verde\ \-\ GO",
"55513751", "Encantado\ \-\ RS",
"55553411", "Uruguaiana\ \-\ RS",
"55313891", "Viçosa\ \-\ MG",
"55443311", "Jardim\ Olinda\ \-\ PR",
"55454063", "Cascavel\ \-\ PR",
"55323337", "Mercês\ \-\ MG",
"55193779", "Campinas\ \-\ SP",
"55473152", "Gaspar\ Alto\ \-\ SC",
"55383234", "São\ João\ da\ Ponte\ \-\ MG",
"55753693", "Pintadas\ \-\ BA",
"55893562", "Bom\ Jesus\ \-\ PI",
"55213481", "Rio\ de\ Janeiro\ \-\ RJ",
"55633437", "Cachoeirinha\ \-\ TO",
"55613217", "Brasília\ \-\ DF",
"55313277", "Minas\ Gerais",
"55173421", "Votuporanga\ \-\ SP",
"55193743", "Campinas\ \-\ SP",
"55543388", "Bento\ Gonçalves\ \-\ RS",
"55733552", "Córrego\ de\ Pedras\ \-\ BA",
"55553261", "Restinga\ Seca\ \-\ RS",
"55673579", "Selvíria\ \-\ MS",
"55453411", "Cascavel\ \-\ PR",
"55983878", "São\ Luís\ \-\ MA",
"55883549", "Tarrafas\ \-\ CE",
"55953621", "Boa\ Vista\ \-\ RR",
"55222553", "Cantagalo\ \-\ RJ",
"55793461", "Pinhão\ \-\ SE",
"55813021", "Paulista\ \-\ PE",
"55513647", "Vendinha\ \-\ RS",
"55873891", "Moreilândia\ \-\ PE",
"55493642", "Guarujá\ do\ Sul\ \-\ SC",
"55813662", "Palmares\ \-\ PE",
"55473339", "Blumenau\ \-\ SC",
"55453375", "Esquina\ Ipiranga\ \-\ PR",
"55733245", "Ubatã\ \-\ BA",
"55163931", "Ribeirão\ Preto\ \-\ SP",
"55733246", "Itapitanga\ \-\ BA",
"55313292", "Belo\ Horizonte\ \-\ MG",
"55343259", "Uberlândia\ \-\ MG",
"55453376", "Nova\ Concórdia\ \-\ PR",
"55833451", "Itaporanga\ \-\ PB",
"55543476", "União\ da\ Serra\ \-\ RS",
"55693434", "Santa\ Luzia\ D\'Oeste\ \-\ RO",
"55313442", "Minas\ Gerais",
"55333621", "Nanuque\ \-\ MG",
"55823286", "Murici\ \-\ AL",
"55433355", "Londrina\ \-\ PR",
"55843522", "Pendências\ \-\ RN",
"55823285", "São\ José\ da\ Laje\ \-\ AL",
"55633369", "Novo\ Acordo\ \-\ TO",
"55433356", "Londrina\ \-\ PR",
"55833633", "Baraúna\ \-\ PB",
"55113432", "Carapicuíba\ \-\ SP",
"55133212", "Santos\ \-\ SP",
"55114178", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55212088", "São\ Gonçalo\ \-\ RJ",
"55153207", "Gramadinho\ \-\ SP",
"55753301", "Feira\ de\ Santana\ \-\ BA",
"55183379", "São\ José\ Laranjeiras\ \-\ SP",
"55423238", "Ponta\ Grossa\ \-\ PR",
"55513768", "Rio\ Grande\ do\ Sul",
"555139", "Rio\ Grande\ do\ Sul",
"55623999", "Goiânia\ \-\ GO",
"5521", "Rio\ de\ Janeiro",
"55883692", "Crateús\ \-\ CE",
"55453258", "Ramilândia\ \-\ PR",
"55333062", "Governador\ Valadares\ \-\ MG",
"55313737", "Minas\ Gerais",
"55813634", "Surubim\ \-\ PE",
"55853315", "São\ Gonçalo\ do\ Amarante\ \-\ CE",
"55843265", "Poço\ Branco\ \-\ RN",
"55513579", "São\ Leopoldo\ \-\ RS",
"55993117", "Timon\ \-\ MA",
"55843266", "Pureza\ \-\ RN",
"5554321", "Caxias\ do\ Sul\ \-\ RS",
"55653224", "Cáceres\ \-\ MT",
"55473467", "Joinville\ \-\ SC",
"55183698", "Lavínia\ \-\ SP",
"55413699", "Almirante\ Tamandaré\ \-\ PR",
"55873032", "Petrolina\ \-\ PE",
"55943344", "Nova\ Ipixuna\ \-\ PA",
"55883677", "Sobral\ \-\ CE",
"55443652", "Iporã\ \-\ PR",
"55193845", "Hortolândia\ \-\ SP",
"55833281", "Itabaiana\ \-\ PB",
"55333377", "São\ João\ do\ Manhuaçu\ \-\ MG",
"55513543", "Parobé\ \-\ RS",
"55163976", "Ribeirão\ Preto\ \-\ SP",
"55354141", "Poços\ de\ Caldas\ \-\ MG",
"55383525", "Senador\ Modestino\ Gonçalves\ \-\ MG",
"55554062", "Santa\ Maria\ \-\ RS",
"55383526", "Carbonita\ \-\ MG",
"55163975", "Ribeirão\ Preto\ \-\ SP",
"55193846", "Vinhedo\ \-\ SP",
"55753321", "Feira\ de\ Santana\ \-\ BA",
"55413579", "Curitiba\ \-\ PR",
"55513486", "Morungava\ \-\ RS",
"55833664", "Santa\ Rita\ \-\ PB",
"55323267", "São\ João\ Nepomuceno\ \-\ MG",
"55163830", "Ituverava\ \-\ SP",
"55213852", "Rio\ de\ Janeiro\ \-\ RJ",
"55112516", "São\ Paulo\ \-\ SP",
"55513485", "Viamão\ \-\ RS",
"55333294", "Nacip\ Raydan\ \-\ MG",
"55892101", "Picos\ \-\ PI",
"55693463", "Mirante\ da\ Serra\ \-\ RO",
"55413543", "Rio\ Negro\ \-\ PR",
"55893563", "Cristino\ Castro\ \-\ PI",
"55223829", "Laje\ do\ Muriaé\ \-\ RJ",
"55123678", "Natividade\ da\ Serra\ \-\ SP",
"55513699", "Rio\ Grande\ do\ Sul",
"55115111", "São\ Paulo\ \-\ SP",
"55443431", "Paraíso\ do\ Norte\ \-\ PR",
"55753692", "Paulo\ Afonso\ \-\ BA",
"55193551", "Araras\ \-\ SP",
"55643515", "Itumbiara\ \-\ GO",
"55454062", "Cascavel\ \-\ PR",
"55553331", "Ijuí\ \-\ RS",
"55383505", "Unaí\ \-\ MG",
"55113651", "Osasco\ \-\ SP",
"5511434", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55653691", "Várzea\ Grande\ \-\ MT",
"55222741", "São\ João\ da\ Barra\ \-\ RJ",
"55463535", "Verê\ \-\ PR",
"55443557", "Terra\ Nova\ do\ Piquirí\ \-\ PR",
"55463536", "Dois\ Vizinhos\ \-\ PR",
"55663488", "Santo\ Antonuio\ do\ Leste\ \-\ MT",
"55613339", "Brasília\ \-\ DF",
"55493643", "São\ José\ do\ Cedro\ \-\ SC",
"55633430", "Carmolândia\ \-\ TO",
"55853198", "Fortaleza\ \-\ CE",
"55383506", "Buritis\ \-\ MG",
"55843371", "Itaú\ \-\ RN",
"55753677", "Valença\ \-\ BA",
"55433141", "Santo\ Antônio\ da\ Platina\ \-\ PR",
"55414113", "Pinhais\ \-\ PR",
"55222552", "Santa\ Rita\ da\ Floresta\ \-\ RJ",
"55653322", "Cuiabá\ \-\ MT",
"55553258", "Nova\ Esperança\ do\ Sul\ \-\ RS",
"55434009", "Londrina\ \-\ PR",
"55433544", "Santa\ Amélia\ \-\ PR",
"55323330", "Correia\ de\ Almeida\ \-\ MG",
"55673255", "Bonito\ \-\ MS",
"55143351", "Piraju\ \-\ SP",
"55313118", "Belo\ Horizonte\ \-\ MG",
"55133847", "Miracatu\ \-\ SP",
"55242404", "Angra\ dos\ Reis\ \-\ RJ",
"55183552", "Pracinha\ \-\ SP",
"55473241", "Itajaí\ \-\ SC",
"55853213", "Caucaia\ \-\ CE",
"55843363", "Rafael\ Godeiro\ \-\ RN",
"55212742", "Teresópolis\ \-\ RJ",
"55643639", "Perolândia\ \-\ GO",
"55543017", "Veranópolis\ \-\ RS",
"55813671", "Ribeirão\ \-\ PE",
"55123652", "Caçapava\ \-\ SP",
"55693316", "Vilhena\ \-\ RO",
"55843232", "Natal\ \-\ RN",
"55733244", "Itagibá\ \-\ BA",
"55323031", "Juiz\ de\ Fora\ \-\ MG",
"55183741", "Castilho\ \-\ SP",
"5535342", "Pouso\ Alegre\ \-\ MG",
"55124109", "São\ José\ dos\ Campos\ \-\ SP",
"55383731", "Várzea\ da\ Palma\ \-\ MG",
"55383235", "Capitão\ Enéas\ \-\ MG",
"55483053", "Tubarão\ \-\ SC",
"55553272", "Tupanciretã\ \-\ RS",
"55223851", "Santo\ Antônio\ de\ Pádua\ \-\ RJ",
"55333583", "Pescador\ \-\ MG",
"55693471", "Presidente\ Médici\ \-\ RO",
"55433253", "Cambé\ \-\ PR",
"55343248", "Cascalho\ Rico\ \-\ MG",
"55114538", "Itatiba\ \-\ SP",
"55342106", "Patos\ de\ Minas\ \-\ MG",
"55383236", "Juramento\ \-\ MG",
"55183839", "Jamaica\ \-\ SP",
"55543340", "Vanini\ \-\ RS",
"55983481", "Anapurus\ \-\ MA",
"55883558", "Abaiara\ \-\ CE",
"55173487", "Magda\ \-\ SP",
"55623554", "Varjão\ \-\ GO",
"55193308", "Campinas\ \-\ SP",
"55652121", "Cuiabá\ \-\ MT",
"55733013", "Teixeira\ de\ Freitas\ \-\ BA",
"55313396", "Minas\ Gerais",
"55843334", "Serra\ do\ Mel\ \-\ RN",
"55453272", "Diamante\ D\'Oeste\ \-\ PR",
"55823003", "Maceió\ \-\ AL",
"55443340", "Alto\ Alegre\ \-\ PR",
"55313395", "Contagem\ \-\ MG",
"55913448", "Maracanã\ \-\ PA",
"55313819", "Ponte\ Nova\ \-\ MG",
"55463562", "Manfrinópolis\ \-\ PR",
"55613879", "Brasília\ \-\ DF",
"55752102", "Feira\ de\ Santana\ \-\ BA",
"55153537", "Itapetininga\ \-\ SP",
"55453030", "Foz\ do\ Iguaçu\ \-\ PR",
"55543712", "Erechim\ \-\ RS",
"55673484", "Caarapó\ \-\ MS",
"55273553", "Guaçuí\ \-\ ES",
"55343823", "Patos\ de\ Minas\ \-\ MG",
"55512109", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55183657", "Alto\ Alegre\ \-\ SP",
"55624017", "Aparecida\ de\ Goiânia\ \-\ GO",
"55983268", "São\ Luís\ \-\ MA",
"55153451", "Tatuí\ \-\ SP",
"55613491", "Brasília\ \-\ DF",
"55123431", "São\ José\ dos\ Campos\ \-\ SP",
"55193328", "Indaiatuba\ \-\ SP",
"55993544", "Loreto\ \-\ MA",
"55853463", "Fortaleza\ \-\ CE",
"55323441", "Leopoldina\ \-\ MG",
"55443017", "Campo\ Mourão\ \-\ PR",
"5561334", "Brasília\ \-\ DF",
"55313867", "São\ Sebastião\ do\ Rio\ Preto\ \-\ MG",
"55743645", "Campo\ Formoso\ \-\ BA",
"55463225", "Pato\ Branco\ \-\ PR",
"55273728", "Vila\ Valério\ \-\ ES",
"55163393", "Américo\ Brasiliense\ \-\ SP",
"55813194", "Recife\ \-\ PE",
"55213229", "Rio\ de\ Janeiro\ \-\ RJ",
"55773612", "Barreiras\ \-\ BA",
"55463226", "Mariópolis\ \-\ PR",
"55743646", "Cafarnaum\ \-\ BA",
"5531379", "Minas\ Gerais",
"55114419", "Mairiporã\ \-\ SP",
"5511347", "São\ Paulo\ \-\ SP",
"55343221", "Uberlândia\ \-\ MG",
"55463534", "São\ Jorge\ D\'Oeste\ \-\ PR",
"55123311", "Aparecida\ \-\ SP",
"55833429", "São\ Bentinho\ \-\ PB",
"55383504", "Paracatu\ \-\ MG",
"55663499", "Araguaiana\ \-\ MT",
"55713555", "Salvador\ \-\ BA",
"55653619", "Cuiabá\ \-\ MT",
"55123653", "Caçapava\ \-\ SP",
"55543347", "Casca\ \-\ RS",
"55883561", "Icó\ \-\ CE",
"55212743", "Teresópolis\ \-\ RJ",
"55843362", "Campo\ Grande\ \-\ RN",
"55433546", "Ibaiti\ \-\ PR",
"55323291", "Santa\ Rita\ de\ Jacutinga\ \-\ MG",
"55513709", "Lajeado\ \-\ RS",
"55114912", "São\ Paulo\ \-\ SP",
"55613241", "Olinda\ \-\ PE",
"55673254", "Sonora\ \-\ MS",
"55433545", "Curiúva\ \-\ PR",
"55793449", "Ribeirópolis\ \-\ SE",
"55353643", "Piranguçu\ \-\ MG",
"55333296", "Sardoá\ \-\ MG",
"55163601", "Ribeirão\ Preto\ \-\ SP",
"55483641", "Tijucas\ \-\ SC",
"55753387", "Quijingue\ \-\ BA",
"55473228", "Balneário\ Camboriú\ \-\ SC",
"55513484", "Gravataí\ \-\ RS",
"55333295", "Virgolândia\ \-\ MG",
"55553249", "Santiago\ \-\ RS",
"55153281", "Araçoiaba\ da\ Serra\ \-\ SP",
"55273138", "Serra\ \-\ ES",
"55433252", "Arapongas\ \-\ PR",
"55553290", "Santa\ Maria\ \-\ RS",
"55333582", "São\ José\ do\ Divino\ \-\ MG",
"55513688", "Rio\ Grande\ do\ Sul",
"55353068", "Varginha\ \-\ MG",
"55843618", "Natal\ \-\ RN",
"55813080", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55933547", "Óbidos\ \-\ PA",
"55513611", "Chuvisca\ \-\ RS",
"55483052", "Tubarão\ \-\ SC",
"55843264", "Taipu\ \-\ RN",
"55513729", "Lajeado\ \-\ RS",
"55813635", "Itambé\ \-\ PE",
"55213142", "Itaboraí\ \-\ RJ",
"55812626", "Recife\ \-\ PE",
"55193341", "Campinas\ \-\ SP",
"55713493", "Camaçari\ \-\ BA",
"55653225", "Porto\ Esperidião\ \-\ MT",
"55453249", "Anahy\ \-\ PR",
"55813636", "Paudalho\ \-\ PE",
"55463563", "Santo\ Antônio\ do\ Sudoeste\ \-\ PR",
"55633509", "Dianópolis\ \-\ TO",
"55462101", "Pato\ Branco\ \-\ PR",
"55533252", "Canguçu\ \-\ RS",
"55313860", "Minas\ Gerais",
"55623016", "Aparecida\ de\ Goiânia\ \-\ GO",
"55193844", "Paulínia\ \-\ SP",
"55343201", "Araxá\ \-\ MG",
"55943345", "Jacundá\ \-\ PA",
"55943346", "Parauapebas\ \-\ PA",
"5545352", "Foz\ do\ Iguaçu\ \-\ PR",
"55453273", "Toledo\ \-\ PR",
"55733012", "Porto\ Seguro\ \-\ BA",
"55623015", "Goiânia\ \-\ GO",
"55163974", "Ribeirão\ Preto\ \-\ SP",
"55114217", "Atibaia\ \-\ SP",
"55433354", "Londrina\ \-\ PR",
"5598", "Maranhão",
"55773613", "Barreiras\ \-\ BA",
"55693435", "Novo\ Horizonte\ do\ Oeste\ \-\ RO",
"55273245", "Serra\ \-\ ES",
"55453037", "Cascavel\ \-\ PR",
"55163392", "Américo\ Brasiliense\ \-\ SP",
"55973464", "Tonantins\ \-\ AM",
"55183708", "Primeira\ Aliança\ \-\ SP",
"55823284", "Cajueiro\ \-\ AL",
"55683211", "Rio\ Branco\ \-\ AC",
"55173257", "Baguaçu\ \-\ SP",
"55853462", "Fortaleza\ \-\ CE",
"55893536", "Flores\ do\ Piauí\ \-\ PI",
"55893535", "Manoel\ Emídio\ \-\ PI",
"55623988", "Goiânia\ \-\ GO",
"55124242", "Cotia\ \-\ SP",
"55412108", "Curitiba\ \-\ PR",
"55753358", "Coronel\ Octaviano\ Alves\ \-\ BA",
"55653363", "Cuiabá\ \-\ MT",
"55222543", "Nova\ Friburgo\ \-\ RJ",
"55883559", "Penaforte\ \-\ CE",
"55773430", "Caatiba\ \-\ BA",
"55543398", "Charrua\ \-\ RS",
"55833441", "Catolé\ do\ Rocha\ \-\ PB",
"55343835", "Cruzeiro\ da\ Fortaleza\ \-\ MG",
"55173812", "Icém\ \-\ SP",
"55733256", "Ituberá\ \-\ BA",
"55213208", "Rio\ de\ Janeiro\ \-\ RJ",
"55114539", "Joanópolis\ \-\ SP",
"55143846", "Areiópolis\ \-\ SP",
"55813622", "Carpina\ \-\ PE",
"55483466", "Orleans\ \-\ SC",
"55533015", "Pelotas\ \-\ RS",
"55343249", "Araguari\ \-\ MG",
"55143845", "Conchas\ \-\ SP",
"55483465", "Urussanga\ \-\ SC",
"55493652", "Palma\ Sola\ \-\ SC",
"55824102", "Centro\ \-\ AL",
"55733255", "Camamu\ \-\ BA",
"5561354", "Brasília\ \-\ DF",
"55513657", "Vendinha\ \-\ RS",
"55753683", "Humildes\ \-\ BA",
"55343836", "São\ João\ da\ Serra\ Negra\ \-\ MG",
"55443599", "Campo\ Mourão\ \-\ PR",
"55413552", "Araucária\ \-\ PR",
"55933598", "Jamanchizinho\ \-\ PA",
"55222768", "Quissamã\ \-\ RJ",
"55643434", "Cachoeira\ Dourada\ \-\ GO",
"55873881", "Ipubi\ \-\ PE",
"55893522", "Floriano\ \-\ PI",
"55693422", "Ji\-Paraná\ \-\ RO",
"55733542", "Km\ Cem\ \-\ BA",
"55623545", "Goiânia\ \-\ GO",
"55843534", "Pedro\ Avelino\ \-\ RN",
"55173461", "General\ Salgado\ \-\ SP",
"55463233", "Coronel\ Vivida\ \-\ PR",
"55113424", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55623546", "Goiânia\ \-\ GO",
"55443540", "Bragantina\ \-\ PR",
"55114852", "Santo\ André\ \-\ SP",
"55493557", "Zortéa\ \-\ SC",
"55443643", "Francisco\ Alves\ \-\ PR",
"55863347", "Batalha\ \-\ PI",
"55163456", "Ribeirão\ Preto\ \-\ SP",
"55613616", "Águas\ Lindas\ de\ Goiás\ \-\ GO",
"55114755", "Itaquaquecetuba\ \-\ SP",
"55513552", "Lindolfo\ Collor\ \-\ RS",
"55623483", "Sítio\ D\'Abadia\ \-\ GO",
"55273729", "São\ Roque\ do\ Canaã\ \-\ ES",
"55623354", "Niquelândia\ \-\ GO",
"55193508", "Araras\ \-\ SP",
"55933017", "Santarém\ \-\ PA",
"55443679", "Tapira\ \-\ PR",
"55823035", "Maceió\ \-\ AL",
"55913656", "Santa\ Bárbara\ do\ Pará\ \-\ PA",
"55242465", "Mendes\ \-\ RJ",
"55513741", "Venâncio\ Aires\ \-\ RS",
"55823036", "Maceió\ \-\ AL",
"55983217", "São\ Luís\ \-\ MA",
"55433911", "Jacarezinho\ \-\ PR",
"55883683", "Ipu\ \-\ CE",
"55993555", "Pastos\ Bons\ \-\ MA",
"55423915", "Carambeí\ \-\ PR",
"55983269", "São\ Luís\ \-\ MA",
"55673496", "Ponta\ Porã\ \-\ MS",
"55313881", "Ponte\ Nova\ \-\ MG",
"55673495", "Caracol\ \-\ MS",
"55613878", "Brasília\ \-\ DF",
"55383223", "Montes\ Claros\ \-\ MG",
"551138", "São\ Paulo\ \-\ SP",
"55443068", "Campo\ Mourão\ \-\ PR",
"55553201", "Santo\ Ângelo\ \-\ RS",
"55993556", "Mirador\ \-\ MA",
"55423916", "Tibagi\ \-\ PR",
"55893415", "Picos\ \-\ PI",
"55113404", "Bragança\ Paulista\ \-\ SP",
"55913449", "São\ João\ de\ Pirabas\ \-\ PA",
"5592365", "Manaus\ \-\ AM",
"55493431", "Xanxerê\ \-\ SC",
"55433015", "Rolândia\ \-\ PR",
"55353713", "Poços\ de\ Caldas\ \-\ MG",
"55313384", "Belo\ Horizonte\ \-\ MG",
"55113608", "Osasco\ \-\ SP",
"55483216", "Florianópolis\ \-\ SC",
"55454003", "Foz\ do\ Iguaçu\ \-\ PR",
"55483215", "Florianópolis\ \-\ SC",
"55413657", "Almirante\ Tamandaré\ \-\ PR",
"55743654", "Barra\ do\ Mendes\ \-\ BA",
"55163690", "Jardinópolis\ \-\ SP",
"55433016", "Rolândia\ \-\ PR",
"55693516", "Ariquemes\ \-\ RO",
"55222640", "Cabo\ Frio\ \-\ RJ",
"55753682", "Gavião\ \-\ BA",
"55653233", "Salto\ do\ Céu\ \-\ MT",
"55714009", "Salvador\ \-\ BA",
"5521301", "Rio\ de\ Janeiro\ \-\ RJ",
"55993014", "Imperatriz\ \-\ MA",
"55115908", "São\ Paulo\ \-\ SP",
"55612099", "Brasília\ \-\ DF",
"55493653", "Anchieta\ \-\ SC",
"55273139", "Vila\ Velha\ \-\ ES",
"55222751", "São\ Fidélis\ \-\ RJ",
"55173813", "Jaci\ \-\ SP",
"55163286", "Ribeirão\ Preto\ \-\ SP",
"55513689", "Xangri\-Lá\ \-\ RS",
"5511435", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55433554", "Congonhinhas\ \-\ PR",
"55513495", "Sertão\ Santana\ \-\ RS",
"55333284", "Frei\ Inocêncio\ \-\ MG",
"55673245", "Anastácio\ \-\ MS",
"55493311", "Chapecó\ \-\ SC",
"55923213", "Manaus\ \-\ AM",
"55433151", "Sabáudia\ \-\ PR",
"55383084", "Montes\ Claros\ \-\ MG",
"55883587", "Juazeiro\ do\ Norte\ \-\ CE",
"55222542", "Nova\ Friburgo\ \-\ RJ",
"55653362", "Várzea\ Grande\ \-\ MT",
"55513496", "Gravataí\ \-\ RS",
"55673246", "Terenos\ \-\ MS",
"55153330", "Sorocaba\ \-\ SP",
"55672108", "Dourados\ \-\ MS",
"55114853", "Suzano\ \-\ SP",
"55513650", "Barão\ do\ Triunfo\ \-\ RS",
"55333727", "Santa\ Maria\ do\ Salto\ \-\ MG",
"55833624", "João\ Pessoa\ \-\ PB",
"55223016", "Nova\ Friburgo\ \-\ RJ",
"55153267", "Capela\ do\ Alto\ \-\ SP",
"55463232", "Coronel\ Vivida\ \-\ PR",
"55983538", "Açailândia\ \-\ MA",
"55213842", "Duque\ de\ Caxias\ \-\ RJ",
"55733543", "Itaquara\ \-\ BA",
"55513708", "Sinimbu\ \-\ RS",
"55693423", "Ji\-Paraná\ \-\ RO",
"55663498", "Primavera\ do\ Leste\ \-\ MT",
"55893523", "Floriano\ \-\ PI",
"55383821", "Janaúba\ \-\ MG",
"55993492", "Lagoa\ do\ Mato\ \-\ MA",
"55773437", "Belo\ Campo\ \-\ BA",
"55193541", "Araras\ \-\ SP",
"55114481", "Bragança\ Paulista\ \-\ SP",
"55853111", "Fortaleza\ \-\ CE",
"55793644", "Lagarto\ \-\ SE",
"55833428", "Mãe\ d\'Água\ \-\ PB",
"55243111", "Petrópolis\ \-\ RJ",
"55222647", "Cabo\ Frio\ \-\ RJ",
"55112811", "Salto\ \-\ SP",
"55843225", "Genipabu\ \-\ RN",
"55863474", "Pimenteiras\ \-\ PI",
"55473427", "Joinville\ \-\ SC",
"55193856", "Vinhedo\ \-\ SP",
"55823295", "São\ Miguel\ dos\ Milagres\ \-\ AL",
"55213745", "Nova\ Iguaçu\ \-\ RJ",
"55623482", "Nova\ Roma\ \-\ GO",
"55513553", "Novo\ Hamburgo\ \-\ RS",
"55663574", "Nova\ Guarita\ \-\ MT",
"55193855", "Socorro\ \-\ SP",
"55213746", "Mesquita\ \-\ RJ",
"55443642", "Guaíra\ \-\ PR",
"55823296", "Maragogi\ \-\ AL",
"55973426", "Japurá\ \-\ AM",
"55753276", "Ribeira\ do\ Pombal\ \-\ BA",
"55753275", "Monte\ Santo\ \-\ BA",
"55833291", "Rio\ Tinto\ \-\ PB",
"55433345", "Londrina\ \-\ PR",
"55353712", "Poços\ de\ Caldas\ \-\ MG",
"55273254", "Cariacica\ \-\ ES",
"55973425", "Jutaí\ \-\ AM",
"55453248", "Iguatu\ \-\ PR",
"55383222", "Montes\ Claros\ \-\ MG",
"55323429", "Cataguases\ \-\ MG",
"55643462", "Goiandira\ \-\ GO",
"55513728", "Rio\ Grande\ do\ Sul",
"55624051", "Anápolis\ \-\ GO",
"55452105", "Foz\ do\ Iguaçu\ \-\ PR",
"55333022", "Governador\ Valadares\ \-\ MG",
"55863340", "Matias\ Olímpio\ \-\ PI",
"55863089", "Teresina\ \-\ PI",
"55114716", "São\ João\ Novo\ \-\ SP",
"55453031", "Foz\ do\ Iguaçu\ \-\ PR",
"55323374", "Rio\ das\ Mortes\ \-\ MG",
"55163415", "São\ Carlos\ \-\ SP",
"55413669", "Pinhais\ \-\ PR",
"55114715", "Alumínio\ \-\ SP",
"55633474", "Araguatins\ \-\ TO",
"55423642", "Turvo\ \-\ PR",
"55513406", "Rio\ Grande\ do\ Sul",
"55313234", "Minas\ Gerais",
"55333414", "Divinolândia\ de\ Minas\ \-\ MG",
"55733629", "São\ João\ do\ Paraíso\ \-\ BA",
"55843295", "Jaçanã\ \-\ RN",
"55513405", "Rio\ Grande\ do\ Sul",
"55173251", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55313858", "Dionísio\ \-\ MG",
"55133279", "Santos\ \-\ SP",
"5511443", "Santo\ André\ \-\ SP",
"55893455", "Caldeirão\ Grande\ do\ Piauí\ \-\ PI",
"55312571", "Betim\ \-\ MG",
"5581322", "Recife\ \-\ PE",
"55192112", "Rio\ Claro\ \-\ SP",
"55893456", "Simões\ \-\ PI",
"55343429", "Frutal\ \-\ MG",
"55212653", "Duque\ de\ Caxias\ \-\ RJ",
"55483255", "Imbituba\ \-\ SC",
"55433056", "Arapongas\ \-\ PR",
"55633399", "Sucupira\ \-\ TO",
"55473472", "Joinville\ \-\ SC",
"55433055", "Arapongas\ \-\ PR",
"55663408", "São\ José\ do\ Couto\ \-\ MT",
"55333233", "Tarumirim\ \-\ MG",
"5592361", "Manaus\ \-\ AM",
"55483256", "Anitápolis\ \-\ SC",
"55153287", "Laranjal\ Paulista\ \-\ SP",
"55693344", "Pimenteiras\ do\ Oeste\ \-\ RO",
"55513426", "Canoas\ \-\ RS",
"55212008", "Teresópolis\ \-\ RJ",
"55313332", "Minas\ Gerais",
"55883519", "Granjeiro\ \-\ CE",
"55133828", "Registro\ \-\ SP",
"55483647", "Laguna\ \-\ SC",
"55753381", "Varzedo\ \-\ BA",
"55163607", "Ribeirão\ Preto\ \-\ SP",
"55513425", "Canoas\ \-\ RS",
"55733215", "Itabuna\ \-\ BA",
"55114461", "Santo\ André\ \-\ SP",
"55323272", "Simão\ Pereira\ \-\ MG",
"55813693", "Xexéu\ \-\ PE",
"55513617", "Rio\ Grande\ do\ Sul",
"55313263", "Belo\ Horizonte\ \-\ MG",
"55163761", "Batatais\ \-\ SP",
"55833201", "Campina\ Grande\ \-\ PB",
"55833498", "Serra\ Grande\ \-\ PB",
"55213448", "Rio\ de\ Janeiro\ \-\ RJ",
"55163265", "Tapinas\ \-\ SP",
"55753662", "Laje\ \-\ BA",
"55893570", "Baixa\ Grande\ do\ Ribeiro\ \-\ PI",
"55993422", "Caxias\ \-\ MA",
"55513669", "Nova\ Tramandaí\ \-\ RS",
"55163266", "Borborema\ \-\ SP",
"55273313", "São\ Mateus\ \-\ ES",
"55873858", "Pedra\ \-\ PE",
"55923545", "Boa\ Vista\ do\ Ramos\ \-\ AM",
"55943434", "Ourilândia\ do\ Norte\ \-\ PA",
"55193713", "Limeira\ \-\ SP",
"55313159", "Betim\ \-\ MG",
"55114812", "Campo\ Limpo\ Paulista\ \-\ SP",
"55223850", "Miracema\ \-\ RJ",
"55242255", "Três\ Rios\ \-\ RJ",
"55413405", "São\ José\ dos\ Pinhais\ \-\ PR",
"55143389", "Timburi\ \-\ SP",
"55753021", "Feira\ de\ Santana\ \-\ BA",
"55543341", "Getúlio\ Vargas\ \-\ RS",
"55883567", "Ipaumirim\ \-\ CE",
"55653382", "Campo\ Novo\ do\ Parecis\ \-\ MT",
"55213644", "Teresópolis\ \-\ RJ",
"55443011", "Maringá\ \-\ PR",
"55313861", "Nova\ Era\ \-\ MG",
"55853345", "Pacatuba\ \-\ CE",
"55323447", "Leopoldina\ \-\ MG",
"55423643", "Nova\ Tebas\ \-\ PR",
"552133", "Rio\ de\ Janeiro\ \-\ RJ",
"55853346", "Itapagé\ \-\ CE",
"55113578", "São\ Paulo\ \-\ SP",
"55653003", "Cuiabá\ \-\ MT",
"55193399", "Sumaré\ \-\ SP",
"55673669", "Paranaíba\ \-\ MS",
"55313094", "Ipatinga\ \-\ MG",
"55943314", "Serra\ Pelada\ \-\ PA",
"55833248", "Cabedelo\ \-\ PB",
"55112354", "São\ Paulo\ \-\ SP",
"55832106", "João\ Pessoa\ \-\ PB",
"55193816", "Indaiatuba\ \-\ SP",
"55373321", "Formiga\ \-\ MG",
"55632112", "Araguaína\ \-\ TO",
"55473655", "Major\ Vieira\ \-\ SC",
"55333232", "Sobrália\ \-\ MG",
"55473473", "Joinville\ \-\ SC",
"55753438", "São\ Félix\ \-\ BA",
"55623463", "Mimoso\ de\ Goiás\ \-\ GO",
"55183651", "Avanhandava\ \-\ SP",
"55624011", "Goiânia\ \-\ GO",
"55193017", "Indaiatuba\ \-\ SP",
"55242485", "Paty\ do\ Alferes\ \-\ RJ",
"55353541", "Cássia\ \-\ MG",
"55473449", "São\ Francisco\ do\ Sul\ \-\ SC",
"55753634", "Amargosa\ \-\ BA",
"55193678", "Canoas\ \-\ SP",
"55192113", "Limeira\ \-\ SP",
"55883663", "Bela\ Cruz\ \-\ CE",
"55153531", "Itararé\ \-\ SP",
"55173268", "Onda\ Verde\ \-\ SP",
"55283539", "Itaoca\ \-\ ES",
"55873967", "Ouricuri\ \-\ PE",
"55113379", "Jundiaí\ \-\ SP",
"55313262", "Belo\ Horizonte\ \-\ MG",
"55133493", "Praia\ Grande\ \-\ SP",
"55373301", "Divinópolis\ \-\ MG",
"55813692", "Lagoa\ dos\ Gatos\ \-\ PE",
"55473039", "Blumenau\ \-\ SC",
"5528", "Espirito\ Santo",
"55323273", "Matias\ Barbosa\ \-\ MG",
"55173481", "São\ João\ das\ Duas\ Pontes\ \-\ SP",
"55123845", "Ubatuba\ \-\ SP",
"55844102", "Natal\ \-\ RN",
"55613299", "Brasília\ \-\ DF",
"55312323", "Betim\ \-\ MG",
"55353856", "Guapé\ \-\ MG",
"55153259", "Tatuí\ \-\ SP",
"55553796", "Alpestre\ \-\ RS",
"55483378", "Santa\ Tereza\ \-\ SC",
"55653023", "Cuiabá\ \-\ MT",
"55893577", "Monte\ Alegre\ do\ Piauí\ \-\ PI",
"55353855", "Coqueiral\ \-\ MG",
"55313333", "Minas\ Gerais",
"55983487", "Paulino\ Neves\ \-\ MA",
"55493351", "Entre\ Rios\ \-\ SC",
"55653383", "Sapezal\ \-\ MT",
"55623434", "Goiânia\ \-\ GO",
"55673405", "Vista\ Alegre\ \-\ MS",
"55543011", "Farroupilha\ \-\ RS",
"55313525", "Minas\ Gerais",
"55273079", "Serra\ \-\ ES",
"55313526", "Minas\ Gerais",
"55513610", "Rio\ Grande\ do\ Sul",
"55312535", "Belo\ Horizonte\ \-\ MG",
"55774141", "Vitória\ da\ Conquista\ \-\ BA",
"55114654", "Arujá\ \-\ SP",
"55114813", "Itu\ \-\ SP",
"55133841", "Iguape\ \-\ SP",
"55223056", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55152104", "Sorocaba\ \-\ SP",
"55143357", "Óleo\ \-\ SP",
"55883438", "Choró\ \-\ CE",
"55214139", "Maricá\ \-\ RJ",
"55333334", "Manhuaçu\ \-\ MG",
"5574", "Bahia",
"55643546", "Itumbiara\ \-\ GO",
"55273312", "São\ Mateus\ \-\ ES",
"55913754", "Barcarena\ \-\ PA",
"55883634", "Ubajara\ \-\ CE",
"55823131", "Maceió\ \-\ AL",
"55822121", "Maceió\ \-\ AL",
"55933528", "Novo\ Progresso\ \-\ PA",
"55493238", "Palmeira\ \-\ SC",
"55643545", "Itumbiara\ \-\ GO",
"55823534", "Jacaré\ dos\ Homens\ \-\ AL",
"55443529", "Campo\ Mourão\ \-\ PR",
"55213978", "Rio\ de\ Janeiro\ \-\ RJ",
"55713198", "Salvador\ \-\ BA",
"55193642", "Águas\ da\ Prata\ \-\ SP",
"55433463", "Godoy\ Moreira\ \-\ PR",
"55833297", "Mataraca\ \-\ PB",
"55323694", "Leopoldina\ \-\ MG",
"55513433", "Rio\ Grande\ do\ Sul",
"55513740", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55823264", "Atalaia\ \-\ AL",
"55973353", "Codajás\ \-\ AM",
"55343428", "Fronteira\ \-\ MG",
"5531370", "Minas\ Gerais",
"55973484", "Itamarati\ \-\ AM",
"55143589", "Reginópolis\ \-\ SP",
"55543541", "Trindade\ do\ Sul\ \-\ RS",
"55813548", "Itapissuma\ \-\ PE",
"55115477", "Mogi\ das\ Cruzes\ \-\ SP",
"55153376", "Itapetininga\ \-\ SP",
"55663902", "Rondonópolis\ \-\ MT",
"5519342", "Piracicaba\ \-\ SP",
"55373373", "Capitólio\ \-\ MG",
"55133278", "Santos\ \-\ SP",
"55313859", "João\ Monlevade\ \-\ MG",
"55323201", "Cataguases\ \-\ MG",
"55213039", "Nilópolis\ \-\ RJ",
"55353529", "Passos\ \-\ MG",
"55132138", "Santos\ \-\ SP",
"55713054", "Camaçari\ \-\ BA",
"55843284", "Serrinha\ \-\ RN",
"55733628", "Santa\ Luzia\ \-\ BA",
"55893444", "Dom\ Expedito\ Lopes\ \-\ PI",
"55693544", "Nova\ Mamoré\ \-\ RO",
"55773652", "Muquém\ de\ São\ Francisco\ \-\ BA",
"55313532", "Betim\ \-\ MG",
"55163322", "Araraquara\ \-\ SP",
"55313880", "Minas\ Gerais",
"55413668", "Pinhais\ \-\ PR",
"55163204", "Jaboticabal\ \-\ SP",
"55694009", "Porto\ Velho\ \-\ RO",
"55483244", "Florianópolis\ \-\ SC",
"5515323", "Sorocaba\ \-\ SP",
"55193955", "Socorro\ \-\ SP",
"55543057", "Bento\ Gonçalves\ \-\ RS",
"55833440", "Brejo\ dos\ Santos\ \-\ PB",
"55833685", "Sertãozinho\ \-\ PB",
"55153261", "Porto\ Feliz\ \-\ SP",
"55513464", "Canoas\ \-\ RS",
"55143311", "Marília\ \-\ SP",
"55333721", "Almenara\ \-\ MG",
"55513668", "Palmares\ do\ Sul\ \-\ RS",
"55843661", "Natal\ \-\ RN",
"55873859", "Santa\ Terezinha\ \-\ PE",
"55183406", "Guararapes\ \-\ SP",
"55193547", "Araras\ \-\ SP",
"55114487", "Itatiba\ \-\ SP",
"55833499", "Aguiar\ \-\ PB",
"55143814", "Botucatu\ \-\ SP",
"55143653", "Brotas\ \-\ SP",
"5511274", "São\ Paulo\ \-\ SP",
"55773431", "Poções\ \-\ BA",
"55353011", "Alfenas\ \-\ MG",
"55633540", "Monte\ do\ Carmo\ \-\ TO",
"55143475", "Ocauçu\ \-\ SP",
"55673432", "Ponta\ Porã\ \-\ MS",
"55223811", "Itaperuna\ \-\ RJ",
"55952121", "Boa\ Vista\ \-\ RR",
"55222757", "Macaé\ \-\ RJ",
"55443541", "Moreira\ Sales\ \-\ PR",
"55313637", "Santa\ Luzia\ \-\ MG",
"55983654", "Santa\ Luzia\ \-\ MA",
"55813734", "Vertentes\ \-\ PE",
"55143476", "Campos\ Novos\ Paulista\ \-\ SP",
"55483342", "Palhoça\ \-\ SC",
"55333225", "Governador\ Valadares\ \-\ MG",
"55843382", "Luís\ Gomes\ \-\ RN",
"55623514", "Inhumas\ \-\ GO",
"55883581", "Iguatu\ \-\ CE",
"55323725", "Antônio\ Prado\ de\ Minas\ \-\ MG",
"55753230", "Antônio\ Cardoso\ \-\ BA",
"55323574", "Tocantins\ \-\ MG",
"55323726", "Patrocínio\ do\ Muriaé\ \-\ MG",
"55883518", "Solonópole\ \-\ CE",
"55873880", "Granito\ \-\ PE",
"55513043", "Gravataí\ \-\ RS",
"55833374", "Nova\ Floresta\ \-\ PB",
"55133829", "Registro\ \-\ SP",
"55383674", "Cabeceira\ Grande\ \-\ MG",
"55673043", "Campo\ Grande\ \-\ MS",
"55843003", "Natal\ \-\ RN",
"55333534", "Padre\ Paraíso\ \-\ MG",
"55173269", "Ipiguá\ \-\ SP",
"55283538", "Atilio\ Vivacqua\ \-\ ES",
"551139", "São\ Paulo\ \-\ SP",
"55313887", "Acaiaca\ \-\ MG",
"55923016", "Manaus\ \-\ AM",
"55663903", "Alta\ Floresta\ \-\ MT",
"55823334", "Maceió\ \-\ AL",
"55473448", "Balneário\ Barra\ do\ Sul\ \-\ SC",
"5511314", "São\ Paulo\ \-\ SP",
"55473644", "Rio\ Negrinho\ \-\ SC",
"55413651", "São\ Luiz\ do\ Purunã\ \-\ PR",
"55973352", "Anori\ \-\ AM",
"55313325", "Minas\ Gerais",
"55753439", "Ribeira\ do\ Amparo\ \-\ BA",
"55773475", "Rio\ de\ Contas\ \-\ BA",
"55313326", "Belo\ Horizonte\ \-\ MG",
"55773476", "Abaíra\ \-\ BA",
"55513432", "Gravataí\ \-\ RS",
"55493437", "Passos\ Maia\ \-\ SC",
"55813274", "Recife\ \-\ PE",
"55112346", "São\ Paulo\ \-\ SP",
"55193643", "Vargem\ Grande\ do\ Sul\ \-\ SP",
"55813521", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"551932", "Campinas\ \-\ SP",
"55543528", "Itatiba\ do\ Sul\ \-\ RS",
"55483717", "Florianópolis\ \-\ SC",
"55673668", "Paranaíba\ \-\ MS",
"55163323", "Ribeirão\ Preto\ \-\ SP",
"55313533", "Ibirité\ \-\ MG",
"55453902", "Cascavel\ \-\ PR",
"55493551", "Joaçaba\ \-\ SC",
"55833273", "Alagoa\ Grande\ \-\ PB",
"55123146", "Lavrinhas\ \-\ SP",
"55123145", "Cruzeiro\ \-\ SP",
"55833290", "Conde\ \-\ PB",
"55513747", "Arroio\ do\ Tigre\ \-\ RS",
"55773311", "Brumado\ \-\ BA",
"55743538", "Sobradinho\ \-\ BA",
"55813762", "Garanhuns\ \-\ PE",
"5568", "Acre",
"55313305", "Belo\ Horizonte\ \-\ MG",
"55163759", "Franca\ \-\ SP",
"55623639", "Goiânia\ \-\ GO",
"55353341", "Caxambu\ \-\ MG",
"55873887", "Orocó\ \-\ PE",
"55143652", "Dois\ Córregos\ \-\ SP",
"55443528", "Assis\ Chateaubriand\ \-\ PR",
"55123351", "Jacareí\ \-\ SP",
"55813372", "Paulista\ \-\ PE",
"55753237", "Teodoro\ Sampaio\ \-\ BA",
"55373274", "Papagaios\ \-\ MG",
"55332101", "Governador\ Valadares\ \-\ MG",
"55214138", "Queimados\ \-\ RJ",
"55883439", "Ibaretama\ \-\ CE",
"55553227", "Itaara\ \-\ RS",
"55353844", "Ibituruna\ \-\ MG",
"55983461", "Vargem\ Grande\ \-\ MA",
"55823232", "Maceió\ \-\ AL",
"55173467", "Nhandeara\ \-\ SP",
"55633547", "Porto\ Nacional\ \-\ TO",
"55114645", "Itaquaquecetuba\ \-\ SP",
"55513313", "Nova\ Santa\ Rita\ \-\ RS",
"55754101", "Feira\ de\ Santana\ \-\ BA",
"55513042", "Gravataí\ \-\ RS",
"55553784", "Chiapetta\ \-\ RS",
"55543329", "Carazinho\ \-\ RS",
"55153258", "Guareí\ \-\ SP",
"55613401", "Taguatinga\ \-\ DF",
"55313161", "Ribeirão\ das\ Neves\ \-\ MG",
"55613298", "Brasília\ \-\ DF",
"55843383", "José\ da\ Penha\ \-\ RN",
"55373521", "Bom\ Despacho\ \-\ MG",
"55114646", "Itaquaquecetuba\ \-\ SP",
"55913746", "Bujaru\ \-\ PA",
"55513651", "São\ Jerônimo\ \-\ RS",
"55483343", "São\ José\ \-\ SC",
"55243354", "Resende\ \-\ RJ",
"55222789", "São\ Francisco\ de\ Paula\ \-\ RJ",
"55813501", "Ipojuca\ \-\ PE",
"55793615", "Simão\ Dias\ \-\ SE",
"55163303", "Araraquara\ \-\ SP",
"55113378", "Jundiaí\ \-\ SP",
"55833447", "Belém\ do\ Brejo\ do\ Cruz\ \-\ PB",
"55673433", "Ponta\ Porã\ \-\ MS",
"55413432", "Antonina\ \-\ PR",
"55873848", "Custódia\ \-\ PE",
"55843697", "Parazinho\ \-\ RN",
"55983656", "Governador\ Newton\ Bello\ \-\ MA",
"55753622", "Feira\ de\ Santana\ \-\ BA",
"55813736", "São\ Caetano\ \-\ PE",
"55143474", "Lupércio\ \-\ SP",
"55114978", "Santo\ André\ \-\ SP",
"55513629", "Rio\ Grande\ do\ Sul",
"55983655", "Zé\ Doca\ \-\ MA",
"55813735", "São\ Bento\ do\ Una\ \-\ PE",
"55663468", "Água\ Boa\ \-\ MT",
"55813683", "Maraial\ \-\ PE",
"55343267", "Centralina\ \-\ MG",
"55634141", "Palmas\ \-\ TO",
"55323724", "Eugenópolis\ \-\ MG",
"55323575", "Guarani\ \-\ MG",
"55543351", "David\ Canabarro\ \-\ RS",
"55833376", "Barra\ de\ Santa\ Rosa\ \-\ PB",
"555131", "Rio\ Grande\ do\ Sul",
"55623515", "Goiânia\ \-\ GO",
"55213813", "Rio\ de\ Janeiro\ \-\ RJ",
"55733512", "Eunápolis\ \-\ BA",
"55383676", "Unaí\ \-\ MG",
"55814107", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55153297", "Araçoiaba\ da\ Serra\ \-\ SP",
"55383675", "Bonfinópolis\ de\ Minas\ \-\ MG",
"55683615", "Santa\ Rosa\ do\ Purus\ \-\ AC",
"55493328", "Chapecó\ \-\ SC",
"55833375", "Pedra\ Lavrada\ \-\ PB",
"55623516", "Goianira\ \-\ GO",
"55883527", "Pereiro\ \-\ CE",
"55323576", "Dores\ do\ Turvo\ \-\ MG",
"55323287", "Senador\ Cortes\ \-\ MG",
"55833684", "Serra\ da\ Raiz\ \-\ PB",
"55513466", "Canoas\ \-\ RS",
"55433436", "Cambira\ \-\ PR",
"55183608", "Araçatuba\ \-\ SP",
"5583323", "João\ Pessoa\ \-\ PB",
"55843672", "Natal\ \-\ RN",
"55483657", "São\ Ludgero\ \-\ SC",
"55433435", "Manoel\ Ribas\ \-\ PR",
"55513465", "Canoas\ \-\ RS",
"55112279", "Guarulhos\ \-\ SP",
"55533045", "Rio\ Grande\ \-\ RS",
"5511405", "Diadema\ \-\ SP",
"55153272", "Itapetininga\ \-\ SP",
"55114421", "Santo\ André\ \-\ SP",
"55983473", "Coelho\ Neto\ \-\ MA",
"55173842", "Indiaporã\ \-\ SP",
"55543238", "Caxias\ do\ Sul\ \-\ RS",
"55813231", "Recife\ \-\ PE",
"55833488", "Santa\ Inês\ \-\ PB",
"55163721", "Franca\ \-\ SP",
"55163176", "Furnas\ Vila\ Residencial\ \-\ SP",
"55143815", "Botucatu\ \-\ SP",
"55843285", "Várzea\ \-\ RN",
"55333322", "Caratinga\ \-\ MG",
"55793251", "Aracaju\ \-\ SE",
"55553537", "Horizontina\ \-\ RS",
"55643492", "Edéia\ \-\ GO",
"55613459", "Samambaia\ Sul\ \-\ DF",
"55893446", "Itainópolis\ \-\ PI",
"55893445", "Santa\ Cruz\ do\ Piauí\ \-\ PI",
"55413465", "Morretes\ \-\ PR",
"55112828", "Santo\ André\ \-\ SP",
"55733617", "Itabuna\ \-\ BA",
"55313848", "Minas\ Gerais",
"55843286", "Passagem\ \-\ RN",
"55513215", "Rio\ Grande\ do\ Sul",
"55823522", "Arapiraca\ \-\ AL",
"55115817", "São\ Paulo\ \-\ SP",
"55443238", "Doutor\ Camargo\ \-\ PR",
"55482108", "Florianópolis\ \-\ SC",
"55643999", "Itumbiara\ \-\ GO",
"55483246", "São\ José\ \-\ SC",
"55753602", "Feira\ de\ Santana\ \-\ BA",
"55353743", "Campestre\ \-\ MG",
"55833261", "Belém\ \-\ PB",
"55693546", "Nova\ Dimensão\ \-\ RO",
"5579", "Sergipe",
"55863369", "Cajueiro\ da\ Praia\ \-\ PI",
"55813559", "Ipojuca\ \-\ PE",
"55273757", "Ponto\ Belo\ \-\ ES",
"55433046", "Arapongas\ \-\ PR",
"55483245", "Santo\ Amaro\ da\ Imperatriz\ \-\ SC",
"55212643", "Teresópolis\ \-\ RJ",
"55513609", "Rio\ Grande\ do\ Sul",
"55823266", "Satuba\ \-\ AL",
"552122", "Rio\ de\ Janeiro\ \-\ RJ",
"55993212", "Timon\ \-\ MA",
"55913467", "Ourém\ \-\ PA",
"55973485", "Guajará\ \-\ AM",
"55413629", "Tijucas\ do\ Sul\ \-\ PR",
"55323696", "Muriaé\ \-\ MG",
"55633389", "Abreulândia\ \-\ TO",
"55823265", "Pilar\ \-\ AL",
"55343074", "Uberaba\ \-\ MG",
"55643014", "Jataí\ \-\ GO",
"55513711", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55443351", "Cianorte\ \-\ PR",
"55693252", "Vila\ Extrema\ \-\ RO",
"55333082", "Governador\ Valadares\ \-\ MG",
"55423652", "Boa\ Ventura\ de\ São\ Roque\ \-\ PR",
"55373231", "Pará\ de\ Minas\ \-\ MG",
"55163667", "Cajuru\ \-\ SP",
"55513788", "Progresso\ \-\ RS",
"55553785", "Inhacorá\ \-\ RS",
"55114644", "Itaquaquecetuba\ \-\ SP",
"55133851", "Cananéia\ \-\ SP",
"55322104", "Juiz\ de\ Fora\ \-\ MG",
"55883603", "Cruz\ \-\ CE",
"55643555", "Avelinópolis\ \-\ GO",
"55813682", "Joaquim\ Nabuco\ \-\ PE",
"55813106", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55243355", "Resende\ \-\ RJ",
"55913744", "Santa\ Isabel\ do\ Pará\ \-\ PA",
"55243356", "Pinheiral\ \-\ RJ",
"55753623", "Feira\ de\ Santana\ \-\ BA",
"55193588", "Porto\ Ferreira\ \-\ SP",
"55543612", "Muitos\ Capões\ \-\ RS",
"55114448", "Cajamar\ \-\ SP",
"55643556", "Paraúna\ \-\ GO",
"55663537", "Nova\ Maringá\ \-\ MT",
"55443569", "Juranda\ \-\ PR",
"55162101", "Ribeirão\ Preto\ \-\ SP",
"55893582", "São\ Raimundo\ Nonato\ \-\ PI",
"55223847", "Raposo\ \-\ RJ",
"55823620", "Dois\ Riachos\ \-\ AL",
"55173843", "Ouroeste\ \-\ SP",
"55983472", "Brejo\ \-\ MA",
"55663451", "Dom\ Aquino\ \-\ MT",
"55153273", "Itapetininga\ \-\ SP",
"55873821", "Arcoverde\ \-\ PE",
"55543368", "Jacutinga\ \-\ RS",
"55493341", "Jupiá\ \-\ SC",
"55813361", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55843673", "Natal\ \-\ RN",
"55373275", "São\ José\ da\ Varginha\ \-\ MG",
"55373276", "Conceição\ do\ Pará\ \-\ MG",
"55113353", "São\ Paulo\ \-\ SP",
"55673216", "Sidrolândia\ \-\ MS",
"55553281", "Caçapava\ do\ Sul\ \-\ RS",
"55153249", "Ibiúna\ \-\ SP",
"55873202", "Petrolina\ \-\ PE",
"55993638", "Alto\ Alegre\ do\ Maranhão\ \-\ MA",
"55423028", "Ponta\ Grossa\ \-\ PR",
"55433316", "Arapongas\ \-\ PR",
"55212642", "Teresópolis\ \-\ RJ",
"55943422", "Piçarras\ \-\ PA",
"55163660", "Batatais\ \-\ SP",
"55213288", "Rio\ de\ Janeiro\ \-\ RJ",
"55813771", "Bom\ Conselho\ \-\ PE",
"55112493", "Atibaia\ \-\ SP",
"55353742", "Bandeira\ do\ Sul\ \-\ MG",
"55313084", "Belo\ Horizonte\ \-\ MG",
"55433315", "Londrina\ \-\ PR",
"55753603", "Feira\ de\ Santana\ \-\ BA",
"55823523", "Limoeiro\ de\ Anadia\ \-\ AL",
"55613487", "Sobradinho\ \-\ DF",
"55383631", "São\ Francisco\ \-\ MG",
"55673465", "Jateí\ \-\ MS",
"55453218", "Cascavel\ \-\ PR",
"55883623", "Barroquinha\ \-\ CE",
"55673466", "Glória\ de\ Dourados\ \-\ MS",
"55353551", "Guaxupé\ \-\ MG",
"55473459", "São\ Francisco\ do\ Sul\ \-\ SC",
"55453281", "Marechal\ Cândido\ Rondon\ \-\ PR",
"55143713", "Paranapanema\ \-\ SP",
"55183641", "Birigui\ \-\ SP",
"55863239", "Santo\ Antônio\ dos\ Milagres\ \-\ PI",
"55323531", "Ubá\ \-\ MG",
"55333323", "Ubaporanga\ \-\ MG",
"55123144", "Cruzeiro\ \-\ SP",
"55963261", "Macapá\ \-\ AP",
"55853356", "Apuiarés\ \-\ CE",
"55793268", "General\ Maynard\ \-\ SE",
"55114038", "Campo\ Limpo\ Paulista\ \-\ SP",
"55112841", "São\ Paulo\ \-\ SP",
"55423653", "Rio\ Bonito\ do\ Iguaçu\ \-\ PR",
"55823336", "Maceió\ \-\ AL",
"55333535", "Pavão\ \-\ MG",
"55693253", "Vila\ Nova\ Califórnia\ \-\ RO",
"55433471", "Jacutinga\ \-\ PR",
"55333536", "Teófilo\ Otoni\ \-\ MG",
"55353437", "Senador\ Amaral\ \-\ MG",
"55773678", "Botuporã\ \-\ BA",
"55193029", "Campinas\ \-\ SP",
"55853355", "São\ Luís\ do\ Curu\ \-\ CE",
"55313324", "Belo\ Horizonte\ \-\ MG",
"55773474", "Feira\ da\ Mata\ \-\ BA",
"55313202", "Belo\ Horizonte\ \-\ MG",
"55833258", "João\ Pessoa\ \-\ PB",
"55953224", "Boa\ Vista\ \-\ RR",
"55423311", "Ponta\ Grossa\ \-\ PR",
"55213716", "São\ Gonçalo\ \-\ RJ",
"55633357", "Formoso\ do\ Araguaia\ \-\ TO",
"55373361", "Oliveira\ \-\ MG",
"55413608", "Fazenda\ Rio\ Grande\ \-\ PR",
"55114497", "Jundiaí\ \-\ SP",
"55833489", "São\ José\ de\ Caiana\ \-\ PB",
"55843377", "Portalegre\ \-\ RN",
"55443551", "Iracema\ do\ Oeste\ \-\ PR",
"55193431", "Tanquinho\ \-\ SP",
"55343281", "Tupaciguara\ \-\ MG",
"55163797", "Ribeirão\ Preto\ \-\ SP",
"55222747", "Farol\ de\ São\ Tomé\ \-\ RJ",
"55372102", "Divinópolis\ \-\ MG",
"55924009", "Manaus\ \-\ AM",
"55333265", "Santa\ Rita\ do\ Itueto\ \-\ MG",
"55513053", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55943435", "São\ Félix\ do\ Xingu\ \-\ PA",
"55242254", "Comendador\ Levy\ Gasparian\ \-\ RJ",
"55413404", "Curitiba\ \-\ PR",
"55333266", "Quatituba\ \-\ MG",
"55183609", "Araçatuba\ \-\ SP",
"55473211", "Brusque\ \-\ SC",
"55693345", "Cabixi\ \-\ RO",
"55112809", "Guarulhos\ \-\ SP",
"55493329", "Chapecó\ \-\ SC",
"55513424", "Rio\ Grande\ do\ Sul",
"55693346", "Chupinguaia\ \-\ RO",
"55323261", "São\ João\ Nepomuceno\ \-\ MG",
"55873873", "Araripina\ \-\ PE",
"55843062", "Mossoró\ \-\ RN",
"55843392", "Antônio\ Martins\ \-\ RN",
"55753327", "Lajedinho\ \-\ BA",
"55212712", "São\ Gonçalo\ \-\ RJ",
"55113138", "São\ Paulo\ \-\ SP",
"55833450", "Tavares\ \-\ PB",
"5547343", "Joinville\ \-\ SC",
"55513628", "Maquiné\ \-\ RS",
"55333522", "Teófilo\ Otoni\ \-\ MG",
"55193557", "Rio\ Claro\ \-\ SP",
"55733214", "Itabuna\ \-\ BA",
"55443437", "Amaporã\ \-\ PR",
"55134010", "Santos\ \-\ SP",
"55873849", "Itaíba\ \-\ PE",
"55123011", "Taubaté\ \-\ SP",
"55343633", "Tapira\ \-\ MG",
"55823204", "Chã\ Preta\ \-\ AL",
"55114979", "Santo\ André\ \-\ SP",
"55183788", "Murutinga\ do\ Sul\ \-\ SP",
"55813723", "Caruaru\ \-\ PE",
"55222651", "Saquarema\ \-\ RJ",
"55812102", "Recife\ \-\ PE",
"55893454", "Fronteiras\ \-\ PI",
"55513789", "Boqueirão\ do\ Leão\ \-\ RS",
"5561331", "Brasília\ \-\ DF",
"55633653", "Arraias\ \-\ TO",
"5577342", "Vitória\ da\ Conquista\ \-\ BA",
"55313731", "Congonhas\ \-\ MG",
"55733668", "Trancoso\ \-\ BA",
"55633388", "Santa\ Rosa\ do\ Tocantins\ \-\ TO",
"55483254", "Garopaba\ \-\ SC",
"55113552", "São\ Paulo\ \-\ SP",
"55413628", "Campo\ do\ Tenente\ \-\ PR",
"5532323", "Juiz\ de\ Fora\ \-\ MG",
"55793339", "Santana\ do\ São\ Francisco\ \-\ SE",
"55833287", "Mari\ \-\ PB",
"55773642", "Oliveira\ dos\ Brejinhos\ \-\ BA",
"55883671", "Tianguá\ \-\ CE",
"55913481", "Primavera\ \-\ PA",
"55543551", "Machadinho\ \-\ RS",
"55323375", "Conceição\ da\ Barra\ de\ Minas\ \-\ MG",
"55733312", "Itamaraju\ \-\ BA",
"55733043", "Itabuna\ \-\ BA",
"55373359", "Arcos\ \-\ MG",
"55973343", "Tefé\ \-\ AM",
"55513608", "Rio\ Grande\ do\ Sul",
"55313873", "Matipó\ \-\ MG",
"55823302", "Maceió\ \-\ AL",
"55643998", "Itumbiara\ \-\ GO",
"55333627", "Machacalis\ \-\ MG",
"55813000", "Recife\ \-\ PE",
"55513750", "Vale\ do\ Sol\ \-\ RS",
"55193652", "Aguaí\ \-\ SP",
"55313890", "Minas\ Gerais",
"55453260", "Missal\ \-\ PR",
"55633028", "Palmas\ \-\ TO",
"55323376", "São\ Tiago\ \-\ MG",
"55112829", "Santo\ André\ \-\ SP",
"55333415", "Gonzaga\ \-\ MG",
"55313235", "Belo\ Horizonte\ \-\ MG",
"55343664", "Araxá\ \-\ MG",
"55633475", "Esperantina\ \-\ TO",
"5519346", "Americana\ \-\ SP",
"55973379", "Novo\ Aripuanã\ \-\ AM",
"55313849", "Timóteo\ \-\ MG",
"55213113", "Rio\ de\ Janeiro\ \-\ RJ",
"555138", "Rio\ Grande\ do\ Sul",
"55853014", "Maracanaú\ \-\ CE",
"55633476", "Colinas\ do\ Tocantins\ \-\ TO",
"55613458", "Samambaia\ Sul\ \-\ DF",
"55623928", "Goiânia\ \-\ GO",
"55843294", "São\ José\ do\ Campestre\ \-\ RN",
"55513404", "Rio\ Grande\ do\ Sul",
"55333416", "Virginópolis\ \-\ MG",
"55313236", "Belo\ Horizonte\ \-\ MG",
"55313524", "Belo\ Horizonte\ \-\ MG",
"55313775", "Sete\ Lagoas\ \-\ MG",
"55114656", "Santa\ Isabel\ \-\ SP",
"55153248", "Ibiúna\ \-\ SP",
"55223054", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55423511", "Santo\ Antônio\ do\ Iratim\ \-\ PR",
"55152105", "Sorocaba\ \-\ SP",
"55323258", "Coronel\ Pacheco\ \-\ MG",
"55513052", "Canoas\ \-\ RS",
"55543369", "Barra\ Funda\ \-\ RS",
"55313121", "Igarapé\ \-\ MG",
"55114655", "Arujá\ \-\ SP",
"55873991", "Vermelho\ \-\ PE",
"55753320", "Itaeté\ \-\ BA",
"55833457", "Princesa\ Isabel\ \-\ PB",
"55913755", "Igarapé\-Miri\ \-\ PA",
"55883635", "Irauçuba\ \-\ CE",
"55163831", "Guará\ \-\ SP",
"55823536", "Traipu\ \-\ AL",
"55333335", "São\ José\ do\ Mantimento\ \-\ MG",
"55333336", "Simonésia\ \-\ MG",
"55823535", "Olho\ d\'Água\ Grande\ \-\ AL",
"55913756", "Moju\ \-\ PA",
"55933517", "Creporizão\ \-\ PA",
"55883636", "Amontada\ \-\ CE",
"55833531", "Cajazeiras\ \-\ PB",
"55424141", "Ponta\ Grossa\ \-\ PR",
"55443568", "Mamborê\ \-\ PR",
"55114449", "Franco\ da\ Rocha\ \-\ SP",
"55193589", "Porto\ Ferreira\ \-\ SP",
"55143642", "Barra\ Bonita\ \-\ SP",
"5533327", "Governador\ Valadares\ \-\ MG",
"55333523", "Teófilo\ Otoni\ \-\ MG",
"55323331", "Barbacena\ \-\ MG",
"5563321", "Palmas\ \-\ TO",
"55163749", "Ribeirão\ Corrente\ \-\ SP",
"55173209", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55212713", "São\ Gonçalo\ \-\ RJ",
"55843393", "João\ Dias\ \-\ RN",
"5591", "Pará",
"55114473", "Santo\ André\ \-\ SP",
"55663410", "Rondonópolis\ \-\ MT",
"55873872", "Araripina\ \-\ PE",
"55553267", "Ivorá\ \-\ RS",
"55353854", "Ilicínea\ \-\ MG",
"55553794", "Planalto\ \-\ RS",
"55633431", "Angico\ \-\ TO",
"55273215", "Vitória\ \-\ ES",
"55543568", "Ponte\ Preta\ \-\ RS",
"55773643", "Matina\ \-\ BA",
"55813561", "Ipojuca\ \-\ PE",
"55493541", "Campos\ Novos\ \-\ SC",
"55193476", "Nova\ Odessa\ \-\ SP",
"55873775", "Águas\ Belas\ \-\ PE",
"55833259", "Pitimbu\ \-\ PB",
"55313897", "São\ Miguel\ do\ Anta\ \-\ MG",
"55753635", "Mutuípe\ \-\ BA",
"55453267", "Vera\ Cruz\ do\ Oeste\ \-\ PR",
"55623941", "Goiânia\ \-\ GO",
"55242484", "Miguel\ Pereira\ \-\ RJ",
"55513757", "Nova\ Bréscia\ \-\ RS",
"55313504", "Belo\ Horizonte\ \-\ MG",
"55114039", "Campo\ Limpo\ Paulista\ \-\ SP",
"55793269", "Riachuelo\ \-\ SE",
"55123156", "Piquete\ \-\ SP",
"55613461", "Ceilândia\ \-\ DF",
"55753636", "Nazaré\ \-\ BA",
"55193311", "Jaguariúna\ \-\ SP",
"55222668", "Silva\ Jardim\ \-\ RJ",
"55833280", "Salgado\ de\ São\ Félix\ \-\ PB",
"55473458", "São\ João\ do\ Itaperiú\ \-\ SC",
"55853344", "Paracuru\ \-\ CE",
"55713462", "Salvador\ \-\ BA",
"55793217", "Aracaju\ \-\ SE",
"55453219", "Cascavel\ \-\ PR",
"55193388", "Campinas\ \-\ SP",
"55943315", "PA\ 275\ \-\ PA",
"55143547", "Guaiçara\ \-\ SP",
"55193814", "Mogi\ Mirim\ \-\ SP",
"55193653", "Aguaí\ \-\ SP",
"55115851", "São\ Paulo\ \-\ SP",
"55473654", "Monte\ Castelo\ \-\ SC",
"55313872", "Abre\ Campo\ \-\ MG",
"55114247", "Barueri\ \-\ SP",
"55843034", "Natal\ \-\ RN",
"55993639", "São\ Mateus\ do\ Maranhão\ \-\ MA",
"55313096", "Ipatinga\ \-\ MG",
"55273711", "Colatina\ \-\ ES",
"55733313", "Ipiaú\ \-\ BA",
"55273270", "Barra\ do\ Riacho\ \-\ ES",
"55743692", "América\ Dourada\ \-\ BA",
"55113159", "São\ Paulo\ \-\ SP",
"55543331", "Carazinho\ \-\ RS",
"55213634", "Rio\ Bonito\ \-\ RJ",
"55813338", "Recife\ \-\ PE",
"55174004", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55333014", "Governador\ Valadares\ \-\ MG",
"55493574", "Macieira\ \-\ SC",
"55183997", "Taciba\ \-\ SP",
"55273032", "Vila\ Velha\ \-\ ES",
"55414020", "Curitiba\ \-\ PR",
"55473367", "Balneário\ Camboriú\ \-\ SC",
"55413385", "São\ José\ dos\ Pinhais\ \-\ PR",
"55823278", "Tanque\ D\'Arca\ \-\ AL",
"55383214", "Montes\ Claros\ \-\ MG",
"55173573", "Roberto\ \-\ SP",
"55114602", "Salto\ \-\ SP",
"55714102", "Salvador\ \-\ BA",
"5517322", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55143227", "Bauru\ \-\ SP",
"55813755", "Tacaimbó\ \-\ PE",
"55623377", "Formoso\ \-\ GO",
"55614101", "Brasília\ \-\ DF",
"55413674", "Tijucas\ do\ Sul\ \-\ PR",
"55743677", "Ponto\ Novo\ \-\ BA",
"55473319", "Navegantes\ \-\ SC",
"55923323", "Pitinga\ \-\ AM",
"55933531", "Medicilândia\ \-\ PA",
"55383799", "Curvelo\ \-\ MG",
"55113180", "São\ Paulo\ \-\ SP",
"55413025", "Curitiba\ \-\ PR",
"55623621", "Goiânia\ \-\ GO",
"55433456", "Apucarana\ \-\ PR",
"55633469", "Goiatins\ \-\ TO",
"55843198", "Natal\ \-\ RN",
"55273120", "Colatina\ \-\ ES",
"55513191", "Portão\ \-\ RS",
"55853371", "Maracanaú\ \-\ CE",
"55383740", "Pirapora\ \-\ MG",
"5581", "Pernambuco",
"55883421", "Aracati\ \-\ CE",
"55643691", "Vicentinópolis\ \-\ GO",
"55313342", "Belo\ Horizonte\ \-\ MG",
"55493802", "Lages\ \-\ SC",
"55513594", "Novo\ Hamburgo\ \-\ RS",
"55313710", "Minas\ Gerais",
"55123102", "Silveiras\ \-\ SP",
"55333243", "Central\ de\ Minas\ \-\ MG",
"55443258", "Munhoz\ de\ Melo\ \-\ PR",
"55323743", "Divino\ \-\ MG",
"55114894", "Itatiba\ \-\ SP",
"55123686", "Taubaté\ \-\ SP",
"55833612", "João\ Pessoa\ \-\ PB",
"55643571", "Palmeiras\ de\ Goiás\ \-\ GO",
"55113413", "Itu\ \-\ SP",
"55343511", "Patrocínio\ \-\ MG",
"55114622", "Santana\ de\ Parnaíba\ \-\ SP",
"55183586", "Mariápolis\ \-\ SP",
"55243371", "Paraty\ \-\ RJ",
"55193934", "Indaiatuba\ \-\ SP",
"55513674", "Tavares\ \-\ RS",
"55115721", "Mauá\ \-\ SP",
"55373755", "Morada\ Nova\ de\ Minas\ \-\ MG",
"55913722", "Curuçá\ \-\ PA",
"55513478", "Rio\ Grande\ do\ Sul",
"55843471", "Parelhas\ \-\ RN",
"55553557", "Coronel\ Bicaco\ \-\ RS",
"55114061", "Diadema\ \-\ SP",
"5565364", "Cuiabá\ \-\ MT",
"55112787", "São\ Paulo\ \-\ SP",
"55274105", "Vila\ Velha\ \-\ ES",
"5564400", "Itumbiara\ \-\ GO",
"5511368", "Osasco\ \-\ SP",
"55544062", "Caxias\ do\ Sul\ \-\ RS",
"55553431", "São\ Borja\ \-\ RS",
"55833368", "Areial\ \-\ PB",
"55674007", "Campo\ Grande\ \-\ MS",
"55483532", "Praia\ Grande\ \-\ SC",
"55173693", "São\ Francisco\ \-\ SP",
"55143666", "Bocaina\ \-\ SP",
"55313244", "Minas\ Gerais",
"55883401", "Limoeiro\ do\ Norte\ \-\ CE",
"55423632", "Jordãozinho\ \-\ PR",
"55183277", "Sandovalina\ \-\ SP",
"55353695", "São\ Lourenço\ \-\ MG",
"5555321", "Santa\ Maria\ \-\ RS",
"55212796", "Mesquita\ \-\ RJ",
"5537", "Minas\ Gerais",
"55993661", "Codó\ \-\ MA",
"55663476", "Araguainha\ \-\ MT",
"55753421", "Alagoinhas\ \-\ BA",
"55353696", "Guaxupé\ \-\ MG",
"55543261", "Farroupilha\ \-\ RS",
"55243335", "Rio\ Claro\ \-\ RJ",
"55493248", "Ponte\ Alta\ \-\ SC",
"55553311", "Santa\ Maria\ \-\ RS",
"55824009", "Maceió\ \-\ AL",
"55114603", "Bragança\ Paulista\ \-\ SP",
"55173572", "Pindorama\ \-\ SP",
"55333344", "Lajinha\ \-\ MG",
"55683548", "Assis\ Brasil\ \-\ AC",
"55613367", "Brasília\ \-\ DF",
"55383747", "Paredão\ de\ Minas\ \-\ MG",
"55663557", "Tabaporã\ \-\ MT",
"55883644", "Santana\ do\ Acaraú\ \-\ CE",
"55273033", "Vila\ Velha\ \-\ ES",
"55453550", "São\ Jorge\ \-\ PR",
"55443684", "Guaporema\ \-\ PR",
"55843436", "São\ Vicente\ \-\ RN",
"55613964", "Brasília\ \-\ DF",
"55793276", "Pirambu\ \-\ SE",
"55883448", "Parambu\ \-\ CE",
"55163346", "Boa\ Esperança\ do\ Sul\ \-\ SP",
"55112536", "São\ Paulo\ \-\ SP",
"55163810", "São\ Joaquim\ da\ Barra\ \-\ SP",
"55163345", "Dourado\ \-\ SP",
"55112535", "São\ Paulo\ \-\ SP",
"55483306", "Florianópolis\ \-\ SC",
"55912122", "Ananindeua\ \-\ PA",
"55843435", "Florânia\ \-\ RN",
"55793275", "Maruim\ \-\ SE",
"55514007", "Porto\ Alegre\ \-\ RS",
"55333739", "Chapada\ do\ Norte\ \-\ MG",
"55193626", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55623370", "Montes\ Claros\ de\ Goiás\ \-\ GO",
"55123836", "Ubatuba\ \-\ SP",
"55943392", "Canaã\ dos\ Carajás\ \-\ PA",
"55123835", "Ubatuba\ \-\ SP",
"55473360", "Balneário\ Camboriú\ \-\ SC",
"55623393", "Bonópolis\ \-\ GO",
"55983194", "São\ Luís\ \-\ MA",
"55193625", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55673478", "Tacuru\ \-\ MS",
"55673025", "Campo\ Grande\ \-\ MS",
"55553028", "Santa\ Maria\ \-\ RS",
"55673674", "Bela\ Vista\ \-\ MS",
"55313379", "Minas\ Gerais",
"55663431", "Guiratinga\ \-\ MT",
"55173301", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55273277", "Timbuí\ \-\ ES",
"55423664", "Faxinal\ do\ Céu\ \-\ PR",
"55113505", "São\ Paulo\ \-\ SP",
"55273064", "Serra\ \-\ ES",
"55313769", "Conselheiro\ Lafaiete\ \-\ MG",
"55833351", "Monteiro\ \-\ PB",
"55543376", "Aratiba\ \-\ RS",
"55543375", "Erval\ Grande\ \-\ RS",
"55863259", "Lagoa\ do\ Piauí\ \-\ PI",
"55323551", "Visconde\ do\ Rio\ Branco\ \-\ MG",
"55913723", "Marapanim\ \-\ PA",
"55353531", "São\ Sebastião\ do\ Paraíso\ \-\ MG",
"55673901", "Campo\ Grande\ \-\ MS",
"5521345", "Rio\ de\ Janeiro\ \-\ RJ",
"55753644", "Queimadas\ \-\ BA",
"55453028", "Foz\ do\ Iguaçu\ \-\ PR",
"55793361", "Amparo\ de\ São\ Francisco\ \-\ SE",
"55753448", "Itamira\ \-\ BA",
"55113412", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55914006", "Belém\ \-\ PA",
"55833613", "Campina\ Grande\ \-\ PB",
"55914005", "Belém\ \-\ PA",
"55323742", "Fervedouro\ \-\ MG",
"55923571", "Urucará\ \-\ AM",
"55333242", "São\ João\ do\ Manteninha\ \-\ MG",
"55713296", "Simões\ Filho\ \-\ BA",
"55123103", "Cachoeira\ Paulista\ \-\ SP",
"55193794", "Campinas\ \-\ SP",
"55773409", "Iguatemi\ \-\ BA",
"55653054", "Cuiabá\ \-\ MT",
"55863280", "São\ Pedro\ do\ Piauí\ \-\ PI",
"55813481", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55423633", "Mato\ Rico\ \-\ PR",
"55613581", "Ceilândia\ \-\ DF",
"55693233", "Triunfo\ \-\ RO",
"55853336", "Horizonte\ \-\ CE",
"55112303", "Guarulhos\ \-\ SP",
"55483086", "Palhoça\ \-\ SC",
"55173692", "Santana\ da\ Ponte\ Pensa\ \-\ SP",
"55483533", "Sombrio\ \-\ SC",
"55414007", "Curitiba\ \-\ PR",
"55483085", "Florianópolis\ \-\ SC",
"55313717", "Santana\ de\ Pirapama\ \-\ MG",
"55313578", "Piedade\ dos\ Gerais\ \-\ MG",
"55353457", "Heliodora\ \-\ MG",
"55743549", "Rômulo\ Campos\ \-\ BA",
"55683301", "Rio\ Branco\ \-\ AC",
"55243302", "Petrópolis\ \-\ RJ",
"55513033", "Esteio\ \-\ RS",
"55212666", "Nova\ Iguaçu\ \-\ RJ",
"55513585", "Campo\ Bom\ \-\ RS",
"55193883", "Sumaré\ \-\ SP",
"55513127", "Gravataí\ \-\ RS",
"55664141", "Rondonópolis\ \-\ MT",
"55163482", "Cravinhos\ \-\ SP",
"55643627", "Riverlândia\ \-\ GO",
"55633468", "Couto\ de\ Magalhães\ \-\ TO",
"55483263", "Tijucas\ \-\ SC",
"55212665", "Queimados\ \-\ RJ",
"55513586", "Rio\ Grande\ do\ Sul",
"55473318", "Gaspar\ \-\ SC",
"55443531", "Peabiru\ \-\ PR",
"55193451", "Limeira\ \-\ SP",
"55274007", "Vitória\ \-\ ES",
"55813744", "Agrestina\ \-\ PE",
"55613048", "Taguatinga\ \-\ DF",
"55483332", "Florianópolis\ \-\ SC",
"55673442", "Ivinhema\ \-\ MS",
"55413443", "Guaratuba\ \-\ PR",
"55113637", "São\ Paulo\ \-\ SP",
"55543259", "Nova\ Sardenha\ \-\ RS",
"55692101", "Vilhena\ \-\ RO",
"55643416", "Morrinhos\ \-\ GO",
"55413972", "Pontal\ do\ Paraná\ \-\ PR",
"55954009", "Boa\ Vista\ \-\ RR",
"55193537", "Ipeúna\ \-\ SP",
"55773441", "Brumado\ \-\ BA",
"55115092", "São\ Paulo\ \-\ SP",
"5511273", "São\ Paulo\ \-\ SP",
"55663588", "Ipiranga\ do\ Norte\ \-\ MT",
"55633530", "Rio\ dos\ Bois\ \-\ TO",
"55993582", "Imperatriz\ \-\ MA",
"55473021", "Balneário\ Camboriú\ \-\ SC",
"55493030", "Concórdia\ \-\ SC",
"55114591", "Itupeva\ \-\ SP",
"55542104", "Passo\ Fundo\ \-\ RS",
"55492020", "Chapecó\ \-\ SC",
"55343814", "Patos\ de\ Minas\ \-\ MG",
"55143408", "Marília\ \-\ SP",
"55823279", "Boca\ da\ Mata\ \-\ AL",
"55143291", "Domélia\ \-\ SP",
"55663511", "Sinop\ \-\ MT",
"55853322", "Ocara\ \-\ CE",
"55173548", "Marapoama\ \-\ SP",
"55433444", "Arapuã\ \-\ PR",
"55543280", "Pedras\ Brancas\ \-\ RS",
"55143604", "Barra\ Bonita\ \-\ SP",
"55353261", "Campanha\ \-\ MG",
"55733676", "Barrolândia\ \-\ BA",
"55113158", "São\ Paulo\ \-\ SP",
"55123221", "Caçapava\ \-\ SP",
"55813339", "Recife\ \-\ PE",
"55242263", "Paraíba\ do\ Sul\ \-\ RJ",
"55623592", "Goiânia\ \-\ GO",
"55543457", "Monte\ Belo\ do\ Sul\ \-\ RS",
"55693534", "Alto\ Paraíso\ \-\ RO",
"55713003", "Salvador\ \-\ BA",
"55313542", "Nova\ Lima\ \-\ MG",
"55913771", "Mosqueiro\ \-\ PA",
"5535323", "Três\ Corações\ \-\ MG",
"55513064", "Sapiranga\ \-\ RS",
"55513394", "Rio\ Grande\ do\ Sul",
"55843422", "Mossoró\ \-\ RN",
"55643522", "Itumbiara\ \-\ GO",
"55283521", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55243322", "Barra\ Mansa\ \-\ RJ",
"55313751", "Entre\ Rios\ de\ Minas\ \-\ MG",
"55163253", "Taquaritinga\ \-\ SP",
"55353411", "São\ Sebastião\ do\ Paraíso\ \-\ MG",
"55733282", "Santa\ Cruz\ Cabrália\ \-\ BA",
"55643607", "Itumbiara\ \-\ GO",
"55833369", "Arara\ \-\ PB",
"55833099", "Campina\ Grande\ \-\ PB",
"55833317", "Galante\ \-\ PB",
"55413585", "Curitiba\ \-\ PR",
"55413033", "Pinhais\ \-\ PR",
"55413586", "São\ José\ dos\ Pinhais\ \-\ PR",
"55653928", "Cuiabá\ \-\ MT",
"55513479", "Nova\ Santa\ Rita\ \-\ RS",
"55483413", "Criciúma\ \-\ SC",
"55473001", "Joinville\ \-\ SC",
"55353375", "Dom\ Viçoso\ \-\ MG",
"55613634", "Padre\ Bernardo\ \-\ GO",
"55114886", "Itu\ \-\ SP",
"55543531", "Paim\ Filho\ \-\ RS",
"55913275", "Ananindeua\ \-\ PA",
"55173349", "Turvínia\ \-\ SP",
"55853302", "Apuiarés\ \-\ CE",
"55542521", "Bento\ Gonçalves\ \-\ RS",
"55513443", "Alvorada\ \-\ RS",
"55413292", "Campo\ Largo\ \-\ PR",
"55513730", "Passo\ do\ Sobrado\ \-\ RS",
"55443259", "Maringá\ \-\ PR",
"55823556", "Feliz\ Deserto\ \-\ AL",
"55163851", "Morro\ Agudo\ \-\ SP",
"55413973", "Rio\ Branco\ do\ Sul\ \-\ PR",
"55613381", "Guará\ \-\ DF",
"55333355", "Iapu\ \-\ MG",
"55112503", "São\ Paulo\ \-\ SP",
"55893462", "Oeiras\ \-\ PI",
"55413442", "Guaratuba\ \-\ PR",
"55883655", "Frecheirinha\ \-\ CE",
"55673443", "Batayporã\ \-\ MS",
"55813217", "Recife\ \-\ PE",
"55833437", "Cajazeirinhas\ \-\ PB",
"55883656", "Graça\ \-\ CE",
"55473048", "Itajaí\ \-\ SC",
"55483333", "Florianópolis\ \-\ SC",
"55543287", "Vila\ Cristina\ \-\ RS",
"55163957", "Ibitiúva\ \-\ SP",
"55333356", "São\ João\ do\ Oriente\ \-\ MG",
"55313378", "Belo\ Horizonte\ \-\ MG",
"55513270", "Rio\ Grande\ do\ Sul",
"55823555", "São\ Brás\ \-\ AL",
"55623455", "Povoado\ de\ São\ Jorge\ \-\ GO",
"55483262", "Governador\ Celso\ Ramos\ \-\ SC",
"55163354", "Guarapiranga\ \-\ SP",
"55914107", "Ananindeua\ \-\ PA",
"55673479", "Sete\ Quedas\ \-\ MS",
"55773624", "Riachão\ das\ Neves\ \-\ BA",
"55333738", "Francisco\ Badaró\ \-\ MG",
"55433062", "Cambé\ \-\ PR",
"55193882", "Cosmópolis\ \-\ SP",
"55513032", "Canoas\ \-\ RS",
"55173521", "Catanduva\ \-\ SP",
"55114783", "Embu\ das\ Artes\ \-\ SP",
"55623456", "Divinópolis\ de\ Goiás\ \-\ GO",
"55173274", "Tanabi\ \-\ SP",
"5568322", "Rio\ Branco\ \-\ AC",
"55213792", "Duque\ de\ Caxias\ \-\ RJ",
"55132101", "Santos\ \-\ SP",
"55633451", "Rio\ Sono\ \-\ TO",
"55883449", "Senador\ Pompeu\ \-\ CE",
"55353834", "Aguanil\ \-\ MG",
"55853323", "Tejuçuoca\ \-\ CE",
"55113305", "São\ Paulo\ \-\ SP",
"55753247", "Irará\ \-\ BA",
"55483525", "Turvo\ \-\ SC",
"55643620", "Rio\ Verde\ \-\ GO",
"55323351", "Barroso\ \-\ MG",
"55813269", "Recife\ \-\ PE",
"55493249", "Campo\ Belo\ do\ Sul\ \-\ SC",
"55423625", "Entre\ Rios\ \-\ PR",
"55353331", "São\ Lourenço\ \-\ MG",
"5516361", "Ribeirão\ Preto\ \-\ SP",
"55483526", "Balneário\ Arroio\ do\ Silva\ \-\ SC",
"55733283", "Camacã\ \-\ BA",
"55122126", "Pindamonhangaba\ \-\ SP",
"55513737", "Rio\ Grande\ do\ Sul",
"55743548", "Pindobaçu\ \-\ BA",
"55163252", "Taquaritinga\ \-\ SP",
"55313579", "Aranha\ \-\ MG",
"55613906", "Luziânia\ \-\ GO",
"55243323", "Barra\ Mansa\ \-\ RJ",
"55753656", "Glória\ \-\ BA",
"55983622", "Bacabal\ \-\ MA",
"55122125", "Taubaté\ \-\ SP",
"55843423", "Jardim\ de\ Piranhas\ \-\ RN",
"55983391", "Cururupu\ \-\ MA",
"55112523", "São\ Paulo\ \-\ SP",
"55443576", "Águas\ de\ Jurema\ \-\ PR",
"55213896", "Duque\ de\ Caxias\ \-\ RJ",
"55313543", "Raposos\ \-\ MG",
"55143441", "Tupã\ \-\ SP",
"55623593", "Goiânia\ \-\ GO",
"55213895", "Rio\ de\ Janeiro\ \-\ RJ",
"55813419", "Recife\ \-\ PE",
"55833310", "Campina\ Grande\ \-\ PB",
"55343431", "Prata\ \-\ MG",
"55443575", "Roncador\ \-\ PR",
"55353863", "Santo\ Antônio\ do\ Amparo\ \-\ MG",
"55673292", "Rio\ Verde\ de\ Mato\ Grosso\ \-\ MS",
"55513442", "Alvorada\ \-\ RS",
"55493447", "Ouro\ Verde\ \-\ SC",
"55653046", "Cuiabá\ \-\ MT",
"55112336", "São\ Paulo\ \-\ SP",
"55112335", "São\ Paulo\ \-\ SP",
"55453029", "Foz\ do\ Iguaçu\ \-\ PR",
"55473634", "São\ Bento\ do\ Sul\ \-\ SC",
"55753449", "Conde\ \-\ BA",
"55553511", "Santa\ Rosa\ \-\ RS",
"55314113", "Sete\ Lagoas\ \-\ MG",
"55863258", "Monsenhor\ Gil\ \-\ PI",
"55823344", "Maceió\ \-\ AL",
"55994102", "Imperatriz\ \-\ MA",
"55313768", "Contagem\ \-\ MG",
"553139", "Minas\ Gerais",
"55413032", "Campo\ Largo\ \-\ PR",
"55673033", "Dourados\ \-\ MS",
"55613567", "Guará\ \-\ DF",
"55423219", "Ponta\ Grossa\ \-\ PR",
"55273385", "Serra\ \-\ ES",
"55283548", "Irupi\ \-\ ES",
"55213097", "Teresópolis\ \-\ RJ",
"55413584", "Curitiba\ \-\ PR",
"55183282", "Teodoro\ Sampaio\ \-\ SP",
"55313254", "Belo\ Horizonte\ \-\ MG",
"55373241", "Itaúna\ \-\ MG",
"55863297", "Agricolândia\ \-\ PI",
"55653314", "Cuiabá\ \-\ MT",
"55993621", "Bacabal\ \-\ MA",
"55613636", "Cabeceiras\ \-\ GO",
"55143417", "Marília\ \-\ SP",
"55793348", "Japoatã\ \-\ SE",
"55863122", "Teresina\ \-\ PI",
"55473307", "Jaraguá\ do\ Sul\ \-\ SC",
"55693536", "Ariquemes\ \-\ RO",
"55212633", "Magé\ \-\ RJ",
"55513066", "Novo\ Hamburgo\ \-\ RS",
"55513396", "Rio\ Grande\ do\ Sul",
"55162138", "Ribeirão\ Preto\ \-\ SP",
"55323753", "Miradouro\ \-\ MG",
"55443248", "Iguaraçu\ \-\ PR",
"55112772", "São\ Paulo\ \-\ SP",
"55513065", "Novo\ Hamburgo\ \-\ RS",
"55483236", "Florianópolis\ \-\ SC",
"55913521", "Paragominas\ \-\ PA",
"55353733", "Ibitiúra\ de\ Minas\ \-\ MG",
"55433035", "Cambé\ \-\ PR",
"55114662", "Embu\-Guaçu\ \-\ SP",
"55693535", "Ariquemes\ \-\ RO",
"55333253", "Belo\ Oriente\ \-\ MG",
"55893435", "Francisco\ Macedo\ \-\ PI",
"55193903", "Sumaré\ \-\ SP",
"55313838", "Santa\ Maria\ de\ Itabira\ \-\ MG",
"55114021", "Salto\ \-\ SP",
"5511369", "Osasco\ \-\ SP",
"55833088", "Campina\ Grande\ \-\ PB",
"55893436", "Alegrete\ do\ Piauí\ \-\ PI",
"55473904", "Itapema\ \-\ SC",
"55312109", "Ipatinga\ \-\ MG",
"55993601", "Feira\ Nova\ do\ Maranhão\ \-\ MA",
"55653212", "Lucas\ do\ Rio\ Verde\ \-\ MT",
"55663599", "Guariba\ \-\ MT",
"55343816", "Lagoa\ Grande\ \-\ MG",
"55542105", "Bento\ Gonçalves\ \-\ RS",
"55114519", "Mauá\ \-\ SP",
"55533035", "Rio\ Grande\ \-\ RS",
"55473087", "Brusque\ \-\ SC",
"55173832", "General\ Salgado\ \-\ SP",
"55623661", "Goiânia\ \-\ GO",
"55923363", "Manaquiri\ \-\ AM",
"55542106", "Erechim\ \-\ RS",
"55213520", "Rio\ de\ Janeiro\ \-\ RJ",
"55833308", "Santo\ André\ \-\ PB",
"55733674", "Barra\ de\ Caravelas\ \-\ BA",
"55633429", "Muricilândia\ \-\ TO",
"55793549", "Poço\ Verde\ \-\ SE",
"5521329", "Rio\ de\ Janeiro\ \-\ RJ",
"55212882", "Nova\ Iguaçu\ \-\ RJ",
"55663540", "União\ do\ Sul\ \-\ MT",
"55112876", "Carapicuíba\ \-\ SP",
"5583324", "João\ Pessoa\ \-\ PB",
"55533931", "Rio\ Grande\ \-\ RS",
"55643681", "Firminópolis\ \-\ GO",
"55853667", "Itarema\ \-\ CE",
"55133302", "Praia\ Grande\ \-\ SP",
"55513584", "Novo\ Hamburgo\ \-\ RS",
"55463213", "Pato\ Branco\ \-\ PR",
"55133224", "Santos\ \-\ SP",
"55353297", "Alfenas\ \-\ MG",
"55212664", "Japeri\ \-\ RJ",
"55623382", "Fazenda\ Nova\ \-\ GO",
"55713649", "Camaçari\ \-\ BA",
"55813745", "Riacho\ das\ Almas\ \-\ PE",
"55112618", "São\ Paulo\ \-\ SP",
"55163829", "Ituverava\ \-\ SP",
"55873838", "Afogados\ da\ Ingazeira\ \-\ PE",
"55753211", "Feira\ de\ Santana\ \-\ BA",
"55813746", "Jataúba\ \-\ PE",
"55322152", "Juiz\ de\ Fora\ \-\ MG",
"55143267", "Borebi\ \-\ SP",
"55983367", "Humberto\ de\ Campos\ \-\ MA",
"55713286", "Salvador\ \-\ BA",
"55813879", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55713285", "Salvador\ \-\ BA",
"55473635", "São\ Bento\ do\ Sul\ \-\ SC",
"55693322", "Vilhena\ \-\ RO",
"55112334", "São\ Paulo\ \-\ SP",
"55173361", "Monte\ Azul\ Paulista\ \-\ SP",
"55743559", "Pindobaçu\ \-\ BA",
"55114048", "Diadema\ \-\ SP",
"55823346", "Maceió\ \-\ AL",
"55473300", "Rio\ do\ Sul\ \-\ SC",
"55112831", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55183283", "Euclides\ da\ Cunha\ Paulista\ \-\ SP",
"55313729", "Minas\ Gerais",
"55513958", "Charqueadas\ \-\ RS",
"55753654", "Brejões\ \-\ BA",
"55323541", "Ubá\ \-\ MG",
"55863249", "São\ Miguel\ do\ Tapuio\ \-\ PI",
"55183631", "Araçatuba\ \-\ SP",
"55242271", "Sapucaia\ \-\ RJ",
"55153551", "Ribeirão\ Branco\ \-\ SP",
"55122124", "Lorena\ \-\ SP",
"55833341", "Campina\ Grande\ \-\ PB",
"55613591", "Sobradinho\ \-\ DF",
"55283559", "Dores\ do\ Rio\ Preto\ \-\ ES",
"55193902", "Holambra\ \-\ SP",
"55373228", "Nova\ Serrana\ \-\ MG",
"55133323", "Santos\ \-\ SP",
"55444003", "Maringá\ \-\ PR",
"55333252", "Joanésia\ \-\ MG",
"55114663", "Embu\-Guaçu\ \-\ SP",
"55353732", "Ipuiúna\ \-\ MG",
"55813491", "Olinda\ \-\ PE",
"55112773", "São\ Paulo\ \-\ SP",
"55863273", "Curralinhos\ \-\ PI",
"55514104", "Canoas\ \-\ RS",
"55993648", "Bernardo\ do\ Mearim\ \-\ MA",
"55212632", "Guapimirim\ \-\ RJ",
"55613307", "Brasília\ \-\ DF",
"55682102", "Rio\ Branco\ \-\ AC",
"55173275", "Monte\ Aprazível\ \-\ SP",
"55173276", "Engenheiro\ Balduíno\ \-\ SP",
"55113907", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55353835", "Cristais\ \-\ MG",
"55544003", "Caxias\ do\ Sul\ \-\ RS",
"55193665", "Mococa\ \-\ SP",
"55443201", "Campo\ Mourão\ \-\ PR",
"55923362", "Careiro\ \-\ AM",
"55173833", "Estrela\ D\'Oeste\ \-\ SP",
"55483524", "Araranguá\ \-\ SC",
"55113304", "São\ Paulo\ \-\ SP",
"55313611", "Viçosa\ \-\ MG",
"55693302", "Porto\ Velho\ \-\ RO",
"55353273", "Jesuânia\ \-\ MG",
"55473059", "São\ Bento\ do\ Sul\ \-\ SC",
"55883654", "Mucambo\ \-\ CE",
"55913734", "Quatro\ Bocas\ \-\ PA",
"5551379", "Rio\ Grande\ do\ Sul",
"55453540", "São\ Miguel\ do\ Iguaçu\ \-\ PR",
"55213602", "Niterói\ \-\ RJ",
"55333354", "Bom\ Jesus\ do\ Galho\ \-\ MG",
"55663547", "Tapurah\ \-\ MT",
"55383757", "Joaquim\ Felício\ \-\ MG",
"55823554", "Igreja\ Nova\ \-\ AL",
"55483271", "Florianópolis\ \-\ SC",
"55773417", "Guajeru\ \-\ BA",
"55493258", "Cerro\ Negro\ \-\ SC",
"55473080", "Blumenau\ \-\ SC",
"55773625", "Santa\ Rita\ de\ Cássia\ \-\ BA",
"55923681", "Manaus\ \-\ AM",
"55172136", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55623383", "Britânia\ \-\ GO",
"55113565", "São\ Caetano\ do\ Sul\ \-\ SP",
"55173587", "Palmares\ Paulista\ \-\ SP",
"55553643", "Boa\ Vista\ do\ Cadeado\ \-\ RS",
"55893471", "Várzea\ Grande\ \-\ PI",
"55773626", "Wanderley\ \-\ BA",
"55114634", "Poá\ \-\ SP",
"55222674", "Araruama\ \-\ RJ",
"55943382", "Sapucaia\ \-\ PA",
"55193031", "Campinas\ \-\ SP",
"55443273", "Ivatuba\ \-\ PR",
"55823482", "Arapiraca\ \-\ AL",
"55143664", "Itapuí\ \-\ SP",
"55312108", "Belo\ Horizonte\ \-\ MG",
"55313246", "Minas\ Gerais",
"55733292", "Teixeira\ de\ Freitas\ \-\ BA",
"55313245", "Belo\ Horizonte\ \-\ MG",
"55613603", "Luziânia\ \-\ GO",
"55313839", "Itabira\ \-\ MG",
"55133416", "Ana\ Dias\ \-\ SP",
"55513453", "Rio\ Grande\ do\ Sul",
"55443249", "Lobato\ \-\ PR",
"55173359", "Colômbia\ \-\ SP",
"55353694", "Lavras\ \-\ MG",
"55883112", "Sobral\ \-\ CE",
"55353822", "Lavras\ \-\ MG",
"55623582", "Goiânia\ \-\ GO",
"55123862", "São\ Sebastião\ \-\ SP",
"55223022", "Itaperuna\ \-\ RJ",
"55114895", "Nazaré\ Paulista\ \-\ SP",
"55922101", "Manaus\ \-\ AM",
"55423903", "União\ da\ Vitória\ \-\ PR",
"55242223", "Petrópolis\ \-\ RJ",
"55413282", "São\ José\ dos\ Pinhais\ \-\ PR",
"55115787", "São\ Paulo\ \-\ SP",
"55793349", "Porto\ da\ Folha\ \-\ SE",
"55193936", "Indaiatuba\ \-\ SP",
"55513676", "Arambaré\ \-\ RS",
"55313552", "Ouro\ Preto\ \-\ MG",
"55193935", "Indaiatuba\ \-\ SP",
"55513675", "Cerro\ Grande\ do\ Sul\ \-\ RS",
"55543447", "Vila\ Flores\ \-\ RS",
"55733277", "Guaratinga\ \-\ BA",
"55663399", "Campo\ Verde\ \-\ MT",
"55143882", "Botucatu\ \-\ SP",
"55313741", "Ouro\ Branco\ \-\ MG",
"55163243", "Monte\ Alto\ \-\ SP",
"55443123", "Maringá\ \-\ PR",
"55483203", "Florianópolis\ \-\ SC",
"55274104", "Cariacica\ \-\ ES",
"55123411", "Taubaté\ \-\ SP",
"55463055", "Francisco\ Beltrão\ \-\ PR",
"55114230", "Itupeva\ \-\ SP",
"55413676", "Campina\ Grande\ do\ Sul\ \-\ PR",
"55873839", "Alagoinha\ \-\ PE",
"55913692", "Gurupá\ \-\ PA",
"55484001", "Florianópolis\ \-\ SC",
"55553347", "Santa\ Maria\ \-\ RS",
"55413675", "Colombo\ \-\ PR",
"55853092", "Fortaleza\ \-\ CE",
"55853362", "Aquiraz\ \-\ CE",
"55753289", "Pedro\ Alexandre\ \-\ BA",
"55773451", "Guanambi\ \-\ BA",
"55713444", "Salvador\ \-\ BA",
"55443447", "Alto\ Paraná\ \-\ PR",
"55624103", "Aparecida\ de\ Goiânia\ \-\ GO",
"55823253", "Novo\ Lino\ \-\ AL",
"55312128", "Belo\ Horizonte\ \-\ MG",
"55713648", "Dias\ d\'Ávila\ \-\ BA",
"55513596", "Novo\ Hamburgo\ \-\ RS",
"55543037", "Carlos\ Barbosa\ \-\ RS",
"55993577", "Parnarama\ \-\ MA",
"55433454", "Cruzmaltina\ \-\ PR",
"55115691", "São\ Paulo\ \-\ SP",
"55353221", "Varginha\ \-\ MG",
"55513595", "Novo\ Hamburgo\ \-\ RS",
"55193893", "Pedreira\ \-\ SP",
"55473622", "Canoinhas\ \-\ SC",
"55613623", "Luziânia\ \-\ GO",
"55543273", "Nova\ Bassano\ \-\ RS",
"55973412", "Tabatinga\ \-\ AM",
"55693523", "Theobroma\ \-\ RO",
"55163014", "Araraquara\ \-\ SP",
"55633428", "Araguanã\ \-\ TO",
"55643667", "Arenópolis\ \-\ GO",
"55833309", "São\ José\ dos\ Cordeiros\ \-\ PB",
"55543290", "Caxias\ do\ Sul\ \-\ RS",
"55793548", "Santa\ Luzia\ do\ Itanhy\ \-\ SE",
"55383216", "Montes\ Claros\ \-\ MG",
"55413384", "São\ José\ dos\ Pinhais\ \-\ PR",
"55923534", "Nhamundá\ \-\ AM",
"55114777", "Cotia\ \-\ SP",
"55114518", "Mauá\ \-\ SP",
"55613500", "Brasília\ \-\ DF",
"55413453", "Matinhos\ \-\ PR",
"55673452", "Rio\ Brilhante\ \-\ MS",
"55922121", "Manaus\ \-\ AM",
"55143281", "Bauru\ \-\ SP",
"55923131", "Manaus\ \-\ AM",
"55143218", "Bauru\ \-\ SP",
"55993592", "Açailândia\ \-\ MA",
"55123863", "Maresias\ \-\ SP",
"55353823", "Itumirim\ \-\ MG",
"55623583", "Goiânia\ \-\ GO",
"55993649", "Peritoró\ \-\ MA",
"55113365", "São\ Paulo\ \-\ SP",
"55193408", "Americana\ \-\ SP",
"55653055", "Cuiabá\ \-\ MT",
"55493457", "Presidente\ Castelo\ Branco\ \-\ SC",
"55983381", "Pinheiro\ \-\ MA",
"55742102", "Juazeiro\ \-\ BA",
"55513452", "Sapucaia\ do\ Sul\ \-\ RS",
"55733270", "Itabela\ \-\ BA",
"55283558", "Jerônimo\ Monteiro\ \-\ ES",
"55242566", "Bom\ Jardim\ \-\ RJ",
"55813616", "Goiana\ \-\ PE",
"55543733", "Caxias\ do\ Sul\ \-\ RS",
"55373229", "Divinópolis\ \-\ MG",
"55173826", "Uchoa\ \-\ SP",
"55513959", "Sapiranga\ \-\ RS",
"55733293", "Alcobaça\ \-\ BA",
"55313728", "Buarque\ de\ Macedo\ \-\ MG",
"55853334", "Cascavel\ \-\ CE",
"55862106", "Teresina\ \-\ PI",
"55443272", "Fênix\ \-\ PR",
"55483084", "Florianópolis\ \-\ SC",
"55863248", "Buriti\ dos\ Montes\ \-\ PI",
"55114049", "Diadema\ \-\ SP",
"55273065", "Serra\ \-\ ES",
"55273395", "Vitória\ \-\ ES",
"55483324", "Florianópolis\ \-\ SC",
"55893515", "Floriano\ \-\ PI",
"5561202", "Brasília\ \-\ DF",
"55753646", "Guaibim\ \-\ BA",
"55483202", "Florianópolis\ \-\ SC",
"5561303", "Brasília\ \-\ DF",
"55443122", "Maringá\ \-\ PR",
"55623931", "Goiânia\ \-\ GO",
"55163242", "Monte\ Alto\ \-\ SP",
"55713601", "Candeias\ \-\ BA",
"55643563", "Jandaia\ \-\ GO",
"55543374", "Ibiaçá\ \-\ RS",
"55143883", "Bofete\ \-\ SP",
"55673596", "Cassilândia\ \-\ MS",
"55642101", "Rio\ Verde\ \-\ GO",
"55683231", "Bujari\ \-\ AC",
"55282102", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55453017", "Foz\ do\ Iguaçu\ \-\ PR",
"55693416", "Ji\-Paraná\ \-\ RO",
"55193796", "Campinas\ \-\ SP",
"55483821", "Florianópolis\ \-\ SC",
"55313553", "Cachoeira\ do\ Campo\ \-\ MG",
"55193795", "Campinas\ \-\ SP",
"55143451", "Marília\ \-\ SP",
"55413283", "São\ José\ dos\ Pinhais\ \-\ PR",
"55493531", "Videira\ \-\ SC",
"55473520", "Rio\ do\ Sul\ \-\ SC",
"55242222", "Petrópolis\ \-\ RJ",
"55423902", "Guarapuava\ \-\ PR",
"55613622", "Luziânia\ \-\ GO",
"55473623", "Três\ Barras\ \-\ SC",
"55193892", "Serra\ Negra\ \-\ SP",
"55193624", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55823252", "Joaquim\ Gomes\ \-\ AL",
"55123834", "Ubatuba\ \-\ SP",
"55543297", "Flores\ da\ Cunha\ \-\ RS",
"55853363", "Paraipaba\ \-\ CE",
"55143632", "Dois\ Córregos\ \-\ SP",
"55673675", "Tacuru\ \-\ MS",
"55323341", "Ressaquinha\ \-\ MG",
"55213194", "Rio\ de\ Janeiro\ \-\ RJ",
"5561344", "Brasília\ \-\ DF",
"55613391", "Brazlândia\ \-\ DF",
"55673676", "Nova\ Andradina\ \-\ MS",
"55753257", "Bessa\ \-\ BA",
"55513283", "Novo\ Hamburgo\ \-\ RS",
"55163947", "Sertãozinho\ \-\ SP",
"55273181", "Vitória\ \-\ ES",
"55433661", "Alvorada\ do\ Sul\ \-\ PR",
"55643534", "Itumbiara\ \-\ GO",
"55893422", "Picos\ \-\ PI",
"55883646", "Cariré\ \-\ CE",
"55513631", "Escadinhas\ \-\ RS",
"55843638", "Rio\ do\ Fogo\ \-\ RN",
"55243334", "Rio\ Claro\ \-\ RJ",
"55193877", "Artur\ Nogueira\ \-\ SP",
"55673453", "Caarapó\ \-\ MS",
"55883645", "Coreaú\ \-\ CE",
"55413452", "Matinhos\ \-\ PR",
"55773468", "Mirante\ \-\ BA",
"55333345", "Chalé\ \-\ MG",
"55533284", "Pelotas\ \-\ RS",
"55623446", "Alto\ Paraíso\ de\ Goiás\ \-\ GO",
"55443440", "Inajá\ \-\ PR",
"55773664", "Paratinga\ \-\ BA",
"55352106", "Varginha\ \-\ MG",
"55184104", "Birigui\ \-\ SP",
"55443685", "Nova\ Olímpia\ \-\ PR",
"55553816", "Condor\ \-\ RS",
"55352105", "Varginha\ \-\ MG",
"55443686", "Palotina\ \-\ PR",
"55923667", "Manaus\ \-\ AM",
"55713621", "Camaçari\ \-\ BA",
"55543272", "Guabiju\ \-\ RS",
"55843434", "Santana\ do\ Matos\ \-\ RN",
"55613966", "Brasília\ \-\ DF",
"55623445", "Damianópolis\ \-\ GO",
"55793274", "Rosário\ do\ Catete\ \-\ SE",
"55173561", "Novais\ \-\ SP",
"55163344", "Ribeirão\ Bonito\ \-\ SP",
"55343322", "Uberaba\ \-\ MG",
"555130", "Rio\ Grande\ do\ Sul",
"55193841", "Mogi\-Guaçu\ \-\ SP",
"55623099", "Anápolis\ \-\ GO",
"55833285", "Gurinhém\ \-\ PB",
"55115643", "São\ Paulo\ \-\ SP",
"55163877", "Ribeirão\ Preto\ \-\ SP",
"55453336", "Luz\ Marina\ \-\ PR",
"55383521", "Itamarandiba\ \-\ MG",
"55413614", "Araucária\ \-\ PR",
"55473379", "Massaranduba\ \-\ SC",
"55814007", "Recife\ \-\ PE",
"55883533", "Campos\ Sales\ \-\ CE",
"55883085", "Juazeiro\ do\ Norte\ \-\ CE",
"55313049", "Contagem\ \-\ MG",
"55833286", "Caaporã\ \-\ PB",
"55543435", "Boa\ Vista\ do\ Sul\ \-\ RS",
"55753161", "Feira\ de\ Santana\ \-\ BA",
"55273744", "Governador\ Lindenberg\ \-\ ES",
"55982109", "São\ Luís\ \-\ MA",
"55663522", "São\ Félix\ do\ Araguaia\ \-\ MT",
"55153022", "Tatuí\ \-\ SP",
"55843261", "Maxaranguape\ \-\ RN",
"55313090", "Belo\ Horizonte\ \-\ MG",
"55443045", "Paranavaí\ \-\ PR",
"55473343", "Ilhota\ \-\ SC",
"55343691", "Araxá\ \-\ MG",
"55613013", "Brasília\ \-\ DF",
"55112350", "Poá\ \-\ SP",
"55193493", "Rio\ das\ Pedras\ \-\ SP",
"55212016", "Rio\ de\ Janeiro\ \-\ RJ",
"5511415", "Santana\ de\ Parnaíba\ \-\ SP",
"55163075", "Ribeirão\ Preto\ \-\ SP",
"55773483", "Santa\ Maria\ da\ Vitória\ \-\ BA",
"55873793", "Calçado\ \-\ PE",
"5571349", "Salvador\ \-\ BA",
"55633477", "Itaguatins\ \-\ TO",
"55115068", "São\ Paulo\ \-\ SP",
"55313237", "Belo\ Horizonte\ \-\ MG",
"55633014", "Palmas\ \-\ TO",
"55913424", "Redenção\ \-\ PA",
"55333625", "Serra\ dos\ Aimorés\ \-\ MG",
"55823218", "Maceió\ \-\ AL",
"55743669", "Várzea\ da\ Roça\ \-\ BA",
"55433351", "Londrina\ \-\ PR",
"55173513", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55823281", "União\ dos\ Palmares\ \-\ AL",
"55683214", "Rio\ Branco\ \-\ AC",
"55333626", "Santa\ Helena\ de\ Minas\ \-\ MG",
"55973461", "Santo\ Antônio\ do\ Içá\ \-\ AM",
"55733208", "Nova\ Viçosa\ \-\ BA",
"55853475", "Caucaia\ \-\ CE",
"55533613", "Pedras\ Altas\ \-\ RS",
"55323294", "Bocaina\ de\ Minas\ \-\ MG",
"55883564", "Cedro\ \-\ CE",
"55433145", "Bandeirantes\ \-\ PR",
"55333267", "Aimorés\ \-\ MG",
"55644141", "Itumbiara\ \-\ GO",
"55673251", "Jardim\ \-\ MS",
"55183217", "Presidente\ Prudente\ \-\ SP",
"55114496", "Itupeva\ \-\ SP",
"55843376", "Viçosa\ \-\ RN",
"55653695", "Várzea\ Grande\ \-\ MT",
"5567", "Mato\ Grosso\ do\ Sul",
"55553523", "Padre\ Gonzales\ \-\ RS",
"55663415", "Ribeirãozinho\ \-\ MT",
"55663416", "General\ Carneiro\ \-\ MT",
"55683464", "Jordão\ \-\ AC",
"55114495", "Itatiba\ \-\ SP",
"55843375", "Taboleiro\ Grande\ \-\ RN",
"55114708", "Mairinque\ \-\ SP",
"55553336", "Catuípe\ \-\ RS",
"55243388", "Resende\ \-\ RJ",
"55193556", "Cordeirópolis\ \-\ SP",
"55643588", "Itumbiara\ \-\ GO",
"55443436", "Itaúna\ do\ Sul\ \-\ PR",
"55443435", "Planaltina\ do\ Paraná\ \-\ PR",
"55193555", "Leme\ \-\ SP",
"55553335", "Eugênio\ de\ Castro\ \-\ RS",
"55513614", "Maratá\ \-\ RS",
"55183269", "Pirapozinho\ \-\ SP",
"55424009", "Ponta\ Grossa\ \-\ PR",
"55883630", "Miraíma\ \-\ CE",
"55753325", "Iaçu\ \-\ BA",
"55543045", "Passo\ Fundo\ \-\ RS",
"55163604", "Ribeirão\ Preto\ \-\ SP",
"55313439", "Minas\ Gerais",
"55533238", "São\ José\ do\ Norte\ \-\ RS",
"55153284", "Cerquilho\ \-\ SP",
"55823530", "Arapiraca\ \-\ AL",
"55843488", "Cerro\ Corá\ \-\ RN",
"55744400", "Pilão\ Arcado\ \-\ BA",
"55113449", "Osasco\ \-\ SP",
"55513481", "Eldorado\ do\ Sul\ \-\ RS",
"55753326", "Boa\ Vista\ do\ Tupim\ \-\ BA",
"55983352", "Vitória\ do\ Mearim\ \-\ MA",
"55543046", "Passo\ Fundo\ \-\ RS",
"55483644", "Laguna\ \-\ SC",
"55313896", "Pedra\ do\ Anta\ \-\ MG",
"55673481", "Amambaí\ \-\ MS",
"55213543", "Rio\ de\ Janeiro\ \-\ RJ",
"55453266", "Céu\ Azul\ \-\ PR",
"55613012", "Brasília\ \-\ DF",
"55653259", "Vila\ Bela\ da\ Santíssima\ Trindade\ \-\ MT",
"55143252", "Pederneiras\ \-\ SP",
"55473342", "Navegantes\ \-\ SC",
"55183913", "Montalvão\ \-\ SP",
"55793711", "Aracaju\ \-\ SE",
"55533517", "Pelotas\ \-\ RS",
"55513756", "Anta\ Gorda\ \-\ RS",
"55513755", "Muçum\ \-\ RS",
"55323393", "Senhora\ das\ Dores\ \-\ MG",
"55663523", "Nova\ Santa\ Helena\ \-\ MT",
"55893498", "Lagoa\ do\ Barro\ do\ Piauí\ \-\ PI",
"55123157", "Lorena\ \-\ SP",
"55673418", "Itaum\ \-\ MS",
"55313895", "Teixeiras\ \-\ MG",
"55633470", "Santa\ Fé\ do\ Araguaia\ \-\ TO",
"55943369", "Parauapebas\ \-\ PA",
"55313230", "Minas\ Gerais",
"55843331", "Açu\ \-\ RN",
"55193477", "Americana\ \-\ SP",
"55883532", "Barbalha\ \-\ CE",
"55633493", "Palmeirante\ \-\ TO",
"55113240", "Salvador\ \-\ BA",
"55115642", "São\ Paulo\ \-\ SP",
"55973458", "Pauini\ \-\ AM",
"55823632", "Olivença\ \-\ AL",
"55343323", "Veríssimo\ \-\ MG",
"55483298", "Florianópolis\ \-\ SC",
"55273269", "Alfredo\ Chaves\ \-\ ES",
"55643954", "Itumbiara\ \-\ GO",
"55143546", "Sabino\ \-\ SP",
"55543908", "Vacaria\ \-\ RS",
"55173512", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55633344", "Carrasco\ Bonito\ \-\ TO",
"55114246", "Mairinque\ \-\ SP",
"55193828", "Sumaré\ \-\ SP",
"55153383", "Laranjal\ Paulista\ \-\ SP",
"55173405", "Votuporanga\ \-\ SP",
"55843258", "São\ Tomé\ \-\ RN",
"55873792", "Terezinha\ \-\ PE",
"55793215", "Aracaju\ \-\ SE",
"55323444", "Recreio\ \-\ MG",
"55993541", "Balsas\ \-\ MA",
"55413539", "Campo\ Largo\ \-\ PR",
"55193492", "Capivari\ \-\ SP",
"55543471", "Dois\ Lajeados\ \-\ RS",
"55133347", "Guarujá\ \-\ SP",
"55933515", "Altamira\ \-\ PA",
"55813478", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55833456", "Pedra\ Branca\ \-\ PB",
"55183744", "Nova\ Independência\ \-\ SP",
"55272144", "Vila\ Velha\ \-\ ES",
"55823537", "Campo\ Grande\ \-\ AL",
"55733241", "Coaraci\ \-\ BA",
"55553522", "Três\ Passos\ \-\ RS",
"5541", "Paraná",
"55963697", "Chaves\ \-\ PA",
"55833455", "Santana\ de\ Mangueira\ \-\ PB",
"55883637", "Reriutaba\ \-\ CE",
"55242401", "Barra\ do\ Piraí\ \-\ RJ",
"55313581", "Nova\ Lima\ \-\ MG",
"55114657", "Santa\ Isabel\ \-\ SP",
"55953625", "Boa\ Vista\ \-\ RR",
"55143354", "Botucatu\ \-\ SP",
"5571324", "Salvador\ \-\ BA",
"55152107", "Porto\ Feliz\ \-\ SP",
"55313184", "Itaguara\ \-\ MG",
"55953626", "Boa\ Vista\ \-\ RR",
"55793465", "São\ Miguel\ do\ Aleixo\ \-\ SE",
"55513539", "Novo\ Hamburgo\ \-\ RS",
"55663503", "Brianorte\ \-\ MT",
"55433569", "Pinhalão\ \-\ PR",
"55613578", "Brasília\ \-\ DF",
"55613717", "Brasília\ \-\ DF",
"55153003", "Sorocaba\ \-\ SP",
"55213699", "Queimados\ \-\ RJ",
"55893574", "Curimatá\ \-\ PI",
"55983353", "Apicum\-Açu\ \-\ MA",
"55943779", "Goianésia\ do\ Pará\ \-\ PA",
"55423278", "Imbaú\ \-\ PR",
"55983484", "Afonso\ Cunha\ \-\ MA",
"55553266", "Nova\ Palma\ \-\ RS",
"55623551", "Bela\ Vista\ de\ Goiás\ \-\ GO",
"55553265", "Agudo\ \-\ RS",
"55173426", "Votuporanga\ \-\ SP",
"55653531", "Sinop\ \-\ MT",
"55673268", "Bodoquena\ \-\ MS",
"55114138", "Taboão\ da\ Serra\ \-\ SP",
"55873964", "Serrolândia\ \-\ PE",
"55193808", "Amparo\ \-\ SP",
"55693474", "Castanheiras\ \-\ RO",
"55193129", "Vinhedo\ \-\ SP",
"55223854", "Santo\ Antônio\ de\ Pádua\ \-\ RJ",
"55213485", "Rio\ de\ Janeiro\ \-\ RJ",
"55115816", "São\ Paulo\ \-\ SP",
"55883412", "Quixadá\ \-\ CE",
"55483247", "São\ José\ \-\ SC",
"55733209", "Posto\ da\ Mata\ \-\ BA",
"55273755", "Ecoporanga\ \-\ ES",
"55273756", "Barra\ de\ São\ Francisco\ \-\ ES",
"55643653", "Gouvelândia\ \-\ GO",
"55943351", "Palestina\ do\ Pará\ \-\ PA",
"55433047", "Apucarana\ \-\ PR",
"55813032", "Recife\ \-\ PE",
"55663571", "Colniza\ \-\ MT",
"55753526", "Maragogipe\ \-\ BA",
"55212868", "Rio\ de\ Janeiro\ \-\ RJ",
"55743668", "João\ Dourado\ \-\ BA",
"55553536", "Alegria\ \-\ RS",
"55623612", "Goiânia\ \-\ GO",
"55112653", "São\ Paulo\ \-\ SP",
"55112814", "Itaquaquecetuba\ \-\ SP",
"55893447", "São\ José\ do\ Piauí\ \-\ PI",
"55653261", "Araputanga\ \-\ MT",
"55733616", "Itabuna\ \-\ BA",
"55553535", "Três\ de\ Maio\ \-\ RS",
"55313663", "Pedro\ Leopoldo\ \-\ MG",
"55843287", "Lagoa\ D\'Anta\ \-\ RN",
"55163665", "Altinópolis\ \-\ SP",
"55483039", "Florianópolis\ \-\ SC",
"5527", "Espirito\ Santo",
"55443423", "Paranavaí\ \-\ PR",
"55753262", "Conceição\ do\ Coité\ \-\ BA",
"55163666", "Santa\ Cruz\ da\ Esperança\ \-\ SP",
"55123111", "Cunha\ \-\ SP",
"55823267", "Coqueiro\ Seco\ \-\ AL",
"55643475", "Três\ Ranchos\ \-\ GO",
"55343415", "Iturama\ \-\ MG",
"55663302", "Rondonópolis\ \-\ MT",
"55313048", "Belo\ Horizonte\ \-\ MG",
"55863315", "Parnaíba\ \-\ PI",
"55913466", "Marudá\ \-\ PA",
"55623098", "Anápolis\ \-\ GO",
"55273251", "Serra\ \-\ ES",
"55833294", "Itapororoca\ \-\ PB",
"55883525", "Antonina\ do\ Norte\ \-\ CE",
"55113448", "Osasco\ \-\ SP",
"55833377", "Dona\ Inês\ \-\ PB",
"55453323", "Cascavel\ \-\ PR",
"55163902", "Ribeirão\ Preto\ \-\ SP",
"55433551", "Ribeirão\ do\ Pinhal\ \-\ PR",
"55823626", "Poço\ das\ Trincheiras\ \-\ AL",
"55383677", "Unaí\ \-\ MG",
"55313438", "Minas\ Gerais",
"55823625", "Maravilha\ \-\ AL",
"55533310", "Pelotas\ \-\ RS",
"55433154", "Cambé\ \-\ PR",
"55383081", "Montes\ Claros\ \-\ MG",
"55623517", "Goiânia\ \-\ GO",
"55883526", "Saboeiro\ \-\ CE",
"55323577", "Rodeiro\ \-\ MG",
"55693642", "São\ Miguel\ do\ Guaporé\ \-\ RO",
"55343265", "Cachoeira\ Dourada\ \-\ MG",
"55313634", "Santa\ Luzia\ \-\ MG",
"55163409", "Franca\ \-\ SP",
"55423242", "Ipiranga\ \-\ PR",
"55843696", "Caiçara\ do\ Norte\ \-\ RN",
"5531328", "Belo\ Horizonte\ \-\ MG",
"55183268", "Nantes\ \-\ SP",
"55813737", "Bonito\ \-\ PE",
"55953537", "São\ Luiz\ \-\ RR",
"55243389", "Barra\ Mansa\ \-\ RJ",
"55173651", "Palmeira\ D\'Oeste\ \-\ SP",
"55133398", "Guarujá\ \-\ SP",
"55843695", "Lagoa\ de\ Velhos\ \-\ RN",
"55343266", "Canápolis\ \-\ MG",
"55653376", "Nobres\ \-\ MT",
"55193544", "Araras\ \-\ SP",
"55114484", "Mairiporã\ \-\ SP",
"55383824", "Rio\ Pardo\ de\ Minas\ \-\ MG",
"55194009", "Campinas\ \-\ SP",
"55833392", "Queimadas\ \-\ PB",
"55913711", "Castanhal\ \-\ PA",
"55793641", "Riachão\ do\ Dantas\ \-\ SE",
"55473543", "Rio\ do\ Oeste\ \-\ SC",
"55553303", "Cruz\ Alta\ \-\ RS",
"55863198", "Teresina\ \-\ PI",
"55323286", "Santo\ Antônio\ do\ Aventureiro\ \-\ MG",
"55513467", "Canoas\ \-\ RS",
"55483655", "Sangão\ \-\ SC",
"55433437", "Novo\ Itacolomi\ \-\ PR",
"55753364", "Iraquara\ \-\ BA",
"55714111", "Camaçari\ \-\ BA",
"55383321", "Montes\ Claros\ \-\ MG",
"55353471", "Santa\ Rita\ do\ Sapucaí\ \-\ MG",
"55543054", "Caxias\ do\ Sul\ \-\ RS",
"55483656", "Sangão\ \-\ SC",
"55114688", "Barueri\ \-\ SP",
"55323285", "Chiador\ \-\ MG",
"55313662", "Pedro\ Leopoldo\ \-\ MG",
"55513744", "Ibarama\ \-\ RS",
"55613486", "Brasília\ \-\ DF",
"55673467", "Fátima\ do\ Sul\ \-\ MS",
"55923311", "Cacau\ Pirêra\ \-\ AM",
"55112652", "São\ Paulo\ \-\ SP",
"55613485", "Sobradinho\ \-\ DF",
"55823260", "Marechal\ Deodoro\ \-\ AL",
"55843259", "Barcelona\ \-\ RN",
"5521261", "Niterói\ \-\ RJ",
"55813127", "Recife\ \-\ PE",
"55813033", "Recife\ \-\ PE",
"55643652", "Cristianópolis\ \-\ GO",
"55193829", "Valinhos\ \-\ SP",
"55623351", "Campos\ Verdes\ \-\ GO",
"5531345", "Belo\ Horizonte\ \-\ MG",
"55273268", "Domingos\ Martins\ \-\ ES",
"55653331", "Barão\ de\ Melgaço\ \-\ MT",
"55883413", "Fortim\ \-\ CE",
"55313381", "Belo\ Horizonte\ \-\ MG",
"55633355", "Miranorte\ \-\ TO",
"55493434", "Vargeão\ \-\ SC",
"55643946", "Itumbiara\ \-\ GO",
"55753332", "Palmeiras\ \-\ BA",
"55143554", "Cafelândia\ \-\ SP",
"55713508", "Lauro\ de\ Freitas\ \-\ BA",
"55893440", "Ipiranga\ do\ Piauí\ \-\ PI",
"55643945", "Itumbiara\ \-\ GO",
"55513210", "Rio\ Grande\ do\ Sul",
"55473647", "Mafra\ \-\ SC",
"55633356", "Peixe\ \-\ TO",
"55743651", "Capim\ Grosso\ \-\ BA",
"55313318", "Belo\ Horizonte\ \-\ MG",
"55853357", "General\ Sampaio\ \-\ CE",
"55893499", "Bela\ Vista\ do\ Piauí\ \-\ PI",
"55313884", "Minas\ Gerais",
"55353435", "Extrema\ \-\ MG",
"55823337", "Maceió\ \-\ AL",
"55673419", "Angélica\ \-\ MS",
"55553322", "Cruz\ Alta\ \-\ RS",
"55353436", "Toledo\ \-\ MG",
"55753263", "Valente\ \-\ BA",
"55443422", "Paranavaí\ \-\ PR",
"55923028", "Manaus\ \-\ AM",
"55193809", "Hortolândia\ \-\ SP",
"55663535", "Sinop\ \-\ MT",
"55833444", "São\ Bento\ \-\ PB",
"55983689", "Zé\ Doca\ \-\ MA",
"55192138", "Campinas\ \-\ SP",
"55243357", "Resende\ \-\ RJ",
"55423243", "Ponta\ Grossa\ \-\ PR",
"55663536", "Marcelândia\ \-\ MT",
"55513460", "Esteio\ \-\ RS",
"55693643", "Alto\ Alegre\ dos\ Parecis\ \-\ RO",
"55173043", "Barretos\ \-\ SP",
"5519375", "Campinas\ \-\ SP",
"55143346", "Bernardino\ de\ Campos\ \-\ SP",
"55673269", "Guia\ Lopes\ da\ Laguna\ \-\ MS",
"55173312", "Barretos\ \-\ SP",
"55343336", "Uberaba\ \-\ MG",
"55473255", "Brusque\ \-\ SC",
"55453322", "Cascavel\ \-\ PR",
"55753413", "Esplanada\ \-\ BA",
"55634009", "Palmas\ \-\ TO",
"55943778", "Vila\ Residencial\ de\ Tucuruí\ \-\ PA",
"55513538", "Canoas\ \-\ RS",
"55843531", "Angicos\ \-\ RN",
"55313519", "Belo\ Horizonte\ \-\ MG",
"55373277", "Leandro\ Ferreira\ \-\ MG",
"55553224", "Silveira\ Martins\ \-\ RS",
"55813972", "Recife\ \-\ PE",
"55553302", "Santa\ Maria\ \-\ RS",
"55113421", "Mauá\ \-\ SP",
"55753234", "Nova\ Fátima\ \-\ BA",
"55473542", "Agronômica\ \-\ SC",
"55183251", "Presidente\ Epitácio\ \-\ SP",
"55833063", "Campina\ Grande\ \-\ PB",
"55833393", "Fagundes\ \-\ PB",
"55963621", "Laranjal\ do\ Jari\ \-\ AP",
"55654062", "Cuiabá\ \-\ MT",
"55643431", "Itumbiara\ \-\ GO",
"55873884", "São\ José\ do\ Belmonte\ \-\ PE",
"55833370", "Caiçara\ \-\ PB",
"5513342", "Itanhaém\ \-\ SP",
"55353462", "Estiva\ \-\ MG",
"55653102", "Nobres\ \-\ MT",
"55383825", "Montezuma\ \-\ MG",
"55993317", "Timon\ \-\ MA",
"55193545", "Santa\ Gertrudes\ \-\ SP",
"55114485", "Mairiporã\ \-\ SP",
"55213138", "Rio\ de\ Janeiro\ \-\ RJ",
"55112712", "São\ Paulo\ \-\ SP",
"55193546", "Cordeirópolis\ \-\ SP",
"55114486", "Terra\ Preta\ \-\ SP",
"55733268", "Porto\ Seguro\ \-\ BA",
"55863212", "Timon\ \-\ MA",
"55183229", "Presidente\ Prudente\ \-\ SP",
"55543056", "Farroupilha\ \-\ RS",
"55483654", "Santa\ Rosa\ de\ Lima\ \-\ SC",
"55143492", "Vera\ Cruz\ \-\ SP",
"5512364", "Pindamonhangaba\ \-\ SP",
"55983013", "São\ Luís\ \-\ MA",
"55114699", "Mogi\ das\ Cruzes\ \-\ SP",
"55323284", "Belmiro\ Braga\ \-\ MG",
"55553748", "Erval\ Seco\ \-\ RS",
"55423554", "Cruz\ Machado\ \-\ PR",
"55543055", "Bento\ Gonçalves\ \-\ RS",
"55153294", "Ibiúna\ \-\ SP",
"55143014", "Bauru\ \-\ SP",
"55513491", "Guaíba\ \-\ RS",
"55673241", "Aquidauana\ \-\ MS",
"55433156", "Rolândia\ \-\ PR",
"55883524", "Aiuaba\ \-\ CE",
"55323727", "Barão\ de\ Monte\ Alto\ \-\ MG",
"55552101", "Santa\ Maria\ \-\ RS",
"55623528", "Caturaí\ \-\ GO",
"55493316", "Chapecó\ \-\ SC",
"55443639", "Umuarama\ \-\ PR",
"55823624", "Pão\ de\ Açúcar\ \-\ AL",
"55553563", "São\ Paulo\ das\ Missões\ \-\ RS",
"55343264", "Gurinhatã\ \-\ MG",
"55653374", "Cangas\ \-\ MT",
"55843694", "Monte\ das\ Gameleiras\ \-\ RN",
"55143477", "Arco\-Íris\ \-\ SP",
"55242458", "Rio\ das\ Flores\ \-\ RJ",
"55163664", "Brodowski\ \-\ SP",
"55452101", "Cascavel\ \-\ PR",
"55643678", "Israelândia\ \-\ GO",
"55313080", "Belo\ Horizonte\ \-\ MG",
"55212108", "Rio\ de\ Janeiro\ \-\ RJ",
"55913464", "Atalaia\ \-\ PA",
"55743629", "Barro\ Alto\ \-\ BA",
"55343414", "Contagem\ \-\ MG",
"558532", "Fortaleza\ \-\ CE",
"55833296", "Baía\ da\ Traição\ \-\ PB",
"55643474", "Orizona\ \-\ GO",
"55753271", "Euclides\ da\ Cunha\ \-\ BA",
"55623089", "Goiânia\ \-\ GO",
"55213839", "Rio\ de\ Janeiro\ \-\ RJ",
"55833295", "Jacaraú\ \-\ PB",
"55113113", "São\ Paulo\ \-\ SP",
"55353212", "Varginha\ \-\ MG",
"55823291", "Barra\ de\ Santo\ Antônio\ \-\ AL",
"55273754", "Montanha\ \-\ ES",
"55143279", "Tibiriçá\ \-\ SP",
"55383561", "João\ Pinheiro\ \-\ MG",
"55493908", "Fraiburgo\ \-\ SC",
"55493198", "Maravilha\ \-\ SC",
"55193851", "Mogi\-Guaçu\ \-\ SP",
"55213552", "Duque\ de\ Caxias\ \-\ RJ",
"55313320", "Ipaba\ \-\ MG",
"55843221", "Natal\ \-\ RN",
"55443056", "Umuarama\ \-\ PR",
"5571348", "Salvador\ \-\ BA",
"55773470", "Rio\ do\ Antônio\ \-\ BA",
"55153392", "Itapetininga\ \-\ SP",
"55663562", "Santa\ Carmem\ \-\ MT",
"55613352", "Taguatinga\ \-\ DF",
"55473353", "Apiúna\ \-\ SC",
"55383722", "Curvelo\ \-\ MG",
"55193483", "São\ Pedro\ \-\ SP",
"55382103", "Montes\ Claros\ \-\ MG",
"55223308", "São\ Pedro\ da\ Aldeia\ \-\ RJ",
"55553534", "Doutor\ Maurício\ Cardoso\ \-\ RS",
"55443055", "Umuarama\ \-\ PR",
"55773493", "Guanambi\ \-\ BA",
"55873783", "Caetés\ \-\ PE",
"55313194", "Belo\ Horizonte\ \-\ MG",
"55623541", "Goiânia\ \-\ GO",
"55173465", "Fernandópolis\ \-\ SP",
"55983012", "São\ Luís\ \-\ MA",
"55173466", "Cardoso\ \-\ SP",
"55854117", "Maracanaú\ \-\ CE",
"55143493", "Varpa\ \-\ SP",
"55223844", "Porciúncula\ \-\ RJ",
"55195657", "São\ Paulo\ \-\ SP",
"55873886", "Verdejante\ \-\ PE",
"55753235", "Candeal\ \-\ BA",
"55873885", "Mirandiba\ \-\ PE",
"55753236", "Santa\ Bárbara\ \-\ BA",
"55353463", "Bueno\ Brandão\ \-\ MG",
"55833445", "Paulista\ \-\ PB",
"55343831", "Patrocínio\ \-\ MG",
"55943309", "Cumaru\ do\ Norte\ \-\ PA",
"55533011", "Pelotas\ \-\ RS",
"55663534", "Terra\ Nova\ do\ Norte\ \-\ MT",
"55143841", "São\ Manuel\ \-\ SP",
"55483461", "Criciúma\ \-\ SC",
"55733251", "Itacaré\ \-\ BA",
"5573", "Bahia",
"55732011", "Teixeira\ de\ Freitas\ \-\ BA",
"55453206", "Agro\ Cafeeira\ \-\ PR",
"5571325", "Salvador\ \-\ BA",
"55143344", "Ipaussu\ \-\ SP",
"55433529", "Jacarezinho\ \-\ PR",
"55323003", "Juiz\ de\ Fora\ \-\ MG",
"55633483", "Bom\ Jesus\ do\ Tocantins\ \-\ TO",
"55713612", "Salvador\ \-\ BA",
"55113112", "São\ Paulo\ \-\ SP",
"55493435", "Ponte\ Serrada\ \-\ SC",
"55273229", "Vila\ Velha\ \-\ ES",
"55433011", "Arapongas\ \-\ PR",
"55633354", "Cristalândia\ \-\ TO",
"55733539", "Itagi\ \-\ BA",
"55114256", "Suzano\ \-\ SP",
"55313327", "Belo\ Horizonte\ \-\ MG",
"55114255", "Mogi\ das\ Cruzes\ \-\ SP",
"55773477", "Lagoa\ Real\ \-\ BA",
"55483211", "Florianópolis\ \-\ SC",
"55493436", "Faxinal\ dos\ Guedes\ \-\ SC",
"55112347", "São\ Paulo\ \-\ SP",
"55193868", "Estiva\ Gerbi\ \-\ SP",
"55143556", "Cafelândia\ \-\ SP",
"55993551", "São\ João\ dos\ Patos\ \-\ MA",
"55353434", "Itapeva\ \-\ MG",
"55893488", "Jacobina\ do\ Piauí\ \-\ PI",
"55313885", "Viçosa\ \-\ MG",
"55313886", "Diogo\ de\ Vasconcelos\ \-\ MG",
"55843248", "Senador\ Georgino\ Avelino\ \-\ RN",
"55463272", "Pato\ Branco\ \-\ PR",
"5521315", "Rio\ de\ Janeiro\ \-\ RJ",
"55833035", "João\ Pessoa\ \-\ PB",
"55873782", "Saloá\ \-\ PE",
"55853051", "Fortaleza\ \-\ CE",
"55115041", "São\ Paulo\ \-\ SP",
"55773492", "Presidente\ Jânio\ Quadros\ \-\ BA",
"55513745", "Segredo\ \-\ RS",
"55382102", "Unaí\ \-\ MG",
"55193482", "Águas\ de\ São\ Pedro\ \-\ SP",
"55343232", "Uberlândia\ \-\ MG",
"55383723", "Inimutaba\ \-\ MG",
"55123147", "Queluz\ \-\ SP",
"55473352", "Presidente\ Getúlio\ \-\ SC",
"55613353", "Taguatinga\ \-\ DF",
"55663563", "Paranaíta\ \-\ MT",
"55513746", "Rio\ Grande\ do\ Sul",
"55213553", "Rio\ de\ Janeiro\ \-\ RJ",
"55114751", "Suzano\ \-\ SP",
"55662101", "Rondonópolis\ \-\ MT",
"55653273", "Curvelândia\ \-\ MT",
"55313520", "Minas\ Gerais",
"55513616", "Rio\ Grande\ do\ Sul",
"55613552", "Núcleo\ Bandeirante\ \-\ DF",
"55793651", "Salgado\ \-\ SE",
"55553334", "Augusto\ Pestana\ \-\ RS",
"55513615", "Caraá\ \-\ RS",
"55193554", "Leme\ \-\ SP",
"5531329", "Minas\ Gerais",
"55114012", "Bom\ Jesus\ dos\ Perdões\ \-\ SP",
"55513427", "Canoas\ \-\ RS",
"55153286", "Jumirim\ \-\ SP",
"55623529", "Brazabrantes\ \-\ GO",
"55793313", "Feira\ Nova\ \-\ SE",
"55163605", "Ribeirão\ Preto\ \-\ SP",
"55753202", "Retirolândia\ \-\ BA",
"55483646", "Laguna\ \-\ SC",
"55483645", "Armazém\ \-\ SC",
"55813452", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"5511331", "São\ Paulo\ \-\ SP",
"55112599", "São\ Paulo\ \-\ SP",
"55333291", "Coroaci\ \-\ MG",
"55153285", "Tietê\ \-\ SP",
"55242257", "Areal\ \-\ RJ",
"55883565", "Acopiara\ \-\ CE",
"55483952", "Florianópolis\ \-\ SC",
"55323295", "Passa\-Vinte\ \-\ MG",
"55323296", "Arantina\ \-\ MG",
"55433541", "Uraí\ \-\ PR",
"55883566", "Juazeiro\ do\ Norte\ \-\ CE",
"55153577", "Barra\ do\ Turvo\ \-\ SP",
"55733269", "Ilhéus\ \-\ BA",
"55833382", "Juazeirinho\ \-\ PB",
"55213139", "Rio\ de\ Janeiro\ \-\ RJ",
"55653694", "Várzea\ Grande\ \-\ MT",
"55173641", "Santa\ Fé\ do\ Sul\ \-\ SP",
"55113654", "Osasco\ \-\ SP",
"55143108", "Bauru\ \-\ SP",
"55114494", "Atibaia\ \-\ SP",
"55843374", "Riacho\ da\ Cruz\ \-\ RN",
"55774009", "Vitória\ da\ Conquista\ \-\ BA",
"55453232", "Guaraniaçu\ \-\ PR",
"55913798", "Pacajá\ \-\ PA",
"55423252", "Palmeira\ \-\ PR",
"55443463", "Paranacity\ \-\ PR",
"55553363", "São\ Nicolau\ \-\ RS",
"55843297", "Japi\ \-\ RN",
"55513407", "Porto\ Alegre\ \-\ RS",
"551122", "São\ Paulo\ \-\ SP",
"55333428", "Santo\ Antônio\ do\ Itambé\ \-\ MG",
"55383833", "Jaíba\ \-\ MG",
"55893531", "Canto\ do\ Buriti\ \-\ PI",
"55993569", "Senador\ Alexandre\ Costa\ \-\ MA",
"55513229", "Rio\ Grande\ do\ Sul",
"55913617", "Cotijuba\ \-\ PA",
"55683216", "Rio\ Branco\ \-\ AC",
"55114578", "Mauá\ \-\ SP",
"55333624", "Carlos\ Chagas\ \-\ MG",
"55654003", "Cuiabá\ \-\ MT",
"55913425", "Bragança\ \-\ PA",
"55493199", "Chapecó\ \-\ SC",
"55633015", "Palmas\ \-\ TO",
"55143278", "Lençóis\ Paulista\ \-\ SP",
"556432", "Itumbiara\ \-\ GO",
"55982016", "São\ Luís\ \-\ MA",
"55553232", "São\ Gabriel\ \-\ RS",
"55623088", "Goiânia\ \-\ GO",
"55823177", "Maceió\ \-\ AL",
"55833284", "Caldas\ Brandão\ \-\ PB",
"55643643", "Porteirão\ \-\ GO",
"55273746", "Alto\ Rio\ Novo\ \-\ ES",
"55943341", "Bom\ Jesus\ do\ Tocantins\ \-\ PA",
"55543434", "Silva\ Jardim\ \-\ RS",
"55273745", "Águia\ Branca\ \-\ ES",
"55843272", "Parnamirim\ \-\ RN",
"55793432", "Itabaiana\ \-\ SE",
"55743628", "Piritiba\ \-\ BA",
"55483257", "São\ José\ \-\ SC",
"55813631", "Timbaúba\ \-\ PE",
"55193345", "Campinas\ \-\ SP",
"55643679", "Sanclerlândia\ \-\ GO",
"55115029", "São\ Paulo\ \-\ SP",
"55112643", "São\ Paulo\ \-\ SP",
"55513179", "Taquara\ \-\ RS",
"55653221", "Cáceres\ \-\ MT",
"55893457", "Jaicós\ \-\ PI",
"55542628", "Farroupilha\ \-\ RS",
"55313623", "São\ José\ da\ Lapa\ \-\ MG",
"55983485", "Água\ Doce\ do\ Maranhão\ \-\ MA",
"55353857", "Campo\ do\ Meio\ \-\ MG",
"55213688", "Rio\ de\ Janeiro\ \-\ RJ",
"55433528", "Wenceslau\ Braz\ \-\ PR",
"55893575", "Avelino\ Lopes\ \-\ PI",
"55553797", "Novo\ Tiradentes\ \-\ RS",
"55813453", "Recife\ \-\ PE",
"55753203", "Jeremoabo\ \-\ BA",
"55893576", "Cristalândia\ do\ Piauí\ \-\ PI",
"55213611", "São\ Gonçalo\ \-\ RJ",
"55383231", "Brasília\ de\ Minas\ \-\ MG",
"55873966", "Exu\ \-\ PE",
"55114013", "Itu\ \-\ SP",
"55613553", "Brasília\ \-\ DF",
"55213484", "Rio\ de\ Janeiro\ \-\ RJ",
"5513346", "São\ Vicente\ \-\ SP",
"55163934", "Ribeirão\ Preto\ \-\ SP",
"55643547", "Indiara\ \-\ GO",
"55933514", "Brasil\ Novo\ \-\ PA",
"55183745", "Itapura\ \-\ SP",
"55453233", "Campo\ Bonito\ \-\ PR",
"55983378", "Pedro\ do\ Rosário\ \-\ MA",
"55833454", "Ibiara\ \-\ PB",
"55183746", "Pereira\ Barreto\ \-\ SP",
"55513420", "Rio\ Grande\ do\ Sul",
"55833383", "Soledade\ \-\ PB",
"55143355", "Manduri\ \-\ SP",
"55813676", "Tamandaré\ \-\ PE",
"55693311", "Cacoal\ \-\ RO",
"55993613", "Grajaú\ \-\ MA",
"55953624", "Boa\ Vista\ \-\ RR",
"55633554", "Taquarussu\ do\ Porto\ \-\ TO",
"55313527", "Minas\ Gerais",
"55483953", "Florianópolis\ \-\ SC",
"55543462", "Garibaldi\ \-\ RS",
"55112547", "São\ Paulo\ \-\ SP",
"55143356", "Manduri\ \-\ SP",
"55813675", "Barreiros\ \-\ PE",
"55553233", "São\ Sepé\ \-\ RS",
"55743641", "Irecê\ \-\ BA",
"55193911", "Mogi\-Guaçu\ \-\ SP",
"55893450", "Francisco\ Santos\ \-\ PI",
"55343131", "Uberlândia\ \-\ MG",
"55943328", "Núcleo\ Carajás\ \-\ PA",
"55643956", "Itumbiara\ \-\ GO",
"55193817", "Amparo\ \-\ SP",
"55613689", "Formosa\ \-\ GO",
"55713040", "Camaçari\ \-\ BA",
"55144009", "Bauru\ \-\ SP",
"55373384", "Itaguara\ \-\ MG",
"55323446", "Palma\ \-\ MG",
"55713369", "Lauro\ de\ Freitas\ \-\ BA",
"55383832", "São\ João\ do\ Paraíso\ \-\ MG",
"55973473", "São\ Gabriel\ da\ Cachoeira\ \-\ AM",
"55553362", "Dezesseis\ de\ Novembro\ \-\ RS",
"55853347", "Baturité\ \-\ CE",
"55323445", "Argirita\ \-\ MG",
"55612141", "Brasília\ \-\ DF",
"55183842", "Junqueirópolis\ \-\ SP",
"55443462", "Querência\ do\ Norte\ \-\ PR",
"55793214", "Aracaju\ \-\ SE",
"55313622", "Vespasiano\ \-\ MG",
"55193016", "Indaiatuba\ \-\ SP",
"55843249", "Espírito\ Santo\ \-\ RN",
"55112642", "São\ Paulo\ \-\ SP",
"55893489", "Conceição\ do\ Canindé\ \-\ PI",
"55313894", "Araponga\ \-\ MG",
"55453264", "Medianeira\ \-\ PR",
"55553414", "Uruguaiana\ \-\ RS",
"55242487", "Avelar\ \-\ RJ",
"55643051", "Rio\ Verde\ \-\ GO",
"55513754", "Imigrante\ \-\ RS",
"55313507", "Belo\ Horizonte\ \-\ MG",
"55843273", "São\ José\ de\ Mipibu\ \-\ RN",
"55623341", "Goianápolis\ \-\ GO",
"55193869", "Valinhos\ \-\ SP",
"55643642", "Turvelândia\ \-\ GO",
"55313391", "Contagem\ \-\ MG",
"55313061", "Conselheiro\ Lafaiete\ \-\ MG",
"55513400", "Rio\ Grande\ do\ Sul",
"55733538", "Itiruçu\ \-\ BA",
"55633362", "Dois\ Irmãos\ do\ Tocantins\ \-\ TO",
"5553330", "Pelotas\ \-\ RS",
"55133219", "Santos\ \-\ SP",
"55113439", "Santo\ André\ \-\ SP",
"55493592", "Tangará\ \-\ SC",
"55543036", "Gramado\ \-\ RS",
"55513597", "Campo\ Bom\ \-\ RS",
"55993576", "Matões\ \-\ MA",
"55353284", "Serrania\ \-\ MG",
"55883640", "Alcântaras\ \-\ CE",
"55993575", "Graça\ Aranha\ \-\ MA",
"55313449", "Belo\ Horizonte\ \-\ MG",
"55543035", "Farroupilha\ \-\ RS",
"55112429", "Itu\ \-\ SP",
"55333340", "Governador\ Valadares\ \-\ MG",
"55533248", "Pinheiro\ Machado\ \-\ RS",
"55163311", "Araraquara\ \-\ SP",
"55443445", "São\ João\ do\ Caiuá\ \-\ PR",
"55313490", "Minas\ Gerais",
"55323462", "Além\ Paraíba\ \-\ MG",
"55743674", "Lajes\ do\ Batata\ \-\ BA",
"55413677", "Campo\ Magro\ \-\ PR",
"55413081", "São\ José\ dos\ Pinhais\ \-\ PR",
"55633233", "Palmas\ \-\ TO",
"55733682", "Teixeira\ de\ Freitas\ \-\ BA",
"55853877", "Fortaleza\ \-\ CE",
"55483438", "Criciúma\ \-\ SC",
"55443446", "Paranavaí\ \-\ PR",
"55183866", "Flora\ Rica\ \-\ SP",
"55383217", "Montes\ Claros\ \-\ MG",
"55143224", "Bauru\ \-\ SP",
"55163475", "Sertãozinho\ \-\ SP",
"55323314", "Juiz\ de\ Fora\ \-\ MG",
"55143302", "Ourinhos\ \-\ SP",
"55193363", "Paulínia\ \-\ SP",
"55623374", "Itapirapuã\ \-\ GO",
"55123601", "Taubaté\ \-\ SP",
"55183994", "Emilianópolis\ \-\ SP",
"55114524", "Itatiba\ \-\ SP",
"55473364", "Dona\ Emma\ \-\ SC",
"55114775", "Itapecerica\ da\ Serra\ \-\ SP",
"55222735", "Campos\ dos\ Goytacazes\ \-\ RJ",
"5543332", "Londrina\ \-\ PR",
"55643665", "Piranhas\ \-\ GO",
"55613234", "Guará\ \-\ DF",
"55443659", "Altônia\ \-\ PR",
"55643666", "Portelândia\ \-\ GO",
"55973391", "Tapauá\ \-\ AM",
"55273763", "São\ Mateus\ \-\ ES",
"55714062", "Salvador\ \-\ BA",
"55193749", "Campinas\ \-\ SP",
"55913119", "Belém\ \-\ PA",
"55843328", "Governador\ Dix\-Sept\ Rosado\ \-\ RN",
"55373513", "Pompéu\ \-\ MG",
"55223201", "Araruama\ \-\ RJ",
"55183274", "Teçaindá\ \-\ SP",
"55512", "Rio\ Grande\ do\ Sul",
"55243076", "Volta\ Redonda\ \-\ RJ",
"55273373", "Linhares\ \-\ ES",
"55753699", "Saubara\ \-\ BA",
"55123974", "Paraibuna\ \-\ SP",
"55242438", "Conservatória\ \-\ RJ",
"55222580", "Nova\ Friburgo\ \-\ RJ",
"55663015", "Sinop\ \-\ MT",
"55193773", "Campinas\ \-\ SP",
"55532125", "Rio\ Grande\ \-\ RS",
"55313247", "Belo\ Horizonte\ \-\ MG",
"55114096", "São\ Paulo\ \-\ SP",
"55473525", "Rio\ do\ Sul\ \-\ SC",
"55532126", "Rio\ Grande\ \-\ RS",
"55422101", "Ponta\ Grossa\ \-\ PR",
"55513692", "Camaquã\ \-\ RS",
"55674004", "Campo\ Grande\ \-\ MS",
"55663016", "Primavera\ do\ Leste\ \-\ MT",
"55112784", "São\ Paulo\ \-\ SP",
"55463057", "Francisco\ Beltrão\ \-\ PR",
"55883579", "Quixelô\ \-\ CE",
"55613332", "Recanto\ das\ Emas\ \-\ DF",
"55473333", "Indaial\ \-\ SC",
"55863284", "Barro\ Duro\ \-\ PI",
"55353022", "Pouso\ Alegre\ \-\ MG",
"55432105", "Londrina\ \-\ PR",
"55553554", "Miraguaí\ \-\ RS",
"55453345", "Portão\ Ocoi\ \-\ PR",
"55143322", "Ourinhos\ \-\ SP",
"55513018", "Porto\ Alegre\ \-\ RS",
"55653329", "Tangará\ da\ Serra\ \-\ MT",
"55843011", "Natal\ \-\ RN",
"55883543", "Aurora\ \-\ CE",
"55543445", "Fagundes\ Varela\ \-\ RS",
"55313039", "Timóteo\ \-\ MG",
"55193937", "Jaguariúna\ \-\ SP",
"55513677", "Dom\ Feliciano\ \-\ RS",
"55183521", "Adamantina\ \-\ SP",
"55613263", "Brasília\ \-\ DF",
"55543446", "Cotiporã\ \-\ RS",
"55193831", "Mogi\-Guaçu\ \-\ SP",
"55823643", "Olho\ d\'Água\ do\ Casado\ \-\ AL",
"55114897", "Itu\ \-\ SP",
"55733276", "Apuarema\ \-\ BA",
"55453346", "São\ João\ d\'Oeste\ \-\ PR",
"55222559", "São\ Sebastião\ do\ Alto\ \-\ RJ",
"55183373", "Tarumã\ \-\ SP",
"55314138", "Vespasiano\ \-\ MG",
"55543296", "Nova\ Pádua\ \-\ RS",
"55213630", "Magé\ \-\ RJ",
"55733683", "Guarani\ \-\ BA",
"55112923", "Jundiaí\ \-\ SP",
"55633232", "Palmas\ \-\ TO",
"55313472", "Minas\ Gerais",
"55423667", "Inácio\ Martins\ \-\ PR",
"55114148", "Cotia\ \-\ SP",
"55983304", "São\ Luís\ \-\ MA",
"55553015", "Santa\ Maria\ \-\ RS",
"55323463", "Volta\ Grande\ \-\ MG",
"55753256", "Tucano\ \-\ BA",
"55543295", "Gramado\ \-\ RS",
"55173807", "Ubarana\ \-\ SP",
"55613505", "Luziânia\ \-\ GO",
"55183349", "Frutal\ do\ Campo\ \-\ SP",
"55653541", "Colíder\ \-\ MT",
"55373425", "Luz\ \-\ MG",
"5511267", "São\ Paulo\ \-\ SP",
"55163041", "Sertãozinho\ \-\ SP",
"55193681", "São\ José\ do\ Rio\ Pardo\ \-\ SP",
"55813512", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55373426", "Campos\ Altos\ \-\ MG",
"55773691", "Malhada\ \-\ BA",
"55833639", "Riachão\ \-\ PB",
"55633363", "Porto\ Nacional\ \-\ TO",
"55613506", "Brasília\ \-\ DF",
"55113581", "Barueri\ \-\ SP",
"55513549", "Igrejinha\ \-\ RS",
"55273762", "Conceição\ da\ Barra\ \-\ ES",
"55352107", "Poços\ de\ Caldas\ \-\ MG",
"55343354", "Santa\ Juliana\ \-\ MG",
"55473234", "Blumenau\ \-\ SC",
"55863383", "Esperantina\ \-\ PI",
"55113184", "Osasco\ \-\ SP",
"55443687", "Maripá\ \-\ PR",
"55113518", "São\ Paulo\ \-\ SP",
"5571323", "Salvador\ \-\ BA",
"55163946", "Sertãozinho\ \-\ SP",
"55613364", "Brasília\ \-\ DF",
"55222106", "Macaé\ \-\ RJ",
"55383744", "Jequitaí\ \-\ MG",
"55663554", "Vila\ Rica\ \-\ MT",
"55883647", "Groaíras\ \-\ CE",
"55123034", "Caraguatatuba\ \-\ SP",
"55343851", "Carmo\ do\ Paranaíba\ \-\ MG",
"55193875", "Indaiatuba\ \-\ SP",
"55513590", "São\ Leopoldo\ \-\ RS",
"55193362", "Mogi\-Guaçu\ \-\ SP",
"55143303", "Marília\ \-\ SP",
"55193876", "Vinhedo\ \-\ SP",
"55222105", "Macaé\ \-\ RJ",
"55483906", "Tubarão\ \-\ SC",
"55163945", "Sertãozinho\ \-\ SP",
"55733231", "Ilhéus\ \-\ BA",
"55513693", "Rio\ Grande\ do\ Sul",
"55373405", "Arcos\ \-\ MG",
"55813078", "Recife\ \-\ PE",
"55993531", "Estreito\ \-\ MA",
"55313714", "Paraopeba\ \-\ MG",
"55113964", "Jundiaí\ \-\ SP",
"55613525", "Brasília\ \-\ DF",
"55893569", "Santa\ Filomena\ \-\ PI",
"55353454", "Espírito\ Santo\ do\ Dourado\ \-\ MG",
"55173827", "Potirendaba\ \-\ SP",
"55613526", "Brasília\ \-\ DF",
"55114873", "São\ Paulo\ \-\ SP",
"55513670", "Amaral\ Ferrador\ \-\ RS",
"55193772", "Campinas\ \-\ SP",
"55862107", "Teresina\ \-\ PI",
"55273372", "Linhares\ \-\ ES",
"55143535", "Pompéia\ \-\ SP",
"55413573", "Curitiba\ \-\ PR",
"55493455", "Alto\ Bela\ Vista\ \-\ SC",
"55173386", "Pirangi\ \-\ SP",
"55373512", "Divinópolis\ \-\ MG",
"55653057", "Cuiabá\ \-\ MT",
"55493456", "Campina\ da\ Alegria\ \-\ SC",
"55113367", "São\ Paulo\ \-\ SP",
"55983324", "Centro\ Novo\ do\ Maranhão\ \-\ MA",
"55413590", "Piraquara\ \-\ PR",
"55713261", "Salvador\ \-\ BA",
"55423562", "Paula\ Freitas\ \-\ PR",
"55222771", "Rio\ das\ Ostras\ \-\ RJ",
"55114731", "Suzano\ \-\ SP",
"55464055", "Pato\ Branco\ \-\ PR",
"55115632", "São\ Paulo\ \-\ SP",
"55823642", "Mata\ Grande\ \-\ AL",
"5551320", "Rio\ Grande\ do\ Sul",
"55193797", "Campinas\ \-\ SP",
"55473263", "Balneário\ Camboriú\ \-\ SC",
"55613262", "Brasília\ \-\ DF",
"55453015", "Cascavel\ \-\ PR",
"55513348", "Rio\ Grande\ do\ Sul",
"55313240", "Perpétuo\ Socorro\ \-\ MG",
"55883542", "Missão\ Velha\ \-\ CE",
"55443582", "Guaiporã\ \-\ PR",
"55612323", "Brasília\ \-\ DF",
"55343252", "Ipiaçu\ \-\ MG",
"55853031", "Fortaleza\ \-\ CE",
"55533201", "Rio\ Grande\ \-\ RS",
"55753647", "Aratuípe\ \-\ BA",
"55483381", "São\ José\ \-\ SC",
"55493649", "Barra\ Bonita\ \-\ SC",
"55473332", "Gaspar\ \-\ SC",
"55613333", "Recanto\ das\ Emas\ \-\ DF",
"55453545", "Foz\ do\ Iguaçu\ \-\ PR",
"55653529", "Santa\ Rita\ do\ Trivelato\ \-\ MT",
"55143522", "Lins\ \-\ SP",
"55212691", "Nilópolis\ \-\ RJ",
"55183321", "Assis\ \-\ SP",
"55513274", "Rio\ Grande\ do\ Sul",
"55213263", "Rio\ de\ Janeiro\ \-\ RJ",
"55343817", "Coromandel\ \-\ MG",
"55473533", "Ituporanga\ \-\ SC",
"55613532", "Brasília\ \-\ DF",
"55793631", "Lagarto\ \-\ SE",
"55773620", "Serra\ do\ Ramalho\ \-\ BA",
"55493719", "Capinzal\ \-\ SC",
"55143761", "Itaí\ \-\ SP",
"55192121", "Campinas\ \-\ SP",
"55653308", "Nova\ Mutum\ \-\ MT",
"55183692", "Braúna\ \-\ SP",
"55542107", "Erechim\ \-\ RS",
"55553354", "Porto\ Xavier\ \-\ RS",
"55143265", "Piratininga\ \-\ SP",
"55112892", "São\ Paulo\ \-\ SP",
"55483439", "Criciúma\ \-\ SC",
"55114566", "Mogi\ das\ Cruzes\ \-\ SP",
"55683901", "Rio\ Branco\ \-\ AC",
"55423232", "Castro\ \-\ PR",
"55513762", "Rio\ Grande\ do\ Sul",
"55442033", "Palotina\ \-\ PR",
"55813747", "Brejo\ da\ Madre\ de\ Deus\ \-\ PE",
"55173293", "Palestina\ \-\ SP",
"55453252", "Toledo\ \-\ PR",
"55643624", "Itumbiara\ \-\ GO",
"55313448", "Minas\ Gerais",
"55533249", "Hulha\ Negra\ \-\ RS",
"55353295", "Machado\ \-\ MG",
"55353296", "Fama\ \-\ MG",
"55113438", "Santo\ André\ \-\ SP",
"55163389", "São\ Lourenço\ do\ Turvo\ \-\ SP",
"55753343", "Bonito\ \-\ BA",
"55483090", "São\ José\ \-\ SC",
"55433273", "Miraselva\ \-\ PR",
"55143415", "Marília\ \-\ SP",
"55693451", "Pimenta\ Bueno\ \-\ RO",
"55863582", "São\ Raimundo\ Nonato\ \-\ PI",
"55173442", "Fernandópolis\ \-\ SP",
"55553252", "São\ Francisco\ de\ Assis\ \-\ RS",
"55613637", "Planaltina\ \-\ GO",
"55192101", "Campinas\ \-\ SP",
"55733561", "Ubaitaba\ \-\ BA",
"55143416", "Jaú\ \-\ SP",
"55114821", "Rio\ Grande\ da\ Serra\ \-\ SP",
"55183301", "Araçatuba\ \-\ SP",
"55433249", "Cambé\ \-\ PR",
"55683026", "Rio\ Branco\ \-\ AC",
"55193563", "Pirassununga\ \-\ SP",
"55732103", "Itabuna\ \-\ BA",
"55683025", "Rio\ Branco\ \-\ AC",
"55833314", "São\ José\ da\ Mata\ \-\ PB",
"55483049", "São\ José\ \-\ SC",
"55883578", "Umari\ \-\ CE",
"55863295", "São\ Félix\ do\ Piauí\ \-\ PI",
"55383614", "Montalvânia\ \-\ MG",
"55473564", "Rio\ do\ Campo\ \-\ SC",
"55114202", "Carapicuíba\ \-\ SP",
"55513372", "Rio\ Grande\ do\ Sul",
"55354103", "Passos\ \-\ MG",
"55553545", "Porto\ Mauá\ \-\ RS",
"55643604", "Mairipotaba\ \-\ GO",
"55813651", "Passira\ \-\ PE",
"55123672", "Tremembé\ \-\ SP",
"55114084", "São\ Paulo\ \-\ SP",
"55493621", "São\ Miguel\ do\ Oeste\ \-\ SC",
"55753698", "Santa\ Brígida\ \-\ BA",
"55553546", "Alecrim\ \-\ RS",
"55833462", "São\ Mamede\ \-\ PB",
"55753494", "Canudos\ \-\ BA",
"55513067", "Novo\ Hamburgo\ \-\ RS",
"55163114", "Araraquara\ \-\ SP",
"55913181", "Belém\ \-\ PA",
"55913118", "Belém\ \-\ PA",
"55543383", "Espumoso\ \-\ RS",
"55643408", "Joviânia\ \-\ GO",
"55212787", "Duque\ de\ Caxias\ \-\ RJ",
"55163511", "Sertãozinho\ \-\ SP",
"55843329", "Felipe\ Guerra\ \-\ RN",
"55423334", "Maceió\ \-\ AL",
"55693218", "Porto\ Velho\ \-\ RO",
"55923877", "Manaus\ \-\ AM",
"55423618", "Virmond\ \-\ PR",
"55183693", "Piacatu\ \-\ SP",
"55193701", "Limeira\ \-\ SP",
"55643441", "Catalão\ \-\ GO",
"55383251", "Bocaiúva\ \-\ MG",
"55963212", "Macapá\ \-\ AP",
"55753244", "Conceição\ da\ Feira\ \-\ BA",
"55613533", "Brasília\ \-\ DF",
"55684007", "Rio\ Branco\ \-\ AC",
"55223835", "Carabuçu\ \-\ RJ",
"55193667", "Mococa\ \-\ SP",
"55813433", "Paulista\ \-\ PE",
"55833213", "João\ Pessoa\ \-\ PB",
"55983271", "São\ Luís\ \-\ MA",
"55853923", "Fortaleza\ \-\ CE",
"55173277", "Nipoã\ \-\ SP",
"55423414", "Rio\ da\ Areia\ \-\ PR",
"55513548", "Riozinho\ \-\ RS",
"5562332", "Anápolis\ \-\ GO",
"55143523", "Lins\ \-\ SP",
"5538", "Minas\ Gerais",
"55114173", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55633534", "Mateiros\ \-\ TO",
"55172137", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55312557", "Contagem\ \-\ MG",
"55613981", "Formosa\ \-\ GO",
"55143335", "Ourinhos\ \-\ SP",
"55833638", "Nova\ Palmeira\ \-\ PB",
"55713450", "Salvador\ \-\ BA",
"55163357", "Araraquara\ \-\ SP",
"55983524", "Imperatriz\ \-\ MA",
"55914104", "Ananindeua\ \-\ PA",
"55413060", "Fazenda\ Rio\ Grande\ \-\ PR",
"55453253", "Nova\ Santa\ Rosa\ \-\ PR",
"55433440", "Pirapó\ \-\ PR",
"55543284", "Caxias\ do\ Sul\ \-\ RS",
"55173292", "Paulo\ de\ Faria\ \-\ SP",
"55213525", "Rio\ de\ Janeiro\ \-\ RJ",
"55213774", "Duque\ de\ Caxias\ \-\ RJ",
"55163954", "Santa\ Rosa\ de\ Viterbo\ \-\ SP",
"55773415", "Ituaçu\ \-\ BA",
"55423233", "Castro\ \-\ PR",
"55513763", "Rio\ Grande\ do\ Sul",
"55663546", "Cláudia\ \-\ MT",
"55383756", "Buenópolis\ \-\ MG",
"55663545", "Sorriso\ \-\ MT",
"55383755", "Morada\ Nova\ de\ Minas\ \-\ MG",
"55112893", "São\ Paulo\ \-\ SP",
"55773416", "Contendas\ do\ Sincorá\ \-\ BA",
"5512390", "São\ José\ dos\ Campos\ \-\ SP",
"55833434", "Guarabira\ \-\ PB",
"55212780", "Mangaratiba\ \-\ RJ",
"55353446", "Albertina\ \-\ MG",
"55623248", "Aparecida\ de\ Goiânia\ \-\ GO",
"55493648", "Caibi\ \-\ SC",
"55732102", "Itabuna\ \-\ BA",
"55193562", "Pirassununga\ \-\ SP",
"55273321", "Vitória\ \-\ ES",
"55933582", "Santa\ Maria\ do\ Uruará\ \-\ PA",
"55353445", "Borda\ da\ Mata\ \-\ MG",
"55185871", "Panorama\ \-\ SP",
"55673521", "Três\ Lagoas\ \-\ MS",
"55693530", "Monte\ Negro\ \-\ RO",
"55212303", "Rio\ de\ Janeiro\ \-\ RJ",
"55963314", "Santana\ \-\ AP",
"55713287", "Lauro\ de\ Freitas\ \-\ BA",
"55115934", "São\ Paulo\ \-\ SP",
"55433272", "Jaguapitã\ \-\ PR",
"55493444", "Concórdia\ \-\ SC",
"55373433", "São\ Roque\ de\ Minas\ \-\ MG",
"5561210", "Brasília\ \-\ DF",
"55543382", "Alto\ Alegre\ \-\ RS",
"55653341", "Santo\ Antônio\ do\ Leverger\ \-\ MT",
"55222561", "Santa\ Maria\ Madalena\ \-\ RJ",
"55793453", "Moita\ Bonita\ \-\ SE",
"55433122", "Apucarana\ \-\ PR",
"5512392", "São\ José\ dos\ Campos\ \-\ SP",
"5511345", "São\ Paulo\ \-\ SP",
"55613306", "Brasília\ \-\ DF",
"55833463", "Taperoá\ \-\ PB",
"55673274", "Figueirão\ \-\ MS",
"55273081", "Vitória\ \-\ ES",
"55373214", "Divinópolis\ \-\ MG",
"55473158", "Itajaí\ \-\ SC",
"55513734", "Pantano\ Grande\ \-\ RS",
"55893568", "Palmeira\ do\ Piauí\ \-\ PI",
"55354102", "Pouso\ Alegre\ \-\ MG",
"55343243", "Amanhece\ \-\ MG",
"55273132", "Vitória\ \-\ ES",
"55114533", "Jundiaí\ \-\ SP",
"55553544", "Novo\ Machado\ \-\ RS",
"55513682", "Balneário\ Pinhal\ \-\ RS",
"55823311", "Maceió\ \-\ AL",
"55123022", "Taubaté\ \-\ SP",
"55433258", "Ibiporã\ \-\ PR",
"55183722", "Andradina\ \-\ SP",
"55333511", "Itambacuri\ \-\ MG",
"55182103", "Araçatuba\ \-\ SP",
"55633571", "Palmas\ \-\ TO",
"55733301", "Itabuna\ \-\ BA",
"55833471", "Malta\ \-\ PB",
"55543456", "Santa\ Tereza\ \-\ RS",
"55212721", "Niterói\ \-\ RJ",
"55213731", "Maricá\ \-\ RJ",
"55753496", "Adustina\ \-\ BA",
"5531351", "Minas\ Gerais",
"55473222", "Blumenau\ \-\ SC",
"55163116", "São\ Carlos\ \-\ SP",
"55353621", "Itajubá\ \-\ MG",
"55883553", "Milagres\ \-\ CE",
"55534062", "Pelotas\ \-\ RS",
"55423523", "União\ da\ Vitória\ \-\ PR",
"55213849", "Rio\ de\ Janeiro\ \-\ RJ",
"55114887", "Jarinu\ \-\ SP",
"55143414", "Marília\ \-\ SP",
"55613190", "Brasília\ \-\ DF",
"55843368", "Triunfo\ Potiguar\ \-\ RN",
"55753650", "Nordestina\ \-\ BA",
"55733166", "Eunápolis\ \-\ BA",
"55483623", "Capivari\ de\ Baixo\ \-\ SC",
"55213236", "Nilópolis\ \-\ RJ",
"55334141", "Governador\ Valadares\ \-\ MG",
"55833316", "Riachão\ do\ Bacamarte\ \-\ PB",
"55623575", "Goiânia\ \-\ GO",
"55614001", "Brasília\ \-\ DF",
"55823028", "Maceió\ \-\ AL",
"55673559", "Paranaíba\ \-\ MS",
"55383616", "Matias\ Cardoso\ \-\ MG",
"55443593", "Jota\ Esse\ \-\ PR",
"55213890", "Rio\ de\ Janeiro\ \-\ RJ",
"55413587", "São\ José\ dos\ Pinhais\ \-\ PR",
"55383615", "Manga\ \-\ MG",
"55223862", "Portela\ \-\ RJ",
"55473565", "Mirim\ Doce\ \-\ SC",
"55833315", "Campina\ Grande\ \-\ PB",
"55733692", "Camacan\ \-\ BA",
"55443673", "Ivaté\ \-\ PR",
"55114161", "Barueri\ \-\ SP",
"55143264", "Lençóis\ Paulista\ \-\ SP",
"55853468", "Fortaleza\ \-\ CE",
"55434062", "Londrina\ \-\ PR",
"55313480", "Minas\ Gerais",
"55113636", "São\ Paulo\ \-\ SP",
"55112625", "São\ Paulo\ \-\ SP",
"55643417", "Morrinhos\ \-\ GO",
"55313645", "Vespasiano\ \-\ MG",
"55353294", "Alterosa\ \-\ MG",
"55513771", "Rio\ Grande\ do\ Sul",
"55212667", "Nova\ Iguaçu\ \-\ RJ",
"55443649", "Palotina\ \-\ PR",
"55272102", "Colatina\ \-\ ES",
"55643626", "Santo\ Antônio\ da\ Barra\ \-\ GO",
"55273723", "Colatina\ \-\ ES",
"55673231", "Corumbá\ \-\ MS",
"55163398", "Fazenda\ Babilônia\ \-\ SP",
"55513587", "Novo\ Hamburgo\ \-\ RS",
"55183702", "Andradina\ \-\ SP",
"55133227", "Santos\ \-\ SP",
"55673683", "Rio\ Verde\ de\ Mato\ Grosso\ \-\ MS",
"55553738", "Caiçara\ \-\ RS",
"55454009", "Cascavel\ \-\ PR",
"55633322", "Palmas\ \-\ TO",
"55533258", "Santana\ da\ Boa\ Vista\ \-\ RS",
"55883650", "Carnaubal\ \-\ CE",
"55313459", "Minas\ Gerais",
"55913443", "Irituia\ \-\ PA",
"55733677", "Coroa\ Vermelha\ \-\ BA",
"55323422", "Cataguases\ \-\ MG",
"55643469", "Anhanguera\ \-\ GO",
"55473084", "Jaraguá\ do\ Sul\ \-\ SC",
"55833198", "João\ Pessoa\ \-\ PB",
"55743065", "Juazeiro\ \-\ BA",
"55553356", "Bossoroca\ \-\ RS",
"55633691", "Rio\ da\ Conceição\ \-\ TO",
"55553355", "Caibaté\ \-\ RS",
"55933063", "Santarém\ \-\ PA",
"55443455", "Santa\ Mônica\ \-\ PR",
"55883552", "Mauriti\ \-\ CE",
"55173395", "Terra\ Roxa\ \-\ SP",
"55213504", "Rio\ de\ Janeiro\ \-\ RJ",
"55843351", "Pau\ dos\ Ferros\ \-\ RN",
"55913032", "Ananindeua\ \-\ PA",
"55613304", "Guará\ \-\ DF",
"55193302", "Piracicaba\ \-\ SP",
"5512388", "Caraguatatuba\ \-\ SP",
"55553278", "Pinhal\ Grande\ \-\ RS",
"55122127", "Jacareí\ \-\ SP",
"55513736", "Estrêla\ \-\ RS",
"55373215", "Divinópolis\ \-\ MG",
"55843613", "Natal\ \-\ RN",
"55182102", "Araçatuba\ \-\ SP",
"55714003", "Salvador\ \-\ BA",
"55183723", "Andradina\ \-\ SP",
"55123023", "Jacareí\ \-\ SP",
"55513683", "Rio\ Grande\ do\ Sul",
"55373216", "Divinópolis\ \-\ MG",
"55173819", "Poloni\ \-\ SP",
"55115031", "São\ Paulo\ \-\ SP",
"55513735", "Várzea\ do\ Capivarita\ \-\ RS",
"55114532", "Jundiaí\ \-\ SP",
"55343242", "Araguari\ \-\ MG",
"55843238", "Parnamirim\ \-\ RN",
"55913120", "Belém\ \-\ PA",
"55223863", "Jaguarembé\ \-\ RJ",
"55313289", "Minas\ Gerais",
"55353444", "Jacutinga\ \-\ MG",
"55474001", "Joinville\ \-\ SC",
"55483061", "Criciúma\ \-\ SC",
"55733573", "Prado\ \-\ BA",
"5551341", "Rio\ Grande\ do\ Sul",
"5553323", "Rio\ Grande\ \-\ RS",
"55193571", "Leme\ \-\ SP",
"55183558", "Sagres\ \-\ SP",
"55483622", "Tubarão\ \-\ SC",
"55493446", "Lindóia\ do\ Sul\ \-\ SC",
"55493445", "Abelardo\ Luz\ \-\ SC",
"55623280", "Aparecida\ de\ Goiânia\ \-\ GO",
"5511258", "São\ Paulo\ \-\ SP",
"55733549", "Manoel\ Vitorino\ \-\ BA",
"55423522", "União\ da\ Vitória\ \-\ PR",
"55713221", "Salvador\ \-\ BA",
"55183703", "Bairro\ Formosa\ \-\ SP",
"55533261", "Jaguarão\ \-\ RS",
"55273722", "Colatina\ \-\ ES",
"55633535", "Marianópolis\ do\ Tocantins\ \-\ TO",
"55272103", "Linhares\ \-\ ES",
"55773618", "Cristópolis\ \-\ BA",
"55983525", "Imperatriz\ \-\ MA",
"55123003", "São\ José\ dos\ Campos\ \-\ SP",
"55513559", "Sapiranga\ \-\ RS",
"55623457", "Monte\ Alegre\ de\ Goiás\ \-\ GO",
"55823557", "Piaçabuçu\ \-\ AL",
"55773414", "Jussiape\ \-\ BA",
"5599352", "Imperatriz\ \-\ MA",
"55623983", "Aparecida\ de\ Goiânia\ \-\ GO",
"55543285", "Picada\ Café\ \-\ RS",
"55833436", "Vista\ Serrana\ \-\ PB",
"55343841", "Coromandel\ \-\ MG",
"55883657", "Quiterianópolis\ \-\ CE",
"55434063", "Londrina\ \-\ PR",
"55833435", "Jericó\ \-\ PB",
"55543286", "Gramado\ \-\ RS",
"55443672", "Rondon\ \-\ PR",
"55163956", "Pontal\ \-\ SP",
"55333357", "Dom\ Cavati\ \-\ MG",
"55663544", "Sorriso\ \-\ MT",
"55383754", "Três\ Marias\ \-\ MG",
"55413358", "São\ José\ dos\ Pinhais\ \-\ PR",
"55513580", "Novo\ Hamburgo\ \-\ RS",
"55753246", "São\ Gonçalo\ dos\ Campos\ \-\ BA",
"55933062", "Santarém\ \-\ PA",
"55813711", "Caruaru\ \-\ PE",
"55114158", "Vargem\ Grande\ Paulista\ \-\ SP",
"55414107", "Curitiba\ \-\ PR",
"55613084", "Luziânia\ \-\ GO",
"55753245", "Santo\ Estêvão\ \-\ BA",
"55983262", "São\ Luís\ \-\ MA",
"55483527", "Araranguá\ \-\ SC",
"55113307", "São\ Paulo\ \-\ SP",
"55323423", "Cataguases\ \-\ MG",
"5511472", "Mogi\ das\ Cruzes\ \-\ SP",
"55863393", "Luzilândia\ \-\ PI",
"55414064", "Paranaguá\ \-\ PR",
"55453278", "Toledo\ \-\ PR",
"55913442", "Santa\ Maria\ do\ Pará\ \-\ PA",
"55963198", "Macapá\ \-\ AP",
"55673682", "Camapuã\ \-\ MS",
"55133877", "Santos\ \-\ SP",
"55432104", "Londrina\ \-\ PR",
"55193336", "Rio\ Claro\ \-\ SP",
"55863285", "Elesbão\ Veloso\ \-\ PI",
"55423303", "Guarapuava\ \-\ PR",
"55112785", "São\ Paulo\ \-\ SP",
"55853182", "Fortaleza\ \-\ CE",
"55553556", "Redentora\ \-\ RS",
"55813641", "Vicência\ \-\ PE",
"55933593", "Altamira\ \-\ PA",
"55833422", "Patos\ \-\ PB",
"55212772", "Duque\ de\ Caxias\ \-\ RJ",
"55513133", "Novo\ Hamburgo\ \-\ RS",
"55273735", "Afonso\ Cláudio\ \-\ ES",
"55543444", "Serafina\ Corrêa\ \-\ RS",
"55633522", "Lagoa\ do\ Tocantins\ \-\ TO",
"55733274", "Vera\ Cruz\ \-\ BA",
"55793442", "Malhador\ \-\ SE",
"55123687", "Quiririm\ \-\ SP",
"55772101", "Vitória\ da\ Conquista\ \-\ BA",
"55963423", "Calçoene\ \-\ AP",
"55273736", "Laranja\ da\ Terra\ \-\ ES",
"55643633", "Lagoa\ do\ Bauzinho\ \-\ GO",
"55943331", "São\ Geraldo\ do\ Araguaia\ \-\ PA",
"55513702", "Rio\ Grande\ do\ Sul",
"55183276", "Piquerobi\ \-\ SP",
"55543393", "Mormaço\ \-\ RS",
"5551353", "Rio\ Grande\ do\ Sul",
"55553242", "Santana\ do\ Livramento\ \-\ RS",
"55493382", "Xanxerê\ \-\ SC",
"55183275", "Martinópolis\ \-\ SP",
"55412103", "Curitiba\ \-\ PR",
"55753353", "Santo\ Antônio\ de\ Jesus\ \-\ BA",
"55513387", "Rio\ Grande\ do\ Sul",
"55353697", "Poços\ de\ Caldas\ \-\ MG",
"55693441", "Cacoal\ \-\ RO",
"55893541", "Marcos\ Parente\ \-\ PI",
"55383843", "Novorizonte\ \-\ MG",
"55753688", "Lamarão\ \-\ BA",
"55123975", "Santa\ Branca\ \-\ SP",
"55515", "Rio\ Grande\ do\ Sul",
"55713273", "Salvador\ \-\ BA",
"55143667", "Itaju\ \-\ SP",
"55192533", "Piracicaba\ \-\ SP",
"55433259", "Jataizinho\ \-\ PR",
"55114094", "Diadema\ \-\ SP",
"55473524", "Aurora\ \-\ SC",
"55813757", "Santa\ Maria\ do\ Cambucá\ \-\ PE",
"55623375", "Itaberaí\ \-\ GO",
"55183996", "Marabá\ Paulista\ \-\ SP",
"55453242", "Corbélia\ \-\ PR",
"55473366", "Balneário\ Camboriú\ \-\ SC",
"55383228", "Coração\ de\ Jesus\ \-\ MG",
"55513722", "Cachoeira\ do\ Sul\ \-\ RS",
"55473365", "Camboriú\ \-\ SC",
"55114774", "Itapevi\ \-\ SP",
"55222734", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55183995", "Indiana\ \-\ SP",
"55143226", "Bauru\ \-\ SP",
"55623376", "Aruanã\ \-\ GO",
"55112664", "Barueri\ \-\ SP",
"55173631", "Santa\ Fé\ do\ Sul\ \-\ SP",
"55993221", "Imperatriz\ \-\ MA",
"55423323", "Ponta\ Grossa\ \-\ PR",
"55433531", "Santa\ Mariana\ \-\ PR",
"55643664", "Doverlândia\ \-\ GO",
"55513561", "Estância\ Velha\ \-\ RS",
"55113603", "Osasco\ \-\ SP",
"55212681", "Seropédica\ \-\ RJ",
"55553739", "Taquaruçu\ do\ Sul\ \-\ RS",
"55353286", "Divisa\ Nova\ \-\ MG",
"55193503", "Hortolândia\ \-\ SP",
"55183361", "Paraguaçu\ Paulista\ \-\ SP",
"55623488", "Simolândia\ \-\ GO",
"5531331", "Minas\ Gerais",
"5561337", "Ceilândia\ \-\ DF",
"55443648", "Santa\ Rita\ do\ Oeste\ \-\ PR",
"55133291", "Santos\ \-\ SP",
"55543034", "São\ Marcos\ \-\ RS",
"55993574", "Fortuna\ \-\ MA",
"55743675", "São\ José\ do\ Jacuípe\ \-\ BA",
"55173283", "Jaci\ \-\ SP",
"55443444", "São\ Pedro\ do\ Paraná\ \-\ PR",
"55633371", "Paranã\ \-\ TO",
"55743676", "Quixabeira\ \-\ BA",
"55883611", "Sobral\ \-\ CE",
"55513703", "Rio\ Grande\ do\ Sul",
"55693428", "Nova\ Londrina\ \-\ RO",
"55643632", "Jataí\ \-\ GO",
"55464054", "Francisco\ Beltrão\ \-\ PR",
"55733548", "Irajuba\ \-\ BA",
"55963422", "Tartarugalzinho\ \-\ AP",
"55653351", "Nossa\ Senhora\ do\ Livramento\ \-\ MT",
"55433162", "Apucarana\ \-\ PR",
"55793443", "Campo\ do\ Brito\ \-\ SE",
"55713297", "Salvador\ \-\ BA",
"55623331", "Pirenópolis\ \-\ GO",
"55353690", "Varginha\ \-\ MG",
"55513380", "Rio\ Grande\ do\ Sul",
"55833423", "Patos\ \-\ PB",
"55543377", "Santo\ Antônio\ do\ Planalto\ \-\ RS",
"55843239", "Nísia\ Floresta\ \-\ RN",
"55473148", "Navegantes\ \-\ SC",
"55423302", "Ponta\ Grossa\ \-\ PR",
"55653613", "Cuiabá\ \-\ MT",
"55222762", "Macaé\ \-\ RJ",
"55853260", "Eusébio\ \-\ CE",
"55613271", "Belo\ Horizonte\ \-\ MG",
"55433575", "Londrina\ \-\ PR",
"55663493", "Pedra\ Preta\ \-\ MT",
"55213084", "Rio\ de\ Janeiro\ \-\ RJ",
"55333431", "Santa\ Maria\ do\ Suaçuí\ \-\ MG",
"55313211", "Minas\ Gerais",
"55113507", "São\ Paulo\ \-\ SP",
"55173818", "Bady\ Bassitt\ \-\ SP",
"55353455", "São\ João\ da\ Mata\ \-\ MG",
"55313715", "Cordisburgo\ \-\ MG",
"55192532", "Piracicaba\ \-\ SP",
"55193607", "Casa\ Branca\ \-\ SP",
"55853337", "Aracoiaba\ \-\ CE",
"55493700", "Chapecó\ \-\ SC",
"55813628", "Limoeiro\ \-\ PE",
"55713272", "Salvador\ \-\ BA",
"55213202", "Rio\ de\ Janeiro\ \-\ RJ",
"55273091", "Cariacica\ \-\ ES",
"55553279", "Quevedos\ \-\ RS",
"55493658", "Tigrinhos\ \-\ SC",
"55273361", "Guarapari\ \-\ ES",
"55313716", "Inhaúma\ \-\ MG",
"55383842", "Salinas\ \-\ MG",
"55353456", "Natércia\ \-\ MG",
"55493454", "Xavantina\ \-\ SC",
"55983326", "Presidente\ Médici\ \-\ MA",
"55193761", "Campinas\ \-\ SP",
"55743631", "Serrolândia\ \-\ BA",
"55553243", "Santana\ do\ Livramento\ \-\ RS",
"55173453", "Cardoso\ \-\ SP",
"55114234", "São\ Caetano\ do\ Sul\ \-\ SP",
"55543392", "Lagoa\ dos\ Três\ Cantos\ \-\ RS",
"55983325", "Maranhãozinho\ \-\ MA",
"55344009", "Uberlândia\ \-\ MG",
"55343355", "Pedrinópolis\ \-\ MG",
"55473236", "Blumenau\ \-\ SC",
"55923664", "Manaus\ \-\ AM",
"55443621", "Umuarama\ \-\ PR",
"55193371", "Piracicaba\ \-\ SP",
"55843437", "Lagoa\ Nova\ \-\ RN",
"5519373", "Campinas\ \-\ SP",
"55793277", "Carmópolis\ \-\ SE",
"55113602", "Osasco\ \-\ SP",
"55163347", "Cambaratiba\ \-\ SP",
"55773667", "Pindaí\ \-\ BA",
"55343356", "Nova\ Ponte\ \-\ MG",
"55453279", "Quatro\ Pontes\ \-\ PR",
"55413020", "Curitiba\ \-\ PR",
"55193874", "Paulínia\ \-\ SP",
"55613365", "Brasília\ \-\ DF",
"55273125", "Guarapari\ \-\ ES",
"55383745", "Lagoa\ dos\ Patos\ \-\ MG",
"55663555", "Cotriguaçu\ \-\ MT",
"55513723", "Cachoeira\ do\ Sul\ \-\ RS",
"55443062", "Paranavaí\ \-\ PR",
"55163944", "Dumont\ \-\ SP",
"55613366", "Brasília\ \-\ DF",
"55383746", "Ibiaí\ \-\ MG",
"55663556", "Juara\ \-\ MT",
"55453243", "Nova\ Aurora\ \-\ PR",
"55273771", "São\ Mateus\ \-\ ES",
"55114159", "Vargem\ Grande\ Paulista\ \-\ SP",
"55483591", "Jacinto\ Machado\ \-\ SC",
"55273275", "Aracruz\ \-\ ES",
"55112883", "Mogi\ das\ Cruzes\ \-\ SP",
"55163010", "Araraquara\ \-\ SP",
"55753254", "Ipirá\ \-\ BA",
"55543294", "Nova\ Roma\ do\ Sul\ \-\ RS",
"55173282", "Icém\ \-\ SP",
"55353593", "Jacuí\ \-\ MG",
"55413132", "Pinhais\ \-\ PR",
"5511567", "São\ Paulo\ \-\ SP",
"55673027", "Campo\ Grande\ \-\ MS",
"55273276", "Guaraná\ \-\ ES",
"55213222", "Rio\ de\ Janeiro\ \-\ RJ",
"55543601", "Passo\ Fundo\ \-\ RS",
"55773619", "Catolândia\ \-\ BA",
"55373424", "Córrego\ Danta\ \-\ MG",
"55213304", "Belford\ Roxo\ \-\ RJ",
"55513558", "Rio\ Grande\ do\ Sul",
"55613504", "Cristalina\ \-\ GO",
"55613101", "Brasília\ \-\ DF",
"55193502", "Rio\ Claro\ \-\ SP",
"55113301", "São\ Paulo\ \-\ SP",
"55553422", "Alegrete\ \-\ RS",
"55513770", "Sério\ \-\ RS",
"55483521", "Araranguá\ \-\ SC",
"55193672", "Santa\ Cruz\ das\ Palmeiras\ \-\ SP",
"55134002", "Santos\ \-\ SP",
"55323356", "Ritápolis\ \-\ MG",
"55613026", "Brasília\ \-\ DF",
"55673230", "Pedro\ Gomes\ \-\ MS",
"55323355", "Tiradentes\ \-\ MG",
"55513793", "Venâncio\ Aires\ \-\ RS",
"55833556", "São\ Gonçalo\ \-\ PB",
"55313853", "Bela\ Vista\ de\ Minas\ \-\ MG",
"55173262", "Nova\ Granada\ \-\ SP",
"55353335", "Conceição\ do\ Rio\ Verde\ \-\ MG",
"55513439", "Cachoeirinha\ \-\ RS",
"55242104", "Petrópolis\ \-\ RJ",
"55463550", "Renascença\ \-\ PR",
"55623537", "Aparecida\ de\ Goiânia\ \-\ GO",
"55132105", "Santos\ \-\ SP",
"55212700", "Itaguaí\ \-\ RJ",
"55613478", "Sobradinho\ \-\ DF",
"55633456", "Augustinópolis\ \-\ TO",
"55333238", "São\ Geraldo\ da\ Piedade\ \-\ MG",
"55413073", "Belo\ Horizonte\ \-\ MG",
"55633455", "Nazaré\ \-\ TO",
"55143583", "Balbinos\ \-\ SP",
"55493334", "Saudades\ \-\ SC",
"55373343", "Camacho\ \-\ MG",
"55753432", "Aramari\ \-\ BA",
"55933502", "Castelo\ dos\ Sonhos\ \-\ PA",
"55694003", "Porto\ Velho\ \-\ RO",
"55623451", "Campos\ Belos\ \-\ GO",
"5592323", "Manaus\ \-\ AM",
"5531335", "Minas\ Gerais",
"55983181", "São\ Luís\ \-\ MA",
"55115103", "São\ Paulo\ \-\ SP",
"55773687", "Canápolis\ \-\ BA",
"55893474", "Pimenteiras\ \-\ PI",
"55433417", "Ribeirão\ Bonito\ \-\ PR",
"55533267", "Herval\ \-\ RS",
"55173525", "Catanduva\ \-\ SP",
"55433625", "Cafeara\ \-\ PR",
"55793304", "Aracaju\ \-\ SE",
"55333351", "Raul\ Soares\ \-\ MG",
"55793222", "Aracaju\ \-\ SE",
"55343847", "Abadia\ dos\ Dourados\ \-\ MG",
"55353523", "Alpinópolis\ \-\ MG",
"55913731", "Vigia\ \-\ PA",
"55614020", "Brasília\ \-\ DF",
"5564309", "Itumbiara\ \-\ GO",
"55613386", "Núcleo\ Bandeirante\ \-\ DF",
"55823551", "Penedo\ \-\ AL",
"55483274", "Angelina\ \-\ SC",
"55433626", "Jundiaí\ do\ Sul\ \-\ PR",
"55113572", "São\ Paulo\ \-\ SP",
"55963243", "Macapá\ \-\ AP",
"55943785", "Novo\ Repartimento\ \-\ PA",
"55813379", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55873853", "Itapetim\ \-\ PE",
"55663423", "Rondonópolis\ \-\ MT",
"55474007", "Joinville\ \-\ SC",
"55493232", "Bom\ Jardim\ da\ Serra\ \-\ SC",
"55933522", "Santarém\ \-\ PA",
"55433267", "São\ Jerônimo\ da\ Serra\ \-\ PR",
"55163752", "Aramina\ \-\ SP",
"55112834", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55273381", "Vitória\ \-\ ES",
"55513237", "Rio\ Grande\ do\ Sul",
"55943786", "Breu\ Branco\ \-\ PA",
"55833493", "Boa\ Ventura\ \-\ PB",
"55813343", "Recife\ \-\ PE",
"55493363", "Bom\ Jesus\ do\ Oeste\ \-\ SC",
"55443302", "Maringá\ \-\ PR",
"55414121", "Fazenda\ Rio\ Grande\ \-\ PR",
"55553402", "Uruguaiana\ \-\ RS",
"55112331", "São\ Paulo\ \-\ SP",
"55883432", "Icapuí\ \-\ CE",
"55193577", "Corumbataí\ \-\ SP",
"55543322", "Quinze\ de\ Novembro\ \-\ RS",
"553130", "Minas\ Gerais",
"55983395", "Godofredo\ Viana\ \-\ MA",
"55713177", "Salvador\ \-\ BA",
"55843357", "Coronel\ João\ Pessoa\ \-\ RN",
"55213891", "Rio\ de\ Janeiro\ \-\ RJ",
"55483372", "São\ José\ \-\ SC",
"55443571", "Luiziana\ \-\ PR",
"55963014", "Macapá\ \-\ AP",
"55513049", "Campo\ Bom\ \-\ RS",
"55983396", "Cândido\ Mendes\ \-\ MA",
"55123131", "São\ José\ dos\ Campos\ \-\ SP",
"55183634", "Birigui\ \-\ SP",
"55313268", "Minas\ Gerais",
"55324009", "Juiz\ de\ Fora\ \-\ MG",
"55753651", "Jiquiriçá\ \-\ BA",
"55273021", "Guarapari\ \-\ ES",
"55193592", "Santa\ Rita\ do\ Passa\ Quatro\ \-\ SP",
"55463311", "Pato\ Branco\ \-\ PR",
"55153554", "Barra\ do\ Chapéu\ \-\ SP",
"55753433", "Subaúma\ \-\ BA",
"55913366", "Belém\ \-\ PA",
"5587", "Pernambuco",
"55143582", "Uru\ \-\ SP",
"55353266", "Três\ Pontas\ \-\ MG",
"55733671", "Santa\ Cruz\ Cabrália\ \-\ BA",
"55193649", "Águas\ da\ Prata\ \-\ SP",
"55353265", "Três\ Pontas\ \-\ MG",
"55173332", "Guaíra\ \-\ SP",
"55663402", "Barra\ do\ Garças\ \-\ MT",
"55114282", "São\ Paulo\ \-\ SP",
"55143296", "Arealva\ \-\ SP",
"55473674", "São\ Miguel\ da\ Serra\ \-\ SC",
"55773445", "Condeúba\ \-\ BA",
"55173263", "Mirassolândia\ \-\ SP",
"55313852", "João\ Monlevade\ \-\ MG",
"55192118", "Hortolândia\ \-\ SP",
"55513792", "Costão\ \-\ RS",
"55114595", "Várzea\ Paulista\ \-\ SP",
"55883668", "Senador\ Sá\ \-\ CE",
"55993604", "São\ Pedro\ dos\ Crentes\ \-\ MA",
"55114596", "Várzea\ Paulista\ \-\ SP",
"55134003", "Praia\ Grande\ \-\ SP",
"55443323", "Colorado\ \-\ PR",
"55193673", "Tambaú\ \-\ SP",
"55513933", "Gravataí\ \-\ RS",
"55112862", "São\ Paulo\ \-\ SP",
"55773446", "Aracatu\ \-\ BA",
"55143295", "Boracéia\ \-\ SP",
"55553423", "Quaraí\ \-\ RS",
"55663515", "Sinop\ \-\ MT",
"55163508", "Araraquara\ \-\ SP",
"55963242", "Macapá\ \-\ AP",
"55443535", "Jesuítas\ \-\ PR",
"55643411", "Catalão\ \-\ GO",
"55193455", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55473386", "Rio\ dos\ Cedros\ \-\ SC",
"55423648", "Marquinho\ \-\ PR",
"55833279", "Cachoeira\ \-\ PB",
"55213032", "Rio\ de\ Janeiro\ \-\ RJ",
"55353522", "Passos\ \-\ MG",
"55112684", "São\ Paulo\ \-\ SP",
"55793223", "Aracaju\ \-\ SE",
"55193456", "Iracemápolis\ \-\ SP",
"55473385", "Benedito\ Novo\ \-\ SC",
"55483548", "Passo\ de\ Torres\ \-\ SC",
"55212707", "Niterói\ \-\ RJ",
"55463557", "Bela\ Vista\ da\ Caroba\ \-\ PR",
"55443536", "Brasiliana\ \-\ PR",
"55214125", "Belford\ Roxo\ \-\ RJ",
"55513581", "Novo\ Hamburgo\ \-\ RS",
"55643684", "Aurilândia\ \-\ GO",
"55183021", "Birigui\ \-\ SP",
"55115102", "São\ Paulo\ \-\ SP",
"55313539", "Betim\ \-\ MG",
"55513777", "Putinga\ \-\ RS",
"55353371", "Passa\ Quatro\ \-\ MG",
"55883433", "Aracati\ \-\ CE",
"55653311", "Tangará\ da\ Serra\ \-\ MT",
"55543535", "Caxias\ do\ Sul\ \-\ RS",
"55453054", "Toledo\ \-\ PR",
"55993075", "Imperatriz\ \-\ MA",
"55114818", "Terra\ Preta\ \-\ SP",
"55144103", "Jaú\ \-\ SP",
"55513097", "Novo\ Hamburgo\ \-\ RS",
"55543536", "Caxias\ do\ Sul\ \-\ RS",
"55114881", "Francisco\ Morato\ \-\ SP",
"55433337", "Londrina\ \-\ PR",
"55813342", "Recife\ \-\ PE",
"55493362", "Novo\ Horizonte\ \-\ SC",
"55653388", "Várzea\ Grande\ \-\ MT",
"55833492", "Monte\ Horebe\ \-\ PB",
"55313251", "Santana\ do\ Paraíso\ \-\ MG",
"55373244", "Carmo\ do\ Cajuru\ \-\ MG",
"55413581", "Curitiba\ \-\ PR",
"55933523", "Santarém\ \-\ PA",
"55493233", "São\ Joaquim\ \-\ SC",
"55273048", "Linhares\ \-\ ES",
"55614007", "Brasília\ \-\ DF",
"55873852", "Betânia\ \-\ PE",
"55323278", "Pequeri\ \-\ MG",
"55222783", "Italva\ \-\ RJ",
"55283525", "Jaciguá\ \-\ ES",
"55114024", "Itu\ \-\ SP",
"55863265", "União\ \-\ PI",
"55313756", "Minas\ Gerais",
"55133201", "Santos\ \-\ SP",
"55683325", "Marechal\ Thaumaturgo\ \-\ AC",
"55673439", "Bela\ Vista\ \-\ MS",
"55193593", "Descalvado\ \-\ SP",
"55313755", "Senhora\ de\ Oliveira\ \-\ MG",
"55473901", "Blumenau\ \-\ SC",
"55283526", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55313338", "Nova\ Lima\ \-\ MG",
"55913776", "Santa\ Bárbara\ do\ Pará\ \-\ PA",
"55433260", "Guaraci\ \-\ PR",
"55653028", "Cuiabá\ \-\ MT",
"55973561", "Coari\ \-\ AM",
"55133822", "Registro\ \-\ SP",
"55953238", "Rorainópolis\ \-\ RR",
"55753312", "Cruz\ das\ Almas\ \-\ BA",
"55833477", "Livramento\ \-\ PB",
"55913775", "Santo\ Antônio\ do\ Tauá\ \-\ PA",
"55543323", "Nova\ Alvorada\ \-\ RS",
"55733623", "Firmino\ Alves\ \-\ BA",
"55323344", "Bias\ Fortes\ \-\ MG",
"55673021", "Dourados\ \-\ MS",
"55143003", "Bauru\ \-\ SP",
"55513560", "Araricá\ \-\ RS",
"55663436", "Poxoréo\ \-\ MT",
"55834009", "João\ Pessoa\ \-\ PB",
"55212680", "Mangaratiba\ \-\ RJ",
"55663435", "Tesouro\ \-\ MT",
"55613394", "Santa\ Maria\ \-\ DF",
"55142107", "Bauru\ \-\ SP",
"55743532", "Pilar\ \-\ BA",
"5511508", "São\ Paulo\ \-\ SP",
"55833544", "Marizópolis\ \-\ PB",
"55474105", "Itajaí\ \-\ SC",
"55543522", "Erechim\ \-\ RS",
"55633444", "Axixá\ do\ Tocantins\ \-\ TO",
"55613107", "Brasília\ \-\ DF",
"55413663", "Colombo\ \-\ PR",
"55643983", "Itumbiara\ \-\ GO",
"55193621", "Americana\ \-\ SP",
"55184101", "Presidente\ Prudente\ \-\ SP",
"55633393", "Chapada\ da\ Natividade\ \-\ TO",
"55773661", "Candiba\ \-\ BA",
"55813543", "Igarassu\ \-\ PE",
"55493563", "Caçador\ \-\ SC",
"55483301", "Tubarão\ \-\ SC",
"55673926", "Ponta\ Porã\ \-\ MS",
"55533281", "Pelotas\ \-\ RS",
"55212659", "Magé\ \-\ RJ",
"55343423", "Frutal\ \-\ MG",
"55513438", "Cachoeirinha\ \-\ RS",
"55163341", "Ibitinga\ \-\ SP",
"55173564", "Catiguá\ \-\ SP",
"55843431", "Currais\ Novos\ \-\ RN",
"55793271", "Divina\ Pastora\ \-\ SE",
"5511479", "Mogi\ das\ Cruzes\ \-\ SP",
"55443627", "São\ Lourenço\ \-\ PR",
"55713624", "Camaçari\ \-\ BA",
"55193377", "Piracicaba\ \-\ SP",
"55313419", "Minas\ Gerais",
"55863323", "Parnaíba\ \-\ PI",
"55433468", "Rio\ Bom\ \-\ PR",
"55854062", "Fortaleza\ \-\ CE",
"55613479", "Brazlândia\ \-\ DF",
"55222622", "Arraial\ do\ Cabo\ \-\ RJ",
"55983004", "São\ Luís\ \-\ MA",
"55413048", "Araucária\ \-\ PR",
"55513634", "Bom\ Princípio\ \-\ RS",
"55643531", "Itumbiara\ \-\ GO",
"55133273", "Santos\ \-\ SP",
"55283532", "Marataízes\ \-\ ES",
"55124408", "Polvilho\ \-\ SP",
"5584321", "Natal\ \-\ RN",
"55313912", "Contagem\ \-\ MG",
"55473442", "São\ Francisco\ do\ Sul\ \-\ SC",
"55492101", "Lages\ \-\ SC",
"55543266", "Santa\ Lúcia\ do\ Piaí\ \-\ RS",
"55813699", "Panelas\ \-\ PE",
"55613585", "Ceilândia\ \-\ DF",
"5524336", "Angra\ dos\ Reis\ \-\ RJ",
"55483018", "Florianópolis\ \-\ SC",
"55353323", "São\ Vicente\ de\ Minas\ \-\ MG",
"55483081", "Criciúma\ \-\ SC",
"55193601", "Americana\ \-\ SP",
"55853331", "Barreira\ \-\ CE",
"55313269", "Belo\ Horizonte\ \-\ MG",
"55473270", "Jaraguá\ do\ Sul\ \-\ SC",
"55813486", "Recife\ \-\ PE",
"55883513", "Crato\ \-\ CE",
"55413634", "São\ José\ dos\ Pinhais\ \-\ PR",
"55743637", "Gentio\ do\ Ouro\ \-\ BA",
"55513048", "Osório\ \-\ RS",
"5511407", "Diadema\ \-\ SP",
"55844109", "Mossoró\ \-\ RN",
"55983453", "Arari\ \-\ MA",
"5511256", "São\ Paulo\ \-\ SP",
"55153252", "Torre\ de\ Pedra\ \-\ SP",
"55983384", "Presidente\ Sarney\ \-\ MA",
"55713291", "Salvador\ \-\ BA",
"55793365", "Malhada\ dos\ Bois\ \-\ SE",
"55313153", "Sete\ Lagoas\ \-\ MG",
"55642104", "Rio\ Verde\ \-\ GO",
"55683234", "Capixaba\ \-\ AC",
"55923575", "Itapiranga\ \-\ AM",
"55793366", "Brejo\ Grande\ \-\ SE",
"55493534", "Ibiam\ \-\ SC",
"55273072", "Vila\ Velha\ \-\ ES",
"55373543", "Quartel\ Geral\ \-\ MG",
"55143454", "Marília\ \-\ SP",
"55113501", "São\ Paulo\ \-\ SP",
"55483321", "Florianópolis\ \-\ SC",
"55353536", "Itaú\ de\ Minas\ \-\ MG",
"55833355", "São\ João\ do\ Cariri\ \-\ PB",
"55443522", "Goioerê\ \-\ PR",
"55323556", "São\ Geraldo\ \-\ MG",
"55543371", "Marau\ \-\ RS",
"55323555", "Coimbra\ \-\ MG",
"55153546", "Buri\ \-\ SP",
"55713604", "Madre\ de\ Deus\ \-\ BA",
"55443607", "São\ Tomé\ \-\ PR",
"55213674", "Niterói\ \-\ RJ",
"55863303", "Teresina\ \-\ PI",
"55813378", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55833356", "Cabaceiras\ \-\ PB",
"55513663", "Osório\ \-\ RS",
"55353535", "São\ Tomás\ de\ Aquino\ \-\ MG",
"55693733", "Porto\ Velho\ \-\ RO",
"55313538", "Esmeraldas\ \-\ MG",
"55773658", "Ibitiara\ \-\ BA",
"55964009", "Macapá\ \-\ AP",
"55643696", "Campo\ Alegre\ de\ Goiás\ \-\ GO",
"5548322", "Florianópolis\ \-\ SC",
"55413662", "Cerro\ Azul\ \-\ PR",
"55883426", "Banabuiú\ \-\ CE",
"55853375", "Pindoretama\ \-\ CE",
"55883425", "Ibicuitinga\ \-\ CE",
"55853376", "Guaiúba\ \-\ CE",
"55183367", "Borá\ \-\ SP",
"55643695", "Adelândia\ \-\ GO",
"5543302", "Londrina\ \-\ PR",
"55273770", "Colatina\ \-\ ES",
"55433451", "São\ Pedro\ do\ Ivaí\ \-\ PR",
"55543523", "Barão\ de\ Cotegipe\ \-\ RS",
"55484004", "Florianópolis\ \-\ SC",
"55743533", "Campo\ Alegre\ de\ Lourdes\ \-\ BA",
"55623626", "Goiânia\ \-\ GO",
"55813255", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55933536", "Juruti\ \-\ PA",
"55883617", "Tamboril\ \-\ CE",
"55473394", "Indaial\ \-\ SC",
"55643489", "Água\ Limpa\ \-\ GO",
"55633377", "Aliança\ do\ Tocantins\ \-\ TO",
"55654141", "Cuiabá\ \-\ MT",
"55333317", "Conceição\ de\ Ipanema\ \-\ MG",
"55773454", "Caetité\ \-\ BA",
"55913821", "Peixe\-Boi\ \-\ PA",
"55814112", "São\ Lourenço\ da\ Mata\ \-\ PE",
"55163509", "São\ Carlos\ \-\ SP",
"55833278", "Alagoinha\ \-\ PB",
"55813256", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55423649", "Guará\ \-\ PR",
"55733622", "Mucuri\ \-\ BA",
"55623625", "Aparecida\ de\ Goiânia\ \-\ GO",
"55143284", "Pederneiras\ \-\ SP",
"55173637", "Guzolândia\ \-\ SP",
"55473443", "Itapoá\ \-\ SC",
"55313913", "Contagem\ \-\ MG",
"55923531", "Barreirinha\ \-\ AM",
"55283533", "Rio\ Novo\ do\ Sul\ \-\ ES",
"55214007", "Rio\ de\ Janeiro\ \-\ RJ",
"55133272", "Santos\ \-\ SP",
"55883669", "Vila\ de\ Jericoacoara\ \-\ CE",
"55813751", "Frei\ Miguelinho\ \-\ PE",
"55192119", "Hortolândia\ \-\ SP",
"55222623", "Armação\ dos\ Búzios\ \-\ RJ",
"55353571", "Muzambinho\ \-\ MG",
"55863322", "Parnaíba\ \-\ PI",
"55112704", "São\ Paulo\ \-\ SP",
"55212687", "Itaguaí\ \-\ RJ",
"55683262", "Vila\ do\ V\ \-\ AC",
"55543336", "Ipiranga\ do\ Sul\ \-\ RS",
"55513567", "Santa\ Maria\ do\ Herval\ \-\ RS",
"55643450", "Marzagão\ \-\ GO",
"55433537", "Barra\ do\ Jacaré\ \-\ PR",
"55813542", "Abreu\ e\ Lima\ \-\ PE",
"55493562", "Pinheiro\ Preto\ \-\ SC",
"55273237", "Vitória\ \-\ ES",
"55843388", "Major\ Sales\ \-\ RN",
"55693447", "Parecis\ \-\ RO",
"55513381", "Rio\ Grande\ do\ Sul",
"55353691", "Três\ Corações\ \-\ MG",
"55153253", "Quadra\ \-\ SP",
"55663471", "Alto\ Garças\ \-\ MT",
"55993665", "Capinzal\ do\ Norte\ \-\ MA",
"55753426", "Rio\ Real\ \-\ BA",
"55733527", "Jequié\ \-\ BA",
"55623605", "Goiânia\ \-\ GO",
"55212791", "Nilópolis\ \-\ RJ",
"55313339", "Belo\ Horizonte\ \-\ MG",
"55883512", "Juazeiro\ do\ Norte\ \-\ CE",
"55993666", "Santo\ Antônio\ dos\ Lopes\ \-\ MA",
"55753425", "Cachoeira\ \-\ BA",
"55313210", "Minas\ Gerais",
"55143022", "Avaré\ \-\ SP",
"55653029", "Várzea\ Grande\ \-\ MT",
"55333743", "Felisburgo\ \-\ MG",
"55114961", "Itupeva\ \-\ SP",
"55163308", "Gavião\ Peixoto\ \-\ SP",
"55673438", "Laguna\ Carapã\ \-\ MS",
"55553435", "Maçambara\ \-\ RS",
"55353322", "Seritinga\ \-\ MG",
"55123876", "São\ José\ dos\ Campos\ \-\ SP",
"55893547", "São\ Miguel\ do\ Fidalgo\ \-\ PI",
"55133499", "Praia\ Grande\ \-\ SP",
"55843653", "Natal\ \-\ RN",
"55513662", "Santo\ Antônio\ da\ Patrulha\ \-\ RS",
"55273049", "Colatina\ \-\ ES",
"55213820", "Rio\ de\ Janeiro\ \-\ RJ",
"55863302", "Teresina\ \-\ PI",
"55813647", "Buenos\ Aires\ \-\ PE",
"55493667", "São\ Miguel\ da\ Boa\ Vista\ \-\ SC",
"55843475", "Equador\ \-\ RN",
"55843476", "Santana\ do\ Seridó\ \-\ RN",
"55793236", "Aracaju\ \-\ SE",
"55114066", "Diadema\ \-\ SP",
"55443523", "Campo\ Mourão\ \-\ PR",
"55743630", "Mirangaba\ \-\ BA",
"55413906", "Curitiba\ \-\ PR",
"55133871", "Eldorado\ \-\ SP",
"55753669", "Ponte\ 2\ de\ Julho\ \-\ BA",
"55943337", "Brejo\ Grande\ do\ Araguaia\ \-\ PA",
"55183581", "Flórida\ Paulista\ \-\ SP",
"55143382", "Fartura\ \-\ SP",
"55643576", "Itumbiara\ \-\ GO",
"55214133", "Magé\ \-\ RJ",
"55273090", "Cariacica\ \-\ ES",
"55643575", "Itumbiara\ \-\ GO",
"55313152", "Sete\ Lagoas\ \-\ MG",
"55123681", "Taubaté\ \-\ SP",
"55343515", "Patrocínio\ \-\ MG",
"55114819", "Franco\ da\ Rocha\ \-\ SP",
"55813709", "Belo\ Jardim\ \-\ PE",
"55683235", "Acrelândia\ \-\ AC",
"55513059", "Canoas\ \-\ RS",
"55543362", "Nonoai\ \-\ RS",
"55793364", "Telha\ \-\ SE",
"55493536", "Salto\ Veloso\ \-\ SC",
"55143456", "Oriente\ \-\ SP",
"55693411", "Ji\-Paraná\ \-\ RO",
"55183603", "Luiziânia\ \-\ SP",
"55493535", "Arroio\ Trinta\ \-\ SC",
"55222777", "Rio\ das\ Ostras\ \-\ RJ",
"55913637", "Melgaço\ \-\ PA",
"55673591", "Santa\ Rita\ do\ Pardo\ \-\ MS",
"55153544", "Ribeirão\ Grande\ \-\ SP",
"55833354", "Serra\ Branca\ \-\ PB",
"55154009", "Sorocaba\ \-\ SP",
"55383813", "Mato\ Verde\ \-\ MG",
"55833483", "Olho\ d\'Água\ \-\ PB",
"55543233", "Ipê\ \-\ RS",
"55753641", "Valença\ \-\ BA",
"55153141", "Sorocaba\ \-\ SP",
"55893588", "Anísio\ de\ Abreu\ \-\ PI",
"55353534", "Itamogi\ \-\ MG",
"55713605", "Candeias\ \-\ BA",
"55853123", "Caucaia\ \-\ CE",
"55323554", "Ervália\ \-\ MG",
"55983478", "Araioses\ \-\ MA",
"55663463", "Primavera\ do\ Leste\ \-\ MT",
"55813688", "São\ José\ da\ Coroa\ Grande\ \-\ PE",
"55483027", "Florianópolis\ \-\ SC",
"55143649", "Barra\ Bonita\ \-\ SC",
"5513336", "Cubatão\ \-\ SP",
"55212760", "Rio\ das\ Ostras\ \-\ RJ",
"55993537", "Senador\ La\ Roque\ \-\ MA",
"55873843", "Tacaratu\ \-\ PE",
"55114442", "Caieiras\ \-\ SP",
"55543618", "Nonoai\ \-\ RS",
"55193582", "Santa\ Rita\ do\ Passa\ Quatro\ \-\ SP",
"55923221", "Manaus\ \-\ AM",
"55493323", "Chapecó\ \-\ SC",
"55413635", "São\ José\ dos\ Pinhais\ \-\ PR",
"55112803", "Carapicuíba\ \-\ SP",
"55412626", "Curitiba\ \-\ PR",
"55443264", "Sarandi\ \-\ PR",
"55713267", "Salvador\ \-\ BA",
"55113361", "São\ Paulo\ \-\ SP",
"55983386", "Guimarães\ \-\ MA",
"55173202", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55983385", "Bequimão\ \-\ MA",
"55413636", "Balsa\ Nova\ \-\ PR",
"55213818", "Rio\ de\ Janeiro\ \-\ RJ",
"55873879", "Exu\ \-\ PE",
"55213987", "Rio\ de\ Janeiro\ \-\ RJ",
"55173566", "Embaúba\ \-\ SP",
"55313491", "Minas\ Gerais",
"55613961", "Brasília\ \-\ DF",
"55312146", "Sete\ Lagoas\ \-\ MG",
"55713626", "Camaçari\ \-\ BA",
"55833252", "João\ Pessoa\ \-\ PB",
"55963117", "Macapá\ \-\ AP",
"5511333", "São\ Paulo\ \-\ SP",
"55352101", "Poços\ de\ Caldas\ \-\ MG",
"55112136", "Jundiaí\ \-\ SP",
"55713625", "Dias\ d\'Ávila\ \-\ BA",
"55623441", "Catalão\ \-\ GO",
"5531334", "Minas\ Gerais",
"55733237", "Buerarema\ \-\ BA",
"55713417", "Salvador\ \-\ BA",
"55114032", "Bragança\ Paulista\ \-\ SP",
"55793262", "Barra\ dos\ Coqueiros\ \-\ SE",
"55823541", "Junqueiro\ \-\ AL",
"55513783", "Esteio\ \-\ RS",
"55213167", "Duque\ de\ Caxias\ \-\ RJ",
"55353563", "Bom\ Jesus\ da\ Penha\ \-\ MG",
"55553314", "Santo\ Ângelo\ \-\ RS",
"55513635", "São\ Sebastião\ do\ Caí\ \-\ RS",
"55883641", "Pacujá\ \-\ CE",
"55513636", "Rio\ Grande\ do\ Sul",
"55633659", "Ponte\ Alta\ do\ Bom\ Jesus\ \-\ TO",
"55183623", "Araçatuba\ \-\ SP",
"55333341", "Manhumirim\ \-\ MG",
"55973373", "Humaitá\ \-\ AM",
"55313843", "Antônio\ Dias\ \-\ MG",
"55913859", "Salinópolis\ \-\ PA",
"5512312", "Guaratinguetá\ \-\ SP",
"55673671", "Dourados\ \-\ MS",
"55323345", "Alto\ Rio\ Doce\ \-\ MG",
"55413059", "Pinhais\ \-\ PR",
"55153355", "Angatuba\ \-\ SP",
"55833545", "São\ Francisco\ \-\ PB",
"55474104", "São\ Bento\ do\ Sul\ \-\ SC",
"55423661", "Porto\ Barreiro\ \-\ PR",
"5561219", "Brasília\ \-\ DF",
"55323346", "Antônio\ Carlos\ \-\ MG",
"55613395", "Santa\ Maria\ \-\ DF",
"55213119", "São\ Gonçalo\ \-\ RJ",
"55943428", "Rio\ Maria\ \-\ PA",
"55212648", "Maricá\ \-\ RJ",
"55313879", "Belo\ Horizonte\ \-\ MG",
"55133258", "Santos\ \-\ SP",
"55993632", "Lago\ dos\ Rodrigues\ \-\ MA",
"55373353", "Iguatama\ \-\ MG",
"55433429", "Califórnia\ \-\ PR",
"55633446", "Sítio\ Novo\ do\ Tocantins\ \-\ TO",
"55123600", "São\ José\ dos\ Campos\ \-\ SP",
"55863131", "Teresina\ \-\ PI",
"55443233", "Mandaguari\ \-\ PR",
"55793526", "Estância\ \-\ SE",
"55173801", "Riolândia\ \-\ SP",
"55463540", "Pranchita\ \-\ PR",
"55153278", "Pilar\ do\ Sul\ \-\ SP",
"55353701", "Alfenas\ \-\ MG",
"55213980", "Rio\ de\ Janeiro\ \-\ RJ",
"55543232", "Vacaria\ \-\ RS",
"55924002", "Manaus\ \-\ AM",
"55173848", "Gastão\ Vidigal\ \-\ SP",
"55833482", "Imaculada\ \-\ PB",
"55383812", "Espinosa\ \-\ MG",
"55313746", "Piranga\ \-\ MG",
"55694062", "Porto\ Velho\ \-\ RO",
"55713183", "Salvador\ \-\ BA",
"55114891", "Bom\ Jesus\ dos\ Perdões\ \-\ SP",
"55133862", "Colonização\ \-\ SP",
"55193837", "Jaguariúna\ \-\ SP",
"55183602", "Gabriel\ Monteiro\ \-\ SP",
"55513671", "Camaquã\ \-\ RS",
"55212767", "Nova\ Iguaçu\ \-\ RJ",
"55133375", "Cubatão\ \-\ SP",
"55543363", "Constantina\ \-\ RS",
"55343514", "Cachoeira\ Dourada\ \-\ MG",
"55812129", "Recife\ \-\ PE",
"5513323", "Santos\ \-\ SP",
"55173203", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55932101", "Santarém\ \-\ PA",
"55753424", "Muritiba\ \-\ BA",
"55242723", "Campos\ dos\ Goitacazes\ \-\ RJ",
"55493322", "Chapecó\ \-\ SC",
"55193583", "Descalvado\ \-\ SP",
"55114443", "Franco\ da\ Rocha\ \-\ SP",
"55873842", "Ibimirim\ \-\ PE",
"55933563", "Curuá\ \-\ PA",
"55753628", "São\ Felipe\ \-\ BA",
"55313241", "Belo\ Horizonte\ \-\ MG",
"55883404", "Russas\ \-\ CE",
"55333529", "Teófilo\ Otoni\ \-\ MG",
"55222793", "Macaé\ \-\ RJ",
"55183622", "Araçatuba\ \-\ SP",
"55463547", "Ampére\ \-\ PR",
"55922125", "Manaus\ \-\ AM",
"55143285", "Cabrália\ Paulista\ \-\ SP",
"55123607", "Tremembé\ \-\ SP",
"55773673", "Oliveira\ dos\ Brejinhos\ \-\ BA",
"55143286", "Lucianópolis\ \-\ SP",
"55123522", "Pindamonhangaba\ \-\ SP",
"55353562", "Nova\ Resende\ \-\ MG",
"55513782", "Santa\ Clara\ do\ Sul\ \-\ RS",
"55793263", "Capela\ \-\ SE",
"55114033", "Bragança\ Paulista\ \-\ SP",
"55115704", "Itupeva\ \-\ SP",
"55543334", "Colorado\ \-\ RS",
"55133261", "Santos\ \-\ SP",
"55114292", "Suzano\ \-\ SP",
"55112705", "São\ Paulo\ \-\ SP",
"55353721", "Poços\ de\ Caldas\ \-\ MG",
"55833253", "Bayeux\ \-\ PB",
"55623877", "Goiânia\ \-\ GO",
"55663212", "Sorriso\ \-\ MT",
"55113559", "São\ Paulo\ \-\ SP",
"55753608", "Barrocas\ \-\ BA",
"55482102", "Criciúma\ \-\ SC",
"55443232", "Marialva\ \-\ PR",
"55353226", "Luminárias\ \-\ MG",
"55115696", "São\ Paulo\ \-\ SP",
"55115695", "São\ Paulo\ \-\ SP",
"55353225", "Carmo\ da\ Cachoeira\ \-\ MG",
"55513591", "São\ Leopoldo\ \-\ RS",
"55993633", "Lagoa\ Grande\ do\ Maranhão\ \-\ MA",
"55733230", "Ubaitaba\ \-\ BA",
"55373352", "Arcos\ \-\ MG",
"55643694", "Palmelo\ \-\ GO",
"55883424", "Tabuleiro\ do\ Norte\ \-\ CE",
"55773456", "Urandi\ \-\ BA",
"55333328", "Alvarenga\ \-\ MG",
"55473065", "Balneário\ Camboriú\ \-\ SC",
"55883628", "Santa\ Quitéria\ \-\ CE",
"55473395", "Pomerode\ \-\ SC",
"55643498", "Professor\ Jamil\ \-\ GO",
"55623624", "Goiânia\ \-\ GO",
"55112822", "Osasco\ \-\ SP",
"55933534", "Prainha\ \-\ PA",
"55473396", "Brusque\ \-\ SC",
"55413671", "Quatro\ Barras\ \-\ PR",
"55823528", "Lagoa\ da\ Canoa\ \-\ AL",
"55323015", "Juiz\ de\ Fora\ \-\ MG",
"55614501", "Brasília\ \-\ DF",
"55773455", "Caculé\ \-\ BA",
"55313842", "Coronel\ Fabriciano\ \-\ MG",
"55713633", "Vera\ Cruz\ \-\ BA",
"55113133", "São\ Paulo\ \-\ SP",
"55373553", "Estrela\ do\ Indaiá\ \-\ MG",
"55873878", "Bodocó\ \-\ PE",
"55813495", "Olinda\ \-\ PE",
"55983394", "Carutapera\ \-\ MA",
"55653347", "Assari\ \-\ MT",
"5519363", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55893550", "Jerumenha\ \-\ PI",
"55483091", "Florianópolis\ \-\ SC",
"55153556", "Iporanga\ \-\ SP",
"55173101", "Uchoa\ \-\ SP",
"55443562", "Araruna\ \-\ PR",
"55833346", "Barra\ de\ Santana\ \-\ PB",
"55153555", "Ribeira\ \-\ SP",
"55833345", "Caturité\ \-\ PB",
"55813689", "Jaqueira\ \-\ PE",
"55613595", "Sobradinho\ \-\ DF",
"55183636", "Araçatuba\ \-\ SP",
"55114820", "Rio\ Grande\ da\ Serra\ \-\ SP",
"55513623", "Rio\ Grande\ do\ Sul",
"55893589", "Caracol\ \-\ PI",
"55823341", "Maceió\ \-\ AL",
"55112836", "São\ Paulo\ \-\ SP",
"55353363", "Itamonte\ \-\ MG",
"55983479", "Tutóia\ \-\ MA",
"55343213", "Uberlândia\ \-\ MG",
"55273327", "Vitória\ \-\ ES",
"55413603", "Itaperuçu\ \-\ PR",
"55843642", "Natal\ \-\ RN",
"55733634", "Ilhéus\ \-\ BA",
"55313229", "Minas\ Gerais",
"55112835", "São\ Caetano\ do\ Sul\ \-\ SP",
"55222519", "Nova\ Friburgo\ \-\ RJ",
"55163145", "Patrocínio\ Paulista\ \-\ SP",
"55153242", "Votorantim\ \-\ SP",
"5511353", "São\ Paulo\ \-\ SP",
"55543701", "Bento\ Gonçalves\ \-\ RS",
"55613004", "Brasília\ \-\ DF",
"55923030", "Manaus\ \-\ AM",
"55163146", "Itirapuã\ \-\ SP",
"55813708", "Bezerros\ \-\ PE",
"55473631", "São\ Bento\ do\ Sul\ \-\ SC",
"55323252", "Santos\ Dumont\ \-\ MG",
"55773621", "Cotegipe\ \-\ BA",
"55173121", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55493523", "Luzerna\ \-\ SC",
"55163351", "São\ Carlos\ \-\ SP",
"55513603", "Rainha\ do\ Mar\ \-\ RS",
"55313878", "Contagem\ \-\ MG",
"55212649", "Cachoeiras\ de\ Macacu\ \-\ RJ",
"55173524", "Catanduva\ \-\ SP",
"55433428", "Marilândia\ do\ Sul\ \-\ PR",
"55893475", "Novo\ Oriente\ do\ Piauí\ \-\ PI",
"55813553", "Amaraji\ \-\ PE",
"55443667", "Santa\ Eliza\ \-\ PR",
"55863363", "Buriti\ dos\ Lopes\ \-\ PI",
"55112970", "Barueri\ \-\ SP",
"55213584", "Nova\ Iguaçu\ \-\ RJ",
"55613453", "Sobradinho\ \-\ DF",
"55623923", "Goiânia\ \-\ GO",
"55473452", "Araquari\ \-\ SC",
"55222662", "Arraial\ do\ Cabo\ \-\ RJ",
"5513356", "São\ Vicente\ \-\ SP",
"55213118", "Rio\ de\ Janeiro\ \-\ RJ",
"55483276", "Alfredo\ Wagner\ \-\ SC",
"55483275", "Rancho\ Queimado\ \-\ SC",
"55212673", "Duque\ de\ Caxias\ \-\ RJ",
"55413058", "São\ José\ dos\ Pinhais\ \-\ PR",
"55153344", "Piedade\ \-\ SP",
"55684001", "Rio\ Branco\ \-\ AC",
"55833554", "Nazarezinho\ \-\ PB",
"55193022", "Mogi\ Mirim\ \-\ SP",
"55633658", "Aurora\ do\ Tocantins\ \-\ TO",
"55313615", "Belo\ Horizonte\ \-\ MG",
"55643447", "Corumbaíba\ \-\ GO",
"55353334", "Carmo\ de\ Minas\ \-\ MG",
"55813728", "Bezerros\ \-\ PE",
"55193707", "Campinas\ \-\ SP",
"5551329", "Rio\ Grande\ do\ Sul",
"55273194", "Vitória\ \-\ ES",
"55323354", "Resende\ Costa\ \-\ MG",
"55613024", "Brasília\ \-\ DF",
"55443619", "Cianorte\ \-\ PR",
"55493336", "Guatambú\ \-\ SC",
"55173271", "Neves\ Paulista\ \-\ SP",
"55633383", "Cariri\ do\ Tocantins\ \-\ TO",
"55353831", "Campo\ Belo\ \-\ MG",
"55242106", "Barra\ Mansa\ \-\ RJ",
"55493335", "Planalto\ Alegre\ \-\ SC",
"55413623", "Quitandinha\ \-\ PR",
"55633454", "Aguiarnópolis\ \-\ TO",
"55193661", "Espírito\ Santo\ do\ Pinhal\ \-\ SP",
"55893431", "Padre\ Marcos\ \-\ PI",
"55333528", "Teófilo\ Otoni\ \-\ MG",
"55833015", "João\ Pessoa\ \-\ PB",
"55513622", "Arroio\ Teixeira\ \-\ RS",
"55854003", "Fortaleza\ \-\ CE",
"55283524", "Vargem\ Grande\ do\ Soturno\ \-\ ES",
"55114025", "Itu\ \-\ SP",
"55863264", "José\ de\ Freitas\ \-\ PI",
"55143377", "São\ Pedro\ do\ Turvo\ \-\ SP",
"55493627", "Paraíso\ \-\ SC",
"55443563", "Farol\ \-\ PR",
"55214501", "Rio\ de\ Janeiro\ \-\ RJ",
"55813657", "Ferreiros\ \-\ PE",
"55114026", "Itu\ \-\ SP",
"55753629", "Conceição\ do\ Almeida\ \-\ BA",
"55313754", "Lamim\ \-\ MG",
"55442101", "Maringá\ \-\ PR",
"55483231", "Florianópolis\ \-\ SC",
"55843398", "Serrinha\ dos\ Pintos\ \-\ RN",
"55913774", "São\ Francisco\ do\ Pará\ \-\ PA",
"55433031", "Londrina\ \-\ PR",
"55713632", "Pólo\ Petroquímico\ Camaçari\ \-\ BA",
"55273080", "Serra\ \-\ ES",
"55543534", "Caxias\ do\ Sul\ \-\ RS",
"55453055", "Toledo\ \-\ PR",
"55333753", "Medina\ \-\ MG",
"55613631", "Formosa\ \-\ GO",
"55323253", "Tabuleiro\ \-\ MG",
"55192107", "Indaiatuba\ \-\ SP",
"55923249", "Manaus\ \-\ AM",
"55423035", "Guarapuava\ \-\ PR",
"55423036", "Guarapuava\ \-\ PR",
"55153243", "Votorantim\ \-\ SP",
"55993626", "Pedreiras\ \-\ MA",
"55813138", "Caruaru\ \-\ PE",
"55453056", "Toledo\ \-\ PR",
"55113359", "São\ Paulo\ \-\ SP",
"55893557", "Nazaré\ do\ Piauí\ \-\ PI",
"55843643", "Parnamirim\ \-\ RN",
"55343212", "Uberlândia\ \-\ MG",
"55123322", "São\ José\ dos\ Campos\ \-\ SP",
"55153279", "Sao\ Miguel\ Arcanjo\ \-\ SP",
"55484107", "Palhoça\ \-\ SC",
"55173849", "Macedônia\ \-\ SP",
"55373246", "Igaratinga\ \-\ MG",
"55813741", "Toritama\ \-\ PE",
"55193454", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55823529", "Arapiraca\ \-\ AL",
"55443534", "Mariluz\ \-\ PR",
"55333329", "Caratinga\ \-\ MG",
"55473384", "Rodeio\ \-\ SC",
"55153492", "Salto\ de\ Pirapora\ \-\ SP",
"55623922", "Goiânia\ \-\ GO",
"55473453", "Joinville\ \-\ SC",
"55112685", "São\ Paulo\ \-\ SP",
"55883629", "Novo\ Oriente\ \-\ CE",
"55863362", "Cocal\ \-\ PI",
"55813552", "Ipojuca\ \-\ PE",
"55114005", "São\ Paulo\ \-\ SP",
"55643685", "Ivolândia\ \-\ GO",
"55333508", "Governador\ Valadares\ \-\ MG",
"55513602", "Caraá\ \-\ RS",
"55643440", "Cumari\ \-\ GO",
"55423446", "Prudentópolis\ \-\ PR",
"55623429", "Posse\ \-\ GO",
"55753609", "Bravo\ \-\ BA",
"55643686", "Moiporá\ \-\ GO",
"55493522", "Joaçaba\ \-\ SC",
"55913412", "Castanhal\ \-\ PA",
"55143601", "Jaú\ \-\ SP",
"55433441", "Marumbi\ \-\ PR",
"55413622", "Lapa\ \-\ PR",
"55133576", "São\ Vicente\ \-\ SP",
"55733021", "Prado\ \-\ BA",
"55973321", "Barcelos\ \-\ AM",
"55123224", "Caçapava\ \-\ SP",
"55212697", "Mesquita\ \-\ RJ",
"55773648", "Novo\ Horizonte\ \-\ BA",
"55123302", "São\ José\ dos\ Campos\ \-\ SP",
"55353264", "Elói\ Mendes\ \-\ MG",
"55114594", "Itatiba\ \-\ SP",
"55542991", "Caxias\ do\ Sul\ \-\ RS",
"55333089", "Governador\ Valadares\ \-\ MG",
"55542101", "Caxias\ do\ Sul\ \-\ RS",
"55423659", "Samambaia\ \-\ PR",
"55143767", "Coronel\ Macedo\ \-\ SP",
"55192127", "Campinas\ \-\ SP",
"55773444", "Livramento\ de\ Nossa\ Senhora\ \-\ BA",
"55713451", "Salvador\ \-\ BA",
"55143294", "Iacanga\ \-\ SP",
"55533031", "Pelotas\ \-\ RS",
"55193023", "Rio\ Claro\ \-\ SP",
"55733662", "Jucuruçu\ \-\ BA",
"55413391", "Campo\ Largo\ \-\ PR",
"55413061", "Curitiba\ \-\ PR",
"55343811", "Presidente\ Olegário\ \-\ MG",
"55923328", "Rio\ Preto\ da\ Eva\ \-\ AM",
"55623956", "Goiânia\ \-\ GO",
"55383634", "Chapada\ Gaúcha\ \-\ MG",
"55163983", "Luís\ Antônio\ \-\ SP",
"55123141", "Cruzeiro\ \-\ SP",
"55713029", "Lauro\ de\ Freitas\ \-\ BA",
"55183644", "Birigui\ \-\ SP",
"55323534", "Brás\ Pires\ \-\ MG",
"55453284", "Marechal\ Cândido\ Rondon\ \-\ PR",
"55543253", "Jaquirana\ \-\ RS",
"55353554", "São\ Pedro\ da\ União\ \-\ MG",
"55493556", "Brunópolis\ \-\ SC",
"55813525", "São\ Lourenço\ da\ Mata\ \-\ PE",
"551130", "São\ Paulo\ \-\ SP",
"55863346", "São\ José\ do\ Divino\ \-\ PI",
"55433399", "Tamarana\ \-\ PR",
"55193889", "Monte\ Mor\ \-\ SP",
"55513039", "Sapiranga\ \-\ RS",
"55613617", "Águas\ Lindas\ de\ Goiás\ \-\ GO",
"55483269", "Florianópolis\ \-\ SC",
"55413473", "Caiobá\ \-\ PR",
"55493555", "Capinzal\ \-\ SC",
"55813526", "Vitória\ de\ Santo\ Antão\ \-\ PE",
"55863345", "São\ João\ da\ Fronteira\ \-\ PI",
"55112341", "São\ Paulo\ \-\ SP",
"55883442", "Madalena\ \-\ CE",
"55313321", "Minas\ Gerais",
"55843220", "Natal\ \-\ RN",
"55273401", "Baixo\ Guandu\ \-\ ES",
"55773471", "Paramirim\ \-\ BA",
"55115845", "São\ Paulo\ \-\ SP",
"55613669", "Valparaíso\ de\ Goiás\ \-\ GO",
"55312", "Minas\ Gerais",
"55413656", "Colombo\ \-\ PR",
"55163134", "Jeriquara\ \-\ SP",
"55433017", "Londrina\ \-\ PR",
"55213433", "Rio\ de\ Janeiro\ \-\ RJ",
"55433474", "Grandes\ Rios\ \-\ PR",
"55493242", "São\ José\ do\ Cerrito\ \-\ SC",
"55623642", "Goiânia\ \-\ GO",
"55733645", "Medeiros\ Neto\ \-\ BA",
"55443482", "Paranavaí\ \-\ PR",
"55683542", "Xapuri\ \-\ AC",
"55823273", "Coruripe\ \-\ AL",
"55993557", "Nova\ Iorque\ \-\ MA",
"55513655", "General\ Câmara\ \-\ RS",
"55114052", "São\ Paulo\ \-\ SP",
"55663023", "Rondonópolis\ \-\ MT",
"55733257", "Nilo\ Peçanha\ \-\ BA",
"55153523", "Caputera\ \-\ SP",
"55143847", "Itatinga\ \-\ SP",
"55483467", "Içara\ \-\ SC",
"55833363", "Solânea\ \-\ PB",
"55793611", "Simão\ Dias\ \-\ SE",
"55383663", "Buritis\ \-\ MG",
"55913741", "Soure\ \-\ PA",
"55313572", "Itatiaiuçu\ \-\ MG",
"55513656", "Arroio\ dos\ Ratos\ \-\ RS",
"55133854", "Cajati\ \-\ SP",
"55114641", "Itaquaquecetuba\ \-\ SP",
"55833232", "Bayeux\ \-\ PB",
"55813412", "Recife\ \-\ PE",
"55313166", "Belo\ Horizonte\ \-\ MG",
"55322101", "Juiz\ de\ Fora\ \-\ MG",
"55313165", "Santa\ Luzia\ \-\ MG",
"55373525", "Moema\ \-\ MG",
"55493344", "São\ Lourenço\ do\ Oeste\ \-\ SC",
"55213668", "São\ João\ de\ Meriti\ \-\ RJ",
"55813094", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55113418", "Taboão\ da\ Serra\ \-\ SP",
"55373333", "Carmópolis\ de\ Minas\ \-\ MG",
"55983465", "Nina\ Rodrigues\ \-\ MA",
"55443253", "Maringá\ \-\ PR",
"55323748", "Pedra\ Dourada\ \-\ MG",
"55173012", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55983466", "Pirapemas\ \-\ MA",
"55513449", "Rio\ Grande\ do\ Sul",
"55173343", "Bebedouro\ \-\ SP",
"55513490", "Gravataí\ \-\ RS",
"55673240", "Aquidauana\ \-\ MS",
"55153336", "Sorocaba\ \-\ SP",
"55353345", "Carvalhos\ \-\ MG",
"55813861", "Petrolina\ \-\ PE",
"55513473", "Esteio\ \-\ RS",
"55353346", "Cruzília\ \-\ MG",
"55373262", "Lagoa\ da\ Prata\ \-\ MG",
"55153335", "Sorocaba\ \-\ SP",
"55193857", "Engenheiro\ Coelho\ \-\ SP",
"55163489", "Serrana\ \-\ SP",
"55413472", "Guaratuba\ \-\ PR",
"55673473", "Eldorado\ \-\ MS",
"55623398", "Itaguaru\ \-\ GO",
"5531320", "Minas\ Gerais",
"55114789", "Jandira\ \-\ SP",
"55423463", "Rio\ Azul\ \-\ PR",
"55383567", "Varjão\ de\ Minas\ \-\ MG",
"55823297", "Japaratinga\ \-\ AL",
"55213747", "Rio\ de\ Janeiro\ \-\ RJ",
"55673449", "Nova\ Andradina\ \-\ MS",
"556232", "Goiânia\ \-\ GO",
"55793254", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55153416", "Votorantim\ \-\ SP",
"55163982", "Serra\ Azul\ \-\ SP",
"55843227", "São\ Gonçalo\ do\ Amarante\ \-\ RN",
"55222645", "Cabo\ Frio\ \-\ RJ",
"55473426", "Joinville\ \-\ SC",
"55513714", "Lajeado\ \-\ RS",
"55823272", "Barra\ de\ São\ Miguel\ \-\ AL",
"55193055", "Pirassununga\ \-\ SP",
"55653291", "Cáceres\ \-\ MT",
"55343071", "Uberaba\ \-\ MG",
"55853329", "Aratuba\ \-\ CE",
"55114608", "Francisco\ Morato\ \-\ SP",
"55643088", "Itumbiara\ \-\ GO",
"55193056", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55373234", "São\ Gonçalo\ do\ Pará\ \-\ MG",
"55623643", "Goiânia\ \-\ GO",
"55493243", "Correia\ Pinto\ \-\ SC",
"55213432", "Rio\ de\ Janeiro\ \-\ RJ",
"55973427", "Juruá\ \-\ AM",
"55543546", "Faxinalzinho\ \-\ RS",
"55112088", "Guarulhos\ \-\ SP",
"55753277", "Antas\ \-\ BA",
"55163704", "Franca\ \-\ SP",
"55883443", "Quixeré\ \-\ CE",
"55493279", "Rio\ Rufino\ \-\ SC",
"55183421", "Assis\ \-\ SP",
"55793352", "Neópolis\ \-\ SE",
"55333221", "Governador\ Valadares\ \-\ MG",
"55823686", "Xingó\ \-\ AL",
"55313549", "Minas\ Gerais",
"55314004", "Belo\ Horizonte\ \-\ MG",
"55883585", "Iguatu\ \-\ CE",
"55843429", "Jucurutu\ \-\ RN",
"55323721", "Muriaé\ \-\ MG",
"55423434", "Guamirim\ \-\ PR",
"55543354", "Esmeralda\ \-\ RS",
"55473405", "Itajaí\ \-\ SC",
"55473406", "Balneário\ Camboriú\ \-\ SC",
"55883586", "Crato\ \-\ CE",
"55813413", "Recife\ \-\ PE",
"55513497", "Gravataí\ \-\ RS",
"55673247", "Costa\ Rica\ \-\ MS",
"55143471", "Garça\ \-\ SP",
"5531322", "Belo\ Horizonte\ \-\ MG",
"55313573", "Rio\ Manso\ \-\ MG",
"55383662", "Buritis\ \-\ MG",
"55483538", "Balneário\ Bela\ Torres\ \-\ SC",
"55833362", "Areia\ \-\ PB",
"55443546", "Quarto\ Centenário\ \-\ PR",
"55733289", "Itagimirim\ \-\ BA",
"55443545", "Yolanda\ \-\ PR",
"55313590", "Minas\ Gerais",
"55153522", "Itapeva\ \-\ SP",
"55663022", "Rondonópolis\ \-\ MT",
"55423638", "Candói\ \-\ PR",
"55163287", "Vista\ Alegre\ do\ Alto\ \-\ SP",
"55693238", "Buritis\ \-\ RO",
"55913728", "Concórdia\ do\ Pará\ \-\ PA",
"55114424", "Santo\ André\ \-\ SP",
"55773436", "Barra\ do\ Choça\ \-\ BA",
"55513472", "Canoas\ \-\ RS",
"55653624", "Cuiabá\ \-\ MT",
"55183401", "Valparaíso\ \-\ SP",
"55993311", "Açailândia\ \-\ MA",
"55773435", "Anagé\ \-\ BA",
"55353015", "Varginha\ \-\ MG",
"55163724", "Franca\ \-\ SP",
"55123108", "Aparecida\ \-\ SP",
"55173342", "Bebedouro\ \-\ SP",
"55333726", "Jordânia\ \-\ MG",
"55143316", "Marília\ \-\ SP",
"55153266", "Iperó\ \-\ SP",
"55443252", "Nova\ Esperança\ \-\ PR",
"55373332", "São\ Francisco\ de\ Paula\ \-\ MG",
"55753443", "Crisópolis\ \-\ BA",
"55833077", "Campina\ Grande\ \-\ PB",
"55333725", "Salto\ da\ Divisa\ \-\ MG",
"55183655", "Barbosa\ \-\ SP",
"55624015", "Anápolis\ \-\ GO",
"55353545", "Ibiraci\ \-\ MG",
"55824002", "Maceió\ \-\ AL",
"55153535", "Nova\ Campina\ \-\ SP",
"55173579", "Botelho\ \-\ SP",
"55183656", "Jatobá\ \-\ SP",
"55663583", "Vera\ \-\ MT",
"55313397", "Contagem\ \-\ MG",
"55493544", "Campos\ Novos\ \-\ SC",
"55313067", "Itabira\ \-\ MG",
"55113153", "São\ Paulo\ \-\ SP",
"55623347", "Campinorte\ \-\ GO",
"55273299", "Vila\ Velha\ \-\ ES",
"55683244", "Rio\ Branco\ \-\ AC",
"55173543", "Novo\ Horizonte\ \-\ SP",
"55343454", "Carneirinho\ \-\ MG",
"55483268", "Leoberto\ Leal\ \-\ SC",
"5516336", "São\ Carlos\ \-\ SP",
"55115854", "São\ Paulo\ \-\ SP",
"55193811", "Mogi\-Guaçu\ \-\ SP",
"55832101", "Campina\ Grande\ \-\ PB",
"55633463", "Aragominas\ \-\ TO",
"55193888", "Paulínia\ \-\ SP",
"55193917", "Ribeirão\ Preto\ \-\ SP",
"55433398", "Tamarana\ \-\ PR",
"55333732", "Comercinho\ \-\ MG",
"55463227", "Vitorino\ \-\ PR",
"55513038", "Campo\ Bom\ \-\ RS",
"55743647", "Jussara\ \-\ BA",
"55443015", "Marialva\ \-\ PR",
"55463902", "Pato\ Branco\ \-\ PR",
"55313865", "Coronel\ Fabriciano\ \-\ MG",
"55853341", "Maranguape\ \-\ CE",
"55323363", "Lagoa\ Dourada\ \-\ MG",
"55893468", "Aroazes\ \-\ PI",
"55213512", "Rio\ de\ Janeiro\ \-\ RJ",
"55613043", "Brasília\ \-\ DF",
"55183942", "Gardênia\ \-\ SP",
"55443016", "Campo\ Mourão\ \-\ PR",
"55623010", "Senador\ Canedo\ \-\ GO",
"55313372", "Minas\ Gerais",
"55313866", "Dom\ Joaquim\ \-\ MG",
"5585349", "Fortaleza\ \-\ CE",
"55863252", "Campo\ Maior\ \-\ PI",
"55112752", "São\ Paulo\ \-\ SP",
"55613433", "Brasília\ \-\ DF",
"556733", "Campo\ Grande\ \-\ MS",
"5582332", "Maceió\ \-\ AL",
"55683342", "Rodrigues\ Alves\ \-\ AC",
"55313762", "Conselheiro\ Lafaiete\ \-\ MG",
"55643541", "Itumbiara\ \-\ GO",
"55283542", "Castelo\ \-\ ES",
"55513448", "Rio\ Grande\ do\ Sul",
"55323749", "Faria\ Lemos\ \-\ MG",
"55223051", "Macaé\ \-\ RJ",
"55133846", "Pedro\ Barros\ \-\ SP",
"55813086", "Recife\ \-\ PE",
"55543015", "Erechim\ \-\ RS",
"55313521", "Ibirité\ \-\ MG",
"5521271", "Niterói\ \-\ RJ",
"55813533", "Gravatá\ \-\ PE",
"55613799", "Brasília\ \-\ DF",
"55173485", "Valentim\ Gentil\ \-\ SP",
"55493356", "Arvoredo\ \-\ SC",
"55213078", "Rio\ de\ Janeiro\ \-\ RJ",
"55773402", "Vitória\ da\ Conquista\ \-\ BA",
"55613214", "Brasília\ \-\ DF",
"55633434", "Juarina\ \-\ TO",
"55553791", "Palmitinho\ \-\ RS",
"55353851", "Boa\ Esperança\ \-\ MG",
"55173486", "Álvares\ Florence\ \-\ SP",
"55493355", "Lajeado\ Grande\ \-\ SC",
"55923528", "Silves\ \-\ AM",
"55163258", "Fernando\ Prestes\ \-\ SP",
"55343003", "Uberlândia\ \-\ MG",
"55833534", "Uiraúna\ \-\ PB",
"55743542", "Senhor\ do\ Bonfim\ \-\ BA",
"55433540", "Rancho\ Alegre\ \-\ PR",
"55323334", "Santana\ do\ Garambéu\ \-\ MG",
"55873865", "Dormentes\ \-\ PE",
"55813887", "Orocó\ \-\ PE",
"55383237", "Claro\ dos\ Poções\ \-\ MG",
"55173699", "Pontalinda\ \-\ SP",
"55173542", "Novo\ Horizonte\ \-\ SP",
"55483251", "Florianópolis\ \-\ SC",
"55973491", "Carauari\ \-\ AM",
"55213938", "Rio\ de\ Janeiro\ \-\ RJ",
"55493278", "Urubici\ \-\ SC",
"55743699", "Lapão\ \-\ BA",
"55433051", "Rolândia\ \-\ PR",
"55943347", "Eldorado\ dos\ Carajás\ \-\ PA",
"55883674", "Acaraú\ \-\ CE",
"55113152", "São\ Paulo\ \-\ SP",
"55713652", "São\ Francisco\ do\ Conde\ \-\ BA",
"5543342", "Apucarana\ \-\ PR",
"55663582", "Gaúcha\ do\ Norte\ \-\ MT",
"55463220", "Pato\ Branco\ \-\ PR",
"55643089", "Itumbiara\ \-\ GO",
"55743640", "Presidente\ Dutra\ \-\ BA",
"55122139", "São\ José\ dos\ Campos\ \-\ SP",
"55714109", "Salvador\ \-\ BA",
"55114609", "Francisco\ Morato\ \-\ SP",
"55473464", "Joinville\ \-\ SC",
"55893451", "Santo\ Inácio\ do\ Piauí\ \-\ PI",
"55222654", "Sampaio\ Correia\ \-\ RJ",
"55873763", "Garanhuns\ \-\ PE",
"5548", "Santa\ Catarina",
"55313734", "Belo\ Vale\ \-\ MG",
"55813637", "Aliança\ \-\ PE",
"55853328", "Mulungu\ \-\ CE",
"55193463", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55713041", "Camaçari\ \-\ BA",
"55143402", "Marília\ \-\ SP",
"55313373", "Belo\ Horizonte\ \-\ MG",
"55173256", "Santa\ Luzia\ \-\ SP",
"55473312", "Timbó\ \-\ SC",
"55343661", "Araxá\ \-\ MG",
"55833562", "Poço\ Dantas\ \-\ PB",
"55623340", "São\ Patrício\ \-\ GO",
"55893537", "Eliseu\ Martins\ \-\ PI",
"55213513", "Rio\ de\ Janeiro\ \-\ RJ",
"55843291", "Santa\ Cruz\ \-\ RN",
"55313390", "Minas\ Gerais",
"55443810", "Campo\ Mourão\ \-\ PR",
"55513401", "Guaíba\ \-\ RS",
"55673448", "Deodápolis\ \-\ MS",
"55323362", "Barbacena\ \-\ MG",
"55413978", "Antonina\ \-\ PR",
"55962101", "Macapá\ \-\ AP",
"55843604", "Parnamirim\ \-\ RN",
"55333733", "Itinga\ \-\ MG",
"55453035", "Cascavel\ \-\ PR",
"55913484", "Santarém\ Novo\ \-\ PA",
"55163411", "São\ Carlos\ \-\ SP",
"55453036", "Cascavel\ \-\ PR",
"55163488", "São\ Simão\ \-\ SP",
"55823221", "Maceió\ \-\ AL",
"55115612", "São\ Paulo\ \-\ SP",
"555133", "Porto\ Alegre\ \-\ RS",
"55153571", "Riversul\ \-\ SP",
"55543346", "Ciríaco\ \-\ RS",
"55433547", "Figueira\ \-\ PR",
"55753674", "Cruz\ das\ Almas\ \-\ BA",
"55242251", "Três\ Rios\ \-\ RJ",
"55543345", "Sertão\ \-\ RS",
"55753025", "Feira\ de\ Santana\ \-\ BA",
"55343284", "Araporã\ \-\ MG",
"55283543", "Ibatiba\ \-\ ES",
"55443554", "Assis\ Chateaubriand\ \-\ PR",
"55313763", "Conselheiro\ Lafaiete\ \-\ MG",
"55683343", "Mâncio\ Lima\ \-\ AC",
"55673038", "Dourados\ \-\ MS",
"55913729", "Paragominas\ \-\ PA",
"554133", "Curitiba\ \-\ PR",
"55613432", "Formosa\ \-\ GO",
"55213610", "Niterói\ \-\ RJ",
"55112753", "São\ Paulo\ \-\ SP",
"55863253", "Juazeiro\ do\ Piauí\ \-\ PI",
"55733211", "Itabuna\ \-\ BA",
"55713431", "Salvador\ \-\ BA",
"55693239", "Campo\ Novo\ de\ Rondônia\ \-\ RO",
"55243328", "Barra\ Mansa\ \-\ RJ",
"55423639", "Foz\ do\ Jordão\ \-\ PR",
"55123014", "Jacareí\ \-\ SP",
"55823201", "Maceió\ \-\ AL",
"55733288", "Porto\ Seguro\ \-\ BA",
"55483539", "São\ João\ do\ Sul\ \-\ SC",
"5571321", "Salvador\ \-\ BA",
"55333297", "Santa\ Efigênia\ de\ Minas\ \-\ MG",
"55623598", "Aparecida\ de\ Goiânia\ \-\ GO",
"55313548", "Minas\ Gerais",
"55333764", "Minas\ Novas\ \-\ MG",
"55553931", "Santo\ Ângelo\ \-\ RS",
"55843428", "São\ Fernando\ \-\ RN",
"55323264", "Guarará\ \-\ MG",
"55513421", "Gravataí\ \-\ RS",
"55153302", "Sorocaba\ \-\ SP",
"55112528", "São\ Paulo\ \-\ SP",
"55484053", "Criciúma\ \-\ SC",
"55313276", "Minas\ Gerais",
"55173353", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55443243", "São\ Jorge\ do\ Ivaí\ \-\ PR",
"55173484", "Monções\ \-\ SP",
"55623557", "Campestre\ de\ Goiás\ \-\ GO",
"55513459", "Esteio\ \-\ RS",
"55212638", "Maricá\ \-\ RJ",
"55493354", "Marema\ \-\ SC",
"55162133", "Ribeirão\ Preto\ \-\ SP",
"55993642", "Pedreiras\ \-\ MA",
"55753452", "Itatim\ \-\ BA",
"55433511", "Jacarezinho\ \-\ PR",
"55864009", "Teresina\ \-\ PI",
"55633435", "Arapoema\ \-\ TO",
"55833535", "São\ João\ do\ Rio\ do\ Peixe\ \-\ PB",
"55513952", "São\ Leopoldo\ \-\ RS",
"55323336", "Desterro\ do\ Melo\ \-\ MG",
"55533029", "Pelotas\ \-\ RS",
"55813821", "Recife\ \-\ PE",
"55313833", "São\ Gonçalo\ do\ Rio\ Abaixo\ \-\ MG",
"55483878", "Florianópolis\ \-\ SC",
"55673250", "Corguinho\ \-\ MS",
"55323335", "Piedade\ do\ Rio\ Grande\ \-\ MG",
"55833536", "Santa\ Cruz\ \-\ PB",
"55373222", "Divinópolis\ \-\ MG",
"55913751", "Abaetetuba\ \-\ PA",
"55883631", "Itapipoca\ \-\ CE",
"55153563", "Guapiara\ \-\ SP",
"55163835", "Miguelópolis\ \-\ SP",
"55333331", "Manhuaçu\ \-\ MG",
"55513480", "Guaíba\ \-\ RS",
"55733247", "Almadina\ \-\ BA",
"55413113", "Campo\ Largo\ \-\ PR",
"55434141", "Londrina\ \-\ PR",
"55823531", "Batalha\ \-\ AL",
"55453377", "Foz\ do\ Iguaçu\ \-\ PR",
"55513645", "São\ Pedro\ da\ Serra\ \-\ RS",
"55383623", "Januária\ \-\ MG",
"55543477", "Paraí\ \-\ RS",
"55133341", "Guarujá\ \-\ SP",
"55163273", "Itápolis\ \-\ SP",
"55313771", "Sete\ Lagoas\ \-\ MG",
"55673289", "Rochedo\ \-\ MS",
"55793343", "Pacatuba\ \-\ SE",
"55423909", "Palmeira\ \-\ PR",
"55152101", "Sorocaba\ \-\ SP",
"55423516", "Rio\ Claro\ do\ Sul\ \-\ PR",
"55312136", "Ipatinga\ \-\ MG",
"55133844", "Juquiá\ \-\ SP",
"55114651", "Arujá\ \-\ SP",
"55963322", "Pedra\ Branca\ do\ Amaparí\ \-\ AP",
"5511334", "São\ Paulo\ \-\ SP",
"55943311", "Parauapebas\ \-\ PA",
"55643613", "Rio\ Verde\ \-\ GO",
"55843260", "São\ Bento\ do\ Norte\ \-\ RN",
"55115855", "São\ Paulo\ \-\ SP",
"55624109", "Goiânia\ \-\ GO",
"55613629", "Valparaíso\ de\ Goiás\ \-\ GO",
"55343690", "Araguari\ \-\ MG",
"55373324", "Pimenta\ \-\ MG",
"55193899", "Monte\ Alegre\ do\ Sul\ \-\ SP",
"55553377", "Pejuçara\ \-\ RS",
"55534141", "Pelotas\ \-\ RS",
"55113178", "São\ Paulo\ \-\ SP",
"55733656", "Ilhéus\ \-\ BA",
"55163993", "Ribeirão\ Preto\ \-\ SP",
"55993547", "São\ Raimundo\ das\ Mangabeiras\ \-\ MA",
"55873833", "Venturosa\ \-\ PE",
"55443014", "Marialva\ \-\ PR",
"55313864", "Carmésia\ \-\ MG",
"55753283", "Paulo\ Afonso\ \-\ BA",
"55493252", "Timbó\ Grande\ \-\ SC",
"55753631", "Santo\ Antônio\ de\ Jesus\ \-\ BA",
"55353544", "Ibiraci\ \-\ MG",
"55623945", "Goiânia\ \-\ GO",
"55472111", "Blumenau\ \-\ SC",
"55123151", "Canas\ \-\ SP",
"55192513", "Campinas\ \-\ SP",
"55183654", "Penápolis\ \-\ SP",
"55624014", "Anápolis\ \-\ GO",
"55823280", "Pindoba\ \-\ AL",
"55153534", "Taquarivaí\ \-\ SP",
"55893429", "São\ João\ da\ Canabrava\ \-\ PI",
"55623946", "Goiânia\ \-\ GO",
"55613465", "Brasília\ \-\ DF",
"55673487", "Vila\ Marques\ \-\ MS",
"55213789", "Mangaratiba\ \-\ RJ",
"55493545", "Abdon\ Batista\ \-\ SC",
"55543279", "Linha\ Oitenta\ \-\ RS",
"55423422", "Irati\ \-\ PR",
"55343456", "União\ de\ Minas\ \-\ MG",
"5551351", "Rio\ Grande\ do\ Sul",
"55343455", "Carneirinho\ \-\ MG",
"55873771", "Bom\ Conselho\ \-\ PE",
"55493546", "Monte\ Carlo\ \-\ SC",
"55843337", "Caraúbas\ \-\ RN",
"55273288", "Marechal\ Floriano\ \-\ ES",
"55553621", "Santana\ do\ Livramento\ \-\ RS",
"55933544", "Oriximiná\ \-\ PA",
"55643517", "Itumbiara\ \-\ GO",
"55313832", "Santa\ Bárbara\ \-\ MG",
"55733299", "Lajedão\ \-\ BA",
"55493482", "Concórdia\ \-\ SC",
"55513487", "Glorinha\ \-\ RS",
"55753453", "Itanagra\ \-\ BA",
"55353829", "Lavras\ \-\ MG",
"55623589", "Goiânia\ \-\ GO",
"55993643", "Barra\ do\ Corda\ \-\ MA",
"55733240", "Gongogi\ \-\ BA",
"55693341", "Colorado\ do\ Oeste\ \-\ RO",
"55162132", "Ribeirão\ Preto\ \-\ SP",
"55323265", "Descoberto\ \-\ MG",
"55963083", "Macapá\ \-\ AP",
"55843417", "Caicó\ \-\ RN",
"55443242", "Floraí\ \-\ PR",
"55114668", "Itapecerica\ da\ Serra\ \-\ SP",
"55963323", "Macapá\ \-\ AP",
"55753676", "São\ Miguel\ das\ Matas\ \-\ BA",
"55333261", "Conselheiro\ Pena\ \-\ MG",
"55943431", "Santana\ do\ Araguaia\ \-\ PA",
"55753024", "Feira\ de\ Santana\ \-\ BA",
"55543344", "Tapejara\ \-\ RS",
"55773639", "Luis\ Eduardo\ Magalhães\ \-\ BA",
"55793342", "Muribeca\ \-\ SE",
"55313559", "Ouro\ Preto\ \-\ MG",
"55114312", "Mogi\ das\ Cruzes\ \-\ SP",
"55383622", "Pedras\ de\ Maria\ da\ Cruz\ \-\ MG",
"55183288", "Rosana\ \-\ SP",
"55833322", "Campina\ Grande\ \-\ PB",
"55443555", "Nice\ \-\ PR",
"55413112", "Curitiba\ \-\ PR",
"55114043", "Diadema\ \-\ SP",
"55463537", "Boa\ Esperança\ do\ Iguaçu\ \-\ PR",
"55623550", "Aragoiânia\ \-\ GO",
"55443556", "Rancho\ Alegre\ D\'Oeste\ \-\ PR",
"55153562", "Itaberá\ \-\ SP",
"55183211", "Birigui\ \-\ SP",
"55112612", "São\ Paulo\ \-\ SP",
"55843330", "Itajá\ \-\ RN",
"55333411", "Peçanha\ \-\ MG",
"55313231", "Minas\ Gerais",
"55493253", "São\ Cristovão\ do\ Sul\ \-\ SC",
"55633471", "Tocantinópolis\ \-\ TO",
"55753282", "Paulo\ Afonso\ \-\ BA",
"55853369", "Maranguape\ \-\ CE",
"55513289", "Rio\ Grande\ do\ Sul",
"55173254", "Mirassol\ \-\ SP",
"55153205", "Tatuí\ \-\ SP",
"55443344", "Maringá\ \-\ PR",
"5531341", "Belo\ Horizonte\ \-\ MG",
"55323371", "São\ João\ Del\ Rei\ \-\ MG",
"55913485", "Tracuateua\ \-\ PA",
"55673480", "Paranhos\ \-\ MS",
"55843605", "Natal\ \-\ RN",
"55823287", "Capela\ \-\ AL",
"55473629", "Bela\ Vista\ do\ Toldo\ \-\ SC",
"55843606", "Natal\ \-\ RN",
"55643612", "Rio\ Verde\ \-\ GO",
"55833302", "Camalaú\ \-\ PB",
"55313358", "Contagem\ \-\ MG",
"55163977", "Ribeirão\ Preto\ \-\ SP",
"55383527", "Turmalina\ \-\ MG",
"55423423", "Irati\ \-\ PR",
"55193847", "Jaguariúna\ \-\ SP",
"55883675", "Independência\ \-\ CE",
"55222655", "Saquarema\ \-\ RJ",
"55224141", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55473465", "Joinville\ \-\ SC",
"55313736", "Desterro\ de\ Entre\ Rios\ \-\ MG",
"55663601", "Nova\ Fronteira\ \-\ MT",
"55623476", "Colinas\ do\ Tocantins\ \-\ TO",
"55843267", "Ielmo\ Marinho\ \-\ RN",
"55313683", "Jaboticatubas\ \-\ MG",
"55313735", "Jeceaba\ \-\ MG",
"55173838", "Pedranópolis\ \-\ SP",
"55543242", "Nova\ Prata\ \-\ RS",
"55353841", "Bom\ Sucesso\ \-\ MG",
"55983464", "Miranda\ do\ Norte\ \-\ MA",
"55123957", "São\ Silvestre\ \-\ SP",
"55113427", "Mogi\ das\ Cruzes\ \-\ SP",
"55553286", "Santa\ Maria\ \-\ RS",
"55493345", "Santiago\ do\ Sul\ \-\ SC",
"55813095", "Caruaru\ \-\ PE",
"55373271", "Pitangui\ \-\ MG",
"55493346", "Quilombo\ \-\ SC",
"55484042", "Balneário\ Camboriú\ \-\ SC",
"55242228", "Secretário\ \-\ RJ",
"5597", "Amazonas",
"55353344", "Aiuruoca\ \-\ MG",
"55483208", "Florianópolis\ \-\ SC",
"55162105", "Sertãozinho\ \-\ SP",
"55483491", "Orleans\ \-\ SC",
"55533311", "Bagé\ \-\ RS",
"55713115", "Salvador\ \-\ BA",
"55162106", "São\ Carlos\ \-\ SP",
"55153334", "Sorocaba\ \-\ SP",
"55743552", "Campo\ Formoso\ \-\ BA",
"55663455", "Santa\ Elvira\ \-\ MT",
"55123354", "Jacareí\ \-\ SP",
"55283552", "Alegre\ \-\ ES",
"55193909", "Hortolândia\ \-\ SP",
"55243351", "Itatiaia\ \-\ RJ",
"55613608", "Novo\ Gama\ \-\ GO",
"55513654", "Triunfo\ \-\ RS",
"55483879", "Florianópolis\ \-\ SC",
"55312103", "Belo\ Horizonte\ \-\ MG",
"55313722", "Queluzito\ \-\ MG",
"55813101", "Caruaru\ \-\ PE",
"55863242", "Barras\ \-\ PI",
"55443278", "Ourizona\ \-\ PR",
"55533028", "Pelotas\ \-\ RS",
"55193516", "Campinas\ \-\ SP",
"55553781", "Santo\ Augusto\ \-\ RS",
"55313561", "Itabirito\ \-\ MG",
"55193402", "Piracicaba\ \-\ SP",
"55983312", "São\ Luís\ \-\ MA",
"55133855", "Tatuí\ \-\ SP",
"55133856", "Pariquera\-Açu\ \-\ SP",
"55353739", "Andradas\ \-\ MG",
"55373524", "Martinho\ Campos\ \-\ MG",
"55213629", "Niterói\ \-\ RJ",
"55513458", "Esteio\ \-\ RS",
"55313164", "Santa\ Luzia\ \-\ MG",
"55793543", "Indiaroba\ \-\ SE",
"55473641", "Mafra\ \-\ SC",
"55743657", "Lapão\ \-\ BA",
"55633423", "Darcinópolis\ \-\ TO",
"55353242", "Turvolândia\ \-\ MG",
"55543278", "Canela\ \-\ RS",
"55813271", "Recife\ \-\ PE",
"55313387", "Minas\ Gerais",
"55163135", "Rifaina\ \-\ SP",
"5511354", "São\ Paulo\ \-\ SP",
"55153363", "Boituva\ \-\ SP",
"55315", "Minas\ Gerais",
"55323323", "São\ João\ Del\ Rei\ \-\ MG",
"55333531", "Caraí\ \-\ MG",
"55433475", "Jardim\ Alegre\ \-\ PR",
"55473052", "Indaial\ \-\ SC",
"55893428", "Santa\ Rosa\ do\ Piauí\ \-\ PI",
"55613053", "Brasília\ \-\ DF",
"55663593", "Apiacás\ \-\ MT",
"55923369", "Careiro\ da\ Várzea\ \-\ AM",
"55433476", "Cândido\ de\ Abreu\ \-\ PR",
"55242491", "Vassouras\ \-\ RJ",
"55313826", "Minas\ Gerais",
"55773462", "Caetanos\ \-\ BA",
"55853351", "Trairi\ \-\ CE",
"55114513", "Mauá\ \-\ SP",
"55183646", "Brejo\ Alegre\ \-\ SP",
"55983214", "São\ Luís\ \-\ MA",
"55323536", "Senador\ Firmino\ \-\ MG",
"55453286", "Capitão\ Leônidas\ Marques\ \-\ PR",
"55383635", "Arinos\ \-\ MG",
"55673461", "Naviraí\ \-\ MS",
"55353556", "Arceburgo\ \-\ MG",
"5585348", "Fortaleza\ \-\ CE",
"55923317", "Autazes\ \-\ AM",
"55353555", "Guaranésia\ \-\ MG",
"55623954", "Goiânia\ \-\ GO",
"55273250", "Coqueiral\ \-\ ES",
"55453285", "Subsede\ São\ Francisco\ \-\ PR",
"55183645", "Coroados\ \-\ SP",
"55323535", "Divinésia\ \-\ MG",
"55323083", "Juiz\ de\ Fora\ \-\ MG",
"55193898", "Lindóia\ \-\ SP",
"55173553", "São\ João\ de\ Itaguaçu\ \-\ SP",
"55653337", "Diamantino\ \-\ MT",
"55613628", "Novo\ Gama\ \-\ GO",
"55193929", "Valinhos\ \-\ SP",
"55813524", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55623357", "Uruaçu\ \-\ GO",
"55493554", "Herval\ D\'Oeste\ \-\ SC",
"55433311", "Rolândia\ \-\ PR",
"55823258", "Passo\ de\ Camaragibe\ \-\ AL",
"55653626", "Cuiabá\ \-\ MT",
"55163171", "Pedregulho\ \-\ SP",
"55143888", "Pereiras\ \-\ SP",
"55743553", "Campo\ Formoso\ \-\ BA",
"55843664", "Natal\ \-\ RN",
"55624141", "Goiânia\ \-\ GO",
"55163726", "Orlândia\ \-\ SP",
"55183289", "Tarabai\ \-\ SP",
"55813236", "Recife\ \-\ PE",
"55163725", "Franca\ \-\ SP",
"55633402", "Araguaína\ \-\ TO",
"55773434", "Planalto\ \-\ BA",
"55653625", "Cuiabá\ \-\ MT",
"55143811", "Botucatu\ \-\ SP",
"55813873", "Araripina\ \-\ PE",
"55313558", "Mariana\ \-\ MG",
"55714117", "Simões\ Filho\ \-\ BA",
"55493015", "Lages\ \-\ SC",
"55333724", "Divisópolis\ \-\ MG",
"55323224", "Juiz\ de\ Fora\ \-\ MG",
"55833627", "Pilõezinhos\ \-\ PB",
"55513461", "Esteio\ \-\ RS",
"55153264", "Águia\ da\ Castelo\ \-\ SP",
"55164003", "Ribeirão\ Preto\ \-\ SP",
"55423435", "Pinho\ de\ Baixo\ \-\ PR",
"55323571", "Rio\ Pomba\ \-\ MG",
"55543355", "Ibiraiaras\ \-\ RS",
"55473404", "Itajaí\ \-\ SC",
"55883584", "Orós\ \-\ CE",
"55623511", "Inhumas\ \-\ GO",
"55114669", "Itapecerica\ da\ Serra\ \-\ SP",
"5571340", "Salvador\ \-\ BA",
"55223311", "Macaé\ \-\ RJ",
"55983313", "São\ Luís\ \-\ MA",
"55383671", "Paracatu\ \-\ MG",
"55433557", "Arapoti\ \-\ PR",
"55683611", "Manoel\ Urbano\ \-\ AC",
"55833371", "Picuí\ \-\ PB",
"55643430", "Itumbiara\ \-\ GO",
"55623588", "Aparecida\ de\ Goiânia\ \-\ GO",
"55423436", "Imbituva\ \-\ PR",
"55543356", "Barracão\ \-\ RS",
"55863243", "Porto\ \-\ PI",
"55733298", "Prado\ \-\ BA",
"55313723", "Casa\ Grande\ \-\ MG",
"55312102", "Belo\ Horizonte\ \-\ MG",
"55163221", "Matão\ \-\ SP",
"55444009", "Maringá\ \-\ PR",
"55983651", "Araguanã\ \-\ MA",
"55993017", "Imperatriz\ \-\ MA",
"55813731", "Santa\ Cruz\ do\ Capibaribe\ \-\ PE",
"55283553", "Guaçuí\ \-\ ES",
"55443544", "Tupãssi\ \-\ PR",
"55123117", "São\ José\ do\ Barreiro\ \-\ SP",
"55513715", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55773463", "Licínio\ de\ Almeida\ \-\ BA",
"55173245", "José\ Bonifácio\ \-\ SP",
"55443355", "Maringá\ \-\ PR",
"55833522", "Sousa\ \-\ PB",
"55173839", "Parisi\ \-\ SP",
"55663592", "Brasnorte\ \-\ MT",
"55143212", "Bauru\ \-\ SP",
"55323322", "Nazareno\ \-\ MG",
"55373235", "Pará\ de\ Minas\ \-\ MG",
"55513716", "Arroio\ do\ Meio\ \-\ RS",
"55163706", "Franca\ \-\ SP",
"55323691", "Juiz\ de\ Fora\ \-\ MG",
"55114405", "Piracaia\ \-\ SP",
"55273257", "Ibiraçu\ \-\ ES",
"55973481", "Eirunepé\ \-\ AM",
"55543544", "Entre\ Rios\ do\ Sul\ \-\ RS",
"55633422", "Bernardo\ Sayão\ \-\ TO",
"55544009", "Caxias\ do\ Sul\ \-\ RS",
"55793542", "Cristinápolis\ \-\ SE",
"55823261", "Rio\ Largo\ \-\ AL",
"55312122", "Belo\ Horizonte\ \-\ MG",
"55733421", "Porto\ Seguro\ \-\ BA",
"55663577", "Canabrava\ do\ Norte\ \-\ MT",
"55623389", "Goianésia\ \-\ GO",
"55833265", "Duas\ Estradas\ \-\ PB",
"55713642", "Pólo\ Petroquímico\ Camaçari\ \-\ BA",
"55693541", "Guajará\-Mirim\ \-\ RO",
"55112317", "São\ Paulo\ \-\ SP",
"55553649", "Sanchuri\ \-\ RS",
"55833266", "Mogeiro\ \-\ PB",
"55753181", "Alagoinhas\ \-\ BA",
"55173552", "Urupês\ \-\ SP",
"55483241", "São\ José\ \-\ SC",
"55913494", "Muaná\ \-\ PA",
"55313132", "Esmeraldas\ \-\ MG",
"55843281", "Nova\ Cruz\ \-\ RN",
"55313380", "Minas\ Gerais",
"55793255", "Aracaju\ \-\ SE",
"55713051", "Lauro\ de\ Freitas\ \-\ BA",
"55513288", "Rio\ Grande\ do\ Sul",
"55473424", "Pirabeiraba\ \-\ SC",
"55222644", "Cabo\ Frio\ \-\ RJ",
"55793256", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55863477", "Inhuma\ \-\ PI",
"55113754", "Arujá\ \-\ SP",
"55353731", "Andradas\ \-\ MG",
"55793322", "Propriá\ \-\ SE",
"55333251", "Santana\ do\ Paraíso\ \-\ MG",
"55543324", "Ibirubá\ \-\ RS",
"55323751", "Tombos\ \-\ MG",
"55213621", "Rio\ de\ Janeiro\ \-\ RJ",
"55813492", "Olinda\ \-\ PE",
"55212631", "Magé\ \-\ RJ",
"55634007", "Palmas\ \-\ TO",
"55423277", "Ortigueira\ \-\ PR",
"55113705", "Santo\ André\ \-\ SP",
"55193594", "Descalvado\ \-\ SP",
"5531325", "Minas\ Gerais",
"55193807", "Amparo\ \-\ SP",
"55443565", "Tuneiras\ do\ Oeste\ \-\ PR",
"5533", "Minas\ Gerais",
"55114023", "Itu\ \-\ SP",
"55643559", "Itumbiara\ \-\ GO",
"55153552", "Apiaí\ \-\ SP",
"55833342", "Campina\ Grande\ \-\ PB",
"55443566", "Juranda\ \-\ PR",
"55173681", "Nova\ Canaã\ Paulista\ \-\ SP",
"55114137", "Taboão\ da\ Serra\ \-\ SP",
"55843646", "Natal\ \-\ RN",
"55883638", "Hidrolândia\ \-\ CE",
"55913758", "Cachoeira\ do\ Arari\ \-\ PA",
"55114454", "Santo\ André\ \-\ SP",
"55213974", "Rio\ de\ Janeiro\ \-\ RJ",
"55933524", "Santarém\ \-\ PA",
"55813477", "Recife\ \-\ PE",
"55133348", "Guarujá\ \-\ SP",
"55373243", "Itaúna\ \-\ MG",
"55613718", "Formosa\ \-\ GO",
"55613577", "Brasília\ \-\ DF",
"55353236", "São\ Bento\ Abade\ \-\ MG",
"55173875", "São\ João\ de\ Iracema\ \-\ SP",
"55144104", "Garça\ \-\ SP",
"55153245", "Votorantim\ \-\ SP",
"55623438", "São\ João\ D\'Aliança\ \-\ GO",
"55443304", "Maringá\ \-\ PR",
"55163142", "São\ José\ da\ Bela\ Vista\ \-\ SP",
"55323256", "Aracitaba\ \-\ MG",
"55883434", "Ererê\ \-\ CE",
"55323255", "Ewbank\ da\ Câmara\ \-\ MG",
"55152108", "Tietê\ \-\ SP",
"55693321", "Vilhena\ \-\ RO",
"55993623", "Bom\ Lugar\ \-\ MA",
"55153246", "Cesário\ Lange\ \-\ SP",
"55114658", "Igaratá\ \-\ SP",
"55173362", "Marcondésia\ \-\ SP",
"55333755", "Águas\ Vermelhas\ \-\ MG",
"55613697", "Taboquinha\ \-\ GO",
"55923682", "Manaus\ \-\ AM",
"55193827", "Artur\ Nogueira\ \-\ SP",
"55383547", "Serra\ Azul\ de\ Minas\ \-\ MG",
"55513260", "Rio\ Grande\ do\ Sul",
"55123637", "Moreira\ César\ \-\ SP",
"55483030", "Florianópolis\ \-\ SC",
"55463211", "Francisco\ Beltrão\ \-\ PR",
"55893472", "Francinópolis\ \-\ PI",
"55222665", "Araruama\ \-\ RJ",
"55113171", "São\ Paulo\ \-\ SP",
"55713671", "Camaçari\ \-\ BA",
"55213601", "Niterói\ \-\ RJ",
"55112683", "São\ Paulo\ \-\ SP",
"55193386", "Campinas\ \-\ SP",
"55473455", "Joinville\ \-\ SC",
"55793302", "Aracaju\ \-\ SE",
"55753213", "Banzaê\ \-\ BA",
"55793224", "Aracaju\ \-\ SE",
"55843257", "Lagoa\ Salgada\ \-\ RN",
"55483272", "Antônio\ Carlos\ \-\ SC",
"5511587", "São\ Paulo\ \-\ SP",
"55673469", "Culturama\ \-\ MS",
"55193385", "Campinas\ \-\ SP",
"55473456", "Barra\ Velha\ \-\ SC",
"55222666", "São\ Vicente\ de\ Paula\ \-\ RJ",
"55193674", "Casa\ Branca\ \-\ SP",
"55753638", "Governador\ Mangabeira\ \-\ BA",
"55134004", "Santos\ \-\ SP",
"55923361", "Manacapuru\ \-\ AM",
"55893497", "Betânia\ do\ Piauí\ \-\ PI",
"55173264", "Bálsamo\ \-\ SP",
"55193026", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55682101", "Rio\ Branco\ \-\ AC",
"55242102", "Volta\ Redonda\ \-\ RJ",
"55433367", "Londrina\ \-\ PR",
"55493332", "Águas\ Frias\ \-\ SC",
"55193478", "Americana\ \-\ SP",
"55753434", "Acajutiba\ \-\ BA",
"55513337", "Rio\ Grande\ do\ Sul",
"55133321", "Santos\ \-\ SP",
"55183786", "Sud\ Mennucci\ \-\ SP",
"55813739", "Altinho\ \-\ PE",
"55444001", "Maringá\ \-\ PR",
"55513625", "Capão\ da\ Canoa\ \-\ RS",
"55833343", "Campina\ Grande\ \-\ PB",
"55153553", "Ribeirão\ Branco\ \-\ SP",
"55114022", "Itu\ \-\ SP",
"55483447", "Cocal\ do\ Sul\ \-\ SC",
"55243387", "Visconde\ de\ Mauá\ \-\ RJ",
"55953539", "Nova\ Colina\ \-\ RR",
"55513626", "Torres\ \-\ RS",
"55114707", "Jandira\ \-\ SP",
"5511332", "São\ Paulo\ \-\ SP",
"55713636", "Vera\ Cruz\ \-\ BA",
"55383679", "Paracatu\ \-\ MG",
"55833379", "Cacimba\ de\ Dentro\ \-\ PB",
"5519378", "Campinas\ \-\ SP",
"55533237", "Povo\ Novo\ \-\ RS",
"55112771", "São\ Paulo\ \-\ SP",
"55623519", "Goiânia\ \-\ GO",
"55553757", "Novo\ Barreiro\ \-\ RS",
"55863271", "Pedro\ II\ \-\ PI",
"55114661", "Embu\-Guaçu\ \-\ SP",
"55713635", "Mata\ de\ São\ João\ \-\ BA",
"55113135", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55333268", "Aimorés\ \-\ MG",
"55114130", "São\ Roque\ \-\ SP",
"55993622", "Bacabal\ \-\ MA",
"55513469", "Cachoeirinha\ \-\ RS",
"55623567", "Goiânia\ \-\ GO",
"55123981", "Cedro\ \-\ SP",
"55163143", "Restinga\ \-\ SP",
"55813344", "Recife\ \-\ PE",
"55493364", "Serra\ Alta\ \-\ SC",
"55753462", "Itapicuru\ \-\ BA",
"55413605", "Colombo\ \-\ PR",
"55373242", "Itaúna\ \-\ MG",
"55183281", "Presidente\ Epitácio\ \-\ SP",
"55194007", "Campinas\ \-\ SP",
"55833494", "Diamante\ \-\ PB",
"55423270", "Guaragi\ \-\ PR",
"55353366", "Alagoa\ \-\ MG",
"55353365", "São\ Sebastião\ do\ Rio\ Verde\ \-\ MG",
"55663424", "Rondonópolis\ \-\ MT",
"55343215", "Uberlândia\ \-\ MG",
"55873854", "Carnaíba\ \-\ PE",
"55673260", "Alcinópolis\ \-\ MS",
"55413606", "Colombo\ \-\ PR",
"55913265", "Ananindeua\ \-\ PA",
"55313238", "Belo\ Horizonte\ \-\ MG",
"55613456", "Taguatinga\ \-\ DF",
"55633478", "Filadélfia\ \-\ TO",
"55893449", "Santo\ Antônio\ de\ Lisboa\ \-\ PI",
"55963244", "Macapá\ \-\ AP",
"55212675", "Duque\ de\ Caxias\ \-\ RJ",
"55483273", "Major\ Gercino\ \-\ SC",
"55242447", "Barra\ do\ Piraí\ \-\ RJ",
"55843289", "Serra\ de\ São\ Bento\ \-\ RN",
"55853133", "Fortaleza\ \-\ CE",
"5542362", "Guarapuava\ \-\ PR",
"55112682", "São\ Paulo\ \-\ SP",
"55353524", "São\ João\ Batista\ do\ Glória\ \-\ MG",
"55893473", "Massapê\ do\ Piauí\ \-\ PI",
"55633026", "Palmas\ \-\ TO",
"55643682", "Turvânia\ \-\ GO",
"55733207", "Nova\ Canaã\ \-\ BA",
"55434101", "Apucarana\ \-\ PR",
"55493526", "Jaborá\ \-\ SC",
"55513605", "Torres\ \-\ RS",
"55643996", "Itumbiara\ \-\ GO",
"55163209", "Jaboticabal\ \-\ SP",
"55513606", "Rondinha\ Velha\ \-\ RS",
"55863366", "Luís\ Correia\ \-\ PI",
"5531348", "Belo\ Horizonte\ \-\ MG",
"55493525", "Catanduvas\ \-\ SC",
"55673410", "Dourados\ \-\ MS",
"55633025", "Palmas\ \-\ TO",
"55623381", "Estrela\ do\ Norte\ \-\ GO",
"55193948", "Louveira\ \-\ SP",
"55143584", "Pirajuí\ \-\ SP",
"55373344", "Pedra\ do\ Indaiá\ \-\ MG",
"55823269", "Pólo\ Cloroquímico\ de\ Alagoas\ \-\ AL",
"55633385", "Talismã\ \-\ TO",
"55313351", "Contagem\ \-\ MG",
"55413625", "Contenda\ \-\ PR",
"55493333", "Nova\ Erechim\ \-\ SC",
"55544001", "Caxias\ do\ Sul\ \-\ RS",
"55413626", "Mandirituba\ \-\ PR",
"55242103", "Petrópolis\ \-\ RJ",
"55114284", "Mogi\ das\ Cruzes\ \-\ SP",
"55163878", "Ribeirão\ Preto\ \-\ SP",
"55743681", "Ourolândia\ \-\ BA",
"55633386", "Palmeirópolis\ \-\ TO",
"55173334", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55353271", "Lambari\ \-\ MG",
"55993602", "Nova\ Colinas\ \-\ MA",
"55653211", "Cáceres\ \-\ MT",
"55483037", "Florianópolis\ \-\ SC",
"55853387", "Caucaia\ \-\ CE",
"55313854", "Rio\ Piracicaba\ \-\ MG",
"5595", "Roraima",
"55513267", "Rio\ Grande\ do\ Sul",
"55733665", "Teixeira\ de\ Freitas\ \-\ BA",
"55173831", "Nova\ Castilho\ \-\ SP",
"55112864", "São\ Paulo\ \-\ SP",
"55213760", "Nilópolis\ \-\ RJ",
"55282101", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55543365", "Rondinha\ \-\ RS",
"55642102", "Jataí\ \-\ GO",
"55683232", "Senador\ Guiomard\ \-\ AC",
"55373278", "Pequi\ \-\ MG",
"55433567", "Sengés\ \-\ PR",
"55493532", "Tangará\ \-\ SC",
"55933222", "Santarém\ \-\ PA",
"5584331", "Mossoró\ \-\ RN",
"55143452", "Pompéia\ \-\ SP",
"55313779", "Sete\ Lagoas\ \-\ MG",
"55543366", "Campinas\ do\ Sul\ \-\ RS",
"55423901", "Ponta\ Grossa\ \-\ PR",
"55513537", "Porto\ Alegre\ \-\ RS",
"55242221", "Petrópolis\ \-\ RJ",
"55823539", "Arapiraca\ \-\ AL",
"55443524", "Campo\ Mourão\ \-\ PR",
"55173667", "Turmalina\ \-\ SP",
"55123413", "Taubaté\ \-\ SP",
"55623932", "Goiânia\ \-\ GO",
"55163241", "Monte\ Alto\ \-\ SP",
"55713186", "Salvador\ \-\ BA",
"55883639", "Varjota\ \-\ CE",
"55983661", "Codó\ \-\ MA",
"55313430", "Minas\ Gerais",
"55333339", "Manhuaçu\ \-\ MG",
"55713602", "Candeias\ \-\ BA",
"55643558", "Itumbiara\ \-\ GO",
"55114446", "Cajamar\ \-\ SP",
"55193586", "Itirapina\ \-\ SP",
"55843654", "Natal\ \-\ RN",
"55613601", "Luziânia\ \-\ GO",
"55243358", "Resende\ \-\ RJ",
"55192137", "Campinas\ \-\ SP",
"55114680", "Santa\ Isabel\ \-\ SP",
"55222796", "Macaé\ \-\ RJ",
"55513883", "Montenegro\ \-\ RS",
"55113374", "Mogi\ das\ Cruzes\ \-\ SP",
"55114445", "Caieiras\ \-\ SP",
"55193585", "Porto\ Ferreira\ \-\ SP",
"55733031", "Itamaraju\ \-\ BA",
"55973331", "Lábrea\ \-\ AM",
"55413632", "Piên\ \-\ PR",
"55333744", "Rio\ do\ Prado\ \-\ MG",
"55433906", "Rolândia\ \-\ PR",
"55983382", "Santa\ Helena\ \-\ MA",
"55513451", "Rio\ Grande\ do\ Sul",
"55553629", "Jacuizinho\ \-\ RS",
"55833255", "João\ Pessoa\ \-\ PB",
"55873779", "Jupi\ \-\ PE",
"55112703", "São\ Paulo\ \-\ SP",
"55713622", "Camaçari\ \-\ BA",
"55693521", "Jaru\ \-\ RO",
"55113122", "São\ Paulo\ \-\ SP",
"55543271", "São\ Jorge\ \-\ RS",
"55833256", "Alhandra\ \-\ PB",
"55213781", "Itaguaí\ \-\ RJ",
"55173562", "Tabapuã\ \-\ SP",
"55413883", "Curitiba\ \-\ PR",
"55433662", "Florestópolis\ \-\ PR",
"55493637", "Cristo\ Rei\ \-\ SC",
"55273182", "Vitória\ \-\ ES",
"55114035", "Bragança\ Paulista\ \-\ SP",
"55793265", "Nossa\ Senhora\ das\ Dores\ \-\ SE",
"55283534", "Anchieta\ \-\ ES",
"55222624", "Iguaba\ Grande\ \-\ RJ",
"55893421", "Picos\ \-\ PI",
"55923133", "Manaus\ \-\ AM",
"55513632", "Montenegro\ \-\ RS",
"55653257", "Rio\ Branco\ \-\ MT",
"55922123", "Manaus\ \-\ AM",
"55473444", "São\ Francisco\ do\ Sul\ \-\ SC",
"55823338", "Maceió\ \-\ AL",
"55753639", "Santa\ Teresinha\ \-\ BA",
"55143283", "Pederneiras\ \-\ SP",
"55114036", "Piracaia\ \-\ SP",
"55793266", "Santo\ Amaro\ das\ Brotas\ \-\ SE",
"55123159", "Lorena\ \-\ SP",
"55853358", "Tururu\ \-\ CE",
"55193394", "Indaiatuba\ \-\ SP",
"55773453", "Brumado\ \-\ BA",
"5511418", "Carapicuíba\ \-\ SP",
"5582", "Alagoas",
"55323342", "Santa\ Rita\ de\ Ibitipoca\ \-\ MG",
"55673468", "Vicentina\ \-\ MS",
"55473393", "Bombinhas\ \-\ SC",
"55613392", "Santa\ Maria\ \-\ DF",
"55484003", "Florianópolis\ \-\ SC",
"55743534", "Pilão\ Arcado\ \-\ BA",
"55833542", "Santa\ Helena\ \-\ PB",
"55443366", "Maringá\ \-\ PR",
"55423025", "Ponta\ Grossa\ \-\ PR",
"55993635", "Lago\ Verde\ \-\ MA",
"55193891", "Mogi\-Guaçu\ \-\ SP",
"55913323", "Belém\ \-\ PA",
"55613621", "Luziânia\ \-\ GO",
"55793522", "Estância\ \-\ SE",
"55812138", "Recife\ \-\ PE",
"55633442", "Ananás\ \-\ TO",
"55543524", "Mariano\ Moro\ \-\ RS",
"55273267", "Fundão\ \-\ ES",
"55114837", "São\ Paulo\ \-\ SP",
"55115693", "São\ Paulo\ \-\ SP",
"55353223", "Varginha\ \-\ MG",
"55943319", "Santa\ Maria\ das\ Barreiras\ \-\ PA",
"55624101", "Goiânia\ \-\ GO",
"55423026", "Ponta\ Grossa\ \-\ PR",
"55823251", "Matriz\ de\ Camaragibe\ \-\ AL",
"55993636", "Poção\ de\ Pedras\ \-\ MA",
"55863304", "Teresina\ \-\ PI",
"55143881", "Botucatu\ \-\ SP",
"55283562", "Bom\ Jesus\ do\ Norte\ \-\ ES",
"55543235", "Campestre\ da\ Serra\ \-\ RS",
"55313742", "Ouro\ Branco\ \-\ MG",
"55623933", "Goiânia\ \-\ GO",
"55513664", "Torres\ \-\ RS",
"5582335", "Maceió\ \-\ AL",
"55833485", "Santana\ dos\ Garrotes\ \-\ PB",
"55223021", "Araruama\ \-\ RJ",
"55183605", "Santópolis\ do\ Aguapeí\ \-\ SP",
"55143453", "Marília\ \-\ SP",
"55373544", "Cedro\ do\ Abaeté\ \-\ MG",
"55114687", "São\ Lourenço\ da\ Serra\ \-\ SP",
"55313551", "Ouro\ Preto\ \-\ MG",
"55493533", "Videira\ \-\ SC",
"55133372", "Cubatão\ \-\ SP",
"55183606", "Guararapes\ \-\ SP",
"55683233", "Porto\ Acre\ \-\ AC",
"55642103", "Itumbiara\ \-\ GO",
"55513468", "Rio\ Grande\ do\ Sul",
"55222031", "Saquarema\ \-\ RJ",
"55323578", "Guidoval\ \-\ MG",
"55983454", "Anajatuba\ \-\ MA",
"55623518", "Aparecida\ de\ Goiânia\ \-\ GO",
"55112806", "Diadema\ \-\ SP",
"55493326", "Caxambu\ do\ Sul\ \-\ SC",
"55883111", "Sobral\ \-\ CE",
"55983383", "São\ Bento\ \-\ MA",
"55424007", "Ponta\ Grossa\ \-\ PR",
"55194126", "Itapira\ \-\ SP",
"55313437", "Minas\ Gerais",
"55383678", "Riachinho\ \-\ MG",
"55733604", "Batinga\ \-\ BA",
"55112805", "Diadema\ \-\ SP",
"55123861", "São\ Sebastião\ \-\ SP",
"55833378", "Campo\ de\ Santana\ \-\ PB",
"55493325", "São\ Carlos\ \-\ SC",
"55113447", "Osasco\ \-\ SP",
"55883514", "Cariús\ \-\ CE",
"55353821", "Lavras\ \-\ MG",
"55623581", "Goiânia\ \-\ GO",
"55873845", "Calumbi\ \-\ PE",
"55823481", "Arapiraca\ \-\ AL",
"55193032", "Campinas\ \-\ SP",
"55663466", "Ponte\ Branca\ \-\ MT",
"55433560", "Cornélio\ Procópio\ \-\ PR",
"55733291", "Teixeira\ de\ Freitas\ \-\ BA",
"55114976", "Santo\ André\ \-\ SP",
"55813738", "Cupira\ \-\ PE",
"55183267", "Santo\ Expedito\ \-\ SP",
"55983658", "Alto\ Alegre\ do\ Pindaré\ \-\ MA",
"55873846", "Triunfo\ \-\ PE",
"55513786", "Rio\ Grande\ do\ Sul",
"55183625", "Araçatuba\ \-\ SP",
"55143282", "Duartina\ \-\ SP",
"55673451", "Itaporã\ \-\ MS",
"55513633", "Pareci\ Novo\ \-\ RS",
"55273260", "Vila\ Velha\ \-\ ES",
"55513785", "Rio\ Grande\ do\ Sul",
"55173563", "Cajobi\ \-\ SP",
"55913082", "Belém\ \-\ PA",
"55623097", "Aparecida\ de\ Goiânia\ \-\ GO",
"55114295", "Suzano\ \-\ SP",
"55623367", "Porangatu\ \-\ GO",
"55493564", "Rio\ das\ Antas\ \-\ SC",
"55813544", "Ilha\ de\ Itamaracá\ \-\ PE",
"55633394", "Sandolândia\ \-\ TO",
"55343424", "Itapagipe\ \-\ MG",
"55743619", "Jaguarari\ \-\ BA",
"55473377", "Luiz\ Alves\ \-\ SC",
"55814009", "Recife\ \-\ PE",
"55823268", "Santa\ Luzia\ do\ Norte\ \-\ AL",
"5511352", "São\ Paulo\ \-\ SP",
"55743667", "Piritiba\ \-\ BA",
"55413664", "Doutor\ Ulysses\ \-\ PR",
"55163491", "Sertãozinho\ \-\ SP",
"55353222", "Varginha\ \-\ MG",
"55323379", "São\ João\ Del\ Rei\ \-\ MG",
"55923020", "Manaus\ \-\ AM",
"55483248", "Florianópolis\ \-\ SC",
"55473621", "Canoinhas\ \-\ SC",
"55373355", "Doresópolis\ \-\ MG",
"55913322", "Barcarena\ \-\ PA",
"55482106", "Florianópolis\ \-\ SC",
"55443236", "Floresta\ \-\ PR",
"55843288", "Passa\ e\ Fica\ \-\ RN",
"55273337", "Vitória\ \-\ ES",
"55313846", "Coronel\ Fabriciano\ \-\ MG",
"55833543", "Aparecida\ \-\ PB",
"55153353", "Votorantim\ \-\ SP",
"55473062", "Balneário\ Camboriú\ \-\ SC",
"55613393", "Santa\ Maria\ \-\ DF",
"55413468", "Alexandra\ \-\ PR",
"55893448", "Bocaina\ \-\ PI",
"55633479", "Piraquê\ \-\ TO",
"55323343", "Senhora\ dos\ Remédios\ \-\ MG",
"55713500", "Salvador\ \-\ BA",
"55733624", "Jussari\ \-\ BA",
"55313239", "Belo\ Horizonte\ \-\ MG",
"55773452", "Guanambi\ \-\ BA",
"55143004", "Bauru\ \-\ SP",
"55313845", "Jaguaraçu\ \-\ MG",
"55853361", "Aquiraz\ \-\ CE",
"55513218", "Rio\ Grande\ do\ Sul",
"55933533", "Monte\ Alegre\ \-\ PA",
"55743536", "Casa\ Nova\ \-\ BA",
"55173302", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55193396", "Sumaré\ \-\ SP",
"55663432", "Poxoréo\ \-\ MT",
"55743535", "Remanso\ \-\ BA",
"55614103", "Brasília\ \-\ DF",
"55813253", "Recife\ \-\ PE",
"55423675", "Copel\ \-\ PR",
"55183441", "Araçatuba\ \-\ SP",
"55543525", "Severiano\ de\ Almeida\ \-\ RS",
"55513170", "Estância\ Velha\ \-\ RS",
"55883423", "Limoeiro\ do\ Norte\ \-\ CE",
"55673666", "Chapadão\ do\ Sul\ \-\ MS",
"55993634", "Lago\ do\ Junco\ \-\ MA",
"5521262", "Niterói\ \-\ RJ",
"55853373", "Acarape\ \-\ CE",
"55673665", "Água\ Clara\ \-\ MS",
"55543526", "Três\ Arroios\ \-\ RS",
"55423676", "Faxinal\ da\ Boa\ Vista\ \-\ PR",
"55193819", "Hortolândia\ \-\ SP",
"55193867", "Jaguariúna\ \-\ SP",
"55833254", "Cruz\ do\ Espírito\ Santo\ \-\ PB",
"55773478", "Ribeirão\ do\ Largo\ \-\ BA",
"55913131", "Belém\ \-\ PA",
"55313328", "Minas\ Gerais",
"55483287", "Florianópolis\ \-\ SC",
"55213002", "Rio\ de\ Janeiro\ \-\ RJ",
"55543333", "Chapada\ \-\ RS",
"55553312", "Santo\ Ângelo\ \-\ RS",
"55473446", "Barra\ Velha\ \-\ SC",
"55843247", "Pedro\ Velho\ \-\ RN",
"55793264", "Itaporanga\ d\'Ajuda\ \-\ SE",
"55114034", "Bragança\ Paulista\ \-\ SP",
"55283535", "Presidente\ Kennedy\ \-\ ES",
"55173571", "Santa\ Adélia\ \-\ SP",
"55923018", "Manaus\ \-\ AM",
"55313916", "Belo\ Horizonte\ \-\ MG",
"55313915", "Belo\ Horizonte\ \-\ MG",
"55283536", "Anchieta\ \-\ ES",
"55893487", "Paulistana\ \-\ PI",
"55773674", "Ibipitanga\ \-\ BA",
"55673429", "Vila\ Macaúba\ \-\ MS",
"55473445", "Garuva\ \-\ SC",
"55473035", "Blumenau\ \-\ SC",
"55193181", "Floresta\ Escura\ \-\ SP",
"55113376", "São\ Paulo\ \-\ SP",
"55173691", "Três\ Fronteiras\ \-\ SP",
"55553433", "Itaqui\ \-\ RS",
"55114444", "Franco\ da\ Rocha\ \-\ SP",
"55193584", "Santa\ Rita\ do\ Passa\ Quatro\ \-\ SP",
"55113375", "São\ Paulo\ \-\ SP",
"5521260", "São\ Gonçalo\ \-\ RJ",
"55543412", "Farroupilha\ \-\ RS",
"55333745", "Joaíma\ \-\ MG",
"55433904", "Cornélio\ Procópio\ \-\ PR",
"55753423", "Alagoinhas\ \-\ BA",
"55923301", "Manaus\ \-\ AM",
"55153256", "Campina\ do\ Monte\ Alegre\ \-\ SP",
"55993663", "Presidente\ Dutra\ \-\ MA",
"55153255", "Angatuba\ \-\ SP",
"55123849", "Ubatuba\ \-\ SP",
"55333746", "Rubim\ \-\ MG",
"55813482", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55793362", "Cumbe\ \-\ SE",
"55243373", "Paraty\ \-\ RJ",
"55983672", "Bom\ Jardim\ \-\ MA",
"55273076", "Cariacica\ \-\ ES",
"55673227", "Anhanduí\ \-\ MS",
"55643573", "Itumbiara\ \-\ GO",
"55343513", "Araguari\ \-\ MG",
"55543364", "Ronda\ Alta\ \-\ RS",
"55823420", "Palmeira\ dos\ Índios\ \-\ AL",
"55113411", "São\ Paulo\ \-\ SP",
"55673409", "Naviraí\ \-\ MS",
"55923572", "São\ Sebastião\ do\ Uatumã\ \-\ AM",
"55323741", "Carangola\ \-\ MG",
"55112549", "São\ Paulo\ \-\ SP",
"55313529", "Betim\ \-\ MG",
"55333241", "Mantena\ \-\ MG",
"55153542", "Capão\ Bonito\ \-\ SP",
"55833352", "São\ João\ do\ Tigre\ \-\ PB",
"55443525", "Campo\ Mourão\ \-\ PR",
"55623520", "Goiânia\ \-\ GO",
"55443526", "Formosa\ do\ Oeste\ \-\ PR",
"55843473", "Cruzeta\ \-\ RN",
"55673902", "Dourados\ \-\ MS",
"55353532", "São\ Sebastião\ do\ Paraíso\ \-\ MG",
"55893480", "Socorro\ do\ Piauí\ \-\ PI",
"55212479", "São\ Gonçalo\ \-\ RJ",
"55493907", "Lages\ \-\ SC",
"55413665", "Pinhais\ \-\ PR",
"55513192", "Novo\ Hamburgo\ \-\ RS",
"5531349", "Belo\ Horizonte\ \-\ MG",
"55513902", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55863086", "Teresina\ \-\ PI",
"55853372", "São\ Gonçalo\ do\ Amarante\ \-\ CE",
"55443234", "Astorga\ \-\ PR",
"55623391", "Mundo\ Novo\ \-\ GO",
"55373354", "Japaraíba\ \-\ MG",
"55843240", "Montanhas\ \-\ RN",
"55413666", "Colombo\ \-\ PR",
"55883422", "Morada\ Nova\ \-\ CE",
"55112321", "São\ Paulo\ \-\ SP",
"55813252", "Recife\ \-\ PE",
"55283322", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55614102", "Brasília\ \-\ DF",
"55212730", "Rio\ de\ Janeiro\ \-\ RJ",
"55843299", "Coronel\ Ezequiel\ \-\ RN",
"55733626", "Núcleo\ Colonial\ de\ Una\ \-\ BA",
"55513409", "Miraguaia\ \-\ RS",
"55663433", "Primavera\ do\ Leste\ \-\ MT",
"55313844", "Cava\ Grande\ \-\ MG",
"55493304", "Chapecó\ \-\ SC",
"55733625", "Mascote\ \-\ BA",
"55623622", "Goiânia\ \-\ GO",
"55753402", "Entre\ Rios\ \-\ BA",
"55933532", "Uruará\ \-\ PA",
"55993567", "São\ João\ do\ Soter\ \-\ MA",
"55343669", "Araxá\ \-\ MG",
"55273031", "Vila\ Velha\ \-\ ES",
"55212394", "Rio\ de\ Janeiro\ \-\ RJ",
"55643677", "Amorinópolis\ \-\ GO",
"55183624", "Araçatuba\ \-\ SP",
"55643018", "Itumbiara\ \-\ GO",
"55513784", "Mato\ Leitão\ \-\ RS",
"55714101", "Salvador\ \-\ BA",
"55114601", "Jundiaí\ \-\ SP",
"55122131", "Guaratinguetá\ \-\ SP",
"55242457", "Santa\ Isabel\ do\ Rio\ Preto\ \-\ RJ",
"55553313", "Santo\ Ângelo\ \-\ RS",
"55353564", "Conceição\ da\ Aparecida\ \-\ MG",
"55893459", "Patos\ do\ Piauí\ \-\ PI",
"55153378", "Pilar\ do\ Sul\ \-\ SP",
"55853104", "Fortaleza\ \-\ CE",
"55493566", "Videira\ \-\ SC",
"55633396", "São\ Salvador\ do\ Tocantins\ \-\ TO",
"55343426", "Pirajuba\ \-\ MG",
"55543332", "Não\-Me\-Toque\ \-\ RS",
"55343425", "Frutal\ \-\ MG",
"55483259", "São\ José\ \-\ SC",
"55863326", "Timon\ \-\ MA",
"55813545", "Igarassu\ \-\ PE",
"55813483", "Olinda\ \-\ PE",
"55143026", "Ourinhos\ \-\ SP",
"55513429", "Canoas\ \-\ RS",
"55623527", "Araçu\ \-\ GO",
"55993662", "Dom\ Pedro\ \-\ MA",
"55983455", "Matões\ do\ Norte\ \-\ MA",
"55323728", "Muriaé\ \-\ MG",
"55883516", "Piquet\ Carneiro\ \-\ CE",
"55493202", "Joaçaba\ \-\ SC",
"55753422", "Alagoinhas\ \-\ BA",
"55883515", "Pedra\ Branca\ \-\ CE",
"55733605", "Itabatan\ \-\ BA",
"55143025", "Lins\ \-\ SP",
"55112597", "São\ Paulo\ \-\ SP",
"551124", "Guarulhos\ \-\ SP",
"55643597", "Itumbiara\ \-\ GO",
"55143478", "Bastos\ \-\ SP",
"55443332", "Itaguajé\ \-\ PR",
"55353326", "Minduri\ \-\ MG",
"55483531", "Morro\ Grande\ \-\ SC",
"55873844", "São\ José\ do\ Egito\ \-\ PE",
"55112301", "São\ Paulo\ \-\ SP",
"55242280", "Petrópolis\ \-\ RJ",
"55823427", "Minador\ do\ Negrão\ \-\ AL",
"55353325", "Andrelândia\ \-\ MG",
"55423631", "Guarapuava\ \-\ PR",
"55693231", "Itapuã\ do\ Oeste\ \-\ RO",
"55353533", "Pratápolis\ \-\ MG",
"55413902", "Paranaguá\ \-\ PR",
"55513665", "Capão\ da\ Canoa\ \-\ RS",
"55913721", "Castanhal\ \-\ PA",
"55543234", "São\ José\ dos\ Ausentes\ \-\ RS",
"55924004", "Manaus\ \-\ AM",
"55843472", "Jardim\ do\ Seridó\ \-\ RN",
"55733267", "Itororó\ \-\ BA",
"55114062", "São\ Paulo\ \-\ SP",
"55323553", "Guiricema\ \-\ MG",
"55213137", "Rio\ de\ Janeiro\ \-\ RJ",
"55833353", "Sumé\ \-\ PB",
"55153543", "Capão\ Bonito\ \-\ SP",
"55833484", "Juru\ \-\ PB",
"55383814", "Mamonas\ \-\ MG",
"55513666", "Terra\ de\ Areia\ \-\ RS",
"55133864", "Jacupiranga\ \-\ SP",
"55123101", "Cachoeira\ Paulista\ \-\ SP",
"55373545", "Paineiras\ \-\ MG",
"55183604", "Vicentinópolis\ \-\ SP",
"55653421", "Rondonópolis\ \-\ MT",
"5521388", "Rio\ de\ Janeiro\ \-\ RJ",
"55553747", "Boa\ Vista\ das\ Missões\ \-\ RS",
"55242259", "Petrópolis\ \-\ RJ",
"55143385", "Tejupá\ \-\ SP",
"55143386", "Taguaí\ \-\ SP",
"55343512", "Araguari\ \-\ MG",
"55223087", "Macaé\ \-\ RJ",
"55373546", "Biquinhas\ \-\ MG",
"55123897", "Caraguatatuba\ \-\ SP",
"55983673", "Brejo\ de\ Areia\ \-\ MA",
"55112166", "Barueri\ \-\ SP",
"55793363", "Canhoba\ \-\ SE",
"55243372", "Paraty\ \-\ RJ",
"55383311", "Paracatu\ \-\ MG",
"55313508", "Belo\ Horizonte\ \-\ MG",
"55173266", "Cedral\ \-\ SP",
"55193024", "Rio\ Claro\ \-\ SP",
"55663513", "Sorriso\ \-\ MT",
"55143293", "Guaianás\ \-\ SP",
"55472033", "Balneário\ Camboriú\ \-\ SC",
"55244004", "Petrópolis\ \-\ RJ",
"55153342", "Sorocaba\ \-\ SP",
"55193675", "Tambaú\ \-\ SP",
"55833552", "São\ José\ de\ Piranhas\ \-\ PB",
"55114593", "Itupeva\ \-\ SP",
"55923019", "Manaus\ \-\ AM",
"55553426", "Alegrete\ \-\ RS",
"55173265", "José\ Bonifácio\ \-\ SP",
"55242411", "Barra\ do\ Piraí\ \-\ RJ",
"55353332", "São\ Lourenço\ \-\ MG",
"55773443", "Caraíbas\ \-\ BA",
"55733537", "Ibirataia\ \-\ BA",
"55753436", "Olindina\ \-\ BA",
"55373016", "Divinópolis\ \-\ MG",
"55353263", "Monsenhor\ Paulo\ \-\ MG",
"55273227", "Vitória\ \-\ ES",
"55143032", "Jaú\ \-\ SP",
"55633452", "Nova\ Olinda\ \-\ TO",
"55553617", "Tiradentes\ do\ Sul\ \-\ RS",
"55373015", "Divinópolis\ \-\ MG",
"55313329", "Minas\ Gerais",
"55933505", "Aveiro\ \-\ PA",
"55773479", "Piatã\ \-\ BA",
"55753435", "Cipó\ \-\ BA",
"5524223", "Petrópolis\ \-\ RJ",
"55273177", "Colatina\ \-\ ES",
"55193818", "Mogi\-Guaçu\ \-\ SP",
"55943327", "Núcleo\ Carajás\ \-\ PA",
"55193881", "Valinhos\ \-\ SP",
"55683303", "Rio\ Branco\ \-\ AC",
"55513031", "Canoas\ \-\ RS",
"55173522", "Catanduva\ \-\ SP",
"55473383", "Ascurra\ \-\ SC",
"55613382", "Guará\ \-\ DF",
"55113576", "São\ Paulo\ \-\ SP",
"55433622", "Jaboti\ \-\ PR",
"55213830", "Rio\ de\ Janeiro\ \-\ RJ",
"55853348", "Pacajus\ \-\ CE",
"55163852", "Sales\ Oliveira\ \-\ SP",
"55893461", "Colônia\ do\ Piauí\ \-\ PI",
"55222664", "Araruama\ \-\ RJ",
"55653247", "Reserva\ do\ Cabaçal\ \-\ MT",
"55193384", "Campinas\ \-\ SP",
"55743620", "São\ Gabriel\ \-\ BA",
"5511419", "Barueri\ \-\ SP",
"55193453", "Limeira\ \-\ SP",
"55553512", "Santa\ Rosa\ \-\ RS",
"55213976", "Rio\ de\ Janeiro\ \-\ RJ",
"55483411", "Criciúma\ \-\ SC",
"55493236", "Urupema\ \-\ SC",
"55933526", "Alenquer\ \-\ PA",
"55963689", "Afuá\ \-\ PA",
"55143737", "Garça\ \-\ SP",
"55623636", "Goiânia\ \-\ GO",
"55843644", "Parnamirim\ \-\ RN",
"55733632", "Ilhéus\ \-\ BA",
"55983377", "Nova\ Olinda\ do\ Maranhão\ \-\ MA",
"55493235", "Painel\ \-\ SC",
"55413031", "Araucária\ \-\ PR",
"55313309", "Belo\ Horizonte\ \-\ MG",
"55813869", "Santa\ Maria\ da\ Boa\ Vista\ \-\ PE",
"55643548", "Itumbiara\ \-\ GO",
"55114456", "Salto\ \-\ SP",
"55673291", "Coxim\ \-\ MS",
"55443305", "Maringá\ \-\ PR",
"55883436", "Itatira\ \-\ CE",
"55513441", "Cachoeirinha\ \-\ RS",
"55163338", "Gavião\ Peixoto\ \-\ SP",
"55223058", "Cabo\ Frio\ \-\ RJ",
"55153244", "Piedade\ \-\ SP",
"55472107", "Jaraguá\ do\ Sul\ \-\ SC",
"55173874", "Macaubal\ \-\ SP",
"55813015", "Recife\ \-\ PE",
"55313528", "Belo\ Horizonte\ \-\ MG",
"55333754", "Cachoeira\ de\ Pajeú\ \-\ MG",
"55543533", "Caxias\ do\ Sul\ \-\ RS",
"55993073", "Imperatriz\ \-\ MA",
"55883435", "Potiretama\ \-\ CE",
"55323254", "Piau\ \-\ MG",
"55123848", "Ubatuba\ \-\ SP",
"55543325", "São\ José\ do\ Herval\ \-\ RS",
"55983392", "Bacuri\ \-\ MA",
"55863332", "Caxingó\ \-\ PI",
"55793205", "Aracaju\ \-\ SE",
"55553798", "Rodeio\ Bonito\ \-\ RS",
"55433527", "Jacarezinho\ \-\ PR",
"55114649", "Itaquaquecetuba\ \-\ SP",
"55543326", "Campos\ Borges\ \-\ RS",
"55353858", "Santana\ da\ Vargem\ \-\ MG",
"5514362", "Jaú\ \-\ SP",
"55923521", "Itacoatiara\ \-\ AM",
"55163251", "Guariba\ \-\ SP",
"55313753", "Rio\ Espera\ \-\ MG",
"55353413", "Passos\ \-\ MG",
"55983621", "Bacabal\ \-\ MA",
"55222633", "Armação\ dos\ Búzios\ \-\ RJ",
"55863263", "Cocal\ de\ Telha\ \-\ PI",
"55283523", "Gironda\ \-\ ES",
"55222785", "Cardoso\ Moreira\ \-\ RJ",
"55743627", "Miguel\ Calmon\ \-\ BA",
"55483258", "São\ José\ \-\ SC",
"55413624", "Agudos\ do\ Sul\ \-\ PR",
"55633384", "Araguaçu\ \-\ TO",
"5511356", "São\ Paulo\ \-\ SP",
"55663406", "Torixoréu\ \-\ MT",
"55633453", "Wanderlândia\ \-\ TO",
"55143585", "Pirajuí\ \-\ SP",
"55663405", "Barra\ do\ Garças\ \-\ MT",
"55143586", "Guarantã\ \-\ SP",
"55173335", "Colômbia\ \-\ SP",
"55153379", "São\ Miguel\ Arcanjo\ \-\ SP",
"55623087", "Goiânia\ \-\ GO",
"55213837", "Rio\ de\ Janeiro\ \-\ RJ",
"55773442", "Buritirama\ \-\ BA",
"55353333", "Soledade\ de\ Minas\ \-\ MG",
"55313855", "Alvinópolis\ \-\ MG",
"55114592", "Itupeva\ \-\ SP",
"55323353", "Dores\ de\ Campos\ \-\ MG",
"55833553", "Carrapateira\ \-\ PB",
"55153343", "Votorantim\ \-\ SP",
"55143292", "Pederneiras\ \-\ SP",
"55663512", "Alta\ Floresta\ \-\ MT",
"55853321", "Guaramiranga\ \-\ CE",
"55313856", "São\ Domingos\ do\ Prata\ \-\ MG",
"55193452", "Limeira\ \-\ SP",
"55443532", "Moreira\ Sales\ \-\ PR",
"55212025", "Rio\ de\ Janeiro\ \-\ RJ",
"55353526", "Passos\ \-\ MG",
"55333427", "Materlândia\ \-\ MG",
"55153494", "Ibiúna\ \-\ SP",
"55513408", "Rio\ Grande\ do\ Sul",
"55112501", "São\ Paulo\ \-\ SP",
"55384141", "Montes\ Claros\ \-\ MG",
"55843298", "São\ Bento\ do\ Trairí\ \-\ RN",
"55613454", "Sobradinho\ \-\ DF",
"55673441", "Nova\ Andradina\ \-\ MS",
"55353525", "Delfinópolis\ \-\ MG",
"55213035", "Rio\ de\ Janeiro\ \-\ RJ",
"55733530", "Entroncamento\ de\ Jaguaquara\ \-\ BA",
"55433623", "Porecatu\ \-\ PR",
"55613383", "Brasília\ \-\ DF",
"55413971", "Matinhos\ \-\ PR",
"55473382", "Timbó\ \-\ SC",
"55173523", "Catanduva\ \-\ SP",
"55473130", "Joinville\ \-\ SC",
"55683302", "Rio\ Branco\ \-\ AC",
"55513604", "Rio\ Grande\ do\ Sul",
"55114781", "Embu\ das\ Artes\ \-\ SP",
"55313057", "Belo\ Horizonte\ \-\ MG",
"55143277", "Bauru\ \-\ SP",
"55115105", "São\ Paulo\ \-\ SP",
"55493524", "Água\ Doce\ \-\ SC",
"55114577", "Mauá\ \-\ SP",
"55114718", "Mairinque\ \-\ SP",
"55222537", "Carmo\ \-\ RJ",
"55484062", "Florianópolis\ \-\ SC",
"55493366", "Pinhalzinho\ \-\ SC",
"55613003", "Brasília\ \-\ DF",
"55993072", "Imperatriz\ \-\ MA",
"55543532", "São\ João\ da\ Urtiga\ \-\ RS",
"55853301", "Beberibe\ \-\ CE",
"55115833", "São\ Paulo\ \-\ SP",
"55353861", "Nepomuceno\ \-\ MG",
"55242258", "Bemposta\ \-\ RJ",
"55413291", "Campo\ Largo\ \-\ PR",
"55493365", "Modelo\ \-\ SC",
"55753471", "Feira\ de\ Santana\ \-\ BA",
"55873856", "Tupanatinga\ \-\ PE",
"55213445", "Rio\ de\ Janeiro\ \-\ RJ",
"55433520", "Cornélio\ Procópio\ \-\ PR",
"55733633", "Ilhéus\ \-\ BA",
"55413604", "Fazenda\ Rio\ Grande\ \-\ PR",
"55873855", "Buíque\ \-\ PE",
"55353364", "Pouso\ Alto\ \-\ MG",
"55314111", "Belo\ Horizonte\ \-\ MG",
"55553513", "Santa\ Rosa\ \-\ RS",
"55283522", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55863262", "Altos\ \-\ PI",
"55513075", "Canoas\ \-\ RS",
"55623307", "Ceres\ \-\ GO",
"55643521", "Itumbiara\ \-\ GO",
"55683322", "Cruzeiro\ do\ Sul\ \-\ AC",
"55513624", "Santa\ Terezinha\ \-\ RS",
"55243321", "Resende\ \-\ RJ",
"55343799", "Araguari\ \-\ MG",
"55143479", "Avencas\ \-\ SP",
"55133387", "Guarujá\ \-\ SP",
"55313752", "Catas\ Altas\ da\ Noruega\ \-\ MG",
"55733281", "Eunápolis\ \-\ BA",
"55212005", "Rio\ de\ Janeiro\ \-\ RJ",
"55623591", "Goiânia\ \-\ GO",
"55313541", "Nova\ Lima\ \-\ MG",
"55913772", "Mosqueiro\ \-\ PA",
"55713634", "Pólo\ Petroquímico\ Camaçari\ \-\ BA",
"55443637", "Cianorte\ \-\ PR",
"55983393", "Luís\ Domingues\ \-\ MA",
"55323729", "Muriaé\ \-\ MG",
"55843421", "Caicó\ \-\ RN",
"55513428", "Rio\ Grande\ do\ Sul",
"55112521", "São\ Paulo\ \-\ SP",
"55493342", "Galvão\ \-\ SC",
"55813362", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55713289", "Lauro\ de\ Freitas\ \-\ BA",
"55242430", "Barra\ do\ Piraí\ \-\ RJ",
"55693481", "Espigão\ do\ Oeste\ \-\ RO",
"55193798", "Campinas\ \-\ SP",
"55693418", "Nova\ Brasilândia\ D\'Oeste\ \-\ RO",
"55873201", "Petrolina\ \-\ PE",
"55553282", "Lavras\ do\ Sul\ \-\ RS",
"55163723", "Franca\ \-\ SP",
"55553595", "Tuparendi\ \-\ RS",
"55162102", "Ribeirão\ Preto\ \-\ SP",
"55843320", "Baraúna\ \-\ RN",
"55753648", "Dom\ Macedo\ Costa\ \-\ BA",
"55873822", "Arcoverde\ \-\ PE",
"55983471", "Chapadinha\ \-\ MA",
"55663452", "Novo\ São\ Joaquim\ \-\ MT",
"55283555", "Mimoso\ do\ Sul\ \-\ ES",
"55813681", "Xexéu\ \-\ PE",
"55193512", "Campinas\ \-\ SP",
"55222009", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55313726", "Santana\ dos\ Montes\ \-\ MG",
"55313574", "Crucilândia\ \-\ MG",
"55483369", "Florianópolis\ \-\ SC",
"55313725", "Caranaíba\ \-\ MG",
"55283556", "São\ José\ do\ Calçado\ \-\ ES",
"55863245", "Nossa\ Senhora\ dos\ Remédios\ \-\ PI",
"55543611", "André\ da\ Rocha\ \-\ RS",
"55923228", "Manaus\ \-\ AM",
"55213917", "Maricá\ \-\ RJ",
"55113368", "São\ Paulo\ \-\ SP",
"55133852", "Ariri\ \-\ SP",
"55193405", "Americana\ \-\ SP",
"55433240", "São\ Martinho\ \-\ PR",
"55193406", "Americana\ \-\ SP",
"55543353", "Caseiros\ \-\ RS",
"55123647", "Lagoinha\ \-\ SP",
"55314003", "Belo\ Horizonte\ \-\ MG",
"55313201", "Belo\ Horizonte\ \-\ MG",
"55883444", "Quixeramobim\ \-\ CE",
"55193669", "Divinolândia\ \-\ SP",
"55443688", "Xambrê\ \-\ PR",
"55114403", "Itu\ \-\ SP",
"55623448", "Flores\ de\ Goiás\ \-\ GO",
"55173279", "Olímpia\ \-\ SP",
"55913346", "Ananindeua\ \-\ PA",
"55483430", "Criciúma\ \-\ SC",
"55773466", "Jacaraci\ \-\ BA",
"55433472", "Ivaiporã\ \-\ PR",
"55473055", "Jaraguá\ do\ Sul\ \-\ SC",
"55493244", "Santa\ Cecília\ \-\ SC",
"55373233", "Pará\ de\ Minas\ \-\ MG",
"55843635", "Santa\ Maria\ \-\ RN",
"55313694", "Nova\ Lima\ \-\ MG",
"55843636", "Ruy\ Barbosa\ \-\ RN",
"55873221", "Garanhuns\ \-\ PE",
"55473056", "Balneário\ Camboriú\ \-\ SC",
"55883648", "Uruoca\ \-\ CE",
"55273115", "Linhares\ \-\ ES",
"55533240", "Bagé\ \-\ RS",
"55173243", "Mirassol\ \-\ SP",
"55773465", "Ibiassucê\ \-\ BA",
"55513713", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55923491", "Carauari\ \-\ AM",
"55114147", "Itapecerica\ da\ Serra\ \-\ SP",
"55383632", "Santa\ Fé\ de\ Minas\ \-\ MG",
"55453282", "Pato\ Bragado\ \-\ PR",
"55353552", "Guaxupé\ \-\ MG",
"55463527", "Francisco\ Beltrão\ \-\ PR",
"55183642", "Birigui\ \-\ SP",
"55323532", "Ubá\ \-\ MG",
"55212641", "Teresópolis\ \-\ RJ",
"55943421", "Conceição\ do\ Araguaia\ \-\ PA",
"55133251", "Santos\ \-\ SP",
"55312559", "Contagem\ \-\ MG",
"55673474", "Mundo\ Novo\ \-\ MS",
"55833263", "Lagoa\ de\ Dentro\ \-\ PB",
"55353741", "Botelhos\ \-\ MG",
"55213212", "Rio\ de\ Janeiro\ \-\ RJ",
"55773629", "Recife\ \-\ PE",
"55193617", "Rio\ Claro\ \-\ SP",
"55983198", "São\ Luís\ \-\ MA",
"55173808", "Engenheiro\ Schimidt\ \-\ SP",
"55153271", "Itapetininga\ \-\ SP",
"55513474", "Sapucaia\ do\ Sul\ \-\ RS",
"5513335", "Guarujá\ \-\ SP",
"55173841", "Arabá\ \-\ SP",
"55734141", "Itabuna\ \-\ BA",
"55713113", "Salvador\ \-\ BA",
"55212608", "Niterói\ \-\ RJ",
"55163722", "Franca\ \-\ SP",
"55933552", "Placas\ \-\ PA",
"55483047", "São\ José\ \-\ SC",
"55143629", "Potunduva\ \-\ SP",
"55843087", "Natal\ \-\ RN",
"55443254", "Atalaia\ \-\ PR",
"55173344", "Bebedouro\ \-\ SP",
"55653391", "Cuiabá\ \-\ MT",
"55513678", "Cristal\ \-\ RS",
"55193938", "Indaiatuba\ \-\ SP",
"55373334", "Piracema\ \-\ MG",
"55813093", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55613639", "Planaltina\ \-\ GO",
"55493343", "Formosa\ do\ Sul\ \-\ SC",
"55813363", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55793483", "Nossa\ Senhora\ Aparecida\ \-\ SE",
"55314002", "Belo\ Horizonte\ \-\ MG",
"55513399", "Rio\ Grande\ do\ Sul",
"55733511", "Eunápolis\ \-\ BA",
"55543352", "São\ José\ do\ Ouro\ \-\ RS",
"55793354", "Gararu\ \-\ SE",
"55693539", "Rio\ Crespo\ \-\ RO",
"55212789", "Mangaratiba\ \-\ RJ",
"55843327", "Grossos\ \-\ RN",
"5511348", "São\ Paulo\ \-\ SP",
"55753062", "Feira\ de\ Santana\ \-\ BA",
"55483239", "Florianópolis\ \-\ SC",
"55133418", "Itariri\ \-\ SP",
"55833364", "Remígio\ \-\ PB",
"55273051", "Serra\ \-\ ES",
"5531330", "Minas\ Gerais",
"55753621", "Cruz\ das\ Almas\ \-\ BA",
"55313248", "Belo\ Horizonte\ \-\ MG",
"55893439", "Marcolândia\ \-\ PI",
"55312106", "Sete\ Lagoas\ \-\ MG",
"55193513", "Limeira\ \-\ SP",
"55133481", "Praia\ Grande\ \-\ SP",
"55153524", "Itapeva\ \-\ SP",
"55963234", "Porto\ Grande\ \-\ AP",
"55112228", "Santo\ André\ \-\ SP",
"55242437", "Ipiabas\ \-\ RJ",
"55513712", "Estrêla\ \-\ RS",
"55823274", "Colônia\ Pindorama\ \-\ AL",
"55173242", "Mirassol\ \-\ SP",
"55813831", "Serra\ Talhada\ \-\ PE",
"55663596", "Paranorte\ \-\ MT",
"55413399", "Campo\ Largo\ \-\ PR",
"55343819", "Monte\ Carmelo\ \-\ MG",
"55443352", "Santo\ Inácio\ \-\ PR",
"55833525", "Sousa\ \-\ PB",
"55373232", "Pará\ de\ Minas\ \-\ MG",
"55423651", "Reserva\ do\ Iguaçu\ \-\ PR",
"55112843", "São\ Paulo\ \-\ SP",
"55894101", "Picos\ \-\ PI",
"55663595", "Matupá\ \-\ MT",
"55613055", "Brasília\ \-\ DF",
"55433473", "Lidianópolis\ \-\ PR",
"55693251", "Vista\ Alegre\ do\ Abunã\ \-\ RO",
"55213434", "Rio\ de\ Janeiro\ \-\ RJ",
"55542109", "Farroupilha\ \-\ RS",
"55383218", "Montes\ Claros\ \-\ MG",
"55463520", "Francisco\ Beltrão\ \-\ PR",
"55163133", "Cristais\ Paulista\ \-\ SP",
"55793546", "Umbaúba\ \-\ SE",
"5569", "Rondônia",
"55133268", "Bertioga\ \-\ SP",
"55873803", "Pesqueira\ \-\ PE",
"55114402", "Atibaia\ \-\ SP",
"55623978", "Anápolis\ \-\ GO",
"55633426", "São\ Sebastião\ do\ Tocantins\ \-\ TO",
"55633425", "Pau\ D\'Arco\ \-\ TO",
"55913015", "Belém\ \-\ PA",
"55793545", "Tomar\ do\ Geru\ \-\ SE",
"55173556", "Irapuã\ \-\ SP",
"55533247", "Bagé\ \-\ RS",
"55623421", "Alvorada\ do\ Norte\ \-\ GO",
"55713645", "Pojuca\ \-\ BA",
"55213213", "Rio\ de\ Janeiro\ \-\ RJ",
"55833262", "João\ Pessoa\ \-\ PB",
"55963332", "Macapá\ \-\ AP",
"55513598", "Campo\ Bom\ \-\ RS",
"55713646", "Lauro\ de\ Freitas\ \-\ BA",
"55163387", "Nova\ Europa\ \-\ SP",
"55793252", "Aracaju\ \-\ SE",
"55333321", "Caratinga\ \-\ MG",
"55323533", "Colônia\ Padre\ Damião\ \-\ MG",
"55183643", "Birigui\ \-\ SP",
"55483437", "Criciúma\ \-\ SC",
"55163984", "São\ Simão\ \-\ SP",
"55883621", "Camocim\ \-\ CE",
"55353553", "Juruaia\ \-\ MG",
"55643491", "Ipameri\ \-\ GO",
"55143711", "Avaré\ \-\ SP",
"55453283", "Margarida\ \-\ PR",
"55383633", "Ubaí\ \-\ MG",
"55753294", "Água\ Fria\ \-\ BA",
"55413678", "Adrianópolis\ \-\ PR",
"55823521", "Arapiraca\ \-\ AL",
"55913817", "Nova\ Esperança\ do\ Piriá\ \-\ PA",
"55873871", "Salgueiro\ \-\ PE",
"55323263", "Maripá\ de\ Minas\ \-\ MG",
"55993646", "Lima\ Campos\ \-\ MA",
"55753456", "Cardeal\ da\ Silva\ \-\ BA",
"55993645", "Esperantinópolis\ \-\ MA",
"55693467", "Rondominas\ \-\ RO",
"55633432", "Bandeirantes\ do\ Tocantins\ \-\ TO",
"55613212", "Brasília\ \-\ DF",
"55123013", "Guaratinguetá\ \-\ SP",
"55343631", "Ibiá\ \-\ MG",
"55373226", "Nova\ Serrana\ \-\ MG",
"55833532", "Cajazeiras\ \-\ PB",
"55893567", "Ribeiro\ Gonçalves\ \-\ PI",
"55413547", "Lapa\ \-\ PR",
"55173829", "Talhado\ \-\ SP",
"55813619", "Fernando\ de\ Noronha\ \-\ PE",
"55143641", "Barra\ Bonita\ \-\ SP",
"55433401", "Cornélio\ Procópio\ \-\ PR",
"55373225", "Nova\ Serrana\ \-\ MG",
"55323332", "Barbacena\ \-\ MG",
"55753649", "Elísio\ Medrado\ \-\ BA",
"55693912", "Espigão\ do\ Oeste\ \-\ RO",
"55863254", "Assunção\ do\ Piauí\ \-\ PI",
"55163832", "Ipuã\ \-\ SP",
"55112754", "São\ Paulo\ \-\ SP",
"55213850", "Rio\ de\ Janeiro\ \-\ RJ",
"55493647", "Palmitos\ \-\ SC",
"55443553", "Janiópolis\ \-\ PR",
"55283544", "Muniz\ Freire\ \-\ ES",
"55913110", "Belém\ \-\ PA",
"55343283", "Monte\ Alegre\ de\ Minas\ \-\ MG",
"55313764", "Conselheiro\ Lafaiete\ \-\ MG",
"55963326", "Ferreira\ Gomes\ \-\ AP",
"55753690", "Capela\ do\ Alto\ Alegre\ \-\ BA",
"55513051", "Canoas\ \-\ RS",
"55713288", "Lauro\ de\ Freitas\ \-\ BA",
"55963325", "Cutias\ \-\ AP",
"55773628", "Luis\ Eduardo\ Magalhães\ \-\ BA",
"55873272", "Parnamirim\ \-\ RN",
"55753593", "Heliópolis\ \-\ BA",
"55173809", "Mendonça\ \-\ SP",
"55163358", "Araraquara\ \-\ SP",
"55115852", "São\ Paulo\ \-\ SP",
"55313871", "Rio\ Casca\ \-\ MG",
"55733041", "Itabuna\ \-\ BA",
"55413642", "Araucária\ \-\ PR",
"55913483", "São\ Domingos\ do\ Capim\ \-\ PA",
"55333734", "Itaobim\ \-\ MG",
"55493256", "Fraiburgo\ \-\ SC",
"55124715", "Alumínio\ \-\ SP",
"55193312", "Indaiatuba\ \-\ SP",
"55713461", "Salvador\ \-\ BA",
"55923427", "Juruá\ \-\ AM",
"55313374", "Minas\ Gerais",
"5541342", "Paranaguá\ \-\ PR",
"55473044", "Brusque\ \-\ SC",
"55883649", "Meruoca\ \-\ CE",
"55313733", "Joaquim\ Murtinho\ \-\ MG",
"55163231", "Guariba\ \-\ SP",
"55623942", "Goiânia\ \-\ GO",
"55313440", "Minas\ Gerais",
"55873764", "Garanhuns\ \-\ PE",
"55193464", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55623473", "Iaciara\ \-\ GO",
"55313685", "Nova\ União\ \-\ MG",
"55313686", "Confins\ \-\ MG",
"55222653", "Saquarema\ \-\ RJ",
"55423617", "Santa\ Maria\ do\ Oeste\ \-\ PR",
"55813721", "Caruaru\ \-\ PE",
"55824004", "Maceió\ \-\ AL",
"55813562", "Primavera\ \-\ PE",
"55493542", "Erval\ Velho\ \-\ SC",
"55883673", "Itapipoca\ \-\ CE",
"55513547", "Rolante\ \-\ RS",
"55333373", "Santana\ do\ Manhuaçu\ \-\ MG",
"55623449", "Guarani\ de\ Goiás\ \-\ GO",
"55173278", "União\ Paulista\ \-\ SP",
"5511471", "São\ Roque\ \-\ SP",
"55313499", "Minas\ Gerais",
"55683242", "Rio\ Branco\ \-\ AC",
"55323333", "Barbacena\ \-\ MG",
"55333521", "Teófilo\ Otoni\ \-\ MG",
"55893438", "São\ Julião\ \-\ PI",
"55313249", "Belo\ Horizonte\ \-\ MG",
"55112229", "Guarulhos\ \-\ SP",
"55313835", "Itabira\ \-\ MG",
"55753697", "Serra\ Preta\ \-\ BA",
"55273347", "Vitória\ \-\ ES",
"55313836", "Itambé\ do\ Mato\ Dentro\ \-\ MG",
"55133419", "Pedro\ de\ Toledo\ \-\ SP",
"55673547", "Debrasa\ \-\ MS",
"55833533", "João\ Pessoa\ \-\ PB",
"5524334", "Volta\ Redonda\ \-\ RJ",
"555132", "Porto\ Alegre\ \-\ RS",
"55633433", "Palmeiras\ do\ Tocantins\ \-\ TO",
"55613213", "Brasília\ \-\ DF",
"55473212", "Brusque\ \-\ SC",
"55443246", "Maringá\ \-\ PR",
"5516333", "Araraquara\ \-\ SP",
"55843061", "Mossoró\ \-\ RN",
"55443245", "Mandaguaçu\ \-\ PR",
"55843391", "Martins\ \-\ RN",
"55323262", "Rochedo\ de\ Minas\ \-\ MG",
"55213857", "São\ Gonçalo\ \-\ RJ",
"55173355", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55813534", "Escada\ \-\ PE",
"55793346", "Canindé\ de\ São\ Francisco\ \-\ SE",
"55513679", "Sentinela\ do\ Sul\ \-\ RS",
"55653327", "Progresso\ \-\ MT",
"55313123", "Belo\ Horizonte\ \-\ MG",
"55114899", "Caieiras\ \-\ SP",
"55813131", "Recife\ \-\ PE",
"55163275", "Taiaçu\ \-\ SP",
"55893560", "Francisco\ Ayres\ \-\ PI",
"55212609", "Niterói\ \-\ RJ",
"55383625", "Varzelândia\ \-\ MG",
"55443552", "Boa\ Esperança\ \-\ PR",
"55153566", "Bairro\ Palmitalzinho\ \-\ SP",
"55413116", "São\ José\ dos\ Pinhais\ \-\ PR",
"55153565", "Itaporanga\ \-\ SP",
"55693913", "Guajará\-Mirim\ \-\ RO",
"55383626", "Ibiracatu\ \-\ MG",
"55372101", "Divinópolis\ \-\ MG",
"55613434", "Recanto\ das\ Emas\ \-\ DF",
"55613044", "Taguatinga\ \-\ DF",
"55833564", "Poço\ de\ José\ de\ Moura\ \-\ PB",
"55163996", "Ribeirão\ Preto\ \-\ SP",
"5567342", "Dourados\ \-\ MS",
"55813748", "Sairé\ \-\ PE",
"55413679", "Campina\ Grande\ do\ Sul\ \-\ PR",
"5531350", "Minas\ Gerais",
"55753285", "Rodelas\ \-\ BA",
"55873836", "Sanharó\ \-\ PE",
"55753286", "Coronel\ João\ Sá\ \-\ BA",
"55873835", "Pesqueira\ \-\ PE",
"55513540", "Rio\ Grande\ do\ Sul",
"55193042", "Piracicaba\ \-\ SP",
"55163995", "Ribeirão\ Preto\ \-\ SP",
"55153324", "Tatuí\ \-\ SP",
"55823597", "Maceió\ \-\ AL",
"55323364", "Paiva\ \-\ MG",
"55153202", "Sorocaba\ \-\ SP",
"55733311", "Teixeira\ de\ Freitas\ \-\ BA",
"55513599", "Sapiranga\ \-\ RS",
"55513115", "Canoas\ \-\ RS",
"55913482", "Augusto\ Corrêa\ \-\ PA",
"55543552", "Cacique\ Doble\ \-\ RS",
"55413643", "Araucária\ \-\ PR",
"55113437", "Guarulhos\ \-\ SP",
"55115853", "São\ Paulo\ \-\ SP",
"55115614", "São\ Paulo\ \-\ SP",
"55112427", "Atibaia\ \-\ SP",
"55633464", "Guaraí\ \-\ TO",
"55313447", "Belo\ Horizonte\ \-\ MG",
"55193651", "Espírito\ Santo\ do\ Pinhal\ \-\ SP",
"55643615", "Quirinópolis\ \-\ GO",
"55854042", "Fortaleza\ \-\ CE",
"55174009", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55343453", "Limeira\ do\ Oeste\ \-\ MG",
"55133269", "Santos\ \-\ SP",
"55213639", "Itaboraí\ \-\ RJ",
"554132", "Curitiba\ \-\ PR",
"55623979", "Anápolis\ \-\ GO",
"55353729", "Poços\ de\ Caldas\ \-\ MG",
"55653904", "Campo\ Novo\ do\ Parecis\ \-\ MT",
"55883672", "Nova\ Russas\ \-\ CE",
"55833306", "Coxixola\ \-\ PB",
"55493543", "Anita\ Garibaldi\ \-\ SC",
"55813563", "Gravatá\ \-\ PE",
"55773641", "Mansidão\ \-\ BA",
"55542108", "Caxias\ do\ Sul\ \-\ RS",
"55812101", "Recife\ \-\ PE",
"55222652", "Saquarema\ \-\ RJ",
"55663584", "Sorriso\ \-\ MT",
"55192516", "Indaiatuba\ \-\ SP",
"55143404", "Tupã\ \-\ SP",
"55343818", "Patos\ de\ Minas\ \-\ MG",
"55413398", "São\ José\ dos\ Pinhais\ \-\ PR",
"55313732", "Congonhas\ \-\ MG",
"55113308", "Jundiaí\ \-\ SP",
"55313684", "Taquaraçu\ de\ Minas\ \-\ MG",
"55183652", "Penápolis\ \-\ SP",
"55624012", "Goiânia\ \-\ GO",
"55543717", "Nova\ Prata\ \-\ RS",
"55193466", "Nova\ Odessa\ \-\ SP",
"55643539", "Itumbiara\ \-\ GO",
"55153532", "Itararé\ \-\ SP",
"55843439", "Bodó\ \-\ RN",
"55793279", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55163349", "Trabiju\ \-\ SP",
"5562331", "Anápolis\ \-\ GO",
"55613471", "Ceilândia\ \-\ DF",
"55333231", "Itanhomi\ \-\ MG",
"55313411", "Minas\ Gerais",
"55453277", "Toledo\ \-\ PR",
"55313488", "Minas\ Gerais",
"55212651", "São\ João\ de\ Meriti\ \-\ RJ",
"5574361", "Juazeiro\ \-\ BA",
"55343820", "Patos\ de\ Minas\ \-\ MG",
"55333736", "Virgem\ da\ Lapa\ \-\ MG",
"55773617", "Baianópolis\ \-\ BA",
"55193629", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55114638", "Poá\ \-\ SP",
"55333735", "Coronel\ Murta\ \-\ MG",
"55632111", "Palmas\ \-\ TO",
"55713472", "Salvador\ \-\ BA",
"55373322", "Formiga\ \-\ MG",
"55173253", "Mirassol\ \-\ SP",
"55463905", "Francisco\ Beltrão\ \-\ PR",
"55313376", "Belo\ Horizonte\ \-\ MG",
"55313862", "Alvorada\ de\ Minas\ \-\ MG",
"55553730", "Vista\ Alegre\ \-\ RS",
"55443343", "Maringá\ \-\ PR",
"55373691", "Divinópolis\ \-\ MG",
"55913738", "Km\ 12\ \-\ PA",
"55473046", "Itajaí\ \-\ SC",
"55883658", "Poranga\ \-\ CE",
"55673029", "Campo\ Grande\ \-\ MS",
"55493254", "Ponte\ Alta\ do\ Norte\ \-\ SC",
"55473045", "Itajaí\ \-\ SC",
"55313375", "Belo\ Horizonte\ \-\ MG",
"55823558", "Penedo\ \-\ AL",
"55273311", "Vila\ Velha\ \-\ ES",
"55543379", "Coxilha\ \-\ RS",
"55283546", "Venda\ Nova\ do\ Imigrante\ \-\ ES",
"55893591", "Jurema\ \-\ PI",
"55313766", "Minas\ Gerais",
"55313765", "Minas\ Gerais",
"55863256", "Alto\ Longá\ \-\ PI",
"55843237", "Parnamirim\ \-\ RN",
"55114044", "Diadema\ \-\ SP",
"55273388", "Vila\ Velha\ \-\ ES",
"55283545", "Iúna\ \-\ ES",
"55553033", "Santa\ Maria\ \-\ RS",
"55543343", "Sananduva\ \-\ RS",
"55753023", "Feira\ de\ Santana\ \-\ BA",
"55793014", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55913544", "Oriximiná\ \-\ PA",
"55212747", "Tanguá\ \-\ RJ",
"55133842", "Ilha\ Comprida\ \-\ SP",
"55963324", "Itaubal\ \-\ AP",
"55183557", "Salmourão\ \-\ SP",
"55813204", "Recife\ \-\ PE",
"55963084", "Macapá\ \-\ AP",
"55173482", "Auriflama\ \-\ SP",
"5512391", "São\ José\ dos\ Campos\ \-\ SP",
"55993644", "Lago\ da\ Pedra\ \-\ MA",
"55853339", "Palmácia\ \-\ CE",
"55483089", "São\ José\ \-\ SC",
"55663442", "Vale\ dos\ Sonhos\ \-\ MT",
"55163763", "Jardinópolis\ \-\ SP",
"55753658", "Fátima\ \-\ BA",
"55313261", "Belo\ Horizonte\ \-\ MG",
"55933543", "Rurópolis\ \-\ PA",
"55813691", "Panelas\ \-\ PE",
"5564", "Goiás",
"55743546", "Itiúba\ \-\ BA",
"55114463", "Santo\ André\ \-\ SP",
"55122128", "Jacareí\ \-\ SP",
"55553277", "São\ Martinho\ da\ Serra\ \-\ RS",
"55733017", "Ilhéus\ \-\ BA",
"55623461", "Pires\ do\ Rio\ \-\ GO",
"55644052", "Itumbiara\ \-\ GO",
"5531336", "Minas\ Gerais",
"55733678", "Monte\ Pascoal\ \-\ BA",
"55713656", "São\ Sebastião\ do\ Passé\ \-\ BA",
"55833304", "São\ Sebastião\ do\ Umbuzeiro\ \-\ PB",
"55713655", "São\ Sebastião\ do\ Passé\ \-\ BA",
"55473471", "São\ Francisco\ do\ Sul\ \-\ SC",
"55173546", "Itajobi\ \-\ SP",
"55533257", "Piratini\ \-\ RS",
"55183311", "Presidente\ Prudente\ \-\ SP",
"55553737", "Vicente\ Dutra\ \-\ RS",
"55153533", "Bom\ Sucesso\ de\ Itararé\ \-\ SP",
"55663585", "Feliz\ Natal\ \-\ MT",
"55143406", "Garça\ \-\ SP",
"55319", "Minas\ Gerais",
"55813759", "Santa\ Cruz\ do\ Capibaribe\ \-\ PE",
"55314062", "Belo\ Horizonte\ \-\ MG",
"55192111", "Rio\ Claro\ \-\ SP",
"55883661", "Acaraú\ \-\ CE",
"55312572", "Betim\ \-\ MG",
"55353543", "Capetinga\ \-\ MG",
"55543244", "São\ Francisco\ de\ Paula\ \-\ RS",
"55663586", "Cocalinho\ \-\ MT",
"55143405", "Pompéia\ \-\ SP",
"55183653", "Penápolis\ \-\ SP",
"55753284", "Macururé\ \-\ BA",
"55163501", "São\ Carlos\ \-\ SP",
"55913829", "Tomé\-Açú\ \-\ PA",
"55833565", "João\ Pessoa\ \-\ PB",
"55517", "Rio\ Grande\ do\ Sul",
"55453270", "Iguiporã\ \-\ PR",
"55613045", "Brasília\ \-\ DF",
"55323366", "Oliveira\ Fortes\ \-\ MG",
"55323365", "Santa\ Bárbara\ do\ Tugúrio\ \-\ MG",
"55443342", "Paranapoema\ \-\ PR",
"55153325", "Sorocaba\ \-\ SP",
"55313863", "Ferros\ \-\ MG",
"55873834", "Poção\ \-\ PE",
"55115616", "São\ Paulo\ \-\ SP",
"55373323", "Pains\ \-\ MG",
"55713473", "Salvador\ \-\ BA",
"55513588", "São\ Leopoldo\ \-\ RS",
"55463560", "Pinhal\ de\ São\ Bento\ \-\ PR",
"55513114", "Guaíba\ \-\ RS",
"55163397", "Araraquara\ \-\ SP",
"55633466", "Pedro\ Afonso\ \-\ TO",
"55643614", "Santa\ Helena\ de\ Goiás\ \-\ GO",
"55633465", "Itapiratins\ \-\ TO",
"55343674", "Matutina\ \-\ MG",
"55212668", "Nova\ Iguaçu\ \-\ RJ",
"55115615", "São\ Paulo\ \-\ SP",
"55653318", "Cuiabá\ \-\ MT",
"55553270", "São\ Miguel\ \-\ RS",
"55114811", "Franco\ da\ Rocha\ \-\ SP",
"55813535", "Moreno\ \-\ PE",
"55133843", "Ilha\ Comprida\ \-\ SP",
"55813536", "Pombos\ \-\ PE",
"55843367", "Paraú\ \-\ RN",
"55793344", "Neópolis\ \-\ SE",
"551120", "São\ Paulo\ \-\ SP",
"55143425", "Marília\ \-\ SP",
"55114888", "Joanópolis\ \-\ SP",
"55753022", "Feira\ de\ Santana\ \-\ BA",
"55543342", "Marau\ \-\ RS",
"55553032", "Santa\ Maria\ \-\ RS",
"55822123", "Maceió\ \-\ AL",
"55133879", "Barra\ do\ Braço\ \-\ SP",
"55383624", "São\ Romão\ \-\ MG",
"55413588", "São\ José\ dos\ Pinhais\ \-\ PR",
"55613436", "Brasília\ \-\ DF",
"55613435", "Brasília\ \-\ DF",
"55993421", "Caxias\ \-\ MA",
"55823027", "Maceió\ \-\ AL",
"55653925", "Cuiabá\ \-\ MT",
"55323271", "Bicas\ \-\ MG",
"55313834", "Itabira\ \-\ MG",
"55114462", "Santo\ André\ \-\ SP",
"55133491", "Praia\ Grande\ \-\ SP",
"55933542", "Jacareacanga\ \-\ PA",
"55133208", "Santos\ \-\ SP",
"55473908", "Itajaí\ \-\ SC",
"55433257", "Pitangueiras\ \-\ PR",
"5592", "Amazonas",
"55623288", "Aparecida\ de\ Goiânia\ \-\ GO",
"55843230", "Nísia\ Floresta\ \-\ RN",
"55313331", "Minas\ Gerais",
"55493353", "Xaxim\ \-\ SC",
"5511349", "São\ Paulo\ \-\ SP",
"55913809", "Inhangapi\ \-\ PA",
"5531377", "Minas\ Gerais",
"55163521", "Sertãozinho\ \-\ SP",
"55173354", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55513389", "Rio\ Grande\ do\ Sul",
"55153305", "Tatuí\ \-\ SP",
"55173483", "Nova\ Luzitânia\ \-\ SP",
"55443244", "Paiçandu\ \-\ PR",
"55663479", "Novo\ São\ Joaquim\ \-\ MT",
"55222643", "Cabo\ Frio\ \-\ RJ",
"5511501", "São\ Paulo\ \-\ SP",
"55213198", "Rio\ de\ Janeiro\ \-\ RJ",
"55163693", "Jardinópolis\ \-\ SP",
"55673028", "Campo\ Grande\ \-\ MS",
"55553025", "Santa\ Maria\ \-\ RS",
"55463581", "Dois\ Vizinhos\ \-\ PR",
"55983212", "São\ Luís\ \-\ MA",
"55553026", "Santa\ Maria\ \-\ RS",
"55883659", "Croatá\ \-\ CE",
"55913739", "Paragominas\ \-\ PA",
"55473423", "Joinville\ \-\ SC",
"55623952", "Aparecida\ de\ Goiânia\ \-\ GO",
"55813761", "Garanhuns\ \-\ PE",
"5524", "Rio\ de\ Janeiro",
"55673476", "Itaquiraí\ \-\ MS",
"55813522", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55114639", "Poá\ \-\ SP",
"55884102", "Crato\ \-\ CE",
"55963271", "Mazagão\ \-\ AP",
"55513557", "Rio\ Grande\ do\ Sul",
"55623459", "Alto\ Paraíso\ de\ Goiás\ \-\ GO",
"55193628", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55493552", "Lacerdópolis\ \-\ SC",
"55813607", "Orobó\ \-\ PE",
"55673475", "Japorã\ \-\ MS",
"55143432", "Marília\ \-\ SP",
"55313489", "Minas\ Gerais",
"55353244", "Cordislândia\ \-\ MG",
"55773668", "Sebastião\ Laranjeiras\ \-\ BA",
"55973351", "Beruri\ \-\ AM",
"55733051", "Alcobaça\ \-\ BA",
"55913344", "Belém\ \-\ PA",
"55413652", "Rio\ Branco\ do\ Sul\ \-\ PR",
"55163348", "Motuca\ \-\ SP",
"55513431", "Gravataí\ \-\ RS",
"55883446", "Aracati\ \-\ CE",
"55843438", "Tenente\ Laurentino\ Cruz\ \-\ RN",
"55553921", "Santa\ Maria\ \-\ RS",
"55433461", "Faxinal\ \-\ PR",
"55623645", "Goiânia\ \-\ GO",
"55843634", "Ceará\-Mirim\ \-\ RN",
"55413041", "Curitiba\ \-\ PR",
"55473054", "Jaraguá\ do\ Sul\ \-\ SC",
"55813265", "Recife\ \-\ PE",
"55493245", "Curitibanos\ \-\ SC",
"55683546", "Brasiléia\ \-\ AC",
"55373371", "Piumhi\ \-\ MG",
"55193053", "Leme\ \-\ SP",
"55483529", "Praia\ Grande\ \-\ SC",
"55773464", "Mortugaba\ \-\ BA",
"55493246", "Fraiburgo\ \-\ SC",
"55443640", "Esperança\ Nova\ \-\ PR",
"55313576", "Bonfim\ \-\ MG",
"55513652", "Butiá\ \-\ RS",
"55493657", "Santa\ Terezinha\ do\ Progresso\ \-\ SC",
"55443543", "Ubiratã\ \-\ PR",
"55283554", "Muqui\ \-\ ES",
"55863244", "Miguel\ Alves\ \-\ PI",
"55853338", "Beberibe\ \-\ CE",
"55193608", "São\ José\ do\ Rio\ Pardo\ \-\ SP",
"55313575", "Moeda\ \-\ MG",
"55313724", "Cristiano\ Otoni\ \-\ MG",
"55753659", "Salinas\ da\ Margarida\ \-\ BA",
"55173817", "Severínia\ \-\ SP",
"55213899", "Rio\ de\ Janeiro\ \-\ RJ",
"55193404", "Limeira\ \-\ SP",
"55913556", "Senador\ José\ Porfírio\ \-\ PA",
"55112152", "Jundiaí\ \-\ SP",
"55513041", "Cachoeirinha\ \-\ RS",
"55273350", "Vila\ Velha\ \-\ ES",
"55883583", "Mombaça\ \-\ CE",
"55313162", "Betim\ \-\ MG",
"55514109", "Gravataí\ \-\ RS",
"55373522", "Bom\ Despacho\ \-\ MG",
"55753680", "Rafael\ Jambeiro\ \-\ BA",
"55453025", "Foz\ do\ Iguaçu\ \-\ PR",
"55333723", "Jacinto\ \-\ MG",
"55332102", "Governador\ Valadares\ \-\ MG",
"55713298", "Simões\ Filho\ \-\ BA",
"55173016", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55753445", "Jandaíra\ \-\ BA",
"55983462", "Cantanhede\ \-\ MA",
"55153263", "Boituva\ \-\ SP",
"55143313", "Bauru\ \-\ SP",
"5524224", "Petrópolis\ \-\ RJ",
"55733547", "Aiquara\ \-\ BA",
"55823231", "Maceió\ \-\ AL",
"55753446", "Sátiro\ Dias\ \-\ BA",
"55693427", "Nova\ Colina\ \-\ RO",
"55453026", "Foz\ do\ Iguaçu\ \-\ PR",
"55353013", "Lavras\ \-\ MG",
"5585", "Ceará",
"55773433", "Boa\ Nova\ \-\ BA",
"557133", "Salvador\ \-\ BA",
"55543378", "Ernestina\ \-\ RS",
"55222540", "Nova\ Friburgo\ \-\ RJ",
"55843663", "Natal\ \-\ RN",
"55513945", "Gravataí\ \-\ RS",
"55313531", "Betim\ \-\ MG",
"55143433", "Marília\ \-\ SP",
"55863343", "Piracuruca\ \-\ PI",
"55443647", "Maripá\ \-\ PR",
"55713644", "Camaçari\ \-\ BA",
"55493553", "Piratuba\ \-\ SC",
"55112419", "Bragança\ Paulista\ \-\ SP",
"55333825", "Belo\ Oriente\ \-\ MG",
"55163321", "Tabatinga\ \-\ SP",
"55212669", "Nova\ Iguaçu\ \-\ RJ",
"55513589", "São\ Leopoldo\ \-\ RS",
"55343972", "Uberaba\ \-\ MG",
"55813523", "Vitória\ de\ Santo\ Antão\ \-\ PE",
"55753296", "Sítio\ do\ Quinto\ \-\ BA",
"55473422", "Joinville\ \-\ SC",
"55323084", "Juiz\ de\ Fora\ \-\ MG",
"55223211", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55643419", "Cromínia\ \-\ GO",
"55983213", "São\ Luís\ \-\ MA",
"55163986", "Luís\ Antônio\ \-\ SP",
"55833271", "Guarabira\ \-\ PB",
"55823275", "Campo\ Alegre\ \-\ AL",
"55513550", "Rio\ Grande\ do\ Sul",
"55823276", "Jequiá\ da\ Praia\ \-\ AL",
"55383227", "Brasília\ de\ Minas\ \-\ MG",
"55663594", "Santa\ Cruz\ do\ Xingu\ \-\ MT",
"55613054", "Brasília\ \-\ DF",
"55143214", "Bauru\ \-\ SP",
"55673041", "Campo\ Grande\ \-\ MS",
"55813758", "Barra\ de\ Guabiraba\ \-\ PE",
"55153364", "Boituva\ \-\ SP",
"55323202", "Cataguases\ \-\ MG",
"55193641", "Vargem\ Grande\ do\ Sul\ \-\ SP",
"55454007", "Cascavel\ \-\ PR",
"55413653", "Pinhais\ \-\ PR",
"55793544", "Itabaianinha\ \-\ SE",
"55913014", "Ananindeua\ \-\ PA",
"55733679", "Porto\ Seguro\ \-\ BA",
"55633424", "Goianorte\ \-\ TO",
"55124448", "Cajamar\ \-\ SP",
"55373523", "Pompéu\ \-\ MG",
"55843381", "Alexandria\ \-\ RN",
"55353698", "Alfenas\ \-\ MG",
"55663478", "Canarana\ \-\ MT",
"55473402", "Joinville\ \-\ SC",
"55883582", "Iguatu\ \-\ CE",
"55554007", "Santa\ Maria\ \-\ RS",
"55163301", "Araraquara\ \-\ SP",
"55673431", "Ponta\ Porã\ \-\ MS",
"55833365", "Alagoa\ Nova\ \-\ PB",
"55143668", "Itaju\ \-\ SP",
"55733540", "Presidente\ Tancredo\ Neves\ \-\ BA",
"55153526", "Itapeva\ \-\ SP",
"55663026", "Rondonópolis\ \-\ MT",
"55833366", "Lagoa\ Seca\ \-\ PB",
"55443542", "Campina\ da\ Lagoa\ \-\ PR",
"55133209", "Santos\ \-\ SP",
"55483341", "Palhoça\ \-\ SC",
"55513653", "Taquari\ \-\ RS",
"55114850", "Itu\ \-\ SP",
"55673557", "Três\ Lagoas\ \-\ MS",
"55843662", "Natal\ \-\ RN",
"55663385", "Nova\ Brasilândia\ \-\ MT",
"55273357", "Vitória\ \-\ ES",
"55513475", "Canoas\ \-\ RS",
"55873983", "Petrolina\ \-\ PE",
"55713038", "Salvador\ \-\ BA",
"55353343", "Baependi\ \-\ MG",
"55773432", "Itambé\ \-\ BA",
"55513476", "Canoas\ \-\ RS",
"55343292", "Uberlândia\ \-\ MG",
"55663386", "São\ José\ do\ Rio\ Claro\ \-\ MT",
"55413589", "Piraquara\ \-\ PR",
"55353012", "Itajubá\ \-\ MG",
"55173345", "Bebedouro\ \-\ SP",
"5531356", "Minas\ Gerais",
"55443255", "Maringá\ \-\ PR",
"55213847", "Rio\ de\ Janeiro\ \-\ RJ",
"55323222", "Juiz\ de\ Fora\ \-\ MG",
"55653319", "Cuiabá\ \-\ MT",
"55153262", "Porto\ Feliz\ \-\ SP",
"55373335", "Passa\ Tempo\ \-\ MG",
"55983463", "Itapecuru\ Mirim\ \-\ MA",
"55443256", "Ângulo\ \-\ PR",
"5511255", "São\ Paulo\ \-\ SP",
"55173346", "Bebedouro\ \-\ SP",
"55333722", "Mata\ Verde\ \-\ MG",
"55114016", "Jarinu\ \-\ SP",
"55333581", "Nova\ Módica\ \-\ MG",
"55353424", "Congonhal\ \-\ MG",
"55223853", "Santo\ Antônio\ de\ Pádua\ \-\ RJ",
"55433251", "Cambé\ \-\ PR",
"55513612", "Doutor\ Ricardo\ \-\ RS",
"55893549", "Alvorada\ do\ Gurguéia\ \-\ PI",
"55114015", "Tuiuti\ \-\ SP",
"55323277", "Chácara\ \-\ MG",
"55793045", "Aracaju\ \-\ SE",
"55652123", "Cuiabá\ \-\ MT",
"55423542", "Mallet\ \-\ PR",
"55493425", "Concórdia\ \-\ SC",
"55273239", "Vila\ Velha\ \-\ ES",
"55693449", "Rolim\ de\ Moura\ \-\ RO",
"5531358", "Minas\ Gerais",
"55212728", "São\ Gonçalo\ \-\ RJ",
"55893573", "Corrente\ \-\ PI",
"55653027", "Cuiabá\ \-\ MT",
"55483642", "Gravatal\ \-\ SC",
"55123668", "Campos\ do\ Jordão\ \-\ SP",
"5543", "Paraná",
"55153282", "Tietê\ \-\ SP",
"55983483", "Magalhães\ de\ Almeida\ \-\ MA",
"55793046", "Aracaju\ \-\ SE",
"55313337", "Belo\ Horizonte\ \-\ MG",
"55883562", "Mineirolândia\ \-\ CE",
"55653387", "Campos\ de\ Júlio\ \-\ MT",
"55813673", "Catende\ \-\ PE",
"55513368", "Rio\ Grande\ do\ Sul",
"55323292", "Bom\ Jardim\ de\ Minas\ \-\ MG",
"55114911", "São\ Paulo\ \-\ SP",
"55313260", "Minas\ Gerais",
"55843361", "Patu\ \-\ RN",
"55663504", "União\ do\ Norte\ \(Antiga\ Lenislândia\)\ \-\ MT",
"55143484", "Álvaro\ de\ Carvalho\ \-\ SP",
"55114817", "Jundiaí\ \-\ SP",
"55813649", "Machados\ \-\ PE",
"55383733", "Francisco\ Dumont\ \-\ MG",
"55343304", "Uberlândia\ \-\ MG",
"55833385", "Cubati\ \-\ PB",
"55423256", "Porto\ Amazonas\ \-\ PR",
"55993427", "Barra\ do\ Corda\ \-\ MA",
"55413517", "São\ José\ dos\ Pinhais\ \-\ PR",
"55453236", "Serranópolis\ do\ Iguaçu\ \-\ PR",
"55273047", "Linhares\ \-\ ES",
"55453235", "Três\ Barras\ do\ Paraná\ \-\ PR",
"55183743", "Ilha\ Solteira\ \-\ SP",
"55753667", "Nossa\ Senhora\ da\ Ajuda\ \-\ BA",
"55833386", "Gurjão\ \-\ PB",
"55683462", "Tarauacá\ \-\ AC",
"55633379", "Caseara\ \-\ TO",
"55463558", "Pérola\ D\'Oeste\ \-\ PR",
"55114168", "Barueri\ \-\ SP",
"55313410", "Minas\ Gerais",
"55853461", "Fortaleza\ \-\ CE",
"55883619", "Forquilha\ \-\ CE",
"5511505", "São\ Paulo\ \-\ SP",
"55153384", "Cerquilho\ \-\ SP",
"55473492", "Santa\ Cruz\ \-\ SC",
"55513778", "Rio\ Grande\ do\ Sul",
"55312591", "Betim\ \-\ MG",
"55553236", "Formigueiro\ \-\ RS",
"55133299", "Santos\ \-\ SP",
"55673238", "Ribas\ do\ Rio\ Pardo\ \-\ MS",
"55683212", "Rio\ Branco\ \-\ AC",
"5511474", "Suzano\ \-\ SP",
"55843276", "Monte\ Alegre\ \-\ RN",
"55793436", "Itabaiana\ \-\ SE",
"55212689", "Porto\ Belo\ \-\ RJ",
"55533251", "São\ Lourenço\ do\ Sul\ \-\ RS",
"55633494", "Barra\ do\ Ouro\ \-\ TO",
"55343324", "Água\ Comprida\ \-\ MG",
"55373690", "Divinópolis\ \-\ MG",
"55273742", "São\ Domingos\ do\ Norte\ \-\ ES",
"55623467", "Teresina\ de\ Goiás\ \-\ GO",
"55843275", "Vera\ Cruz\ \-\ RN",
"55733011", "Teixeira\ de\ Freitas\ \-\ BA",
"55513569", "Morro\ Reuter\ \-\ RS",
"55173639", "Populina\ \-\ SP",
"55343821", "Patos\ de\ Minas\ \-\ MG",
"55883667", "Itarema\ \-\ CE",
"5553", "Rio\ Grande\ do\ Sul",
"55192117", "Campinas\ \-\ SP",
"5571301", "Salvador\ \-\ BA",
"55983482", "Buriti\ \-\ MA",
"55743639", "Várzea\ do\ Poço\ \-\ BA",
"55534052", "Pelotas\ \-\ RS",
"55153283", "Laranjal\ Paulista\ \-\ SP",
"55483643", "Imaruí\ \-\ SC",
"55753660", "Pé\ de\ Serra\ \-\ BA",
"55793316", "Nossa\ Senhora\ de\ Lourdes\ \-\ SE",
"55893572", "Parnaguá\ \-\ PI",
"55843358", "Rafael\ Fernandes\ \-\ RN",
"55973431", "São\ Paulo\ de\ Olivença\ \-\ AM",
"55163603", "Ribeirão\ Preto\ \-\ SP",
"55193769", "Campinas\ \-\ SP",
"55423543", "Paulo\ Frontin\ \-\ PR",
"55652122", "Cáceres\ \-\ MT",
"55273369", "Vila\ Velha\ \-\ ES",
"55553271", "Júlio\ de\ Castilhos\ \-\ RS",
"55473556", "Santa\ Terezinha\ \-\ SC",
"55373286", "São\ Sebastião\ do\ Oeste\ \-\ MG",
"55513613", "Fazenda\ Vilanova\ \-\ RS",
"55173889", "Altair\ \-\ SP",
"55223852", "Miracema\ \-\ RJ",
"55313267", "Belo\ Horizonte\ \-\ MG",
"55413146", "São\ José\ dos\ Pinhais\ \-\ PR",
"55323032", "Juiz\ de\ Fora\ \-\ MG",
"55683463", "Feijó\ \-\ AC",
"55513238", "Rio\ Grande\ do\ Sul",
"55313330", "Belo\ Horizonte\ \-\ MG",
"55843231", "Natal\ \-\ RN",
"55433268", "Ibiporã\ \-\ PR",
"55183742", "Ilha\ Solteira\ \-\ SP",
"55123042", "São\ José\ dos\ Campos\ \-\ SP",
"55553524", "Crissiumal\ \-\ RS",
"55273317", "Vitória\ \-\ ES",
"55113399", "São\ Paulo\ \-\ SP",
"55353641", "Brasópolis\ \-\ MG",
"55143352", "Piraju\ \-\ SP",
"55193717", "Limeira\ \-\ SP",
"55193578", "Campinas\ \-\ SP",
"55183551", "Lucélia\ \-\ SP",
"55473242", "Pomerode\ \-\ SC",
"55212741", "Teresópolis\ \-\ RJ",
"55323293", "Liberdade\ \-\ MG",
"55883563", "Icó\ \-\ CE",
"55793198", "Aracaju\ \-\ SE",
"55683213", "Rio\ Branco\ \-\ AC",
"55773688", "Novo\ Paraná\ \-\ BA",
"55883660", "Cruz\ \-\ CE",
"5522", "Rio\ de\ Janeiro",
"55773611", "Barreiras\ \-\ BA",
"55913423", "Salinópolis\ \-\ PA",
"5521375", "São\ João\ de\ Meriti\ \-\ RJ",
"55123432", "Taubaté\ \-\ SP",
"55553366", "Itacurubi\ \-\ RS",
"55553365", "Roque\ Gonzales\ \-\ RS",
"55343848", "Romaria\ \-\ MG",
"55142109", "Bauru\ \-\ SP",
"55213809", "Rio\ de\ Janeiro\ \-\ RJ",
"55873794", "Ibirajuba\ \-\ PE",
"55443465", "Cruzeiro\ do\ Sul\ \-\ PR",
"55773484", "Santana\ \-\ BA",
"55323442", "Leopoldina\ \-\ MG",
"55473344", "Itajaí\ \-\ SC",
"55752101", "Feira\ de\ Santana\ \-\ BA",
"55313625", "Ribeirão\ das\ Neves\ \-\ MG",
"55813577", "Sirinhaém\ \-\ PE",
"55313074", "Belo\ Horizonte\ \-\ MG",
"55434052", "Londrina\ \-\ PR",
"55112646", "São\ Paulo\ \-\ SP",
"55313626", "Ribeirão\ das\ Neves\ \-\ MG",
"55453271", "Sede\ Alvorada\ \-\ PR",
"55273743", "Colatina\ \-\ ES",
"55643645", "Acreúna\ \-\ GO",
"55823634", "Senador\ Rui\ Palmeira\ \-\ AL",
"55333237", "Fernandes\ Tourinho\ \-\ MG",
"55443629", "Cianorte\ \-\ PR",
"55853813", "São\ Paulo\ \-\ SP",
"55643480", "Edealina\ \-\ GO",
"55623538", "Goiânia\ \-\ GO",
"55353465", "Monte\ Sião\ \-\ MG",
"55383822", "Janaúba\ \-\ MG",
"55193542", "Araras\ \-\ SP",
"55114482", "Mairiporã\ \-\ SP",
"55873883", "Parnamirim\ \-\ PE",
"55863216", "Teresina\ \-\ PI",
"55614009", "Brasília\ \-\ DF",
"55493668", "Flor\ do\ Sertão\ \-\ SC",
"55813648", "João\ Alfredo\ \-\ PE",
"55112715", "Itu\ \-\ SP",
"55123426", "Taubaté\ \-\ SP",
"55833394", "Ingá\ \-\ PB",
"55353466", "Munhoz\ \-\ MG",
"55383201", "Montes\ Claros\ \-\ MG",
"55753362", "Boa\ Vista\ Cananéia\ \-\ BA",
"55983345", "Rosário\ \-\ MA",
"55843133", "Natal\ \-\ RN",
"55143495", "Tupã\ \-\ SP",
"55812119", "Recife\ \-\ PE",
"55143496", "Tupã\ \-\ SP",
"55433339", "Londrina\ \-\ PR",
"55173463", "Fernandópolis\ \-\ SP",
"55983346", "Bacabeira\ \-\ MA",
"55543052", "Bento\ Gonçalves\ \-\ RS",
"55513099", "São\ Leopoldo\ \-\ RS",
"55163904", "Ribeirão\ Preto\ \-\ SP",
"5594", "Pará",
"55353629", "Itajubá\ \-\ MG",
"55753414", "Cachoeira\ \-\ BA",
"55123669", "Campos\ do\ Jordão\ \-\ SP",
"55493312", "Chapecó\ \-\ SC",
"5512395", "Jacareí\ \-\ SP",
"55733528", "Jequié\ \-\ BA",
"55343271", "Ituiutaba\ \-\ MG",
"55433152", "Arapongas\ \-\ PR",
"55653361", "Barra\ do\ Bugres\ \-\ MT",
"55222541", "Nova\ Friburgo\ \-\ RJ",
"55173044", "Bebedouro\ \-\ SP",
"55693448", "Ministro\ Andreazza\ \-\ RO",
"55843387", "Riacho\ de\ Santana\ \-\ RN",
"55833479", "Cacimba\ de\ Areia\ \-\ PB",
"55753681", "Cabaceiras\ do\ Paraguaçu\ \-\ BA",
"55153584", "Taquarivaí\ \-\ SP",
"55673437", "Ponta\ Porã\ \-\ MS",
"55833443", "Brejo\ do\ Cruz\ \-\ PB",
"55554001", "Santa\ Maria\ \-\ RS",
"55163307", "São\ Carlos\ \-\ SP",
"55123512", "São\ José\ dos\ Campos\ \-\ SP",
"55833033", "Santa\ Rita\ \-\ PB",
"55673047", "Campo\ Grande\ \-\ MS",
"55383221", "Montes\ Claros\ \-\ MG",
"55753264", "Riachão\ do\ Jacuípe\ \-\ BA",
"55643461", "Pires\ do\ Rio\ \-\ GO",
"55624052", "Goiânia\ \-\ GO",
"55313883", "Rio\ Doce\ \-\ MG",
"55173638", "Mesópolis\ \-\ SP",
"55333021", "Governador\ Valadares\ \-\ MG",
"55433538", "Andirá\ \-\ PR",
"55513568", "São\ Leopoldo\ \-\ RS",
"55973389", "Apuí\ \-\ AM",
"55833292", "Mamanguape\ \-\ PB",
"55212688", "Itaguaí\ \-\ RJ",
"55454001", "Cascavel\ \-\ PR",
"55193647", "Itobi\ \-\ SP",
"55143553", "Guaimbê\ \-\ SP",
"55493433", "Xanxerê\ \-\ SC",
"55673239", "Água\ Clara\ \-\ MS",
"55653275", "Glória\ D\'Oeste\ \-\ MT",
"55183368", "Lutécia\ \-\ SP",
"55883414", "Quixadá\ \-\ CE",
"55623481", "Posse\ \-\ GO",
"55513779", "Rio\ Grande\ do\ Sul",
"55133298", "Santos\ \-\ SP",
"55443641", "Terra\ Boa\ \-\ PR",
"55773657", "Tabocas\ do\ Brejo\ Velho\ \-\ BA",
"55313537", "Serra\ Azul\ \-\ MG",
"55213555", "Rio\ de\ Janeiro\ \-\ RJ",
"55112812", "Guarulhos\ \-\ SP",
"5545357", "Foz\ do\ Iguaçu\ \-\ PR",
"55833277", "Pirpirituba\ \-\ PB",
"55663565", "Aripuanã\ \-\ MT",
"55323025", "Juiz\ de\ Fora\ \-\ MG",
"55383726", "Santo\ Hipólito\ \-\ MG",
"55613355", "Taguatinga\ \-\ DF",
"55513743", "Candelária\ \-\ RS",
"55333318", "Caratinga\ \-\ MG",
"55663566", "Juína\ \-\ MT",
"55383725", "Morro\ da\ Garça\ \-\ MG",
"55513430", "Gravataí\ \-\ RS",
"55323026", "Juiz\ de\ Fora\ \-\ MG",
"55633378", "Ponte\ Alta\ do\ Tocantins\ \-\ TO",
"55273145", "Vitória\ \-\ ES",
"55613356", "Taguatinga\ \-\ DF",
"55463559", "Quedas\ do\ Iguaçu\ \-\ PR",
"55413099", "Curitiba\ \-\ PR",
"551155", "São\ Paulo\ \-\ SP",
"55212709", "Niterói\ \-\ RJ",
"55114169", "Carapicuíba\ \-\ SP",
"55693421", "Ji\-Paraná\ \-\ RO",
"55173462", "Fernandópolis\ \-\ SP",
"55193579", "Campinas\ \-\ SP",
"55983015", "São\ Luís\ \-\ MA",
"55813974", "Recife\ \-\ PE",
"55553304", "Santa\ Maria\ \-\ RS",
"55623338", "Corumbá\ de\ Goiás\ \-\ GO",
"55834105", "Cabedelo\ \-\ PB",
"55473544", "Trombudo\ Central\ \-\ SC",
"55813377", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55853113", "Aquiraz\ \-\ CE",
"55133448", "Mongaguá\ \-\ SP",
"55873882", "Serrita\ \-\ PE",
"55114483", "Mairiporã\ \-\ SP",
"55513239", "Rio\ Grande\ do\ Sul",
"55193543", "Araras\ \-\ SP",
"55513310", "Rio\ Grande\ do\ Sul",
"55383823", "Riacho\ dos\ Machados\ \-\ MG",
"551132", "São\ Paulo\ \-\ SP",
"55893521", "Floriano\ \-\ PI",
"55173811", "Nova\ Aliança\ \-\ SP",
"55813621", "Carpina\ \-\ PE",
"55213492", "Niterói\ \-\ RJ",
"55553565", "Porto\ Lucena\ \-\ RS",
"5511461", "Cotia\ \-\ SP",
"5562", "Goiás",
"55213828", "Rio\ de\ Janeiro\ \-\ RJ",
"55193768", "Campinas\ \-\ SP",
"55493313", "Chapecó\ \-\ SC",
"55453324", "Cascavel\ \-\ PR",
"55513047", "Gravataí\ \-\ RS",
"55843359", "Água\ Nova\ \-\ RN",
"55194113", "Sumaré\ \-\ SP",
"55633542", "Silvanópolis\ \-\ TO",
"55493432", "Irani\ \-\ SC",
"55113599", "Osasco\ \-\ SP",
"55433467", "Rio\ Branco\ do\ Ivaí\ \-\ PR",
"55753334", "Lençóis\ \-\ BA",
"55143552", "Getulina\ \-\ SP",
"55443628", "Jussara\ \-\ PR",
"55113115", "São\ Paulo\ \-\ SP",
"55183351", "Palmital\ \-\ SP",
"55513437", "Rio\ Grande\ do\ Sul",
"55833293", "Lucena\ \-\ PB",
"55623539", "Goiânia\ \-\ GO",
"55644012", "Itumbiara\ \-\ GO",
"55713616", "Salvador\ \-\ BA",
"55453565", "São\ Miguel\ do\ Iguaçu\ \-\ PR",
"55313530", "Betim\ \-\ MG",
"55213279", "Rio\ de\ Janeiro\ \-\ RJ",
"55313882", "Minas\ Gerais",
"55624053", "Goiânia\ \-\ GO",
"55443424", "Paranavaí\ \-\ PR",
"55413047", "Almirante\ Tamandaré\ \-\ PR",
"55553324", "Cruz\ Alta\ \-\ RS",
"55833032", "Santa\ Rita\ \-\ PB",
"55813719", "Caruaru\ \-\ PE",
"55773495", "Caetité\ \-\ BA",
"55142108", "Bauru\ \-\ SP",
"55873785", "Lagoa\ do\ Ouro\ \-\ PE",
"55343849", "Monte\ Carmelo\ \-\ MG",
"55473356", "Vidal\ Ramos\ \-\ SC",
"55343235", "Uberlândia\ \-\ MG",
"55513742", "Sobradinho\ \-\ RS",
"55473355", "Brusque\ \-\ SC",
"55193486", "Charqueada\ \-\ SP",
"55343236", "Uberlândia\ \-\ MG",
"55873786", "Iati\ \-\ PE",
"55112813", "São\ Paulo\ \-\ SP",
"55453304", "Cascavel\ \-\ PR",
"55112654", "São\ Paulo\ \-\ SP",
"55773496", "Santa\ Maria\ da\ Vitória\ \-\ BA",
"55643654", "Cachoeira\ Alta\ \-\ GO",
"55513551", "Estância\ Velha\ \-\ RS",
"55613108", "Brasília\ \-\ DF",
"55773689", "Rosário\ \-\ BA",
"55883415", "Palhano\ \-\ CE",
"55753522", "Castro\ Alves\ \-\ BA",
"55353214", "Varginha\ \-\ MG",
"55273752", "Nova\ Venécia\ \-\ ES",
"55243401", "Barra\ Mansa\ \-\ RJ",
"55115812", "São\ Paulo\ \-\ SP",
"55513529", "Sapiranga\ \-\ RS",
"55883416", "Tauá\ \-\ CE",
"55533241", "Bagé\ \-\ RS",
"55913811", "Ipixuna\ do\ Pará\ \-\ PA",
"55114278", "Santa\ Isabel\ \-\ SP",
"55153394", "Ibiúna\ \-\ SP",
"55843301", "Natal\ \-\ RN",
"55663564", "Confresa\ \-\ MT",
"55823527", "Craíbas\ \-\ AL",
"55613354", "Brasília\ \-\ DF",
"55613483", "Sobradinho\ \-\ DF",
"55733612", "Itabuna\ \-\ BA",
"55213554", "Rio\ de\ Janeiro\ \-\ RJ",
"55643497", "Santo\ Antônio\ do\ Rio\ Verde\ \-\ GO",
"55193352", "Araras\ \-\ SP",
"55883627", "Martinópole\ \-\ CE",
"55383724", "Presidente\ Juscelino\ \-\ MG",
"55483431", "Quarta\ Linha\ \-\ SC",
"55333327", "Ipaba\ \-\ MG",
"55753265", "Santaluz\ \-\ BA",
"55163662", "Batatais\ \-\ SP",
"55333087", "Teófilo\ Otoni\ \-\ MG",
"55143769", "Holambra\ II\ \-\ SP",
"55423657", "Palmital\ \-\ PR",
"55192129", "Campinas\ \-\ SP",
"55123608", "Taubaté\ \-\ SP",
"55353433", "Camanducaia\ \-\ MG",
"55463548", "Bom\ Jesus\ do\ Sul\ \-\ PR",
"55323453", "Dona\ Eusébia\ \-\ MG",
"55753266", "Araci\ \-\ BA",
"55353799", "Caldas\ \-\ MG",
"55343412", "Campina\ Verde\ \-\ MG",
"55643472", "Santa\ Cruz\ de\ Goiás\ \-\ GO",
"55623878", "Goiânia\ \-\ GO",
"55913462", "Capanema\ \-\ PA",
"55633484", "Campos\ Lindos\ \-\ TO",
"55183329", "Tarumã\ \-\ SP",
"55633353", "Alvorada\ \-\ TO",
"5531367", "Sabará\ \-\ MG",
"55143343", "Canitar\ \-\ SP",
"55883522", "Jaguaribe\ \-\ CE",
"55814102", "Recife\ \-\ PE",
"55153292", "Salto\ de\ Pirapora\ \-\ SP",
"55163519", "Ribeirão\ Preto\ \-\ SP",
"55313220", "Minas\ Gerais",
"55843321", "Mossoró\ \-\ RN",
"55343333", "Uberaba\ \-\ MG",
"55893580", "Dom\ Inocêncio\ \-\ PI",
"55823622", "São\ José\ da\ Tapera\ \-\ AL",
"5531359", "Betim\ \-\ MG",
"55173045", "Catanduva\ \-\ SP",
"55242431", "Piraí\ \-\ RJ",
"55423245", "Socavão\ \-\ PR",
"55343262", "Ituiutaba\ \-\ MG",
"55143379", "Ribeirão\ do\ Sul\ \-\ SP",
"55753627", "Sapeaçu\ \-\ BA",
"55513509", "São\ Leopoldo\ \-\ RS",
"55623407", "São\ Miguel\ do\ Passa\ Quatro\ \-\ GO",
"55663533", "Sinop\ \-\ MT",
"55243421", "Angra\ dos\ Reis\ \-\ RJ",
"55843692", "Lagoa\ de\ Pedras\ \-\ RN",
"55423246", "Caetano\ Mendes\ \-\ PR",
"55123424", "Taubaté\ \-\ SP",
"55833396", "Aroeiras\ \-\ PB",
"55353464", "Inconfidentes\ \-\ MG",
"55893559", "Itaueira\ \-\ PI",
"5571", "Bahia",
"55173847", "Floreal\ \-\ SP",
"55223843", "Varre\-Sai\ \-\ RJ",
"55833395", "Umbuzeiro\ \-\ PB",
"55833065", "Campina\ Grande\ \-\ PB",
"55153277", "Tapiraí\ \-\ SP",
"55863214", "Teresina\ \-\ PI",
"55484109", "Biguaçu\ \-\ SC",
"55513011", "Lajeado\ \-\ RS",
"55923247", "Manaus\ \-\ AM",
"55212768", "Nova\ Iguaçu\ \-\ RJ",
"55813445", "Recife\ \-\ PE",
"55483652", "Grão\ Pará\ \-\ SC",
"55183528", "Osvaldo\ Cruz\ \-\ SP",
"55813446", "Recife\ \-\ PE",
"55693459", "Ji\-Paraná\ \-\ RO",
"55653397", "Diamantino\ \-\ MT",
"55163567", "Cajuru\ \-\ SP",
"55113357", "São\ Paulo\ \-\ SP",
"55323282", "Pedro\ Teixeira\ \-\ MG",
"55513088", "Lajeado\ \-\ RS",
"55423552", "General\ Carneiro\ \-\ PR",
"55313665", "Pedro\ Leopoldo\ \-\ MG",
"55553533", "São\ Martinho\ \-\ RS",
"55382104", "Montes\ Claros\ \-\ MG",
"55193484", "Nova\ Odessa\ \-\ SP",
"55873784", "São\ João\ \-\ PE",
"55453306", "Cascavel\ \-\ PR",
"55773494", "Tremedal\ \-\ BA",
"55193353", "Araras\ \-\ SP",
"55112655", "São\ Paulo\ \-\ SP",
"55453305", "Cascavel\ \-\ PR",
"55733613", "Itabuna\ \-\ BA",
"55114141", "Itapevi\ \-\ SP",
"55373071", "Divinópolis\ \-\ MG",
"55473354", "Guabiruba\ \-\ SC",
"55643655", "Paranaiguara\ \-\ GO",
"55653548", "Lucas\ do\ Rio\ Verde\ \-\ MT",
"55643656", "Caçu\ \-\ GO",
"55273753", "Vila\ Pavão\ \-\ ES",
"55773698", "Ibotirama\ \-\ BA",
"55212647", "Magé\ \-\ RJ",
"55943427", "Água\ Azul\ do\ Norte\ \-\ PA",
"55673509", "Três\ Lagoas\ \-\ MS",
"55633352", "Crixás\ do\ Tocantins\ \-\ TO",
"55753335", "Andaraí\ \-\ BA",
"55963118", "Macapá\ \-\ AP",
"55643942", "Itumbiara\ \-\ GO",
"55753336", "Wagner\ \-\ BA",
"55313207", "Belo\ Horizonte\ \-\ MG",
"55343413", "São\ Francisco\ de\ Sales\ \-\ MG",
"55823520", "Girau\ do\ Ponciano\ \-\ AL",
"55183855", "Monte\ Castelo\ \-\ SP",
"55112473", "Bragança\ Paulista\ \-\ SP",
"55323452", "Itamarati\ de\ Minas\ \-\ MG",
"55553326", "Cruz\ Alta\ \-\ RS",
"55953194", "Boa\ Vista\ \-\ RR",
"55353432", "Córrego\ do\ Bom\ Jesus\ \-\ MG",
"55112490", "Bragança\ Paulista\ \-\ SP",
"55193709", "Campinas\ \-\ SP",
"55953591", "Uiramutã\ \-\ RR",
"55163663", "Jardinópolis\ \-\ SP",
"55183856", "Nova\ Guataporanga\ \-\ SP",
"55443425", "Loanda\ \-\ PR",
"55733238", "Itajuípe\ \-\ BA",
"55843693", "Touros\ \-\ RN",
"55543617", "Tapejara\ \-\ RS",
"55663532", "Sinop\ \-\ MT",
"55993538", "Açailândia\ \-\ MA",
"55343263", "Capinópolis\ \-\ MG",
"55483028", "Florianópolis\ \-\ SC",
"55813687", "Bonito\ \-\ PE",
"55453326", "Cascavel\ \-\ PR",
"55383531", "Diamantina\ \-\ MG",
"55823623", "Olho\ d\'Água\ das\ Flores\ \-\ AL",
"55212751", "São\ João\ de\ Meriti\ \-\ RJ",
"55343332", "Uberaba\ \-\ MG",
"55153293", "Sorocaba\ \-\ SP",
"55353651", "Paraisópolis\ \-\ MG",
"55883523", "Crato\ \-\ CE",
"55483476", "Nova\ Veneza\ \-\ SC",
"55653349", "Campo\ Novo\ do\ Parecis\ \-\ MT",
"55143342", "Chavantes\ \-\ SP",
"55114738", "Mogi\ das\ Cruzes\ \-\ SP",
"55222778", "Casimiro\ de\ Abreu\ \-\ RJ",
"55423553", "Bituruna\ \-\ PR",
"55323283", "Rio\ Preto\ \-\ MG",
"5584320", "Natal\ \-\ RN",
"55913434", "Garrafão\ do\ Norte\ \-\ PA",
"55113389", "São\ Paulo\ \-\ SP",
"55483653", "Rio\ Fortuna\ \-\ SC",
"55623142", "Goiânia\ \-\ GO",
"55983014", "São\ Luís\ \-\ MA",
"55553305", "Ijuí\ \-\ RS",
"55983477", "São\ Bernardo\ \-\ MA",
"55313409", "Belo\ Horizonte\ \-\ MG",
"55893587", "Dirceu\ Arcoverde\ \-\ PI",
"55223842", "Porciúncula\ \-\ RJ",
"55473545", "Pouso\ Redondo\ \-\ SC",
"55473546", "Laurentino\ \-\ SC",
"55833282", "Pilar\ \-\ PB",
"55773647", "Ibitiara\ \-\ BA",
"55873031", "Petrolina\ \-\ PE",
"55984009", "São\ Luís\ \-\ MA",
"55713460", "Salvador\ \-\ BA",
"55843274", "Ceará\-Mirim\ \-\ RN",
"55153478", "Pilar\ do\ Sul\ \-\ SP",
"55453332", "Nova\ Santa\ Rosa\ \-\ PR",
"55353798", "Areado\ \-\ MG",
"55123609", "Taubaté\ \-\ SP",
"55443313", "Santa\ Inês\ \-\ PR",
"55313893", "Porto\ Firme\ \-\ MG",
"55513753", "Roca\ Sales\ \-\ RS",
"55963283", "Santana\ \-\ AP",
"55663525", "Carlinda\ \-\ MT",
"55183916", "Presidente\ Prudente\ \-\ SP",
"55553413", "Uruguaiana\ \-\ RS",
"55463549", "Realeza\ \-\ PR",
"55114808", "Jundiaí\ \-\ SP",
"55663526", "Porto\ dos\ Gaúchos\ \-\ MT",
"55153026", "Sorocaba\ \-\ SP",
"55313870", "Minas\ Gerais",
"55653301", "Chapada\ dos\ Guimarães\ \-\ MT",
"55143768", "Jurumirim\ \-\ SP",
"55793213", "Aracaju\ \-\ SE",
"55412152", "Paranaguá\ \-\ PR",
"55883691", "Crateús\ \-\ CE",
"55313441", "Minas\ Gerais",
"55193657", "Tapiratiba\ \-\ SP",
"55143543", "Promissão\ \-\ SP",
"55213252", "Rio\ de\ Janeiro\ \-\ RJ",
"55373383", "Carmo\ da\ Mata\ \-\ MG",
"55843521", "Macau\ \-\ RN",
"55333622", "Nanuque\ \-\ MG",
"55133211", "Santos\ \-\ SP",
"55113431", "Barueri\ \-\ SP",
"55114243", "Cotia\ \-\ SP",
"55553234", "Vila\ Nova\ do\ Sul\ \-\ RS",
"55143486", "Herculândia\ \-\ SP",
"55193839", "Amparo\ \-\ SP",
"5512394", "São\ José\ dos\ Campos\ \-\ SP",
"55222551", "Cordeiro\ \-\ RJ",
"55953623", "Boa\ Vista\ \-\ RR",
"55993614", "Itaipava\ do\ Grajaú\ \-\ MA",
"5511346", "São\ Paulo\ \-\ SP",
"55114109", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55653321", "Cuiabá\ \-\ MT",
"55192108", "Americana\ \-\ SP",
"55183529", "Osvaldo\ Cruz\ \-\ SP",
"55212769", "Nova\ Iguaçu\ \-\ RJ",
"55663506", "Analândia\ do\ Norte\ \-\ MT",
"55833453", "Conceição\ \-\ PB",
"55653692", "Várzea\ Grande\ \-\ MT",
"55113652", "Osasco\ \-\ SP",
"55833384", "Pocinhos\ \-\ PB",
"55663412", "Juscimeira\ \-\ MT",
"55873870", "Trindade\ \-\ PE",
"55693654", "São\ Domingos\ \-\ RO",
"55423254", "Colônia\ Witmarsum\ \-\ PR",
"55883571", "Juazeiro\ do\ Norte\ \-\ CE",
"55114492", "Jundiaí\ \-\ SP",
"55843372", "Severiano\ Melo\ \-\ RN",
"55893558", "São\ Francisco\ do\ Piauí\ \-\ PI",
"55483357", "São\ José\ \-\ SC",
"55873893", "Itacuruba\ \-\ PE",
"55453234", "Catanduvas\ \-\ PR",
"55673541", "Bataguassu\ \-\ MS",
"55213483", "Rio\ de\ Janeiro\ \-\ RJ",
"55613554", "Brasília\ \-\ DF",
"55115112", "São\ Paulo\ \-\ SP",
"55273341", "Serra\ \-\ ES",
"55813658", "Glória\ do\ Goitá\ \-\ PE",
"55813700", "Caruaru\ \-\ PE",
"55193552", "Mogi\ Mirim\ \-\ SP",
"55143378", "Salto\ Grande\ \-\ SP",
"55443432", "Nova\ Londrina\ \-\ PR",
"55283515", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55114014", "Morungaba\ \-\ SP",
"55353426", "Senador\ José\ Bento\ \-\ MG",
"55333527", "Ouro\ Verde\ de\ Minas\ \-\ MG",
"55553332", "Ijuí\ \-\ RS",
"55753322", "Feira\ de\ Santana\ \-\ BA",
"55543042", "Farroupilha\ \-\ RS",
"55493424", "Bom\ Jesus\ \-\ SC",
"55753204", "Feira\ de\ Santana\ \-\ BA",
"55553263", "Faxinal\ do\ Soturno\ \-\ RS",
"55213851", "Nova\ Iguaçu\ \-\ RJ",
"55114477", "Santo\ André\ \-\ SP",
"55843397", "Umarizal\ \-\ RN",
"55173423", "Votuporanga\ \-\ SP",
"55813454", "Recife\ \-\ PE",
"55983355", "Cajapió\ \-\ MA",
"55163518", "Cravinhos\ \-\ SP",
"55193708", "Campinas\ \-\ SP",
"55733239", "Uruçuca\ \-\ BA",
"55313624", "Ribeirão\ das\ Neves\ \-\ MG",
"55473346", "Itajaí\ \-\ SC",
"55553412", "Uruguaiana\ \-\ RS",
"55114555", "Mauá\ \-\ SP",
"55443043", "Paiçandu\ \-\ PR",
"55513752", "Jacarezinho\ \-\ RS",
"55963282", "Santana\ \-\ AP",
"5599", "Maranhão",
"55313892", "Viçosa\ \-\ MG",
"55443312", "Nossa\ Senhora\ das\ Graças\ \-\ PR",
"55343859", "Patos\ de\ Minas\ \-\ MG",
"55453262", "Matelândia\ \-\ PR",
"55543433", "Arco\ Verde\ \-\ RS",
"55553506", "São\ Francisco\ de\ Assis\ \-\ RS",
"55453333", "Cascavel\ \-\ PR",
"55115646", "São\ Paulo\ \-\ SP",
"55983278", "São\ Luís\ \-\ MA",
"55883535", "Assaré\ \-\ CE",
"55513541", "Taquara\ \-\ RS",
"55115645", "São\ Paulo\ \-\ SP",
"55883536", "Lavras\ da\ Mangabeira\ \-\ CE",
"55463572", "Cruzeiro\ do\ Iguaçu\ \-\ PR",
"55433878", "Londrina\ \-\ PR",
"55553505", "Alegrete\ \-\ RS",
"55313428", "Belo\ Horizonte\ \-\ MG",
"55643644", "Aporé\ \-\ GO",
"55833283", "Sapé\ \-\ PB",
"55443668", "Serra\ dos\ Dourados\ \-\ PR",
"55313877", "Jequeri\ \-\ MG",
"55733047", "Jequié\ \-\ BA",
"55183341", "Cândido\ Mota\ \-\ SP",
"55654004", "Várzea\ Grande\ \-\ MT",
"55333623", "Fronteira\ dos\ Vales\ \-\ MG",
"55943491", "Redenção\ \-\ PA",
"55484141", "Florianópolis\ \-\ SC",
"55143542", "Promissão\ \-\ SP",
"55653549", "Lucas\ do\ Rio\ Verde\ \-\ MT",
"55193496", "Rafard\ \-\ SP",
"55383834", "Nova\ Porteirinha\ \-\ MG",
"55873796", "Capoeiras\ \-\ PE",
"55433616", "Sengés\ \-\ PR",
"55773485", "Carinhanha\ \-\ BA",
"55873795", "Jurema\ \-\ PE",
"55443464", "São\ Pedro\ do\ Paraná\ \-\ PR",
"55193495", "Limeira\ \-\ SP",
"55933512", "Santarém\ \-\ PA",
"55873892", "Terra\ Nova\ \-\ PE",
"55843373", "Rodolfo\ Fernandes\ \-\ RN",
"55114493", "Várzea\ Paulista\ \-\ SP",
"55553526", "Sede\ Nova\ \-\ RS",
"55813661", "Palmares\ \-\ PE",
"55493641", "Princesa\ \-\ SC",
"55313408", "Belo\ Horizonte\ \-\ MG",
"55553525", "Humaitá\ \-\ RS",
"55313291", "Belo\ Horizonte\ \-\ MG",
"55113653", "Osasco\ \-\ SP",
"55833452", "Piancó\ \-\ PB",
"5513331", "Bertioga\ \-\ SP",
"55813707", "Frei\ Miguelinho\ \-\ PE",
"55513057", "Montenegro\ \-\ RS",
"55114739", "Mogi\ das\ Cruzes\ \-\ SP",
"55222779", "Conceição\ de\ Macabu\ \-\ RJ",
"55543464", "Garibaldi\ \-\ RS",
"55693461", "Ouro\ Preto\ do\ Oeste\ \-\ RO",
"55173422", "Votuporanga\ \-\ SP",
"55733551", "Aurelino\ Leal\ \-\ BA",
"55873877", "Floresta\ \-\ PE",
"55553262", "Paraíso\ do\ Sul\ \-\ RS",
"55793314", "Itabi\ \-\ SE",
"55553333", "Ijuí\ \-\ RS",
"55443433", "Nova\ Aliança\ do\ Ivaí\ \-\ PR",
"55483029", "São\ José\ \-\ SC",
"55883303", "Aracati\ \-\ CE",
"55343637", "Pratinha\ \-\ MG",
"55993539", "Vila\ Nova\ dos\ Martírios\ \-\ MA",
"55833426", "Emas\ \-\ PB",
"55213534", "Rio\ de\ Janeiro\ \-\ RJ",
"55663495", "Primavera\ do\ Leste\ \-\ MT",
"55433573", "Guapirama\ \-\ PR",
"55613334", "Recanto\ das\ Emas\ \-\ DF",
"55863282", "Água\ Branca\ \-\ PI",
"5589", "Piauí",
"55213131", "Rio\ de\ Janeiro\ \-\ RJ",
"55733261", "Eunápolis\ \-\ BA",
"55553552", "Vista\ Gaúcha\ \-\ RS",
"55663496", "Alto\ Taquari\ \-\ MT",
"55913727", "Tomé\-Açu\ \-\ PA",
"55833425", "Quixabá\ \-\ PB",
"55273732", "Baixo\ Guandu\ \-\ ES",
"55433549", "Bandeirantes\ \-\ PR",
"55493025", "Chapecó\ \-\ SC",
"55513706", "Rio\ Grande\ do\ Sul",
"55123891", "São\ Sebastião\ \-\ SP",
"55223081", "Macaé\ \-\ RJ",
"55493674", "Mondaí\ \-\ SC",
"55143324", "Ourinhos\ \-\ SP",
"55434004", "Londrina\ \-\ PR",
"55793445", "Carira\ \-\ SE",
"55143202", "Bauru\ \-\ SP",
"55473264", "Balneário\ Camboriú\ \-\ SC",
"55513705", "Marques\ de\ Souza\ \-\ RS",
"55123107", "Areias\ \-\ SP",
"55672106", "Campo\ Grande\ \-\ MS",
"55983323", "Centro\ do\ Guilherme\ \-\ MA",
"55673248", "Costa\ Rica\ \-\ MS",
"55112591", "São\ Paulo\ \-\ SP",
"55513498", "Rio\ Grande\ do\ Sul",
"55333299", "Açucena\ \-\ MG",
"55183272", "Presidente\ Venceslau\ \-\ SP",
"55672105", "Três\ Lagoas\ \-\ MS",
"55223321", "Rio\ das\ Ostras\ \-\ RJ",
"55693237", "Porto\ Velho\ \-\ RO",
"55513822", "Gravataí\ \-\ RS",
"55423637", "Nova\ Laranjeiras\ \-\ PR",
"55823421", "Palmeira\ dos\ Índios\ \-\ AL",
"55123972", "Santa\ Branca\ \-\ SP",
"55213660", "Barra\ Mansa\ \-\ RJ",
"55513694", "Minas\ do\ Leão\ \-\ RS",
"55674002", "Campo\ Grande\ \-\ MS",
"55483537", "Meleiro\ \-\ SC",
"55414003", "Curitiba\ \-\ PR",
"55353453", "São\ Sebastião\ da\ Bela\ Vista\ \-\ MG",
"55115906", "São\ Paulo\ \-\ SP",
"55313713", "Capim\ Branco\ \-\ MG",
"55913284", "Ananindeua\ \-\ PA",
"55643591", "Itumbiara\ \-\ GO",
"55143222", "Bauru\ \-\ SP",
"55453245", "Braganey\ \-\ PR",
"55323312", "Juiz\ de\ Fora\ \-\ MG",
"55623372", "Goiás\ \-\ GO",
"55513726", "Lajeado\ \-\ RS",
"55643087", "Itumbiara\ \-\ GO",
"55114607", "Jundiaí\ \-\ SP",
"55663553", "Juruena\ \-\ MT",
"55813639", "Macaparana\ \-\ PE",
"55383743", "Pirapora\ \-\ MG",
"55473362", "Presidente\ Nereu\ \-\ SC",
"55613363", "Guará\ \-\ DF",
"55913661", "Oeiras\ do\ Pará\ \-\ PA",
"55513725", "Cerro\ Branco\ \-\ RS",
"55115021", "São\ Paulo\ \-\ SP",
"55643671", "São\ Luís\ de\ Montes\ Belos\ \-\ GO",
"55183992", "Narandiba\ \-\ SP",
"55453246", "Palmitópolis\ \-\ PR",
"55343611", "Araxá\ \-\ MG",
"55113183", "Itatiba\ \-\ SP",
"55473233", "São\ Francisco\ do\ Sul\ \-\ SC",
"55114761", "Mogi\ das\ Cruzes\ \-\ SP",
"55753278", "Cícero\ Dantas\ \-\ BA",
"55112087", "Guarulhos\ \-\ SP",
"55343353", "Conquista\ \-\ MG",
"55163461", "Araraquara\ \-\ SP",
"55514003", "Porto\ Alegre\ \-\ RS",
"55973428", "Maraã\ \-\ AM",
"55823298", "Porto\ de\ Pedras\ \-\ AL",
"55213748", "Belford\ Roxo\ \-\ RJ",
"55483632", "Tubarão\ \-\ SC",
"55633364", "Lagoa\ da\ Confusão\ \-\ TO",
"5553322", "Pelotas\ \-\ RS",
"55312112", "Belo\ Horizonte\ \-\ MG",
"55183871", "Panorama\ \-\ SP",
"55623397", "Rialma\ \-\ GO",
"55114265", "Itapecerica\ da\ Serra\ \-\ SP",
"55423532", "São\ Mateus\ do\ Sul\ \-\ PR",
"55353282", "Carvalhópolis\ \-\ MG",
"55273249", "Paraju\ \-\ ES",
"55193858", "Engenheiro\ Coelho\ \-\ SP",
"55112886", "São\ Paulo\ \-\ SP",
"55993561", "Governador\ Luiz\ Rocha\ \-\ MA",
"55893539", "Porto\ Alegre\ do\ Piauí\ \-\ PI",
"55843228", "Ceará\-Mirim\ \-\ RN",
"55323464", "Estrela\ Dalva\ \-\ MG",
"55743672", "Morro\ do\ Chapéu\ \-\ BA",
"55273273", "Sooretama\ \-\ ES",
"55112885", "Guarulhos\ \-\ SP",
"55733684", "Itamaraty\ \-\ BA",
"55823644", "Água\ Branca\ \-\ AL",
"55333247", "Itabirinha\ \-\ MG",
"5551332", "Rio\ Grande\ do\ Sul",
"55643635", "Santa\ Rita\ do\ Araguaia\ \-\ GO",
"55613264", "Brasília\ \-\ DF",
"55512125", "Porto\ Alegre\ \-\ RS",
"55623548", "Aparecida\ de\ Goiânia\ \-\ GO",
"55115634", "São\ Paulo\ \-\ SP",
"55323747", "Alto\ Caparaó\ \-\ MG",
"55883544", "Farias\ Brito\ \-\ CE",
"55143203", "Bauru\ \-\ SP",
"55613797", "Brasília\ \-\ DF",
"55213667", "Duque\ de\ Caxias\ \-\ RJ",
"55963426", "Lourenço\ \-\ AP",
"55313598", "Minas\ Gerais",
"55673221", "Três\ Lagoas\ \-\ MS",
"55693230", "Candeias\ do\ Jamari\ \-\ RO",
"55512126", "Porto\ Alegre\ \-\ RS",
"55423630", "Guarapuava\ \-\ PR",
"55643636", "Jataí\ \-\ GO",
"55273733", "Brejetuba\ \-\ ES",
"55533321", "Pelotas\ \-\ RS",
"55713125", "Camaçari\ \-\ BA",
"55712136", "Salvador\ \-\ BA",
"55443584", "Icaraíma\ \-\ PR",
"55933596", "São\ José\ \-\ PA",
"55473334", "Blumenau\ \-\ SC",
"55873816", "Buíque\ \-\ PE",
"55222765", "Macaé\ \-\ RJ",
"55112783", "São\ Paulo\ \-\ SP",
"55433572", "Londrina\ \-\ PR",
"55313712", "Matozinhos\ \-\ MG",
"55433301", "Londrina\ \-\ PR",
"55353452", "Careaçu\ \-\ MG",
"55674003", "Campo\ Grande\ \-\ MS",
"55923194", "Manaus\ \-\ AM",
"55143848", "Itatinga\ \-\ SP",
"55733258", "Maraú\ \-\ BA",
"55383239", "Mirabela\ \-\ MG",
"55713276", "Salvador\ \-\ BA",
"55342109", "Araguari\ \-\ MG",
"55383845", "Taiobeiras\ \-\ MG",
"55114620", "Osasco\ \-\ SP",
"55193187", "Santa\ Maria\ da\ Serra\ \-\ SP",
"55543396", "Santo\ Expedito\ do\ Sul\ \-\ RS",
"55673574", "Inocência\ \-\ MS",
"55183273", "Álvares\ Machado\ \-\ SP",
"55483664", "Florianópolis\ \-\ SC",
"55373514", "Abaeté\ \-\ MG",
"5511499", "Santo\ André\ \-\ SP",
"5512362", "Taubaté\ \-\ SP",
"55543395", "Viadutos\ \-\ RS",
"55412106", "Curitiba\ \-\ PR",
"55983322", "Boa\ Vista\ do\ Gurupi\ \-\ MA",
"55313399", "Minas\ Gerais",
"55273764", "Pedro\ Canário\ \-\ ES",
"55343352", "Uberaba\ \-\ MG",
"55213175", "Nilópolis\ \-\ RJ",
"55713105", "Salvador\ \-\ BA",
"55753544", "Ubaíra\ \-\ BA",
"55613233", "Guará\ \-\ DF",
"55754009", "Feira\ de\ Santana\ \-\ BA",
"55713682", "Bom\ Despacho\ \-\ BA",
"55693581", "Machadinho\ D\'Oeste\ \-\ RO",
"55623349", "Hidrolina\ \-\ GO",
"55193861", "Mogi\-Guaçu\ \-\ SP",
"55993558", "Passagem\ Franca\ \-\ MA",
"55183993", "Cuiabá\ Paulista\ \-\ SP",
"55833513", "João\ Pessoa\ \-\ PB",
"55613362", "Guará\ \-\ DF",
"55473363", "Balneário\ Camboriú\ \-\ SC",
"55383742", "Buritizeiro\ \-\ MG",
"55663552", "Guarantã\ do\ Norte\ \-\ MT",
"5551330", "Rio\ Grande\ do\ Sul",
"55673498", "Caarapó\ \-\ MS",
"55512106", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55843241", "Canguaretama\ \-\ RN",
"55623373", "Jussara\ \-\ GO",
"55323313", "Juiz\ de\ Fora\ \-\ MG",
"55143223", "Bauru\ \-\ SP",
"55923671", "Manaus\ \-\ AM",
"5511412", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55273272", "Guarapari\ \-\ ES",
"55773202", "Vitória\ da\ Conquista\ \-\ BA",
"55633234", "Palmas\ \-\ TO",
"55983302", "São\ Luís\ \-\ MA",
"55743673", "Uauá\ \-\ BA",
"55913658", "Santa\ Cruz\ do\ Arari\ \-\ PA",
"55983224", "São\ José\ de\ Ribamar\ \-\ MA",
"55964400", "Macapá\ \-\ AP",
"55543584", "Passo\ Fundo\ \-\ RS",
"55973441", "Santa\ Isabel\ do\ Rio\ Negro\ \-\ AM",
"55353283", "Poço\ Fundo\ \-\ MG",
"55423533", "Antônio\ Olinto\ \-\ PR",
"55743649", "Uibaí\ \-\ BA",
"55613618", "Águas\ Lindas\ de\ Goiás\ \-\ GO",
"55513733", "Encruzilhada\ do\ Sul\ \-\ RS",
"55733287", "Belmonte\ \-\ BA",
"55643602", "Rio\ Verde\ \-\ GO",
"55513440", "Rio\ Grande\ do\ Sul",
"55123674", "Tremembé\ \-\ SP",
"55114082", "São\ Paulo\ \-\ SP",
"55123025", "Taubaté\ \-\ SP",
"55513685", "Capivari\ do\ Sul\ \-\ RS",
"55843616", "Natal\ \-\ RN",
"55353066", "Poços\ de\ Caldas\ \-\ MG",
"55373213", "Divinópolis\ \-\ MG",
"55513686", "Magistério\ \-\ RS",
"55123026", "Taubaté\ \-\ SP",
"55833464", "Junco\ do\ Seridó\ \-\ PB",
"55623301", "Leopoldo\ de\ Bulhões\ \-\ GO",
"55273136", "Cariacica\ \-\ ES",
"5531340", "Minas\ Gerais",
"55843427", "Timbaúba\ dos\ Batistas\ \-\ RN",
"5519372", "Campinas\ \-\ SP",
"5521386", "Rio\ de\ Janeiro\ \-\ RJ",
"55443631", "Cianorte\ \-\ PR",
"55313547", "Minas\ Gerais",
"55513499", "Eldorado\ do\ Sul\ \-\ RS",
"55623597", "Goiânia\ \-\ GO",
"55543452", "Bento\ Gonçalves\ \-\ RS",
"55333298", "Açucena\ \-\ MG",
"55453352", "Rio\ do\ Salto\ \-\ PR",
"55143366", "Bauru\ \-\ SP",
"55353867", "Ribeirão\ Vermelho\ \-\ MG",
"55733162", "Porto\ Seguro\ \-\ BA",
"55373434", "Medeiros\ \-\ MG",
"55493443", "São\ Domingos\ \-\ SC",
"55433548", "Sapopema\ \-\ PR",
"55553254", "Cacequi\ \-\ RS",
"55653491", "Itiquira\ \-\ MT",
"55115933", "São\ Paulo\ \-\ SP",
"55443283", "Barbosa\ Ferraz\ \-\ PR",
"55323512", "Juiz\ de\ Fora\ \-\ MG",
"55733575", "Arraial\ d\'Ajuda\ \-\ BA",
"55623572", "Goiânia\ \-\ GO",
"55183221", "Presidente\ Prudente\ \-\ SP",
"55173648", "Paranapuã\ \-\ SP",
"55223866", "São\ José\ de\ Ubá\ \-\ RJ",
"55613563", "Taguatinga\ \-\ DF",
"55383612", "Montalvânia\ \-\ MG",
"55473562", "Taió\ \-\ SC",
"55223865", "São\ João\ do\ Paraíso\ \-\ RJ",
"55114204", "Araçariguama\ \-\ SP",
"55413122", "Curitiba\ \-\ PR",
"5513345", "Peruíbe\ \-\ SP",
"55753477", "Chorrochó\ \-\ BA",
"55112894", "São\ Paulo\ \-\ SP",
"55133519", "Santos\ \-\ SP",
"55833433", "Coremas\ \-\ PB",
"55673447", "Novo\ Horizonte\ do\ Sul\ \-\ MS",
"55112507", "São\ Paulo\ \-\ SP",
"55213773", "Nova\ Iguaçu\ \-\ RJ",
"55893538", "Colônia\ do\ Gurguéia\ \-\ PI",
"55112622", "São\ Paulo\ \-\ SP",
"55333421", "Guanhães\ \-\ MG",
"55543283", "Caxias\ do\ Sul\ \-\ RS",
"55453254", "Marechal\ Cândido\ Rondon\ \-\ PR",
"55513764", "Cruzeiro\ do\ Sul\ \-\ RS",
"55843229", "São\ Gonçalo\ do\ Amarante\ \-\ RN",
"55423234", "Colônia\ Castrolanda\ \-\ PR",
"55163953", "Pontal\ \-\ SP",
"55274002", "Vitória\ \-\ ES",
"55473205", "Joinville\ \-\ SC",
"55983523", "Imperatriz\ \-\ MA",
"55114571", "São\ Paulo\ \-\ SP",
"55222531", "Sumidouro\ \-\ RJ",
"55183706", "Suzanápolis\ \-\ SP",
"55193859", "Valinhos\ \-\ SP",
"55643622", "Rio\ Verde\ \-\ GO",
"55273248", "Aracê\ \-\ ES",
"5531342", "Minas\ Gerais",
"55823299", "Atalaia\ \-\ AL",
"55222134", "Iguaba\ Grande\ \-\ RJ",
"55114174", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55114787", "Taboão\ da\ Serra\ \-\ SP",
"55183705", "Guaraçaí\ \-\ SP",
"55413685", "Paiol\ de\ Baixo\ \-\ PR",
"55753279", "Paripiranga\ \-\ BA",
"55943348", "Curionópolis\ \-\ PA",
"55493277", "Bom\ Retiro\ \-\ SC",
"55813434", "Paulista\ \-\ PE",
"55853924", "Fortaleza\ \-\ CE",
"55743621", "Jacobina\ \-\ BA",
"55114302", "São\ Paulo\ \-\ SP",
"55183822", "Dracena\ \-\ SP",
"55753243", "Conceição\ do\ Jacuípe\ \-\ BA",
"55323425", "Santana\ de\ Cataguases\ \-\ MG",
"55813638", "Bom\ Jardim\ \-\ PE",
"55183694", "Zacarias\ \-\ SP",
"55993587", "São\ Francisco\ do\ Brejão\ \-\ MA",
"55653228", "Lambari\ D\'Oeste\ \-\ MT",
"55553352", "São\ Luiz\ Gonzaga\ \-\ RS",
"55323426", "Miraí\ \-\ MG",
"55313956", "Contagem\ \-\ MG",
"55542621", "Bento\ Gonçalves\ \-\ RS",
"55443452", "Santa\ Cruz\ de\ Monte\ Castelo\ \-\ PR",
"55115097", "São\ Paulo\ \-\ SP",
"55543384", "Barros\ Cassal\ \-\ RS",
"55193306", "Sumaré\ \-\ SP",
"55212173", "Rio\ de\ Janeiro\ \-\ RJ",
"55883555", "Jardim\ \-\ CE",
"55173392", "Viradouro\ \-\ SP",
"55433521", "Londrina\ \-\ PR",
"55213077", "Rio\ de\ Janeiro\ \-\ RJ",
"5511482", "Ribeirão\ Pires\ \-\ SP",
"55883556", "Catarina\ \-\ CE",
"55813314", "Recife\ \-\ PE",
"55193305", "Campinas\ \-\ SP",
"55733259", "Ibirapitanga\ \-\ BA",
"55383238", "Grão\ Mogol\ \-\ MG",
"55133048", "São\ Vicente\ \-\ SP",
"55342108", "Araguari\ \-\ MG",
"55483469", "Treviso\ \-\ SC",
"55143849", "Bairro\ de\ Santana\ \-\ SP",
"55343246", "Araguari\ \-\ MG",
"55673272", "Sidrolândia\ \-\ MS",
"55713164", "Salvador\ \-\ BA",
"55373212", "Divinópolis\ \-\ MG",
"55173621", "Jales\ \-\ SP",
"55163257", "Cândido\ Rodrigues\ \-\ SP",
"55343839", "Patrocínio\ \-\ MG",
"55354104", "Lavras\ \-\ MG",
"55114083", "São\ Paulo\ \-\ SP",
"55114535", "Jundiaí\ \-\ SP",
"55343245", "Indianópolis\ \-\ MG",
"55643603", "Iporá\ \-\ GO",
"55513732", "Rio\ Grande\ do\ Sul",
"55943301", "Maracajá\ \-\ PA",
"55833313", "Boa\ Vista\ \-\ PB",
"55833042", "João\ Pessoa\ \-\ PB",
"55473563", "Salete\ \-\ SC",
"55383613", "Itacarambi\ \-\ MG",
"55613562", "Taguatinga\ \-\ DF",
"5551350", "Rio\ Grande\ do\ Sul",
"55983371", "Governador\ Nunes\ Freire\ \-\ MA",
"55143731", "Avaré\ \-\ SP",
"55313540", "Minas\ Gerais",
"55623573", "Goiânia\ \-\ GO",
"55313599", "Ibirité\ \-\ MG",
"55423526", "Porto\ União\ \-\ SC",
"55643520", "Itumbiara\ \-\ GO",
"55115932", "São\ Paulo\ \-\ SP",
"55243320", "Volta\ Redonda\ \-\ RJ",
"55963312", "Macapá\ \-\ AP",
"55483625", "Treze\ de\ Maio\ \-\ SC",
"55433274", "Arapongas\ \-\ PR",
"55483626", "Tubarão\ \-\ SC",
"55493442", "Concórdia\ \-\ SC",
"55753344", "Palmeiras\ \-\ BA",
"55313116", "Belo\ Horizonte\ \-\ MG",
"55793022", "Aracaju\ \-\ SE",
"55623549", "Aparecida\ de\ Goiânia\ \-\ GO",
"55673297", "Chapadão\ do\ Baús\ \-\ MS",
"55513447", "Alvorada\ \-\ RS",
"55743648", "Ibipeba\ \-\ BA",
"55513037", "São\ Leopoldo\ \-\ RS",
"55613619", "Águas\ Lindas\ de\ Goiás\ \-\ GO",
"55115090", "São\ Paulo\ \-\ SP",
"55273725", "Itaguaçu\ \-\ ES",
"55513123", "Porto\ Alegre\ \-\ RS",
"55193887", "Hortolândia\ \-\ SP",
"55943321", "Marabá\ \-\ PA",
"55273726", "Pancas\ \-\ ES",
"55643623", "Rio\ Verde\ \-\ GO",
"55273171", "Linhares\ \-\ ES",
"55114759", "Suzano\ \-\ SP",
"55483267", "Nova\ Trento\ \-\ SC",
"55853320", "Paramoti\ \-\ CE",
"55274003", "Vitória\ \-\ ES",
"55163952", "Pitangueiras\ \-\ SP",
"55653241", "Mirassol\ D\'Oeste\ \-\ MT",
"55543282", "Canela\ \-\ RS",
"55112623", "São\ Paulo\ \-\ SP",
"55193326", "Campinas\ \-\ SP",
"55443676", "Cruzeiro\ do\ Oeste\ \-\ PR",
"55115049", "São\ Paulo\ \-\ SP",
"55193325", "Campinas\ \-\ SP",
"55443675", "Cidade\ Gaúcha\ \-\ PR",
"55113633", "São\ Paulo\ \-\ SP",
"55893467", "Lagoa\ do\ Sítio\ \-\ PI",
"55813212", "Recife\ \-\ PE",
"55443453", "Santa\ Isabel\ do\ Ivaí\ \-\ PR",
"55673499", "Vila\ Nova\ Casa\ Verde\ \-\ MS",
"55963214", "Macapá\ \-\ AP",
"55553353", "Guarani\ das\ Missões\ \-\ RS",
"55473534", "Agrolândia\ \-\ SC",
"55993559", "Sucupira\ do\ Norte\ \-\ MA",
"55613701", "Brasília\ \-\ DF",
"55622765", "Goiânia\ \-\ GO",
"55753242", "Amélia\ Rodrigues\ \-\ BA",
"55183823", "Dracena\ \-\ SP",
"5551352", "Rio\ Grande\ do\ Sul",
"5513328", "Santos\ \-\ SP",
"55673686", "Bonito\ \-\ MS",
"55913446", "São\ Miguel\ do\ Guamá\ \-\ PA",
"55623348", "Mozarlândia\ \-\ GO",
"55553611", "Unistalda\ \-\ RS",
"55483330", "Florianópolis\ \-\ SC",
"55673440", "Amandina\ \-\ MS",
"55913445", "Santa\ Luzia\ do\ Pará\ \-\ PA",
"55313398", "Minas\ Gerais",
"55423412", "Mato\ Branco\ de\ Baixo\ \-\ PR",
"55733531", "Ipiaú\ \-\ BA",
"55813436", "Paulista\ \-\ PE",
"55273259", "Santa\ Teresa\ \-\ ES",
"55113170", "São\ Paulo\ \-\ SP",
"55193848", "Louveira\ \-\ SP",
"55544007", "Caxias\ do\ Sul\ \-\ RS",
"55313357", "Contagem\ \-\ MG",
"55674062", "Campo\ Grande\ \-\ MS",
"55813435", "Paulista\ \-\ PE",
"55933737", "Almeirim\ \-\ PA",
"55833215", "João\ Pessoa\ \-\ PB",
"55223833", "Bom\ Jesus\ do\ Itabapoana\ \-\ RJ",
"55613535", "Brasília\ \-\ DF",
"55173837", "Sebastianópolis\ do\ Sul\ \-\ SP",
"55183696", "Turiúba\ \-\ SP",
"55993521", "Caxias\ \-\ MA",
"55323424", "Laranjal\ \-\ MG",
"55123119", "Campos\ de\ Cunha\ \-\ SP",
"55843268", "Caiçara\ do\ Rio\ do\ Vento\ \-\ RN",
"55853381", "Maracanaú\ \-\ CE",
"55483031", "Florianópolis\ \-\ SC",
"55613536", "Brasília\ \-\ DF",
"55183695", "Planalto\ \-\ SP",
"5585345", "Fortaleza\ \-\ CE",
"55143262", "Agudos\ \-\ SP",
"55453256", "Mercedes\ \-\ PR",
"55383753", "Felixlândia\ \-\ MG",
"55513766", "Bom\ Retiro\ do\ Sul\ \-\ RS",
"55423236", "Ponta\ Grossa\ \-\ PR",
"55112895", "São\ Paulo\ \-\ SP",
"55733694", "São\ José\ da\ Vitória\ \-\ BA",
"55913621", "Caiçava\ \-\ PA",
"55423235", "Ponta\ Grossa\ \-\ PR",
"55773413", "Cascavel\ \-\ BA",
"55513765", "Lagoão\ \-\ RS",
"55112896", "Santo\ André\ \-\ SP",
"55473204", "São\ Francisco\ do\ Sul\ \-\ SC",
"55133591", "Praia\ Grande\ \-\ SP",
"55453255", "São\ Pedro\ do\ Iguaçu\ \-\ PR",
"55115061", "São\ Paulo\ \-\ SP",
"55623387", "Anápolis\ \-\ GO",
"55114176", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55353292", "Alfenas\ \-\ MG",
"55123004", "São\ José\ dos\ Campos\ \-\ SP",
"55663579", "Nova\ Ubiratã\ \-\ MT",
"55413375", "São\ José\ dos\ Pinhais\ \-\ PR",
"55823288", "Quebrangulo\ \-\ AL",
"55183704", "Pereira\ Barreto\ \-\ SP",
"55112319", "São\ Paulo\ \-\ SP",
"55163421", "Ribeirão\ Preto\ \-\ SP",
"55983363", "Morros\ \-\ MA",
"55373435", "Vargem\ Bonita\ \-\ MG",
"55753015", "Feira\ de\ Santana\ \-\ BA",
"55553256", "Manoel\ Viana\ \-\ RS",
"55553255", "Jaguari\ \-\ RS",
"55833629", "São\ Miguel\ de\ Taipu\ \-\ PB",
"55623561", "Caldazinha\ \-\ GO",
"55173445", "Américo\ de\ Campos\ \-\ SP",
"55714119", "Candeias\ \-\ BA",
"55114619", "Jandira\ \-\ SP",
"55673258", "Taunay\ \-\ MS",
"55643933", "Itumbiara\ \-\ GO",
"5511367", "São\ Paulo\ \-\ SP",
"5521310", "Rio\ de\ Janeiro\ \-\ RJ",
"55353443", "Jacutinga\ \-\ MG",
"55114206", "Jandira\ \-\ SP",
"55213620", "Niterói\ \-\ RJ",
"55463538", "Salto\ do\ Lontra\ \-\ PR",
"55663486", "Pedra\ Preta\ \-\ MT",
"55212630", "Magé\ \-\ RJ",
"55183287", "Campinal\ \-\ SP",
"55114205", "Itapevi\ \-\ SP",
"55513375", "Rio\ Grande\ do\ Sul",
"55863292", "Amarante\ \-\ PI",
"55223864", "Aperibé\ \-\ RJ",
"55353064", "Poços\ de\ Caldas\ \-\ MG",
"55114701", "Taboão\ da\ Serra\ \-\ SP",
"55513684", "Tramandaí\ \-\ RS",
"55243381", "Resende\ \-\ RJ",
"55833466", "Assunção\ \-\ PB",
"55483441", "Urussanga\ \-\ SC",
"55643581", "Itumbiara\ \-\ GO",
"55553542", "Tucunduva\ \-\ RS",
"55733221", "Ilhéus\ \-\ BA",
"55123676", "Redenção\ da\ Serra\ \-\ SP",
"55444007", "Maringá\ \-\ PR",
"55913767", "São\ Caetano\ de\ Odivelas\ \-\ PA",
"55843614", "Natal\ \-\ RN",
"55114667", "Itapecerica\ da\ Serra\ \-\ SP",
"55553751", "Dois\ Irmãos\ das\ MissõEs\ \-\ RS",
"55863277", "Capitão\ de\ Campos\ \-\ PI",
"55112518", "São\ Paulo\ \-\ SP",
"55513411", "Alvorada\ \-\ RS",
"55793455", "São\ Domingos\ \-\ SE",
"55513488", "Gravataí\ \-\ RS",
"55613303", "Brasília\ \-\ DF",
"55433559", "Joaquim\ Távora\ \-\ PR",
"55813046", "Caruaru\ \-\ PE",
"55933064", "Santarém\ \-\ PA",
"55473536", "Petrolândia\ \-\ SC",
"55673488", "Aral\ Moreira\ \-\ MS",
"55113409", "Suzano\ \-\ SP",
"55983264", "São\ Luís\ \-\ MA",
"55622764", "Goiânia\ \-\ GO",
"55853048", "Fortaleza\ \-\ CE",
"55673411", "Dourados\ \-\ MS",
"55623380", "Araguapaz\ \-\ GO",
"55923367", "Iranduba\ \-\ AM",
"55223832", "Rosal\ \-\ RJ",
"55473535", "Atalanta\ \-\ SC",
"55414062", "Curitiba\ \-\ PR",
"55273287", "Fundão\ \-\ ES",
"55843338", "Carnaubais\ \-\ RN",
"55113192", "São\ Paulo\ \-\ SP",
"55743659", "Várzea\ Nova\ \-\ BA",
"55313389", "Belo\ Horizonte\ \-\ MG",
"55913444", "Mãe\ do\ Rio\ \-\ PA",
"55453543", "Vila\ Ipiranga\ \-\ PR",
"55973451", "Boca\ do\ Acre\ \-\ AM",
"55813198", "Recife\ \-\ PE",
"55193927", "Piracicaba\ \-\ SP",
"55273724", "Marilândia\ \-\ ES",
"55623359", "Jesúpolis\ \-\ GO",
"55313029", "Belo\ Horizonte\ \-\ MG",
"55143332", "Santa\ Cruz\ do\ Rio\ Pardo\ \-\ SP",
"55653339", "Tangará\ da\ Serra\ \-\ MT",
"55383541", "Serro\ \-\ MG",
"55123631", "Taubaté\ \-\ SP",
"55353293", "Areado\ \-\ MG",
"5584", "Rio\ Grande\ do\ Norte",
"55193821", "Elias\ Fausto\ \-\ SP",
"55213761", "Nilópolis\ \-\ RJ",
"55173295", "Monte\ Aprazível\ \-\ SP",
"55323052", "Barbacena\ \-\ MG",
"55843251", "São\ Paulo\ do\ Potengi\ \-\ RN",
"55773412", "Iramaia\ \-\ BA",
"5511597", "São\ Paulo\ \-\ SP",
"55533275", "Capão\ do\ Leão\ \-\ RS",
"55663542", "Rondolândia\ \-\ MT",
"55143263", "Lençóis\ Paulista\ \-\ SP",
"55153313", "Sorocaba\ \-\ SP",
"55443674", "Indianópolis\ \-\ PR",
"55713677", "Mata\ de\ São\ João\ \-\ BA",
"55193324", "Campinas\ \-\ SP",
"55113177", "São\ Paulo\ \-\ SP",
"55543478", "Vista\ Alegre\ do\ Prata\ \-\ RS",
"55863293", "Regeneração\ \-\ PI",
"55813471", "Recife\ \-\ PE",
"55353100", "Extrema\ \-\ MG",
"55317", "Minas\ Gerais",
"55453378", "Toledo\ \-\ PR",
"55193566", "Analândia\ \-\ SP",
"55733248", "Itapé\ \-\ BA",
"55443901", "Maringá\ \-\ PR",
"55942103", "Marabá\ \-\ PA",
"55732105", "Porto\ Seguro\ \-\ BA",
"55193565", "Pirassununga\ \-\ SP",
"55353442", "Bueno\ Brandão\ \-\ MG",
"55643932", "Itumbiara\ \-\ GO",
"55433276", "Arapongas\ \-\ PR",
"55483624", "Jaguaruna\ \-\ SC",
"55242291", "Petrópolis\ \-\ RJ",
"55113429", "São\ Paulo\ \-\ SP",
"55773262", "Itapetinga\ \-\ BA",
"55423524", "União\ da\ Vitória\ \-\ PR",
"55983362", "Icatu\ \-\ MA",
"55753345", "Nova\ Redenção\ \-\ BA",
"55313511", "Betim\ \-\ MG",
"55143413", "Marília\ \-\ SP",
"55433275", "Arapongas\ \-\ PR",
"55613302", "Sobradinho\ \-\ DF",
"55634001", "Palmas\ \-\ TO",
"55692183", "Ji\-Paraná\ \-\ RO",
"55883554", "Barro\ \-\ CE",
"55423271", "Telêmaco\ Borba\ \-\ PR",
"55543385", "Tapera\ \-\ RS",
"55813316", "Recife\ \-\ PE",
"55212637", "Maricá\ \-\ RJ",
"55543386", "Muliterno\ \-\ RS",
"55193304", "Campinas\ \-\ SP",
"55623558", "Goiânia\ \-\ GO",
"55673261", "Bandeirantes\ \-\ MS",
"55353737", "São\ Pedro\ de\ Caldas\ \-\ MG",
"55114131", "Pirapora\ do\ Bom\ Jesus\ \-\ SP",
"55182104", "Presidente\ Prudente\ \-\ SP",
"55483877", "Florianópolis\ \-\ SC",
"55514062", "Porto\ Alegre\ \-\ RS",
"55283036", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55923581", "Manaus\ \-\ AM",
"55519", "Rio\ Grande\ do\ Sul",
"55193907", "Amparo\ \-\ SP",
"55553543", "Tuparendi\ \-\ RS",
"55193801", "Indaiatuba\ \-\ SP",
"55114534", "Itatiba\ \-\ SP",
"55343244", "Uberlândia\ \-\ MG",
"55983681", "Santa\ Inês\ \-\ MA",
"55923184", "Manaus\ \-\ AM",
"55823289", "Santana\ do\ Mundaú\ \-\ AL",
"55633365", "Fátima\ \-\ TO",
"55473627", "Canoinhas\ \-\ SC",
"55112318", "São\ Paulo\ \-\ SP",
"55213303", "Duque\ de\ Caxias\ \-\ RJ",
"55373423", "Tapiraí\ \-\ MG",
"55543032", "Flores\ da\ Cunha\ \-\ RS",
"55993572", "Buriti\ Bravo\ \-\ MA",
"55943358", "Canaã\ dos\ Carajás\ \-\ PA",
"55633366", "Miracema\ do\ Tocantins\ \-\ TO",
"55743661", "Xique\-Xique\ \-\ BA",
"55613503", "Planaltina\ \-\ GO",
"55663578", "Itanhangá\ \-\ MT",
"55114264", "Francisco\ Morato\ \-\ SP",
"55323465", "Pirapetinga\ \-\ MG",
"55623995", "Goiânia\ \-\ GO",
"55543293", "Antônio\ Prado\ \-\ RS",
"55443442", "Guairaçá\ \-\ PR",
"55183376", "Cruzália\ \-\ SP",
"55183862", "Pacaembu\ \-\ SP",
"55473416", "Joinville\ \-\ SC",
"55112884", "Mogi\ das\ Cruzes\ \-\ SP",
"55653268", "Vale\ de\ São\ Domingos\ \-\ MT",
"55213780", "Duque\ de\ Caxias\ \-\ RJ",
"55433020", "Rolândia\ \-\ PR",
"5546", "Paraná",
"55183375", "Pedrinhas\ Paulista\ \-\ SP",
"55323466", "Além\ Paraíba\ \-\ MG",
"55273331", "Vitória\ \-\ ES",
"55613620", "Luziânia\ \-\ GO",
"55222103", "Nova\ Friburgo\ \-\ RJ",
"55163943", "Barrinha\ \-\ SP",
"55143305", "Piraju\ \-\ SP",
"55453244", "Missal\ \-\ PR",
"55163472", "Araraquara\ \-\ SP",
"55673457", "Itaporã\ \-\ MS",
"55193873", "Sumaré\ \-\ SP",
"55112662", "São\ Paulo\ \-\ SP",
"55843269", "Riachuelo\ \-\ RN",
"55513724", "Cachoeira\ do\ Sul\ \-\ RS",
"55513575", "São\ Leopoldo\ \-\ RS",
"55483903", "Araranguá\ \-\ SC",
"55114772", "Jandira\ \-\ SP",
"55222732", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55853319", "Chorozinho\ \-\ CE",
"55864020", "Teresina\ \-\ PI",
"55163979", "Ribeirão\ Preto\ \-\ SP",
"55473371", "Jaraguá\ do\ Sul\ \-\ SC",
"55863385", "São\ João\ do\ Arraial\ \-\ PI",
"55643662", "Palestina\ de\ Goiás\ \-\ GO",
"55623091", "Goiânia\ \-\ GO",
"55193849", "Valinhos\ \-\ SP",
"55973417", "Atalaia\ do\ Norte\ \-\ AM",
"55623361", "Itapaci\ \-\ GO",
"55923663", "Manaus\ \-\ AM",
"5531346", "Minas\ Gerais",
"55273258", "João\ Neiva\ \-\ ES",
"5512393", "São\ José\ dos\ Campos\ \-\ SP",
"55433132", "Cornélio\ Procópio\ \-\ PR",
"55513489", "Gravataí\ \-\ RS",
"55113441", "São\ Paulo\ \-\ SP",
"55114233", "São\ Caetano\ do\ Sul\ \-\ SP",
"5522252", "Nova\ Friburgo\ \-\ RJ",
"55623587", "Aparecida\ de\ Goiânia\ \-\ GO",
"55553244", "Santana\ do\ Livramento\ \-\ RS",
"55123867", "Maresias\ \-\ SP",
"55433558", "Santo\ Antônio\ da\ Platina\ \-\ PR",
"55413576", "Curitiba\ \-\ PR",
"55143533", "Lins\ \-\ SP",
"55413575", "Curitiba\ \-\ PR",
"55313431", "Belo\ Horizonte\ \-\ MG",
"55133507", "Mongaguá\ \-\ SP",
"55493453", "Peritiba\ \-\ SC",
"55424001", "Ponta\ Grossa\ \-\ PR",
"55323711", "Vermelho\ \-\ MG",
"55123961", "Jacareí\ \-\ SP",
"55643519", "Itumbiara\ \-\ GO",
"55513696", "Barão\ \-\ RS",
"55873945", "Serra\ Talhada\ \-\ PE",
"55115904", "São\ Paulo\ \-\ SP",
"55183261", "Ribeirão\ dos\ Índios\ \-\ SP",
"55513982", "Lajeado\ \-\ RS",
"55913286", "Ananindeua\ \-\ PA",
"5531321", "Belo\ Horizonte\ \-\ MG",
"55654052", "Cuiabá\ \-\ MT",
"55733297", "Caravelas\ \-\ BA",
"55473522", "Rio\ do\ Sul\ \-\ SC",
"55114092", "Diadema\ \-\ SP",
"55133391", "Guarujá\ \-\ SP",
"55873946", "Salgueiro\ \-\ PE",
"55242220", "Petrópolis\ \-\ RJ",
"55513695", "Harmonia\ \-\ RS",
"55613335", "São\ Sebastião\ \-\ DF",
"55693623", "Seringueiras\ \-\ RO",
"55993321", "Imperatriz\ \-\ MA",
"55913781", "Cametá\ \-\ PA",
"55432102", "Apucarana\ \-\ PR",
"55663494", "São\ José\ do\ Povo\ \-\ MT",
"55833424", "Salgadinho\ \-\ PB",
"55793648", "Pedrinhas\ \-\ SE",
"55212774", "São\ João\ de\ Meriti\ \-\ RJ",
"55463539", "Doutor\ Antônio\ Paranhos\ \-\ PR",
"55613336", "Taguatinga\ \-\ DF",
"55513450", "Rio\ Grande\ do\ Sul",
"55643567", "Itumbiara\ \-\ GO",
"55733272", "Ibicuí\ \-\ BA",
"55493675", "Riqueza\ \-\ SC",
"55143325", "Ourinhos\ \-\ SP",
"55633524", "Porto\ Alegre\ do\ Tocantins\ \-\ TO",
"55222123", "Macaé\ \-\ RJ",
"55114618", "Jandira\ \-\ SP",
"55114681", "Juquitiba\ \-\ SP",
"55513704", "Monte\ Alverne\ \-\ RS",
"55313557", "Mariana\ \-\ MG",
"55143326", "Ourinhos\ \-\ SP",
"55443270", "Uniflor\ \-\ PR",
"55753252", "Ruy\ Barbosa\ \-\ BA",
"55623683", "Santa\ Bárbara\ de\ Goiás\ \-\ GO",
"55613415", "Brasília\ \-\ DF",
"55923318", "Nova\ Olinda\ do\ Norte\ \-\ AM",
"55553343", "Cruz\ Alta\ \-\ RS",
"55443443", "Santo\ Antônio\ do\ Caiuá\ \-\ PR",
"55543292", "Flores\ da\ Cunha\ \-\ RS",
"55173284", "Ribeiro\ dos\ Santos\ \-\ SP",
"55413134", "São\ José\ dos\ Pinhais\ \-\ PR",
"55823257", "Campestre\ \-\ AL",
"55613502", "Luziânia\ \-\ GO",
"55213224", "Rio\ de\ Janeiro\ \-\ RJ",
"55543033", "Nova\ Petrópolis\ \-\ RS",
"55913456", "Benfica\ \-\ PA",
"55623358", "Santa\ Isabel\ \-\ GO",
"55273261", "Guarapari\ \-\ ES",
"55553379", "Condor\ \-\ RS",
"55613627", "Valparaíso\ de\ Goiás\ \-\ GO",
"55653338", "Gleba\ Ranchão\ \-\ MT",
"55193897", "Hortolândia\ \-\ SP",
"55433133", "Cornélio\ Procópio\ \-\ PR",
"5565", "Mato\ Grosso",
"55313388", "Belo\ Horizonte\ \-\ MG",
"55213787", "Seropédica\ \-\ RJ",
"55273765", "Pinheiros\ \-\ ES",
"55713501", "Salvador\ \-\ BA",
"55643663", "Caiapônia\ \-\ GO",
"55743658", "Canarana\ \-\ BA",
"55753545", "Milagres\ \-\ BA",
"55222733", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55114773", "Itapevi\ \-\ SP",
"55483902", "Criciúma\ \-\ SC",
"55512104", "Porto\ Alegre\ \-\ RS",
"55112663", "São\ Paulo\ \-\ SP",
"55193366", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55193872", "Cosmópolis\ \-\ SP",
"55413457", "Pontal\ do\ Paraná\ \-\ PR",
"55893427", "Tanque\ do\ Piauí\ \-\ PI",
"55113408", "Itatiba\ \-\ SP",
"55653251", "São\ José\ dos\ Quatro\ Marcos\ \-\ MT",
"55673489", "Indápolis\ \-\ MS",
"55163942", "Sertãozinho\ \-\ SP",
"55222102", "Nova\ Friburgo\ \-\ RJ",
"55923021", "Manaus\ \-\ AM",
"55223723", "Macaé\ \-\ RJ",
"55493631", "São\ Miguel\ do\ Oeste\ \-\ SC",
"55533027", "Pelotas\ \-\ RS",
"55373402", "Itaúna\ \-\ MG",
"55443277", "Corumbataí\ do\ Sul\ \-\ PR",
"55473523", "Lontras\ \-\ SC",
"55114093", "Diadema\ \-\ SP",
"55613522", "Brasília\ \-\ DF",
"55313550", "Minas\ Gerais",
"55532123", "Pelotas\ \-\ RS",
"55513983", "Venâncio\ Aires\ \-\ RS",
"55613607", "Distrito\ de\ Campos\ Lindos\ \-\ GO",
"55222030", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55193775", "Campinas\ \-\ SP",
"55143880", "Botucatu\ \-\ SP",
"55643560", "São\ João\ da\ Paraúna\ \-\ GO",
"55513457", "Rio\ Grande\ do\ Sul",
"55493452", "Seara\ \-\ SC",
"55143532", "Lins\ \-\ SP",
"55543394", "Santo\ Antônio\ do\ Palma\ \-\ RS",
"55213691", "Japeri\ \-\ RJ",
"55833641", "Riacho\ de\ Santo\ Antônio\ \-\ PB",
"55115635", "São\ Paulo\ \-\ SP",
"55883546", "Nova\ Olinda\ \-\ CE",
"55423907", "Irati\ \-\ PR",
"55843538", "Fernando\ Pedroza\ \-\ RN",
"55963424", "Pracuúba\ \-\ AP",
"55673287", "Porto\ Murtinho\ \-\ MS",
"55823645", "Inhapi\ \-\ AL",
"55433561", "Conselheiro\ Mairinck\ \-\ PR",
"55733290", "Ibirapuã\ \-\ BA",
"55643634", "Chapadão\ do\ Céu\ \-\ GO",
"55823646", "Canapi\ \-\ AL",
"55313589", "Nova\ Lima\ \-\ MG",
"55543443", "Guaporé\ \-\ RS",
"55513134", "São\ Leopoldo\ \-\ RS",
"55883545", "Santana\ do\ Cariri\ \-\ CE",
"55733273", "Pau\ Brasil\ \-\ BA",
"55473336", "Blumenau\ \-\ SC",
"55793377", "Ilha\ das\ Flores\ \-\ SE",
"55133500", "Santos\ \-\ SP",
"5541356", "Curitiba\ \-\ PR",
"55432103", "Londrina\ \-\ PR",
"55173661", "Rubinéia\ \-\ SP",
"55124104", "Taubaté\ \-\ SP",
"55483207", "Florianópolis\ \-\ SC",
"55643438", "Domiciano\ Ribeiro\ \-\ GO",
"55733249", "Barro\ Preto\ \-\ BA",
"55423304", "Guarapuava\ \-\ PR",
"55453379", "Toledo\ \-\ PR",
"55713521", "Salvador\ \-\ BA",
"55222764", "Rio\ das\ Ostras\ \-\ RJ",
"55343256", "Uberlândia\ \-\ MG",};
$areanames{pt} = {"5561", "Distrito\ Federal",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+55|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      my $prefix = qr/^(?:(?:0|90)(?:(1[245]|2[1-35]|31|4[13]|[56]5|99)(\d{10,11}))?)/;
      my @matches = $number =~ /$prefix/;
      if (defined $matches[-1]) {
        no warnings 'uninitialized';
        $number =~ s/$prefix/$2/;
      }
      else {
        $number =~ s/$prefix//;
      }
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;