# This Makefile.PL for Image-Leptonica was generated by
# inc::LeptonicaMakeMaker <self>
# and Dist::Zilla::Plugin::MakeMaker::Awesome 0.20.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;



use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "bindings to the Leptonica image processing library",
  "AUTHOR" => "Zakariyya Mughal <zmughal\@cpan.org>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "Alien::Leptonica" => 0,
    "ExtUtils::MakeMaker" => "6.30",
    "Inline::MakeMaker" => "0.45"
  },
  "DISTNAME" => "Image-Leptonica",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "Image::Leptonica",
  "PREREQ_PM" => {
    "Alien::Leptonica" => 0,
    "ExtUtils::Depends" => 0,
    "ExtUtils::MakeMaker" => "6.52",
    "File::Spec::Functions" => 0,
    "Inline" => 0,
    "Inline::MakeMaker" => "0.45",
    "Path::Class" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "Module::Load" => 0,
    "Test::More" => 0
  },
  "VERSION" => "0.02",
  "test" => {
    "TESTS" => "t/*.t"
  }
);
use Inline::MakeMaker;
use ExtUtils::Depends;
use File::Spec::Functions;
use File::Path qw(make_path);
use File::Copy;
$WriteMakefileArgs{CONFIGURE} = sub {
	require Alien::Leptonica;
	my $l = Alien::Leptonica->new;
	my $pkg = ExtUtils::Depends->new('Image::Leptonica',);
	$pkg->set_inc( $l->cflags );
	$pkg->set_libs( $l->libs );
	$pkg->add_typemaps( 'typemap' );

	# make path to install to
	my @dir = qw( lib Image Leptonica Install );
	make_path catfile @dir;
	# copy typemap into that path
	copy( 'typemap', catfile( @dir, 'typemap') );
	# save config to that path
	$pkg->save_config( catfile( @dir, 'Files.pm' ) );

	+{ CCFLAGS => $l->cflags,
	   LIBS => $l->libs,
	   $pkg->get_makefile_vars()  };
};


my %FallbackPrereqs = (
  "Alien::Leptonica" => 0,
  "ExtUtils::Depends" => 0,
  "ExtUtils::MakeMaker" => "6.52",
  "File::Spec::Functions" => 0,
  "Inline" => 0,
  "Inline::MakeMaker" => "0.45",
  "Module::Load" => 0,
  "Path::Class" => 0,
  "Test::More" => 0,
  "strict" => 0,
  "warnings" => 0
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



