use strict;
use Panda::Install;

write_makefile(
    NAME          => 'Panda::Lib',
    PREREQ_PM     => {'Panda::XS' => '1.1.1', 'Panda::Export' => 0, 'Time::HiRes' => 0},
    TEST_REQUIRES => {'Test::Fatal' => 0, 'JSON::XS' => 0},
    CPLUS         => 1,
    DEFINE        => $ENV{TEST_FULL} ? '-DTEST_FULL' : '',
    SRC           => 'src',
    INC           => '-Isrc',
    LIBS          => ($^O eq 'MSWin32') ? '' : '-lpthread',
    BIN_DEPS      => 'Panda::XS',
    BIN_SHARE     => {
        INCLUDE  => {'src' => '/'},
        TYPEMAPS => {'typemap' => ''},
    },
    #OPTIMIZE  => '-g -O2',
    #CC => 'clang++',
    #CCFLAGS => '-std=c++11',
);
